/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.formats;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.hl7.fhir.instance.formats.JsonParser;
import org.hl7.fhir.instance.formats.Parser;
import org.hl7.fhir.instance.formats.ParserBase;
import org.hl7.fhir.instance.formats.ResourceOrFeed;
import org.hl7.fhir.instance.model.AtomCategory;
import org.hl7.fhir.instance.model.AtomEntry;
import org.hl7.fhir.instance.model.AtomFeed;
import org.hl7.fhir.instance.model.Binary;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public abstract class JsonParserBase
extends ParserBase
implements Parser {
    private static com.google.gson.JsonParser parser = new com.google.gson.JsonParser();

    protected abstract Resource parseResource(JsonObject var1) throws Exception;

    private JsonObject loadJson(InputStream inputStream) throws Exception {
        return parser.parse(TextFile.streamToString(inputStream)).getAsJsonObject();
    }

    @Override
    public ResourceOrFeed parseGeneral(InputStream inputStream) throws Exception {
        JsonObject jsonObject = this.loadJson(inputStream);
        ResourceOrFeed resourceOrFeed = new ResourceOrFeed();
        String string = jsonObject.get("resourceType").getAsString();
        if ("Bundle".equals(string)) {
            resourceOrFeed.setFeed(this.parseAtom(jsonObject));
        } else {
            resourceOrFeed.setResource(this.parseResource(jsonObject));
        }
        return resourceOrFeed;
    }

    @Override
    public Resource parse(InputStream inputStream) throws Exception {
        JsonObject jsonObject = this.loadJson(inputStream);
        return this.parseResource(jsonObject);
    }

    public Resource parse(JsonObject jsonObject) throws Exception {
        return this.parseResource(jsonObject);
    }

    protected void parseElementProperties(JsonObject jsonObject, Element element) throws Exception {
        if (jsonObject != null && jsonObject.has("id")) {
            element.setXmlId(jsonObject.get("id").getAsString());
        }
        if (jsonObject != null && jsonObject.has("_id")) {
            element.setXmlId(jsonObject.get("_id").getAsString());
        }
        if (!Utilities.noString(element.getXmlId())) {
            this.idMap.put(element.getXmlId(), element);
        }
    }

    protected abstract void parseResourceProperties(JsonObject var1, Resource var2) throws Exception;

    protected XhtmlNode parseXhtml(String string) throws Exception {
        XhtmlParser xhtmlParser = new XhtmlParser();
        return xhtmlParser.parse(string, "div").getChildNodes().get(0);
    }

    protected Resource parseBinary(JsonObject jsonObject) throws Exception {
        Binary binary = new Binary();
        this.parseResourceProperties(jsonObject, binary);
        binary.setContentType(jsonObject.get("contentType").getAsString());
        binary.setContent(Base64.decodeBase64((byte[])jsonObject.get("content").getAsString().getBytes()));
        return binary;
    }

    private AtomFeed parseAtom(JsonObject jsonObject) throws Exception {
        int n;
        Object object;
        AtomFeed atomFeed = new AtomFeed();
        if (jsonObject.has("title") && !jsonObject.get("title").isJsonNull()) {
            atomFeed.setTitle(jsonObject.get("title").getAsString());
        }
        if (jsonObject.has("id") && !jsonObject.get("id").isJsonNull()) {
            atomFeed.setId(jsonObject.get("id").getAsString());
        }
        if (jsonObject.has("updated") && !jsonObject.get("updated").isJsonNull()) {
            atomFeed.setUpdated(new DateAndTime(jsonObject.get("updated").getAsString()));
        }
        if (jsonObject.has("author") && !jsonObject.get("author").isJsonNull()) {
            object = jsonObject.getAsJsonArray("author").get(0).getAsJsonObject();
            if (object.has("name")) {
                atomFeed.setAuthorName(object.get("name").getAsString());
            }
            if (object.has("uri")) {
                atomFeed.setAuthorUri(object.get("uri").getAsString());
            }
        }
        if (jsonObject.has("link") && !jsonObject.get("link").isJsonNull()) {
            object = jsonObject.getAsJsonArray("link");
            for (n = 0; n < object.size(); ++n) {
                this.parseLink(atomFeed.getLinks(), object.get(n).getAsJsonObject());
            }
        }
        if (jsonObject.has("category") && !jsonObject.get("category").isJsonNull()) {
            object = jsonObject.getAsJsonArray("category").iterator();
            while (object.hasNext()) {
                JsonElement jsonElement = (JsonElement)object.next();
                JsonObject jsonObject2 = jsonElement.getAsJsonObject();
                if (!jsonObject2.has("term") || !jsonObject2.has("scheme")) continue;
                atomFeed.getTags().add(new AtomCategory(jsonObject2.get("scheme").getAsString(), jsonObject2.get("term").getAsString(), jsonObject2.has("label") ? jsonObject2.get("label").getAsString() : null));
            }
        }
        if ((object = jsonObject.getAsJsonArray("entry")) != null) {
            for (n = 0; n < object.size(); ++n) {
                atomFeed.getEntryList().add(this.parseEntry(object.get(n).getAsJsonObject()));
            }
        }
        return atomFeed;
    }

    private void parseLink(Map<String, String> map, JsonObject jsonObject) throws Exception {
        if (jsonObject.has("href") && jsonObject.has("rel")) {
            map.put(jsonObject.get("rel").getAsString(), jsonObject.get("href").getAsString());
        }
    }

    private <T extends Resource> AtomEntry<T> parseEntry(JsonObject jsonObject) throws Exception {
        Object object;
        AtomEntry<Resource> atomEntry = new AtomEntry<Resource>();
        if (jsonObject.has("title") && !jsonObject.get("title").isJsonNull()) {
            atomEntry.setTitle(jsonObject.get("title").getAsString());
        }
        if (jsonObject.has("id") && !jsonObject.get("id").isJsonNull()) {
            atomEntry.setId(jsonObject.get("id").getAsString());
        }
        if (jsonObject.has("updated") && !jsonObject.get("updated").isJsonNull()) {
            atomEntry.setUpdated(new DateAndTime(jsonObject.get("updated").getAsString()));
        }
        if (jsonObject.has("published") && !jsonObject.get("published").isJsonNull()) {
            atomEntry.setPublished(new DateAndTime(jsonObject.get("published").getAsString()));
        }
        if (jsonObject.has("link") && !jsonObject.get("link").isJsonNull()) {
            object = jsonObject.getAsJsonArray("link");
            for (int i = 0; i < object.size(); ++i) {
                this.parseLink(atomEntry.getLinks(), object.get(i).getAsJsonObject());
            }
        }
        if (jsonObject.has("author") && !jsonObject.get("author").isJsonNull()) {
            object = jsonObject.getAsJsonArray("author").get(0).getAsJsonObject();
            if (object.has("name") && !object.get("name").isJsonNull()) {
                atomEntry.setAuthorName(object.get("name").getAsString());
            }
            if (object.has("uri") && !object.get("uri").isJsonNull()) {
                atomEntry.setAuthorUri(object.get("uri").getAsString());
            }
        }
        if (jsonObject.has("category") && !jsonObject.get("category").isJsonNull()) {
            for (JsonElement jsonElement : jsonObject.getAsJsonArray("category")) {
                JsonObject jsonObject2 = jsonElement.getAsJsonObject();
                if (!jsonObject2.has("term") || !jsonObject2.has("scheme") || jsonObject2.get("term").isJsonNull() || jsonObject2.get("scheme").isJsonNull()) continue;
                atomEntry.getTags().add(new AtomCategory(jsonObject2.get("scheme").getAsString(), jsonObject2.get("term").getAsString(), jsonObject2.has("label") ? jsonObject2.get("label").getAsString() : null));
            }
        }
        if (jsonObject.has("summary") && !jsonObject.get("summary").isJsonNull()) {
            atomEntry.setSummary(new XhtmlParser().parse(jsonObject.get("summary").getAsString(), "div").getChildNodes().get(0));
        }
        if (jsonObject.has("content") && !jsonObject.get("content").isJsonNull()) {
            atomEntry.setResource(new JsonParser().parse(jsonObject.getAsJsonObject("content")));
        }
        return atomEntry;
    }
}

