/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.formats;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.hl7.fhir.instance.formats.FormatUtilities;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.utilities.Utilities;

public abstract class ParserBase
extends FormatUtilities {
    protected Map<String, Object> idMap = new HashMap<String, Object>();

    protected int parseIntegerPrimitive(String string) {
        if (string.startsWith("+") && Utilities.IsInteger(string.substring(1))) {
            string = string.substring(1);
        }
        return Integer.parseInt(string);
    }

    protected int parseIntegerPrimitive(Long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(l + " cannot be cast to int without changing its value.");
        }
        return l.intValue();
    }

    protected DateAndTime parseDateTimePrimitive(String string) throws ParseException {
        return new DateAndTime(string);
    }

    protected String parseCodePrimitive(String string) {
        return string;
    }

    protected DateAndTime parseDatePrimitive(String string) throws ParseException {
        return new DateAndTime(string);
    }

    protected String parseTimePrimitive(String string) throws ParseException {
        return string;
    }

    protected BigDecimal parseDecimalPrimitive(BigDecimal bigDecimal) {
        return bigDecimal;
    }

    protected BigDecimal parseDecimalPrimitive(String string) {
        return new BigDecimal(string);
    }

    protected String parseUriPrimitive(String string) throws Exception {
        return string;
    }

    protected byte[] parseBase64BinaryPrimitive(String string) {
        return Base64.decodeBase64((byte[])string.getBytes());
    }

    protected String parseOidPrimitive(String string) {
        return string;
    }

    protected Boolean parseBooleanPrimitive(String string) {
        return Boolean.valueOf(string);
    }

    protected Boolean parseBooleanPrimitive(Boolean bl) {
        return (boolean)bl;
    }

    protected DateAndTime parseInstantPrimitive(String string) throws Exception {
        return new DateAndTime(string);
    }

    protected String parseIdPrimitive(String string) {
        return string;
    }

    protected String parseStringPrimitive(String string) {
        return string;
    }

    protected String parseUuidPrimitive(String string) {
        return string;
    }
}

