/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.formats;

import org.hl7.fhir.instance.formats.XmlComposerBase;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.AdverseReaction;
import org.hl7.fhir.instance.model.Age;
import org.hl7.fhir.instance.model.Alert;
import org.hl7.fhir.instance.model.AllergyIntolerance;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Base64BinaryType;
import org.hl7.fhir.instance.model.Binary;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CarePlan;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.Composition;
import org.hl7.fhir.instance.model.ConceptMap;
import org.hl7.fhir.instance.model.Condition;
import org.hl7.fhir.instance.model.Conformance;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.Count;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.DecimalType;
import org.hl7.fhir.instance.model.Device;
import org.hl7.fhir.instance.model.DeviceObservationReport;
import org.hl7.fhir.instance.model.DiagnosticOrder;
import org.hl7.fhir.instance.model.DiagnosticReport;
import org.hl7.fhir.instance.model.Distance;
import org.hl7.fhir.instance.model.DocumentManifest;
import org.hl7.fhir.instance.model.DocumentReference;
import org.hl7.fhir.instance.model.Duration;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.Encounter;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Extension;
import org.hl7.fhir.instance.model.FamilyHistory;
import org.hl7.fhir.instance.model.Group;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.ImagingStudy;
import org.hl7.fhir.instance.model.Immunization;
import org.hl7.fhir.instance.model.ImmunizationRecommendation;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.List_;
import org.hl7.fhir.instance.model.Location;
import org.hl7.fhir.instance.model.Media;
import org.hl7.fhir.instance.model.Medication;
import org.hl7.fhir.instance.model.MedicationAdministration;
import org.hl7.fhir.instance.model.MedicationDispense;
import org.hl7.fhir.instance.model.MedicationPrescription;
import org.hl7.fhir.instance.model.MedicationStatement;
import org.hl7.fhir.instance.model.MessageHeader;
import org.hl7.fhir.instance.model.Money;
import org.hl7.fhir.instance.model.Narrative;
import org.hl7.fhir.instance.model.Observation;
import org.hl7.fhir.instance.model.OidType;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.Order;
import org.hl7.fhir.instance.model.OrderResponse;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Other;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Procedure;
import org.hl7.fhir.instance.model.Profile;
import org.hl7.fhir.instance.model.Provenance;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Query;
import org.hl7.fhir.instance.model.Questionnaire;
import org.hl7.fhir.instance.model.Range;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.RelatedPerson;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.SampledData;
import org.hl7.fhir.instance.model.Schedule;
import org.hl7.fhir.instance.model.SecurityEvent;
import org.hl7.fhir.instance.model.Specimen;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Substance;
import org.hl7.fhir.instance.model.Supply;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.UuidType;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.utilities.Utilities;

public class XmlComposer
extends XmlComposerBase {
    private void composeElementElements(Element element) throws Exception {
        for (Extension extension : element.getExtensions()) {
            this.composeExtension("extension", extension);
        }
    }

    private void composeBackboneElements(BackboneElement backboneElement) throws Exception {
        this.composeElementElements(backboneElement);
        for (Extension extension : backboneElement.getModifierExtensions()) {
            this.composeExtension("modifierExtension", extension);
        }
    }

    private <E extends Enum<E>> void composeEnumeration(String string, Enumeration<E> enumeration, EnumFactory enumFactory) throws Exception {
        if (enumeration != null && (!Utilities.noString(enumeration.getXmlId()) || enumeration.hasExtensions() || enumeration.getValue() != null)) {
            this.composeElementAttributes(enumeration);
            if (enumeration.getValue() != null) {
                this.xml.attribute("value", enumFactory.toCode((Enum<?>)enumeration.getValue()));
            }
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(enumeration);
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeId(String string, IdType idType) throws Exception {
        if (!(idType == null || Utilities.noString(idType.getXmlId()) && !idType.hasExtensions() && Utilities.noString(idType.getValue()))) {
            this.composeElementAttributes(idType);
            if (idType.getValue() != null) {
                this.xml.attribute("value", this.toString(idType.getValue()));
            }
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(idType);
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeBase64Binary(String string, Base64BinaryType base64BinaryType) throws Exception {
        if (base64BinaryType != null && (!Utilities.noString(base64BinaryType.getXmlId()) || base64BinaryType.hasExtensions() || base64BinaryType.getValue() != null)) {
            this.composeElementAttributes(base64BinaryType);
            if (base64BinaryType.getValue() != null) {
                this.xml.attribute("value", XmlComposer.toString(base64BinaryType.getValue()));
            }
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(base64BinaryType);
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDateTime(String string, DateTimeType dateTimeType) throws Exception {
        if (dateTimeType != null && (!Utilities.noString(dateTimeType.getXmlId()) || dateTimeType.hasExtensions() || dateTimeType.getValue() != null)) {
            this.composeElementAttributes(dateTimeType);
            if (dateTimeType.getValue() != null) {
                this.xml.attribute("value", this.toString(dateTimeType.getValue()));
            }
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(dateTimeType);
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeInteger(String string, IntegerType integerType) throws Exception {
        if (integerType != null) {
            this.composeElementAttributes(integerType);
            this.xml.attribute("value", this.toString(integerType.getValue()));
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(integerType);
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeOid(String string, OidType oidType) throws Exception {
        if (!(oidType == null || Utilities.noString(oidType.getXmlId()) && !oidType.hasExtensions() && Utilities.noString(oidType.getValue()))) {
            this.composeElementAttributes(oidType);
            if (oidType.getValue() != null) {
                this.xml.attribute("value", this.toString(oidType.getValue()));
            }
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(oidType);
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeString(String string, StringType stringType) throws Exception {
        if (!(stringType == null || Utilities.noString(stringType.getXmlId()) && !stringType.hasExtensions() && Utilities.noString(stringType.getValue()))) {
            this.composeElementAttributes(stringType);
            if (stringType.getValue() != null) {
                this.xml.attribute("value", this.toString(stringType.getValue()));
            }
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(stringType);
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeBoolean(String string, BooleanType booleanType) throws Exception {
        if (booleanType != null) {
            this.composeElementAttributes(booleanType);
            this.xml.attribute("value", this.toString(booleanType.getValue()));
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(booleanType);
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeUuid(String string, UuidType uuidType) throws Exception {
        if (!(uuidType == null || Utilities.noString(uuidType.getXmlId()) && !uuidType.hasExtensions() && Utilities.noString(uuidType.getValue()))) {
            this.composeElementAttributes(uuidType);
            if (uuidType.getValue() != null) {
                this.xml.attribute("value", this.toString(uuidType.getValue()));
            }
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(uuidType);
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeCode(String string, CodeType codeType) throws Exception {
        if (!(codeType == null || Utilities.noString(codeType.getXmlId()) && !codeType.hasExtensions() && Utilities.noString(codeType.getValue()))) {
            this.composeElementAttributes(codeType);
            if (codeType.getValue() != null) {
                this.xml.attribute("value", this.toString(codeType.getValue()));
            }
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(codeType);
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDate(String string, DateType dateType) throws Exception {
        if (dateType != null && (!Utilities.noString(dateType.getXmlId()) || dateType.hasExtensions() || dateType.getValue() != null)) {
            this.composeElementAttributes(dateType);
            if (dateType.getValue() != null) {
                this.xml.attribute("value", this.toString(dateType.getValue()));
            }
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(dateType);
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeUri(String string, UriType uriType) throws Exception {
        if (uriType != null && (!Utilities.noString(uriType.getXmlId()) || uriType.hasExtensions() || uriType.getValue() != null)) {
            this.composeElementAttributes(uriType);
            if (uriType.getValue() != null) {
                this.xml.attribute("value", this.toString(uriType.getValue()));
            }
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(uriType);
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeInstant(String string, InstantType instantType) throws Exception {
        if (instantType != null && (!Utilities.noString(instantType.getXmlId()) || instantType.hasExtensions() || instantType.getValue() != null)) {
            this.composeElementAttributes(instantType);
            if (instantType.getValue() != null) {
                this.xml.attribute("value", this.toString(instantType.getValue()));
            }
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(instantType);
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDecimal(String string, DecimalType decimalType) throws Exception {
        if (decimalType != null && (!Utilities.noString(decimalType.getXmlId()) || decimalType.hasExtensions() || decimalType.getValue() != null)) {
            this.composeElementAttributes(decimalType);
            if (decimalType.getValue() != null) {
                this.xml.attribute("value", this.toString(decimalType.getValue()));
            }
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(decimalType);
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeExtension(String string, Extension extension) throws Exception {
        if (extension != null) {
            this.composeElementAttributes(extension);
            if (extension.getUrl() != null) {
                this.xml.attribute("url", extension.getUrl().getValue());
            }
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(extension);
            this.composeType("value", extension.getValue());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeNarrative(String string, Narrative narrative) throws Exception {
        if (narrative != null) {
            this.composeElementAttributes(narrative);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(narrative);
            if (narrative.getStatus() != null) {
                this.composeEnumeration("status", narrative.getStatus(), new Narrative.NarrativeStatusEnumFactory());
            }
            this.composeXhtml("div", narrative.getDiv());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composePeriod(String string, Period period) throws Exception {
        if (period != null) {
            this.composeTypeAttributes(period);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(period);
            this.composeDateTime("start", period.getStart());
            this.composeDateTime("end", period.getEnd());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeCoding(String string, Coding coding) throws Exception {
        if (coding != null) {
            this.composeTypeAttributes(coding);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(coding);
            this.composeUri("system", coding.getSystem());
            this.composeString("version", coding.getVersion());
            this.composeCode("code", coding.getCode());
            this.composeString("display", coding.getDisplay());
            this.composeBoolean("primary", coding.getPrimary());
            this.composeResourceReference("valueSet", coding.getValueSet());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeRange(String string, Range range) throws Exception {
        if (range != null) {
            this.composeTypeAttributes(range);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(range);
            this.composeQuantity("low", range.getLow());
            this.composeQuantity("high", range.getHigh());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeQuantity(String string, Quantity quantity) throws Exception {
        if (quantity != null) {
            this.composeTypeAttributes(quantity);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(quantity);
            this.composeDecimal("value", quantity.getValue());
            if (quantity.getComparator() != null) {
                this.composeEnumeration("comparator", quantity.getComparator(), new Quantity.QuantityComparatorEnumFactory());
            }
            this.composeString("units", quantity.getUnits());
            this.composeUri("system", quantity.getSystem());
            this.composeCode("code", quantity.getCode());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeAttachment(String string, Attachment attachment) throws Exception {
        if (attachment != null) {
            this.composeTypeAttributes(attachment);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(attachment);
            this.composeCode("contentType", attachment.getContentType());
            this.composeCode("language", attachment.getLanguage());
            this.composeBase64Binary("data", attachment.getData());
            this.composeUri("url", attachment.getUrl());
            this.composeInteger("size", attachment.getSize());
            this.composeBase64Binary("hash", attachment.getHash());
            this.composeString("title", attachment.getTitle());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeRatio(String string, Ratio ratio) throws Exception {
        if (ratio != null) {
            this.composeTypeAttributes(ratio);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(ratio);
            this.composeQuantity("numerator", ratio.getNumerator());
            this.composeQuantity("denominator", ratio.getDenominator());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSampledData(String string, SampledData sampledData) throws Exception {
        if (sampledData != null) {
            this.composeTypeAttributes(sampledData);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(sampledData);
            this.composeQuantity("origin", sampledData.getOrigin());
            this.composeDecimal("period", sampledData.getPeriod());
            this.composeDecimal("factor", sampledData.getFactor());
            this.composeDecimal("lowerLimit", sampledData.getLowerLimit());
            this.composeDecimal("upperLimit", sampledData.getUpperLimit());
            this.composeInteger("dimensions", sampledData.getDimensions());
            this.composeString("data", sampledData.getData());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeResourceReference(String string, ResourceReference resourceReference) throws Exception {
        if (resourceReference != null) {
            this.composeTypeAttributes(resourceReference);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(resourceReference);
            this.composeString("reference", resourceReference.getReference());
            this.composeString("display", resourceReference.getDisplay());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeCodeableConcept(String string, CodeableConcept codeableConcept) throws Exception {
        if (codeableConcept != null) {
            this.composeTypeAttributes(codeableConcept);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(codeableConcept);
            for (Coding coding : codeableConcept.getCoding()) {
                this.composeCoding("coding", coding);
            }
            this.composeString("text", codeableConcept.getText());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeIdentifier(String string, Identifier identifier) throws Exception {
        if (identifier != null) {
            this.composeTypeAttributes(identifier);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(identifier);
            if (identifier.getUse() != null) {
                this.composeEnumeration("use", identifier.getUse(), new Identifier.IdentifierUseEnumFactory());
            }
            this.composeString("label", identifier.getLabel());
            this.composeUri("system", identifier.getSystem());
            this.composeString("value", identifier.getValue());
            this.composePeriod("period", identifier.getPeriod());
            this.composeResourceReference("assigner", identifier.getAssigner());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeAge(String string, Age age) throws Exception {
        if (age != null) {
            this.composeTypeAttributes(age);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(age);
            this.composeDecimal("value", age.getValue());
            if (age.getComparator() != null) {
                this.composeEnumeration("comparator", age.getComparator(), new Quantity.QuantityComparatorEnumFactory());
            }
            this.composeString("units", age.getUnits());
            this.composeUri("system", age.getSystem());
            this.composeCode("code", age.getCode());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeCount(String string, Count count) throws Exception {
        if (count != null) {
            this.composeTypeAttributes(count);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(count);
            this.composeDecimal("value", count.getValue());
            if (count.getComparator() != null) {
                this.composeEnumeration("comparator", count.getComparator(), new Quantity.QuantityComparatorEnumFactory());
            }
            this.composeString("units", count.getUnits());
            this.composeUri("system", count.getSystem());
            this.composeCode("code", count.getCode());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMoney(String string, Money money) throws Exception {
        if (money != null) {
            this.composeTypeAttributes(money);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(money);
            this.composeDecimal("value", money.getValue());
            if (money.getComparator() != null) {
                this.composeEnumeration("comparator", money.getComparator(), new Quantity.QuantityComparatorEnumFactory());
            }
            this.composeString("units", money.getUnits());
            this.composeUri("system", money.getSystem());
            this.composeCode("code", money.getCode());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDistance(String string, Distance distance) throws Exception {
        if (distance != null) {
            this.composeTypeAttributes(distance);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(distance);
            this.composeDecimal("value", distance.getValue());
            if (distance.getComparator() != null) {
                this.composeEnumeration("comparator", distance.getComparator(), new Quantity.QuantityComparatorEnumFactory());
            }
            this.composeString("units", distance.getUnits());
            this.composeUri("system", distance.getSystem());
            this.composeCode("code", distance.getCode());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDuration(String string, Duration duration) throws Exception {
        if (duration != null) {
            this.composeTypeAttributes(duration);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(duration);
            this.composeDecimal("value", duration.getValue());
            if (duration.getComparator() != null) {
                this.composeEnumeration("comparator", duration.getComparator(), new Quantity.QuantityComparatorEnumFactory());
            }
            this.composeString("units", duration.getUnits());
            this.composeUri("system", duration.getSystem());
            this.composeCode("code", duration.getCode());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSchedule(String string, Schedule schedule) throws Exception {
        if (schedule != null) {
            this.composeElementAttributes(schedule);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(schedule);
            for (Period period : schedule.getEvent()) {
                this.composePeriod("event", period);
            }
            this.composeScheduleScheduleRepeatComponent("repeat", schedule.getRepeat());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeScheduleScheduleRepeatComponent(String string, Schedule.ScheduleRepeatComponent scheduleRepeatComponent) throws Exception {
        if (scheduleRepeatComponent != null) {
            this.composeElementAttributes(scheduleRepeatComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(scheduleRepeatComponent);
            this.composeInteger("frequency", scheduleRepeatComponent.getFrequency());
            if (scheduleRepeatComponent.getWhen() != null) {
                this.composeEnumeration("when", scheduleRepeatComponent.getWhen(), new Schedule.EventTimingEnumFactory());
            }
            this.composeDecimal("duration", scheduleRepeatComponent.getDuration());
            if (scheduleRepeatComponent.getUnits() != null) {
                this.composeEnumeration("units", scheduleRepeatComponent.getUnits(), new Schedule.UnitsOfTimeEnumFactory());
            }
            this.composeInteger("count", scheduleRepeatComponent.getCount());
            this.composeDateTime("end", scheduleRepeatComponent.getEnd());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeContact(String string, Contact contact) throws Exception {
        if (contact != null) {
            this.composeElementAttributes(contact);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(contact);
            if (contact.getSystem() != null) {
                this.composeEnumeration("system", contact.getSystem(), new Contact.ContactSystemEnumFactory());
            }
            this.composeString("value", contact.getValue());
            if (contact.getUse() != null) {
                this.composeEnumeration("use", contact.getUse(), new Contact.ContactUseEnumFactory());
            }
            this.composePeriod("period", contact.getPeriod());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeAddress(String string, Address address) throws Exception {
        if (address != null) {
            this.composeElementAttributes(address);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(address);
            if (address.getUse() != null) {
                this.composeEnumeration("use", address.getUse(), new Address.AddressUseEnumFactory());
            }
            this.composeString("text", address.getText());
            for (StringType stringType : address.getLine()) {
                this.composeString("line", stringType);
            }
            this.composeString("city", address.getCity());
            this.composeString("state", address.getState());
            this.composeString("zip", address.getZip());
            this.composeString("country", address.getCountry());
            this.composePeriod("period", address.getPeriod());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeHumanName(String string, HumanName humanName) throws Exception {
        if (humanName != null) {
            this.composeElementAttributes(humanName);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeElementElements(humanName);
            if (humanName.getUse() != null) {
                this.composeEnumeration("use", humanName.getUse(), new HumanName.NameUseEnumFactory());
            }
            this.composeString("text", humanName.getText());
            for (StringType stringType : humanName.getFamily()) {
                this.composeString("family", stringType);
            }
            for (StringType stringType : humanName.getGiven()) {
                this.composeString("given", stringType);
            }
            for (StringType stringType : humanName.getPrefix()) {
                this.composeString("prefix", stringType);
            }
            for (StringType stringType : humanName.getSuffix()) {
                this.composeString("suffix", stringType);
            }
            this.composePeriod("period", humanName.getPeriod());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeResourceAttributes(Resource resource) throws Exception {
        this.composeElementAttributes(resource);
    }

    private void composeResourceElements(Resource resource) throws Exception {
        this.composeBackboneElements(resource);
        this.composeCode("language", resource.getLanguage());
        this.composeNarrative("text", resource.getText());
        for (Resource resource2 : resource.getContained()) {
            if (resource2.getXmlId() == null) {
                throw new Exception("Contained Resource has no id - one must be assigned");
            }
            this.xml.open("http://hl7.org/fhir", "contained");
            this.composeResource(resource2);
            this.xml.close("http://hl7.org/fhir", "contained");
        }
    }

    private void composeAdverseReaction(String string, AdverseReaction adverseReaction) throws Exception {
        if (adverseReaction != null) {
            this.composeResourceAttributes(adverseReaction);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(adverseReaction);
            for (Identifier element : adverseReaction.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            this.composeDateTime("date", adverseReaction.getDate());
            this.composeResourceReference("subject", adverseReaction.getSubject());
            this.composeBoolean("didNotOccurFlag", adverseReaction.getDidNotOccurFlag());
            this.composeResourceReference("recorder", adverseReaction.getRecorder());
            for (AdverseReaction.AdverseReactionSymptomComponent adverseReactionSymptomComponent : adverseReaction.getSymptom()) {
                this.composeAdverseReactionAdverseReactionSymptomComponent("symptom", adverseReactionSymptomComponent);
            }
            for (AdverseReaction.AdverseReactionExposureComponent adverseReactionExposureComponent : adverseReaction.getExposure()) {
                this.composeAdverseReactionAdverseReactionExposureComponent("exposure", adverseReactionExposureComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeAdverseReactionAdverseReactionSymptomComponent(String string, AdverseReaction.AdverseReactionSymptomComponent adverseReactionSymptomComponent) throws Exception {
        if (adverseReactionSymptomComponent != null) {
            this.composeElementAttributes(adverseReactionSymptomComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(adverseReactionSymptomComponent);
            this.composeCodeableConcept("code", adverseReactionSymptomComponent.getCode());
            if (adverseReactionSymptomComponent.getSeverity() != null) {
                this.composeEnumeration("severity", adverseReactionSymptomComponent.getSeverity(), new AdverseReaction.ReactionSeverityEnumFactory());
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeAdverseReactionAdverseReactionExposureComponent(String string, AdverseReaction.AdverseReactionExposureComponent adverseReactionExposureComponent) throws Exception {
        if (adverseReactionExposureComponent != null) {
            this.composeElementAttributes(adverseReactionExposureComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(adverseReactionExposureComponent);
            this.composeDateTime("date", adverseReactionExposureComponent.getDate());
            if (adverseReactionExposureComponent.getType() != null) {
                this.composeEnumeration("type", adverseReactionExposureComponent.getType(), new AdverseReaction.ExposureTypeEnumFactory());
            }
            if (adverseReactionExposureComponent.getCausalityExpectation() != null) {
                this.composeEnumeration("causalityExpectation", adverseReactionExposureComponent.getCausalityExpectation(), new AdverseReaction.CausalityExpectationEnumFactory());
            }
            this.composeResourceReference("substance", adverseReactionExposureComponent.getSubstance());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeAlert(String string, Alert alert) throws Exception {
        if (alert != null) {
            this.composeResourceAttributes(alert);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(alert);
            for (Identifier identifier : alert.getIdentifier()) {
                this.composeIdentifier("identifier", identifier);
            }
            this.composeCodeableConcept("category", alert.getCategory());
            if (alert.getStatus() != null) {
                this.composeEnumeration("status", alert.getStatus(), new Alert.AlertStatusEnumFactory());
            }
            this.composeResourceReference("subject", alert.getSubject());
            this.composeResourceReference("author", alert.getAuthor());
            this.composeString("note", alert.getNote());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeAllergyIntolerance(String string, AllergyIntolerance allergyIntolerance) throws Exception {
        if (allergyIntolerance != null) {
            this.composeResourceAttributes(allergyIntolerance);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(allergyIntolerance);
            for (Identifier type : allergyIntolerance.getIdentifier()) {
                this.composeIdentifier("identifier", type);
            }
            if (allergyIntolerance.getCriticality() != null) {
                this.composeEnumeration("criticality", allergyIntolerance.getCriticality(), new AllergyIntolerance.CriticalityEnumFactory());
            }
            if (allergyIntolerance.getSensitivityType() != null) {
                this.composeEnumeration("sensitivityType", allergyIntolerance.getSensitivityType(), new AllergyIntolerance.SensitivitytypeEnumFactory());
            }
            this.composeDateTime("recordedDate", allergyIntolerance.getRecordedDate());
            if (allergyIntolerance.getStatus() != null) {
                this.composeEnumeration("status", allergyIntolerance.getStatus(), new AllergyIntolerance.SensitivitystatusEnumFactory());
            }
            this.composeResourceReference("subject", allergyIntolerance.getSubject());
            this.composeResourceReference("recorder", allergyIntolerance.getRecorder());
            this.composeResourceReference("substance", allergyIntolerance.getSubstance());
            for (ResourceReference resourceReference : allergyIntolerance.getReaction()) {
                this.composeResourceReference("reaction", resourceReference);
            }
            for (ResourceReference resourceReference : allergyIntolerance.getSensitivityTest()) {
                this.composeResourceReference("sensitivityTest", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeCarePlan(String string, CarePlan carePlan) throws Exception {
        if (carePlan != null) {
            this.composeResourceAttributes(carePlan);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(carePlan);
            for (Identifier element : carePlan.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            this.composeResourceReference("patient", carePlan.getPatient());
            if (carePlan.getStatus() != null) {
                this.composeEnumeration("status", carePlan.getStatus(), new CarePlan.CarePlanStatusEnumFactory());
            }
            this.composePeriod("period", carePlan.getPeriod());
            this.composeDateTime("modified", carePlan.getModified());
            for (ResourceReference resourceReference : carePlan.getConcern()) {
                this.composeResourceReference("concern", resourceReference);
            }
            for (CarePlan.CarePlanParticipantComponent carePlanParticipantComponent : carePlan.getParticipant()) {
                this.composeCarePlanCarePlanParticipantComponent("participant", carePlanParticipantComponent);
            }
            for (CarePlan.CarePlanGoalComponent carePlanGoalComponent : carePlan.getGoal()) {
                this.composeCarePlanCarePlanGoalComponent("goal", carePlanGoalComponent);
            }
            for (CarePlan.CarePlanActivityComponent carePlanActivityComponent : carePlan.getActivity()) {
                this.composeCarePlanCarePlanActivityComponent("activity", carePlanActivityComponent);
            }
            this.composeString("notes", carePlan.getNotes());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeCarePlanCarePlanParticipantComponent(String string, CarePlan.CarePlanParticipantComponent carePlanParticipantComponent) throws Exception {
        if (carePlanParticipantComponent != null) {
            this.composeElementAttributes(carePlanParticipantComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(carePlanParticipantComponent);
            this.composeCodeableConcept("role", carePlanParticipantComponent.getRole());
            this.composeResourceReference("member", carePlanParticipantComponent.getMember());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeCarePlanCarePlanGoalComponent(String string, CarePlan.CarePlanGoalComponent carePlanGoalComponent) throws Exception {
        if (carePlanGoalComponent != null) {
            this.composeElementAttributes(carePlanGoalComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(carePlanGoalComponent);
            this.composeString("description", carePlanGoalComponent.getDescription());
            if (carePlanGoalComponent.getStatus() != null) {
                this.composeEnumeration("status", carePlanGoalComponent.getStatus(), new CarePlan.CarePlanGoalStatusEnumFactory());
            }
            this.composeString("notes", carePlanGoalComponent.getNotes());
            for (ResourceReference resourceReference : carePlanGoalComponent.getConcern()) {
                this.composeResourceReference("concern", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeCarePlanCarePlanActivityComponent(String string, CarePlan.CarePlanActivityComponent carePlanActivityComponent) throws Exception {
        if (carePlanActivityComponent != null) {
            this.composeElementAttributes(carePlanActivityComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(carePlanActivityComponent);
            for (StringType type : carePlanActivityComponent.getGoal()) {
                this.composeString("goal", type);
            }
            if (carePlanActivityComponent.getStatus() != null) {
                this.composeEnumeration("status", carePlanActivityComponent.getStatus(), new CarePlan.CarePlanActivityStatusEnumFactory());
            }
            this.composeBoolean("prohibited", carePlanActivityComponent.getProhibited());
            for (ResourceReference resourceReference : carePlanActivityComponent.getActionResulting()) {
                this.composeResourceReference("actionResulting", resourceReference);
            }
            this.composeString("notes", carePlanActivityComponent.getNotes());
            this.composeResourceReference("detail", carePlanActivityComponent.getDetail());
            this.composeCarePlanCarePlanActivitySimpleComponent("simple", carePlanActivityComponent.getSimple());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeCarePlanCarePlanActivitySimpleComponent(String string, CarePlan.CarePlanActivitySimpleComponent carePlanActivitySimpleComponent) throws Exception {
        if (carePlanActivitySimpleComponent != null) {
            this.composeElementAttributes(carePlanActivitySimpleComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(carePlanActivitySimpleComponent);
            if (carePlanActivitySimpleComponent.getCategory() != null) {
                this.composeEnumeration("category", carePlanActivitySimpleComponent.getCategory(), new CarePlan.CarePlanActivityCategoryEnumFactory());
            }
            this.composeCodeableConcept("code", carePlanActivitySimpleComponent.getCode());
            this.composeType("timing", carePlanActivitySimpleComponent.getTiming());
            this.composeResourceReference("location", carePlanActivitySimpleComponent.getLocation());
            for (ResourceReference resourceReference : carePlanActivitySimpleComponent.getPerformer()) {
                this.composeResourceReference("performer", resourceReference);
            }
            this.composeResourceReference("product", carePlanActivitySimpleComponent.getProduct());
            this.composeQuantity("dailyAmount", carePlanActivitySimpleComponent.getDailyAmount());
            this.composeQuantity("quantity", carePlanActivitySimpleComponent.getQuantity());
            this.composeString("details", carePlanActivitySimpleComponent.getDetails());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeComposition(String string, Composition composition) throws Exception {
        if (composition != null) {
            this.composeResourceAttributes(composition);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(composition);
            this.composeIdentifier("identifier", composition.getIdentifier());
            this.composeDateTime("date", composition.getDate());
            this.composeCodeableConcept("type", composition.getType());
            this.composeCodeableConcept("class", composition.getClass_());
            this.composeString("title", composition.getTitle());
            if (composition.getStatus() != null) {
                this.composeEnumeration("status", composition.getStatus(), new Composition.CompositionStatusEnumFactory());
            }
            this.composeCoding("confidentiality", composition.getConfidentiality());
            this.composeResourceReference("subject", composition.getSubject());
            for (ResourceReference element : composition.getAuthor()) {
                this.composeResourceReference("author", element);
            }
            for (Composition.CompositionAttesterComponent compositionAttesterComponent : composition.getAttester()) {
                this.composeCompositionCompositionAttesterComponent("attester", compositionAttesterComponent);
            }
            this.composeResourceReference("custodian", composition.getCustodian());
            this.composeCompositionCompositionEventComponent("event", composition.getEvent());
            this.composeResourceReference("encounter", composition.getEncounter());
            for (Composition.SectionComponent sectionComponent : composition.getSection()) {
                this.composeCompositionSectionComponent("section", sectionComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeCompositionCompositionAttesterComponent(String string, Composition.CompositionAttesterComponent compositionAttesterComponent) throws Exception {
        if (compositionAttesterComponent != null) {
            this.composeElementAttributes(compositionAttesterComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(compositionAttesterComponent);
            for (Enumeration<Composition.CompositionAttestationMode> enumeration : compositionAttesterComponent.getMode()) {
                this.composeEnumeration("mode", enumeration, new Composition.CompositionAttestationModeEnumFactory());
            }
            this.composeDateTime("time", compositionAttesterComponent.getTime());
            this.composeResourceReference("party", compositionAttesterComponent.getParty());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeCompositionCompositionEventComponent(String string, Composition.CompositionEventComponent compositionEventComponent) throws Exception {
        if (compositionEventComponent != null) {
            this.composeElementAttributes(compositionEventComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(compositionEventComponent);
            for (CodeableConcept type : compositionEventComponent.getCode()) {
                this.composeCodeableConcept("code", type);
            }
            this.composePeriod("period", compositionEventComponent.getPeriod());
            for (ResourceReference resourceReference : compositionEventComponent.getDetail()) {
                this.composeResourceReference("detail", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeCompositionSectionComponent(String string, Composition.SectionComponent sectionComponent) throws Exception {
        if (sectionComponent != null) {
            this.composeElementAttributes(sectionComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(sectionComponent);
            this.composeString("title", sectionComponent.getTitle());
            this.composeCodeableConcept("code", sectionComponent.getCode());
            this.composeResourceReference("subject", sectionComponent.getSubject());
            this.composeResourceReference("content", sectionComponent.getContent());
            for (Composition.SectionComponent sectionComponent2 : sectionComponent.getSection()) {
                this.composeCompositionSectionComponent("section", sectionComponent2);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConceptMap(String string, ConceptMap conceptMap) throws Exception {
        if (conceptMap != null) {
            this.composeResourceAttributes(conceptMap);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(conceptMap);
            this.composeString("identifier", conceptMap.getIdentifier());
            this.composeString("version", conceptMap.getVersion());
            this.composeString("name", conceptMap.getName());
            this.composeString("publisher", conceptMap.getPublisher());
            for (Contact element : conceptMap.getTelecom()) {
                this.composeContact("telecom", element);
            }
            this.composeString("description", conceptMap.getDescription());
            this.composeString("copyright", conceptMap.getCopyright());
            if (conceptMap.getStatus() != null) {
                this.composeEnumeration("status", conceptMap.getStatus(), new ConceptMap.ValuesetStatusEnumFactory());
            }
            this.composeBoolean("experimental", conceptMap.getExperimental());
            this.composeDateTime("date", conceptMap.getDate());
            this.composeResourceReference("source", conceptMap.getSource());
            this.composeResourceReference("target", conceptMap.getTarget());
            for (ConceptMap.ConceptMapConceptComponent conceptMapConceptComponent : conceptMap.getConcept()) {
                this.composeConceptMapConceptMapConceptComponent("concept", conceptMapConceptComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConceptMapConceptMapConceptComponent(String string, ConceptMap.ConceptMapConceptComponent conceptMapConceptComponent) throws Exception {
        if (conceptMapConceptComponent != null) {
            this.composeElementAttributes(conceptMapConceptComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conceptMapConceptComponent);
            this.composeUri("system", conceptMapConceptComponent.getSystem());
            this.composeCode("code", conceptMapConceptComponent.getCode());
            for (ConceptMap.OtherConceptComponent backboneElement : conceptMapConceptComponent.getDependsOn()) {
                this.composeConceptMapOtherConceptComponent("dependsOn", backboneElement);
            }
            for (ConceptMap.ConceptMapConceptMapComponent conceptMapConceptMapComponent : conceptMapConceptComponent.getMap()) {
                this.composeConceptMapConceptMapConceptMapComponent("map", conceptMapConceptMapComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConceptMapOtherConceptComponent(String string, ConceptMap.OtherConceptComponent otherConceptComponent) throws Exception {
        if (otherConceptComponent != null) {
            this.composeElementAttributes(otherConceptComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(otherConceptComponent);
            this.composeUri("concept", otherConceptComponent.getConcept());
            this.composeUri("system", otherConceptComponent.getSystem());
            this.composeCode("code", otherConceptComponent.getCode());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConceptMapConceptMapConceptMapComponent(String string, ConceptMap.ConceptMapConceptMapComponent conceptMapConceptMapComponent) throws Exception {
        if (conceptMapConceptMapComponent != null) {
            this.composeElementAttributes(conceptMapConceptMapComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conceptMapConceptMapComponent);
            this.composeUri("system", conceptMapConceptMapComponent.getSystem());
            this.composeCode("code", conceptMapConceptMapComponent.getCode());
            if (conceptMapConceptMapComponent.getEquivalence() != null) {
                this.composeEnumeration("equivalence", conceptMapConceptMapComponent.getEquivalence(), new ConceptMap.ConceptEquivalenceEnumFactory());
            }
            this.composeString("comments", conceptMapConceptMapComponent.getComments());
            for (ConceptMap.OtherConceptComponent otherConceptComponent : conceptMapConceptMapComponent.getProduct()) {
                this.composeConceptMapOtherConceptComponent("product", otherConceptComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeCondition(String string, Condition condition) throws Exception {
        if (condition != null) {
            this.composeResourceAttributes(condition);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(condition);
            for (Identifier element : condition.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            this.composeResourceReference("subject", condition.getSubject());
            this.composeResourceReference("encounter", condition.getEncounter());
            this.composeResourceReference("asserter", condition.getAsserter());
            this.composeDate("dateAsserted", condition.getDateAsserted());
            this.composeCodeableConcept("code", condition.getCode());
            this.composeCodeableConcept("category", condition.getCategory());
            if (condition.getStatus() != null) {
                this.composeEnumeration("status", condition.getStatus(), new Condition.ConditionStatusEnumFactory());
            }
            this.composeCodeableConcept("certainty", condition.getCertainty());
            this.composeCodeableConcept("severity", condition.getSeverity());
            this.composeType("onset", condition.getOnset());
            this.composeType("abatement", condition.getAbatement());
            this.composeConditionConditionStageComponent("stage", condition.getStage());
            for (Condition.ConditionEvidenceComponent conditionEvidenceComponent : condition.getEvidence()) {
                this.composeConditionConditionEvidenceComponent("evidence", conditionEvidenceComponent);
            }
            for (Condition.ConditionLocationComponent conditionLocationComponent : condition.getLocation()) {
                this.composeConditionConditionLocationComponent("location", conditionLocationComponent);
            }
            for (Condition.ConditionRelatedItemComponent conditionRelatedItemComponent : condition.getRelatedItem()) {
                this.composeConditionConditionRelatedItemComponent("relatedItem", conditionRelatedItemComponent);
            }
            this.composeString("notes", condition.getNotes());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConditionConditionStageComponent(String string, Condition.ConditionStageComponent conditionStageComponent) throws Exception {
        if (conditionStageComponent != null) {
            this.composeElementAttributes(conditionStageComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conditionStageComponent);
            this.composeCodeableConcept("summary", conditionStageComponent.getSummary());
            for (ResourceReference resourceReference : conditionStageComponent.getAssessment()) {
                this.composeResourceReference("assessment", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConditionConditionEvidenceComponent(String string, Condition.ConditionEvidenceComponent conditionEvidenceComponent) throws Exception {
        if (conditionEvidenceComponent != null) {
            this.composeElementAttributes(conditionEvidenceComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conditionEvidenceComponent);
            this.composeCodeableConcept("code", conditionEvidenceComponent.getCode());
            for (ResourceReference resourceReference : conditionEvidenceComponent.getDetail()) {
                this.composeResourceReference("detail", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConditionConditionLocationComponent(String string, Condition.ConditionLocationComponent conditionLocationComponent) throws Exception {
        if (conditionLocationComponent != null) {
            this.composeElementAttributes(conditionLocationComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conditionLocationComponent);
            this.composeCodeableConcept("code", conditionLocationComponent.getCode());
            this.composeString("detail", conditionLocationComponent.getDetail());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConditionConditionRelatedItemComponent(String string, Condition.ConditionRelatedItemComponent conditionRelatedItemComponent) throws Exception {
        if (conditionRelatedItemComponent != null) {
            this.composeElementAttributes(conditionRelatedItemComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conditionRelatedItemComponent);
            if (conditionRelatedItemComponent.getType() != null) {
                this.composeEnumeration("type", conditionRelatedItemComponent.getType(), new Condition.ConditionRelationshipTypeEnumFactory());
            }
            this.composeCodeableConcept("code", conditionRelatedItemComponent.getCode());
            this.composeResourceReference("target", conditionRelatedItemComponent.getTarget());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConformance(String string, Conformance conformance) throws Exception {
        if (conformance != null) {
            this.composeResourceAttributes(conformance);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(conformance);
            this.composeString("identifier", conformance.getIdentifier());
            this.composeString("version", conformance.getVersion());
            this.composeString("name", conformance.getName());
            this.composeString("publisher", conformance.getPublisher());
            for (Contact element : conformance.getTelecom()) {
                this.composeContact("telecom", element);
            }
            this.composeString("description", conformance.getDescription());
            if (conformance.getStatus() != null) {
                this.composeEnumeration("status", conformance.getStatus(), new Conformance.ConformanceStatementStatusEnumFactory());
            }
            this.composeBoolean("experimental", conformance.getExperimental());
            this.composeDateTime("date", conformance.getDate());
            this.composeConformanceConformanceSoftwareComponent("software", conformance.getSoftware());
            this.composeConformanceConformanceImplementationComponent("implementation", conformance.getImplementation());
            this.composeId("fhirVersion", conformance.getFhirVersion());
            this.composeBoolean("acceptUnknown", conformance.getAcceptUnknown());
            for (CodeType codeType : conformance.getFormat()) {
                this.composeCode("format", codeType);
            }
            for (ResourceReference resourceReference : conformance.getProfile()) {
                this.composeResourceReference("profile", resourceReference);
            }
            for (Conformance.ConformanceRestComponent conformanceRestComponent : conformance.getRest()) {
                this.composeConformanceConformanceRestComponent("rest", conformanceRestComponent);
            }
            for (Conformance.ConformanceMessagingComponent conformanceMessagingComponent : conformance.getMessaging()) {
                this.composeConformanceConformanceMessagingComponent("messaging", conformanceMessagingComponent);
            }
            for (Conformance.ConformanceDocumentComponent conformanceDocumentComponent : conformance.getDocument()) {
                this.composeConformanceConformanceDocumentComponent("document", conformanceDocumentComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConformanceConformanceSoftwareComponent(String string, Conformance.ConformanceSoftwareComponent conformanceSoftwareComponent) throws Exception {
        if (conformanceSoftwareComponent != null) {
            this.composeElementAttributes(conformanceSoftwareComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conformanceSoftwareComponent);
            this.composeString("name", conformanceSoftwareComponent.getName());
            this.composeString("version", conformanceSoftwareComponent.getVersion());
            this.composeDateTime("releaseDate", conformanceSoftwareComponent.getReleaseDate());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConformanceConformanceImplementationComponent(String string, Conformance.ConformanceImplementationComponent conformanceImplementationComponent) throws Exception {
        if (conformanceImplementationComponent != null) {
            this.composeElementAttributes(conformanceImplementationComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conformanceImplementationComponent);
            this.composeString("description", conformanceImplementationComponent.getDescription());
            this.composeUri("url", conformanceImplementationComponent.getUrl());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConformanceConformanceRestComponent(String string, Conformance.ConformanceRestComponent conformanceRestComponent) throws Exception {
        if (conformanceRestComponent != null) {
            this.composeElementAttributes(conformanceRestComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conformanceRestComponent);
            if (conformanceRestComponent.getMode() != null) {
                this.composeEnumeration("mode", conformanceRestComponent.getMode(), new Conformance.RestfulConformanceModeEnumFactory());
            }
            this.composeString("documentation", conformanceRestComponent.getDocumentation());
            this.composeConformanceConformanceRestSecurityComponent("security", conformanceRestComponent.getSecurity());
            for (Conformance.ConformanceRestResourceComponent element : conformanceRestComponent.getResource()) {
                this.composeConformanceConformanceRestResourceComponent("resource", element);
            }
            for (Conformance.ConformanceRestOperationComponent conformanceRestOperationComponent : conformanceRestComponent.getOperation()) {
                this.composeConformanceConformanceRestOperationComponent("operation", conformanceRestOperationComponent);
            }
            for (Conformance.ConformanceRestQueryComponent conformanceRestQueryComponent : conformanceRestComponent.getQuery()) {
                this.composeConformanceConformanceRestQueryComponent("query", conformanceRestQueryComponent);
            }
            for (UriType uriType : conformanceRestComponent.getDocumentMailbox()) {
                this.composeUri("documentMailbox", uriType);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConformanceConformanceRestSecurityComponent(String string, Conformance.ConformanceRestSecurityComponent conformanceRestSecurityComponent) throws Exception {
        if (conformanceRestSecurityComponent != null) {
            this.composeElementAttributes(conformanceRestSecurityComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conformanceRestSecurityComponent);
            this.composeBoolean("cors", conformanceRestSecurityComponent.getCors());
            for (CodeableConcept element : conformanceRestSecurityComponent.getService()) {
                this.composeCodeableConcept("service", element);
            }
            this.composeString("description", conformanceRestSecurityComponent.getDescription());
            for (Conformance.ConformanceRestSecurityCertificateComponent conformanceRestSecurityCertificateComponent : conformanceRestSecurityComponent.getCertificate()) {
                this.composeConformanceConformanceRestSecurityCertificateComponent("certificate", conformanceRestSecurityCertificateComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConformanceConformanceRestSecurityCertificateComponent(String string, Conformance.ConformanceRestSecurityCertificateComponent conformanceRestSecurityCertificateComponent) throws Exception {
        if (conformanceRestSecurityCertificateComponent != null) {
            this.composeElementAttributes(conformanceRestSecurityCertificateComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conformanceRestSecurityCertificateComponent);
            this.composeCode("type", conformanceRestSecurityCertificateComponent.getType());
            this.composeBase64Binary("blob", conformanceRestSecurityCertificateComponent.getBlob());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConformanceConformanceRestResourceComponent(String string, Conformance.ConformanceRestResourceComponent conformanceRestResourceComponent) throws Exception {
        if (conformanceRestResourceComponent != null) {
            this.composeElementAttributes(conformanceRestResourceComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conformanceRestResourceComponent);
            this.composeCode("type", conformanceRestResourceComponent.getType());
            this.composeResourceReference("profile", conformanceRestResourceComponent.getProfile());
            for (Conformance.ConformanceRestResourceOperationComponent element : conformanceRestResourceComponent.getOperation()) {
                this.composeConformanceConformanceRestResourceOperationComponent("operation", element);
            }
            this.composeBoolean("readHistory", conformanceRestResourceComponent.getReadHistory());
            this.composeBoolean("updateCreate", conformanceRestResourceComponent.getUpdateCreate());
            for (StringType stringType : conformanceRestResourceComponent.getSearchInclude()) {
                this.composeString("searchInclude", stringType);
            }
            for (Conformance.ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent : conformanceRestResourceComponent.getSearchParam()) {
                this.composeConformanceConformanceRestResourceSearchParamComponent("searchParam", conformanceRestResourceSearchParamComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConformanceConformanceRestResourceOperationComponent(String string, Conformance.ConformanceRestResourceOperationComponent conformanceRestResourceOperationComponent) throws Exception {
        if (conformanceRestResourceOperationComponent != null) {
            this.composeElementAttributes(conformanceRestResourceOperationComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conformanceRestResourceOperationComponent);
            if (conformanceRestResourceOperationComponent.getCode() != null) {
                this.composeEnumeration("code", conformanceRestResourceOperationComponent.getCode(), new Conformance.TypeRestfulOperationEnumFactory());
            }
            this.composeString("documentation", conformanceRestResourceOperationComponent.getDocumentation());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConformanceConformanceRestResourceSearchParamComponent(String string, Conformance.ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent) throws Exception {
        if (conformanceRestResourceSearchParamComponent != null) {
            this.composeElementAttributes(conformanceRestResourceSearchParamComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conformanceRestResourceSearchParamComponent);
            this.composeString("name", conformanceRestResourceSearchParamComponent.getName());
            this.composeUri("definition", conformanceRestResourceSearchParamComponent.getDefinition());
            if (conformanceRestResourceSearchParamComponent.getType() != null) {
                this.composeEnumeration("type", conformanceRestResourceSearchParamComponent.getType(), new Conformance.SearchParamTypeEnumFactory());
            }
            this.composeString("documentation", conformanceRestResourceSearchParamComponent.getDocumentation());
            for (CodeType primitiveType : conformanceRestResourceSearchParamComponent.getTarget()) {
                this.composeCode("target", primitiveType);
            }
            for (StringType stringType : conformanceRestResourceSearchParamComponent.getChain()) {
                this.composeString("chain", stringType);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConformanceConformanceRestOperationComponent(String string, Conformance.ConformanceRestOperationComponent conformanceRestOperationComponent) throws Exception {
        if (conformanceRestOperationComponent != null) {
            this.composeElementAttributes(conformanceRestOperationComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conformanceRestOperationComponent);
            if (conformanceRestOperationComponent.getCode() != null) {
                this.composeEnumeration("code", conformanceRestOperationComponent.getCode(), new Conformance.SystemRestfulOperationEnumFactory());
            }
            this.composeString("documentation", conformanceRestOperationComponent.getDocumentation());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConformanceConformanceRestQueryComponent(String string, Conformance.ConformanceRestQueryComponent conformanceRestQueryComponent) throws Exception {
        if (conformanceRestQueryComponent != null) {
            this.composeElementAttributes(conformanceRestQueryComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conformanceRestQueryComponent);
            this.composeString("name", conformanceRestQueryComponent.getName());
            this.composeUri("definition", conformanceRestQueryComponent.getDefinition());
            this.composeString("documentation", conformanceRestQueryComponent.getDocumentation());
            for (Conformance.ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent : conformanceRestQueryComponent.getParameter()) {
                this.composeConformanceConformanceRestResourceSearchParamComponent("parameter", conformanceRestResourceSearchParamComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConformanceConformanceMessagingComponent(String string, Conformance.ConformanceMessagingComponent conformanceMessagingComponent) throws Exception {
        if (conformanceMessagingComponent != null) {
            this.composeElementAttributes(conformanceMessagingComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conformanceMessagingComponent);
            this.composeUri("endpoint", conformanceMessagingComponent.getEndpoint());
            this.composeInteger("reliableCache", conformanceMessagingComponent.getReliableCache());
            this.composeString("documentation", conformanceMessagingComponent.getDocumentation());
            for (Conformance.ConformanceMessagingEventComponent conformanceMessagingEventComponent : conformanceMessagingComponent.getEvent()) {
                this.composeConformanceConformanceMessagingEventComponent("event", conformanceMessagingEventComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConformanceConformanceMessagingEventComponent(String string, Conformance.ConformanceMessagingEventComponent conformanceMessagingEventComponent) throws Exception {
        if (conformanceMessagingEventComponent != null) {
            this.composeElementAttributes(conformanceMessagingEventComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conformanceMessagingEventComponent);
            this.composeCoding("code", conformanceMessagingEventComponent.getCode());
            if (conformanceMessagingEventComponent.getCategory() != null) {
                this.composeEnumeration("category", conformanceMessagingEventComponent.getCategory(), new Conformance.MessageSignificanceCategoryEnumFactory());
            }
            if (conformanceMessagingEventComponent.getMode() != null) {
                this.composeEnumeration("mode", conformanceMessagingEventComponent.getMode(), new Conformance.MessageConformanceEventModeEnumFactory());
            }
            for (Coding coding : conformanceMessagingEventComponent.getProtocol()) {
                this.composeCoding("protocol", coding);
            }
            this.composeCode("focus", conformanceMessagingEventComponent.getFocus());
            this.composeResourceReference("request", conformanceMessagingEventComponent.getRequest());
            this.composeResourceReference("response", conformanceMessagingEventComponent.getResponse());
            this.composeString("documentation", conformanceMessagingEventComponent.getDocumentation());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeConformanceConformanceDocumentComponent(String string, Conformance.ConformanceDocumentComponent conformanceDocumentComponent) throws Exception {
        if (conformanceDocumentComponent != null) {
            this.composeElementAttributes(conformanceDocumentComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conformanceDocumentComponent);
            if (conformanceDocumentComponent.getMode() != null) {
                this.composeEnumeration("mode", conformanceDocumentComponent.getMode(), new Conformance.DocumentModeEnumFactory());
            }
            this.composeString("documentation", conformanceDocumentComponent.getDocumentation());
            this.composeResourceReference("profile", conformanceDocumentComponent.getProfile());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDevice(String string, Device device) throws Exception {
        if (device != null) {
            this.composeResourceAttributes(device);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(device);
            for (Identifier type : device.getIdentifier()) {
                this.composeIdentifier("identifier", type);
            }
            this.composeCodeableConcept("type", device.getType());
            this.composeString("manufacturer", device.getManufacturer());
            this.composeString("model", device.getModel());
            this.composeString("version", device.getVersion());
            this.composeDate("expiry", device.getExpiry());
            this.composeString("udi", device.getUdi());
            this.composeString("lotNumber", device.getLotNumber());
            this.composeResourceReference("owner", device.getOwner());
            this.composeResourceReference("location", device.getLocation());
            this.composeResourceReference("patient", device.getPatient());
            for (Contact contact : device.getContact()) {
                this.composeContact("contact", contact);
            }
            this.composeUri("url", device.getUrl());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDeviceObservationReport(String string, DeviceObservationReport deviceObservationReport) throws Exception {
        if (deviceObservationReport != null) {
            this.composeResourceAttributes(deviceObservationReport);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(deviceObservationReport);
            this.composeInstant("instant", deviceObservationReport.getInstant());
            this.composeIdentifier("identifier", deviceObservationReport.getIdentifier());
            this.composeResourceReference("source", deviceObservationReport.getSource());
            this.composeResourceReference("subject", deviceObservationReport.getSubject());
            for (DeviceObservationReport.DeviceObservationReportVirtualDeviceComponent deviceObservationReportVirtualDeviceComponent : deviceObservationReport.getVirtualDevice()) {
                this.composeDeviceObservationReportDeviceObservationReportVirtualDeviceComponent("virtualDevice", deviceObservationReportVirtualDeviceComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDeviceObservationReportDeviceObservationReportVirtualDeviceComponent(String string, DeviceObservationReport.DeviceObservationReportVirtualDeviceComponent deviceObservationReportVirtualDeviceComponent) throws Exception {
        if (deviceObservationReportVirtualDeviceComponent != null) {
            this.composeElementAttributes(deviceObservationReportVirtualDeviceComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(deviceObservationReportVirtualDeviceComponent);
            this.composeCodeableConcept("code", deviceObservationReportVirtualDeviceComponent.getCode());
            for (DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelComponent deviceObservationReportVirtualDeviceChannelComponent : deviceObservationReportVirtualDeviceComponent.getChannel()) {
                this.composeDeviceObservationReportDeviceObservationReportVirtualDeviceChannelComponent("channel", deviceObservationReportVirtualDeviceChannelComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDeviceObservationReportDeviceObservationReportVirtualDeviceChannelComponent(String string, DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelComponent deviceObservationReportVirtualDeviceChannelComponent) throws Exception {
        if (deviceObservationReportVirtualDeviceChannelComponent != null) {
            this.composeElementAttributes(deviceObservationReportVirtualDeviceChannelComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(deviceObservationReportVirtualDeviceChannelComponent);
            this.composeCodeableConcept("code", deviceObservationReportVirtualDeviceChannelComponent.getCode());
            for (DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelMetricComponent deviceObservationReportVirtualDeviceChannelMetricComponent : deviceObservationReportVirtualDeviceChannelComponent.getMetric()) {
                this.composeDeviceObservationReportDeviceObservationReportVirtualDeviceChannelMetricComponent("metric", deviceObservationReportVirtualDeviceChannelMetricComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDeviceObservationReportDeviceObservationReportVirtualDeviceChannelMetricComponent(String string, DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelMetricComponent deviceObservationReportVirtualDeviceChannelMetricComponent) throws Exception {
        if (deviceObservationReportVirtualDeviceChannelMetricComponent != null) {
            this.composeElementAttributes(deviceObservationReportVirtualDeviceChannelMetricComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(deviceObservationReportVirtualDeviceChannelMetricComponent);
            this.composeResourceReference("observation", deviceObservationReportVirtualDeviceChannelMetricComponent.getObservation());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDiagnosticOrder(String string, DiagnosticOrder diagnosticOrder) throws Exception {
        if (diagnosticOrder != null) {
            this.composeResourceAttributes(diagnosticOrder);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(diagnosticOrder);
            this.composeResourceReference("subject", diagnosticOrder.getSubject());
            this.composeResourceReference("orderer", diagnosticOrder.getOrderer());
            for (Identifier element : diagnosticOrder.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            this.composeResourceReference("encounter", diagnosticOrder.getEncounter());
            this.composeString("clinicalNotes", diagnosticOrder.getClinicalNotes());
            for (ResourceReference resourceReference : diagnosticOrder.getSpecimen()) {
                this.composeResourceReference("specimen", resourceReference);
            }
            if (diagnosticOrder.getStatus() != null) {
                this.composeEnumeration("status", diagnosticOrder.getStatus(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory());
            }
            if (diagnosticOrder.getPriority() != null) {
                this.composeEnumeration("priority", diagnosticOrder.getPriority(), new DiagnosticOrder.DiagnosticOrderPriorityEnumFactory());
            }
            for (DiagnosticOrder.DiagnosticOrderEventComponent diagnosticOrderEventComponent : diagnosticOrder.getEvent()) {
                this.composeDiagnosticOrderDiagnosticOrderEventComponent("event", diagnosticOrderEventComponent);
            }
            for (DiagnosticOrder.DiagnosticOrderItemComponent diagnosticOrderItemComponent : diagnosticOrder.getItem()) {
                this.composeDiagnosticOrderDiagnosticOrderItemComponent("item", diagnosticOrderItemComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDiagnosticOrderDiagnosticOrderEventComponent(String string, DiagnosticOrder.DiagnosticOrderEventComponent diagnosticOrderEventComponent) throws Exception {
        if (diagnosticOrderEventComponent != null) {
            this.composeElementAttributes(diagnosticOrderEventComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(diagnosticOrderEventComponent);
            if (diagnosticOrderEventComponent.getStatus() != null) {
                this.composeEnumeration("status", diagnosticOrderEventComponent.getStatus(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory());
            }
            this.composeCodeableConcept("description", diagnosticOrderEventComponent.getDescription());
            this.composeDateTime("dateTime", diagnosticOrderEventComponent.getDateTime());
            this.composeResourceReference("actor", diagnosticOrderEventComponent.getActor());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDiagnosticOrderDiagnosticOrderItemComponent(String string, DiagnosticOrder.DiagnosticOrderItemComponent diagnosticOrderItemComponent) throws Exception {
        if (diagnosticOrderItemComponent != null) {
            this.composeElementAttributes(diagnosticOrderItemComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(diagnosticOrderItemComponent);
            this.composeCodeableConcept("code", diagnosticOrderItemComponent.getCode());
            for (ResourceReference element : diagnosticOrderItemComponent.getSpecimen()) {
                this.composeResourceReference("specimen", element);
            }
            this.composeCodeableConcept("bodySite", diagnosticOrderItemComponent.getBodySite());
            if (diagnosticOrderItemComponent.getStatus() != null) {
                this.composeEnumeration("status", diagnosticOrderItemComponent.getStatus(), new DiagnosticOrder.DiagnosticOrderStatusEnumFactory());
            }
            for (DiagnosticOrder.DiagnosticOrderEventComponent diagnosticOrderEventComponent : diagnosticOrderItemComponent.getEvent()) {
                this.composeDiagnosticOrderDiagnosticOrderEventComponent("event", diagnosticOrderEventComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDiagnosticReport(String string, DiagnosticReport diagnosticReport) throws Exception {
        if (diagnosticReport != null) {
            this.composeResourceAttributes(diagnosticReport);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(diagnosticReport);
            this.composeCodeableConcept("name", diagnosticReport.getName());
            if (diagnosticReport.getStatus() != null) {
                this.composeEnumeration("status", diagnosticReport.getStatus(), new DiagnosticReport.DiagnosticReportStatusEnumFactory());
            }
            this.composeDateTime("issued", diagnosticReport.getIssued());
            this.composeResourceReference("subject", diagnosticReport.getSubject());
            this.composeResourceReference("performer", diagnosticReport.getPerformer());
            this.composeIdentifier("identifier", diagnosticReport.getIdentifier());
            for (ResourceReference element : diagnosticReport.getRequestDetail()) {
                this.composeResourceReference("requestDetail", element);
            }
            this.composeCodeableConcept("serviceCategory", diagnosticReport.getServiceCategory());
            this.composeType("diagnostic", diagnosticReport.getDiagnostic());
            for (ResourceReference resourceReference : diagnosticReport.getSpecimen()) {
                this.composeResourceReference("specimen", resourceReference);
            }
            for (ResourceReference resourceReference : diagnosticReport.getResult()) {
                this.composeResourceReference("result", resourceReference);
            }
            for (ResourceReference resourceReference : diagnosticReport.getImagingStudy()) {
                this.composeResourceReference("imagingStudy", resourceReference);
            }
            for (DiagnosticReport.DiagnosticReportImageComponent diagnosticReportImageComponent : diagnosticReport.getImage()) {
                this.composeDiagnosticReportDiagnosticReportImageComponent("image", diagnosticReportImageComponent);
            }
            this.composeString("conclusion", diagnosticReport.getConclusion());
            for (CodeableConcept codeableConcept : diagnosticReport.getCodedDiagnosis()) {
                this.composeCodeableConcept("codedDiagnosis", codeableConcept);
            }
            for (Attachment attachment : diagnosticReport.getPresentedForm()) {
                this.composeAttachment("presentedForm", attachment);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDiagnosticReportDiagnosticReportImageComponent(String string, DiagnosticReport.DiagnosticReportImageComponent diagnosticReportImageComponent) throws Exception {
        if (diagnosticReportImageComponent != null) {
            this.composeElementAttributes(diagnosticReportImageComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(diagnosticReportImageComponent);
            this.composeString("comment", diagnosticReportImageComponent.getComment());
            this.composeResourceReference("link", diagnosticReportImageComponent.getLink());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDocumentManifest(String string, DocumentManifest documentManifest) throws Exception {
        if (documentManifest != null) {
            this.composeResourceAttributes(documentManifest);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(documentManifest);
            this.composeIdentifier("masterIdentifier", documentManifest.getMasterIdentifier());
            for (Identifier type : documentManifest.getIdentifier()) {
                this.composeIdentifier("identifier", type);
            }
            for (ResourceReference resourceReference : documentManifest.getSubject()) {
                this.composeResourceReference("subject", resourceReference);
            }
            for (ResourceReference resourceReference : documentManifest.getRecipient()) {
                this.composeResourceReference("recipient", resourceReference);
            }
            this.composeCodeableConcept("type", documentManifest.getType());
            for (ResourceReference resourceReference : documentManifest.getAuthor()) {
                this.composeResourceReference("author", resourceReference);
            }
            this.composeDateTime("created", documentManifest.getCreated());
            this.composeUri("source", documentManifest.getSource());
            if (documentManifest.getStatus() != null) {
                this.composeEnumeration("status", documentManifest.getStatus(), new DocumentManifest.DocumentReferenceStatusEnumFactory());
            }
            this.composeResourceReference("supercedes", documentManifest.getSupercedes());
            this.composeString("description", documentManifest.getDescription());
            this.composeCodeableConcept("confidentiality", documentManifest.getConfidentiality());
            for (ResourceReference resourceReference : documentManifest.getContent()) {
                this.composeResourceReference("content", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDocumentReference(String string, DocumentReference documentReference) throws Exception {
        if (documentReference != null) {
            this.composeResourceAttributes(documentReference);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(documentReference);
            this.composeIdentifier("masterIdentifier", documentReference.getMasterIdentifier());
            for (Identifier element : documentReference.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            this.composeResourceReference("subject", documentReference.getSubject());
            this.composeCodeableConcept("type", documentReference.getType());
            this.composeCodeableConcept("class", documentReference.getClass_());
            for (ResourceReference resourceReference : documentReference.getAuthor()) {
                this.composeResourceReference("author", resourceReference);
            }
            this.composeResourceReference("custodian", documentReference.getCustodian());
            this.composeUri("policyManager", documentReference.getPolicyManager());
            this.composeResourceReference("authenticator", documentReference.getAuthenticator());
            this.composeDateTime("created", documentReference.getCreated());
            this.composeInstant("indexed", documentReference.getIndexed());
            if (documentReference.getStatus() != null) {
                this.composeEnumeration("status", documentReference.getStatus(), new DocumentReference.DocumentReferenceStatusEnumFactory());
            }
            this.composeCodeableConcept("docStatus", documentReference.getDocStatus());
            for (DocumentReference.DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent : documentReference.getRelatesTo()) {
                this.composeDocumentReferenceDocumentReferenceRelatesToComponent("relatesTo", documentReferenceRelatesToComponent);
            }
            this.composeString("description", documentReference.getDescription());
            for (CodeableConcept codeableConcept : documentReference.getConfidentiality()) {
                this.composeCodeableConcept("confidentiality", codeableConcept);
            }
            this.composeCode("primaryLanguage", documentReference.getPrimaryLanguage());
            this.composeCode("mimeType", documentReference.getMimeType());
            for (UriType uriType : documentReference.getFormat()) {
                this.composeUri("format", uriType);
            }
            this.composeInteger("size", documentReference.getSize());
            this.composeString("hash", documentReference.getHash());
            this.composeUri("location", documentReference.getLocation());
            this.composeDocumentReferenceDocumentReferenceServiceComponent("service", documentReference.getService());
            this.composeDocumentReferenceDocumentReferenceContextComponent("context", documentReference.getContext());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDocumentReferenceDocumentReferenceRelatesToComponent(String string, DocumentReference.DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent) throws Exception {
        if (documentReferenceRelatesToComponent != null) {
            this.composeElementAttributes(documentReferenceRelatesToComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(documentReferenceRelatesToComponent);
            if (documentReferenceRelatesToComponent.getCode() != null) {
                this.composeEnumeration("code", documentReferenceRelatesToComponent.getCode(), new DocumentReference.DocumentRelationshipTypeEnumFactory());
            }
            this.composeResourceReference("target", documentReferenceRelatesToComponent.getTarget());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDocumentReferenceDocumentReferenceServiceComponent(String string, DocumentReference.DocumentReferenceServiceComponent documentReferenceServiceComponent) throws Exception {
        if (documentReferenceServiceComponent != null) {
            this.composeElementAttributes(documentReferenceServiceComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(documentReferenceServiceComponent);
            this.composeCodeableConcept("type", documentReferenceServiceComponent.getType());
            this.composeString("address", documentReferenceServiceComponent.getAddress());
            for (DocumentReference.DocumentReferenceServiceParameterComponent documentReferenceServiceParameterComponent : documentReferenceServiceComponent.getParameter()) {
                this.composeDocumentReferenceDocumentReferenceServiceParameterComponent("parameter", documentReferenceServiceParameterComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDocumentReferenceDocumentReferenceServiceParameterComponent(String string, DocumentReference.DocumentReferenceServiceParameterComponent documentReferenceServiceParameterComponent) throws Exception {
        if (documentReferenceServiceParameterComponent != null) {
            this.composeElementAttributes(documentReferenceServiceParameterComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(documentReferenceServiceParameterComponent);
            this.composeString("name", documentReferenceServiceParameterComponent.getName());
            this.composeString("value", documentReferenceServiceParameterComponent.getValue());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeDocumentReferenceDocumentReferenceContextComponent(String string, DocumentReference.DocumentReferenceContextComponent documentReferenceContextComponent) throws Exception {
        if (documentReferenceContextComponent != null) {
            this.composeElementAttributes(documentReferenceContextComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(documentReferenceContextComponent);
            for (CodeableConcept codeableConcept : documentReferenceContextComponent.getEvent()) {
                this.composeCodeableConcept("event", codeableConcept);
            }
            this.composePeriod("period", documentReferenceContextComponent.getPeriod());
            this.composeCodeableConcept("facilityType", documentReferenceContextComponent.getFacilityType());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeEncounter(String string, Encounter encounter) throws Exception {
        if (encounter != null) {
            this.composeResourceAttributes(encounter);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(encounter);
            for (Identifier element : encounter.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            if (encounter.getStatus() != null) {
                this.composeEnumeration("status", encounter.getStatus(), new Encounter.EncounterStateEnumFactory());
            }
            if (encounter.getClass_() != null) {
                this.composeEnumeration("class", encounter.getClass_(), new Encounter.EncounterClassEnumFactory());
            }
            for (CodeableConcept codeableConcept : encounter.getType()) {
                this.composeCodeableConcept("type", codeableConcept);
            }
            this.composeResourceReference("subject", encounter.getSubject());
            for (Encounter.EncounterParticipantComponent encounterParticipantComponent : encounter.getParticipant()) {
                this.composeEncounterEncounterParticipantComponent("participant", encounterParticipantComponent);
            }
            this.composePeriod("period", encounter.getPeriod());
            this.composeDuration("length", encounter.getLength());
            this.composeCodeableConcept("reason", encounter.getReason());
            this.composeResourceReference("indication", encounter.getIndication());
            this.composeCodeableConcept("priority", encounter.getPriority());
            this.composeEncounterEncounterHospitalizationComponent("hospitalization", encounter.getHospitalization());
            for (Encounter.EncounterLocationComponent encounterLocationComponent : encounter.getLocation()) {
                this.composeEncounterEncounterLocationComponent("location", encounterLocationComponent);
            }
            this.composeResourceReference("serviceProvider", encounter.getServiceProvider());
            this.composeResourceReference("partOf", encounter.getPartOf());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeEncounterEncounterParticipantComponent(String string, Encounter.EncounterParticipantComponent encounterParticipantComponent) throws Exception {
        if (encounterParticipantComponent != null) {
            this.composeElementAttributes(encounterParticipantComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(encounterParticipantComponent);
            for (CodeableConcept codeableConcept : encounterParticipantComponent.getType()) {
                this.composeCodeableConcept("type", codeableConcept);
            }
            this.composeResourceReference("individual", encounterParticipantComponent.getIndividual());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeEncounterEncounterHospitalizationComponent(String string, Encounter.EncounterHospitalizationComponent encounterHospitalizationComponent) throws Exception {
        if (encounterHospitalizationComponent != null) {
            this.composeElementAttributes(encounterHospitalizationComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(encounterHospitalizationComponent);
            this.composeIdentifier("preAdmissionIdentifier", encounterHospitalizationComponent.getPreAdmissionIdentifier());
            this.composeResourceReference("origin", encounterHospitalizationComponent.getOrigin());
            this.composeCodeableConcept("admitSource", encounterHospitalizationComponent.getAdmitSource());
            this.composePeriod("period", encounterHospitalizationComponent.getPeriod());
            for (Encounter.EncounterHospitalizationAccomodationComponent element : encounterHospitalizationComponent.getAccomodation()) {
                this.composeEncounterEncounterHospitalizationAccomodationComponent("accomodation", element);
            }
            this.composeCodeableConcept("diet", encounterHospitalizationComponent.getDiet());
            for (CodeableConcept codeableConcept : encounterHospitalizationComponent.getSpecialCourtesy()) {
                this.composeCodeableConcept("specialCourtesy", codeableConcept);
            }
            for (CodeableConcept codeableConcept : encounterHospitalizationComponent.getSpecialArrangement()) {
                this.composeCodeableConcept("specialArrangement", codeableConcept);
            }
            this.composeResourceReference("destination", encounterHospitalizationComponent.getDestination());
            this.composeCodeableConcept("dischargeDisposition", encounterHospitalizationComponent.getDischargeDisposition());
            this.composeResourceReference("dischargeDiagnosis", encounterHospitalizationComponent.getDischargeDiagnosis());
            this.composeBoolean("reAdmission", encounterHospitalizationComponent.getReAdmission());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeEncounterEncounterHospitalizationAccomodationComponent(String string, Encounter.EncounterHospitalizationAccomodationComponent encounterHospitalizationAccomodationComponent) throws Exception {
        if (encounterHospitalizationAccomodationComponent != null) {
            this.composeElementAttributes(encounterHospitalizationAccomodationComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(encounterHospitalizationAccomodationComponent);
            this.composeResourceReference("bed", encounterHospitalizationAccomodationComponent.getBed());
            this.composePeriod("period", encounterHospitalizationAccomodationComponent.getPeriod());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeEncounterEncounterLocationComponent(String string, Encounter.EncounterLocationComponent encounterLocationComponent) throws Exception {
        if (encounterLocationComponent != null) {
            this.composeElementAttributes(encounterLocationComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(encounterLocationComponent);
            this.composeResourceReference("location", encounterLocationComponent.getLocation());
            this.composePeriod("period", encounterLocationComponent.getPeriod());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeFamilyHistory(String string, FamilyHistory familyHistory) throws Exception {
        if (familyHistory != null) {
            this.composeResourceAttributes(familyHistory);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(familyHistory);
            for (Identifier element : familyHistory.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            this.composeResourceReference("subject", familyHistory.getSubject());
            this.composeString("note", familyHistory.getNote());
            for (FamilyHistory.FamilyHistoryRelationComponent familyHistoryRelationComponent : familyHistory.getRelation()) {
                this.composeFamilyHistoryFamilyHistoryRelationComponent("relation", familyHistoryRelationComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeFamilyHistoryFamilyHistoryRelationComponent(String string, FamilyHistory.FamilyHistoryRelationComponent familyHistoryRelationComponent) throws Exception {
        if (familyHistoryRelationComponent != null) {
            this.composeElementAttributes(familyHistoryRelationComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(familyHistoryRelationComponent);
            this.composeString("name", familyHistoryRelationComponent.getName());
            this.composeCodeableConcept("relationship", familyHistoryRelationComponent.getRelationship());
            this.composeType("born", familyHistoryRelationComponent.getBorn());
            this.composeType("deceased", familyHistoryRelationComponent.getDeceased());
            this.composeString("note", familyHistoryRelationComponent.getNote());
            for (FamilyHistory.FamilyHistoryRelationConditionComponent familyHistoryRelationConditionComponent : familyHistoryRelationComponent.getCondition()) {
                this.composeFamilyHistoryFamilyHistoryRelationConditionComponent("condition", familyHistoryRelationConditionComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeFamilyHistoryFamilyHistoryRelationConditionComponent(String string, FamilyHistory.FamilyHistoryRelationConditionComponent familyHistoryRelationConditionComponent) throws Exception {
        if (familyHistoryRelationConditionComponent != null) {
            this.composeElementAttributes(familyHistoryRelationConditionComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(familyHistoryRelationConditionComponent);
            this.composeCodeableConcept("type", familyHistoryRelationConditionComponent.getType());
            this.composeCodeableConcept("outcome", familyHistoryRelationConditionComponent.getOutcome());
            this.composeType("onset", familyHistoryRelationConditionComponent.getOnset());
            this.composeString("note", familyHistoryRelationConditionComponent.getNote());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeGroup(String string, Group group) throws Exception {
        if (group != null) {
            this.composeResourceAttributes(group);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(group);
            this.composeIdentifier("identifier", group.getIdentifier());
            if (group.getType() != null) {
                this.composeEnumeration("type", group.getType(), new Group.GroupTypeEnumFactory());
            }
            this.composeBoolean("actual", group.getActual());
            this.composeCodeableConcept("code", group.getCode());
            this.composeString("name", group.getName());
            this.composeInteger("quantity", group.getQuantity());
            for (Group.GroupCharacteristicComponent element : group.getCharacteristic()) {
                this.composeGroupGroupCharacteristicComponent("characteristic", element);
            }
            for (ResourceReference resourceReference : group.getMember()) {
                this.composeResourceReference("member", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeGroupGroupCharacteristicComponent(String string, Group.GroupCharacteristicComponent groupCharacteristicComponent) throws Exception {
        if (groupCharacteristicComponent != null) {
            this.composeElementAttributes(groupCharacteristicComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(groupCharacteristicComponent);
            this.composeCodeableConcept("code", groupCharacteristicComponent.getCode());
            this.composeType("value", groupCharacteristicComponent.getValue());
            this.composeBoolean("exclude", groupCharacteristicComponent.getExclude());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeImagingStudy(String string, ImagingStudy imagingStudy) throws Exception {
        if (imagingStudy != null) {
            this.composeResourceAttributes(imagingStudy);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(imagingStudy);
            this.composeDateTime("dateTime", imagingStudy.getDateTime());
            this.composeResourceReference("subject", imagingStudy.getSubject());
            this.composeOid("uid", imagingStudy.getUid());
            this.composeIdentifier("accessionNo", imagingStudy.getAccessionNo());
            for (Identifier element : imagingStudy.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            for (ResourceReference resourceReference : imagingStudy.getOrder()) {
                this.composeResourceReference("order", resourceReference);
            }
            for (Enumeration enumeration : imagingStudy.getModality()) {
                this.composeEnumeration("modality", enumeration, new ImagingStudy.ImagingModalityEnumFactory());
            }
            this.composeResourceReference("referrer", imagingStudy.getReferrer());
            if (imagingStudy.getAvailability() != null) {
                this.composeEnumeration("availability", imagingStudy.getAvailability(), new ImagingStudy.InstanceAvailabilityEnumFactory());
            }
            this.composeUri("url", imagingStudy.getUrl());
            this.composeInteger("numberOfSeries", imagingStudy.getNumberOfSeries());
            this.composeInteger("numberOfInstances", imagingStudy.getNumberOfInstances());
            this.composeString("clinicalInformation", imagingStudy.getClinicalInformation());
            for (Coding coding : imagingStudy.getProcedure()) {
                this.composeCoding("procedure", coding);
            }
            this.composeResourceReference("interpreter", imagingStudy.getInterpreter());
            this.composeString("description", imagingStudy.getDescription());
            for (ImagingStudy.ImagingStudySeriesComponent imagingStudySeriesComponent : imagingStudy.getSeries()) {
                this.composeImagingStudyImagingStudySeriesComponent("series", imagingStudySeriesComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeImagingStudyImagingStudySeriesComponent(String string, ImagingStudy.ImagingStudySeriesComponent imagingStudySeriesComponent) throws Exception {
        if (imagingStudySeriesComponent != null) {
            this.composeElementAttributes(imagingStudySeriesComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(imagingStudySeriesComponent);
            this.composeInteger("number", imagingStudySeriesComponent.getNumber());
            if (imagingStudySeriesComponent.getModality() != null) {
                this.composeEnumeration("modality", imagingStudySeriesComponent.getModality(), new ImagingStudy.ModalityEnumFactory());
            }
            this.composeOid("uid", imagingStudySeriesComponent.getUid());
            this.composeString("description", imagingStudySeriesComponent.getDescription());
            this.composeInteger("numberOfInstances", imagingStudySeriesComponent.getNumberOfInstances());
            if (imagingStudySeriesComponent.getAvailability() != null) {
                this.composeEnumeration("availability", imagingStudySeriesComponent.getAvailability(), new ImagingStudy.InstanceAvailabilityEnumFactory());
            }
            this.composeUri("url", imagingStudySeriesComponent.getUrl());
            this.composeCoding("bodySite", imagingStudySeriesComponent.getBodySite());
            this.composeDateTime("dateTime", imagingStudySeriesComponent.getDateTime());
            for (ImagingStudy.ImagingStudySeriesInstanceComponent imagingStudySeriesInstanceComponent : imagingStudySeriesComponent.getInstance()) {
                this.composeImagingStudyImagingStudySeriesInstanceComponent("instance", imagingStudySeriesInstanceComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeImagingStudyImagingStudySeriesInstanceComponent(String string, ImagingStudy.ImagingStudySeriesInstanceComponent imagingStudySeriesInstanceComponent) throws Exception {
        if (imagingStudySeriesInstanceComponent != null) {
            this.composeElementAttributes(imagingStudySeriesInstanceComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(imagingStudySeriesInstanceComponent);
            this.composeInteger("number", imagingStudySeriesInstanceComponent.getNumber());
            this.composeOid("uid", imagingStudySeriesInstanceComponent.getUid());
            this.composeOid("sopclass", imagingStudySeriesInstanceComponent.getSopclass());
            this.composeString("type", imagingStudySeriesInstanceComponent.getType());
            this.composeString("title", imagingStudySeriesInstanceComponent.getTitle());
            this.composeUri("url", imagingStudySeriesInstanceComponent.getUrl());
            this.composeResourceReference("attachment", imagingStudySeriesInstanceComponent.getAttachment());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeImmunization(String string, Immunization immunization) throws Exception {
        if (immunization != null) {
            this.composeResourceAttributes(immunization);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(immunization);
            for (Identifier element : immunization.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            this.composeDateTime("date", immunization.getDate());
            this.composeCodeableConcept("vaccineType", immunization.getVaccineType());
            this.composeResourceReference("subject", immunization.getSubject());
            this.composeBoolean("refusedIndicator", immunization.getRefusedIndicator());
            this.composeBoolean("reported", immunization.getReported());
            this.composeResourceReference("performer", immunization.getPerformer());
            this.composeResourceReference("requester", immunization.getRequester());
            this.composeResourceReference("manufacturer", immunization.getManufacturer());
            this.composeResourceReference("location", immunization.getLocation());
            this.composeString("lotNumber", immunization.getLotNumber());
            this.composeDate("expirationDate", immunization.getExpirationDate());
            this.composeCodeableConcept("site", immunization.getSite());
            this.composeCodeableConcept("route", immunization.getRoute());
            this.composeQuantity("doseQuantity", immunization.getDoseQuantity());
            this.composeImmunizationImmunizationExplanationComponent("explanation", immunization.getExplanation());
            for (Immunization.ImmunizationReactionComponent immunizationReactionComponent : immunization.getReaction()) {
                this.composeImmunizationImmunizationReactionComponent("reaction", immunizationReactionComponent);
            }
            for (Immunization.ImmunizationVaccinationProtocolComponent immunizationVaccinationProtocolComponent : immunization.getVaccinationProtocol()) {
                this.composeImmunizationImmunizationVaccinationProtocolComponent("vaccinationProtocol", immunizationVaccinationProtocolComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeImmunizationImmunizationExplanationComponent(String string, Immunization.ImmunizationExplanationComponent immunizationExplanationComponent) throws Exception {
        if (immunizationExplanationComponent != null) {
            this.composeElementAttributes(immunizationExplanationComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(immunizationExplanationComponent);
            for (CodeableConcept codeableConcept : immunizationExplanationComponent.getReason()) {
                this.composeCodeableConcept("reason", codeableConcept);
            }
            for (CodeableConcept codeableConcept : immunizationExplanationComponent.getRefusalReason()) {
                this.composeCodeableConcept("refusalReason", codeableConcept);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeImmunizationImmunizationReactionComponent(String string, Immunization.ImmunizationReactionComponent immunizationReactionComponent) throws Exception {
        if (immunizationReactionComponent != null) {
            this.composeElementAttributes(immunizationReactionComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(immunizationReactionComponent);
            this.composeDateTime("date", immunizationReactionComponent.getDate());
            this.composeResourceReference("detail", immunizationReactionComponent.getDetail());
            this.composeBoolean("reported", immunizationReactionComponent.getReported());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeImmunizationImmunizationVaccinationProtocolComponent(String string, Immunization.ImmunizationVaccinationProtocolComponent immunizationVaccinationProtocolComponent) throws Exception {
        if (immunizationVaccinationProtocolComponent != null) {
            this.composeElementAttributes(immunizationVaccinationProtocolComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(immunizationVaccinationProtocolComponent);
            this.composeInteger("doseSequence", immunizationVaccinationProtocolComponent.getDoseSequence());
            this.composeString("description", immunizationVaccinationProtocolComponent.getDescription());
            this.composeResourceReference("authority", immunizationVaccinationProtocolComponent.getAuthority());
            this.composeString("series", immunizationVaccinationProtocolComponent.getSeries());
            this.composeInteger("seriesDoses", immunizationVaccinationProtocolComponent.getSeriesDoses());
            this.composeCodeableConcept("doseTarget", immunizationVaccinationProtocolComponent.getDoseTarget());
            this.composeCodeableConcept("doseStatus", immunizationVaccinationProtocolComponent.getDoseStatus());
            this.composeCodeableConcept("doseStatusReason", immunizationVaccinationProtocolComponent.getDoseStatusReason());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeImmunizationRecommendation(String string, ImmunizationRecommendation immunizationRecommendation) throws Exception {
        if (immunizationRecommendation != null) {
            this.composeResourceAttributes(immunizationRecommendation);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(immunizationRecommendation);
            for (Identifier element : immunizationRecommendation.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            this.composeResourceReference("subject", immunizationRecommendation.getSubject());
            for (ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent immunizationRecommendationRecommendationComponent : immunizationRecommendation.getRecommendation()) {
                this.composeImmunizationRecommendationImmunizationRecommendationRecommendationComponent("recommendation", immunizationRecommendationRecommendationComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeImmunizationRecommendationImmunizationRecommendationRecommendationComponent(String string, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent immunizationRecommendationRecommendationComponent) throws Exception {
        if (immunizationRecommendationRecommendationComponent != null) {
            this.composeElementAttributes(immunizationRecommendationRecommendationComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(immunizationRecommendationRecommendationComponent);
            this.composeDateTime("date", immunizationRecommendationRecommendationComponent.getDate());
            this.composeCodeableConcept("vaccineType", immunizationRecommendationRecommendationComponent.getVaccineType());
            this.composeInteger("doseNumber", immunizationRecommendationRecommendationComponent.getDoseNumber());
            this.composeCodeableConcept("forecastStatus", immunizationRecommendationRecommendationComponent.getForecastStatus());
            for (ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent element : immunizationRecommendationRecommendationComponent.getDateCriterion()) {
                this.composeImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent("dateCriterion", element);
            }
            this.composeImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent("protocol", immunizationRecommendationRecommendationComponent.getProtocol());
            for (ResourceReference resourceReference : immunizationRecommendationRecommendationComponent.getSupportingImmunization()) {
                this.composeResourceReference("supportingImmunization", resourceReference);
            }
            for (ResourceReference resourceReference : immunizationRecommendationRecommendationComponent.getSupportingPatientInformation()) {
                this.composeResourceReference("supportingPatientInformation", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(String string, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent immunizationRecommendationRecommendationDateCriterionComponent) throws Exception {
        if (immunizationRecommendationRecommendationDateCriterionComponent != null) {
            this.composeElementAttributes(immunizationRecommendationRecommendationDateCriterionComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(immunizationRecommendationRecommendationDateCriterionComponent);
            this.composeCodeableConcept("code", immunizationRecommendationRecommendationDateCriterionComponent.getCode());
            this.composeDateTime("value", immunizationRecommendationRecommendationDateCriterionComponent.getValue());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(String string, ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent immunizationRecommendationRecommendationProtocolComponent) throws Exception {
        if (immunizationRecommendationRecommendationProtocolComponent != null) {
            this.composeElementAttributes(immunizationRecommendationRecommendationProtocolComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(immunizationRecommendationRecommendationProtocolComponent);
            this.composeInteger("doseSequence", immunizationRecommendationRecommendationProtocolComponent.getDoseSequence());
            this.composeString("description", immunizationRecommendationRecommendationProtocolComponent.getDescription());
            this.composeResourceReference("authority", immunizationRecommendationRecommendationProtocolComponent.getAuthority());
            this.composeString("series", immunizationRecommendationRecommendationProtocolComponent.getSeries());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeList_(String string, List_ list_) throws Exception {
        if (list_ != null) {
            this.composeResourceAttributes(list_);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(list_);
            for (Identifier element : list_.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            this.composeCodeableConcept("code", list_.getCode());
            this.composeResourceReference("subject", list_.getSubject());
            this.composeResourceReference("source", list_.getSource());
            this.composeDateTime("date", list_.getDate());
            this.composeBoolean("ordered", list_.getOrdered());
            if (list_.getMode() != null) {
                this.composeEnumeration("mode", list_.getMode(), new List_.ListModeEnumFactory());
            }
            for (List_.ListEntryComponent listEntryComponent : list_.getEntry()) {
                this.composeList_ListEntryComponent("entry", listEntryComponent);
            }
            this.composeCodeableConcept("emptyReason", list_.getEmptyReason());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeList_ListEntryComponent(String string, List_.ListEntryComponent listEntryComponent) throws Exception {
        if (listEntryComponent != null) {
            this.composeElementAttributes(listEntryComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(listEntryComponent);
            for (CodeableConcept codeableConcept : listEntryComponent.getFlag()) {
                this.composeCodeableConcept("flag", codeableConcept);
            }
            this.composeBoolean("deleted", listEntryComponent.getDeleted());
            this.composeDateTime("date", listEntryComponent.getDate());
            this.composeResourceReference("item", listEntryComponent.getItem());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeLocation(String string, Location location) throws Exception {
        if (location != null) {
            this.composeResourceAttributes(location);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(location);
            this.composeIdentifier("identifier", location.getIdentifier());
            this.composeString("name", location.getName());
            this.composeString("description", location.getDescription());
            this.composeCodeableConcept("type", location.getType());
            for (Contact contact : location.getTelecom()) {
                this.composeContact("telecom", contact);
            }
            this.composeAddress("address", location.getAddress());
            this.composeCodeableConcept("physicalType", location.getPhysicalType());
            this.composeLocationLocationPositionComponent("position", location.getPosition());
            this.composeResourceReference("managingOrganization", location.getManagingOrganization());
            if (location.getStatus() != null) {
                this.composeEnumeration("status", location.getStatus(), new Location.LocationStatusEnumFactory());
            }
            this.composeResourceReference("partOf", location.getPartOf());
            if (location.getMode() != null) {
                this.composeEnumeration("mode", location.getMode(), new Location.LocationModeEnumFactory());
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeLocationLocationPositionComponent(String string, Location.LocationPositionComponent locationPositionComponent) throws Exception {
        if (locationPositionComponent != null) {
            this.composeElementAttributes(locationPositionComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(locationPositionComponent);
            this.composeDecimal("longitude", locationPositionComponent.getLongitude());
            this.composeDecimal("latitude", locationPositionComponent.getLatitude());
            this.composeDecimal("altitude", locationPositionComponent.getAltitude());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedia(String string, Media media) throws Exception {
        if (media != null) {
            this.composeResourceAttributes(media);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(media);
            if (media.getType() != null) {
                this.composeEnumeration("type", media.getType(), new Media.MediaTypeEnumFactory());
            }
            this.composeCodeableConcept("subtype", media.getSubtype());
            for (Identifier identifier : media.getIdentifier()) {
                this.composeIdentifier("identifier", identifier);
            }
            this.composeDateTime("dateTime", media.getDateTime());
            this.composeResourceReference("subject", media.getSubject());
            this.composeResourceReference("operator", media.getOperator());
            this.composeCodeableConcept("view", media.getView());
            this.composeString("deviceName", media.getDeviceName());
            this.composeInteger("height", media.getHeight());
            this.composeInteger("width", media.getWidth());
            this.composeInteger("frames", media.getFrames());
            this.composeInteger("length", media.getLength());
            this.composeAttachment("content", media.getContent());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedication(String string, Medication medication) throws Exception {
        if (medication != null) {
            this.composeResourceAttributes(medication);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(medication);
            this.composeString("name", medication.getName());
            this.composeCodeableConcept("code", medication.getCode());
            this.composeBoolean("isBrand", medication.getIsBrand());
            this.composeResourceReference("manufacturer", medication.getManufacturer());
            if (medication.getKind() != null) {
                this.composeEnumeration("kind", medication.getKind(), new Medication.MedicationKindEnumFactory());
            }
            this.composeMedicationMedicationProductComponent("product", medication.getProduct());
            this.composeMedicationMedicationPackageComponent("package", medication.getPackage());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationMedicationProductComponent(String string, Medication.MedicationProductComponent medicationProductComponent) throws Exception {
        if (medicationProductComponent != null) {
            this.composeElementAttributes(medicationProductComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(medicationProductComponent);
            this.composeCodeableConcept("form", medicationProductComponent.getForm());
            for (Medication.MedicationProductIngredientComponent medicationProductIngredientComponent : medicationProductComponent.getIngredient()) {
                this.composeMedicationMedicationProductIngredientComponent("ingredient", medicationProductIngredientComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationMedicationProductIngredientComponent(String string, Medication.MedicationProductIngredientComponent medicationProductIngredientComponent) throws Exception {
        if (medicationProductIngredientComponent != null) {
            this.composeElementAttributes(medicationProductIngredientComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(medicationProductIngredientComponent);
            this.composeResourceReference("item", medicationProductIngredientComponent.getItem());
            this.composeRatio("amount", medicationProductIngredientComponent.getAmount());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationMedicationPackageComponent(String string, Medication.MedicationPackageComponent medicationPackageComponent) throws Exception {
        if (medicationPackageComponent != null) {
            this.composeElementAttributes(medicationPackageComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(medicationPackageComponent);
            this.composeCodeableConcept("container", medicationPackageComponent.getContainer());
            for (Medication.MedicationPackageContentComponent medicationPackageContentComponent : medicationPackageComponent.getContent()) {
                this.composeMedicationMedicationPackageContentComponent("content", medicationPackageContentComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationMedicationPackageContentComponent(String string, Medication.MedicationPackageContentComponent medicationPackageContentComponent) throws Exception {
        if (medicationPackageContentComponent != null) {
            this.composeElementAttributes(medicationPackageContentComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(medicationPackageContentComponent);
            this.composeResourceReference("item", medicationPackageContentComponent.getItem());
            this.composeQuantity("amount", medicationPackageContentComponent.getAmount());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationAdministration(String string, MedicationAdministration medicationAdministration) throws Exception {
        if (medicationAdministration != null) {
            this.composeResourceAttributes(medicationAdministration);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(medicationAdministration);
            for (Identifier element : medicationAdministration.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            if (medicationAdministration.getStatus() != null) {
                this.composeEnumeration("status", medicationAdministration.getStatus(), new MedicationAdministration.MedicationAdminStatusEnumFactory());
            }
            this.composeResourceReference("patient", medicationAdministration.getPatient());
            this.composeResourceReference("practitioner", medicationAdministration.getPractitioner());
            this.composeResourceReference("encounter", medicationAdministration.getEncounter());
            this.composeResourceReference("prescription", medicationAdministration.getPrescription());
            this.composeBoolean("wasNotGiven", medicationAdministration.getWasNotGiven());
            for (CodeableConcept codeableConcept : medicationAdministration.getReasonNotGiven()) {
                this.composeCodeableConcept("reasonNotGiven", codeableConcept);
            }
            this.composePeriod("whenGiven", medicationAdministration.getWhenGiven());
            this.composeResourceReference("medication", medicationAdministration.getMedication());
            for (ResourceReference resourceReference : medicationAdministration.getDevice()) {
                this.composeResourceReference("device", resourceReference);
            }
            for (MedicationAdministration.MedicationAdministrationDosageComponent medicationAdministrationDosageComponent : medicationAdministration.getDosage()) {
                this.composeMedicationAdministrationMedicationAdministrationDosageComponent("dosage", medicationAdministrationDosageComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationAdministrationMedicationAdministrationDosageComponent(String string, MedicationAdministration.MedicationAdministrationDosageComponent medicationAdministrationDosageComponent) throws Exception {
        if (medicationAdministrationDosageComponent != null) {
            this.composeElementAttributes(medicationAdministrationDosageComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(medicationAdministrationDosageComponent);
            this.composeType("timing", medicationAdministrationDosageComponent.getTiming());
            this.composeType("asNeeded", medicationAdministrationDosageComponent.getAsNeeded());
            this.composeCodeableConcept("site", medicationAdministrationDosageComponent.getSite());
            this.composeCodeableConcept("route", medicationAdministrationDosageComponent.getRoute());
            this.composeCodeableConcept("method", medicationAdministrationDosageComponent.getMethod());
            this.composeQuantity("quantity", medicationAdministrationDosageComponent.getQuantity());
            this.composeRatio("rate", medicationAdministrationDosageComponent.getRate());
            this.composeRatio("maxDosePerPeriod", medicationAdministrationDosageComponent.getMaxDosePerPeriod());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationDispense(String string, MedicationDispense medicationDispense) throws Exception {
        if (medicationDispense != null) {
            this.composeResourceAttributes(medicationDispense);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(medicationDispense);
            this.composeIdentifier("identifier", medicationDispense.getIdentifier());
            if (medicationDispense.getStatus() != null) {
                this.composeEnumeration("status", medicationDispense.getStatus(), new MedicationDispense.MedicationDispenseStatusEnumFactory());
            }
            this.composeResourceReference("patient", medicationDispense.getPatient());
            this.composeResourceReference("dispenser", medicationDispense.getDispenser());
            for (ResourceReference element : medicationDispense.getAuthorizingPrescription()) {
                this.composeResourceReference("authorizingPrescription", element);
            }
            for (MedicationDispense.MedicationDispenseDispenseComponent medicationDispenseDispenseComponent : medicationDispense.getDispense()) {
                this.composeMedicationDispenseMedicationDispenseDispenseComponent("dispense", medicationDispenseDispenseComponent);
            }
            this.composeMedicationDispenseMedicationDispenseSubstitutionComponent("substitution", medicationDispense.getSubstitution());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationDispenseMedicationDispenseDispenseComponent(String string, MedicationDispense.MedicationDispenseDispenseComponent medicationDispenseDispenseComponent) throws Exception {
        if (medicationDispenseDispenseComponent != null) {
            this.composeElementAttributes(medicationDispenseDispenseComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(medicationDispenseDispenseComponent);
            this.composeIdentifier("identifier", medicationDispenseDispenseComponent.getIdentifier());
            if (medicationDispenseDispenseComponent.getStatus() != null) {
                this.composeEnumeration("status", medicationDispenseDispenseComponent.getStatus(), new MedicationDispense.MedicationDispenseStatusEnumFactory());
            }
            this.composeCodeableConcept("type", medicationDispenseDispenseComponent.getType());
            this.composeQuantity("quantity", medicationDispenseDispenseComponent.getQuantity());
            this.composeResourceReference("medication", medicationDispenseDispenseComponent.getMedication());
            this.composeDateTime("whenPrepared", medicationDispenseDispenseComponent.getWhenPrepared());
            this.composeDateTime("whenHandedOver", medicationDispenseDispenseComponent.getWhenHandedOver());
            this.composeResourceReference("destination", medicationDispenseDispenseComponent.getDestination());
            for (ResourceReference element : medicationDispenseDispenseComponent.getReceiver()) {
                this.composeResourceReference("receiver", element);
            }
            for (MedicationDispense.MedicationDispenseDispenseDosageComponent medicationDispenseDispenseDosageComponent : medicationDispenseDispenseComponent.getDosage()) {
                this.composeMedicationDispenseMedicationDispenseDispenseDosageComponent("dosage", medicationDispenseDispenseDosageComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationDispenseMedicationDispenseDispenseDosageComponent(String string, MedicationDispense.MedicationDispenseDispenseDosageComponent medicationDispenseDispenseDosageComponent) throws Exception {
        if (medicationDispenseDispenseDosageComponent != null) {
            this.composeElementAttributes(medicationDispenseDispenseDosageComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(medicationDispenseDispenseDosageComponent);
            this.composeCodeableConcept("additionalInstructions", medicationDispenseDispenseDosageComponent.getAdditionalInstructions());
            this.composeType("timing", medicationDispenseDispenseDosageComponent.getTiming());
            this.composeType("asNeeded", medicationDispenseDispenseDosageComponent.getAsNeeded());
            this.composeCodeableConcept("site", medicationDispenseDispenseDosageComponent.getSite());
            this.composeCodeableConcept("route", medicationDispenseDispenseDosageComponent.getRoute());
            this.composeCodeableConcept("method", medicationDispenseDispenseDosageComponent.getMethod());
            this.composeQuantity("quantity", medicationDispenseDispenseDosageComponent.getQuantity());
            this.composeRatio("rate", medicationDispenseDispenseDosageComponent.getRate());
            this.composeRatio("maxDosePerPeriod", medicationDispenseDispenseDosageComponent.getMaxDosePerPeriod());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationDispenseMedicationDispenseSubstitutionComponent(String string, MedicationDispense.MedicationDispenseSubstitutionComponent medicationDispenseSubstitutionComponent) throws Exception {
        if (medicationDispenseSubstitutionComponent != null) {
            this.composeElementAttributes(medicationDispenseSubstitutionComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(medicationDispenseSubstitutionComponent);
            this.composeCodeableConcept("type", medicationDispenseSubstitutionComponent.getType());
            for (CodeableConcept type : medicationDispenseSubstitutionComponent.getReason()) {
                this.composeCodeableConcept("reason", type);
            }
            for (ResourceReference resourceReference : medicationDispenseSubstitutionComponent.getResponsibleParty()) {
                this.composeResourceReference("responsibleParty", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationPrescription(String string, MedicationPrescription medicationPrescription) throws Exception {
        if (medicationPrescription != null) {
            this.composeResourceAttributes(medicationPrescription);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(medicationPrescription);
            for (Identifier element : medicationPrescription.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            this.composeDateTime("dateWritten", medicationPrescription.getDateWritten());
            if (medicationPrescription.getStatus() != null) {
                this.composeEnumeration("status", medicationPrescription.getStatus(), new MedicationPrescription.MedicationPrescriptionStatusEnumFactory());
            }
            this.composeResourceReference("patient", medicationPrescription.getPatient());
            this.composeResourceReference("prescriber", medicationPrescription.getPrescriber());
            this.composeResourceReference("encounter", medicationPrescription.getEncounter());
            this.composeType("reason", medicationPrescription.getReason());
            this.composeResourceReference("medication", medicationPrescription.getMedication());
            for (MedicationPrescription.MedicationPrescriptionDosageInstructionComponent medicationPrescriptionDosageInstructionComponent : medicationPrescription.getDosageInstruction()) {
                this.composeMedicationPrescriptionMedicationPrescriptionDosageInstructionComponent("dosageInstruction", medicationPrescriptionDosageInstructionComponent);
            }
            this.composeMedicationPrescriptionMedicationPrescriptionDispenseComponent("dispense", medicationPrescription.getDispense());
            this.composeMedicationPrescriptionMedicationPrescriptionSubstitutionComponent("substitution", medicationPrescription.getSubstitution());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationPrescriptionMedicationPrescriptionDosageInstructionComponent(String string, MedicationPrescription.MedicationPrescriptionDosageInstructionComponent medicationPrescriptionDosageInstructionComponent) throws Exception {
        if (medicationPrescriptionDosageInstructionComponent != null) {
            this.composeElementAttributes(medicationPrescriptionDosageInstructionComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(medicationPrescriptionDosageInstructionComponent);
            this.composeString("text", medicationPrescriptionDosageInstructionComponent.getText());
            this.composeCodeableConcept("additionalInstructions", medicationPrescriptionDosageInstructionComponent.getAdditionalInstructions());
            this.composeType("timing", medicationPrescriptionDosageInstructionComponent.getTiming());
            this.composeType("asNeeded", medicationPrescriptionDosageInstructionComponent.getAsNeeded());
            this.composeCodeableConcept("site", medicationPrescriptionDosageInstructionComponent.getSite());
            this.composeCodeableConcept("route", medicationPrescriptionDosageInstructionComponent.getRoute());
            this.composeCodeableConcept("method", medicationPrescriptionDosageInstructionComponent.getMethod());
            this.composeQuantity("doseQuantity", medicationPrescriptionDosageInstructionComponent.getDoseQuantity());
            this.composeRatio("rate", medicationPrescriptionDosageInstructionComponent.getRate());
            this.composeRatio("maxDosePerPeriod", medicationPrescriptionDosageInstructionComponent.getMaxDosePerPeriod());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationPrescriptionMedicationPrescriptionDispenseComponent(String string, MedicationPrescription.MedicationPrescriptionDispenseComponent medicationPrescriptionDispenseComponent) throws Exception {
        if (medicationPrescriptionDispenseComponent != null) {
            this.composeElementAttributes(medicationPrescriptionDispenseComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(medicationPrescriptionDispenseComponent);
            this.composeResourceReference("medication", medicationPrescriptionDispenseComponent.getMedication());
            this.composePeriod("validityPeriod", medicationPrescriptionDispenseComponent.getValidityPeriod());
            this.composeInteger("numberOfRepeatsAllowed", medicationPrescriptionDispenseComponent.getNumberOfRepeatsAllowed());
            this.composeQuantity("quantity", medicationPrescriptionDispenseComponent.getQuantity());
            this.composeDuration("expectedSupplyDuration", medicationPrescriptionDispenseComponent.getExpectedSupplyDuration());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationPrescriptionMedicationPrescriptionSubstitutionComponent(String string, MedicationPrescription.MedicationPrescriptionSubstitutionComponent medicationPrescriptionSubstitutionComponent) throws Exception {
        if (medicationPrescriptionSubstitutionComponent != null) {
            this.composeElementAttributes(medicationPrescriptionSubstitutionComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(medicationPrescriptionSubstitutionComponent);
            this.composeCodeableConcept("type", medicationPrescriptionSubstitutionComponent.getType());
            this.composeCodeableConcept("reason", medicationPrescriptionSubstitutionComponent.getReason());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationStatement(String string, MedicationStatement medicationStatement) throws Exception {
        if (medicationStatement != null) {
            this.composeResourceAttributes(medicationStatement);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(medicationStatement);
            for (Identifier element : medicationStatement.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            this.composeResourceReference("patient", medicationStatement.getPatient());
            this.composeBoolean("wasNotGiven", medicationStatement.getWasNotGiven());
            for (CodeableConcept codeableConcept : medicationStatement.getReasonNotGiven()) {
                this.composeCodeableConcept("reasonNotGiven", codeableConcept);
            }
            this.composePeriod("whenGiven", medicationStatement.getWhenGiven());
            this.composeResourceReference("medication", medicationStatement.getMedication());
            for (ResourceReference resourceReference : medicationStatement.getDevice()) {
                this.composeResourceReference("device", resourceReference);
            }
            for (MedicationStatement.MedicationStatementDosageComponent medicationStatementDosageComponent : medicationStatement.getDosage()) {
                this.composeMedicationStatementMedicationStatementDosageComponent("dosage", medicationStatementDosageComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMedicationStatementMedicationStatementDosageComponent(String string, MedicationStatement.MedicationStatementDosageComponent medicationStatementDosageComponent) throws Exception {
        if (medicationStatementDosageComponent != null) {
            this.composeElementAttributes(medicationStatementDosageComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(medicationStatementDosageComponent);
            this.composeSchedule("timing", medicationStatementDosageComponent.getTiming());
            this.composeType("asNeeded", medicationStatementDosageComponent.getAsNeeded());
            this.composeCodeableConcept("site", medicationStatementDosageComponent.getSite());
            this.composeCodeableConcept("route", medicationStatementDosageComponent.getRoute());
            this.composeCodeableConcept("method", medicationStatementDosageComponent.getMethod());
            this.composeQuantity("quantity", medicationStatementDosageComponent.getQuantity());
            this.composeRatio("rate", medicationStatementDosageComponent.getRate());
            this.composeRatio("maxDosePerPeriod", medicationStatementDosageComponent.getMaxDosePerPeriod());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMessageHeader(String string, MessageHeader messageHeader) throws Exception {
        if (messageHeader != null) {
            this.composeResourceAttributes(messageHeader);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(messageHeader);
            this.composeId("identifier", messageHeader.getIdentifier());
            this.composeInstant("timestamp", messageHeader.getTimestamp());
            this.composeCoding("event", messageHeader.getEvent());
            this.composeMessageHeaderMessageHeaderResponseComponent("response", messageHeader.getResponse());
            this.composeMessageHeaderMessageSourceComponent("source", messageHeader.getSource());
            for (MessageHeader.MessageDestinationComponent element : messageHeader.getDestination()) {
                this.composeMessageHeaderMessageDestinationComponent("destination", element);
            }
            this.composeResourceReference("enterer", messageHeader.getEnterer());
            this.composeResourceReference("author", messageHeader.getAuthor());
            this.composeResourceReference("receiver", messageHeader.getReceiver());
            this.composeResourceReference("responsible", messageHeader.getResponsible());
            this.composeCodeableConcept("reason", messageHeader.getReason());
            for (ResourceReference resourceReference : messageHeader.getData()) {
                this.composeResourceReference("data", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMessageHeaderMessageHeaderResponseComponent(String string, MessageHeader.MessageHeaderResponseComponent messageHeaderResponseComponent) throws Exception {
        if (messageHeaderResponseComponent != null) {
            this.composeElementAttributes(messageHeaderResponseComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(messageHeaderResponseComponent);
            this.composeId("identifier", messageHeaderResponseComponent.getIdentifier());
            if (messageHeaderResponseComponent.getCode() != null) {
                this.composeEnumeration("code", messageHeaderResponseComponent.getCode(), new MessageHeader.ResponseCodeEnumFactory());
            }
            this.composeResourceReference("details", messageHeaderResponseComponent.getDetails());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMessageHeaderMessageSourceComponent(String string, MessageHeader.MessageSourceComponent messageSourceComponent) throws Exception {
        if (messageSourceComponent != null) {
            this.composeElementAttributes(messageSourceComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(messageSourceComponent);
            this.composeString("name", messageSourceComponent.getName());
            this.composeString("software", messageSourceComponent.getSoftware());
            this.composeString("version", messageSourceComponent.getVersion());
            this.composeContact("contact", messageSourceComponent.getContact());
            this.composeUri("endpoint", messageSourceComponent.getEndpoint());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeMessageHeaderMessageDestinationComponent(String string, MessageHeader.MessageDestinationComponent messageDestinationComponent) throws Exception {
        if (messageDestinationComponent != null) {
            this.composeElementAttributes(messageDestinationComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(messageDestinationComponent);
            this.composeString("name", messageDestinationComponent.getName());
            this.composeResourceReference("target", messageDestinationComponent.getTarget());
            this.composeUri("endpoint", messageDestinationComponent.getEndpoint());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeObservation(String string, Observation observation) throws Exception {
        if (observation != null) {
            this.composeResourceAttributes(observation);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(observation);
            this.composeCodeableConcept("name", observation.getName());
            this.composeType("value", observation.getValue());
            this.composeCodeableConcept("interpretation", observation.getInterpretation());
            this.composeString("comments", observation.getComments());
            this.composeType("applies", observation.getApplies());
            this.composeInstant("issued", observation.getIssued());
            if (observation.getStatus() != null) {
                this.composeEnumeration("status", observation.getStatus(), new Observation.ObservationStatusEnumFactory());
            }
            if (observation.getReliability() != null) {
                this.composeEnumeration("reliability", observation.getReliability(), new Observation.ObservationReliabilityEnumFactory());
            }
            this.composeCodeableConcept("bodySite", observation.getBodySite());
            this.composeCodeableConcept("method", observation.getMethod());
            this.composeIdentifier("identifier", observation.getIdentifier());
            this.composeResourceReference("subject", observation.getSubject());
            this.composeResourceReference("specimen", observation.getSpecimen());
            for (ResourceReference element : observation.getPerformer()) {
                this.composeResourceReference("performer", element);
            }
            for (Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent : observation.getReferenceRange()) {
                this.composeObservationObservationReferenceRangeComponent("referenceRange", observationReferenceRangeComponent);
            }
            for (Observation.ObservationRelatedComponent observationRelatedComponent : observation.getRelated()) {
                this.composeObservationObservationRelatedComponent("related", observationRelatedComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeObservationObservationReferenceRangeComponent(String string, Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent) throws Exception {
        if (observationReferenceRangeComponent != null) {
            this.composeElementAttributes(observationReferenceRangeComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(observationReferenceRangeComponent);
            this.composeQuantity("low", observationReferenceRangeComponent.getLow());
            this.composeQuantity("high", observationReferenceRangeComponent.getHigh());
            this.composeCodeableConcept("meaning", observationReferenceRangeComponent.getMeaning());
            this.composeRange("age", observationReferenceRangeComponent.getAge());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeObservationObservationRelatedComponent(String string, Observation.ObservationRelatedComponent observationRelatedComponent) throws Exception {
        if (observationRelatedComponent != null) {
            this.composeElementAttributes(observationRelatedComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(observationRelatedComponent);
            if (observationRelatedComponent.getType() != null) {
                this.composeEnumeration("type", observationRelatedComponent.getType(), new Observation.ObservationRelationshiptypesEnumFactory());
            }
            this.composeResourceReference("target", observationRelatedComponent.getTarget());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeOperationOutcome(String string, OperationOutcome operationOutcome) throws Exception {
        if (operationOutcome != null) {
            this.composeResourceAttributes(operationOutcome);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(operationOutcome);
            for (OperationOutcome.OperationOutcomeIssueComponent operationOutcomeIssueComponent : operationOutcome.getIssue()) {
                this.composeOperationOutcomeOperationOutcomeIssueComponent("issue", operationOutcomeIssueComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeOperationOutcomeOperationOutcomeIssueComponent(String string, OperationOutcome.OperationOutcomeIssueComponent operationOutcomeIssueComponent) throws Exception {
        if (operationOutcomeIssueComponent != null) {
            this.composeElementAttributes(operationOutcomeIssueComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(operationOutcomeIssueComponent);
            if (operationOutcomeIssueComponent.getSeverity() != null) {
                this.composeEnumeration("severity", operationOutcomeIssueComponent.getSeverity(), new OperationOutcome.IssueSeverityEnumFactory());
            }
            this.composeCoding("type", operationOutcomeIssueComponent.getType());
            this.composeString("details", operationOutcomeIssueComponent.getDetails());
            for (StringType stringType : operationOutcomeIssueComponent.getLocation()) {
                this.composeString("location", stringType);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeOrder(String string, Order order) throws Exception {
        if (order != null) {
            this.composeResourceAttributes(order);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(order);
            for (Identifier type : order.getIdentifier()) {
                this.composeIdentifier("identifier", type);
            }
            this.composeDateTime("date", order.getDate());
            this.composeResourceReference("subject", order.getSubject());
            this.composeResourceReference("source", order.getSource());
            this.composeResourceReference("target", order.getTarget());
            this.composeType("reason", order.getReason());
            this.composeResourceReference("authority", order.getAuthority());
            this.composeOrderOrderWhenComponent("when", order.getWhen());
            for (ResourceReference resourceReference : order.getDetail()) {
                this.composeResourceReference("detail", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeOrderOrderWhenComponent(String string, Order.OrderWhenComponent orderWhenComponent) throws Exception {
        if (orderWhenComponent != null) {
            this.composeElementAttributes(orderWhenComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(orderWhenComponent);
            this.composeCodeableConcept("code", orderWhenComponent.getCode());
            this.composeSchedule("schedule", orderWhenComponent.getSchedule());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeOrderResponse(String string, OrderResponse orderResponse) throws Exception {
        if (orderResponse != null) {
            this.composeResourceAttributes(orderResponse);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(orderResponse);
            for (Identifier type : orderResponse.getIdentifier()) {
                this.composeIdentifier("identifier", type);
            }
            this.composeResourceReference("request", orderResponse.getRequest());
            this.composeDateTime("date", orderResponse.getDate());
            this.composeResourceReference("who", orderResponse.getWho());
            this.composeType("authority", orderResponse.getAuthority());
            if (orderResponse.getCode() != null) {
                this.composeEnumeration("code", orderResponse.getCode(), new OrderResponse.OrderOutcomeCodeEnumFactory());
            }
            this.composeString("description", orderResponse.getDescription());
            for (ResourceReference resourceReference : orderResponse.getFulfillment()) {
                this.composeResourceReference("fulfillment", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeOrganization(String string, Organization organization) throws Exception {
        if (organization != null) {
            this.composeResourceAttributes(organization);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(organization);
            for (Identifier element : organization.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            this.composeString("name", organization.getName());
            this.composeCodeableConcept("type", organization.getType());
            for (Contact contact : organization.getTelecom()) {
                this.composeContact("telecom", contact);
            }
            for (Address address : organization.getAddress()) {
                this.composeAddress("address", address);
            }
            this.composeResourceReference("partOf", organization.getPartOf());
            for (Organization.OrganizationContactComponent organizationContactComponent : organization.getContact()) {
                this.composeOrganizationOrganizationContactComponent("contact", organizationContactComponent);
            }
            for (ResourceReference resourceReference : organization.getLocation()) {
                this.composeResourceReference("location", resourceReference);
            }
            this.composeBoolean("active", organization.getActive());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeOrganizationOrganizationContactComponent(String string, Organization.OrganizationContactComponent organizationContactComponent) throws Exception {
        if (organizationContactComponent != null) {
            this.composeElementAttributes(organizationContactComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(organizationContactComponent);
            this.composeCodeableConcept("purpose", organizationContactComponent.getPurpose());
            this.composeHumanName("name", organizationContactComponent.getName());
            for (Contact contact : organizationContactComponent.getTelecom()) {
                this.composeContact("telecom", contact);
            }
            this.composeAddress("address", organizationContactComponent.getAddress());
            this.composeCodeableConcept("gender", organizationContactComponent.getGender());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeOther(String string, Other other) throws Exception {
        if (other != null) {
            this.composeResourceAttributes(other);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(other);
            for (Identifier identifier : other.getIdentifier()) {
                this.composeIdentifier("identifier", identifier);
            }
            this.composeCodeableConcept("code", other.getCode());
            this.composeResourceReference("subject", other.getSubject());
            this.composeResourceReference("author", other.getAuthor());
            this.composeDate("created", other.getCreated());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composePatient(String string, Patient patient) throws Exception {
        if (patient != null) {
            this.composeResourceAttributes(patient);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(patient);
            for (Identifier element : patient.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            for (HumanName humanName : patient.getName()) {
                this.composeHumanName("name", humanName);
            }
            for (Contact contact : patient.getTelecom()) {
                this.composeContact("telecom", contact);
            }
            this.composeCodeableConcept("gender", patient.getGender());
            this.composeDateTime("birthDate", patient.getBirthDate());
            this.composeType("deceased", patient.getDeceased());
            for (Address address : patient.getAddress()) {
                this.composeAddress("address", address);
            }
            this.composeCodeableConcept("maritalStatus", patient.getMaritalStatus());
            this.composeType("multipleBirth", patient.getMultipleBirth());
            for (Attachment attachment : patient.getPhoto()) {
                this.composeAttachment("photo", attachment);
            }
            for (Patient.ContactComponent contactComponent : patient.getContact()) {
                this.composePatientContactComponent("contact", contactComponent);
            }
            this.composePatientAnimalComponent("animal", patient.getAnimal());
            for (CodeableConcept codeableConcept : patient.getCommunication()) {
                this.composeCodeableConcept("communication", codeableConcept);
            }
            for (ResourceReference resourceReference : patient.getCareProvider()) {
                this.composeResourceReference("careProvider", resourceReference);
            }
            this.composeResourceReference("managingOrganization", patient.getManagingOrganization());
            for (Patient.PatientLinkComponent patientLinkComponent : patient.getLink()) {
                this.composePatientPatientLinkComponent("link", patientLinkComponent);
            }
            this.composeBoolean("active", patient.getActive());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composePatientContactComponent(String string, Patient.ContactComponent contactComponent) throws Exception {
        if (contactComponent != null) {
            this.composeElementAttributes(contactComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(contactComponent);
            for (CodeableConcept type : contactComponent.getRelationship()) {
                this.composeCodeableConcept("relationship", type);
            }
            this.composeHumanName("name", contactComponent.getName());
            for (Contact contact : contactComponent.getTelecom()) {
                this.composeContact("telecom", contact);
            }
            this.composeAddress("address", contactComponent.getAddress());
            this.composeCodeableConcept("gender", contactComponent.getGender());
            this.composeResourceReference("organization", contactComponent.getOrganization());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composePatientAnimalComponent(String string, Patient.AnimalComponent animalComponent) throws Exception {
        if (animalComponent != null) {
            this.composeElementAttributes(animalComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(animalComponent);
            this.composeCodeableConcept("species", animalComponent.getSpecies());
            this.composeCodeableConcept("breed", animalComponent.getBreed());
            this.composeCodeableConcept("genderStatus", animalComponent.getGenderStatus());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composePatientPatientLinkComponent(String string, Patient.PatientLinkComponent patientLinkComponent) throws Exception {
        if (patientLinkComponent != null) {
            this.composeElementAttributes(patientLinkComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(patientLinkComponent);
            this.composeResourceReference("other", patientLinkComponent.getOther());
            if (patientLinkComponent.getType() != null) {
                this.composeEnumeration("type", patientLinkComponent.getType(), new Patient.LinkTypeEnumFactory());
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composePractitioner(String string, Practitioner practitioner) throws Exception {
        if (practitioner != null) {
            this.composeResourceAttributes(practitioner);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(practitioner);
            for (Identifier element : practitioner.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            this.composeHumanName("name", practitioner.getName());
            for (Contact contact : practitioner.getTelecom()) {
                this.composeContact("telecom", contact);
            }
            this.composeAddress("address", practitioner.getAddress());
            this.composeCodeableConcept("gender", practitioner.getGender());
            this.composeDateTime("birthDate", practitioner.getBirthDate());
            for (Attachment attachment : practitioner.getPhoto()) {
                this.composeAttachment("photo", attachment);
            }
            this.composeResourceReference("organization", practitioner.getOrganization());
            for (CodeableConcept codeableConcept : practitioner.getRole()) {
                this.composeCodeableConcept("role", codeableConcept);
            }
            for (CodeableConcept codeableConcept : practitioner.getSpecialty()) {
                this.composeCodeableConcept("specialty", codeableConcept);
            }
            this.composePeriod("period", practitioner.getPeriod());
            for (ResourceReference resourceReference : practitioner.getLocation()) {
                this.composeResourceReference("location", resourceReference);
            }
            for (Practitioner.PractitionerQualificationComponent practitionerQualificationComponent : practitioner.getQualification()) {
                this.composePractitionerPractitionerQualificationComponent("qualification", practitionerQualificationComponent);
            }
            for (CodeableConcept codeableConcept : practitioner.getCommunication()) {
                this.composeCodeableConcept("communication", codeableConcept);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composePractitionerPractitionerQualificationComponent(String string, Practitioner.PractitionerQualificationComponent practitionerQualificationComponent) throws Exception {
        if (practitionerQualificationComponent != null) {
            this.composeElementAttributes(practitionerQualificationComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(practitionerQualificationComponent);
            this.composeCodeableConcept("code", practitionerQualificationComponent.getCode());
            this.composePeriod("period", practitionerQualificationComponent.getPeriod());
            this.composeResourceReference("issuer", practitionerQualificationComponent.getIssuer());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProcedure(String string, Procedure procedure) throws Exception {
        if (procedure != null) {
            this.composeResourceAttributes(procedure);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(procedure);
            for (Identifier element : procedure.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            this.composeResourceReference("subject", procedure.getSubject());
            this.composeCodeableConcept("type", procedure.getType());
            for (CodeableConcept codeableConcept : procedure.getBodySite()) {
                this.composeCodeableConcept("bodySite", codeableConcept);
            }
            for (CodeableConcept codeableConcept : procedure.getIndication()) {
                this.composeCodeableConcept("indication", codeableConcept);
            }
            for (Procedure.ProcedurePerformerComponent procedurePerformerComponent : procedure.getPerformer()) {
                this.composeProcedureProcedurePerformerComponent("performer", procedurePerformerComponent);
            }
            this.composePeriod("date", procedure.getDate());
            this.composeResourceReference("encounter", procedure.getEncounter());
            this.composeString("outcome", procedure.getOutcome());
            for (ResourceReference resourceReference : procedure.getReport()) {
                this.composeResourceReference("report", resourceReference);
            }
            for (CodeableConcept codeableConcept : procedure.getComplication()) {
                this.composeCodeableConcept("complication", codeableConcept);
            }
            this.composeString("followUp", procedure.getFollowUp());
            for (Procedure.ProcedureRelatedItemComponent procedureRelatedItemComponent : procedure.getRelatedItem()) {
                this.composeProcedureProcedureRelatedItemComponent("relatedItem", procedureRelatedItemComponent);
            }
            this.composeString("notes", procedure.getNotes());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProcedureProcedurePerformerComponent(String string, Procedure.ProcedurePerformerComponent procedurePerformerComponent) throws Exception {
        if (procedurePerformerComponent != null) {
            this.composeElementAttributes(procedurePerformerComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(procedurePerformerComponent);
            this.composeResourceReference("person", procedurePerformerComponent.getPerson());
            this.composeCodeableConcept("role", procedurePerformerComponent.getRole());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProcedureProcedureRelatedItemComponent(String string, Procedure.ProcedureRelatedItemComponent procedureRelatedItemComponent) throws Exception {
        if (procedureRelatedItemComponent != null) {
            this.composeElementAttributes(procedureRelatedItemComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(procedureRelatedItemComponent);
            if (procedureRelatedItemComponent.getType() != null) {
                this.composeEnumeration("type", procedureRelatedItemComponent.getType(), new Procedure.ProcedureRelationshipTypeEnumFactory());
            }
            this.composeResourceReference("target", procedureRelatedItemComponent.getTarget());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProfile(String string, Profile profile) throws Exception {
        if (profile != null) {
            this.composeResourceAttributes(profile);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(profile);
            this.composeString("identifier", profile.getIdentifier());
            this.composeString("version", profile.getVersion());
            this.composeString("name", profile.getName());
            this.composeString("publisher", profile.getPublisher());
            for (Contact element : profile.getTelecom()) {
                this.composeContact("telecom", element);
            }
            this.composeString("description", profile.getDescription());
            for (Coding coding : profile.getCode()) {
                this.composeCoding("code", coding);
            }
            if (profile.getStatus() != null) {
                this.composeEnumeration("status", profile.getStatus(), new Profile.ResourceProfileStatusEnumFactory());
            }
            this.composeBoolean("experimental", profile.getExperimental());
            this.composeDateTime("date", profile.getDate());
            this.composeString("requirements", profile.getRequirements());
            this.composeId("fhirVersion", profile.getFhirVersion());
            for (Profile.ProfileMappingComponent profileMappingComponent : profile.getMapping()) {
                this.composeProfileProfileMappingComponent("mapping", profileMappingComponent);
            }
            for (Profile.ProfileStructureComponent profileStructureComponent : profile.getStructure()) {
                this.composeProfileProfileStructureComponent("structure", profileStructureComponent);
            }
            for (Profile.ProfileExtensionDefnComponent profileExtensionDefnComponent : profile.getExtensionDefn()) {
                this.composeProfileProfileExtensionDefnComponent("extensionDefn", profileExtensionDefnComponent);
            }
            for (Profile.ProfileQueryComponent profileQueryComponent : profile.getQuery()) {
                this.composeProfileProfileQueryComponent("query", profileQueryComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProfileProfileMappingComponent(String string, Profile.ProfileMappingComponent profileMappingComponent) throws Exception {
        if (profileMappingComponent != null) {
            this.composeElementAttributes(profileMappingComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(profileMappingComponent);
            this.composeId("identity", profileMappingComponent.getIdentity());
            this.composeUri("uri", profileMappingComponent.getUri());
            this.composeString("name", profileMappingComponent.getName());
            this.composeString("comments", profileMappingComponent.getComments());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProfileProfileStructureComponent(String string, Profile.ProfileStructureComponent profileStructureComponent) throws Exception {
        if (profileStructureComponent != null) {
            this.composeElementAttributes(profileStructureComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(profileStructureComponent);
            this.composeCode("type", profileStructureComponent.getType());
            this.composeString("name", profileStructureComponent.getName());
            this.composeBoolean("publish", profileStructureComponent.getPublish());
            this.composeString("purpose", profileStructureComponent.getPurpose());
            for (Profile.ElementComponent backboneElement : profileStructureComponent.getElement()) {
                this.composeProfileElementComponent("element", backboneElement);
            }
            for (Profile.ProfileStructureSearchParamComponent profileStructureSearchParamComponent : profileStructureComponent.getSearchParam()) {
                this.composeProfileProfileStructureSearchParamComponent("searchParam", profileStructureSearchParamComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProfileElementComponent(String string, Profile.ElementComponent elementComponent) throws Exception {
        if (elementComponent != null) {
            this.composeElementAttributes(elementComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(elementComponent);
            this.composeString("path", elementComponent.getPath());
            for (Enumeration<Profile.PropertyRepresentation> enumeration : elementComponent.getRepresentation()) {
                this.composeEnumeration("representation", enumeration, new Profile.PropertyRepresentationEnumFactory());
            }
            this.composeString("name", elementComponent.getName());
            this.composeProfileElementSlicingComponent("slicing", elementComponent.getSlicing());
            this.composeProfileElementDefinitionComponent("definition", elementComponent.getDefinition());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProfileElementSlicingComponent(String string, Profile.ElementSlicingComponent elementSlicingComponent) throws Exception {
        if (elementSlicingComponent != null) {
            this.composeElementAttributes(elementSlicingComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(elementSlicingComponent);
            this.composeId("discriminator", elementSlicingComponent.getDiscriminator());
            this.composeBoolean("ordered", elementSlicingComponent.getOrdered());
            if (elementSlicingComponent.getRules() != null) {
                this.composeEnumeration("rules", elementSlicingComponent.getRules(), new Profile.ResourceSlicingRulesEnumFactory());
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProfileElementDefinitionComponent(String string, Profile.ElementDefinitionComponent elementDefinitionComponent) throws Exception {
        if (elementDefinitionComponent != null) {
            this.composeElementAttributes(elementDefinitionComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(elementDefinitionComponent);
            this.composeString("short", elementDefinitionComponent.getShort());
            this.composeString("formal", elementDefinitionComponent.getFormal());
            this.composeString("comments", elementDefinitionComponent.getComments());
            this.composeString("requirements", elementDefinitionComponent.getRequirements());
            for (StringType element : elementDefinitionComponent.getSynonym()) {
                this.composeString("synonym", element);
            }
            this.composeInteger("min", elementDefinitionComponent.getMin());
            this.composeString("max", elementDefinitionComponent.getMax());
            for (Profile.TypeRefComponent typeRefComponent : elementDefinitionComponent.getType()) {
                this.composeProfileTypeRefComponent("type", typeRefComponent);
            }
            this.composeString("nameReference", elementDefinitionComponent.getNameReference());
            this.composeType("value", elementDefinitionComponent.getValue());
            this.composeType("example", elementDefinitionComponent.getExample());
            this.composeInteger("maxLength", elementDefinitionComponent.getMaxLength());
            for (IdType idType : elementDefinitionComponent.getCondition()) {
                this.composeId("condition", idType);
            }
            for (Profile.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : elementDefinitionComponent.getConstraint()) {
                this.composeProfileElementDefinitionConstraintComponent("constraint", elementDefinitionConstraintComponent);
            }
            this.composeBoolean("mustSupport", elementDefinitionComponent.getMustSupport());
            this.composeBoolean("isModifier", elementDefinitionComponent.getIsModifier());
            this.composeProfileElementDefinitionBindingComponent("binding", elementDefinitionComponent.getBinding());
            for (Profile.ElementDefinitionMappingComponent elementDefinitionMappingComponent : elementDefinitionComponent.getMapping()) {
                this.composeProfileElementDefinitionMappingComponent("mapping", elementDefinitionMappingComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProfileTypeRefComponent(String string, Profile.TypeRefComponent typeRefComponent) throws Exception {
        if (typeRefComponent != null) {
            this.composeElementAttributes(typeRefComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(typeRefComponent);
            this.composeCode("code", typeRefComponent.getCode());
            this.composeUri("profile", typeRefComponent.getProfile());
            for (Enumeration<Profile.ResourceAggregationMode> enumeration : typeRefComponent.getAggregation()) {
                this.composeEnumeration("aggregation", enumeration, new Profile.ResourceAggregationModeEnumFactory());
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProfileElementDefinitionConstraintComponent(String string, Profile.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent) throws Exception {
        if (elementDefinitionConstraintComponent != null) {
            this.composeElementAttributes(elementDefinitionConstraintComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(elementDefinitionConstraintComponent);
            this.composeId("key", elementDefinitionConstraintComponent.getKey());
            this.composeString("name", elementDefinitionConstraintComponent.getName());
            if (elementDefinitionConstraintComponent.getSeverity() != null) {
                this.composeEnumeration("severity", elementDefinitionConstraintComponent.getSeverity(), new Profile.ConstraintSeverityEnumFactory());
            }
            this.composeString("human", elementDefinitionConstraintComponent.getHuman());
            this.composeString("xpath", elementDefinitionConstraintComponent.getXpath());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProfileElementDefinitionBindingComponent(String string, Profile.ElementDefinitionBindingComponent elementDefinitionBindingComponent) throws Exception {
        if (elementDefinitionBindingComponent != null) {
            this.composeElementAttributes(elementDefinitionBindingComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(elementDefinitionBindingComponent);
            this.composeString("name", elementDefinitionBindingComponent.getName());
            this.composeBoolean("isExtensible", elementDefinitionBindingComponent.getIsExtensible());
            if (elementDefinitionBindingComponent.getConformance() != null) {
                this.composeEnumeration("conformance", elementDefinitionBindingComponent.getConformance(), new Profile.BindingConformanceEnumFactory());
            }
            this.composeString("description", elementDefinitionBindingComponent.getDescription());
            this.composeType("reference", elementDefinitionBindingComponent.getReference());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProfileElementDefinitionMappingComponent(String string, Profile.ElementDefinitionMappingComponent elementDefinitionMappingComponent) throws Exception {
        if (elementDefinitionMappingComponent != null) {
            this.composeElementAttributes(elementDefinitionMappingComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(elementDefinitionMappingComponent);
            this.composeId("identity", elementDefinitionMappingComponent.getIdentity());
            this.composeString("map", elementDefinitionMappingComponent.getMap());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProfileProfileStructureSearchParamComponent(String string, Profile.ProfileStructureSearchParamComponent profileStructureSearchParamComponent) throws Exception {
        if (profileStructureSearchParamComponent != null) {
            this.composeElementAttributes(profileStructureSearchParamComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(profileStructureSearchParamComponent);
            this.composeString("name", profileStructureSearchParamComponent.getName());
            if (profileStructureSearchParamComponent.getType() != null) {
                this.composeEnumeration("type", profileStructureSearchParamComponent.getType(), new Profile.SearchParamTypeEnumFactory());
            }
            this.composeString("documentation", profileStructureSearchParamComponent.getDocumentation());
            this.composeString("xpath", profileStructureSearchParamComponent.getXpath());
            for (CodeType codeType : profileStructureSearchParamComponent.getTarget()) {
                this.composeCode("target", codeType);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProfileProfileExtensionDefnComponent(String string, Profile.ProfileExtensionDefnComponent profileExtensionDefnComponent) throws Exception {
        if (profileExtensionDefnComponent != null) {
            this.composeElementAttributes(profileExtensionDefnComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(profileExtensionDefnComponent);
            this.composeCode("code", profileExtensionDefnComponent.getCode());
            this.composeString("display", profileExtensionDefnComponent.getDisplay());
            if (profileExtensionDefnComponent.getContextType() != null) {
                this.composeEnumeration("contextType", profileExtensionDefnComponent.getContextType(), new Profile.ExtensionContextEnumFactory());
            }
            for (StringType stringType : profileExtensionDefnComponent.getContext()) {
                this.composeString("context", stringType);
            }
            this.composeProfileElementDefinitionComponent("definition", profileExtensionDefnComponent.getDefinition());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProfileProfileQueryComponent(String string, Profile.ProfileQueryComponent profileQueryComponent) throws Exception {
        if (profileQueryComponent != null) {
            this.composeElementAttributes(profileQueryComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(profileQueryComponent);
            this.composeString("name", profileQueryComponent.getName());
            this.composeString("documentation", profileQueryComponent.getDocumentation());
            for (Profile.ProfileStructureSearchParamComponent profileStructureSearchParamComponent : profileQueryComponent.getParameter()) {
                this.composeProfileProfileStructureSearchParamComponent("parameter", profileStructureSearchParamComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProvenance(String string, Provenance provenance) throws Exception {
        if (provenance != null) {
            this.composeResourceAttributes(provenance);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(provenance);
            for (ResourceReference element : provenance.getTarget()) {
                this.composeResourceReference("target", element);
            }
            this.composePeriod("period", provenance.getPeriod());
            this.composeInstant("recorded", provenance.getRecorded());
            this.composeCodeableConcept("reason", provenance.getReason());
            this.composeResourceReference("location", provenance.getLocation());
            for (UriType uriType : provenance.getPolicy()) {
                this.composeUri("policy", uriType);
            }
            for (Provenance.ProvenanceAgentComponent provenanceAgentComponent : provenance.getAgent()) {
                this.composeProvenanceProvenanceAgentComponent("agent", provenanceAgentComponent);
            }
            for (Provenance.ProvenanceEntityComponent provenanceEntityComponent : provenance.getEntity()) {
                this.composeProvenanceProvenanceEntityComponent("entity", provenanceEntityComponent);
            }
            this.composeString("integritySignature", provenance.getIntegritySignature());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProvenanceProvenanceAgentComponent(String string, Provenance.ProvenanceAgentComponent provenanceAgentComponent) throws Exception {
        if (provenanceAgentComponent != null) {
            this.composeElementAttributes(provenanceAgentComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(provenanceAgentComponent);
            this.composeCoding("role", provenanceAgentComponent.getRole());
            this.composeCoding("type", provenanceAgentComponent.getType());
            this.composeUri("reference", provenanceAgentComponent.getReference());
            this.composeString("display", provenanceAgentComponent.getDisplay());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeProvenanceProvenanceEntityComponent(String string, Provenance.ProvenanceEntityComponent provenanceEntityComponent) throws Exception {
        if (provenanceEntityComponent != null) {
            this.composeElementAttributes(provenanceEntityComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(provenanceEntityComponent);
            if (provenanceEntityComponent.getRole() != null) {
                this.composeEnumeration("role", provenanceEntityComponent.getRole(), new Provenance.ProvenanceEntityRoleEnumFactory());
            }
            this.composeCoding("type", provenanceEntityComponent.getType());
            this.composeUri("reference", provenanceEntityComponent.getReference());
            this.composeString("display", provenanceEntityComponent.getDisplay());
            this.composeProvenanceProvenanceAgentComponent("agent", provenanceEntityComponent.getAgent());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeQuery(String string, Query query) throws Exception {
        if (query != null) {
            this.composeResourceAttributes(query);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(query);
            this.composeUri("identifier", query.getIdentifier());
            for (Extension extension : query.getParameter()) {
                this.composeExtension("parameter", extension);
            }
            this.composeQueryQueryResponseComponent("response", query.getResponse());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeQueryQueryResponseComponent(String string, Query.QueryResponseComponent queryResponseComponent) throws Exception {
        if (queryResponseComponent != null) {
            this.composeElementAttributes(queryResponseComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(queryResponseComponent);
            this.composeUri("identifier", queryResponseComponent.getIdentifier());
            if (queryResponseComponent.getOutcome() != null) {
                this.composeEnumeration("outcome", queryResponseComponent.getOutcome(), new Query.QueryOutcomeEnumFactory());
            }
            this.composeInteger("total", queryResponseComponent.getTotal());
            for (Extension element : queryResponseComponent.getParameter()) {
                this.composeExtension("parameter", element);
            }
            for (Extension extension : queryResponseComponent.getFirst()) {
                this.composeExtension("first", extension);
            }
            for (Extension extension : queryResponseComponent.getPrevious()) {
                this.composeExtension("previous", extension);
            }
            for (Extension extension : queryResponseComponent.getNext()) {
                this.composeExtension("next", extension);
            }
            for (Extension extension : queryResponseComponent.getLast()) {
                this.composeExtension("last", extension);
            }
            for (ResourceReference resourceReference : queryResponseComponent.getReference()) {
                this.composeResourceReference("reference", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeQuestionnaire(String string, Questionnaire questionnaire) throws Exception {
        if (questionnaire != null) {
            this.composeResourceAttributes(questionnaire);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(questionnaire);
            if (questionnaire.getStatus() != null) {
                this.composeEnumeration("status", questionnaire.getStatus(), new Questionnaire.QuestionnaireStatusEnumFactory());
            }
            this.composeDateTime("authored", questionnaire.getAuthored());
            this.composeResourceReference("subject", questionnaire.getSubject());
            this.composeResourceReference("author", questionnaire.getAuthor());
            this.composeResourceReference("source", questionnaire.getSource());
            this.composeCodeableConcept("name", questionnaire.getName());
            for (Identifier identifier : questionnaire.getIdentifier()) {
                this.composeIdentifier("identifier", identifier);
            }
            this.composeResourceReference("encounter", questionnaire.getEncounter());
            this.composeQuestionnaireGroupComponent("group", questionnaire.getGroup());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeQuestionnaireGroupComponent(String string, Questionnaire.GroupComponent groupComponent) throws Exception {
        if (groupComponent != null) {
            this.composeElementAttributes(groupComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(groupComponent);
            this.composeCodeableConcept("name", groupComponent.getName());
            this.composeString("header", groupComponent.getHeader());
            this.composeString("text", groupComponent.getText());
            this.composeResourceReference("subject", groupComponent.getSubject());
            for (Questionnaire.GroupComponent backboneElement : groupComponent.getGroup()) {
                this.composeQuestionnaireGroupComponent("group", backboneElement);
            }
            for (Questionnaire.QuestionComponent questionComponent : groupComponent.getQuestion()) {
                this.composeQuestionnaireQuestionComponent("question", questionComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeQuestionnaireQuestionComponent(String string, Questionnaire.QuestionComponent questionComponent) throws Exception {
        if (questionComponent != null) {
            this.composeElementAttributes(questionComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(questionComponent);
            this.composeCodeableConcept("name", questionComponent.getName());
            this.composeString("text", questionComponent.getText());
            this.composeType("answer", questionComponent.getAnswer());
            for (Coding element : questionComponent.getChoice()) {
                this.composeCoding("choice", element);
            }
            this.composeResourceReference("options", questionComponent.getOptions());
            this.composeType("data", questionComponent.getData());
            this.composeString("remarks", questionComponent.getRemarks());
            for (Questionnaire.GroupComponent groupComponent : questionComponent.getGroup()) {
                this.composeQuestionnaireGroupComponent("group", groupComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeRelatedPerson(String string, RelatedPerson relatedPerson) throws Exception {
        if (relatedPerson != null) {
            this.composeResourceAttributes(relatedPerson);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(relatedPerson);
            for (Identifier type : relatedPerson.getIdentifier()) {
                this.composeIdentifier("identifier", type);
            }
            this.composeResourceReference("patient", relatedPerson.getPatient());
            this.composeCodeableConcept("relationship", relatedPerson.getRelationship());
            this.composeHumanName("name", relatedPerson.getName());
            for (Contact contact : relatedPerson.getTelecom()) {
                this.composeContact("telecom", contact);
            }
            this.composeCodeableConcept("gender", relatedPerson.getGender());
            this.composeAddress("address", relatedPerson.getAddress());
            for (Attachment attachment : relatedPerson.getPhoto()) {
                this.composeAttachment("photo", attachment);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSecurityEvent(String string, SecurityEvent securityEvent) throws Exception {
        if (securityEvent != null) {
            this.composeResourceAttributes(securityEvent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(securityEvent);
            this.composeSecurityEventSecurityEventEventComponent("event", securityEvent.getEvent());
            for (SecurityEvent.SecurityEventParticipantComponent backboneElement : securityEvent.getParticipant()) {
                this.composeSecurityEventSecurityEventParticipantComponent("participant", backboneElement);
            }
            this.composeSecurityEventSecurityEventSourceComponent("source", securityEvent.getSource());
            for (SecurityEvent.SecurityEventObjectComponent securityEventObjectComponent : securityEvent.getObject()) {
                this.composeSecurityEventSecurityEventObjectComponent("object", securityEventObjectComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSecurityEventSecurityEventEventComponent(String string, SecurityEvent.SecurityEventEventComponent securityEventEventComponent) throws Exception {
        if (securityEventEventComponent != null) {
            this.composeElementAttributes(securityEventEventComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(securityEventEventComponent);
            this.composeCodeableConcept("type", securityEventEventComponent.getType());
            for (CodeableConcept codeableConcept : securityEventEventComponent.getSubtype()) {
                this.composeCodeableConcept("subtype", codeableConcept);
            }
            if (securityEventEventComponent.getAction() != null) {
                this.composeEnumeration("action", securityEventEventComponent.getAction(), new SecurityEvent.SecurityEventActionEnumFactory());
            }
            this.composeInstant("dateTime", securityEventEventComponent.getDateTime());
            if (securityEventEventComponent.getOutcome() != null) {
                this.composeEnumeration("outcome", securityEventEventComponent.getOutcome(), new SecurityEvent.SecurityEventOutcomeEnumFactory());
            }
            this.composeString("outcomeDesc", securityEventEventComponent.getOutcomeDesc());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSecurityEventSecurityEventParticipantComponent(String string, SecurityEvent.SecurityEventParticipantComponent securityEventParticipantComponent) throws Exception {
        if (securityEventParticipantComponent != null) {
            this.composeElementAttributes(securityEventParticipantComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(securityEventParticipantComponent);
            for (CodeableConcept codeableConcept : securityEventParticipantComponent.getRole()) {
                this.composeCodeableConcept("role", codeableConcept);
            }
            this.composeResourceReference("reference", securityEventParticipantComponent.getReference());
            this.composeString("userId", securityEventParticipantComponent.getUserId());
            this.composeString("altId", securityEventParticipantComponent.getAltId());
            this.composeString("name", securityEventParticipantComponent.getName());
            this.composeBoolean("requestor", securityEventParticipantComponent.getRequestor());
            this.composeCoding("media", securityEventParticipantComponent.getMedia());
            this.composeSecurityEventSecurityEventParticipantNetworkComponent("network", securityEventParticipantComponent.getNetwork());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSecurityEventSecurityEventParticipantNetworkComponent(String string, SecurityEvent.SecurityEventParticipantNetworkComponent securityEventParticipantNetworkComponent) throws Exception {
        if (securityEventParticipantNetworkComponent != null) {
            this.composeElementAttributes(securityEventParticipantNetworkComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(securityEventParticipantNetworkComponent);
            this.composeString("identifier", securityEventParticipantNetworkComponent.getIdentifier());
            if (securityEventParticipantNetworkComponent.getType() != null) {
                this.composeEnumeration("type", securityEventParticipantNetworkComponent.getType(), new SecurityEvent.NetworkTypeEnumFactory());
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSecurityEventSecurityEventSourceComponent(String string, SecurityEvent.SecurityEventSourceComponent securityEventSourceComponent) throws Exception {
        if (securityEventSourceComponent != null) {
            this.composeElementAttributes(securityEventSourceComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(securityEventSourceComponent);
            this.composeString("site", securityEventSourceComponent.getSite());
            this.composeString("identifier", securityEventSourceComponent.getIdentifier());
            for (Coding coding : securityEventSourceComponent.getType()) {
                this.composeCoding("type", coding);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSecurityEventSecurityEventObjectComponent(String string, SecurityEvent.SecurityEventObjectComponent securityEventObjectComponent) throws Exception {
        if (securityEventObjectComponent != null) {
            this.composeElementAttributes(securityEventObjectComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(securityEventObjectComponent);
            this.composeIdentifier("identifier", securityEventObjectComponent.getIdentifier());
            this.composeResourceReference("reference", securityEventObjectComponent.getReference());
            if (securityEventObjectComponent.getType() != null) {
                this.composeEnumeration("type", securityEventObjectComponent.getType(), new SecurityEvent.ObjectTypeEnumFactory());
            }
            if (securityEventObjectComponent.getRole() != null) {
                this.composeEnumeration("role", securityEventObjectComponent.getRole(), new SecurityEvent.ObjectRoleEnumFactory());
            }
            if (securityEventObjectComponent.getLifecycle() != null) {
                this.composeEnumeration("lifecycle", securityEventObjectComponent.getLifecycle(), new SecurityEvent.ObjectLifecycleEnumFactory());
            }
            this.composeCodeableConcept("sensitivity", securityEventObjectComponent.getSensitivity());
            this.composeString("name", securityEventObjectComponent.getName());
            this.composeString("description", securityEventObjectComponent.getDescription());
            this.composeBase64Binary("query", securityEventObjectComponent.getQuery());
            for (SecurityEvent.SecurityEventObjectDetailComponent securityEventObjectDetailComponent : securityEventObjectComponent.getDetail()) {
                this.composeSecurityEventSecurityEventObjectDetailComponent("detail", securityEventObjectDetailComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSecurityEventSecurityEventObjectDetailComponent(String string, SecurityEvent.SecurityEventObjectDetailComponent securityEventObjectDetailComponent) throws Exception {
        if (securityEventObjectDetailComponent != null) {
            this.composeElementAttributes(securityEventObjectDetailComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(securityEventObjectDetailComponent);
            this.composeString("type", securityEventObjectDetailComponent.getType());
            this.composeBase64Binary("value", securityEventObjectDetailComponent.getValue());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSpecimen(String string, Specimen specimen) throws Exception {
        if (specimen != null) {
            this.composeResourceAttributes(specimen);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(specimen);
            for (Identifier element : specimen.getIdentifier()) {
                this.composeIdentifier("identifier", element);
            }
            this.composeCodeableConcept("type", specimen.getType());
            for (Specimen.SpecimenSourceComponent specimenSourceComponent : specimen.getSource()) {
                this.composeSpecimenSpecimenSourceComponent("source", specimenSourceComponent);
            }
            this.composeResourceReference("subject", specimen.getSubject());
            this.composeIdentifier("accessionIdentifier", specimen.getAccessionIdentifier());
            this.composeDateTime("receivedTime", specimen.getReceivedTime());
            this.composeSpecimenSpecimenCollectionComponent("collection", specimen.getCollection());
            for (Specimen.SpecimenTreatmentComponent specimenTreatmentComponent : specimen.getTreatment()) {
                this.composeSpecimenSpecimenTreatmentComponent("treatment", specimenTreatmentComponent);
            }
            for (Specimen.SpecimenContainerComponent specimenContainerComponent : specimen.getContainer()) {
                this.composeSpecimenSpecimenContainerComponent("container", specimenContainerComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSpecimenSpecimenSourceComponent(String string, Specimen.SpecimenSourceComponent specimenSourceComponent) throws Exception {
        if (specimenSourceComponent != null) {
            this.composeElementAttributes(specimenSourceComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(specimenSourceComponent);
            if (specimenSourceComponent.getRelationship() != null) {
                this.composeEnumeration("relationship", specimenSourceComponent.getRelationship(), new Specimen.HierarchicalRelationshipTypeEnumFactory());
            }
            for (ResourceReference resourceReference : specimenSourceComponent.getTarget()) {
                this.composeResourceReference("target", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSpecimenSpecimenCollectionComponent(String string, Specimen.SpecimenCollectionComponent specimenCollectionComponent) throws Exception {
        if (specimenCollectionComponent != null) {
            this.composeElementAttributes(specimenCollectionComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(specimenCollectionComponent);
            this.composeResourceReference("collector", specimenCollectionComponent.getCollector());
            for (StringType stringType : specimenCollectionComponent.getComment()) {
                this.composeString("comment", stringType);
            }
            this.composeType("collected", specimenCollectionComponent.getCollected());
            this.composeQuantity("quantity", specimenCollectionComponent.getQuantity());
            this.composeCodeableConcept("method", specimenCollectionComponent.getMethod());
            this.composeCodeableConcept("sourceSite", specimenCollectionComponent.getSourceSite());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSpecimenSpecimenTreatmentComponent(String string, Specimen.SpecimenTreatmentComponent specimenTreatmentComponent) throws Exception {
        if (specimenTreatmentComponent != null) {
            this.composeElementAttributes(specimenTreatmentComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(specimenTreatmentComponent);
            this.composeString("description", specimenTreatmentComponent.getDescription());
            this.composeCodeableConcept("procedure", specimenTreatmentComponent.getProcedure());
            for (ResourceReference resourceReference : specimenTreatmentComponent.getAdditive()) {
                this.composeResourceReference("additive", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSpecimenSpecimenContainerComponent(String string, Specimen.SpecimenContainerComponent specimenContainerComponent) throws Exception {
        if (specimenContainerComponent != null) {
            this.composeElementAttributes(specimenContainerComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(specimenContainerComponent);
            for (Identifier identifier : specimenContainerComponent.getIdentifier()) {
                this.composeIdentifier("identifier", identifier);
            }
            this.composeString("description", specimenContainerComponent.getDescription());
            this.composeCodeableConcept("type", specimenContainerComponent.getType());
            this.composeQuantity("capacity", specimenContainerComponent.getCapacity());
            this.composeQuantity("specimenQuantity", specimenContainerComponent.getSpecimenQuantity());
            this.composeResourceReference("additive", specimenContainerComponent.getAdditive());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSubstance(String string, Substance substance) throws Exception {
        if (substance != null) {
            this.composeResourceAttributes(substance);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(substance);
            this.composeCodeableConcept("type", substance.getType());
            this.composeString("description", substance.getDescription());
            this.composeSubstanceSubstanceInstanceComponent("instance", substance.getInstance());
            for (Substance.SubstanceIngredientComponent substanceIngredientComponent : substance.getIngredient()) {
                this.composeSubstanceSubstanceIngredientComponent("ingredient", substanceIngredientComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSubstanceSubstanceInstanceComponent(String string, Substance.SubstanceInstanceComponent substanceInstanceComponent) throws Exception {
        if (substanceInstanceComponent != null) {
            this.composeElementAttributes(substanceInstanceComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(substanceInstanceComponent);
            this.composeIdentifier("identifier", substanceInstanceComponent.getIdentifier());
            this.composeDateTime("expiry", substanceInstanceComponent.getExpiry());
            this.composeQuantity("quantity", substanceInstanceComponent.getQuantity());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSubstanceSubstanceIngredientComponent(String string, Substance.SubstanceIngredientComponent substanceIngredientComponent) throws Exception {
        if (substanceIngredientComponent != null) {
            this.composeElementAttributes(substanceIngredientComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(substanceIngredientComponent);
            this.composeRatio("quantity", substanceIngredientComponent.getQuantity());
            this.composeResourceReference("substance", substanceIngredientComponent.getSubstance());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSupply(String string, Supply supply) throws Exception {
        if (supply != null) {
            this.composeResourceAttributes(supply);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(supply);
            this.composeCodeableConcept("kind", supply.getKind());
            this.composeIdentifier("identifier", supply.getIdentifier());
            if (supply.getStatus() != null) {
                this.composeEnumeration("status", supply.getStatus(), new Supply.ValuesetSupplyStatusEnumFactory());
            }
            this.composeResourceReference("orderedItem", supply.getOrderedItem());
            this.composeResourceReference("patient", supply.getPatient());
            for (Supply.SupplyDispenseComponent supplyDispenseComponent : supply.getDispense()) {
                this.composeSupplySupplyDispenseComponent("dispense", supplyDispenseComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeSupplySupplyDispenseComponent(String string, Supply.SupplyDispenseComponent supplyDispenseComponent) throws Exception {
        if (supplyDispenseComponent != null) {
            this.composeElementAttributes(supplyDispenseComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(supplyDispenseComponent);
            this.composeIdentifier("identifier", supplyDispenseComponent.getIdentifier());
            if (supplyDispenseComponent.getStatus() != null) {
                this.composeEnumeration("status", supplyDispenseComponent.getStatus(), new Supply.ValuesetSupplyDispenseStatusEnumFactory());
            }
            this.composeCodeableConcept("type", supplyDispenseComponent.getType());
            this.composeQuantity("quantity", supplyDispenseComponent.getQuantity());
            this.composeResourceReference("suppliedItem", supplyDispenseComponent.getSuppliedItem());
            this.composeResourceReference("supplier", supplyDispenseComponent.getSupplier());
            this.composePeriod("whenPrepared", supplyDispenseComponent.getWhenPrepared());
            this.composePeriod("whenHandedOver", supplyDispenseComponent.getWhenHandedOver());
            this.composeResourceReference("destination", supplyDispenseComponent.getDestination());
            for (ResourceReference resourceReference : supplyDispenseComponent.getReceiver()) {
                this.composeResourceReference("receiver", resourceReference);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeValueSet(String string, ValueSet valueSet) throws Exception {
        if (valueSet != null) {
            this.composeResourceAttributes(valueSet);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeResourceElements(valueSet);
            this.composeString("identifier", valueSet.getIdentifier());
            this.composeString("version", valueSet.getVersion());
            this.composeString("name", valueSet.getName());
            this.composeString("publisher", valueSet.getPublisher());
            for (Contact contact : valueSet.getTelecom()) {
                this.composeContact("telecom", contact);
            }
            this.composeString("description", valueSet.getDescription());
            this.composeString("copyright", valueSet.getCopyright());
            if (valueSet.getStatus() != null) {
                this.composeEnumeration("status", valueSet.getStatus(), new ValueSet.ValuesetStatusEnumFactory());
            }
            this.composeBoolean("experimental", valueSet.getExperimental());
            this.composeBoolean("extensible", valueSet.getExtensible());
            this.composeDateTime("date", valueSet.getDate());
            this.composeValueSetValueSetDefineComponent("define", valueSet.getDefine());
            this.composeValueSetValueSetComposeComponent("compose", valueSet.getCompose());
            this.composeValueSetValueSetExpansionComponent("expansion", valueSet.getExpansion());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeValueSetValueSetDefineComponent(String string, ValueSet.ValueSetDefineComponent valueSetDefineComponent) throws Exception {
        if (valueSetDefineComponent != null) {
            this.composeElementAttributes(valueSetDefineComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(valueSetDefineComponent);
            this.composeUri("system", valueSetDefineComponent.getSystem());
            this.composeString("version", valueSetDefineComponent.getVersion());
            this.composeBoolean("caseSensitive", valueSetDefineComponent.getCaseSensitive());
            for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent : valueSetDefineComponent.getConcept()) {
                this.composeValueSetValueSetDefineConceptComponent("concept", valueSetDefineConceptComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeValueSetValueSetDefineConceptComponent(String string, ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent) throws Exception {
        if (valueSetDefineConceptComponent != null) {
            this.composeElementAttributes(valueSetDefineConceptComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(valueSetDefineConceptComponent);
            this.composeCode("code", valueSetDefineConceptComponent.getCode());
            this.composeBoolean("abstract", valueSetDefineConceptComponent.getAbstract());
            this.composeString("display", valueSetDefineConceptComponent.getDisplay());
            this.composeString("definition", valueSetDefineConceptComponent.getDefinition());
            for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent2 : valueSetDefineConceptComponent.getConcept()) {
                this.composeValueSetValueSetDefineConceptComponent("concept", valueSetDefineConceptComponent2);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeValueSetValueSetComposeComponent(String string, ValueSet.ValueSetComposeComponent valueSetComposeComponent) throws Exception {
        if (valueSetComposeComponent != null) {
            this.composeElementAttributes(valueSetComposeComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(valueSetComposeComponent);
            for (UriType element : valueSetComposeComponent.getImport()) {
                this.composeUri("import", element);
            }
            for (ValueSet.ConceptSetComponent conceptSetComponent : valueSetComposeComponent.getInclude()) {
                this.composeValueSetConceptSetComponent("include", conceptSetComponent);
            }
            for (ValueSet.ConceptSetComponent conceptSetComponent : valueSetComposeComponent.getExclude()) {
                this.composeValueSetConceptSetComponent("exclude", conceptSetComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeValueSetConceptSetComponent(String string, ValueSet.ConceptSetComponent conceptSetComponent) throws Exception {
        if (conceptSetComponent != null) {
            this.composeElementAttributes(conceptSetComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conceptSetComponent);
            this.composeUri("system", conceptSetComponent.getSystem());
            this.composeString("version", conceptSetComponent.getVersion());
            for (CodeType element : conceptSetComponent.getCode()) {
                this.composeCode("code", element);
            }
            for (ValueSet.ConceptSetFilterComponent conceptSetFilterComponent : conceptSetComponent.getFilter()) {
                this.composeValueSetConceptSetFilterComponent("filter", conceptSetFilterComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeValueSetConceptSetFilterComponent(String string, ValueSet.ConceptSetFilterComponent conceptSetFilterComponent) throws Exception {
        if (conceptSetFilterComponent != null) {
            this.composeElementAttributes(conceptSetFilterComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(conceptSetFilterComponent);
            this.composeCode("property", conceptSetFilterComponent.getProperty());
            if (conceptSetFilterComponent.getOp() != null) {
                this.composeEnumeration("op", conceptSetFilterComponent.getOp(), new ValueSet.FilterOperatorEnumFactory());
            }
            this.composeCode("value", conceptSetFilterComponent.getValue());
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeValueSetValueSetExpansionComponent(String string, ValueSet.ValueSetExpansionComponent valueSetExpansionComponent) throws Exception {
        if (valueSetExpansionComponent != null) {
            this.composeElementAttributes(valueSetExpansionComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(valueSetExpansionComponent);
            this.composeIdentifier("identifier", valueSetExpansionComponent.getIdentifier());
            this.composeInstant("timestamp", valueSetExpansionComponent.getTimestamp());
            for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : valueSetExpansionComponent.getContains()) {
                this.composeValueSetValueSetExpansionContainsComponent("contains", valueSetExpansionContainsComponent);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    private void composeValueSetValueSetExpansionContainsComponent(String string, ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent) throws Exception {
        if (valueSetExpansionContainsComponent != null) {
            this.composeElementAttributes(valueSetExpansionContainsComponent);
            this.xml.open("http://hl7.org/fhir", string);
            this.composeBackboneElements(valueSetExpansionContainsComponent);
            this.composeUri("system", valueSetExpansionContainsComponent.getSystem());
            this.composeCode("code", valueSetExpansionContainsComponent.getCode());
            this.composeString("display", valueSetExpansionContainsComponent.getDisplay());
            for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent2 : valueSetExpansionContainsComponent.getContains()) {
                this.composeValueSetValueSetExpansionContainsComponent("contains", valueSetExpansionContainsComponent2);
            }
            this.xml.close("http://hl7.org/fhir", string);
        }
    }

    @Override
    protected void composeResource(Resource resource) throws Exception {
        if (resource instanceof AdverseReaction) {
            this.composeAdverseReaction("AdverseReaction", (AdverseReaction)resource);
        } else if (resource instanceof Alert) {
            this.composeAlert("Alert", (Alert)resource);
        } else if (resource instanceof AllergyIntolerance) {
            this.composeAllergyIntolerance("AllergyIntolerance", (AllergyIntolerance)resource);
        } else if (resource instanceof CarePlan) {
            this.composeCarePlan("CarePlan", (CarePlan)resource);
        } else if (resource instanceof Composition) {
            this.composeComposition("Composition", (Composition)resource);
        } else if (resource instanceof ConceptMap) {
            this.composeConceptMap("ConceptMap", (ConceptMap)resource);
        } else if (resource instanceof Condition) {
            this.composeCondition("Condition", (Condition)resource);
        } else if (resource instanceof Conformance) {
            this.composeConformance("Conformance", (Conformance)resource);
        } else if (resource instanceof Device) {
            this.composeDevice("Device", (Device)resource);
        } else if (resource instanceof DeviceObservationReport) {
            this.composeDeviceObservationReport("DeviceObservationReport", (DeviceObservationReport)resource);
        } else if (resource instanceof DiagnosticOrder) {
            this.composeDiagnosticOrder("DiagnosticOrder", (DiagnosticOrder)resource);
        } else if (resource instanceof DiagnosticReport) {
            this.composeDiagnosticReport("DiagnosticReport", (DiagnosticReport)resource);
        } else if (resource instanceof DocumentManifest) {
            this.composeDocumentManifest("DocumentManifest", (DocumentManifest)resource);
        } else if (resource instanceof DocumentReference) {
            this.composeDocumentReference("DocumentReference", (DocumentReference)resource);
        } else if (resource instanceof Encounter) {
            this.composeEncounter("Encounter", (Encounter)resource);
        } else if (resource instanceof FamilyHistory) {
            this.composeFamilyHistory("FamilyHistory", (FamilyHistory)resource);
        } else if (resource instanceof Group) {
            this.composeGroup("Group", (Group)resource);
        } else if (resource instanceof ImagingStudy) {
            this.composeImagingStudy("ImagingStudy", (ImagingStudy)resource);
        } else if (resource instanceof Immunization) {
            this.composeImmunization("Immunization", (Immunization)resource);
        } else if (resource instanceof ImmunizationRecommendation) {
            this.composeImmunizationRecommendation("ImmunizationRecommendation", (ImmunizationRecommendation)resource);
        } else if (resource instanceof List_) {
            this.composeList_("List", (List_)resource);
        } else if (resource instanceof Location) {
            this.composeLocation("Location", (Location)resource);
        } else if (resource instanceof Media) {
            this.composeMedia("Media", (Media)resource);
        } else if (resource instanceof Medication) {
            this.composeMedication("Medication", (Medication)resource);
        } else if (resource instanceof MedicationAdministration) {
            this.composeMedicationAdministration("MedicationAdministration", (MedicationAdministration)resource);
        } else if (resource instanceof MedicationDispense) {
            this.composeMedicationDispense("MedicationDispense", (MedicationDispense)resource);
        } else if (resource instanceof MedicationPrescription) {
            this.composeMedicationPrescription("MedicationPrescription", (MedicationPrescription)resource);
        } else if (resource instanceof MedicationStatement) {
            this.composeMedicationStatement("MedicationStatement", (MedicationStatement)resource);
        } else if (resource instanceof MessageHeader) {
            this.composeMessageHeader("MessageHeader", (MessageHeader)resource);
        } else if (resource instanceof Observation) {
            this.composeObservation("Observation", (Observation)resource);
        } else if (resource instanceof OperationOutcome) {
            this.composeOperationOutcome("OperationOutcome", (OperationOutcome)resource);
        } else if (resource instanceof Order) {
            this.composeOrder("Order", (Order)resource);
        } else if (resource instanceof OrderResponse) {
            this.composeOrderResponse("OrderResponse", (OrderResponse)resource);
        } else if (resource instanceof Organization) {
            this.composeOrganization("Organization", (Organization)resource);
        } else if (resource instanceof Other) {
            this.composeOther("Other", (Other)resource);
        } else if (resource instanceof Patient) {
            this.composePatient("Patient", (Patient)resource);
        } else if (resource instanceof Practitioner) {
            this.composePractitioner("Practitioner", (Practitioner)resource);
        } else if (resource instanceof Procedure) {
            this.composeProcedure("Procedure", (Procedure)resource);
        } else if (resource instanceof Profile) {
            this.composeProfile("Profile", (Profile)resource);
        } else if (resource instanceof Provenance) {
            this.composeProvenance("Provenance", (Provenance)resource);
        } else if (resource instanceof Query) {
            this.composeQuery("Query", (Query)resource);
        } else if (resource instanceof Questionnaire) {
            this.composeQuestionnaire("Questionnaire", (Questionnaire)resource);
        } else if (resource instanceof RelatedPerson) {
            this.composeRelatedPerson("RelatedPerson", (RelatedPerson)resource);
        } else if (resource instanceof SecurityEvent) {
            this.composeSecurityEvent("SecurityEvent", (SecurityEvent)resource);
        } else if (resource instanceof Specimen) {
            this.composeSpecimen("Specimen", (Specimen)resource);
        } else if (resource instanceof Substance) {
            this.composeSubstance("Substance", (Substance)resource);
        } else if (resource instanceof Supply) {
            this.composeSupply("Supply", (Supply)resource);
        } else if (resource instanceof ValueSet) {
            this.composeValueSet("ValueSet", (ValueSet)resource);
        } else if (resource instanceof Binary) {
            this.composeBinary("Binary", (Binary)resource);
        } else {
            throw new Exception("Unhanded resource type " + resource.getClass().getName());
        }
    }

    @Override
    protected void composeType(String string, Type type) throws Exception {
        if (type != null) {
            if (type instanceof Age) {
                this.composeAge(string + "Age", (Age)type);
            } else if (type instanceof Count) {
                this.composeCount(string + "Count", (Count)type);
            } else if (type instanceof Money) {
                this.composeMoney(string + "Money", (Money)type);
            } else if (type instanceof Distance) {
                this.composeDistance(string + "Distance", (Distance)type);
            } else if (type instanceof Duration) {
                this.composeDuration(string + "Duration", (Duration)type);
            } else if (type instanceof Period) {
                this.composePeriod(string + "Period", (Period)type);
            } else if (type instanceof Coding) {
                this.composeCoding(string + "Coding", (Coding)type);
            } else if (type instanceof Range) {
                this.composeRange(string + "Range", (Range)type);
            } else if (type instanceof Quantity) {
                this.composeQuantity(string + "Quantity", (Quantity)type);
            } else if (type instanceof Attachment) {
                this.composeAttachment(string + "Attachment", (Attachment)type);
            } else if (type instanceof Ratio) {
                this.composeRatio(string + "Ratio", (Ratio)type);
            } else if (type instanceof SampledData) {
                this.composeSampledData(string + "SampledData", (SampledData)type);
            } else if (type instanceof ResourceReference) {
                this.composeResourceReference(string + "Resource", (ResourceReference)type);
            } else if (type instanceof CodeableConcept) {
                this.composeCodeableConcept(string + "CodeableConcept", (CodeableConcept)type);
            } else if (type instanceof Identifier) {
                this.composeIdentifier(string + "Identifier", (Identifier)type);
            } else if (type instanceof Schedule) {
                this.composeSchedule(string + "Schedule", (Schedule)type);
            } else if (type instanceof Contact) {
                this.composeContact(string + "Contact", (Contact)type);
            } else if (type instanceof Address) {
                this.composeAddress(string + "Address", (Address)type);
            } else if (type instanceof HumanName) {
                this.composeHumanName(string + "HumanName", (HumanName)type);
            } else if (type instanceof IdType) {
                this.composeId(string + "Id", (IdType)type);
            } else if (type instanceof Base64BinaryType) {
                this.composeBase64Binary(string + "Base64Binary", (Base64BinaryType)type);
            } else if (type instanceof DateTimeType) {
                this.composeDateTime(string + "DateTime", (DateTimeType)type);
            } else if (type instanceof IntegerType) {
                this.composeInteger(string + "Integer", (IntegerType)type);
            } else if (type instanceof OidType) {
                this.composeOid(string + "Oid", (OidType)type);
            } else if (type instanceof StringType) {
                this.composeString(string + "String", (StringType)type);
            } else if (type instanceof BooleanType) {
                this.composeBoolean(string + "Boolean", (BooleanType)type);
            } else if (type instanceof UuidType) {
                this.composeUuid(string + "Uuid", (UuidType)type);
            } else if (type instanceof CodeType) {
                this.composeCode(string + "Code", (CodeType)type);
            } else if (type instanceof DateType) {
                this.composeDate(string + "Date", (DateType)type);
            } else if (type instanceof UriType) {
                this.composeUri(string + "Uri", (UriType)type);
            } else if (type instanceof InstantType) {
                this.composeInstant(string + "Instant", (InstantType)type);
            } else if (type instanceof DecimalType) {
                this.composeDecimal(string + "Decimal", (DecimalType)type);
            } else {
                throw new Exception("Unhanded type");
            }
        }
    }
}

