/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.formats;

import java.io.OutputStream;
import java.util.List;
import org.hl7.fhir.instance.formats.ComposerBase;
import org.hl7.fhir.instance.model.AtomCategory;
import org.hl7.fhir.instance.model.AtomEntry;
import org.hl7.fhir.instance.model.AtomFeed;
import org.hl7.fhir.instance.model.Binary;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xml.IXMLWriter;
import org.hl7.fhir.utilities.xml.XMLWriter;

public abstract class XmlComposerBase
extends ComposerBase {
    protected IXMLWriter xml;
    protected boolean htmlPretty;

    @Override
    public void compose(OutputStream outputStream, Resource resource, boolean bl) throws Exception {
        XMLWriter xMLWriter = new XMLWriter(outputStream, "UTF-8");
        xMLWriter.setPretty(bl);
        xMLWriter.start();
        this.compose((IXMLWriter)xMLWriter, resource, bl);
        xMLWriter.close();
    }

    public void compose(OutputStream outputStream, Resource resource, boolean bl, boolean bl2) throws Exception {
        XMLWriter xMLWriter = new XMLWriter(outputStream, "UTF-8");
        xMLWriter.setPretty(bl);
        xMLWriter.start();
        this.compose((IXMLWriter)xMLWriter, resource, bl2);
        xMLWriter.close();
    }

    @Override
    public void compose(OutputStream outputStream, AtomFeed atomFeed, boolean bl) throws Exception {
        XMLWriter xMLWriter = new XMLWriter(outputStream, "UTF-8");
        xMLWriter.setPretty(bl);
        xMLWriter.start();
        this.compose((IXMLWriter)xMLWriter, atomFeed, bl);
        xMLWriter.close();
    }

    public void compose(OutputStream outputStream, AtomFeed atomFeed, boolean bl, boolean bl2) throws Exception {
        XMLWriter xMLWriter = new XMLWriter(outputStream, "UTF-8");
        xMLWriter.setPretty(bl);
        xMLWriter.start();
        this.compose((IXMLWriter)xMLWriter, atomFeed, bl2);
        xMLWriter.close();
    }

    @Override
    public void compose(OutputStream outputStream, List<AtomCategory> list, boolean bl) throws Exception {
        XMLWriter xMLWriter = new XMLWriter(outputStream, "UTF-8");
        xMLWriter.setPretty(bl);
        xMLWriter.start();
        this.compose((IXMLWriter)xMLWriter, list, bl);
        xMLWriter.close();
    }

    public void compose(OutputStream outputStream, List<AtomCategory> list, boolean bl, boolean bl2) throws Exception {
        XMLWriter xMLWriter = new XMLWriter(outputStream, "UTF-8");
        xMLWriter.setPretty(bl);
        xMLWriter.start();
        this.compose((IXMLWriter)xMLWriter, list, bl2);
        xMLWriter.close();
    }

    public void compose(IXMLWriter iXMLWriter, AtomFeed atomFeed, boolean bl) throws Exception {
        this.htmlPretty = bl;
        this.xml = iXMLWriter;
        this.xml.setDefaultNamespace("http://www.w3.org/2005/Atom");
        this.xml.open("http://www.w3.org/2005/Atom", "feed");
        if (atomFeed.getTitle() != null) {
            this.xml.element("http://www.w3.org/2005/Atom", "title", atomFeed.getTitle());
        }
        if (atomFeed.getId() != null) {
            this.xml.element("http://www.w3.org/2005/Atom", "id", atomFeed.getId());
        }
        for (String object : atomFeed.getLinks().keySet()) {
            this.xml.attribute("href", atomFeed.getLinks().get(object));
            this.xml.attribute("rel", object);
            this.xml.element("http://www.w3.org/2005/Atom", "link", null);
        }
        if (atomFeed.getTotalResults() != null) {
            this.xml.setDefaultNamespace("http://a9.com/-/spec/opensearch/1.1/");
            this.xml.element("totalResults", atomFeed.getTotalResults().toString());
            this.xml.setDefaultNamespace("http://www.w3.org/2005/Atom");
        }
        if (atomFeed.getUpdated() != null) {
            this.xml.element("http://www.w3.org/2005/Atom", "updated", atomFeed.getUpdated().toString());
        }
        if (atomFeed.getAuthorName() != null || atomFeed.getAuthorUri() != null) {
            this.xml.open("http://www.w3.org/2005/Atom", "author");
            if (atomFeed.getAuthorName() != null) {
                this.xml.element("http://www.w3.org/2005/Atom", "name", atomFeed.getAuthorName());
            }
            if (atomFeed.getAuthorUri() != null) {
                this.xml.element("http://www.w3.org/2005/Atom", "uri", atomFeed.getAuthorUri());
            }
            this.xml.close("http://www.w3.org/2005/Atom", "author");
        }
        for (AtomCategory atomCategory : atomFeed.getTags()) {
            this.xml.attribute("scheme", atomCategory.getScheme());
            this.xml.attribute("term", atomCategory.getTerm());
            if (!Utilities.noString(atomCategory.getLabel())) {
                this.xml.attribute("label", atomCategory.getLabel());
            }
            this.xml.element("category", null);
        }
        for (AtomEntry atomEntry : atomFeed.getEntryList()) {
            this.composeEntry(atomEntry);
        }
        this.xml.close("http://www.w3.org/2005/Atom", "feed");
    }

    public void compose(OutputStream outputStream, Type type) throws Exception {
        this.xml = new XMLWriter(outputStream, "UTF-8");
        this.xml.setPretty(true);
        this.xml.start();
        this.xml.setDefaultNamespace("http://hl7.org/fhir");
        this.composeType("", type);
        this.xml.close();
    }

    protected abstract void composeType(String var1, Type var2) throws Exception;

    private <T extends Resource> void composeEntry(AtomEntry<T> atomEntry) throws Exception {
        AtomEntry<T> atomEntry2 = atomEntry;
        if (atomEntry.isDeleted()) {
            this.xml.setDefaultNamespace("http://purl.org/atompub/tombstones/1.0");
            this.xml.attribute("ref", atomEntry.getId());
            this.xml.attribute("when", atomEntry.getUpdated().toString());
            this.xml.open("deleted-entry");
            for (String string : atomEntry.getLinks().keySet()) {
                this.xml.attribute("href", atomEntry.getLinks().get(string));
                this.xml.attribute("rel", string);
                this.xml.element("link", null);
            }
            if (atomEntry.getAuthorUri() != null || atomEntry.getAuthorName() != null) {
                this.xml.open("by");
                if (atomEntry.getAuthorName() != null) {
                    this.xml.element("name", atomEntry.getAuthorName());
                }
                if (atomEntry.getAuthorUri() != null) {
                    this.xml.element("uri", atomEntry.getAuthorUri());
                }
                this.xml.close("by");
            }
            this.xml.close("deleted-entry");
            this.xml.setDefaultNamespace("http://www.w3.org/2005/Atom");
        } else {
            this.xml.setDefaultNamespace("http://www.w3.org/2005/Atom");
            this.xml.open("entry");
            if (atomEntry2.getTitle() != null) {
                this.xml.element("http://www.w3.org/2005/Atom", "title", atomEntry2.getTitle());
            }
            if (atomEntry2.getId() != null) {
                this.xml.element("http://www.w3.org/2005/Atom", "id", atomEntry2.getId());
            }
            for (String object : atomEntry2.getLinks().keySet()) {
                this.xml.attribute("href", atomEntry2.getLinks().get(object));
                this.xml.attribute("rel", object);
                this.xml.element("http://www.w3.org/2005/Atom", "link", null);
            }
            if (atomEntry2.getUpdated() != null) {
                this.xml.element("http://www.w3.org/2005/Atom", "updated", atomEntry2.getUpdated().toString());
            }
            if (atomEntry.getAuthorUri() != null || atomEntry.getAuthorName() != null) {
                this.xml.open("author");
                if (atomEntry.getAuthorName() != null) {
                    this.xml.element("name", atomEntry.getAuthorName());
                }
                if (atomEntry.getAuthorUri() != null) {
                    this.xml.element("uri", atomEntry.getAuthorUri());
                }
                this.xml.close("author");
            }
            for (AtomCategory atomCategory : atomEntry.getTags()) {
                this.xml.attribute("scheme", atomCategory.getScheme());
                this.xml.attribute("term", atomCategory.getTerm());
                if (!Utilities.noString(atomCategory.getLabel())) {
                    this.xml.attribute("label", atomCategory.getLabel());
                }
                this.xml.element("category", null);
            }
            if (atomEntry2.getPublished() != null) {
                this.xml.element("http://www.w3.org/2005/Atom", "published", atomEntry2.getPublished().toString());
            }
            this.xml.attribute("type", "text/xml");
            this.xml.open("http://www.w3.org/2005/Atom", "content");
            this.xml.setDefaultNamespace("http://hl7.org/fhir");
            if (atomEntry.getResource() instanceof Binary) {
                this.composeBinary("Binary", (Binary)atomEntry.getResource());
            } else {
                this.composeResource((Resource)atomEntry.getResource());
            }
            this.xml.setDefaultNamespace("http://www.w3.org/2005/Atom");
            this.xml.close("http://www.w3.org/2005/Atom", "content");
            if (atomEntry2.getSummary() != null) {
                this.xml.attribute("type", "xhtml");
                this.xml.open("http://www.w3.org/2005/Atom", "summary");
                this.xml.namespace("http://www.w3.org/1999/xhtml", null);
                boolean bl = this.xml.isPretty();
                this.xml.setPretty(this.htmlPretty);
                new XhtmlComposer().compose(this.xml, atomEntry2.getSummary());
                this.xml.setPretty(bl);
                this.xml.close("http://www.w3.org/2005/Atom", "summary");
            }
            this.xml.close("entry");
        }
    }

    public void compose(IXMLWriter iXMLWriter, Resource resource, boolean bl) throws Exception {
        this.htmlPretty = bl;
        this.xml = iXMLWriter;
        this.xml.setDefaultNamespace("http://hl7.org/fhir");
        this.composeResource(resource);
    }

    public void compose(IXMLWriter iXMLWriter, List<AtomCategory> list, boolean bl) throws Exception {
        this.htmlPretty = bl;
        this.xml = iXMLWriter;
        this.xml.setDefaultNamespace("http://hl7.org/fhir");
        this.xml.open("http://hl7.org/fhir", "taglist");
        for (AtomCategory atomCategory : list) {
            this.xml.attribute("scheme", atomCategory.getScheme());
            this.xml.attribute("term", atomCategory.getTerm());
            if (!Utilities.noString(atomCategory.getLabel())) {
                this.xml.attribute("label", atomCategory.getLabel());
            }
            this.xml.element("category", null);
        }
        this.xml.close("http://hl7.org/fhir", "taglist");
    }

    protected abstract void composeResource(Resource var1) throws Exception;

    protected void composeElementAttributes(Element element) throws Exception {
        for (String string : element.getXmlComments()) {
            this.xml.comment(string, false);
        }
        if (element.getXmlId() != null) {
            this.xml.attribute("id", element.getXmlId());
        }
    }

    protected void composeTypeAttributes(Type type) throws Exception {
        this.composeElementAttributes(type);
    }

    protected void composeXhtml(String string, XhtmlNode xhtmlNode) throws Exception {
        if (!Utilities.noString(this.xhtmlMessage)) {
            this.xml.open("http://www.w3.org/1999/xhtml", string);
            this.xml.comment(this.xhtmlMessage, false);
            this.xml.close("http://www.w3.org/1999/xhtml", string);
        } else {
            XhtmlComposer xhtmlComposer = new XhtmlComposer();
            boolean bl = this.xml.isPretty();
            this.xml.setPretty(this.htmlPretty);
            this.xml.namespace("http://www.w3.org/1999/xhtml", null);
            xhtmlComposer.compose(this.xml, xhtmlNode);
            this.xml.setPretty(bl);
        }
    }

    protected void composeBinary(String string, Binary binary) throws Exception {
        if (binary != null) {
            this.composeElementAttributes(binary);
            this.xml.attribute("contentType", binary.getContentType());
            this.xml.open("http://hl7.org/fhir", string);
            this.xml.text(XmlComposerBase.toString(binary.getContent()));
            this.xml.close("http://hl7.org/fhir", string);
        }
    }
}

