/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.formats;

import org.hl7.fhir.instance.formats.XmlParserBase;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.AdverseReaction;
import org.hl7.fhir.instance.model.Age;
import org.hl7.fhir.instance.model.Alert;
import org.hl7.fhir.instance.model.AllergyIntolerance;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Base64BinaryType;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CarePlan;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.Composition;
import org.hl7.fhir.instance.model.ConceptMap;
import org.hl7.fhir.instance.model.Condition;
import org.hl7.fhir.instance.model.Conformance;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.Count;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.DecimalType;
import org.hl7.fhir.instance.model.Device;
import org.hl7.fhir.instance.model.DeviceObservationReport;
import org.hl7.fhir.instance.model.DiagnosticOrder;
import org.hl7.fhir.instance.model.DiagnosticReport;
import org.hl7.fhir.instance.model.Distance;
import org.hl7.fhir.instance.model.DocumentManifest;
import org.hl7.fhir.instance.model.DocumentReference;
import org.hl7.fhir.instance.model.Duration;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.Encounter;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Extension;
import org.hl7.fhir.instance.model.FamilyHistory;
import org.hl7.fhir.instance.model.Group;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.ImagingStudy;
import org.hl7.fhir.instance.model.Immunization;
import org.hl7.fhir.instance.model.ImmunizationRecommendation;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.List_;
import org.hl7.fhir.instance.model.Location;
import org.hl7.fhir.instance.model.Media;
import org.hl7.fhir.instance.model.Medication;
import org.hl7.fhir.instance.model.MedicationAdministration;
import org.hl7.fhir.instance.model.MedicationDispense;
import org.hl7.fhir.instance.model.MedicationPrescription;
import org.hl7.fhir.instance.model.MedicationStatement;
import org.hl7.fhir.instance.model.MessageHeader;
import org.hl7.fhir.instance.model.Money;
import org.hl7.fhir.instance.model.Narrative;
import org.hl7.fhir.instance.model.Observation;
import org.hl7.fhir.instance.model.OidType;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.Order;
import org.hl7.fhir.instance.model.OrderResponse;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Other;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Procedure;
import org.hl7.fhir.instance.model.Profile;
import org.hl7.fhir.instance.model.Provenance;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Query;
import org.hl7.fhir.instance.model.Questionnaire;
import org.hl7.fhir.instance.model.Range;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.RelatedPerson;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.SampledData;
import org.hl7.fhir.instance.model.Schedule;
import org.hl7.fhir.instance.model.SecurityEvent;
import org.hl7.fhir.instance.model.Specimen;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Substance;
import org.hl7.fhir.instance.model.Supply;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.UuidType;
import org.hl7.fhir.instance.model.ValueSet;
import org.xmlpull.v1.XmlPullParser;

public class XmlParser
extends XmlParserBase {
    public XmlParser() {
    }

    public XmlParser(boolean bl) {
        this.setAllowUnknownContent(bl);
    }

    private boolean parseElementContent(int n, XmlPullParser xmlPullParser, Element element) throws Exception {
        if (n != 2 || !xmlPullParser.getName().equals("extension")) {
            return false;
        }
        element.getExtensions().add(this.parseExtension(xmlPullParser));
        return true;
    }

    private boolean parseBackboneContent(int n, XmlPullParser xmlPullParser, BackboneElement backboneElement) throws Exception {
        if (n != 2 || !xmlPullParser.getName().equals("modifierExtension")) {
            return this.parseElementContent(n, xmlPullParser, backboneElement);
        }
        backboneElement.getModifierExtensions().add(this.parseExtension(xmlPullParser));
        return true;
    }

    private <E extends Enum<E>> Enumeration<E> parseEnumeration(XmlPullParser xmlPullParser, E e, EnumFactory enumFactory) throws Exception {
        Enumeration enumeration = new Enumeration();
        this.parseElementAttributes(xmlPullParser, enumeration);
        enumeration.setValue(enumFactory.fromCode(xmlPullParser.getAttributeValue(null, "value")));
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (!this.parseElementContent(n, xmlPullParser, enumeration)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return enumeration;
    }

    private IdType parseId(XmlPullParser xmlPullParser) throws Exception {
        IdType idType = new IdType();
        this.parseElementAttributes(xmlPullParser, idType);
        idType.setValue(this.parseIdPrimitive(xmlPullParser.getAttributeValue(null, "value")));
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (!this.parseElementContent(n, xmlPullParser, idType)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return idType;
    }

    private Base64BinaryType parseBase64Binary(XmlPullParser xmlPullParser) throws Exception {
        Base64BinaryType base64BinaryType = new Base64BinaryType();
        this.parseElementAttributes(xmlPullParser, base64BinaryType);
        base64BinaryType.setValue(this.parseBase64BinaryPrimitive(xmlPullParser.getAttributeValue(null, "value")));
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (!this.parseElementContent(n, xmlPullParser, base64BinaryType)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return base64BinaryType;
    }

    private DateTimeType parseDateTime(XmlPullParser xmlPullParser) throws Exception {
        DateTimeType dateTimeType = new DateTimeType();
        this.parseElementAttributes(xmlPullParser, dateTimeType);
        dateTimeType.setValue(this.parseDateTimePrimitive(xmlPullParser.getAttributeValue(null, "value")));
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (!this.parseElementContent(n, xmlPullParser, dateTimeType)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return dateTimeType;
    }

    private IntegerType parseInteger(XmlPullParser xmlPullParser) throws Exception {
        IntegerType integerType = new IntegerType();
        this.parseElementAttributes(xmlPullParser, integerType);
        integerType.setValue(this.parseIntegerPrimitive(xmlPullParser.getAttributeValue(null, "value")));
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (!this.parseElementContent(n, xmlPullParser, integerType)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return integerType;
    }

    private OidType parseOid(XmlPullParser xmlPullParser) throws Exception {
        OidType oidType = new OidType();
        this.parseElementAttributes(xmlPullParser, oidType);
        oidType.setValue(this.parseOidPrimitive(xmlPullParser.getAttributeValue(null, "value")));
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (!this.parseElementContent(n, xmlPullParser, oidType)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return oidType;
    }

    private StringType parseString(XmlPullParser xmlPullParser) throws Exception {
        StringType stringType = new StringType();
        this.parseElementAttributes(xmlPullParser, stringType);
        stringType.setValue(this.parseStringPrimitive(xmlPullParser.getAttributeValue(null, "value")));
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (!this.parseElementContent(n, xmlPullParser, stringType)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return stringType;
    }

    private BooleanType parseBoolean(XmlPullParser xmlPullParser) throws Exception {
        BooleanType booleanType = new BooleanType();
        this.parseElementAttributes(xmlPullParser, booleanType);
        booleanType.setValue(this.parseBooleanPrimitive(xmlPullParser.getAttributeValue(null, "value")));
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (!this.parseElementContent(n, xmlPullParser, booleanType)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return booleanType;
    }

    private UuidType parseUuid(XmlPullParser xmlPullParser) throws Exception {
        UuidType uuidType = new UuidType();
        this.parseElementAttributes(xmlPullParser, uuidType);
        uuidType.setValue(this.parseUuidPrimitive(xmlPullParser.getAttributeValue(null, "value")));
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (!this.parseElementContent(n, xmlPullParser, uuidType)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return uuidType;
    }

    private CodeType parseCode(XmlPullParser xmlPullParser) throws Exception {
        CodeType codeType = new CodeType();
        this.parseElementAttributes(xmlPullParser, codeType);
        codeType.setValue(this.parseCodePrimitive(xmlPullParser.getAttributeValue(null, "value")));
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (!this.parseElementContent(n, xmlPullParser, codeType)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return codeType;
    }

    private DateType parseDate(XmlPullParser xmlPullParser) throws Exception {
        DateType dateType = new DateType();
        this.parseElementAttributes(xmlPullParser, dateType);
        dateType.setValue(this.parseDatePrimitive(xmlPullParser.getAttributeValue(null, "value")));
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (!this.parseElementContent(n, xmlPullParser, dateType)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return dateType;
    }

    private UriType parseUri(XmlPullParser xmlPullParser) throws Exception {
        UriType uriType = new UriType();
        this.parseElementAttributes(xmlPullParser, uriType);
        uriType.setValue(this.parseUriPrimitive(xmlPullParser.getAttributeValue(null, "value")));
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (!this.parseElementContent(n, xmlPullParser, uriType)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return uriType;
    }

    private InstantType parseInstant(XmlPullParser xmlPullParser) throws Exception {
        InstantType instantType = new InstantType();
        this.parseElementAttributes(xmlPullParser, instantType);
        instantType.setValue(this.parseInstantPrimitive(xmlPullParser.getAttributeValue(null, "value")));
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (!this.parseElementContent(n, xmlPullParser, instantType)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return instantType;
    }

    private DecimalType parseDecimal(XmlPullParser xmlPullParser) throws Exception {
        DecimalType decimalType = new DecimalType();
        this.parseElementAttributes(xmlPullParser, decimalType);
        decimalType.setValue(this.parseDecimalPrimitive(xmlPullParser.getAttributeValue(null, "value")));
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (!this.parseElementContent(n, xmlPullParser, decimalType)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return decimalType;
    }

    private Extension parseExtension(XmlPullParser xmlPullParser) throws Exception {
        Extension extension = new Extension();
        this.parseElementAttributes(xmlPullParser, extension);
        if (xmlPullParser.getAttributeValue(null, "url") != null) {
            extension.setUrlSimple(xmlPullParser.getAttributeValue(null, "url"));
        }
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && this.nameIsTypeName(xmlPullParser, "value")) {
                extension.setValue(this.parseType("value", xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, extension)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return extension;
    }

    private Narrative parseNarrative(XmlPullParser xmlPullParser) throws Exception {
        Narrative narrative = new Narrative();
        this.parseElementAttributes(xmlPullParser, narrative);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("status")) {
                narrative.setStatus(this.parseEnumeration(xmlPullParser, Narrative.NarrativeStatus.Null, new Narrative.NarrativeStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("div")) {
                narrative.setDiv(this.parseXhtml(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, narrative)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return narrative;
    }

    private Period parsePeriod(XmlPullParser xmlPullParser) throws Exception {
        Period period = new Period();
        this.parseTypeAttributes(xmlPullParser, period);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("start")) {
                period.setStart(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("end")) {
                period.setEnd(this.parseDateTime(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, period)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return period;
    }

    private Coding parseCoding(XmlPullParser xmlPullParser) throws Exception {
        Coding coding = new Coding();
        this.parseTypeAttributes(xmlPullParser, coding);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("system")) {
                coding.setSystem(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("version")) {
                coding.setVersion(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                coding.setCode(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("display")) {
                coding.setDisplay(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("primary")) {
                coding.setPrimary(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("valueSet")) {
                coding.setValueSet(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, coding)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return coding;
    }

    private Range parseRange(XmlPullParser xmlPullParser) throws Exception {
        Range range = new Range();
        this.parseTypeAttributes(xmlPullParser, range);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("low")) {
                range.setLow(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("high")) {
                range.setHigh(this.parseQuantity(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, range)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return range;
    }

    private Quantity parseQuantity(XmlPullParser xmlPullParser) throws Exception {
        Quantity quantity = new Quantity();
        this.parseTypeAttributes(xmlPullParser, quantity);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("value")) {
                quantity.setValue(this.parseDecimal(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("comparator")) {
                quantity.setComparator(this.parseEnumeration(xmlPullParser, Quantity.QuantityComparator.Null, new Quantity.QuantityComparatorEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("units")) {
                quantity.setUnits(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("system")) {
                quantity.setSystem(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                quantity.setCode(this.parseCode(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, quantity)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return quantity;
    }

    private Attachment parseAttachment(XmlPullParser xmlPullParser) throws Exception {
        Attachment attachment = new Attachment();
        this.parseTypeAttributes(xmlPullParser, attachment);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("contentType")) {
                attachment.setContentType(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("language")) {
                attachment.setLanguage(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("data")) {
                attachment.setData(this.parseBase64Binary(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("url")) {
                attachment.setUrl(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("size")) {
                attachment.setSize(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("hash")) {
                attachment.setHash(this.parseBase64Binary(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("title")) {
                attachment.setTitle(this.parseString(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, attachment)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return attachment;
    }

    private Ratio parseRatio(XmlPullParser xmlPullParser) throws Exception {
        Ratio ratio = new Ratio();
        this.parseTypeAttributes(xmlPullParser, ratio);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("numerator")) {
                ratio.setNumerator(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("denominator")) {
                ratio.setDenominator(this.parseQuantity(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, ratio)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return ratio;
    }

    private SampledData parseSampledData(XmlPullParser xmlPullParser) throws Exception {
        SampledData sampledData = new SampledData();
        this.parseTypeAttributes(xmlPullParser, sampledData);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("origin")) {
                sampledData.setOrigin(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("period")) {
                sampledData.setPeriod(this.parseDecimal(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("factor")) {
                sampledData.setFactor(this.parseDecimal(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("lowerLimit")) {
                sampledData.setLowerLimit(this.parseDecimal(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("upperLimit")) {
                sampledData.setUpperLimit(this.parseDecimal(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dimensions")) {
                sampledData.setDimensions(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("data")) {
                sampledData.setData(this.parseString(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, sampledData)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return sampledData;
    }

    private ResourceReference parseResourceReference(XmlPullParser xmlPullParser) throws Exception {
        ResourceReference resourceReference = new ResourceReference();
        this.parseTypeAttributes(xmlPullParser, resourceReference);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("reference")) {
                resourceReference.setReference(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("display")) {
                resourceReference.setDisplay(this.parseString(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, resourceReference)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return resourceReference;
    }

    private CodeableConcept parseCodeableConcept(XmlPullParser xmlPullParser) throws Exception {
        CodeableConcept codeableConcept = new CodeableConcept();
        this.parseTypeAttributes(xmlPullParser, codeableConcept);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("coding")) {
                codeableConcept.getCoding().add(this.parseCoding(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("text")) {
                codeableConcept.setText(this.parseString(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, codeableConcept)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return codeableConcept;
    }

    private Identifier parseIdentifier(XmlPullParser xmlPullParser) throws Exception {
        Identifier identifier = new Identifier();
        this.parseTypeAttributes(xmlPullParser, identifier);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("use")) {
                identifier.setUse(this.parseEnumeration(xmlPullParser, Identifier.IdentifierUse.Null, new Identifier.IdentifierUseEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("label")) {
                identifier.setLabel(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("system")) {
                identifier.setSystem(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("value")) {
                identifier.setValue(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("period")) {
                identifier.setPeriod(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("assigner")) {
                identifier.setAssigner(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, identifier)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return identifier;
    }

    private Age parseAge(XmlPullParser xmlPullParser) throws Exception {
        Age age = new Age();
        this.parseElementAttributes(xmlPullParser, age);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("value")) {
                age.setValue(this.parseDecimal(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("comparator")) {
                age.setComparator(this.parseEnumeration(xmlPullParser, Quantity.QuantityComparator.Null, new Quantity.QuantityComparatorEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("units")) {
                age.setUnits(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("system")) {
                age.setSystem(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                age.setCode(this.parseCode(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, age)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return age;
    }

    private Count parseCount(XmlPullParser xmlPullParser) throws Exception {
        Count count = new Count();
        this.parseElementAttributes(xmlPullParser, count);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("value")) {
                count.setValue(this.parseDecimal(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("comparator")) {
                count.setComparator(this.parseEnumeration(xmlPullParser, Quantity.QuantityComparator.Null, new Quantity.QuantityComparatorEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("units")) {
                count.setUnits(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("system")) {
                count.setSystem(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                count.setCode(this.parseCode(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, count)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return count;
    }

    private Money parseMoney(XmlPullParser xmlPullParser) throws Exception {
        Money money = new Money();
        this.parseElementAttributes(xmlPullParser, money);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("value")) {
                money.setValue(this.parseDecimal(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("comparator")) {
                money.setComparator(this.parseEnumeration(xmlPullParser, Quantity.QuantityComparator.Null, new Quantity.QuantityComparatorEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("units")) {
                money.setUnits(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("system")) {
                money.setSystem(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                money.setCode(this.parseCode(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, money)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return money;
    }

    private Distance parseDistance(XmlPullParser xmlPullParser) throws Exception {
        Distance distance = new Distance();
        this.parseElementAttributes(xmlPullParser, distance);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("value")) {
                distance.setValue(this.parseDecimal(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("comparator")) {
                distance.setComparator(this.parseEnumeration(xmlPullParser, Quantity.QuantityComparator.Null, new Quantity.QuantityComparatorEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("units")) {
                distance.setUnits(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("system")) {
                distance.setSystem(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                distance.setCode(this.parseCode(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, distance)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return distance;
    }

    private Duration parseDuration(XmlPullParser xmlPullParser) throws Exception {
        Duration duration = new Duration();
        this.parseElementAttributes(xmlPullParser, duration);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("value")) {
                duration.setValue(this.parseDecimal(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("comparator")) {
                duration.setComparator(this.parseEnumeration(xmlPullParser, Quantity.QuantityComparator.Null, new Quantity.QuantityComparatorEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("units")) {
                duration.setUnits(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("system")) {
                duration.setSystem(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                duration.setCode(this.parseCode(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, duration)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return duration;
    }

    private Schedule parseSchedule(XmlPullParser xmlPullParser) throws Exception {
        Schedule schedule = new Schedule();
        this.parseElementAttributes(xmlPullParser, schedule);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("event")) {
                schedule.getEvent().add(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("repeat")) {
                schedule.setRepeat(this.parseScheduleScheduleRepeatComponent(xmlPullParser, schedule));
            } else if (!this.parseElementContent(n, xmlPullParser, schedule)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return schedule;
    }

    private Schedule.ScheduleRepeatComponent parseScheduleScheduleRepeatComponent(XmlPullParser xmlPullParser, Schedule schedule) throws Exception {
        Schedule.ScheduleRepeatComponent scheduleRepeatComponent = new Schedule.ScheduleRepeatComponent();
        this.parseElementAttributes(xmlPullParser, scheduleRepeatComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("frequency")) {
                scheduleRepeatComponent.setFrequency(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("when")) {
                scheduleRepeatComponent.setWhen(this.parseEnumeration(xmlPullParser, Schedule.EventTiming.Null, new Schedule.EventTimingEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("duration")) {
                scheduleRepeatComponent.setDuration(this.parseDecimal(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("units")) {
                scheduleRepeatComponent.setUnits(this.parseEnumeration(xmlPullParser, Schedule.UnitsOfTime.Null, new Schedule.UnitsOfTimeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("count")) {
                scheduleRepeatComponent.setCount(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("end")) {
                scheduleRepeatComponent.setEnd(this.parseDateTime(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, scheduleRepeatComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return scheduleRepeatComponent;
    }

    private Contact parseContact(XmlPullParser xmlPullParser) throws Exception {
        Contact contact = new Contact();
        this.parseElementAttributes(xmlPullParser, contact);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("system")) {
                contact.setSystem(this.parseEnumeration(xmlPullParser, Contact.ContactSystem.Null, new Contact.ContactSystemEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("value")) {
                contact.setValue(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("use")) {
                contact.setUse(this.parseEnumeration(xmlPullParser, Contact.ContactUse.Null, new Contact.ContactUseEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("period")) {
                contact.setPeriod(this.parsePeriod(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, contact)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return contact;
    }

    private Address parseAddress(XmlPullParser xmlPullParser) throws Exception {
        Address address = new Address();
        this.parseElementAttributes(xmlPullParser, address);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("use")) {
                address.setUse(this.parseEnumeration(xmlPullParser, Address.AddressUse.Null, new Address.AddressUseEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("text")) {
                address.setText(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("line")) {
                address.getLine().add(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("city")) {
                address.setCity(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("state")) {
                address.setState(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("zip")) {
                address.setZip(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("country")) {
                address.setCountry(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("period")) {
                address.setPeriod(this.parsePeriod(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, address)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return address;
    }

    private HumanName parseHumanName(XmlPullParser xmlPullParser) throws Exception {
        HumanName humanName = new HumanName();
        this.parseElementAttributes(xmlPullParser, humanName);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("use")) {
                humanName.setUse(this.parseEnumeration(xmlPullParser, HumanName.NameUse.Null, new HumanName.NameUseEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("text")) {
                humanName.setText(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("family")) {
                humanName.getFamily().add(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("given")) {
                humanName.getGiven().add(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("prefix")) {
                humanName.getPrefix().add(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("suffix")) {
                humanName.getSuffix().add(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("period")) {
                humanName.setPeriod(this.parsePeriod(xmlPullParser));
            } else if (!this.parseElementContent(n, xmlPullParser, humanName)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return humanName;
    }

    private boolean parseResourceContent(int n, XmlPullParser xmlPullParser, Resource resource) throws Exception {
        if (n == 2 && xmlPullParser.getName().equals("language")) {
            resource.setLanguage(this.parseCode(xmlPullParser));
        } else if (n == 2 && xmlPullParser.getName().equals("text")) {
            resource.setText(this.parseNarrative(xmlPullParser));
        } else if (n == 2 && xmlPullParser.getName().equals("contained")) {
            this.next(xmlPullParser);
            this.nextNoWhitespace(xmlPullParser);
            resource.getContained().add(this.parse(xmlPullParser));
            if (xmlPullParser.getName() == null) {
                this.next(xmlPullParser);
            }
            if (xmlPullParser.getName() != null) {
                this.next(xmlPullParser);
            }
            this.nextNoWhitespace(xmlPullParser);
        } else {
            return this.parseBackboneContent(n, xmlPullParser, resource);
        }
        return true;
    }

    private AdverseReaction parseAdverseReaction(XmlPullParser xmlPullParser) throws Exception {
        AdverseReaction adverseReaction = new AdverseReaction();
        this.parseResourceAttributes(xmlPullParser, adverseReaction);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                adverseReaction.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("date")) {
                adverseReaction.setDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                adverseReaction.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("didNotOccurFlag")) {
                adverseReaction.setDidNotOccurFlag(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("recorder")) {
                adverseReaction.setRecorder(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("symptom")) {
                adverseReaction.getSymptom().add(this.parseAdverseReactionAdverseReactionSymptomComponent(xmlPullParser, adverseReaction));
            } else if (n == 2 && xmlPullParser.getName().equals("exposure")) {
                adverseReaction.getExposure().add(this.parseAdverseReactionAdverseReactionExposureComponent(xmlPullParser, adverseReaction));
            } else if (!this.parseResourceContent(n, xmlPullParser, adverseReaction)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return adverseReaction;
    }

    private AdverseReaction.AdverseReactionSymptomComponent parseAdverseReactionAdverseReactionSymptomComponent(XmlPullParser xmlPullParser, AdverseReaction adverseReaction) throws Exception {
        AdverseReaction.AdverseReactionSymptomComponent adverseReactionSymptomComponent = new AdverseReaction.AdverseReactionSymptomComponent();
        this.parseBackboneAttributes(xmlPullParser, adverseReactionSymptomComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                adverseReactionSymptomComponent.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("severity")) {
                adverseReactionSymptomComponent.setSeverity(this.parseEnumeration(xmlPullParser, AdverseReaction.ReactionSeverity.Null, new AdverseReaction.ReactionSeverityEnumFactory()));
            } else if (!this.parseBackboneContent(n, xmlPullParser, adverseReactionSymptomComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return adverseReactionSymptomComponent;
    }

    private AdverseReaction.AdverseReactionExposureComponent parseAdverseReactionAdverseReactionExposureComponent(XmlPullParser xmlPullParser, AdverseReaction adverseReaction) throws Exception {
        AdverseReaction.AdverseReactionExposureComponent adverseReactionExposureComponent = new AdverseReaction.AdverseReactionExposureComponent();
        this.parseBackboneAttributes(xmlPullParser, adverseReactionExposureComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("date")) {
                adverseReactionExposureComponent.setDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                adverseReactionExposureComponent.setType(this.parseEnumeration(xmlPullParser, AdverseReaction.ExposureType.Null, new AdverseReaction.ExposureTypeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("causalityExpectation")) {
                adverseReactionExposureComponent.setCausalityExpectation(this.parseEnumeration(xmlPullParser, AdverseReaction.CausalityExpectation.Null, new AdverseReaction.CausalityExpectationEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("substance")) {
                adverseReactionExposureComponent.setSubstance(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, adverseReactionExposureComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return adverseReactionExposureComponent;
    }

    private Alert parseAlert(XmlPullParser xmlPullParser) throws Exception {
        Alert alert = new Alert();
        this.parseResourceAttributes(xmlPullParser, alert);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                alert.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("category")) {
                alert.setCategory(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                alert.setStatus(this.parseEnumeration(xmlPullParser, Alert.AlertStatus.Null, new Alert.AlertStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                alert.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("author")) {
                alert.setAuthor(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("note")) {
                alert.setNote(this.parseString(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, alert)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return alert;
    }

    private AllergyIntolerance parseAllergyIntolerance(XmlPullParser xmlPullParser) throws Exception {
        AllergyIntolerance allergyIntolerance = new AllergyIntolerance();
        this.parseResourceAttributes(xmlPullParser, allergyIntolerance);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                allergyIntolerance.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("criticality")) {
                allergyIntolerance.setCriticality(this.parseEnumeration(xmlPullParser, AllergyIntolerance.Criticality.Null, new AllergyIntolerance.CriticalityEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("sensitivityType")) {
                allergyIntolerance.setSensitivityType(this.parseEnumeration(xmlPullParser, AllergyIntolerance.Sensitivitytype.Null, new AllergyIntolerance.SensitivitytypeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("recordedDate")) {
                allergyIntolerance.setRecordedDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                allergyIntolerance.setStatus(this.parseEnumeration(xmlPullParser, AllergyIntolerance.Sensitivitystatus.Null, new AllergyIntolerance.SensitivitystatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                allergyIntolerance.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("recorder")) {
                allergyIntolerance.setRecorder(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("substance")) {
                allergyIntolerance.setSubstance(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reaction")) {
                allergyIntolerance.getReaction().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("sensitivityTest")) {
                allergyIntolerance.getSensitivityTest().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, allergyIntolerance)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return allergyIntolerance;
    }

    private CarePlan parseCarePlan(XmlPullParser xmlPullParser) throws Exception {
        CarePlan carePlan = new CarePlan();
        this.parseResourceAttributes(xmlPullParser, carePlan);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                carePlan.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("patient")) {
                carePlan.setPatient(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                carePlan.setStatus(this.parseEnumeration(xmlPullParser, CarePlan.CarePlanStatus.Null, new CarePlan.CarePlanStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("period")) {
                carePlan.setPeriod(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("modified")) {
                carePlan.setModified(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("concern")) {
                carePlan.getConcern().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("participant")) {
                carePlan.getParticipant().add(this.parseCarePlanCarePlanParticipantComponent(xmlPullParser, carePlan));
            } else if (n == 2 && xmlPullParser.getName().equals("goal")) {
                carePlan.getGoal().add(this.parseCarePlanCarePlanGoalComponent(xmlPullParser, carePlan));
            } else if (n == 2 && xmlPullParser.getName().equals("activity")) {
                carePlan.getActivity().add(this.parseCarePlanCarePlanActivityComponent(xmlPullParser, carePlan));
            } else if (n == 2 && xmlPullParser.getName().equals("notes")) {
                carePlan.setNotes(this.parseString(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, carePlan)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return carePlan;
    }

    private CarePlan.CarePlanParticipantComponent parseCarePlanCarePlanParticipantComponent(XmlPullParser xmlPullParser, CarePlan carePlan) throws Exception {
        CarePlan.CarePlanParticipantComponent carePlanParticipantComponent = new CarePlan.CarePlanParticipantComponent();
        this.parseBackboneAttributes(xmlPullParser, carePlanParticipantComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("role")) {
                carePlanParticipantComponent.setRole(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("member")) {
                carePlanParticipantComponent.setMember(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, carePlanParticipantComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return carePlanParticipantComponent;
    }

    private CarePlan.CarePlanGoalComponent parseCarePlanCarePlanGoalComponent(XmlPullParser xmlPullParser, CarePlan carePlan) throws Exception {
        CarePlan.CarePlanGoalComponent carePlanGoalComponent = new CarePlan.CarePlanGoalComponent();
        this.parseBackboneAttributes(xmlPullParser, carePlanGoalComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("description")) {
                carePlanGoalComponent.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                carePlanGoalComponent.setStatus(this.parseEnumeration(xmlPullParser, CarePlan.CarePlanGoalStatus.Null, new CarePlan.CarePlanGoalStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("notes")) {
                carePlanGoalComponent.setNotes(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("concern")) {
                carePlanGoalComponent.getConcern().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, carePlanGoalComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return carePlanGoalComponent;
    }

    private CarePlan.CarePlanActivityComponent parseCarePlanCarePlanActivityComponent(XmlPullParser xmlPullParser, CarePlan carePlan) throws Exception {
        CarePlan.CarePlanActivityComponent carePlanActivityComponent = new CarePlan.CarePlanActivityComponent();
        this.parseBackboneAttributes(xmlPullParser, carePlanActivityComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("goal")) {
                carePlanActivityComponent.getGoal().add(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                carePlanActivityComponent.setStatus(this.parseEnumeration(xmlPullParser, CarePlan.CarePlanActivityStatus.Null, new CarePlan.CarePlanActivityStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("prohibited")) {
                carePlanActivityComponent.setProhibited(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("actionResulting")) {
                carePlanActivityComponent.getActionResulting().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("notes")) {
                carePlanActivityComponent.setNotes(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("detail")) {
                carePlanActivityComponent.setDetail(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("simple")) {
                carePlanActivityComponent.setSimple(this.parseCarePlanCarePlanActivitySimpleComponent(xmlPullParser, carePlan));
            } else if (!this.parseBackboneContent(n, xmlPullParser, carePlanActivityComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return carePlanActivityComponent;
    }

    private CarePlan.CarePlanActivitySimpleComponent parseCarePlanCarePlanActivitySimpleComponent(XmlPullParser xmlPullParser, CarePlan carePlan) throws Exception {
        CarePlan.CarePlanActivitySimpleComponent carePlanActivitySimpleComponent = new CarePlan.CarePlanActivitySimpleComponent();
        this.parseBackboneAttributes(xmlPullParser, carePlanActivitySimpleComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("category")) {
                carePlanActivitySimpleComponent.setCategory(this.parseEnumeration(xmlPullParser, CarePlan.CarePlanActivityCategory.Null, new CarePlan.CarePlanActivityCategoryEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                carePlanActivitySimpleComponent.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "timing")) {
                carePlanActivitySimpleComponent.setTiming(this.parseType("timing", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("location")) {
                carePlanActivitySimpleComponent.setLocation(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("performer")) {
                carePlanActivitySimpleComponent.getPerformer().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("product")) {
                carePlanActivitySimpleComponent.setProduct(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dailyAmount")) {
                carePlanActivitySimpleComponent.setDailyAmount(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("quantity")) {
                carePlanActivitySimpleComponent.setQuantity(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("details")) {
                carePlanActivitySimpleComponent.setDetails(this.parseString(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, carePlanActivitySimpleComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return carePlanActivitySimpleComponent;
    }

    private Composition parseComposition(XmlPullParser xmlPullParser) throws Exception {
        Composition composition = new Composition();
        this.parseResourceAttributes(xmlPullParser, composition);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                composition.setIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("date")) {
                composition.setDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                composition.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("class")) {
                composition.setClass_(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("title")) {
                composition.setTitle(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                composition.setStatus(this.parseEnumeration(xmlPullParser, Composition.CompositionStatus.Null, new Composition.CompositionStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("confidentiality")) {
                composition.setConfidentiality(this.parseCoding(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                composition.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("author")) {
                composition.getAuthor().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("attester")) {
                composition.getAttester().add(this.parseCompositionCompositionAttesterComponent(xmlPullParser, composition));
            } else if (n == 2 && xmlPullParser.getName().equals("custodian")) {
                composition.setCustodian(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("event")) {
                composition.setEvent(this.parseCompositionCompositionEventComponent(xmlPullParser, composition));
            } else if (n == 2 && xmlPullParser.getName().equals("encounter")) {
                composition.setEncounter(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("section")) {
                composition.getSection().add(this.parseCompositionSectionComponent(xmlPullParser, composition));
            } else if (!this.parseResourceContent(n, xmlPullParser, composition)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return composition;
    }

    private Composition.CompositionAttesterComponent parseCompositionCompositionAttesterComponent(XmlPullParser xmlPullParser, Composition composition) throws Exception {
        Composition.CompositionAttesterComponent compositionAttesterComponent = new Composition.CompositionAttesterComponent();
        this.parseBackboneAttributes(xmlPullParser, compositionAttesterComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("mode")) {
                compositionAttesterComponent.getMode().add(this.parseEnumeration(xmlPullParser, Composition.CompositionAttestationMode.Null, new Composition.CompositionAttestationModeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("time")) {
                compositionAttesterComponent.setTime(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("party")) {
                compositionAttesterComponent.setParty(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, compositionAttesterComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return compositionAttesterComponent;
    }

    private Composition.CompositionEventComponent parseCompositionCompositionEventComponent(XmlPullParser xmlPullParser, Composition composition) throws Exception {
        Composition.CompositionEventComponent compositionEventComponent = new Composition.CompositionEventComponent();
        this.parseBackboneAttributes(xmlPullParser, compositionEventComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                compositionEventComponent.getCode().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("period")) {
                compositionEventComponent.setPeriod(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("detail")) {
                compositionEventComponent.getDetail().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, compositionEventComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return compositionEventComponent;
    }

    private Composition.SectionComponent parseCompositionSectionComponent(XmlPullParser xmlPullParser, Composition composition) throws Exception {
        Composition.SectionComponent sectionComponent = new Composition.SectionComponent();
        this.parseBackboneAttributes(xmlPullParser, sectionComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("title")) {
                sectionComponent.setTitle(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                sectionComponent.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                sectionComponent.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("content")) {
                sectionComponent.setContent(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("section")) {
                sectionComponent.getSection().add(this.parseCompositionSectionComponent(xmlPullParser, composition));
            } else if (!this.parseBackboneContent(n, xmlPullParser, sectionComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return sectionComponent;
    }

    private ConceptMap parseConceptMap(XmlPullParser xmlPullParser) throws Exception {
        ConceptMap conceptMap = new ConceptMap();
        this.parseResourceAttributes(xmlPullParser, conceptMap);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                conceptMap.setIdentifier(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("version")) {
                conceptMap.setVersion(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                conceptMap.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("publisher")) {
                conceptMap.setPublisher(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("telecom")) {
                conceptMap.getTelecom().add(this.parseContact(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                conceptMap.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("copyright")) {
                conceptMap.setCopyright(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                conceptMap.setStatus(this.parseEnumeration(xmlPullParser, ConceptMap.ValuesetStatus.Null, new ConceptMap.ValuesetStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("experimental")) {
                conceptMap.setExperimental(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("date")) {
                conceptMap.setDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("source")) {
                conceptMap.setSource(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("target")) {
                conceptMap.setTarget(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("concept")) {
                conceptMap.getConcept().add(this.parseConceptMapConceptMapConceptComponent(xmlPullParser, conceptMap));
            } else if (!this.parseResourceContent(n, xmlPullParser, conceptMap)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conceptMap;
    }

    private ConceptMap.ConceptMapConceptComponent parseConceptMapConceptMapConceptComponent(XmlPullParser xmlPullParser, ConceptMap conceptMap) throws Exception {
        ConceptMap.ConceptMapConceptComponent conceptMapConceptComponent = new ConceptMap.ConceptMapConceptComponent();
        this.parseBackboneAttributes(xmlPullParser, conceptMapConceptComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("system")) {
                conceptMapConceptComponent.setSystem(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                conceptMapConceptComponent.setCode(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dependsOn")) {
                conceptMapConceptComponent.getDependsOn().add(this.parseConceptMapOtherConceptComponent(xmlPullParser, conceptMap));
            } else if (n == 2 && xmlPullParser.getName().equals("map")) {
                conceptMapConceptComponent.getMap().add(this.parseConceptMapConceptMapConceptMapComponent(xmlPullParser, conceptMap));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conceptMapConceptComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conceptMapConceptComponent;
    }

    private ConceptMap.OtherConceptComponent parseConceptMapOtherConceptComponent(XmlPullParser xmlPullParser, ConceptMap conceptMap) throws Exception {
        ConceptMap.OtherConceptComponent otherConceptComponent = new ConceptMap.OtherConceptComponent();
        this.parseBackboneAttributes(xmlPullParser, otherConceptComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("concept")) {
                otherConceptComponent.setConcept(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("system")) {
                otherConceptComponent.setSystem(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                otherConceptComponent.setCode(this.parseCode(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, otherConceptComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return otherConceptComponent;
    }

    private ConceptMap.ConceptMapConceptMapComponent parseConceptMapConceptMapConceptMapComponent(XmlPullParser xmlPullParser, ConceptMap conceptMap) throws Exception {
        ConceptMap.ConceptMapConceptMapComponent conceptMapConceptMapComponent = new ConceptMap.ConceptMapConceptMapComponent();
        this.parseBackboneAttributes(xmlPullParser, conceptMapConceptMapComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("system")) {
                conceptMapConceptMapComponent.setSystem(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                conceptMapConceptMapComponent.setCode(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("equivalence")) {
                conceptMapConceptMapComponent.setEquivalence(this.parseEnumeration(xmlPullParser, ConceptMap.ConceptEquivalence.Null, new ConceptMap.ConceptEquivalenceEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("comments")) {
                conceptMapConceptMapComponent.setComments(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("product")) {
                conceptMapConceptMapComponent.getProduct().add(this.parseConceptMapOtherConceptComponent(xmlPullParser, conceptMap));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conceptMapConceptMapComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conceptMapConceptMapComponent;
    }

    private Condition parseCondition(XmlPullParser xmlPullParser) throws Exception {
        Condition condition = new Condition();
        this.parseResourceAttributes(xmlPullParser, condition);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                condition.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                condition.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("encounter")) {
                condition.setEncounter(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("asserter")) {
                condition.setAsserter(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dateAsserted")) {
                condition.setDateAsserted(this.parseDate(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                condition.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("category")) {
                condition.setCategory(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                condition.setStatus(this.parseEnumeration(xmlPullParser, Condition.ConditionStatus.Null, new Condition.ConditionStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("certainty")) {
                condition.setCertainty(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("severity")) {
                condition.setSeverity(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "onset")) {
                condition.setOnset(this.parseType("onset", xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "abatement")) {
                condition.setAbatement(this.parseType("abatement", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("stage")) {
                condition.setStage(this.parseConditionConditionStageComponent(xmlPullParser, condition));
            } else if (n == 2 && xmlPullParser.getName().equals("evidence")) {
                condition.getEvidence().add(this.parseConditionConditionEvidenceComponent(xmlPullParser, condition));
            } else if (n == 2 && xmlPullParser.getName().equals("location")) {
                condition.getLocation().add(this.parseConditionConditionLocationComponent(xmlPullParser, condition));
            } else if (n == 2 && xmlPullParser.getName().equals("relatedItem")) {
                condition.getRelatedItem().add(this.parseConditionConditionRelatedItemComponent(xmlPullParser, condition));
            } else if (n == 2 && xmlPullParser.getName().equals("notes")) {
                condition.setNotes(this.parseString(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, condition)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return condition;
    }

    private Condition.ConditionStageComponent parseConditionConditionStageComponent(XmlPullParser xmlPullParser, Condition condition) throws Exception {
        Condition.ConditionStageComponent conditionStageComponent = new Condition.ConditionStageComponent();
        this.parseBackboneAttributes(xmlPullParser, conditionStageComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("summary")) {
                conditionStageComponent.setSummary(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("assessment")) {
                conditionStageComponent.getAssessment().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conditionStageComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conditionStageComponent;
    }

    private Condition.ConditionEvidenceComponent parseConditionConditionEvidenceComponent(XmlPullParser xmlPullParser, Condition condition) throws Exception {
        Condition.ConditionEvidenceComponent conditionEvidenceComponent = new Condition.ConditionEvidenceComponent();
        this.parseBackboneAttributes(xmlPullParser, conditionEvidenceComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                conditionEvidenceComponent.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("detail")) {
                conditionEvidenceComponent.getDetail().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conditionEvidenceComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conditionEvidenceComponent;
    }

    private Condition.ConditionLocationComponent parseConditionConditionLocationComponent(XmlPullParser xmlPullParser, Condition condition) throws Exception {
        Condition.ConditionLocationComponent conditionLocationComponent = new Condition.ConditionLocationComponent();
        this.parseBackboneAttributes(xmlPullParser, conditionLocationComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                conditionLocationComponent.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("detail")) {
                conditionLocationComponent.setDetail(this.parseString(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conditionLocationComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conditionLocationComponent;
    }

    private Condition.ConditionRelatedItemComponent parseConditionConditionRelatedItemComponent(XmlPullParser xmlPullParser, Condition condition) throws Exception {
        Condition.ConditionRelatedItemComponent conditionRelatedItemComponent = new Condition.ConditionRelatedItemComponent();
        this.parseBackboneAttributes(xmlPullParser, conditionRelatedItemComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("type")) {
                conditionRelatedItemComponent.setType(this.parseEnumeration(xmlPullParser, Condition.ConditionRelationshipType.Null, new Condition.ConditionRelationshipTypeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                conditionRelatedItemComponent.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("target")) {
                conditionRelatedItemComponent.setTarget(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conditionRelatedItemComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conditionRelatedItemComponent;
    }

    private Conformance parseConformance(XmlPullParser xmlPullParser) throws Exception {
        Conformance conformance = new Conformance();
        this.parseResourceAttributes(xmlPullParser, conformance);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                conformance.setIdentifier(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("version")) {
                conformance.setVersion(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                conformance.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("publisher")) {
                conformance.setPublisher(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("telecom")) {
                conformance.getTelecom().add(this.parseContact(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                conformance.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                conformance.setStatus(this.parseEnumeration(xmlPullParser, Conformance.ConformanceStatementStatus.Null, new Conformance.ConformanceStatementStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("experimental")) {
                conformance.setExperimental(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("date")) {
                conformance.setDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("software")) {
                conformance.setSoftware(this.parseConformanceConformanceSoftwareComponent(xmlPullParser, conformance));
            } else if (n == 2 && xmlPullParser.getName().equals("implementation")) {
                conformance.setImplementation(this.parseConformanceConformanceImplementationComponent(xmlPullParser, conformance));
            } else if (n == 2 && xmlPullParser.getName().equals("fhirVersion")) {
                conformance.setFhirVersion(this.parseId(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("acceptUnknown")) {
                conformance.setAcceptUnknown(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("format")) {
                conformance.getFormat().add(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("profile")) {
                conformance.getProfile().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("rest")) {
                conformance.getRest().add(this.parseConformanceConformanceRestComponent(xmlPullParser, conformance));
            } else if (n == 2 && xmlPullParser.getName().equals("messaging")) {
                conformance.getMessaging().add(this.parseConformanceConformanceMessagingComponent(xmlPullParser, conformance));
            } else if (n == 2 && xmlPullParser.getName().equals("document")) {
                conformance.getDocument().add(this.parseConformanceConformanceDocumentComponent(xmlPullParser, conformance));
            } else if (!this.parseResourceContent(n, xmlPullParser, conformance)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conformance;
    }

    private Conformance.ConformanceSoftwareComponent parseConformanceConformanceSoftwareComponent(XmlPullParser xmlPullParser, Conformance conformance) throws Exception {
        Conformance.ConformanceSoftwareComponent conformanceSoftwareComponent = new Conformance.ConformanceSoftwareComponent();
        this.parseBackboneAttributes(xmlPullParser, conformanceSoftwareComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("name")) {
                conformanceSoftwareComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("version")) {
                conformanceSoftwareComponent.setVersion(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("releaseDate")) {
                conformanceSoftwareComponent.setReleaseDate(this.parseDateTime(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conformanceSoftwareComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conformanceSoftwareComponent;
    }

    private Conformance.ConformanceImplementationComponent parseConformanceConformanceImplementationComponent(XmlPullParser xmlPullParser, Conformance conformance) throws Exception {
        Conformance.ConformanceImplementationComponent conformanceImplementationComponent = new Conformance.ConformanceImplementationComponent();
        this.parseBackboneAttributes(xmlPullParser, conformanceImplementationComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("description")) {
                conformanceImplementationComponent.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("url")) {
                conformanceImplementationComponent.setUrl(this.parseUri(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conformanceImplementationComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conformanceImplementationComponent;
    }

    private Conformance.ConformanceRestComponent parseConformanceConformanceRestComponent(XmlPullParser xmlPullParser, Conformance conformance) throws Exception {
        Conformance.ConformanceRestComponent conformanceRestComponent = new Conformance.ConformanceRestComponent();
        this.parseBackboneAttributes(xmlPullParser, conformanceRestComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("mode")) {
                conformanceRestComponent.setMode(this.parseEnumeration(xmlPullParser, Conformance.RestfulConformanceMode.Null, new Conformance.RestfulConformanceModeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("documentation")) {
                conformanceRestComponent.setDocumentation(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("security")) {
                conformanceRestComponent.setSecurity(this.parseConformanceConformanceRestSecurityComponent(xmlPullParser, conformance));
            } else if (n == 2 && xmlPullParser.getName().equals("resource")) {
                conformanceRestComponent.getResource().add(this.parseConformanceConformanceRestResourceComponent(xmlPullParser, conformance));
            } else if (n == 2 && xmlPullParser.getName().equals("operation")) {
                conformanceRestComponent.getOperation().add(this.parseConformanceConformanceRestOperationComponent(xmlPullParser, conformance));
            } else if (n == 2 && xmlPullParser.getName().equals("query")) {
                conformanceRestComponent.getQuery().add(this.parseConformanceConformanceRestQueryComponent(xmlPullParser, conformance));
            } else if (n == 2 && xmlPullParser.getName().equals("documentMailbox")) {
                conformanceRestComponent.getDocumentMailbox().add(this.parseUri(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conformanceRestComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conformanceRestComponent;
    }

    private Conformance.ConformanceRestSecurityComponent parseConformanceConformanceRestSecurityComponent(XmlPullParser xmlPullParser, Conformance conformance) throws Exception {
        Conformance.ConformanceRestSecurityComponent conformanceRestSecurityComponent = new Conformance.ConformanceRestSecurityComponent();
        this.parseBackboneAttributes(xmlPullParser, conformanceRestSecurityComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("cors")) {
                conformanceRestSecurityComponent.setCors(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("service")) {
                conformanceRestSecurityComponent.getService().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                conformanceRestSecurityComponent.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("certificate")) {
                conformanceRestSecurityComponent.getCertificate().add(this.parseConformanceConformanceRestSecurityCertificateComponent(xmlPullParser, conformance));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conformanceRestSecurityComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conformanceRestSecurityComponent;
    }

    private Conformance.ConformanceRestSecurityCertificateComponent parseConformanceConformanceRestSecurityCertificateComponent(XmlPullParser xmlPullParser, Conformance conformance) throws Exception {
        Conformance.ConformanceRestSecurityCertificateComponent conformanceRestSecurityCertificateComponent = new Conformance.ConformanceRestSecurityCertificateComponent();
        this.parseBackboneAttributes(xmlPullParser, conformanceRestSecurityCertificateComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("type")) {
                conformanceRestSecurityCertificateComponent.setType(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("blob")) {
                conformanceRestSecurityCertificateComponent.setBlob(this.parseBase64Binary(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conformanceRestSecurityCertificateComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conformanceRestSecurityCertificateComponent;
    }

    private Conformance.ConformanceRestResourceComponent parseConformanceConformanceRestResourceComponent(XmlPullParser xmlPullParser, Conformance conformance) throws Exception {
        Conformance.ConformanceRestResourceComponent conformanceRestResourceComponent = new Conformance.ConformanceRestResourceComponent();
        this.parseBackboneAttributes(xmlPullParser, conformanceRestResourceComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("type")) {
                conformanceRestResourceComponent.setType(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("profile")) {
                conformanceRestResourceComponent.setProfile(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("operation")) {
                conformanceRestResourceComponent.getOperation().add(this.parseConformanceConformanceRestResourceOperationComponent(xmlPullParser, conformance));
            } else if (n == 2 && xmlPullParser.getName().equals("readHistory")) {
                conformanceRestResourceComponent.setReadHistory(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("updateCreate")) {
                conformanceRestResourceComponent.setUpdateCreate(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("searchInclude")) {
                conformanceRestResourceComponent.getSearchInclude().add(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("searchParam")) {
                conformanceRestResourceComponent.getSearchParam().add(this.parseConformanceConformanceRestResourceSearchParamComponent(xmlPullParser, conformance));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conformanceRestResourceComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conformanceRestResourceComponent;
    }

    private Conformance.ConformanceRestResourceOperationComponent parseConformanceConformanceRestResourceOperationComponent(XmlPullParser xmlPullParser, Conformance conformance) throws Exception {
        Conformance.ConformanceRestResourceOperationComponent conformanceRestResourceOperationComponent = new Conformance.ConformanceRestResourceOperationComponent();
        this.parseBackboneAttributes(xmlPullParser, conformanceRestResourceOperationComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                conformanceRestResourceOperationComponent.setCode(this.parseEnumeration(xmlPullParser, Conformance.TypeRestfulOperation.Null, new Conformance.TypeRestfulOperationEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("documentation")) {
                conformanceRestResourceOperationComponent.setDocumentation(this.parseString(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conformanceRestResourceOperationComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conformanceRestResourceOperationComponent;
    }

    private Conformance.ConformanceRestResourceSearchParamComponent parseConformanceConformanceRestResourceSearchParamComponent(XmlPullParser xmlPullParser, Conformance conformance) throws Exception {
        Conformance.ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent = new Conformance.ConformanceRestResourceSearchParamComponent();
        this.parseBackboneAttributes(xmlPullParser, conformanceRestResourceSearchParamComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("name")) {
                conformanceRestResourceSearchParamComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("definition")) {
                conformanceRestResourceSearchParamComponent.setDefinition(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                conformanceRestResourceSearchParamComponent.setType(this.parseEnumeration(xmlPullParser, Conformance.SearchParamType.Null, new Conformance.SearchParamTypeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("documentation")) {
                conformanceRestResourceSearchParamComponent.setDocumentation(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("target")) {
                conformanceRestResourceSearchParamComponent.getTarget().add(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("chain")) {
                conformanceRestResourceSearchParamComponent.getChain().add(this.parseString(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conformanceRestResourceSearchParamComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conformanceRestResourceSearchParamComponent;
    }

    private Conformance.ConformanceRestOperationComponent parseConformanceConformanceRestOperationComponent(XmlPullParser xmlPullParser, Conformance conformance) throws Exception {
        Conformance.ConformanceRestOperationComponent conformanceRestOperationComponent = new Conformance.ConformanceRestOperationComponent();
        this.parseBackboneAttributes(xmlPullParser, conformanceRestOperationComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                conformanceRestOperationComponent.setCode(this.parseEnumeration(xmlPullParser, Conformance.SystemRestfulOperation.Null, new Conformance.SystemRestfulOperationEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("documentation")) {
                conformanceRestOperationComponent.setDocumentation(this.parseString(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conformanceRestOperationComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conformanceRestOperationComponent;
    }

    private Conformance.ConformanceRestQueryComponent parseConformanceConformanceRestQueryComponent(XmlPullParser xmlPullParser, Conformance conformance) throws Exception {
        Conformance.ConformanceRestQueryComponent conformanceRestQueryComponent = new Conformance.ConformanceRestQueryComponent();
        this.parseBackboneAttributes(xmlPullParser, conformanceRestQueryComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("name")) {
                conformanceRestQueryComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("definition")) {
                conformanceRestQueryComponent.setDefinition(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("documentation")) {
                conformanceRestQueryComponent.setDocumentation(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("parameter")) {
                conformanceRestQueryComponent.getParameter().add(this.parseConformanceConformanceRestResourceSearchParamComponent(xmlPullParser, conformance));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conformanceRestQueryComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conformanceRestQueryComponent;
    }

    private Conformance.ConformanceMessagingComponent parseConformanceConformanceMessagingComponent(XmlPullParser xmlPullParser, Conformance conformance) throws Exception {
        Conformance.ConformanceMessagingComponent conformanceMessagingComponent = new Conformance.ConformanceMessagingComponent();
        this.parseBackboneAttributes(xmlPullParser, conformanceMessagingComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("endpoint")) {
                conformanceMessagingComponent.setEndpoint(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reliableCache")) {
                conformanceMessagingComponent.setReliableCache(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("documentation")) {
                conformanceMessagingComponent.setDocumentation(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("event")) {
                conformanceMessagingComponent.getEvent().add(this.parseConformanceConformanceMessagingEventComponent(xmlPullParser, conformance));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conformanceMessagingComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conformanceMessagingComponent;
    }

    private Conformance.ConformanceMessagingEventComponent parseConformanceConformanceMessagingEventComponent(XmlPullParser xmlPullParser, Conformance conformance) throws Exception {
        Conformance.ConformanceMessagingEventComponent conformanceMessagingEventComponent = new Conformance.ConformanceMessagingEventComponent();
        this.parseBackboneAttributes(xmlPullParser, conformanceMessagingEventComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                conformanceMessagingEventComponent.setCode(this.parseCoding(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("category")) {
                conformanceMessagingEventComponent.setCategory(this.parseEnumeration(xmlPullParser, Conformance.MessageSignificanceCategory.Null, new Conformance.MessageSignificanceCategoryEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("mode")) {
                conformanceMessagingEventComponent.setMode(this.parseEnumeration(xmlPullParser, Conformance.MessageConformanceEventMode.Null, new Conformance.MessageConformanceEventModeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("protocol")) {
                conformanceMessagingEventComponent.getProtocol().add(this.parseCoding(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("focus")) {
                conformanceMessagingEventComponent.setFocus(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("request")) {
                conformanceMessagingEventComponent.setRequest(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("response")) {
                conformanceMessagingEventComponent.setResponse(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("documentation")) {
                conformanceMessagingEventComponent.setDocumentation(this.parseString(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conformanceMessagingEventComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conformanceMessagingEventComponent;
    }

    private Conformance.ConformanceDocumentComponent parseConformanceConformanceDocumentComponent(XmlPullParser xmlPullParser, Conformance conformance) throws Exception {
        Conformance.ConformanceDocumentComponent conformanceDocumentComponent = new Conformance.ConformanceDocumentComponent();
        this.parseBackboneAttributes(xmlPullParser, conformanceDocumentComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("mode")) {
                conformanceDocumentComponent.setMode(this.parseEnumeration(xmlPullParser, Conformance.DocumentMode.Null, new Conformance.DocumentModeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("documentation")) {
                conformanceDocumentComponent.setDocumentation(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("profile")) {
                conformanceDocumentComponent.setProfile(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conformanceDocumentComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conformanceDocumentComponent;
    }

    private Device parseDevice(XmlPullParser xmlPullParser) throws Exception {
        Device device = new Device();
        this.parseResourceAttributes(xmlPullParser, device);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                device.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                device.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("manufacturer")) {
                device.setManufacturer(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("model")) {
                device.setModel(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("version")) {
                device.setVersion(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("expiry")) {
                device.setExpiry(this.parseDate(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("udi")) {
                device.setUdi(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("lotNumber")) {
                device.setLotNumber(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("owner")) {
                device.setOwner(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("location")) {
                device.setLocation(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("patient")) {
                device.setPatient(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("contact")) {
                device.getContact().add(this.parseContact(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("url")) {
                device.setUrl(this.parseUri(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, device)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return device;
    }

    private DeviceObservationReport parseDeviceObservationReport(XmlPullParser xmlPullParser) throws Exception {
        DeviceObservationReport deviceObservationReport = new DeviceObservationReport();
        this.parseResourceAttributes(xmlPullParser, deviceObservationReport);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("instant")) {
                deviceObservationReport.setInstant(this.parseInstant(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                deviceObservationReport.setIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("source")) {
                deviceObservationReport.setSource(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                deviceObservationReport.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("virtualDevice")) {
                deviceObservationReport.getVirtualDevice().add(this.parseDeviceObservationReportDeviceObservationReportVirtualDeviceComponent(xmlPullParser, deviceObservationReport));
            } else if (!this.parseResourceContent(n, xmlPullParser, deviceObservationReport)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return deviceObservationReport;
    }

    private DeviceObservationReport.DeviceObservationReportVirtualDeviceComponent parseDeviceObservationReportDeviceObservationReportVirtualDeviceComponent(XmlPullParser xmlPullParser, DeviceObservationReport deviceObservationReport) throws Exception {
        DeviceObservationReport.DeviceObservationReportVirtualDeviceComponent deviceObservationReportVirtualDeviceComponent = new DeviceObservationReport.DeviceObservationReportVirtualDeviceComponent();
        this.parseBackboneAttributes(xmlPullParser, deviceObservationReportVirtualDeviceComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                deviceObservationReportVirtualDeviceComponent.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("channel")) {
                deviceObservationReportVirtualDeviceComponent.getChannel().add(this.parseDeviceObservationReportDeviceObservationReportVirtualDeviceChannelComponent(xmlPullParser, deviceObservationReport));
            } else if (!this.parseBackboneContent(n, xmlPullParser, deviceObservationReportVirtualDeviceComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return deviceObservationReportVirtualDeviceComponent;
    }

    private DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelComponent parseDeviceObservationReportDeviceObservationReportVirtualDeviceChannelComponent(XmlPullParser xmlPullParser, DeviceObservationReport deviceObservationReport) throws Exception {
        DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelComponent deviceObservationReportVirtualDeviceChannelComponent = new DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelComponent();
        this.parseBackboneAttributes(xmlPullParser, deviceObservationReportVirtualDeviceChannelComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                deviceObservationReportVirtualDeviceChannelComponent.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("metric")) {
                deviceObservationReportVirtualDeviceChannelComponent.getMetric().add(this.parseDeviceObservationReportDeviceObservationReportVirtualDeviceChannelMetricComponent(xmlPullParser, deviceObservationReport));
            } else if (!this.parseBackboneContent(n, xmlPullParser, deviceObservationReportVirtualDeviceChannelComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return deviceObservationReportVirtualDeviceChannelComponent;
    }

    private DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelMetricComponent parseDeviceObservationReportDeviceObservationReportVirtualDeviceChannelMetricComponent(XmlPullParser xmlPullParser, DeviceObservationReport deviceObservationReport) throws Exception {
        DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelMetricComponent deviceObservationReportVirtualDeviceChannelMetricComponent = new DeviceObservationReport.DeviceObservationReportVirtualDeviceChannelMetricComponent();
        this.parseBackboneAttributes(xmlPullParser, deviceObservationReportVirtualDeviceChannelMetricComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("observation")) {
                deviceObservationReportVirtualDeviceChannelMetricComponent.setObservation(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, deviceObservationReportVirtualDeviceChannelMetricComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return deviceObservationReportVirtualDeviceChannelMetricComponent;
    }

    private DiagnosticOrder parseDiagnosticOrder(XmlPullParser xmlPullParser) throws Exception {
        DiagnosticOrder diagnosticOrder = new DiagnosticOrder();
        this.parseResourceAttributes(xmlPullParser, diagnosticOrder);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("subject")) {
                diagnosticOrder.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("orderer")) {
                diagnosticOrder.setOrderer(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                diagnosticOrder.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("encounter")) {
                diagnosticOrder.setEncounter(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("clinicalNotes")) {
                diagnosticOrder.setClinicalNotes(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("specimen")) {
                diagnosticOrder.getSpecimen().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                diagnosticOrder.setStatus(this.parseEnumeration(xmlPullParser, DiagnosticOrder.DiagnosticOrderStatus.Null, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("priority")) {
                diagnosticOrder.setPriority(this.parseEnumeration(xmlPullParser, DiagnosticOrder.DiagnosticOrderPriority.Null, new DiagnosticOrder.DiagnosticOrderPriorityEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("event")) {
                diagnosticOrder.getEvent().add(this.parseDiagnosticOrderDiagnosticOrderEventComponent(xmlPullParser, diagnosticOrder));
            } else if (n == 2 && xmlPullParser.getName().equals("item")) {
                diagnosticOrder.getItem().add(this.parseDiagnosticOrderDiagnosticOrderItemComponent(xmlPullParser, diagnosticOrder));
            } else if (!this.parseResourceContent(n, xmlPullParser, diagnosticOrder)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return diagnosticOrder;
    }

    private DiagnosticOrder.DiagnosticOrderEventComponent parseDiagnosticOrderDiagnosticOrderEventComponent(XmlPullParser xmlPullParser, DiagnosticOrder diagnosticOrder) throws Exception {
        DiagnosticOrder.DiagnosticOrderEventComponent diagnosticOrderEventComponent = new DiagnosticOrder.DiagnosticOrderEventComponent();
        this.parseBackboneAttributes(xmlPullParser, diagnosticOrderEventComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("status")) {
                diagnosticOrderEventComponent.setStatus(this.parseEnumeration(xmlPullParser, DiagnosticOrder.DiagnosticOrderStatus.Null, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                diagnosticOrderEventComponent.setDescription(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dateTime")) {
                diagnosticOrderEventComponent.setDateTime(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("actor")) {
                diagnosticOrderEventComponent.setActor(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, diagnosticOrderEventComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return diagnosticOrderEventComponent;
    }

    private DiagnosticOrder.DiagnosticOrderItemComponent parseDiagnosticOrderDiagnosticOrderItemComponent(XmlPullParser xmlPullParser, DiagnosticOrder diagnosticOrder) throws Exception {
        DiagnosticOrder.DiagnosticOrderItemComponent diagnosticOrderItemComponent = new DiagnosticOrder.DiagnosticOrderItemComponent();
        this.parseBackboneAttributes(xmlPullParser, diagnosticOrderItemComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                diagnosticOrderItemComponent.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("specimen")) {
                diagnosticOrderItemComponent.getSpecimen().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("bodySite")) {
                diagnosticOrderItemComponent.setBodySite(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                diagnosticOrderItemComponent.setStatus(this.parseEnumeration(xmlPullParser, DiagnosticOrder.DiagnosticOrderStatus.Null, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("event")) {
                diagnosticOrderItemComponent.getEvent().add(this.parseDiagnosticOrderDiagnosticOrderEventComponent(xmlPullParser, diagnosticOrder));
            } else if (!this.parseBackboneContent(n, xmlPullParser, diagnosticOrderItemComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return diagnosticOrderItemComponent;
    }

    private DiagnosticReport parseDiagnosticReport(XmlPullParser xmlPullParser) throws Exception {
        DiagnosticReport diagnosticReport = new DiagnosticReport();
        this.parseResourceAttributes(xmlPullParser, diagnosticReport);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("name")) {
                diagnosticReport.setName(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                diagnosticReport.setStatus(this.parseEnumeration(xmlPullParser, DiagnosticReport.DiagnosticReportStatus.Null, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("issued")) {
                diagnosticReport.setIssued(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                diagnosticReport.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("performer")) {
                diagnosticReport.setPerformer(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                diagnosticReport.setIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("requestDetail")) {
                diagnosticReport.getRequestDetail().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("serviceCategory")) {
                diagnosticReport.setServiceCategory(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "diagnostic")) {
                diagnosticReport.setDiagnostic(this.parseType("diagnostic", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("specimen")) {
                diagnosticReport.getSpecimen().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("result")) {
                diagnosticReport.getResult().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("imagingStudy")) {
                diagnosticReport.getImagingStudy().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("image")) {
                diagnosticReport.getImage().add(this.parseDiagnosticReportDiagnosticReportImageComponent(xmlPullParser, diagnosticReport));
            } else if (n == 2 && xmlPullParser.getName().equals("conclusion")) {
                diagnosticReport.setConclusion(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("codedDiagnosis")) {
                diagnosticReport.getCodedDiagnosis().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("presentedForm")) {
                diagnosticReport.getPresentedForm().add(this.parseAttachment(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, diagnosticReport)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return diagnosticReport;
    }

    private DiagnosticReport.DiagnosticReportImageComponent parseDiagnosticReportDiagnosticReportImageComponent(XmlPullParser xmlPullParser, DiagnosticReport diagnosticReport) throws Exception {
        DiagnosticReport.DiagnosticReportImageComponent diagnosticReportImageComponent = new DiagnosticReport.DiagnosticReportImageComponent();
        this.parseBackboneAttributes(xmlPullParser, diagnosticReportImageComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("comment")) {
                diagnosticReportImageComponent.setComment(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("link")) {
                diagnosticReportImageComponent.setLink(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, diagnosticReportImageComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return diagnosticReportImageComponent;
    }

    private DocumentManifest parseDocumentManifest(XmlPullParser xmlPullParser) throws Exception {
        DocumentManifest documentManifest = new DocumentManifest();
        this.parseResourceAttributes(xmlPullParser, documentManifest);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("masterIdentifier")) {
                documentManifest.setMasterIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                documentManifest.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                documentManifest.getSubject().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("recipient")) {
                documentManifest.getRecipient().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                documentManifest.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("author")) {
                documentManifest.getAuthor().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("created")) {
                documentManifest.setCreated(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("source")) {
                documentManifest.setSource(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                documentManifest.setStatus(this.parseEnumeration(xmlPullParser, DocumentManifest.DocumentReferenceStatus.Null, new DocumentManifest.DocumentReferenceStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("supercedes")) {
                documentManifest.setSupercedes(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                documentManifest.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("confidentiality")) {
                documentManifest.setConfidentiality(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("content")) {
                documentManifest.getContent().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, documentManifest)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return documentManifest;
    }

    private DocumentReference parseDocumentReference(XmlPullParser xmlPullParser) throws Exception {
        DocumentReference documentReference = new DocumentReference();
        this.parseResourceAttributes(xmlPullParser, documentReference);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("masterIdentifier")) {
                documentReference.setMasterIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                documentReference.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                documentReference.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                documentReference.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("class")) {
                documentReference.setClass_(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("author")) {
                documentReference.getAuthor().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("custodian")) {
                documentReference.setCustodian(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("policyManager")) {
                documentReference.setPolicyManager(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("authenticator")) {
                documentReference.setAuthenticator(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("created")) {
                documentReference.setCreated(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("indexed")) {
                documentReference.setIndexed(this.parseInstant(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                documentReference.setStatus(this.parseEnumeration(xmlPullParser, DocumentReference.DocumentReferenceStatus.Null, new DocumentReference.DocumentReferenceStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("docStatus")) {
                documentReference.setDocStatus(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("relatesTo")) {
                documentReference.getRelatesTo().add(this.parseDocumentReferenceDocumentReferenceRelatesToComponent(xmlPullParser, documentReference));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                documentReference.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("confidentiality")) {
                documentReference.getConfidentiality().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("primaryLanguage")) {
                documentReference.setPrimaryLanguage(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("mimeType")) {
                documentReference.setMimeType(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("format")) {
                documentReference.getFormat().add(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("size")) {
                documentReference.setSize(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("hash")) {
                documentReference.setHash(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("location")) {
                documentReference.setLocation(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("service")) {
                documentReference.setService(this.parseDocumentReferenceDocumentReferenceServiceComponent(xmlPullParser, documentReference));
            } else if (n == 2 && xmlPullParser.getName().equals("context")) {
                documentReference.setContext(this.parseDocumentReferenceDocumentReferenceContextComponent(xmlPullParser, documentReference));
            } else if (!this.parseResourceContent(n, xmlPullParser, documentReference)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return documentReference;
    }

    private DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceDocumentReferenceRelatesToComponent(XmlPullParser xmlPullParser, DocumentReference documentReference) throws Exception {
        DocumentReference.DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent = new DocumentReference.DocumentReferenceRelatesToComponent();
        this.parseBackboneAttributes(xmlPullParser, documentReferenceRelatesToComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                documentReferenceRelatesToComponent.setCode(this.parseEnumeration(xmlPullParser, DocumentReference.DocumentRelationshipType.Null, new DocumentReference.DocumentRelationshipTypeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("target")) {
                documentReferenceRelatesToComponent.setTarget(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, documentReferenceRelatesToComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return documentReferenceRelatesToComponent;
    }

    private DocumentReference.DocumentReferenceServiceComponent parseDocumentReferenceDocumentReferenceServiceComponent(XmlPullParser xmlPullParser, DocumentReference documentReference) throws Exception {
        DocumentReference.DocumentReferenceServiceComponent documentReferenceServiceComponent = new DocumentReference.DocumentReferenceServiceComponent();
        this.parseBackboneAttributes(xmlPullParser, documentReferenceServiceComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("type")) {
                documentReferenceServiceComponent.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("address")) {
                documentReferenceServiceComponent.setAddress(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("parameter")) {
                documentReferenceServiceComponent.getParameter().add(this.parseDocumentReferenceDocumentReferenceServiceParameterComponent(xmlPullParser, documentReference));
            } else if (!this.parseBackboneContent(n, xmlPullParser, documentReferenceServiceComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return documentReferenceServiceComponent;
    }

    private DocumentReference.DocumentReferenceServiceParameterComponent parseDocumentReferenceDocumentReferenceServiceParameterComponent(XmlPullParser xmlPullParser, DocumentReference documentReference) throws Exception {
        DocumentReference.DocumentReferenceServiceParameterComponent documentReferenceServiceParameterComponent = new DocumentReference.DocumentReferenceServiceParameterComponent();
        this.parseBackboneAttributes(xmlPullParser, documentReferenceServiceParameterComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("name")) {
                documentReferenceServiceParameterComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("value")) {
                documentReferenceServiceParameterComponent.setValue(this.parseString(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, documentReferenceServiceParameterComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return documentReferenceServiceParameterComponent;
    }

    private DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceDocumentReferenceContextComponent(XmlPullParser xmlPullParser, DocumentReference documentReference) throws Exception {
        DocumentReference.DocumentReferenceContextComponent documentReferenceContextComponent = new DocumentReference.DocumentReferenceContextComponent();
        this.parseBackboneAttributes(xmlPullParser, documentReferenceContextComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("event")) {
                documentReferenceContextComponent.getEvent().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("period")) {
                documentReferenceContextComponent.setPeriod(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("facilityType")) {
                documentReferenceContextComponent.setFacilityType(this.parseCodeableConcept(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, documentReferenceContextComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return documentReferenceContextComponent;
    }

    private Encounter parseEncounter(XmlPullParser xmlPullParser) throws Exception {
        Encounter encounter = new Encounter();
        this.parseResourceAttributes(xmlPullParser, encounter);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                encounter.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                encounter.setStatus(this.parseEnumeration(xmlPullParser, Encounter.EncounterState.Null, new Encounter.EncounterStateEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("class")) {
                encounter.setClass_(this.parseEnumeration(xmlPullParser, Encounter.EncounterClass.Null, new Encounter.EncounterClassEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                encounter.getType().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                encounter.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("participant")) {
                encounter.getParticipant().add(this.parseEncounterEncounterParticipantComponent(xmlPullParser, encounter));
            } else if (n == 2 && xmlPullParser.getName().equals("period")) {
                encounter.setPeriod(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("length")) {
                encounter.setLength(this.parseDuration(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reason")) {
                encounter.setReason(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("indication")) {
                encounter.setIndication(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("priority")) {
                encounter.setPriority(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("hospitalization")) {
                encounter.setHospitalization(this.parseEncounterEncounterHospitalizationComponent(xmlPullParser, encounter));
            } else if (n == 2 && xmlPullParser.getName().equals("location")) {
                encounter.getLocation().add(this.parseEncounterEncounterLocationComponent(xmlPullParser, encounter));
            } else if (n == 2 && xmlPullParser.getName().equals("serviceProvider")) {
                encounter.setServiceProvider(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("partOf")) {
                encounter.setPartOf(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, encounter)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return encounter;
    }

    private Encounter.EncounterParticipantComponent parseEncounterEncounterParticipantComponent(XmlPullParser xmlPullParser, Encounter encounter) throws Exception {
        Encounter.EncounterParticipantComponent encounterParticipantComponent = new Encounter.EncounterParticipantComponent();
        this.parseBackboneAttributes(xmlPullParser, encounterParticipantComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("type")) {
                encounterParticipantComponent.getType().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("individual")) {
                encounterParticipantComponent.setIndividual(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, encounterParticipantComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return encounterParticipantComponent;
    }

    private Encounter.EncounterHospitalizationComponent parseEncounterEncounterHospitalizationComponent(XmlPullParser xmlPullParser, Encounter encounter) throws Exception {
        Encounter.EncounterHospitalizationComponent encounterHospitalizationComponent = new Encounter.EncounterHospitalizationComponent();
        this.parseBackboneAttributes(xmlPullParser, encounterHospitalizationComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("preAdmissionIdentifier")) {
                encounterHospitalizationComponent.setPreAdmissionIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("origin")) {
                encounterHospitalizationComponent.setOrigin(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("admitSource")) {
                encounterHospitalizationComponent.setAdmitSource(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("period")) {
                encounterHospitalizationComponent.setPeriod(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("accomodation")) {
                encounterHospitalizationComponent.getAccomodation().add(this.parseEncounterEncounterHospitalizationAccomodationComponent(xmlPullParser, encounter));
            } else if (n == 2 && xmlPullParser.getName().equals("diet")) {
                encounterHospitalizationComponent.setDiet(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("specialCourtesy")) {
                encounterHospitalizationComponent.getSpecialCourtesy().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("specialArrangement")) {
                encounterHospitalizationComponent.getSpecialArrangement().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("destination")) {
                encounterHospitalizationComponent.setDestination(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dischargeDisposition")) {
                encounterHospitalizationComponent.setDischargeDisposition(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dischargeDiagnosis")) {
                encounterHospitalizationComponent.setDischargeDiagnosis(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reAdmission")) {
                encounterHospitalizationComponent.setReAdmission(this.parseBoolean(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, encounterHospitalizationComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return encounterHospitalizationComponent;
    }

    private Encounter.EncounterHospitalizationAccomodationComponent parseEncounterEncounterHospitalizationAccomodationComponent(XmlPullParser xmlPullParser, Encounter encounter) throws Exception {
        Encounter.EncounterHospitalizationAccomodationComponent encounterHospitalizationAccomodationComponent = new Encounter.EncounterHospitalizationAccomodationComponent();
        this.parseBackboneAttributes(xmlPullParser, encounterHospitalizationAccomodationComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("bed")) {
                encounterHospitalizationAccomodationComponent.setBed(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("period")) {
                encounterHospitalizationAccomodationComponent.setPeriod(this.parsePeriod(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, encounterHospitalizationAccomodationComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return encounterHospitalizationAccomodationComponent;
    }

    private Encounter.EncounterLocationComponent parseEncounterEncounterLocationComponent(XmlPullParser xmlPullParser, Encounter encounter) throws Exception {
        Encounter.EncounterLocationComponent encounterLocationComponent = new Encounter.EncounterLocationComponent();
        this.parseBackboneAttributes(xmlPullParser, encounterLocationComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("location")) {
                encounterLocationComponent.setLocation(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("period")) {
                encounterLocationComponent.setPeriod(this.parsePeriod(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, encounterLocationComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return encounterLocationComponent;
    }

    private FamilyHistory parseFamilyHistory(XmlPullParser xmlPullParser) throws Exception {
        FamilyHistory familyHistory = new FamilyHistory();
        this.parseResourceAttributes(xmlPullParser, familyHistory);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                familyHistory.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                familyHistory.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("note")) {
                familyHistory.setNote(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("relation")) {
                familyHistory.getRelation().add(this.parseFamilyHistoryFamilyHistoryRelationComponent(xmlPullParser, familyHistory));
            } else if (!this.parseResourceContent(n, xmlPullParser, familyHistory)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return familyHistory;
    }

    private FamilyHistory.FamilyHistoryRelationComponent parseFamilyHistoryFamilyHistoryRelationComponent(XmlPullParser xmlPullParser, FamilyHistory familyHistory) throws Exception {
        FamilyHistory.FamilyHistoryRelationComponent familyHistoryRelationComponent = new FamilyHistory.FamilyHistoryRelationComponent();
        this.parseBackboneAttributes(xmlPullParser, familyHistoryRelationComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("name")) {
                familyHistoryRelationComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("relationship")) {
                familyHistoryRelationComponent.setRelationship(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "born")) {
                familyHistoryRelationComponent.setBorn(this.parseType("born", xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "deceased")) {
                familyHistoryRelationComponent.setDeceased(this.parseType("deceased", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("note")) {
                familyHistoryRelationComponent.setNote(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("condition")) {
                familyHistoryRelationComponent.getCondition().add(this.parseFamilyHistoryFamilyHistoryRelationConditionComponent(xmlPullParser, familyHistory));
            } else if (!this.parseBackboneContent(n, xmlPullParser, familyHistoryRelationComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return familyHistoryRelationComponent;
    }

    private FamilyHistory.FamilyHistoryRelationConditionComponent parseFamilyHistoryFamilyHistoryRelationConditionComponent(XmlPullParser xmlPullParser, FamilyHistory familyHistory) throws Exception {
        FamilyHistory.FamilyHistoryRelationConditionComponent familyHistoryRelationConditionComponent = new FamilyHistory.FamilyHistoryRelationConditionComponent();
        this.parseBackboneAttributes(xmlPullParser, familyHistoryRelationConditionComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("type")) {
                familyHistoryRelationConditionComponent.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("outcome")) {
                familyHistoryRelationConditionComponent.setOutcome(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "onset")) {
                familyHistoryRelationConditionComponent.setOnset(this.parseType("onset", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("note")) {
                familyHistoryRelationConditionComponent.setNote(this.parseString(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, familyHistoryRelationConditionComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return familyHistoryRelationConditionComponent;
    }

    private Group parseGroup(XmlPullParser xmlPullParser) throws Exception {
        Group group = new Group();
        this.parseResourceAttributes(xmlPullParser, group);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                group.setIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                group.setType(this.parseEnumeration(xmlPullParser, Group.GroupType.Null, new Group.GroupTypeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("actual")) {
                group.setActual(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                group.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                group.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("quantity")) {
                group.setQuantity(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("characteristic")) {
                group.getCharacteristic().add(this.parseGroupGroupCharacteristicComponent(xmlPullParser, group));
            } else if (n == 2 && xmlPullParser.getName().equals("member")) {
                group.getMember().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, group)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return group;
    }

    private Group.GroupCharacteristicComponent parseGroupGroupCharacteristicComponent(XmlPullParser xmlPullParser, Group group) throws Exception {
        Group.GroupCharacteristicComponent groupCharacteristicComponent = new Group.GroupCharacteristicComponent();
        this.parseBackboneAttributes(xmlPullParser, groupCharacteristicComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                groupCharacteristicComponent.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "value")) {
                groupCharacteristicComponent.setValue(this.parseType("value", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("exclude")) {
                groupCharacteristicComponent.setExclude(this.parseBoolean(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, groupCharacteristicComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return groupCharacteristicComponent;
    }

    private ImagingStudy parseImagingStudy(XmlPullParser xmlPullParser) throws Exception {
        ImagingStudy imagingStudy = new ImagingStudy();
        this.parseResourceAttributes(xmlPullParser, imagingStudy);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("dateTime")) {
                imagingStudy.setDateTime(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                imagingStudy.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("uid")) {
                imagingStudy.setUid(this.parseOid(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("accessionNo")) {
                imagingStudy.setAccessionNo(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                imagingStudy.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("order")) {
                imagingStudy.getOrder().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("modality")) {
                imagingStudy.getModality().add(this.parseEnumeration(xmlPullParser, ImagingStudy.ImagingModality.Null, new ImagingStudy.ImagingModalityEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("referrer")) {
                imagingStudy.setReferrer(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("availability")) {
                imagingStudy.setAvailability(this.parseEnumeration(xmlPullParser, ImagingStudy.InstanceAvailability.Null, new ImagingStudy.InstanceAvailabilityEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("url")) {
                imagingStudy.setUrl(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("numberOfSeries")) {
                imagingStudy.setNumberOfSeries(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("numberOfInstances")) {
                imagingStudy.setNumberOfInstances(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("clinicalInformation")) {
                imagingStudy.setClinicalInformation(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("procedure")) {
                imagingStudy.getProcedure().add(this.parseCoding(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("interpreter")) {
                imagingStudy.setInterpreter(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                imagingStudy.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("series")) {
                imagingStudy.getSeries().add(this.parseImagingStudyImagingStudySeriesComponent(xmlPullParser, imagingStudy));
            } else if (!this.parseResourceContent(n, xmlPullParser, imagingStudy)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return imagingStudy;
    }

    private ImagingStudy.ImagingStudySeriesComponent parseImagingStudyImagingStudySeriesComponent(XmlPullParser xmlPullParser, ImagingStudy imagingStudy) throws Exception {
        ImagingStudy.ImagingStudySeriesComponent imagingStudySeriesComponent = new ImagingStudy.ImagingStudySeriesComponent();
        this.parseBackboneAttributes(xmlPullParser, imagingStudySeriesComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("number")) {
                imagingStudySeriesComponent.setNumber(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("modality")) {
                imagingStudySeriesComponent.setModality(this.parseEnumeration(xmlPullParser, ImagingStudy.Modality.Null, new ImagingStudy.ModalityEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("uid")) {
                imagingStudySeriesComponent.setUid(this.parseOid(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                imagingStudySeriesComponent.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("numberOfInstances")) {
                imagingStudySeriesComponent.setNumberOfInstances(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("availability")) {
                imagingStudySeriesComponent.setAvailability(this.parseEnumeration(xmlPullParser, ImagingStudy.InstanceAvailability.Null, new ImagingStudy.InstanceAvailabilityEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("url")) {
                imagingStudySeriesComponent.setUrl(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("bodySite")) {
                imagingStudySeriesComponent.setBodySite(this.parseCoding(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dateTime")) {
                imagingStudySeriesComponent.setDateTime(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("instance")) {
                imagingStudySeriesComponent.getInstance().add(this.parseImagingStudyImagingStudySeriesInstanceComponent(xmlPullParser, imagingStudy));
            } else if (!this.parseBackboneContent(n, xmlPullParser, imagingStudySeriesComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return imagingStudySeriesComponent;
    }

    private ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudyImagingStudySeriesInstanceComponent(XmlPullParser xmlPullParser, ImagingStudy imagingStudy) throws Exception {
        ImagingStudy.ImagingStudySeriesInstanceComponent imagingStudySeriesInstanceComponent = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        this.parseBackboneAttributes(xmlPullParser, imagingStudySeriesInstanceComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("number")) {
                imagingStudySeriesInstanceComponent.setNumber(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("uid")) {
                imagingStudySeriesInstanceComponent.setUid(this.parseOid(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("sopclass")) {
                imagingStudySeriesInstanceComponent.setSopclass(this.parseOid(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                imagingStudySeriesInstanceComponent.setType(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("title")) {
                imagingStudySeriesInstanceComponent.setTitle(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("url")) {
                imagingStudySeriesInstanceComponent.setUrl(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("attachment")) {
                imagingStudySeriesInstanceComponent.setAttachment(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, imagingStudySeriesInstanceComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return imagingStudySeriesInstanceComponent;
    }

    private Immunization parseImmunization(XmlPullParser xmlPullParser) throws Exception {
        Immunization immunization = new Immunization();
        this.parseResourceAttributes(xmlPullParser, immunization);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                immunization.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("date")) {
                immunization.setDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("vaccineType")) {
                immunization.setVaccineType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                immunization.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("refusedIndicator")) {
                immunization.setRefusedIndicator(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reported")) {
                immunization.setReported(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("performer")) {
                immunization.setPerformer(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("requester")) {
                immunization.setRequester(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("manufacturer")) {
                immunization.setManufacturer(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("location")) {
                immunization.setLocation(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("lotNumber")) {
                immunization.setLotNumber(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("expirationDate")) {
                immunization.setExpirationDate(this.parseDate(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("site")) {
                immunization.setSite(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("route")) {
                immunization.setRoute(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("doseQuantity")) {
                immunization.setDoseQuantity(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("explanation")) {
                immunization.setExplanation(this.parseImmunizationImmunizationExplanationComponent(xmlPullParser, immunization));
            } else if (n == 2 && xmlPullParser.getName().equals("reaction")) {
                immunization.getReaction().add(this.parseImmunizationImmunizationReactionComponent(xmlPullParser, immunization));
            } else if (n == 2 && xmlPullParser.getName().equals("vaccinationProtocol")) {
                immunization.getVaccinationProtocol().add(this.parseImmunizationImmunizationVaccinationProtocolComponent(xmlPullParser, immunization));
            } else if (!this.parseResourceContent(n, xmlPullParser, immunization)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return immunization;
    }

    private Immunization.ImmunizationExplanationComponent parseImmunizationImmunizationExplanationComponent(XmlPullParser xmlPullParser, Immunization immunization) throws Exception {
        Immunization.ImmunizationExplanationComponent immunizationExplanationComponent = new Immunization.ImmunizationExplanationComponent();
        this.parseBackboneAttributes(xmlPullParser, immunizationExplanationComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("reason")) {
                immunizationExplanationComponent.getReason().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("refusalReason")) {
                immunizationExplanationComponent.getRefusalReason().add(this.parseCodeableConcept(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, immunizationExplanationComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return immunizationExplanationComponent;
    }

    private Immunization.ImmunizationReactionComponent parseImmunizationImmunizationReactionComponent(XmlPullParser xmlPullParser, Immunization immunization) throws Exception {
        Immunization.ImmunizationReactionComponent immunizationReactionComponent = new Immunization.ImmunizationReactionComponent();
        this.parseBackboneAttributes(xmlPullParser, immunizationReactionComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("date")) {
                immunizationReactionComponent.setDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("detail")) {
                immunizationReactionComponent.setDetail(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reported")) {
                immunizationReactionComponent.setReported(this.parseBoolean(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, immunizationReactionComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return immunizationReactionComponent;
    }

    private Immunization.ImmunizationVaccinationProtocolComponent parseImmunizationImmunizationVaccinationProtocolComponent(XmlPullParser xmlPullParser, Immunization immunization) throws Exception {
        Immunization.ImmunizationVaccinationProtocolComponent immunizationVaccinationProtocolComponent = new Immunization.ImmunizationVaccinationProtocolComponent();
        this.parseBackboneAttributes(xmlPullParser, immunizationVaccinationProtocolComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("doseSequence")) {
                immunizationVaccinationProtocolComponent.setDoseSequence(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                immunizationVaccinationProtocolComponent.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("authority")) {
                immunizationVaccinationProtocolComponent.setAuthority(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("series")) {
                immunizationVaccinationProtocolComponent.setSeries(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("seriesDoses")) {
                immunizationVaccinationProtocolComponent.setSeriesDoses(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("doseTarget")) {
                immunizationVaccinationProtocolComponent.setDoseTarget(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("doseStatus")) {
                immunizationVaccinationProtocolComponent.setDoseStatus(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("doseStatusReason")) {
                immunizationVaccinationProtocolComponent.setDoseStatusReason(this.parseCodeableConcept(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, immunizationVaccinationProtocolComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return immunizationVaccinationProtocolComponent;
    }

    private ImmunizationRecommendation parseImmunizationRecommendation(XmlPullParser xmlPullParser) throws Exception {
        ImmunizationRecommendation immunizationRecommendation = new ImmunizationRecommendation();
        this.parseResourceAttributes(xmlPullParser, immunizationRecommendation);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                immunizationRecommendation.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                immunizationRecommendation.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("recommendation")) {
                immunizationRecommendation.getRecommendation().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(xmlPullParser, immunizationRecommendation));
            } else if (!this.parseResourceContent(n, xmlPullParser, immunizationRecommendation)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return immunizationRecommendation;
    }

    private ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(XmlPullParser xmlPullParser, ImmunizationRecommendation immunizationRecommendation) throws Exception {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent immunizationRecommendationRecommendationComponent = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
        this.parseBackboneAttributes(xmlPullParser, immunizationRecommendationRecommendationComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("date")) {
                immunizationRecommendationRecommendationComponent.setDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("vaccineType")) {
                immunizationRecommendationRecommendationComponent.setVaccineType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("doseNumber")) {
                immunizationRecommendationRecommendationComponent.setDoseNumber(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("forecastStatus")) {
                immunizationRecommendationRecommendationComponent.setForecastStatus(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dateCriterion")) {
                immunizationRecommendationRecommendationComponent.getDateCriterion().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(xmlPullParser, immunizationRecommendation));
            } else if (n == 2 && xmlPullParser.getName().equals("protocol")) {
                immunizationRecommendationRecommendationComponent.setProtocol(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(xmlPullParser, immunizationRecommendation));
            } else if (n == 2 && xmlPullParser.getName().equals("supportingImmunization")) {
                immunizationRecommendationRecommendationComponent.getSupportingImmunization().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("supportingPatientInformation")) {
                immunizationRecommendationRecommendationComponent.getSupportingPatientInformation().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, immunizationRecommendationRecommendationComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return immunizationRecommendationRecommendationComponent;
    }

    private ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(XmlPullParser xmlPullParser, ImmunizationRecommendation immunizationRecommendation) throws Exception {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent immunizationRecommendationRecommendationDateCriterionComponent = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
        this.parseBackboneAttributes(xmlPullParser, immunizationRecommendationRecommendationDateCriterionComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                immunizationRecommendationRecommendationDateCriterionComponent.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("value")) {
                immunizationRecommendationRecommendationDateCriterionComponent.setValue(this.parseDateTime(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, immunizationRecommendationRecommendationDateCriterionComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return immunizationRecommendationRecommendationDateCriterionComponent;
    }

    private ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(XmlPullParser xmlPullParser, ImmunizationRecommendation immunizationRecommendation) throws Exception {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent immunizationRecommendationRecommendationProtocolComponent = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent();
        this.parseBackboneAttributes(xmlPullParser, immunizationRecommendationRecommendationProtocolComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("doseSequence")) {
                immunizationRecommendationRecommendationProtocolComponent.setDoseSequence(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                immunizationRecommendationRecommendationProtocolComponent.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("authority")) {
                immunizationRecommendationRecommendationProtocolComponent.setAuthority(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("series")) {
                immunizationRecommendationRecommendationProtocolComponent.setSeries(this.parseString(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, immunizationRecommendationRecommendationProtocolComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return immunizationRecommendationRecommendationProtocolComponent;
    }

    private List_ parseList_(XmlPullParser xmlPullParser) throws Exception {
        List_ list_ = new List_();
        this.parseResourceAttributes(xmlPullParser, list_);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                list_.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                list_.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                list_.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("source")) {
                list_.setSource(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("date")) {
                list_.setDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("ordered")) {
                list_.setOrdered(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("mode")) {
                list_.setMode(this.parseEnumeration(xmlPullParser, List_.ListMode.Null, new List_.ListModeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("entry")) {
                list_.getEntry().add(this.parseList_ListEntryComponent(xmlPullParser, list_));
            } else if (n == 2 && xmlPullParser.getName().equals("emptyReason")) {
                list_.setEmptyReason(this.parseCodeableConcept(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, list_)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return list_;
    }

    private List_.ListEntryComponent parseList_ListEntryComponent(XmlPullParser xmlPullParser, List_ list_) throws Exception {
        List_.ListEntryComponent listEntryComponent = new List_.ListEntryComponent();
        this.parseBackboneAttributes(xmlPullParser, listEntryComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("flag")) {
                listEntryComponent.getFlag().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("deleted")) {
                listEntryComponent.setDeleted(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("date")) {
                listEntryComponent.setDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("item")) {
                listEntryComponent.setItem(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, listEntryComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return listEntryComponent;
    }

    private Location parseLocation(XmlPullParser xmlPullParser) throws Exception {
        Location location = new Location();
        this.parseResourceAttributes(xmlPullParser, location);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                location.setIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                location.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                location.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                location.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("telecom")) {
                location.getTelecom().add(this.parseContact(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("address")) {
                location.setAddress(this.parseAddress(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("physicalType")) {
                location.setPhysicalType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("position")) {
                location.setPosition(this.parseLocationLocationPositionComponent(xmlPullParser, location));
            } else if (n == 2 && xmlPullParser.getName().equals("managingOrganization")) {
                location.setManagingOrganization(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                location.setStatus(this.parseEnumeration(xmlPullParser, Location.LocationStatus.Null, new Location.LocationStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("partOf")) {
                location.setPartOf(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("mode")) {
                location.setMode(this.parseEnumeration(xmlPullParser, Location.LocationMode.Null, new Location.LocationModeEnumFactory()));
            } else if (!this.parseResourceContent(n, xmlPullParser, location)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return location;
    }

    private Location.LocationPositionComponent parseLocationLocationPositionComponent(XmlPullParser xmlPullParser, Location location) throws Exception {
        Location.LocationPositionComponent locationPositionComponent = new Location.LocationPositionComponent();
        this.parseBackboneAttributes(xmlPullParser, locationPositionComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("longitude")) {
                locationPositionComponent.setLongitude(this.parseDecimal(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("latitude")) {
                locationPositionComponent.setLatitude(this.parseDecimal(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("altitude")) {
                locationPositionComponent.setAltitude(this.parseDecimal(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, locationPositionComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return locationPositionComponent;
    }

    private Media parseMedia(XmlPullParser xmlPullParser) throws Exception {
        Media media = new Media();
        this.parseResourceAttributes(xmlPullParser, media);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("type")) {
                media.setType(this.parseEnumeration(xmlPullParser, Media.MediaType.Null, new Media.MediaTypeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("subtype")) {
                media.setSubtype(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                media.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dateTime")) {
                media.setDateTime(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                media.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("operator")) {
                media.setOperator(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("view")) {
                media.setView(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("deviceName")) {
                media.setDeviceName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("height")) {
                media.setHeight(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("width")) {
                media.setWidth(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("frames")) {
                media.setFrames(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("length")) {
                media.setLength(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("content")) {
                media.setContent(this.parseAttachment(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, media)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return media;
    }

    private Medication parseMedication(XmlPullParser xmlPullParser) throws Exception {
        Medication medication = new Medication();
        this.parseResourceAttributes(xmlPullParser, medication);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("name")) {
                medication.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                medication.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("isBrand")) {
                medication.setIsBrand(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("manufacturer")) {
                medication.setManufacturer(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("kind")) {
                medication.setKind(this.parseEnumeration(xmlPullParser, Medication.MedicationKind.Null, new Medication.MedicationKindEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("product")) {
                medication.setProduct(this.parseMedicationMedicationProductComponent(xmlPullParser, medication));
            } else if (n == 2 && xmlPullParser.getName().equals("package")) {
                medication.setPackage(this.parseMedicationMedicationPackageComponent(xmlPullParser, medication));
            } else if (!this.parseResourceContent(n, xmlPullParser, medication)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medication;
    }

    private Medication.MedicationProductComponent parseMedicationMedicationProductComponent(XmlPullParser xmlPullParser, Medication medication) throws Exception {
        Medication.MedicationProductComponent medicationProductComponent = new Medication.MedicationProductComponent();
        this.parseBackboneAttributes(xmlPullParser, medicationProductComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("form")) {
                medicationProductComponent.setForm(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("ingredient")) {
                medicationProductComponent.getIngredient().add(this.parseMedicationMedicationProductIngredientComponent(xmlPullParser, medication));
            } else if (!this.parseBackboneContent(n, xmlPullParser, medicationProductComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationProductComponent;
    }

    private Medication.MedicationProductIngredientComponent parseMedicationMedicationProductIngredientComponent(XmlPullParser xmlPullParser, Medication medication) throws Exception {
        Medication.MedicationProductIngredientComponent medicationProductIngredientComponent = new Medication.MedicationProductIngredientComponent();
        this.parseBackboneAttributes(xmlPullParser, medicationProductIngredientComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("item")) {
                medicationProductIngredientComponent.setItem(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("amount")) {
                medicationProductIngredientComponent.setAmount(this.parseRatio(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, medicationProductIngredientComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationProductIngredientComponent;
    }

    private Medication.MedicationPackageComponent parseMedicationMedicationPackageComponent(XmlPullParser xmlPullParser, Medication medication) throws Exception {
        Medication.MedicationPackageComponent medicationPackageComponent = new Medication.MedicationPackageComponent();
        this.parseBackboneAttributes(xmlPullParser, medicationPackageComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("container")) {
                medicationPackageComponent.setContainer(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("content")) {
                medicationPackageComponent.getContent().add(this.parseMedicationMedicationPackageContentComponent(xmlPullParser, medication));
            } else if (!this.parseBackboneContent(n, xmlPullParser, medicationPackageComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationPackageComponent;
    }

    private Medication.MedicationPackageContentComponent parseMedicationMedicationPackageContentComponent(XmlPullParser xmlPullParser, Medication medication) throws Exception {
        Medication.MedicationPackageContentComponent medicationPackageContentComponent = new Medication.MedicationPackageContentComponent();
        this.parseBackboneAttributes(xmlPullParser, medicationPackageContentComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("item")) {
                medicationPackageContentComponent.setItem(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("amount")) {
                medicationPackageContentComponent.setAmount(this.parseQuantity(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, medicationPackageContentComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationPackageContentComponent;
    }

    private MedicationAdministration parseMedicationAdministration(XmlPullParser xmlPullParser) throws Exception {
        MedicationAdministration medicationAdministration = new MedicationAdministration();
        this.parseResourceAttributes(xmlPullParser, medicationAdministration);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                medicationAdministration.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                medicationAdministration.setStatus(this.parseEnumeration(xmlPullParser, MedicationAdministration.MedicationAdminStatus.Null, new MedicationAdministration.MedicationAdminStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("patient")) {
                medicationAdministration.setPatient(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("practitioner")) {
                medicationAdministration.setPractitioner(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("encounter")) {
                medicationAdministration.setEncounter(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("prescription")) {
                medicationAdministration.setPrescription(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("wasNotGiven")) {
                medicationAdministration.setWasNotGiven(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reasonNotGiven")) {
                medicationAdministration.getReasonNotGiven().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("whenGiven")) {
                medicationAdministration.setWhenGiven(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("medication")) {
                medicationAdministration.setMedication(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("device")) {
                medicationAdministration.getDevice().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dosage")) {
                medicationAdministration.getDosage().add(this.parseMedicationAdministrationMedicationAdministrationDosageComponent(xmlPullParser, medicationAdministration));
            } else if (!this.parseResourceContent(n, xmlPullParser, medicationAdministration)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationAdministration;
    }

    private MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationMedicationAdministrationDosageComponent(XmlPullParser xmlPullParser, MedicationAdministration medicationAdministration) throws Exception {
        MedicationAdministration.MedicationAdministrationDosageComponent medicationAdministrationDosageComponent = new MedicationAdministration.MedicationAdministrationDosageComponent();
        this.parseBackboneAttributes(xmlPullParser, medicationAdministrationDosageComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && this.nameIsTypeName(xmlPullParser, "timing")) {
                medicationAdministrationDosageComponent.setTiming(this.parseType("timing", xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "asNeeded")) {
                medicationAdministrationDosageComponent.setAsNeeded(this.parseType("asNeeded", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("site")) {
                medicationAdministrationDosageComponent.setSite(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("route")) {
                medicationAdministrationDosageComponent.setRoute(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("method")) {
                medicationAdministrationDosageComponent.setMethod(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("quantity")) {
                medicationAdministrationDosageComponent.setQuantity(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("rate")) {
                medicationAdministrationDosageComponent.setRate(this.parseRatio(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("maxDosePerPeriod")) {
                medicationAdministrationDosageComponent.setMaxDosePerPeriod(this.parseRatio(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, medicationAdministrationDosageComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationAdministrationDosageComponent;
    }

    private MedicationDispense parseMedicationDispense(XmlPullParser xmlPullParser) throws Exception {
        MedicationDispense medicationDispense = new MedicationDispense();
        this.parseResourceAttributes(xmlPullParser, medicationDispense);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                medicationDispense.setIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                medicationDispense.setStatus(this.parseEnumeration(xmlPullParser, MedicationDispense.MedicationDispenseStatus.Null, new MedicationDispense.MedicationDispenseStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("patient")) {
                medicationDispense.setPatient(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dispenser")) {
                medicationDispense.setDispenser(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("authorizingPrescription")) {
                medicationDispense.getAuthorizingPrescription().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dispense")) {
                medicationDispense.getDispense().add(this.parseMedicationDispenseMedicationDispenseDispenseComponent(xmlPullParser, medicationDispense));
            } else if (n == 2 && xmlPullParser.getName().equals("substitution")) {
                medicationDispense.setSubstitution(this.parseMedicationDispenseMedicationDispenseSubstitutionComponent(xmlPullParser, medicationDispense));
            } else if (!this.parseResourceContent(n, xmlPullParser, medicationDispense)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationDispense;
    }

    private MedicationDispense.MedicationDispenseDispenseComponent parseMedicationDispenseMedicationDispenseDispenseComponent(XmlPullParser xmlPullParser, MedicationDispense medicationDispense) throws Exception {
        MedicationDispense.MedicationDispenseDispenseComponent medicationDispenseDispenseComponent = new MedicationDispense.MedicationDispenseDispenseComponent();
        this.parseBackboneAttributes(xmlPullParser, medicationDispenseDispenseComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                medicationDispenseDispenseComponent.setIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                medicationDispenseDispenseComponent.setStatus(this.parseEnumeration(xmlPullParser, MedicationDispense.MedicationDispenseStatus.Null, new MedicationDispense.MedicationDispenseStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                medicationDispenseDispenseComponent.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("quantity")) {
                medicationDispenseDispenseComponent.setQuantity(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("medication")) {
                medicationDispenseDispenseComponent.setMedication(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("whenPrepared")) {
                medicationDispenseDispenseComponent.setWhenPrepared(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("whenHandedOver")) {
                medicationDispenseDispenseComponent.setWhenHandedOver(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("destination")) {
                medicationDispenseDispenseComponent.setDestination(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("receiver")) {
                medicationDispenseDispenseComponent.getReceiver().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dosage")) {
                medicationDispenseDispenseComponent.getDosage().add(this.parseMedicationDispenseMedicationDispenseDispenseDosageComponent(xmlPullParser, medicationDispense));
            } else if (!this.parseBackboneContent(n, xmlPullParser, medicationDispenseDispenseComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationDispenseDispenseComponent;
    }

    private MedicationDispense.MedicationDispenseDispenseDosageComponent parseMedicationDispenseMedicationDispenseDispenseDosageComponent(XmlPullParser xmlPullParser, MedicationDispense medicationDispense) throws Exception {
        MedicationDispense.MedicationDispenseDispenseDosageComponent medicationDispenseDispenseDosageComponent = new MedicationDispense.MedicationDispenseDispenseDosageComponent();
        this.parseBackboneAttributes(xmlPullParser, medicationDispenseDispenseDosageComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("additionalInstructions")) {
                medicationDispenseDispenseDosageComponent.setAdditionalInstructions(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "timing")) {
                medicationDispenseDispenseDosageComponent.setTiming(this.parseType("timing", xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "asNeeded")) {
                medicationDispenseDispenseDosageComponent.setAsNeeded(this.parseType("asNeeded", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("site")) {
                medicationDispenseDispenseDosageComponent.setSite(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("route")) {
                medicationDispenseDispenseDosageComponent.setRoute(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("method")) {
                medicationDispenseDispenseDosageComponent.setMethod(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("quantity")) {
                medicationDispenseDispenseDosageComponent.setQuantity(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("rate")) {
                medicationDispenseDispenseDosageComponent.setRate(this.parseRatio(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("maxDosePerPeriod")) {
                medicationDispenseDispenseDosageComponent.setMaxDosePerPeriod(this.parseRatio(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, medicationDispenseDispenseDosageComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationDispenseDispenseDosageComponent;
    }

    private MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseMedicationDispenseSubstitutionComponent(XmlPullParser xmlPullParser, MedicationDispense medicationDispense) throws Exception {
        MedicationDispense.MedicationDispenseSubstitutionComponent medicationDispenseSubstitutionComponent = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        this.parseBackboneAttributes(xmlPullParser, medicationDispenseSubstitutionComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("type")) {
                medicationDispenseSubstitutionComponent.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reason")) {
                medicationDispenseSubstitutionComponent.getReason().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("responsibleParty")) {
                medicationDispenseSubstitutionComponent.getResponsibleParty().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, medicationDispenseSubstitutionComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationDispenseSubstitutionComponent;
    }

    private MedicationPrescription parseMedicationPrescription(XmlPullParser xmlPullParser) throws Exception {
        MedicationPrescription medicationPrescription = new MedicationPrescription();
        this.parseResourceAttributes(xmlPullParser, medicationPrescription);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                medicationPrescription.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dateWritten")) {
                medicationPrescription.setDateWritten(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                medicationPrescription.setStatus(this.parseEnumeration(xmlPullParser, MedicationPrescription.MedicationPrescriptionStatus.Null, new MedicationPrescription.MedicationPrescriptionStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("patient")) {
                medicationPrescription.setPatient(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("prescriber")) {
                medicationPrescription.setPrescriber(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("encounter")) {
                medicationPrescription.setEncounter(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "reason")) {
                medicationPrescription.setReason(this.parseType("reason", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("medication")) {
                medicationPrescription.setMedication(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dosageInstruction")) {
                medicationPrescription.getDosageInstruction().add(this.parseMedicationPrescriptionMedicationPrescriptionDosageInstructionComponent(xmlPullParser, medicationPrescription));
            } else if (n == 2 && xmlPullParser.getName().equals("dispense")) {
                medicationPrescription.setDispense(this.parseMedicationPrescriptionMedicationPrescriptionDispenseComponent(xmlPullParser, medicationPrescription));
            } else if (n == 2 && xmlPullParser.getName().equals("substitution")) {
                medicationPrescription.setSubstitution(this.parseMedicationPrescriptionMedicationPrescriptionSubstitutionComponent(xmlPullParser, medicationPrescription));
            } else if (!this.parseResourceContent(n, xmlPullParser, medicationPrescription)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationPrescription;
    }

    private MedicationPrescription.MedicationPrescriptionDosageInstructionComponent parseMedicationPrescriptionMedicationPrescriptionDosageInstructionComponent(XmlPullParser xmlPullParser, MedicationPrescription medicationPrescription) throws Exception {
        MedicationPrescription.MedicationPrescriptionDosageInstructionComponent medicationPrescriptionDosageInstructionComponent = new MedicationPrescription.MedicationPrescriptionDosageInstructionComponent();
        this.parseBackboneAttributes(xmlPullParser, medicationPrescriptionDosageInstructionComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("text")) {
                medicationPrescriptionDosageInstructionComponent.setText(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("additionalInstructions")) {
                medicationPrescriptionDosageInstructionComponent.setAdditionalInstructions(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "timing")) {
                medicationPrescriptionDosageInstructionComponent.setTiming(this.parseType("timing", xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "asNeeded")) {
                medicationPrescriptionDosageInstructionComponent.setAsNeeded(this.parseType("asNeeded", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("site")) {
                medicationPrescriptionDosageInstructionComponent.setSite(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("route")) {
                medicationPrescriptionDosageInstructionComponent.setRoute(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("method")) {
                medicationPrescriptionDosageInstructionComponent.setMethod(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("doseQuantity")) {
                medicationPrescriptionDosageInstructionComponent.setDoseQuantity(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("rate")) {
                medicationPrescriptionDosageInstructionComponent.setRate(this.parseRatio(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("maxDosePerPeriod")) {
                medicationPrescriptionDosageInstructionComponent.setMaxDosePerPeriod(this.parseRatio(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, medicationPrescriptionDosageInstructionComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationPrescriptionDosageInstructionComponent;
    }

    private MedicationPrescription.MedicationPrescriptionDispenseComponent parseMedicationPrescriptionMedicationPrescriptionDispenseComponent(XmlPullParser xmlPullParser, MedicationPrescription medicationPrescription) throws Exception {
        MedicationPrescription.MedicationPrescriptionDispenseComponent medicationPrescriptionDispenseComponent = new MedicationPrescription.MedicationPrescriptionDispenseComponent();
        this.parseBackboneAttributes(xmlPullParser, medicationPrescriptionDispenseComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("medication")) {
                medicationPrescriptionDispenseComponent.setMedication(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("validityPeriod")) {
                medicationPrescriptionDispenseComponent.setValidityPeriod(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("numberOfRepeatsAllowed")) {
                medicationPrescriptionDispenseComponent.setNumberOfRepeatsAllowed(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("quantity")) {
                medicationPrescriptionDispenseComponent.setQuantity(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("expectedSupplyDuration")) {
                medicationPrescriptionDispenseComponent.setExpectedSupplyDuration(this.parseDuration(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, medicationPrescriptionDispenseComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationPrescriptionDispenseComponent;
    }

    private MedicationPrescription.MedicationPrescriptionSubstitutionComponent parseMedicationPrescriptionMedicationPrescriptionSubstitutionComponent(XmlPullParser xmlPullParser, MedicationPrescription medicationPrescription) throws Exception {
        MedicationPrescription.MedicationPrescriptionSubstitutionComponent medicationPrescriptionSubstitutionComponent = new MedicationPrescription.MedicationPrescriptionSubstitutionComponent();
        this.parseBackboneAttributes(xmlPullParser, medicationPrescriptionSubstitutionComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("type")) {
                medicationPrescriptionSubstitutionComponent.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reason")) {
                medicationPrescriptionSubstitutionComponent.setReason(this.parseCodeableConcept(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, medicationPrescriptionSubstitutionComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationPrescriptionSubstitutionComponent;
    }

    private MedicationStatement parseMedicationStatement(XmlPullParser xmlPullParser) throws Exception {
        MedicationStatement medicationStatement = new MedicationStatement();
        this.parseResourceAttributes(xmlPullParser, medicationStatement);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                medicationStatement.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("patient")) {
                medicationStatement.setPatient(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("wasNotGiven")) {
                medicationStatement.setWasNotGiven(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reasonNotGiven")) {
                medicationStatement.getReasonNotGiven().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("whenGiven")) {
                medicationStatement.setWhenGiven(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("medication")) {
                medicationStatement.setMedication(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("device")) {
                medicationStatement.getDevice().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dosage")) {
                medicationStatement.getDosage().add(this.parseMedicationStatementMedicationStatementDosageComponent(xmlPullParser, medicationStatement));
            } else if (!this.parseResourceContent(n, xmlPullParser, medicationStatement)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationStatement;
    }

    private MedicationStatement.MedicationStatementDosageComponent parseMedicationStatementMedicationStatementDosageComponent(XmlPullParser xmlPullParser, MedicationStatement medicationStatement) throws Exception {
        MedicationStatement.MedicationStatementDosageComponent medicationStatementDosageComponent = new MedicationStatement.MedicationStatementDosageComponent();
        this.parseBackboneAttributes(xmlPullParser, medicationStatementDosageComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("timing")) {
                medicationStatementDosageComponent.setTiming(this.parseSchedule(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "asNeeded")) {
                medicationStatementDosageComponent.setAsNeeded(this.parseType("asNeeded", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("site")) {
                medicationStatementDosageComponent.setSite(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("route")) {
                medicationStatementDosageComponent.setRoute(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("method")) {
                medicationStatementDosageComponent.setMethod(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("quantity")) {
                medicationStatementDosageComponent.setQuantity(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("rate")) {
                medicationStatementDosageComponent.setRate(this.parseRatio(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("maxDosePerPeriod")) {
                medicationStatementDosageComponent.setMaxDosePerPeriod(this.parseRatio(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, medicationStatementDosageComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return medicationStatementDosageComponent;
    }

    private MessageHeader parseMessageHeader(XmlPullParser xmlPullParser) throws Exception {
        MessageHeader messageHeader = new MessageHeader();
        this.parseResourceAttributes(xmlPullParser, messageHeader);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                messageHeader.setIdentifier(this.parseId(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("timestamp")) {
                messageHeader.setTimestamp(this.parseInstant(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("event")) {
                messageHeader.setEvent(this.parseCoding(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("response")) {
                messageHeader.setResponse(this.parseMessageHeaderMessageHeaderResponseComponent(xmlPullParser, messageHeader));
            } else if (n == 2 && xmlPullParser.getName().equals("source")) {
                messageHeader.setSource(this.parseMessageHeaderMessageSourceComponent(xmlPullParser, messageHeader));
            } else if (n == 2 && xmlPullParser.getName().equals("destination")) {
                messageHeader.getDestination().add(this.parseMessageHeaderMessageDestinationComponent(xmlPullParser, messageHeader));
            } else if (n == 2 && xmlPullParser.getName().equals("enterer")) {
                messageHeader.setEnterer(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("author")) {
                messageHeader.setAuthor(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("receiver")) {
                messageHeader.setReceiver(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("responsible")) {
                messageHeader.setResponsible(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reason")) {
                messageHeader.setReason(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("data")) {
                messageHeader.getData().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, messageHeader)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return messageHeader;
    }

    private MessageHeader.MessageHeaderResponseComponent parseMessageHeaderMessageHeaderResponseComponent(XmlPullParser xmlPullParser, MessageHeader messageHeader) throws Exception {
        MessageHeader.MessageHeaderResponseComponent messageHeaderResponseComponent = new MessageHeader.MessageHeaderResponseComponent();
        this.parseBackboneAttributes(xmlPullParser, messageHeaderResponseComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                messageHeaderResponseComponent.setIdentifier(this.parseId(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                messageHeaderResponseComponent.setCode(this.parseEnumeration(xmlPullParser, MessageHeader.ResponseCode.Null, new MessageHeader.ResponseCodeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("details")) {
                messageHeaderResponseComponent.setDetails(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, messageHeaderResponseComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return messageHeaderResponseComponent;
    }

    private MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(XmlPullParser xmlPullParser, MessageHeader messageHeader) throws Exception {
        MessageHeader.MessageSourceComponent messageSourceComponent = new MessageHeader.MessageSourceComponent();
        this.parseBackboneAttributes(xmlPullParser, messageSourceComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("name")) {
                messageSourceComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("software")) {
                messageSourceComponent.setSoftware(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("version")) {
                messageSourceComponent.setVersion(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("contact")) {
                messageSourceComponent.setContact(this.parseContact(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("endpoint")) {
                messageSourceComponent.setEndpoint(this.parseUri(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, messageSourceComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return messageSourceComponent;
    }

    private MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(XmlPullParser xmlPullParser, MessageHeader messageHeader) throws Exception {
        MessageHeader.MessageDestinationComponent messageDestinationComponent = new MessageHeader.MessageDestinationComponent();
        this.parseBackboneAttributes(xmlPullParser, messageDestinationComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("name")) {
                messageDestinationComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("target")) {
                messageDestinationComponent.setTarget(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("endpoint")) {
                messageDestinationComponent.setEndpoint(this.parseUri(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, messageDestinationComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return messageDestinationComponent;
    }

    private Observation parseObservation(XmlPullParser xmlPullParser) throws Exception {
        Observation observation = new Observation();
        this.parseResourceAttributes(xmlPullParser, observation);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("name")) {
                observation.setName(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "value")) {
                observation.setValue(this.parseType("value", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("interpretation")) {
                observation.setInterpretation(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("comments")) {
                observation.setComments(this.parseString(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "applies")) {
                observation.setApplies(this.parseType("applies", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("issued")) {
                observation.setIssued(this.parseInstant(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                observation.setStatus(this.parseEnumeration(xmlPullParser, Observation.ObservationStatus.Null, new Observation.ObservationStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("reliability")) {
                observation.setReliability(this.parseEnumeration(xmlPullParser, Observation.ObservationReliability.Null, new Observation.ObservationReliabilityEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("bodySite")) {
                observation.setBodySite(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("method")) {
                observation.setMethod(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                observation.setIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                observation.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("specimen")) {
                observation.setSpecimen(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("performer")) {
                observation.getPerformer().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("referenceRange")) {
                observation.getReferenceRange().add(this.parseObservationObservationReferenceRangeComponent(xmlPullParser, observation));
            } else if (n == 2 && xmlPullParser.getName().equals("related")) {
                observation.getRelated().add(this.parseObservationObservationRelatedComponent(xmlPullParser, observation));
            } else if (!this.parseResourceContent(n, xmlPullParser, observation)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return observation;
    }

    private Observation.ObservationReferenceRangeComponent parseObservationObservationReferenceRangeComponent(XmlPullParser xmlPullParser, Observation observation) throws Exception {
        Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent = new Observation.ObservationReferenceRangeComponent();
        this.parseBackboneAttributes(xmlPullParser, observationReferenceRangeComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("low")) {
                observationReferenceRangeComponent.setLow(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("high")) {
                observationReferenceRangeComponent.setHigh(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("meaning")) {
                observationReferenceRangeComponent.setMeaning(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("age")) {
                observationReferenceRangeComponent.setAge(this.parseRange(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, observationReferenceRangeComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return observationReferenceRangeComponent;
    }

    private Observation.ObservationRelatedComponent parseObservationObservationRelatedComponent(XmlPullParser xmlPullParser, Observation observation) throws Exception {
        Observation.ObservationRelatedComponent observationRelatedComponent = new Observation.ObservationRelatedComponent();
        this.parseBackboneAttributes(xmlPullParser, observationRelatedComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("type")) {
                observationRelatedComponent.setType(this.parseEnumeration(xmlPullParser, Observation.ObservationRelationshiptypes.Null, new Observation.ObservationRelationshiptypesEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("target")) {
                observationRelatedComponent.setTarget(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, observationRelatedComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return observationRelatedComponent;
    }

    private OperationOutcome parseOperationOutcome(XmlPullParser xmlPullParser) throws Exception {
        OperationOutcome operationOutcome = new OperationOutcome();
        this.parseResourceAttributes(xmlPullParser, operationOutcome);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("issue")) {
                operationOutcome.getIssue().add(this.parseOperationOutcomeOperationOutcomeIssueComponent(xmlPullParser, operationOutcome));
            } else if (!this.parseResourceContent(n, xmlPullParser, operationOutcome)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return operationOutcome;
    }

    private OperationOutcome.OperationOutcomeIssueComponent parseOperationOutcomeOperationOutcomeIssueComponent(XmlPullParser xmlPullParser, OperationOutcome operationOutcome) throws Exception {
        OperationOutcome.OperationOutcomeIssueComponent operationOutcomeIssueComponent = new OperationOutcome.OperationOutcomeIssueComponent();
        this.parseBackboneAttributes(xmlPullParser, operationOutcomeIssueComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("severity")) {
                operationOutcomeIssueComponent.setSeverity(this.parseEnumeration(xmlPullParser, OperationOutcome.IssueSeverity.Null, new OperationOutcome.IssueSeverityEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                operationOutcomeIssueComponent.setType(this.parseCoding(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("details")) {
                operationOutcomeIssueComponent.setDetails(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("location")) {
                operationOutcomeIssueComponent.getLocation().add(this.parseString(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, operationOutcomeIssueComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return operationOutcomeIssueComponent;
    }

    private Order parseOrder(XmlPullParser xmlPullParser) throws Exception {
        Order order = new Order();
        this.parseResourceAttributes(xmlPullParser, order);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                order.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("date")) {
                order.setDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                order.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("source")) {
                order.setSource(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("target")) {
                order.setTarget(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "reason")) {
                order.setReason(this.parseType("reason", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("authority")) {
                order.setAuthority(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("when")) {
                order.setWhen(this.parseOrderOrderWhenComponent(xmlPullParser, order));
            } else if (n == 2 && xmlPullParser.getName().equals("detail")) {
                order.getDetail().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, order)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return order;
    }

    private Order.OrderWhenComponent parseOrderOrderWhenComponent(XmlPullParser xmlPullParser, Order order) throws Exception {
        Order.OrderWhenComponent orderWhenComponent = new Order.OrderWhenComponent();
        this.parseBackboneAttributes(xmlPullParser, orderWhenComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                orderWhenComponent.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("schedule")) {
                orderWhenComponent.setSchedule(this.parseSchedule(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, orderWhenComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return orderWhenComponent;
    }

    private OrderResponse parseOrderResponse(XmlPullParser xmlPullParser) throws Exception {
        OrderResponse orderResponse = new OrderResponse();
        this.parseResourceAttributes(xmlPullParser, orderResponse);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                orderResponse.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("request")) {
                orderResponse.setRequest(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("date")) {
                orderResponse.setDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("who")) {
                orderResponse.setWho(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "authority")) {
                orderResponse.setAuthority(this.parseType("authority", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                orderResponse.setCode(this.parseEnumeration(xmlPullParser, OrderResponse.OrderOutcomeCode.Null, new OrderResponse.OrderOutcomeCodeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                orderResponse.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("fulfillment")) {
                orderResponse.getFulfillment().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, orderResponse)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return orderResponse;
    }

    private Organization parseOrganization(XmlPullParser xmlPullParser) throws Exception {
        Organization organization = new Organization();
        this.parseResourceAttributes(xmlPullParser, organization);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                organization.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                organization.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                organization.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("telecom")) {
                organization.getTelecom().add(this.parseContact(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("address")) {
                organization.getAddress().add(this.parseAddress(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("partOf")) {
                organization.setPartOf(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("contact")) {
                organization.getContact().add(this.parseOrganizationOrganizationContactComponent(xmlPullParser, organization));
            } else if (n == 2 && xmlPullParser.getName().equals("location")) {
                organization.getLocation().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("active")) {
                organization.setActive(this.parseBoolean(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, organization)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return organization;
    }

    private Organization.OrganizationContactComponent parseOrganizationOrganizationContactComponent(XmlPullParser xmlPullParser, Organization organization) throws Exception {
        Organization.OrganizationContactComponent organizationContactComponent = new Organization.OrganizationContactComponent();
        this.parseBackboneAttributes(xmlPullParser, organizationContactComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("purpose")) {
                organizationContactComponent.setPurpose(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                organizationContactComponent.setName(this.parseHumanName(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("telecom")) {
                organizationContactComponent.getTelecom().add(this.parseContact(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("address")) {
                organizationContactComponent.setAddress(this.parseAddress(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("gender")) {
                organizationContactComponent.setGender(this.parseCodeableConcept(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, organizationContactComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return organizationContactComponent;
    }

    private Other parseOther(XmlPullParser xmlPullParser) throws Exception {
        Other other = new Other();
        this.parseResourceAttributes(xmlPullParser, other);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                other.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                other.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                other.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("author")) {
                other.setAuthor(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("created")) {
                other.setCreated(this.parseDate(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, other)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return other;
    }

    private Patient parsePatient(XmlPullParser xmlPullParser) throws Exception {
        Patient patient = new Patient();
        this.parseResourceAttributes(xmlPullParser, patient);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                patient.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                patient.getName().add(this.parseHumanName(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("telecom")) {
                patient.getTelecom().add(this.parseContact(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("gender")) {
                patient.setGender(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("birthDate")) {
                patient.setBirthDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "deceased")) {
                patient.setDeceased(this.parseType("deceased", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("address")) {
                patient.getAddress().add(this.parseAddress(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("maritalStatus")) {
                patient.setMaritalStatus(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "multipleBirth")) {
                patient.setMultipleBirth(this.parseType("multipleBirth", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("photo")) {
                patient.getPhoto().add(this.parseAttachment(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("contact")) {
                patient.getContact().add(this.parsePatientContactComponent(xmlPullParser, patient));
            } else if (n == 2 && xmlPullParser.getName().equals("animal")) {
                patient.setAnimal(this.parsePatientAnimalComponent(xmlPullParser, patient));
            } else if (n == 2 && xmlPullParser.getName().equals("communication")) {
                patient.getCommunication().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("careProvider")) {
                patient.getCareProvider().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("managingOrganization")) {
                patient.setManagingOrganization(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("link")) {
                patient.getLink().add(this.parsePatientPatientLinkComponent(xmlPullParser, patient));
            } else if (n == 2 && xmlPullParser.getName().equals("active")) {
                patient.setActive(this.parseBoolean(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, patient)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return patient;
    }

    private Patient.ContactComponent parsePatientContactComponent(XmlPullParser xmlPullParser, Patient patient) throws Exception {
        Patient.ContactComponent contactComponent = new Patient.ContactComponent();
        this.parseBackboneAttributes(xmlPullParser, contactComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("relationship")) {
                contactComponent.getRelationship().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                contactComponent.setName(this.parseHumanName(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("telecom")) {
                contactComponent.getTelecom().add(this.parseContact(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("address")) {
                contactComponent.setAddress(this.parseAddress(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("gender")) {
                contactComponent.setGender(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("organization")) {
                contactComponent.setOrganization(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, contactComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return contactComponent;
    }

    private Patient.AnimalComponent parsePatientAnimalComponent(XmlPullParser xmlPullParser, Patient patient) throws Exception {
        Patient.AnimalComponent animalComponent = new Patient.AnimalComponent();
        this.parseBackboneAttributes(xmlPullParser, animalComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("species")) {
                animalComponent.setSpecies(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("breed")) {
                animalComponent.setBreed(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("genderStatus")) {
                animalComponent.setGenderStatus(this.parseCodeableConcept(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, animalComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return animalComponent;
    }

    private Patient.PatientLinkComponent parsePatientPatientLinkComponent(XmlPullParser xmlPullParser, Patient patient) throws Exception {
        Patient.PatientLinkComponent patientLinkComponent = new Patient.PatientLinkComponent();
        this.parseBackboneAttributes(xmlPullParser, patientLinkComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("other")) {
                patientLinkComponent.setOther(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                patientLinkComponent.setType(this.parseEnumeration(xmlPullParser, Patient.LinkType.Null, new Patient.LinkTypeEnumFactory()));
            } else if (!this.parseBackboneContent(n, xmlPullParser, patientLinkComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return patientLinkComponent;
    }

    private Practitioner parsePractitioner(XmlPullParser xmlPullParser) throws Exception {
        Practitioner practitioner = new Practitioner();
        this.parseResourceAttributes(xmlPullParser, practitioner);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                practitioner.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                practitioner.setName(this.parseHumanName(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("telecom")) {
                practitioner.getTelecom().add(this.parseContact(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("address")) {
                practitioner.setAddress(this.parseAddress(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("gender")) {
                practitioner.setGender(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("birthDate")) {
                practitioner.setBirthDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("photo")) {
                practitioner.getPhoto().add(this.parseAttachment(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("organization")) {
                practitioner.setOrganization(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("role")) {
                practitioner.getRole().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("specialty")) {
                practitioner.getSpecialty().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("period")) {
                practitioner.setPeriod(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("location")) {
                practitioner.getLocation().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("qualification")) {
                practitioner.getQualification().add(this.parsePractitionerPractitionerQualificationComponent(xmlPullParser, practitioner));
            } else if (n == 2 && xmlPullParser.getName().equals("communication")) {
                practitioner.getCommunication().add(this.parseCodeableConcept(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, practitioner)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return practitioner;
    }

    private Practitioner.PractitionerQualificationComponent parsePractitionerPractitionerQualificationComponent(XmlPullParser xmlPullParser, Practitioner practitioner) throws Exception {
        Practitioner.PractitionerQualificationComponent practitionerQualificationComponent = new Practitioner.PractitionerQualificationComponent();
        this.parseBackboneAttributes(xmlPullParser, practitionerQualificationComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                practitionerQualificationComponent.setCode(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("period")) {
                practitionerQualificationComponent.setPeriod(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("issuer")) {
                practitionerQualificationComponent.setIssuer(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, practitionerQualificationComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return practitionerQualificationComponent;
    }

    private Procedure parseProcedure(XmlPullParser xmlPullParser) throws Exception {
        Procedure procedure = new Procedure();
        this.parseResourceAttributes(xmlPullParser, procedure);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                procedure.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                procedure.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                procedure.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("bodySite")) {
                procedure.getBodySite().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("indication")) {
                procedure.getIndication().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("performer")) {
                procedure.getPerformer().add(this.parseProcedureProcedurePerformerComponent(xmlPullParser, procedure));
            } else if (n == 2 && xmlPullParser.getName().equals("date")) {
                procedure.setDate(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("encounter")) {
                procedure.setEncounter(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("outcome")) {
                procedure.setOutcome(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("report")) {
                procedure.getReport().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("complication")) {
                procedure.getComplication().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("followUp")) {
                procedure.setFollowUp(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("relatedItem")) {
                procedure.getRelatedItem().add(this.parseProcedureProcedureRelatedItemComponent(xmlPullParser, procedure));
            } else if (n == 2 && xmlPullParser.getName().equals("notes")) {
                procedure.setNotes(this.parseString(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, procedure)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return procedure;
    }

    private Procedure.ProcedurePerformerComponent parseProcedureProcedurePerformerComponent(XmlPullParser xmlPullParser, Procedure procedure) throws Exception {
        Procedure.ProcedurePerformerComponent procedurePerformerComponent = new Procedure.ProcedurePerformerComponent();
        this.parseBackboneAttributes(xmlPullParser, procedurePerformerComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("person")) {
                procedurePerformerComponent.setPerson(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("role")) {
                procedurePerformerComponent.setRole(this.parseCodeableConcept(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, procedurePerformerComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return procedurePerformerComponent;
    }

    private Procedure.ProcedureRelatedItemComponent parseProcedureProcedureRelatedItemComponent(XmlPullParser xmlPullParser, Procedure procedure) throws Exception {
        Procedure.ProcedureRelatedItemComponent procedureRelatedItemComponent = new Procedure.ProcedureRelatedItemComponent();
        this.parseBackboneAttributes(xmlPullParser, procedureRelatedItemComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("type")) {
                procedureRelatedItemComponent.setType(this.parseEnumeration(xmlPullParser, Procedure.ProcedureRelationshipType.Null, new Procedure.ProcedureRelationshipTypeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("target")) {
                procedureRelatedItemComponent.setTarget(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, procedureRelatedItemComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return procedureRelatedItemComponent;
    }

    private Profile parseProfile(XmlPullParser xmlPullParser) throws Exception {
        Profile profile = new Profile();
        this.parseResourceAttributes(xmlPullParser, profile);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                profile.setIdentifier(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("version")) {
                profile.setVersion(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                profile.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("publisher")) {
                profile.setPublisher(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("telecom")) {
                profile.getTelecom().add(this.parseContact(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                profile.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                profile.getCode().add(this.parseCoding(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                profile.setStatus(this.parseEnumeration(xmlPullParser, Profile.ResourceProfileStatus.Null, new Profile.ResourceProfileStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("experimental")) {
                profile.setExperimental(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("date")) {
                profile.setDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("requirements")) {
                profile.setRequirements(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("fhirVersion")) {
                profile.setFhirVersion(this.parseId(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("mapping")) {
                profile.getMapping().add(this.parseProfileProfileMappingComponent(xmlPullParser, profile));
            } else if (n == 2 && xmlPullParser.getName().equals("structure")) {
                profile.getStructure().add(this.parseProfileProfileStructureComponent(xmlPullParser, profile));
            } else if (n == 2 && xmlPullParser.getName().equals("extensionDefn")) {
                profile.getExtensionDefn().add(this.parseProfileProfileExtensionDefnComponent(xmlPullParser, profile));
            } else if (n == 2 && xmlPullParser.getName().equals("query")) {
                profile.getQuery().add(this.parseProfileProfileQueryComponent(xmlPullParser, profile));
            } else if (!this.parseResourceContent(n, xmlPullParser, profile)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return profile;
    }

    private Profile.ProfileMappingComponent parseProfileProfileMappingComponent(XmlPullParser xmlPullParser, Profile profile) throws Exception {
        Profile.ProfileMappingComponent profileMappingComponent = new Profile.ProfileMappingComponent();
        this.parseBackboneAttributes(xmlPullParser, profileMappingComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identity")) {
                profileMappingComponent.setIdentity(this.parseId(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("uri")) {
                profileMappingComponent.setUri(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                profileMappingComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("comments")) {
                profileMappingComponent.setComments(this.parseString(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, profileMappingComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return profileMappingComponent;
    }

    private Profile.ProfileStructureComponent parseProfileProfileStructureComponent(XmlPullParser xmlPullParser, Profile profile) throws Exception {
        Profile.ProfileStructureComponent profileStructureComponent = new Profile.ProfileStructureComponent();
        this.parseBackboneAttributes(xmlPullParser, profileStructureComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("type")) {
                profileStructureComponent.setType(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                profileStructureComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("publish")) {
                profileStructureComponent.setPublish(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("purpose")) {
                profileStructureComponent.setPurpose(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("element")) {
                profileStructureComponent.getElement().add(this.parseProfileElementComponent(xmlPullParser, profile));
            } else if (n == 2 && xmlPullParser.getName().equals("searchParam")) {
                profileStructureComponent.getSearchParam().add(this.parseProfileProfileStructureSearchParamComponent(xmlPullParser, profile));
            } else if (!this.parseBackboneContent(n, xmlPullParser, profileStructureComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return profileStructureComponent;
    }

    private Profile.ElementComponent parseProfileElementComponent(XmlPullParser xmlPullParser, Profile profile) throws Exception {
        Profile.ElementComponent elementComponent = new Profile.ElementComponent();
        this.parseBackboneAttributes(xmlPullParser, elementComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("path")) {
                elementComponent.setPath(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("representation")) {
                elementComponent.getRepresentation().add(this.parseEnumeration(xmlPullParser, Profile.PropertyRepresentation.Null, new Profile.PropertyRepresentationEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                elementComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("slicing")) {
                elementComponent.setSlicing(this.parseProfileElementSlicingComponent(xmlPullParser, profile));
            } else if (n == 2 && xmlPullParser.getName().equals("definition")) {
                elementComponent.setDefinition(this.parseProfileElementDefinitionComponent(xmlPullParser, profile));
            } else if (!this.parseBackboneContent(n, xmlPullParser, elementComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return elementComponent;
    }

    private Profile.ElementSlicingComponent parseProfileElementSlicingComponent(XmlPullParser xmlPullParser, Profile profile) throws Exception {
        Profile.ElementSlicingComponent elementSlicingComponent = new Profile.ElementSlicingComponent();
        this.parseBackboneAttributes(xmlPullParser, elementSlicingComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("discriminator")) {
                elementSlicingComponent.setDiscriminator(this.parseId(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("ordered")) {
                elementSlicingComponent.setOrdered(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("rules")) {
                elementSlicingComponent.setRules(this.parseEnumeration(xmlPullParser, Profile.ResourceSlicingRules.Null, new Profile.ResourceSlicingRulesEnumFactory()));
            } else if (!this.parseBackboneContent(n, xmlPullParser, elementSlicingComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return elementSlicingComponent;
    }

    private Profile.ElementDefinitionComponent parseProfileElementDefinitionComponent(XmlPullParser xmlPullParser, Profile profile) throws Exception {
        Profile.ElementDefinitionComponent elementDefinitionComponent = new Profile.ElementDefinitionComponent();
        this.parseBackboneAttributes(xmlPullParser, elementDefinitionComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("short")) {
                elementDefinitionComponent.setShort(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("formal")) {
                elementDefinitionComponent.setFormal(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("comments")) {
                elementDefinitionComponent.setComments(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("requirements")) {
                elementDefinitionComponent.setRequirements(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("synonym")) {
                elementDefinitionComponent.getSynonym().add(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("min")) {
                elementDefinitionComponent.setMin(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("max")) {
                elementDefinitionComponent.setMax(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                elementDefinitionComponent.getType().add(this.parseProfileTypeRefComponent(xmlPullParser, profile));
            } else if (n == 2 && xmlPullParser.getName().equals("nameReference")) {
                elementDefinitionComponent.setNameReference(this.parseString(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "value")) {
                elementDefinitionComponent.setValue(this.parseType("value", xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "example")) {
                elementDefinitionComponent.setExample(this.parseType("example", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("maxLength")) {
                elementDefinitionComponent.setMaxLength(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("condition")) {
                elementDefinitionComponent.getCondition().add(this.parseId(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("constraint")) {
                elementDefinitionComponent.getConstraint().add(this.parseProfileElementDefinitionConstraintComponent(xmlPullParser, profile));
            } else if (n == 2 && xmlPullParser.getName().equals("mustSupport")) {
                elementDefinitionComponent.setMustSupport(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("isModifier")) {
                elementDefinitionComponent.setIsModifier(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("binding")) {
                elementDefinitionComponent.setBinding(this.parseProfileElementDefinitionBindingComponent(xmlPullParser, profile));
            } else if (n == 2 && xmlPullParser.getName().equals("mapping")) {
                elementDefinitionComponent.getMapping().add(this.parseProfileElementDefinitionMappingComponent(xmlPullParser, profile));
            } else if (!this.parseBackboneContent(n, xmlPullParser, elementDefinitionComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return elementDefinitionComponent;
    }

    private Profile.TypeRefComponent parseProfileTypeRefComponent(XmlPullParser xmlPullParser, Profile profile) throws Exception {
        Profile.TypeRefComponent typeRefComponent = new Profile.TypeRefComponent();
        this.parseBackboneAttributes(xmlPullParser, typeRefComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                typeRefComponent.setCode(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("profile")) {
                typeRefComponent.setProfile(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("aggregation")) {
                typeRefComponent.getAggregation().add(this.parseEnumeration(xmlPullParser, Profile.ResourceAggregationMode.Null, new Profile.ResourceAggregationModeEnumFactory()));
            } else if (!this.parseBackboneContent(n, xmlPullParser, typeRefComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return typeRefComponent;
    }

    private Profile.ElementDefinitionConstraintComponent parseProfileElementDefinitionConstraintComponent(XmlPullParser xmlPullParser, Profile profile) throws Exception {
        Profile.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent = new Profile.ElementDefinitionConstraintComponent();
        this.parseBackboneAttributes(xmlPullParser, elementDefinitionConstraintComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("key")) {
                elementDefinitionConstraintComponent.setKey(this.parseId(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                elementDefinitionConstraintComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("severity")) {
                elementDefinitionConstraintComponent.setSeverity(this.parseEnumeration(xmlPullParser, Profile.ConstraintSeverity.Null, new Profile.ConstraintSeverityEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("human")) {
                elementDefinitionConstraintComponent.setHuman(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("xpath")) {
                elementDefinitionConstraintComponent.setXpath(this.parseString(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, elementDefinitionConstraintComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return elementDefinitionConstraintComponent;
    }

    private Profile.ElementDefinitionBindingComponent parseProfileElementDefinitionBindingComponent(XmlPullParser xmlPullParser, Profile profile) throws Exception {
        Profile.ElementDefinitionBindingComponent elementDefinitionBindingComponent = new Profile.ElementDefinitionBindingComponent();
        this.parseBackboneAttributes(xmlPullParser, elementDefinitionBindingComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("name")) {
                elementDefinitionBindingComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("isExtensible")) {
                elementDefinitionBindingComponent.setIsExtensible(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("conformance")) {
                elementDefinitionBindingComponent.setConformance(this.parseEnumeration(xmlPullParser, Profile.BindingConformance.Null, new Profile.BindingConformanceEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                elementDefinitionBindingComponent.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "reference")) {
                elementDefinitionBindingComponent.setReference(this.parseType("reference", xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, elementDefinitionBindingComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return elementDefinitionBindingComponent;
    }

    private Profile.ElementDefinitionMappingComponent parseProfileElementDefinitionMappingComponent(XmlPullParser xmlPullParser, Profile profile) throws Exception {
        Profile.ElementDefinitionMappingComponent elementDefinitionMappingComponent = new Profile.ElementDefinitionMappingComponent();
        this.parseBackboneAttributes(xmlPullParser, elementDefinitionMappingComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identity")) {
                elementDefinitionMappingComponent.setIdentity(this.parseId(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("map")) {
                elementDefinitionMappingComponent.setMap(this.parseString(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, elementDefinitionMappingComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return elementDefinitionMappingComponent;
    }

    private Profile.ProfileStructureSearchParamComponent parseProfileProfileStructureSearchParamComponent(XmlPullParser xmlPullParser, Profile profile) throws Exception {
        Profile.ProfileStructureSearchParamComponent profileStructureSearchParamComponent = new Profile.ProfileStructureSearchParamComponent();
        this.parseBackboneAttributes(xmlPullParser, profileStructureSearchParamComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("name")) {
                profileStructureSearchParamComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                profileStructureSearchParamComponent.setType(this.parseEnumeration(xmlPullParser, Profile.SearchParamType.Null, new Profile.SearchParamTypeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("documentation")) {
                profileStructureSearchParamComponent.setDocumentation(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("xpath")) {
                profileStructureSearchParamComponent.setXpath(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("target")) {
                profileStructureSearchParamComponent.getTarget().add(this.parseCode(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, profileStructureSearchParamComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return profileStructureSearchParamComponent;
    }

    private Profile.ProfileExtensionDefnComponent parseProfileProfileExtensionDefnComponent(XmlPullParser xmlPullParser, Profile profile) throws Exception {
        Profile.ProfileExtensionDefnComponent profileExtensionDefnComponent = new Profile.ProfileExtensionDefnComponent();
        this.parseBackboneAttributes(xmlPullParser, profileExtensionDefnComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                profileExtensionDefnComponent.setCode(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("display")) {
                profileExtensionDefnComponent.setDisplay(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("contextType")) {
                profileExtensionDefnComponent.setContextType(this.parseEnumeration(xmlPullParser, Profile.ExtensionContext.Null, new Profile.ExtensionContextEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("context")) {
                profileExtensionDefnComponent.getContext().add(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("definition")) {
                profileExtensionDefnComponent.setDefinition(this.parseProfileElementDefinitionComponent(xmlPullParser, profile));
            } else if (!this.parseBackboneContent(n, xmlPullParser, profileExtensionDefnComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return profileExtensionDefnComponent;
    }

    private Profile.ProfileQueryComponent parseProfileProfileQueryComponent(XmlPullParser xmlPullParser, Profile profile) throws Exception {
        Profile.ProfileQueryComponent profileQueryComponent = new Profile.ProfileQueryComponent();
        this.parseBackboneAttributes(xmlPullParser, profileQueryComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("name")) {
                profileQueryComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("documentation")) {
                profileQueryComponent.setDocumentation(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("parameter")) {
                profileQueryComponent.getParameter().add(this.parseProfileProfileStructureSearchParamComponent(xmlPullParser, profile));
            } else if (!this.parseBackboneContent(n, xmlPullParser, profileQueryComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return profileQueryComponent;
    }

    private Provenance parseProvenance(XmlPullParser xmlPullParser) throws Exception {
        Provenance provenance = new Provenance();
        this.parseResourceAttributes(xmlPullParser, provenance);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("target")) {
                provenance.getTarget().add(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("period")) {
                provenance.setPeriod(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("recorded")) {
                provenance.setRecorded(this.parseInstant(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reason")) {
                provenance.setReason(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("location")) {
                provenance.setLocation(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("policy")) {
                provenance.getPolicy().add(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("agent")) {
                provenance.getAgent().add(this.parseProvenanceProvenanceAgentComponent(xmlPullParser, provenance));
            } else if (n == 2 && xmlPullParser.getName().equals("entity")) {
                provenance.getEntity().add(this.parseProvenanceProvenanceEntityComponent(xmlPullParser, provenance));
            } else if (n == 2 && xmlPullParser.getName().equals("integritySignature")) {
                provenance.setIntegritySignature(this.parseString(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, provenance)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return provenance;
    }

    private Provenance.ProvenanceAgentComponent parseProvenanceProvenanceAgentComponent(XmlPullParser xmlPullParser, Provenance provenance) throws Exception {
        Provenance.ProvenanceAgentComponent provenanceAgentComponent = new Provenance.ProvenanceAgentComponent();
        this.parseBackboneAttributes(xmlPullParser, provenanceAgentComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("role")) {
                provenanceAgentComponent.setRole(this.parseCoding(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                provenanceAgentComponent.setType(this.parseCoding(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reference")) {
                provenanceAgentComponent.setReference(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("display")) {
                provenanceAgentComponent.setDisplay(this.parseString(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, provenanceAgentComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return provenanceAgentComponent;
    }

    private Provenance.ProvenanceEntityComponent parseProvenanceProvenanceEntityComponent(XmlPullParser xmlPullParser, Provenance provenance) throws Exception {
        Provenance.ProvenanceEntityComponent provenanceEntityComponent = new Provenance.ProvenanceEntityComponent();
        this.parseBackboneAttributes(xmlPullParser, provenanceEntityComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("role")) {
                provenanceEntityComponent.setRole(this.parseEnumeration(xmlPullParser, Provenance.ProvenanceEntityRole.Null, new Provenance.ProvenanceEntityRoleEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                provenanceEntityComponent.setType(this.parseCoding(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reference")) {
                provenanceEntityComponent.setReference(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("display")) {
                provenanceEntityComponent.setDisplay(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("agent")) {
                provenanceEntityComponent.setAgent(this.parseProvenanceProvenanceAgentComponent(xmlPullParser, provenance));
            } else if (!this.parseBackboneContent(n, xmlPullParser, provenanceEntityComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return provenanceEntityComponent;
    }

    private Query parseQuery(XmlPullParser xmlPullParser) throws Exception {
        Query query = new Query();
        this.parseResourceAttributes(xmlPullParser, query);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                query.setIdentifier(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("parameter")) {
                query.getParameter().add(this.parseExtension(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("response")) {
                query.setResponse(this.parseQueryQueryResponseComponent(xmlPullParser, query));
            } else if (!this.parseResourceContent(n, xmlPullParser, query)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return query;
    }

    private Query.QueryResponseComponent parseQueryQueryResponseComponent(XmlPullParser xmlPullParser, Query query) throws Exception {
        Query.QueryResponseComponent queryResponseComponent = new Query.QueryResponseComponent();
        this.parseBackboneAttributes(xmlPullParser, queryResponseComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                queryResponseComponent.setIdentifier(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("outcome")) {
                queryResponseComponent.setOutcome(this.parseEnumeration(xmlPullParser, Query.QueryOutcome.Null, new Query.QueryOutcomeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("total")) {
                queryResponseComponent.setTotal(this.parseInteger(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("parameter")) {
                queryResponseComponent.getParameter().add(this.parseExtension(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("first")) {
                queryResponseComponent.getFirst().add(this.parseExtension(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("previous")) {
                queryResponseComponent.getPrevious().add(this.parseExtension(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("next")) {
                queryResponseComponent.getNext().add(this.parseExtension(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("last")) {
                queryResponseComponent.getLast().add(this.parseExtension(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reference")) {
                queryResponseComponent.getReference().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, queryResponseComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return queryResponseComponent;
    }

    private Questionnaire parseQuestionnaire(XmlPullParser xmlPullParser) throws Exception {
        Questionnaire questionnaire = new Questionnaire();
        this.parseResourceAttributes(xmlPullParser, questionnaire);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("status")) {
                questionnaire.setStatus(this.parseEnumeration(xmlPullParser, Questionnaire.QuestionnaireStatus.Null, new Questionnaire.QuestionnaireStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("authored")) {
                questionnaire.setAuthored(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                questionnaire.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("author")) {
                questionnaire.setAuthor(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("source")) {
                questionnaire.setSource(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                questionnaire.setName(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                questionnaire.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("encounter")) {
                questionnaire.setEncounter(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("group")) {
                questionnaire.setGroup(this.parseQuestionnaireGroupComponent(xmlPullParser, questionnaire));
            } else if (!this.parseResourceContent(n, xmlPullParser, questionnaire)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return questionnaire;
    }

    private Questionnaire.GroupComponent parseQuestionnaireGroupComponent(XmlPullParser xmlPullParser, Questionnaire questionnaire) throws Exception {
        Questionnaire.GroupComponent groupComponent = new Questionnaire.GroupComponent();
        this.parseBackboneAttributes(xmlPullParser, groupComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("name")) {
                groupComponent.setName(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("header")) {
                groupComponent.setHeader(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("text")) {
                groupComponent.setText(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                groupComponent.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("group")) {
                groupComponent.getGroup().add(this.parseQuestionnaireGroupComponent(xmlPullParser, questionnaire));
            } else if (n == 2 && xmlPullParser.getName().equals("question")) {
                groupComponent.getQuestion().add(this.parseQuestionnaireQuestionComponent(xmlPullParser, questionnaire));
            } else if (!this.parseBackboneContent(n, xmlPullParser, groupComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return groupComponent;
    }

    private Questionnaire.QuestionComponent parseQuestionnaireQuestionComponent(XmlPullParser xmlPullParser, Questionnaire questionnaire) throws Exception {
        Questionnaire.QuestionComponent questionComponent = new Questionnaire.QuestionComponent();
        this.parseBackboneAttributes(xmlPullParser, questionComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("name")) {
                questionComponent.setName(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("text")) {
                questionComponent.setText(this.parseString(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "answer")) {
                questionComponent.setAnswer(this.parseType("answer", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("choice")) {
                questionComponent.getChoice().add(this.parseCoding(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("options")) {
                questionComponent.setOptions(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "data")) {
                questionComponent.setData(this.parseType("data", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("remarks")) {
                questionComponent.setRemarks(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("group")) {
                questionComponent.getGroup().add(this.parseQuestionnaireGroupComponent(xmlPullParser, questionnaire));
            } else if (!this.parseBackboneContent(n, xmlPullParser, questionComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return questionComponent;
    }

    private RelatedPerson parseRelatedPerson(XmlPullParser xmlPullParser) throws Exception {
        RelatedPerson relatedPerson = new RelatedPerson();
        this.parseResourceAttributes(xmlPullParser, relatedPerson);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                relatedPerson.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("patient")) {
                relatedPerson.setPatient(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("relationship")) {
                relatedPerson.setRelationship(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                relatedPerson.setName(this.parseHumanName(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("telecom")) {
                relatedPerson.getTelecom().add(this.parseContact(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("gender")) {
                relatedPerson.setGender(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("address")) {
                relatedPerson.setAddress(this.parseAddress(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("photo")) {
                relatedPerson.getPhoto().add(this.parseAttachment(xmlPullParser));
            } else if (!this.parseResourceContent(n, xmlPullParser, relatedPerson)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return relatedPerson;
    }

    private SecurityEvent parseSecurityEvent(XmlPullParser xmlPullParser) throws Exception {
        SecurityEvent securityEvent = new SecurityEvent();
        this.parseResourceAttributes(xmlPullParser, securityEvent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("event")) {
                securityEvent.setEvent(this.parseSecurityEventSecurityEventEventComponent(xmlPullParser, securityEvent));
            } else if (n == 2 && xmlPullParser.getName().equals("participant")) {
                securityEvent.getParticipant().add(this.parseSecurityEventSecurityEventParticipantComponent(xmlPullParser, securityEvent));
            } else if (n == 2 && xmlPullParser.getName().equals("source")) {
                securityEvent.setSource(this.parseSecurityEventSecurityEventSourceComponent(xmlPullParser, securityEvent));
            } else if (n == 2 && xmlPullParser.getName().equals("object")) {
                securityEvent.getObject().add(this.parseSecurityEventSecurityEventObjectComponent(xmlPullParser, securityEvent));
            } else if (!this.parseResourceContent(n, xmlPullParser, securityEvent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return securityEvent;
    }

    private SecurityEvent.SecurityEventEventComponent parseSecurityEventSecurityEventEventComponent(XmlPullParser xmlPullParser, SecurityEvent securityEvent) throws Exception {
        SecurityEvent.SecurityEventEventComponent securityEventEventComponent = new SecurityEvent.SecurityEventEventComponent();
        this.parseBackboneAttributes(xmlPullParser, securityEventEventComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("type")) {
                securityEventEventComponent.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("subtype")) {
                securityEventEventComponent.getSubtype().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("action")) {
                securityEventEventComponent.setAction(this.parseEnumeration(xmlPullParser, SecurityEvent.SecurityEventAction.Null, new SecurityEvent.SecurityEventActionEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("dateTime")) {
                securityEventEventComponent.setDateTime(this.parseInstant(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("outcome")) {
                securityEventEventComponent.setOutcome(this.parseEnumeration(xmlPullParser, SecurityEvent.SecurityEventOutcome.Null, new SecurityEvent.SecurityEventOutcomeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("outcomeDesc")) {
                securityEventEventComponent.setOutcomeDesc(this.parseString(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, securityEventEventComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return securityEventEventComponent;
    }

    private SecurityEvent.SecurityEventParticipantComponent parseSecurityEventSecurityEventParticipantComponent(XmlPullParser xmlPullParser, SecurityEvent securityEvent) throws Exception {
        SecurityEvent.SecurityEventParticipantComponent securityEventParticipantComponent = new SecurityEvent.SecurityEventParticipantComponent();
        this.parseBackboneAttributes(xmlPullParser, securityEventParticipantComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("role")) {
                securityEventParticipantComponent.getRole().add(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reference")) {
                securityEventParticipantComponent.setReference(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("userId")) {
                securityEventParticipantComponent.setUserId(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("altId")) {
                securityEventParticipantComponent.setAltId(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                securityEventParticipantComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("requestor")) {
                securityEventParticipantComponent.setRequestor(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("media")) {
                securityEventParticipantComponent.setMedia(this.parseCoding(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("network")) {
                securityEventParticipantComponent.setNetwork(this.parseSecurityEventSecurityEventParticipantNetworkComponent(xmlPullParser, securityEvent));
            } else if (!this.parseBackboneContent(n, xmlPullParser, securityEventParticipantComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return securityEventParticipantComponent;
    }

    private SecurityEvent.SecurityEventParticipantNetworkComponent parseSecurityEventSecurityEventParticipantNetworkComponent(XmlPullParser xmlPullParser, SecurityEvent securityEvent) throws Exception {
        SecurityEvent.SecurityEventParticipantNetworkComponent securityEventParticipantNetworkComponent = new SecurityEvent.SecurityEventParticipantNetworkComponent();
        this.parseBackboneAttributes(xmlPullParser, securityEventParticipantNetworkComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                securityEventParticipantNetworkComponent.setIdentifier(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                securityEventParticipantNetworkComponent.setType(this.parseEnumeration(xmlPullParser, SecurityEvent.NetworkType.Null, new SecurityEvent.NetworkTypeEnumFactory()));
            } else if (!this.parseBackboneContent(n, xmlPullParser, securityEventParticipantNetworkComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return securityEventParticipantNetworkComponent;
    }

    private SecurityEvent.SecurityEventSourceComponent parseSecurityEventSecurityEventSourceComponent(XmlPullParser xmlPullParser, SecurityEvent securityEvent) throws Exception {
        SecurityEvent.SecurityEventSourceComponent securityEventSourceComponent = new SecurityEvent.SecurityEventSourceComponent();
        this.parseBackboneAttributes(xmlPullParser, securityEventSourceComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("site")) {
                securityEventSourceComponent.setSite(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                securityEventSourceComponent.setIdentifier(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                securityEventSourceComponent.getType().add(this.parseCoding(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, securityEventSourceComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return securityEventSourceComponent;
    }

    private SecurityEvent.SecurityEventObjectComponent parseSecurityEventSecurityEventObjectComponent(XmlPullParser xmlPullParser, SecurityEvent securityEvent) throws Exception {
        SecurityEvent.SecurityEventObjectComponent securityEventObjectComponent = new SecurityEvent.SecurityEventObjectComponent();
        this.parseBackboneAttributes(xmlPullParser, securityEventObjectComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                securityEventObjectComponent.setIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("reference")) {
                securityEventObjectComponent.setReference(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                securityEventObjectComponent.setType(this.parseEnumeration(xmlPullParser, SecurityEvent.ObjectType.Null, new SecurityEvent.ObjectTypeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("role")) {
                securityEventObjectComponent.setRole(this.parseEnumeration(xmlPullParser, SecurityEvent.ObjectRole.Null, new SecurityEvent.ObjectRoleEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("lifecycle")) {
                securityEventObjectComponent.setLifecycle(this.parseEnumeration(xmlPullParser, SecurityEvent.ObjectLifecycle.Null, new SecurityEvent.ObjectLifecycleEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("sensitivity")) {
                securityEventObjectComponent.setSensitivity(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                securityEventObjectComponent.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                securityEventObjectComponent.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("query")) {
                securityEventObjectComponent.setQuery(this.parseBase64Binary(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("detail")) {
                securityEventObjectComponent.getDetail().add(this.parseSecurityEventSecurityEventObjectDetailComponent(xmlPullParser, securityEvent));
            } else if (!this.parseBackboneContent(n, xmlPullParser, securityEventObjectComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return securityEventObjectComponent;
    }

    private SecurityEvent.SecurityEventObjectDetailComponent parseSecurityEventSecurityEventObjectDetailComponent(XmlPullParser xmlPullParser, SecurityEvent securityEvent) throws Exception {
        SecurityEvent.SecurityEventObjectDetailComponent securityEventObjectDetailComponent = new SecurityEvent.SecurityEventObjectDetailComponent();
        this.parseBackboneAttributes(xmlPullParser, securityEventObjectDetailComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("type")) {
                securityEventObjectDetailComponent.setType(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("value")) {
                securityEventObjectDetailComponent.setValue(this.parseBase64Binary(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, securityEventObjectDetailComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return securityEventObjectDetailComponent;
    }

    private Specimen parseSpecimen(XmlPullParser xmlPullParser) throws Exception {
        Specimen specimen = new Specimen();
        this.parseResourceAttributes(xmlPullParser, specimen);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                specimen.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                specimen.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("source")) {
                specimen.getSource().add(this.parseSpecimenSpecimenSourceComponent(xmlPullParser, specimen));
            } else if (n == 2 && xmlPullParser.getName().equals("subject")) {
                specimen.setSubject(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("accessionIdentifier")) {
                specimen.setAccessionIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("receivedTime")) {
                specimen.setReceivedTime(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("collection")) {
                specimen.setCollection(this.parseSpecimenSpecimenCollectionComponent(xmlPullParser, specimen));
            } else if (n == 2 && xmlPullParser.getName().equals("treatment")) {
                specimen.getTreatment().add(this.parseSpecimenSpecimenTreatmentComponent(xmlPullParser, specimen));
            } else if (n == 2 && xmlPullParser.getName().equals("container")) {
                specimen.getContainer().add(this.parseSpecimenSpecimenContainerComponent(xmlPullParser, specimen));
            } else if (!this.parseResourceContent(n, xmlPullParser, specimen)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return specimen;
    }

    private Specimen.SpecimenSourceComponent parseSpecimenSpecimenSourceComponent(XmlPullParser xmlPullParser, Specimen specimen) throws Exception {
        Specimen.SpecimenSourceComponent specimenSourceComponent = new Specimen.SpecimenSourceComponent();
        this.parseBackboneAttributes(xmlPullParser, specimenSourceComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("relationship")) {
                specimenSourceComponent.setRelationship(this.parseEnumeration(xmlPullParser, Specimen.HierarchicalRelationshipType.Null, new Specimen.HierarchicalRelationshipTypeEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("target")) {
                specimenSourceComponent.getTarget().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, specimenSourceComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return specimenSourceComponent;
    }

    private Specimen.SpecimenCollectionComponent parseSpecimenSpecimenCollectionComponent(XmlPullParser xmlPullParser, Specimen specimen) throws Exception {
        Specimen.SpecimenCollectionComponent specimenCollectionComponent = new Specimen.SpecimenCollectionComponent();
        this.parseBackboneAttributes(xmlPullParser, specimenCollectionComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("collector")) {
                specimenCollectionComponent.setCollector(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("comment")) {
                specimenCollectionComponent.getComment().add(this.parseString(xmlPullParser));
            } else if (n == 2 && this.nameIsTypeName(xmlPullParser, "collected")) {
                specimenCollectionComponent.setCollected(this.parseType("collected", xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("quantity")) {
                specimenCollectionComponent.setQuantity(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("method")) {
                specimenCollectionComponent.setMethod(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("sourceSite")) {
                specimenCollectionComponent.setSourceSite(this.parseCodeableConcept(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, specimenCollectionComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return specimenCollectionComponent;
    }

    private Specimen.SpecimenTreatmentComponent parseSpecimenSpecimenTreatmentComponent(XmlPullParser xmlPullParser, Specimen specimen) throws Exception {
        Specimen.SpecimenTreatmentComponent specimenTreatmentComponent = new Specimen.SpecimenTreatmentComponent();
        this.parseBackboneAttributes(xmlPullParser, specimenTreatmentComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("description")) {
                specimenTreatmentComponent.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("procedure")) {
                specimenTreatmentComponent.setProcedure(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("additive")) {
                specimenTreatmentComponent.getAdditive().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, specimenTreatmentComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return specimenTreatmentComponent;
    }

    private Specimen.SpecimenContainerComponent parseSpecimenSpecimenContainerComponent(XmlPullParser xmlPullParser, Specimen specimen) throws Exception {
        Specimen.SpecimenContainerComponent specimenContainerComponent = new Specimen.SpecimenContainerComponent();
        this.parseBackboneAttributes(xmlPullParser, specimenContainerComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                specimenContainerComponent.getIdentifier().add(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                specimenContainerComponent.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                specimenContainerComponent.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("capacity")) {
                specimenContainerComponent.setCapacity(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("specimenQuantity")) {
                specimenContainerComponent.setSpecimenQuantity(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("additive")) {
                specimenContainerComponent.setAdditive(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, specimenContainerComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return specimenContainerComponent;
    }

    private Substance parseSubstance(XmlPullParser xmlPullParser) throws Exception {
        Substance substance = new Substance();
        this.parseResourceAttributes(xmlPullParser, substance);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("type")) {
                substance.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                substance.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("instance")) {
                substance.setInstance(this.parseSubstanceSubstanceInstanceComponent(xmlPullParser, substance));
            } else if (n == 2 && xmlPullParser.getName().equals("ingredient")) {
                substance.getIngredient().add(this.parseSubstanceSubstanceIngredientComponent(xmlPullParser, substance));
            } else if (!this.parseResourceContent(n, xmlPullParser, substance)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return substance;
    }

    private Substance.SubstanceInstanceComponent parseSubstanceSubstanceInstanceComponent(XmlPullParser xmlPullParser, Substance substance) throws Exception {
        Substance.SubstanceInstanceComponent substanceInstanceComponent = new Substance.SubstanceInstanceComponent();
        this.parseBackboneAttributes(xmlPullParser, substanceInstanceComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                substanceInstanceComponent.setIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("expiry")) {
                substanceInstanceComponent.setExpiry(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("quantity")) {
                substanceInstanceComponent.setQuantity(this.parseQuantity(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, substanceInstanceComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return substanceInstanceComponent;
    }

    private Substance.SubstanceIngredientComponent parseSubstanceSubstanceIngredientComponent(XmlPullParser xmlPullParser, Substance substance) throws Exception {
        Substance.SubstanceIngredientComponent substanceIngredientComponent = new Substance.SubstanceIngredientComponent();
        this.parseBackboneAttributes(xmlPullParser, substanceIngredientComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("quantity")) {
                substanceIngredientComponent.setQuantity(this.parseRatio(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("substance")) {
                substanceIngredientComponent.setSubstance(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, substanceIngredientComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return substanceIngredientComponent;
    }

    private Supply parseSupply(XmlPullParser xmlPullParser) throws Exception {
        Supply supply = new Supply();
        this.parseResourceAttributes(xmlPullParser, supply);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("kind")) {
                supply.setKind(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                supply.setIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                supply.setStatus(this.parseEnumeration(xmlPullParser, Supply.ValuesetSupplyStatus.Null, new Supply.ValuesetSupplyStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("orderedItem")) {
                supply.setOrderedItem(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("patient")) {
                supply.setPatient(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("dispense")) {
                supply.getDispense().add(this.parseSupplySupplyDispenseComponent(xmlPullParser, supply));
            } else if (!this.parseResourceContent(n, xmlPullParser, supply)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return supply;
    }

    private Supply.SupplyDispenseComponent parseSupplySupplyDispenseComponent(XmlPullParser xmlPullParser, Supply supply) throws Exception {
        Supply.SupplyDispenseComponent supplyDispenseComponent = new Supply.SupplyDispenseComponent();
        this.parseBackboneAttributes(xmlPullParser, supplyDispenseComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                supplyDispenseComponent.setIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                supplyDispenseComponent.setStatus(this.parseEnumeration(xmlPullParser, Supply.ValuesetSupplyDispenseStatus.Null, new Supply.ValuesetSupplyDispenseStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("type")) {
                supplyDispenseComponent.setType(this.parseCodeableConcept(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("quantity")) {
                supplyDispenseComponent.setQuantity(this.parseQuantity(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("suppliedItem")) {
                supplyDispenseComponent.setSuppliedItem(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("supplier")) {
                supplyDispenseComponent.setSupplier(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("whenPrepared")) {
                supplyDispenseComponent.setWhenPrepared(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("whenHandedOver")) {
                supplyDispenseComponent.setWhenHandedOver(this.parsePeriod(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("destination")) {
                supplyDispenseComponent.setDestination(this.parseResourceReference(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("receiver")) {
                supplyDispenseComponent.getReceiver().add(this.parseResourceReference(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, supplyDispenseComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return supplyDispenseComponent;
    }

    private ValueSet parseValueSet(XmlPullParser xmlPullParser) throws Exception {
        ValueSet valueSet = new ValueSet();
        this.parseResourceAttributes(xmlPullParser, valueSet);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                valueSet.setIdentifier(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("version")) {
                valueSet.setVersion(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("name")) {
                valueSet.setName(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("publisher")) {
                valueSet.setPublisher(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("telecom")) {
                valueSet.getTelecom().add(this.parseContact(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("description")) {
                valueSet.setDescription(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("copyright")) {
                valueSet.setCopyright(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("status")) {
                valueSet.setStatus(this.parseEnumeration(xmlPullParser, ValueSet.ValuesetStatus.Null, new ValueSet.ValuesetStatusEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("experimental")) {
                valueSet.setExperimental(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("extensible")) {
                valueSet.setExtensible(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("date")) {
                valueSet.setDate(this.parseDateTime(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("define")) {
                valueSet.setDefine(this.parseValueSetValueSetDefineComponent(xmlPullParser, valueSet));
            } else if (n == 2 && xmlPullParser.getName().equals("compose")) {
                valueSet.setCompose(this.parseValueSetValueSetComposeComponent(xmlPullParser, valueSet));
            } else if (n == 2 && xmlPullParser.getName().equals("expansion")) {
                valueSet.setExpansion(this.parseValueSetValueSetExpansionComponent(xmlPullParser, valueSet));
            } else if (!this.parseResourceContent(n, xmlPullParser, valueSet)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return valueSet;
    }

    private ValueSet.ValueSetDefineComponent parseValueSetValueSetDefineComponent(XmlPullParser xmlPullParser, ValueSet valueSet) throws Exception {
        ValueSet.ValueSetDefineComponent valueSetDefineComponent = new ValueSet.ValueSetDefineComponent();
        this.parseBackboneAttributes(xmlPullParser, valueSetDefineComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("system")) {
                valueSetDefineComponent.setSystem(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("version")) {
                valueSetDefineComponent.setVersion(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("caseSensitive")) {
                valueSetDefineComponent.setCaseSensitive(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("concept")) {
                valueSetDefineComponent.getConcept().add(this.parseValueSetValueSetDefineConceptComponent(xmlPullParser, valueSet));
            } else if (!this.parseBackboneContent(n, xmlPullParser, valueSetDefineComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return valueSetDefineComponent;
    }

    private ValueSet.ValueSetDefineConceptComponent parseValueSetValueSetDefineConceptComponent(XmlPullParser xmlPullParser, ValueSet valueSet) throws Exception {
        ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent = new ValueSet.ValueSetDefineConceptComponent();
        this.parseBackboneAttributes(xmlPullParser, valueSetDefineConceptComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("code")) {
                valueSetDefineConceptComponent.setCode(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("abstract")) {
                valueSetDefineConceptComponent.setAbstract(this.parseBoolean(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("display")) {
                valueSetDefineConceptComponent.setDisplay(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("definition")) {
                valueSetDefineConceptComponent.setDefinition(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("concept")) {
                valueSetDefineConceptComponent.getConcept().add(this.parseValueSetValueSetDefineConceptComponent(xmlPullParser, valueSet));
            } else if (!this.parseBackboneContent(n, xmlPullParser, valueSetDefineConceptComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return valueSetDefineConceptComponent;
    }

    private ValueSet.ValueSetComposeComponent parseValueSetValueSetComposeComponent(XmlPullParser xmlPullParser, ValueSet valueSet) throws Exception {
        ValueSet.ValueSetComposeComponent valueSetComposeComponent = new ValueSet.ValueSetComposeComponent();
        this.parseBackboneAttributes(xmlPullParser, valueSetComposeComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("import")) {
                valueSetComposeComponent.getImport().add(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("include")) {
                valueSetComposeComponent.getInclude().add(this.parseValueSetConceptSetComponent(xmlPullParser, valueSet));
            } else if (n == 2 && xmlPullParser.getName().equals("exclude")) {
                valueSetComposeComponent.getExclude().add(this.parseValueSetConceptSetComponent(xmlPullParser, valueSet));
            } else if (!this.parseBackboneContent(n, xmlPullParser, valueSetComposeComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return valueSetComposeComponent;
    }

    private ValueSet.ConceptSetComponent parseValueSetConceptSetComponent(XmlPullParser xmlPullParser, ValueSet valueSet) throws Exception {
        ValueSet.ConceptSetComponent conceptSetComponent = new ValueSet.ConceptSetComponent();
        this.parseBackboneAttributes(xmlPullParser, conceptSetComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("system")) {
                conceptSetComponent.setSystem(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("version")) {
                conceptSetComponent.setVersion(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                conceptSetComponent.getCode().add(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("filter")) {
                conceptSetComponent.getFilter().add(this.parseValueSetConceptSetFilterComponent(xmlPullParser, valueSet));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conceptSetComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conceptSetComponent;
    }

    private ValueSet.ConceptSetFilterComponent parseValueSetConceptSetFilterComponent(XmlPullParser xmlPullParser, ValueSet valueSet) throws Exception {
        ValueSet.ConceptSetFilterComponent conceptSetFilterComponent = new ValueSet.ConceptSetFilterComponent();
        this.parseBackboneAttributes(xmlPullParser, conceptSetFilterComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("property")) {
                conceptSetFilterComponent.setProperty(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("op")) {
                conceptSetFilterComponent.setOp(this.parseEnumeration(xmlPullParser, ValueSet.FilterOperator.Null, new ValueSet.FilterOperatorEnumFactory()));
            } else if (n == 2 && xmlPullParser.getName().equals("value")) {
                conceptSetFilterComponent.setValue(this.parseCode(xmlPullParser));
            } else if (!this.parseBackboneContent(n, xmlPullParser, conceptSetFilterComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return conceptSetFilterComponent;
    }

    private ValueSet.ValueSetExpansionComponent parseValueSetValueSetExpansionComponent(XmlPullParser xmlPullParser, ValueSet valueSet) throws Exception {
        ValueSet.ValueSetExpansionComponent valueSetExpansionComponent = new ValueSet.ValueSetExpansionComponent();
        this.parseBackboneAttributes(xmlPullParser, valueSetExpansionComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("identifier")) {
                valueSetExpansionComponent.setIdentifier(this.parseIdentifier(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("timestamp")) {
                valueSetExpansionComponent.setTimestamp(this.parseInstant(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("contains")) {
                valueSetExpansionComponent.getContains().add(this.parseValueSetValueSetExpansionContainsComponent(xmlPullParser, valueSet));
            } else if (!this.parseBackboneContent(n, xmlPullParser, valueSetExpansionComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return valueSetExpansionComponent;
    }

    private ValueSet.ValueSetExpansionContainsComponent parseValueSetValueSetExpansionContainsComponent(XmlPullParser xmlPullParser, ValueSet valueSet) throws Exception {
        ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent = new ValueSet.ValueSetExpansionContainsComponent();
        this.parseBackboneAttributes(xmlPullParser, valueSetExpansionContainsComponent);
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("system")) {
                valueSetExpansionContainsComponent.setSystem(this.parseUri(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("code")) {
                valueSetExpansionContainsComponent.setCode(this.parseCode(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("display")) {
                valueSetExpansionContainsComponent.setDisplay(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("contains")) {
                valueSetExpansionContainsComponent.getContains().add(this.parseValueSetValueSetExpansionContainsComponent(xmlPullParser, valueSet));
            } else if (!this.parseBackboneContent(n, xmlPullParser, valueSetExpansionContainsComponent)) {
                this.unknownContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        this.next(xmlPullParser);
        return valueSetExpansionContainsComponent;
    }

    @Override
    protected Resource parseResource(XmlPullParser xmlPullParser) throws Exception {
        if (xmlPullParser.getName().equals("AdverseReaction")) {
            return this.parseAdverseReaction(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Alert")) {
            return this.parseAlert(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("AllergyIntolerance")) {
            return this.parseAllergyIntolerance(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("CarePlan")) {
            return this.parseCarePlan(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Composition")) {
            return this.parseComposition(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("ConceptMap")) {
            return this.parseConceptMap(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Condition")) {
            return this.parseCondition(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Conformance")) {
            return this.parseConformance(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Device")) {
            return this.parseDevice(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("DeviceObservationReport")) {
            return this.parseDeviceObservationReport(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("DiagnosticOrder")) {
            return this.parseDiagnosticOrder(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("DiagnosticReport")) {
            return this.parseDiagnosticReport(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("DocumentManifest")) {
            return this.parseDocumentManifest(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("DocumentReference")) {
            return this.parseDocumentReference(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Encounter")) {
            return this.parseEncounter(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("FamilyHistory")) {
            return this.parseFamilyHistory(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Group")) {
            return this.parseGroup(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("ImagingStudy")) {
            return this.parseImagingStudy(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Immunization")) {
            return this.parseImmunization(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("ImmunizationRecommendation")) {
            return this.parseImmunizationRecommendation(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("List")) {
            return this.parseList_(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Location")) {
            return this.parseLocation(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Media")) {
            return this.parseMedia(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Medication")) {
            return this.parseMedication(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("MedicationAdministration")) {
            return this.parseMedicationAdministration(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("MedicationDispense")) {
            return this.parseMedicationDispense(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("MedicationPrescription")) {
            return this.parseMedicationPrescription(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("MedicationStatement")) {
            return this.parseMedicationStatement(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("MessageHeader")) {
            return this.parseMessageHeader(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Observation")) {
            return this.parseObservation(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("OperationOutcome")) {
            return this.parseOperationOutcome(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Order")) {
            return this.parseOrder(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("OrderResponse")) {
            return this.parseOrderResponse(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Organization")) {
            return this.parseOrganization(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Other")) {
            return this.parseOther(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Patient")) {
            return this.parsePatient(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Practitioner")) {
            return this.parsePractitioner(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Procedure")) {
            return this.parseProcedure(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Profile")) {
            return this.parseProfile(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Provenance")) {
            return this.parseProvenance(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Query")) {
            return this.parseQuery(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Questionnaire")) {
            return this.parseQuestionnaire(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("RelatedPerson")) {
            return this.parseRelatedPerson(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("SecurityEvent")) {
            return this.parseSecurityEvent(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Specimen")) {
            return this.parseSpecimen(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Substance")) {
            return this.parseSubstance(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Supply")) {
            return this.parseSupply(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("ValueSet")) {
            return this.parseValueSet(xmlPullParser);
        }
        if (xmlPullParser.getName().equals("Binary")) {
            return this.parseBinary(xmlPullParser);
        }
        throw new Exception("Unknown resource type " + xmlPullParser.getName() + "");
    }

    protected Type parseType(String string, XmlPullParser xmlPullParser) throws Exception {
        if (xmlPullParser.getName().equals(string + "Period")) {
            return this.parsePeriod(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Coding")) {
            return this.parseCoding(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Range")) {
            return this.parseRange(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Quantity")) {
            return this.parseQuantity(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Attachment")) {
            return this.parseAttachment(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Ratio")) {
            return this.parseRatio(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "SampledData")) {
            return this.parseSampledData(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Resource")) {
            return this.parseResourceReference(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "CodeableConcept")) {
            return this.parseCodeableConcept(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Identifier")) {
            return this.parseIdentifier(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Age")) {
            return this.parseAge(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Count")) {
            return this.parseCount(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Money")) {
            return this.parseMoney(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Distance")) {
            return this.parseDistance(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Duration")) {
            return this.parseDuration(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Schedule")) {
            return this.parseSchedule(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Contact")) {
            return this.parseContact(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Address")) {
            return this.parseAddress(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "HumanName")) {
            return this.parseHumanName(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Id")) {
            return this.parseId(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Base64Binary")) {
            return this.parseBase64Binary(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "DateTime")) {
            return this.parseDateTime(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Integer")) {
            return this.parseInteger(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Oid")) {
            return this.parseOid(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "String")) {
            return this.parseString(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Boolean")) {
            return this.parseBoolean(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Uuid")) {
            return this.parseUuid(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Code")) {
            return this.parseCode(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Date")) {
            return this.parseDate(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Uri")) {
            return this.parseUri(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Instant")) {
            return this.parseInstant(xmlPullParser);
        }
        if (xmlPullParser.getName().equals(string + "Decimal")) {
            return this.parseDecimal(xmlPullParser);
        }
        throw new Exception("Unknown type " + xmlPullParser.getName());
    }

    public Element parseFragment(XmlPullParser xmlPullParser, String string) throws Exception {
        if (string.equals("Extension")) {
            return this.parseExtension(xmlPullParser);
        }
        if (string.equals("Narrative")) {
            return this.parseNarrative(xmlPullParser);
        }
        if (string.equals("Period")) {
            return this.parsePeriod(xmlPullParser);
        }
        if (string.equals("Coding")) {
            return this.parseCoding(xmlPullParser);
        }
        if (string.equals("Range")) {
            return this.parseRange(xmlPullParser);
        }
        if (string.equals("Quantity")) {
            return this.parseQuantity(xmlPullParser);
        }
        if (string.equals("Attachment")) {
            return this.parseAttachment(xmlPullParser);
        }
        if (string.equals("Ratio")) {
            return this.parseRatio(xmlPullParser);
        }
        if (string.equals("SampledData")) {
            return this.parseSampledData(xmlPullParser);
        }
        if (string.equals("ResourceReference")) {
            return this.parseResourceReference(xmlPullParser);
        }
        if (string.equals("CodeableConcept")) {
            return this.parseCodeableConcept(xmlPullParser);
        }
        if (string.equals("Identifier")) {
            return this.parseIdentifier(xmlPullParser);
        }
        if (string.equals("Age")) {
            return this.parseAge(xmlPullParser);
        }
        if (string.equals("Count")) {
            return this.parseCount(xmlPullParser);
        }
        if (string.equals("Money")) {
            return this.parseMoney(xmlPullParser);
        }
        if (string.equals("Distance")) {
            return this.parseDistance(xmlPullParser);
        }
        if (string.equals("Duration")) {
            return this.parseDuration(xmlPullParser);
        }
        if (string.equals("Schedule")) {
            return this.parseSchedule(xmlPullParser);
        }
        if (string.equals("Contact")) {
            return this.parseContact(xmlPullParser);
        }
        if (string.equals("Address")) {
            return this.parseAddress(xmlPullParser);
        }
        if (string.equals("HumanName")) {
            return this.parseHumanName(xmlPullParser);
        }
        if (string.equals("AdverseReaction")) {
            return this.parseAdverseReaction(xmlPullParser);
        }
        if (string.equals("Alert")) {
            return this.parseAlert(xmlPullParser);
        }
        if (string.equals("AllergyIntolerance")) {
            return this.parseAllergyIntolerance(xmlPullParser);
        }
        if (string.equals("CarePlan")) {
            return this.parseCarePlan(xmlPullParser);
        }
        if (string.equals("Composition")) {
            return this.parseComposition(xmlPullParser);
        }
        if (string.equals("ConceptMap")) {
            return this.parseConceptMap(xmlPullParser);
        }
        if (string.equals("Condition")) {
            return this.parseCondition(xmlPullParser);
        }
        if (string.equals("Conformance")) {
            return this.parseConformance(xmlPullParser);
        }
        if (string.equals("Device")) {
            return this.parseDevice(xmlPullParser);
        }
        if (string.equals("DeviceObservationReport")) {
            return this.parseDeviceObservationReport(xmlPullParser);
        }
        if (string.equals("DiagnosticOrder")) {
            return this.parseDiagnosticOrder(xmlPullParser);
        }
        if (string.equals("DiagnosticReport")) {
            return this.parseDiagnosticReport(xmlPullParser);
        }
        if (string.equals("DocumentManifest")) {
            return this.parseDocumentManifest(xmlPullParser);
        }
        if (string.equals("DocumentReference")) {
            return this.parseDocumentReference(xmlPullParser);
        }
        if (string.equals("Encounter")) {
            return this.parseEncounter(xmlPullParser);
        }
        if (string.equals("FamilyHistory")) {
            return this.parseFamilyHistory(xmlPullParser);
        }
        if (string.equals("Group")) {
            return this.parseGroup(xmlPullParser);
        }
        if (string.equals("ImagingStudy")) {
            return this.parseImagingStudy(xmlPullParser);
        }
        if (string.equals("Immunization")) {
            return this.parseImmunization(xmlPullParser);
        }
        if (string.equals("ImmunizationRecommendation")) {
            return this.parseImmunizationRecommendation(xmlPullParser);
        }
        if (string.equals("List")) {
            return this.parseList_(xmlPullParser);
        }
        if (string.equals("Location")) {
            return this.parseLocation(xmlPullParser);
        }
        if (string.equals("Media")) {
            return this.parseMedia(xmlPullParser);
        }
        if (string.equals("Medication")) {
            return this.parseMedication(xmlPullParser);
        }
        if (string.equals("MedicationAdministration")) {
            return this.parseMedicationAdministration(xmlPullParser);
        }
        if (string.equals("MedicationDispense")) {
            return this.parseMedicationDispense(xmlPullParser);
        }
        if (string.equals("MedicationPrescription")) {
            return this.parseMedicationPrescription(xmlPullParser);
        }
        if (string.equals("MedicationStatement")) {
            return this.parseMedicationStatement(xmlPullParser);
        }
        if (string.equals("MessageHeader")) {
            return this.parseMessageHeader(xmlPullParser);
        }
        if (string.equals("Observation")) {
            return this.parseObservation(xmlPullParser);
        }
        if (string.equals("OperationOutcome")) {
            return this.parseOperationOutcome(xmlPullParser);
        }
        if (string.equals("Order")) {
            return this.parseOrder(xmlPullParser);
        }
        if (string.equals("OrderResponse")) {
            return this.parseOrderResponse(xmlPullParser);
        }
        if (string.equals("Organization")) {
            return this.parseOrganization(xmlPullParser);
        }
        if (string.equals("Other")) {
            return this.parseOther(xmlPullParser);
        }
        if (string.equals("Patient")) {
            return this.parsePatient(xmlPullParser);
        }
        if (string.equals("Practitioner")) {
            return this.parsePractitioner(xmlPullParser);
        }
        if (string.equals("Procedure")) {
            return this.parseProcedure(xmlPullParser);
        }
        if (string.equals("Profile")) {
            return this.parseProfile(xmlPullParser);
        }
        if (string.equals("Provenance")) {
            return this.parseProvenance(xmlPullParser);
        }
        if (string.equals("Query")) {
            return this.parseQuery(xmlPullParser);
        }
        if (string.equals("Questionnaire")) {
            return this.parseQuestionnaire(xmlPullParser);
        }
        if (string.equals("RelatedPerson")) {
            return this.parseRelatedPerson(xmlPullParser);
        }
        if (string.equals("SecurityEvent")) {
            return this.parseSecurityEvent(xmlPullParser);
        }
        if (string.equals("Specimen")) {
            return this.parseSpecimen(xmlPullParser);
        }
        if (string.equals("Substance")) {
            return this.parseSubstance(xmlPullParser);
        }
        if (string.equals("Supply")) {
            return this.parseSupply(xmlPullParser);
        }
        if (string.equals("ValueSet")) {
            return this.parseValueSet(xmlPullParser);
        }
        if (string.equals("id")) {
            return this.parseId(xmlPullParser);
        }
        if (string.equals("base64Binary")) {
            return this.parseBase64Binary(xmlPullParser);
        }
        if (string.equals("dateTime")) {
            return this.parseDateTime(xmlPullParser);
        }
        if (string.equals("integer")) {
            return this.parseInteger(xmlPullParser);
        }
        if (string.equals("oid")) {
            return this.parseOid(xmlPullParser);
        }
        if (string.equals("string")) {
            return this.parseString(xmlPullParser);
        }
        if (string.equals("boolean")) {
            return this.parseBoolean(xmlPullParser);
        }
        if (string.equals("uuid")) {
            return this.parseUuid(xmlPullParser);
        }
        if (string.equals("code")) {
            return this.parseCode(xmlPullParser);
        }
        if (string.equals("date")) {
            return this.parseDate(xmlPullParser);
        }
        if (string.equals("uri")) {
            return this.parseUri(xmlPullParser);
        }
        if (string.equals("instant")) {
            return this.parseInstant(xmlPullParser);
        }
        if (string.equals("decimal")) {
            return this.parseDecimal(xmlPullParser);
        }
        throw new Exception("Unknown type " + string);
    }

    private boolean nameIsTypeName(XmlPullParser xmlPullParser, String string) {
        if (xmlPullParser.getName().equals(string + "Period")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Coding")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Range")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Quantity")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Attachment")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Ratio")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "SampledData")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Resource")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "CodeableConcept")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Identifier")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Age")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Count")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Money")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Distance")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Duration")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Schedule")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Contact")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Address")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "HumanName")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "AdverseReaction")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Alert")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "AllergyIntolerance")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "CarePlan")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Composition")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "ConceptMap")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Condition")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Conformance")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Device")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "DeviceObservationReport")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "DiagnosticOrder")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "DiagnosticReport")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "DocumentManifest")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "DocumentReference")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Encounter")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "FamilyHistory")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Group")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "ImagingStudy")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Immunization")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "ImmunizationRecommendation")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "List")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Location")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Media")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Medication")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "MedicationAdministration")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "MedicationDispense")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "MedicationPrescription")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "MedicationStatement")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "MessageHeader")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Observation")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "OperationOutcome")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Order")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "OrderResponse")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Organization")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Other")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Patient")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Practitioner")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Procedure")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Profile")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Provenance")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Query")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Questionnaire")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "RelatedPerson")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "SecurityEvent")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Specimen")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Substance")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Supply")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "ValueSet")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Id")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Base64Binary")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "DateTime")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Integer")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Oid")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "String")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Boolean")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Uuid")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Code")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Date")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Uri")) {
            return true;
        }
        if (xmlPullParser.getName().equals(string + "Instant")) {
            return true;
        }
        return xmlPullParser.getName().equals(string + "Decimal");
    }
}

