/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.formats;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.hl7.fhir.instance.formats.Parser;
import org.hl7.fhir.instance.formats.ParserBase;
import org.hl7.fhir.instance.formats.ResourceOrFeed;
import org.hl7.fhir.instance.formats.XmlParser;
import org.hl7.fhir.instance.model.AtomCategory;
import org.hl7.fhir.instance.model.AtomEntry;
import org.hl7.fhir.instance.model.AtomFeed;
import org.hl7.fhir.instance.model.Binary;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public abstract class XmlParserBase
extends ParserBase
implements Parser {
    private boolean parseComments = true;
    private List<String> comments = new ArrayList<String>();
    private boolean allowUnknownContent;

    public boolean isParseComments() {
        return this.parseComments;
    }

    public void setParseComments(boolean bl) {
        this.parseComments = bl;
    }

    protected XmlPullParser loadXml(InputStream inputStream) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        xmlPullParserFactory.setNamespaceAware(true);
        XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
        xmlPullParser.setInput((InputStream)bufferedInputStream, "UTF-8");
        this.next(xmlPullParser);
        this.nextNoWhitespace(xmlPullParser);
        this.comments.clear();
        return xmlPullParser;
    }

    protected int next(XmlPullParser xmlPullParser) throws Exception {
        if (this.parseComments) {
            return xmlPullParser.nextToken();
        }
        return xmlPullParser.next();
    }

    protected int nextNoWhitespace(XmlPullParser xmlPullParser) throws Exception {
        int n = xmlPullParser.getEventType();
        while (n == 4 && xmlPullParser.isWhitespace() || n == 9 || n == 5 || n == 7 || n == 8 || n == 10) {
            if (n == 9) {
                this.comments.add(xmlPullParser.getText());
            }
            n = this.next(xmlPullParser);
        }
        return n;
    }

    protected void skipElementWithContent(XmlPullParser xmlPullParser) throws Exception {
        while (xmlPullParser.getEventType() != 3) {
            this.next(xmlPullParser);
            if (xmlPullParser.getEventType() != 2) continue;
            this.skipElementWithContent(xmlPullParser);
        }
        this.next(xmlPullParser);
    }

    protected void skipEmptyElement(XmlPullParser xmlPullParser) throws Exception {
        while (xmlPullParser.getEventType() != 3) {
            this.next(xmlPullParser);
        }
        this.next(xmlPullParser);
    }

    public boolean isAllowUnknownContent() {
        return this.allowUnknownContent;
    }

    public void setAllowUnknownContent(boolean bl) {
        this.allowUnknownContent = bl;
    }

    protected abstract Resource parseResource(XmlPullParser var1) throws Exception;

    protected void parseTypeAttributes(XmlPullParser xmlPullParser, Type type) throws Exception {
        this.parseElementAttributes(xmlPullParser, type);
    }

    protected void parseElementAttributes(XmlPullParser xmlPullParser, Element element) throws Exception {
        if (xmlPullParser.getAttributeValue(null, "id") != null) {
            element.setXmlId(xmlPullParser.getAttributeValue(null, "id"));
            this.idMap.put(element.getXmlId(), element);
        }
        if (!this.comments.isEmpty()) {
            element.getXmlComments().addAll(this.comments);
            this.comments.clear();
        }
    }

    protected void parseBackboneAttributes(XmlPullParser xmlPullParser, Element element) throws Exception {
        this.parseElementAttributes(xmlPullParser, element);
    }

    protected void parseResourceAttributes(XmlPullParser xmlPullParser, Resource resource) throws Exception {
        this.parseElementAttributes(xmlPullParser, resource);
    }

    private String pathForLocation(XmlPullParser xmlPullParser) {
        return xmlPullParser.getPositionDescription();
    }

    @Override
    public ResourceOrFeed parseGeneral(InputStream inputStream) throws Exception {
        XmlPullParser xmlPullParser = this.loadXml(inputStream);
        ResourceOrFeed resourceOrFeed = new ResourceOrFeed();
        if (xmlPullParser.getNamespace().equals("http://hl7.org/fhir") && !xmlPullParser.getName().equalsIgnoreCase("TagList")) {
            resourceOrFeed.setResource(this.parseResource(xmlPullParser));
        } else if (xmlPullParser.getNamespace().equals("http://hl7.org/fhir") && xmlPullParser.getName().equalsIgnoreCase("Taglist")) {
            resourceOrFeed.setTaglist(this.parseTagList(xmlPullParser));
        } else if (xmlPullParser.getNamespace().equals("http://www.w3.org/2005/Atom")) {
            resourceOrFeed.setFeed(this.parseFeed(xmlPullParser));
        } else {
            throw new Exception("This does not appear to be a FHIR resource (wrong namespace '" + xmlPullParser.getNamespace() + "') (@ /)");
        }
        return resourceOrFeed;
    }

    @Override
    public Resource parse(InputStream inputStream) throws Exception {
        XmlPullParser xmlPullParser = this.loadXml(inputStream);
        if (xmlPullParser.getNamespace() == null) {
            throw new Exception("This does not appear to be a FHIR resource (no namespace '" + xmlPullParser.getNamespace() + "') (@ /) " + Integer.toString(xmlPullParser.getEventType()));
        }
        if (!xmlPullParser.getNamespace().equals("http://hl7.org/fhir")) {
            throw new Exception("This does not appear to be a FHIR resource (wrong namespace '" + xmlPullParser.getNamespace() + "') (@ /)");
        }
        return this.parseResource(xmlPullParser);
    }

    public Resource parse(XmlPullParser xmlPullParser) throws Exception {
        if (!xmlPullParser.getNamespace().equals("http://hl7.org/fhir")) {
            throw new Exception("This does not appear to be a FHIR resource (wrong namespace '" + xmlPullParser.getNamespace() + "') (@ /)");
        }
        return this.parseResource(xmlPullParser);
    }

    protected void unknownContent(XmlPullParser xmlPullParser) throws Exception {
        if (!this.isAllowUnknownContent()) {
            throw new Exception("Unknown Content " + xmlPullParser.getName() + " @ " + this.pathForLocation(xmlPullParser));
        }
    }

    protected XhtmlNode parseXhtml(XmlPullParser xmlPullParser) throws Exception {
        XhtmlParser xhtmlParser = new XhtmlParser();
        return xhtmlParser.parseHtmlNode(xmlPullParser);
    }

    protected Resource parseBinary(XmlPullParser xmlPullParser) throws Exception {
        Binary binary = new Binary();
        this.parseElementAttributes(xmlPullParser, binary);
        binary.setContentType(xmlPullParser.getAttributeValue(null, "contentType"));
        int n = this.next(xmlPullParser);
        if (n == 4) {
            binary.setContent(Base64.decodeBase64((byte[])xmlPullParser.getText().getBytes()));
            n = this.next(xmlPullParser);
        }
        if (n != 3) {
            throw new Exception("Bad String Structure");
        }
        this.next(xmlPullParser);
        return binary;
    }

    private AtomFeed parseFeed(XmlPullParser xmlPullParser) throws Exception {
        if (!(xmlPullParser.getNamespace().equals("http://www.w3.org/2005/Atom") || xmlPullParser.getNamespace().equals("http://hl7.org/fhir") && xmlPullParser.getName().equalsIgnoreCase("TagList"))) {
            throw new Exception("This does not appear to be an atom feed (wrong namespace '" + xmlPullParser.getNamespace() + "') (@ /)");
        }
        return this.parseAtom(xmlPullParser);
    }

    private List<AtomCategory> parseTagList(XmlPullParser xmlPullParser) throws Exception {
        ArrayList<AtomCategory> arrayList = new ArrayList<AtomCategory>();
        if (!xmlPullParser.getName().equalsIgnoreCase("Taglist")) {
            throw new Exception("This does not appear to be a tag list (wrong name '" + xmlPullParser.getName() + "') (@ /)");
        }
        this.next(xmlPullParser);
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("category")) {
                arrayList.add(new AtomCategory(xmlPullParser.getAttributeValue(null, "scheme"), xmlPullParser.getAttributeValue(null, "term"), xmlPullParser.getAttributeValue(null, "label")));
                this.skipEmptyElement(xmlPullParser);
            } else {
                this.skipElementWithContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        return arrayList;
    }

    private AtomFeed parseAtom(XmlPullParser xmlPullParser) throws Exception {
        AtomFeed atomFeed = new AtomFeed();
        if (!xmlPullParser.getName().equals("feed") && !xmlPullParser.getName().equalsIgnoreCase("TagList")) {
            throw new Exception("This does not appear to be an atom feed (wrong name '" + xmlPullParser.getName() + "') (@ /)");
        }
        xmlPullParser.next();
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("title")) {
                atomFeed.setTitle(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("id")) {
                atomFeed.setId(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("link")) {
                atomFeed.getLinks().put(xmlPullParser.getAttributeValue(null, "rel"), xmlPullParser.getAttributeValue(null, "href"));
                this.skipEmptyElement(xmlPullParser);
            } else if (n == 2 && xmlPullParser.getName().equals("updated")) {
                atomFeed.setUpdated(this.parseDate(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("category")) {
                atomFeed.getTags().add(new AtomCategory(xmlPullParser.getAttributeValue(null, "scheme"), xmlPullParser.getAttributeValue(null, "term"), xmlPullParser.getAttributeValue(null, "label")));
                this.skipEmptyElement(xmlPullParser);
            } else if (n == 2 && xmlPullParser.getName().equals("entry")) {
                atomFeed.getEntryList().add(this.parseEntry(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("author")) {
                xmlPullParser.next();
                n = this.nextNoWhitespace(xmlPullParser);
                while (n != 3) {
                    if (n == 2 && xmlPullParser.getName().equals("name")) {
                        atomFeed.setAuthorName(this.parseString(xmlPullParser));
                    } else if (n == 2 && xmlPullParser.getName().equals("uri")) {
                        atomFeed.setAuthorUri(this.parseString(xmlPullParser));
                    } else {
                        throw new Exception("Bad Xml parsing entry.author");
                    }
                    n = this.nextNoWhitespace(xmlPullParser);
                }
                xmlPullParser.next();
            } else if (n == 2 && xmlPullParser.getName().equals("totalResults")) {
                atomFeed.setTotalResults(this.parseInt(xmlPullParser));
            } else {
                this.skipElementWithContent(xmlPullParser);
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        return atomFeed;
    }

    private <T extends Resource> AtomEntry<T> parseEntry(XmlPullParser xmlPullParser) throws Exception {
        AtomEntry<Resource> atomEntry = new AtomEntry<Resource>();
        xmlPullParser.next();
        int n = this.nextNoWhitespace(xmlPullParser);
        while (n != 3) {
            if (n == 2 && xmlPullParser.getName().equals("title")) {
                atomEntry.setTitle(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("id")) {
                atomEntry.setId(this.parseString(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("link")) {
                atomEntry.getLinks().put(xmlPullParser.getAttributeValue(null, "rel"), xmlPullParser.getAttributeValue(null, "href"));
                this.skipEmptyElement(xmlPullParser);
            } else if (n == 2 && xmlPullParser.getName().equals("updated")) {
                atomEntry.setUpdated(this.parseDate(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("published")) {
                atomEntry.setPublished(this.parseDate(xmlPullParser));
            } else if (n == 2 && xmlPullParser.getName().equals("category")) {
                atomEntry.getTags().add(new AtomCategory(xmlPullParser.getAttributeValue(null, "scheme"), xmlPullParser.getAttributeValue(null, "term"), xmlPullParser.getAttributeValue(null, "label")));
                this.skipEmptyElement(xmlPullParser);
            } else if (n == 2 && xmlPullParser.getName().equals("author")) {
                xmlPullParser.next();
                n = this.nextNoWhitespace(xmlPullParser);
                while (n != 3) {
                    if (n == 2 && xmlPullParser.getName().equals("name")) {
                        atomEntry.setAuthorName(this.parseString(xmlPullParser));
                    } else if (n == 2 && xmlPullParser.getName().equals("uri")) {
                        atomEntry.setAuthorUri(this.parseString(xmlPullParser));
                    } else {
                        throw new Exception("Bad Xml parsing entry.author");
                    }
                    n = this.nextNoWhitespace(xmlPullParser);
                }
                xmlPullParser.next();
            } else if (n == 2 && xmlPullParser.getName().equals("content")) {
                xmlPullParser.next();
                this.nextNoWhitespace(xmlPullParser);
                XmlParser xmlParser = new XmlParser();
                xmlParser.setAllowUnknownContent(this.isAllowUnknownContent());
                atomEntry.setResource(xmlParser.parse(xmlPullParser));
                xmlPullParser.next();
                this.nextNoWhitespace(xmlPullParser);
                if (xmlPullParser.getName().equals("content")) {
                    xmlPullParser.next();
                }
            } else if (n == 2 && xmlPullParser.getName().equals("summary")) {
                xmlPullParser.next();
                this.nextNoWhitespace(xmlPullParser);
                atomEntry.setSummary(new XhtmlParser().parseHtmlNode(xmlPullParser));
                xmlPullParser.next();
                this.nextNoWhitespace(xmlPullParser);
                if (xmlPullParser.getName().equals("summary")) {
                    xmlPullParser.next();
                }
            } else {
                throw new Exception("Bad Xml parsing entry");
            }
            n = this.nextNoWhitespace(xmlPullParser);
        }
        xmlPullParser.next();
        return atomEntry;
    }

    private String parseString(XmlPullParser xmlPullParser) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        this.next(xmlPullParser);
        while (xmlPullParser.getEventType() == 4 || xmlPullParser.getEventType() == 7 || xmlPullParser.getEventType() == 6) {
            stringBuilder.append(xmlPullParser.getText());
            this.next(xmlPullParser);
        }
        if (xmlPullParser.getEventType() != 3) {
            throw new Exception("Bad String Structure - parsed " + stringBuilder.toString() + " now found " + Integer.toString(xmlPullParser.getEventType()));
        }
        this.next(xmlPullParser);
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    private int parseInt(XmlPullParser xmlPullParser) throws Exception {
        int n = -1;
        String string = this.parseString(xmlPullParser);
        n = Integer.parseInt(string);
        return n;
    }

    private DateAndTime parseDate(XmlPullParser xmlPullParser) throws Exception {
        return new DateAndTime(this.parseString(xmlPullParser));
    }
}

