/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;

public class Address
extends Type {
    protected Enumeration<AddressUse> use;
    protected StringType text;
    protected List<StringType> line = new ArrayList<StringType>();
    protected StringType city;
    protected StringType state;
    protected StringType zip;
    protected StringType country;
    protected Period period;
    private static final long serialVersionUID = 1214286881L;

    public Enumeration<AddressUse> getUse() {
        return this.use;
    }

    public Address setUse(Enumeration<AddressUse> enumeration) {
        this.use = enumeration;
        return this;
    }

    public AddressUse getUseSimple() {
        return this.use == null ? null : this.use.getValue();
    }

    public Address setUseSimple(AddressUse addressUse) {
        if (addressUse == null) {
            this.use = null;
        } else {
            if (this.use == null) {
                this.use = new Enumeration();
            }
            this.use.setValue(addressUse);
        }
        return this;
    }

    public StringType getText() {
        return this.text;
    }

    public Address setText(StringType stringType) {
        this.text = stringType;
        return this;
    }

    public String getTextSimple() {
        return this.text == null ? null : this.text.getValue();
    }

    public Address setTextSimple(String string) {
        if (string == null) {
            this.text = null;
        } else {
            if (this.text == null) {
                this.text = new StringType();
            }
            this.text.setValue(string);
        }
        return this;
    }

    public List<StringType> getLine() {
        return this.line;
    }

    public StringType addLine() {
        StringType stringType = new StringType();
        this.line.add(stringType);
        return stringType;
    }

    public StringType addLineSimple(String string) {
        StringType stringType = new StringType();
        stringType.setValue(string);
        this.line.add(stringType);
        return stringType;
    }

    public boolean hasLineSimple(String string) {
        for (StringType stringType : this.line) {
            if (!stringType.getValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    public StringType getCity() {
        return this.city;
    }

    public Address setCity(StringType stringType) {
        this.city = stringType;
        return this;
    }

    public String getCitySimple() {
        return this.city == null ? null : this.city.getValue();
    }

    public Address setCitySimple(String string) {
        if (string == null) {
            this.city = null;
        } else {
            if (this.city == null) {
                this.city = new StringType();
            }
            this.city.setValue(string);
        }
        return this;
    }

    public StringType getState() {
        return this.state;
    }

    public Address setState(StringType stringType) {
        this.state = stringType;
        return this;
    }

    public String getStateSimple() {
        return this.state == null ? null : this.state.getValue();
    }

    public Address setStateSimple(String string) {
        if (string == null) {
            this.state = null;
        } else {
            if (this.state == null) {
                this.state = new StringType();
            }
            this.state.setValue(string);
        }
        return this;
    }

    public StringType getZip() {
        return this.zip;
    }

    public Address setZip(StringType stringType) {
        this.zip = stringType;
        return this;
    }

    public String getZipSimple() {
        return this.zip == null ? null : this.zip.getValue();
    }

    public Address setZipSimple(String string) {
        if (string == null) {
            this.zip = null;
        } else {
            if (this.zip == null) {
                this.zip = new StringType();
            }
            this.zip.setValue(string);
        }
        return this;
    }

    public StringType getCountry() {
        return this.country;
    }

    public Address setCountry(StringType stringType) {
        this.country = stringType;
        return this;
    }

    public String getCountrySimple() {
        return this.country == null ? null : this.country.getValue();
    }

    public Address setCountrySimple(String string) {
        if (string == null) {
            this.country = null;
        } else {
            if (this.country == null) {
                this.country = new StringType();
            }
            this.country.setValue(string);
        }
        return this;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Address setPeriod(Period period) {
        this.period = period;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("use", "code", "The purpose of this address.", 0, Integer.MAX_VALUE, this.use));
        list.add(new Property("text", "string", "A full text representation of the address.", 0, Integer.MAX_VALUE, this.text));
        list.add(new Property("line", "string", "This component contains the house number, apartment number, street name, street direction, \nP.O. Box number, delivery hints, and similar address information.", 0, Integer.MAX_VALUE, this.line));
        list.add(new Property("city", "string", "The name of the city, town, village or other community or delivery center.", 0, Integer.MAX_VALUE, this.city));
        list.add(new Property("state", "string", "Sub-unit of a country with limited sovereignty in a federally organized country. A code may be used if codes are in common use (i.e. US 2 letter state codes).", 0, Integer.MAX_VALUE, this.state));
        list.add(new Property("zip", "string", "A postal code designating a region defined by the postal service.", 0, Integer.MAX_VALUE, this.zip));
        list.add(new Property("country", "string", "Country - a nation as commonly understood or generally accepted.", 0, Integer.MAX_VALUE, this.country));
        list.add(new Property("period", "Period", "Time period when address was/is in use.", 0, Integer.MAX_VALUE, this.period));
    }

    @Override
    public Address copy() {
        Address address = new Address();
        address.use = this.use == null ? null : this.use.copy();
        address.text = this.text == null ? null : this.text.copy();
        address.line = new ArrayList<StringType>();
        for (StringType stringType : this.line) {
            address.line.add(stringType.copy());
        }
        address.city = this.city == null ? null : this.city.copy();
        address.state = this.state == null ? null : this.state.copy();
        address.zip = this.zip == null ? null : this.zip.copy();
        address.country = this.country == null ? null : this.country.copy();
        address.period = this.period == null ? null : this.period.copy();
        return address;
    }

    @Override
    protected Address typedCopy() {
        return this.copy();
    }

    public static class AddressUseEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("home".equals(string)) {
                return AddressUse.home;
            }
            if ("work".equals(string)) {
                return AddressUse.work;
            }
            if ("temp".equals(string)) {
                return AddressUse.temp;
            }
            if ("old".equals(string)) {
                return AddressUse.old;
            }
            throw new Exception("Unknown AddressUse code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == AddressUse.home) {
                return "home";
            }
            if (enum_ == AddressUse.work) {
                return "work";
            }
            if (enum_ == AddressUse.temp) {
                return "temp";
            }
            if (enum_ == AddressUse.old) {
                return "old";
            }
            return "?";
        }
    }

    public static enum AddressUse {
        home,
        work,
        temp,
        old,
        Null;


        public static AddressUse fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("home".equals(string)) {
                return home;
            }
            if ("work".equals(string)) {
                return work;
            }
            if ("temp".equals(string)) {
                return temp;
            }
            if ("old".equals(string)) {
                return old;
            }
            throw new Exception("Unknown AddressUse code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case home: {
                    return "home";
                }
                case work: {
                    return "work";
                }
                case temp: {
                    return "temp";
                }
                case old: {
                    return "old";
                }
            }
            return "?";
        }
    }
}

