/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.Substance;

public class AdverseReaction
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected DateTimeType date;
    protected ResourceReference subject;
    protected Patient subjectTarget;
    protected BooleanType didNotOccurFlag;
    protected ResourceReference recorder;
    protected Resource recorderTarget;
    protected List<AdverseReactionSymptomComponent> symptom = new ArrayList<AdverseReactionSymptomComponent>();
    protected List<AdverseReactionExposureComponent> exposure = new ArrayList<AdverseReactionExposureComponent>();
    private static final long serialVersionUID = -285872214L;

    public AdverseReaction() {
    }

    public AdverseReaction(ResourceReference resourceReference, BooleanType booleanType) {
        this.subject = resourceReference;
        this.didNotOccurFlag = booleanType;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public DateTimeType getDate() {
        return this.date;
    }

    public AdverseReaction setDate(DateTimeType dateTimeType) {
        this.date = dateTimeType;
        return this;
    }

    public DateAndTime getDateSimple() {
        return this.date == null ? null : this.date.getValue();
    }

    public AdverseReaction setDateSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(dateAndTime);
        }
        return this;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public AdverseReaction setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Patient getSubjectTarget() {
        return this.subjectTarget;
    }

    public AdverseReaction setSubjectTarget(Patient patient) {
        this.subjectTarget = patient;
        return this;
    }

    public BooleanType getDidNotOccurFlag() {
        return this.didNotOccurFlag;
    }

    public AdverseReaction setDidNotOccurFlag(BooleanType booleanType) {
        this.didNotOccurFlag = booleanType;
        return this;
    }

    public boolean getDidNotOccurFlagSimple() {
        return this.didNotOccurFlag == null ? false : this.didNotOccurFlag.getValue();
    }

    public AdverseReaction setDidNotOccurFlagSimple(boolean bl) {
        if (this.didNotOccurFlag == null) {
            this.didNotOccurFlag = new BooleanType();
        }
        this.didNotOccurFlag.setValue(bl);
        return this;
    }

    public ResourceReference getRecorder() {
        return this.recorder;
    }

    public AdverseReaction setRecorder(ResourceReference resourceReference) {
        this.recorder = resourceReference;
        return this;
    }

    public Resource getRecorderTarget() {
        return this.recorderTarget;
    }

    public AdverseReaction setRecorderTarget(Resource resource) {
        this.recorderTarget = resource;
        return this;
    }

    public List<AdverseReactionSymptomComponent> getSymptom() {
        return this.symptom;
    }

    public AdverseReactionSymptomComponent addSymptom() {
        AdverseReactionSymptomComponent adverseReactionSymptomComponent = new AdverseReactionSymptomComponent();
        this.symptom.add(adverseReactionSymptomComponent);
        return adverseReactionSymptomComponent;
    }

    public List<AdverseReactionExposureComponent> getExposure() {
        return this.exposure;
    }

    public AdverseReactionExposureComponent addExposure() {
        AdverseReactionExposureComponent adverseReactionExposureComponent = new AdverseReactionExposureComponent();
        this.exposure.add(adverseReactionExposureComponent);
        return adverseReactionExposureComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "This records identifiers associated with this reaction that are defined by business processed and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("date", "dateTime", "The date (and possibly time) when the reaction began.", 0, Integer.MAX_VALUE, this.date));
        list.add(new Property("subject", "Resource(Patient)", "The subject of the adverse reaction.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("didNotOccurFlag", "boolean", "If true, indicates that no reaction occurred.", 0, Integer.MAX_VALUE, this.didNotOccurFlag));
        list.add(new Property("recorder", "Resource(Practitioner|Patient)", "Identifies the individual responsible for the information in the reaction record.", 0, Integer.MAX_VALUE, this.recorder));
        list.add(new Property("symptom", "", "The signs and symptoms that were observed as part of the reaction.", 0, Integer.MAX_VALUE, this.symptom));
        list.add(new Property("exposure", "", "An exposure to a substance that preceded a reaction occurrence.", 0, Integer.MAX_VALUE, this.exposure));
    }

    public AdverseReaction copy() {
        AdverseReaction adverseReaction = new AdverseReaction();
        adverseReaction.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            adverseReaction.identifier.add(element.copy());
        }
        adverseReaction.date = this.date == null ? null : this.date.copy();
        adverseReaction.subject = this.subject == null ? null : this.subject.copy();
        adverseReaction.didNotOccurFlag = this.didNotOccurFlag == null ? null : this.didNotOccurFlag.copy();
        adverseReaction.recorder = this.recorder == null ? null : this.recorder.copy();
        adverseReaction.symptom = new ArrayList<AdverseReactionSymptomComponent>();
        for (AdverseReactionSymptomComponent adverseReactionSymptomComponent : this.symptom) {
            adverseReaction.symptom.add(adverseReactionSymptomComponent.copy());
        }
        adverseReaction.exposure = new ArrayList<AdverseReactionExposureComponent>();
        for (AdverseReactionExposureComponent adverseReactionExposureComponent : this.exposure) {
            adverseReaction.exposure.add(adverseReactionExposureComponent.copy());
        }
        return adverseReaction;
    }

    protected AdverseReaction typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.AdverseReaction;
    }

    public static class AdverseReactionExposureComponent
    extends BackboneElement {
        protected DateTimeType date;
        protected Enumeration<ExposureType> type;
        protected Enumeration<CausalityExpectation> causalityExpectation;
        protected ResourceReference substance;
        protected Substance substanceTarget;
        private static final long serialVersionUID = -1829911400L;

        public DateTimeType getDate() {
            return this.date;
        }

        public AdverseReactionExposureComponent setDate(DateTimeType dateTimeType) {
            this.date = dateTimeType;
            return this;
        }

        public DateAndTime getDateSimple() {
            return this.date == null ? null : this.date.getValue();
        }

        public AdverseReactionExposureComponent setDateSimple(DateAndTime dateAndTime) {
            if (dateAndTime == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(dateAndTime);
            }
            return this;
        }

        public Enumeration<ExposureType> getType() {
            return this.type;
        }

        public AdverseReactionExposureComponent setType(Enumeration<ExposureType> enumeration) {
            this.type = enumeration;
            return this;
        }

        public ExposureType getTypeSimple() {
            return this.type == null ? null : this.type.getValue();
        }

        public AdverseReactionExposureComponent setTypeSimple(ExposureType exposureType) {
            if (exposureType == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration();
                }
                this.type.setValue(exposureType);
            }
            return this;
        }

        public Enumeration<CausalityExpectation> getCausalityExpectation() {
            return this.causalityExpectation;
        }

        public AdverseReactionExposureComponent setCausalityExpectation(Enumeration<CausalityExpectation> enumeration) {
            this.causalityExpectation = enumeration;
            return this;
        }

        public CausalityExpectation getCausalityExpectationSimple() {
            return this.causalityExpectation == null ? null : this.causalityExpectation.getValue();
        }

        public AdverseReactionExposureComponent setCausalityExpectationSimple(CausalityExpectation causalityExpectation) {
            if (causalityExpectation == null) {
                this.causalityExpectation = null;
            } else {
                if (this.causalityExpectation == null) {
                    this.causalityExpectation = new Enumeration();
                }
                this.causalityExpectation.setValue(causalityExpectation);
            }
            return this;
        }

        public ResourceReference getSubstance() {
            return this.substance;
        }

        public AdverseReactionExposureComponent setSubstance(ResourceReference resourceReference) {
            this.substance = resourceReference;
            return this;
        }

        public Substance getSubstanceTarget() {
            return this.substanceTarget;
        }

        public AdverseReactionExposureComponent setSubstanceTarget(Substance substance) {
            this.substanceTarget = substance;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("date", "dateTime", "Identifies the initial date of the exposure that is suspected to be related to the reaction.", 0, Integer.MAX_VALUE, this.date));
            list.add(new Property("type", "code", "The type of exposure: Drug Administration, Immunization, Coincidental.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("causalityExpectation", "code", "A statement of how confident that the recorder was that this exposure caused the reaction.", 0, Integer.MAX_VALUE, this.causalityExpectation));
            list.add(new Property("substance", "Resource(Substance)", "Substance that is presumed to have caused the adverse reaction.", 0, Integer.MAX_VALUE, this.substance));
        }

        public AdverseReactionExposureComponent copy() {
            AdverseReactionExposureComponent adverseReactionExposureComponent = new AdverseReactionExposureComponent();
            adverseReactionExposureComponent.date = this.date == null ? null : this.date.copy();
            adverseReactionExposureComponent.type = this.type == null ? null : this.type.copy();
            adverseReactionExposureComponent.causalityExpectation = this.causalityExpectation == null ? null : this.causalityExpectation.copy();
            adverseReactionExposureComponent.substance = this.substance == null ? null : this.substance.copy();
            return adverseReactionExposureComponent;
        }
    }

    public static class AdverseReactionSymptomComponent
    extends BackboneElement {
        protected CodeableConcept code;
        protected Enumeration<ReactionSeverity> severity;
        private static final long serialVersionUID = -1856198542L;

        public AdverseReactionSymptomComponent() {
        }

        public AdverseReactionSymptomComponent(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public AdverseReactionSymptomComponent setCode(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
            return this;
        }

        public Enumeration<ReactionSeverity> getSeverity() {
            return this.severity;
        }

        public AdverseReactionSymptomComponent setSeverity(Enumeration<ReactionSeverity> enumeration) {
            this.severity = enumeration;
            return this;
        }

        public ReactionSeverity getSeveritySimple() {
            return this.severity == null ? null : this.severity.getValue();
        }

        public AdverseReactionSymptomComponent setSeveritySimple(ReactionSeverity reactionSeverity) {
            if (reactionSeverity == null) {
                this.severity = null;
            } else {
                if (this.severity == null) {
                    this.severity = new Enumeration();
                }
                this.severity.setValue(reactionSeverity);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "CodeableConcept", "Indicates the specific sign or symptom that was observed.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("severity", "code", "The severity of the sign or symptom.", 0, Integer.MAX_VALUE, this.severity));
        }

        public AdverseReactionSymptomComponent copy() {
            AdverseReactionSymptomComponent adverseReactionSymptomComponent = new AdverseReactionSymptomComponent();
            adverseReactionSymptomComponent.code = this.code == null ? null : this.code.copy();
            adverseReactionSymptomComponent.severity = this.severity == null ? null : this.severity.copy();
            return adverseReactionSymptomComponent;
        }
    }

    public static class CausalityExpectationEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("likely".equals(string)) {
                return CausalityExpectation.likely;
            }
            if ("unlikely".equals(string)) {
                return CausalityExpectation.unlikely;
            }
            if ("confirmed".equals(string)) {
                return CausalityExpectation.confirmed;
            }
            if ("unknown".equals(string)) {
                return CausalityExpectation.unknown;
            }
            throw new Exception("Unknown CausalityExpectation code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == CausalityExpectation.likely) {
                return "likely";
            }
            if (enum_ == CausalityExpectation.unlikely) {
                return "unlikely";
            }
            if (enum_ == CausalityExpectation.confirmed) {
                return "confirmed";
            }
            if (enum_ == CausalityExpectation.unknown) {
                return "unknown";
            }
            return "?";
        }
    }

    public static enum CausalityExpectation {
        likely,
        unlikely,
        confirmed,
        unknown,
        Null;


        public static CausalityExpectation fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("likely".equals(string)) {
                return likely;
            }
            if ("unlikely".equals(string)) {
                return unlikely;
            }
            if ("confirmed".equals(string)) {
                return confirmed;
            }
            if ("unknown".equals(string)) {
                return unknown;
            }
            throw new Exception("Unknown CausalityExpectation code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case likely: {
                    return "likely";
                }
                case unlikely: {
                    return "unlikely";
                }
                case confirmed: {
                    return "confirmed";
                }
                case unknown: {
                    return "unknown";
                }
            }
            return "?";
        }
    }

    public static class ExposureTypeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("drugadmin".equals(string)) {
                return ExposureType.drugadmin;
            }
            if ("immuniz".equals(string)) {
                return ExposureType.immuniz;
            }
            if ("coincidental".equals(string)) {
                return ExposureType.coincidental;
            }
            throw new Exception("Unknown ExposureType code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ExposureType.drugadmin) {
                return "drugadmin";
            }
            if (enum_ == ExposureType.immuniz) {
                return "immuniz";
            }
            if (enum_ == ExposureType.coincidental) {
                return "coincidental";
            }
            return "?";
        }
    }

    public static enum ExposureType {
        drugadmin,
        immuniz,
        coincidental,
        Null;


        public static ExposureType fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("drugadmin".equals(string)) {
                return drugadmin;
            }
            if ("immuniz".equals(string)) {
                return immuniz;
            }
            if ("coincidental".equals(string)) {
                return coincidental;
            }
            throw new Exception("Unknown ExposureType code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case drugadmin: {
                    return "drugadmin";
                }
                case immuniz: {
                    return "immuniz";
                }
                case coincidental: {
                    return "coincidental";
                }
            }
            return "?";
        }
    }

    public static class ReactionSeverityEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("severe".equals(string)) {
                return ReactionSeverity.severe;
            }
            if ("serious".equals(string)) {
                return ReactionSeverity.serious;
            }
            if ("moderate".equals(string)) {
                return ReactionSeverity.moderate;
            }
            if ("minor".equals(string)) {
                return ReactionSeverity.minor;
            }
            throw new Exception("Unknown ReactionSeverity code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ReactionSeverity.severe) {
                return "severe";
            }
            if (enum_ == ReactionSeverity.serious) {
                return "serious";
            }
            if (enum_ == ReactionSeverity.moderate) {
                return "moderate";
            }
            if (enum_ == ReactionSeverity.minor) {
                return "minor";
            }
            return "?";
        }
    }

    public static enum ReactionSeverity {
        severe,
        serious,
        moderate,
        minor,
        Null;


        public static ReactionSeverity fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("severe".equals(string)) {
                return severe;
            }
            if ("serious".equals(string)) {
                return serious;
            }
            if ("moderate".equals(string)) {
                return moderate;
            }
            if ("minor".equals(string)) {
                return minor;
            }
            throw new Exception("Unknown ReactionSeverity code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case severe: {
                    return "severe";
                }
                case serious: {
                    return "serious";
                }
                case moderate: {
                    return "moderate";
                }
                case minor: {
                    return "minor";
                }
            }
            return "?";
        }
    }
}

