/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;

public class Alert
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected CodeableConcept category;
    protected Enumeration<AlertStatus> status;
    protected ResourceReference subject;
    protected Patient subjectTarget;
    protected ResourceReference author;
    protected Resource authorTarget;
    protected StringType note;
    private static final long serialVersionUID = 1816158418L;

    public Alert() {
    }

    public Alert(Enumeration<AlertStatus> enumeration, ResourceReference resourceReference, StringType stringType) {
        this.status = enumeration;
        this.subject = resourceReference;
        this.note = stringType;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public CodeableConcept getCategory() {
        return this.category;
    }

    public Alert setCategory(CodeableConcept codeableConcept) {
        this.category = codeableConcept;
        return this;
    }

    public Enumeration<AlertStatus> getStatus() {
        return this.status;
    }

    public Alert setStatus(Enumeration<AlertStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public AlertStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public Alert setStatusSimple(AlertStatus alertStatus) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(alertStatus);
        return this;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public Alert setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Patient getSubjectTarget() {
        return this.subjectTarget;
    }

    public Alert setSubjectTarget(Patient patient) {
        this.subjectTarget = patient;
        return this;
    }

    public ResourceReference getAuthor() {
        return this.author;
    }

    public Alert setAuthor(ResourceReference resourceReference) {
        this.author = resourceReference;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public Alert setAuthorTarget(Resource resource) {
        this.authorTarget = resource;
        return this;
    }

    public StringType getNote() {
        return this.note;
    }

    public Alert setNote(StringType stringType) {
        this.note = stringType;
        return this;
    }

    public String getNoteSimple() {
        return this.note == null ? null : this.note.getValue();
    }

    public Alert setNoteSimple(String string) {
        if (this.note == null) {
            this.note = new StringType();
        }
        this.note.setValue(string);
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "Identifier assigned to the alert for external use (outside the FHIR environment).", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("category", "CodeableConcept", "Allows an alert to be divided into different categories like clinical, administrative etc.", 0, Integer.MAX_VALUE, this.category));
        list.add(new Property("status", "code", "Supports basic workflow.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("subject", "Resource(Patient)", "The person who this alert concerns.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("author", "Resource(Practitioner|Patient|Device)", "The person or device that created the alert.", 0, Integer.MAX_VALUE, this.author));
        list.add(new Property("note", "string", "The textual component of the alert to display to the user.", 0, Integer.MAX_VALUE, this.note));
    }

    public Alert copy() {
        Alert alert = new Alert();
        alert.identifier = new ArrayList<Identifier>();
        for (Identifier identifier : this.identifier) {
            alert.identifier.add(identifier.copy());
        }
        alert.category = this.category == null ? null : this.category.copy();
        alert.status = this.status == null ? null : this.status.copy();
        alert.subject = this.subject == null ? null : this.subject.copy();
        alert.author = this.author == null ? null : this.author.copy();
        alert.note = this.note == null ? null : this.note.copy();
        return alert;
    }

    protected Alert typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Alert;
    }

    public static class AlertStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("active".equals(string)) {
                return AlertStatus.active;
            }
            if ("inactive".equals(string)) {
                return AlertStatus.inactive;
            }
            if ("entered in error".equals(string)) {
                return AlertStatus.enteredInError;
            }
            throw new Exception("Unknown AlertStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == AlertStatus.active) {
                return "active";
            }
            if (enum_ == AlertStatus.inactive) {
                return "inactive";
            }
            if (enum_ == AlertStatus.enteredInError) {
                return "entered in error";
            }
            return "?";
        }
    }

    public static enum AlertStatus {
        active,
        inactive,
        enteredInError,
        Null;


        public static AlertStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("active".equals(string)) {
                return active;
            }
            if ("inactive".equals(string)) {
                return inactive;
            }
            if ("entered in error".equals(string)) {
                return enteredInError;
            }
            throw new Exception("Unknown AlertStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case active: {
                    return "active";
                }
                case inactive: {
                    return "inactive";
                }
                case enteredInError: {
                    return "entered in error";
                }
            }
            return "?";
        }
    }
}

