/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.AdverseReaction;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Observation;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.Substance;

public class AllergyIntolerance
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected Enumeration<Criticality> criticality;
    protected Enumeration<Sensitivitytype> sensitivityType;
    protected DateTimeType recordedDate;
    protected Enumeration<Sensitivitystatus> status;
    protected ResourceReference subject;
    protected Patient subjectTarget;
    protected ResourceReference recorder;
    protected Resource recorderTarget;
    protected ResourceReference substance;
    protected Substance substanceTarget;
    protected List<ResourceReference> reaction = new ArrayList<ResourceReference>();
    protected List<AdverseReaction> reactionTarget = new ArrayList<AdverseReaction>();
    protected List<ResourceReference> sensitivityTest = new ArrayList<ResourceReference>();
    protected List<Observation> sensitivityTestTarget = new ArrayList<Observation>();
    private static final long serialVersionUID = -449872376L;

    public AllergyIntolerance() {
    }

    public AllergyIntolerance(Enumeration<Sensitivitytype> enumeration, Enumeration<Sensitivitystatus> enumeration2, ResourceReference resourceReference, ResourceReference resourceReference2) {
        this.sensitivityType = enumeration;
        this.status = enumeration2;
        this.subject = resourceReference;
        this.substance = resourceReference2;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public Enumeration<Criticality> getCriticality() {
        return this.criticality;
    }

    public AllergyIntolerance setCriticality(Enumeration<Criticality> enumeration) {
        this.criticality = enumeration;
        return this;
    }

    public Criticality getCriticalitySimple() {
        return this.criticality == null ? null : this.criticality.getValue();
    }

    public AllergyIntolerance setCriticalitySimple(Criticality criticality) {
        if (criticality == null) {
            this.criticality = null;
        } else {
            if (this.criticality == null) {
                this.criticality = new Enumeration();
            }
            this.criticality.setValue(criticality);
        }
        return this;
    }

    public Enumeration<Sensitivitytype> getSensitivityType() {
        return this.sensitivityType;
    }

    public AllergyIntolerance setSensitivityType(Enumeration<Sensitivitytype> enumeration) {
        this.sensitivityType = enumeration;
        return this;
    }

    public Sensitivitytype getSensitivityTypeSimple() {
        return this.sensitivityType == null ? null : this.sensitivityType.getValue();
    }

    public AllergyIntolerance setSensitivityTypeSimple(Sensitivitytype sensitivitytype) {
        if (this.sensitivityType == null) {
            this.sensitivityType = new Enumeration();
        }
        this.sensitivityType.setValue(sensitivitytype);
        return this;
    }

    public DateTimeType getRecordedDate() {
        return this.recordedDate;
    }

    public AllergyIntolerance setRecordedDate(DateTimeType dateTimeType) {
        this.recordedDate = dateTimeType;
        return this;
    }

    public DateAndTime getRecordedDateSimple() {
        return this.recordedDate == null ? null : this.recordedDate.getValue();
    }

    public AllergyIntolerance setRecordedDateSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.recordedDate = null;
        } else {
            if (this.recordedDate == null) {
                this.recordedDate = new DateTimeType();
            }
            this.recordedDate.setValue(dateAndTime);
        }
        return this;
    }

    public Enumeration<Sensitivitystatus> getStatus() {
        return this.status;
    }

    public AllergyIntolerance setStatus(Enumeration<Sensitivitystatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public Sensitivitystatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public AllergyIntolerance setStatusSimple(Sensitivitystatus sensitivitystatus) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(sensitivitystatus);
        return this;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public AllergyIntolerance setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Patient getSubjectTarget() {
        return this.subjectTarget;
    }

    public AllergyIntolerance setSubjectTarget(Patient patient) {
        this.subjectTarget = patient;
        return this;
    }

    public ResourceReference getRecorder() {
        return this.recorder;
    }

    public AllergyIntolerance setRecorder(ResourceReference resourceReference) {
        this.recorder = resourceReference;
        return this;
    }

    public Resource getRecorderTarget() {
        return this.recorderTarget;
    }

    public AllergyIntolerance setRecorderTarget(Resource resource) {
        this.recorderTarget = resource;
        return this;
    }

    public ResourceReference getSubstance() {
        return this.substance;
    }

    public AllergyIntolerance setSubstance(ResourceReference resourceReference) {
        this.substance = resourceReference;
        return this;
    }

    public Substance getSubstanceTarget() {
        return this.substanceTarget;
    }

    public AllergyIntolerance setSubstanceTarget(Substance substance) {
        this.substanceTarget = substance;
        return this;
    }

    public List<ResourceReference> getReaction() {
        return this.reaction;
    }

    public ResourceReference addReaction() {
        ResourceReference resourceReference = new ResourceReference();
        this.reaction.add(resourceReference);
        return resourceReference;
    }

    public List<AdverseReaction> getReactionTarget() {
        return this.reactionTarget;
    }

    public AdverseReaction addReactionTarget() {
        AdverseReaction adverseReaction = new AdverseReaction();
        this.reactionTarget.add(adverseReaction);
        return adverseReaction;
    }

    public List<ResourceReference> getSensitivityTest() {
        return this.sensitivityTest;
    }

    public ResourceReference addSensitivityTest() {
        ResourceReference resourceReference = new ResourceReference();
        this.sensitivityTest.add(resourceReference);
        return resourceReference;
    }

    public List<Observation> getSensitivityTestTarget() {
        return this.sensitivityTestTarget;
    }

    public Observation addSensitivityTestTarget() {
        Observation observation = new Observation();
        this.sensitivityTestTarget.add(observation);
        return observation;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "This records identifiers associated with this allergy/intolerance concern that are defined by business processed and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("criticality", "code", "Criticality of the sensitivity.", 0, Integer.MAX_VALUE, this.criticality));
        list.add(new Property("sensitivityType", "code", "Type of the sensitivity.", 0, Integer.MAX_VALUE, this.sensitivityType));
        list.add(new Property("recordedDate", "dateTime", "Date when the sensitivity was recorded.", 0, Integer.MAX_VALUE, this.recordedDate));
        list.add(new Property("status", "code", "Status of the sensitivity.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("subject", "Resource(Patient)", "The patient who has the allergy or intolerance.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("recorder", "Resource(Practitioner|Patient)", "Indicates who has responsibility for the record.", 0, Integer.MAX_VALUE, this.recorder));
        list.add(new Property("substance", "Resource(Substance)", "The substance that causes the sensitivity.", 0, Integer.MAX_VALUE, this.substance));
        list.add(new Property("reaction", "Resource(AdverseReaction)", "Reactions associated with the sensitivity.", 0, Integer.MAX_VALUE, this.reaction));
        list.add(new Property("sensitivityTest", "Resource(Observation)", "Observations that confirm or refute the sensitivity.", 0, Integer.MAX_VALUE, this.sensitivityTest));
    }

    public AllergyIntolerance copy() {
        AllergyIntolerance allergyIntolerance = new AllergyIntolerance();
        allergyIntolerance.identifier = new ArrayList<Identifier>();
        for (Identifier type : this.identifier) {
            allergyIntolerance.identifier.add(type.copy());
        }
        allergyIntolerance.criticality = this.criticality == null ? null : this.criticality.copy();
        allergyIntolerance.sensitivityType = this.sensitivityType == null ? null : this.sensitivityType.copy();
        allergyIntolerance.recordedDate = this.recordedDate == null ? null : this.recordedDate.copy();
        allergyIntolerance.status = this.status == null ? null : this.status.copy();
        allergyIntolerance.subject = this.subject == null ? null : this.subject.copy();
        allergyIntolerance.recorder = this.recorder == null ? null : this.recorder.copy();
        allergyIntolerance.substance = this.substance == null ? null : this.substance.copy();
        allergyIntolerance.reaction = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.reaction) {
            allergyIntolerance.reaction.add(resourceReference.copy());
        }
        allergyIntolerance.sensitivityTest = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.sensitivityTest) {
            allergyIntolerance.sensitivityTest.add(resourceReference.copy());
        }
        return allergyIntolerance;
    }

    protected AllergyIntolerance typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.AllergyIntolerance;
    }

    public static class SensitivitystatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("suspected".equals(string)) {
                return Sensitivitystatus.suspected;
            }
            if ("confirmed".equals(string)) {
                return Sensitivitystatus.confirmed;
            }
            if ("refuted".equals(string)) {
                return Sensitivitystatus.refuted;
            }
            if ("resolved".equals(string)) {
                return Sensitivitystatus.resolved;
            }
            throw new Exception("Unknown Sensitivitystatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == Sensitivitystatus.suspected) {
                return "suspected";
            }
            if (enum_ == Sensitivitystatus.confirmed) {
                return "confirmed";
            }
            if (enum_ == Sensitivitystatus.refuted) {
                return "refuted";
            }
            if (enum_ == Sensitivitystatus.resolved) {
                return "resolved";
            }
            return "?";
        }
    }

    public static enum Sensitivitystatus {
        suspected,
        confirmed,
        refuted,
        resolved,
        Null;


        public static Sensitivitystatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("suspected".equals(string)) {
                return suspected;
            }
            if ("confirmed".equals(string)) {
                return confirmed;
            }
            if ("refuted".equals(string)) {
                return refuted;
            }
            if ("resolved".equals(string)) {
                return resolved;
            }
            throw new Exception("Unknown Sensitivitystatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case suspected: {
                    return "suspected";
                }
                case confirmed: {
                    return "confirmed";
                }
                case refuted: {
                    return "refuted";
                }
                case resolved: {
                    return "resolved";
                }
            }
            return "?";
        }
    }

    public static class SensitivitytypeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("allergy".equals(string)) {
                return Sensitivitytype.allergy;
            }
            if ("intolerance".equals(string)) {
                return Sensitivitytype.intolerance;
            }
            if ("unknown".equals(string)) {
                return Sensitivitytype.unknown;
            }
            throw new Exception("Unknown Sensitivitytype code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == Sensitivitytype.allergy) {
                return "allergy";
            }
            if (enum_ == Sensitivitytype.intolerance) {
                return "intolerance";
            }
            if (enum_ == Sensitivitytype.unknown) {
                return "unknown";
            }
            return "?";
        }
    }

    public static enum Sensitivitytype {
        allergy,
        intolerance,
        unknown,
        Null;


        public static Sensitivitytype fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("allergy".equals(string)) {
                return allergy;
            }
            if ("intolerance".equals(string)) {
                return intolerance;
            }
            if ("unknown".equals(string)) {
                return unknown;
            }
            throw new Exception("Unknown Sensitivitytype code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case allergy: {
                    return "allergy";
                }
                case intolerance: {
                    return "intolerance";
                }
                case unknown: {
                    return "unknown";
                }
            }
            return "?";
        }
    }

    public static class CriticalityEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("fatal".equals(string)) {
                return Criticality.fatal;
            }
            if ("high".equals(string)) {
                return Criticality.high;
            }
            if ("medium".equals(string)) {
                return Criticality.medium;
            }
            if ("low".equals(string)) {
                return Criticality.low;
            }
            throw new Exception("Unknown Criticality code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == Criticality.fatal) {
                return "fatal";
            }
            if (enum_ == Criticality.high) {
                return "high";
            }
            if (enum_ == Criticality.medium) {
                return "medium";
            }
            if (enum_ == Criticality.low) {
                return "low";
            }
            return "?";
        }
    }

    public static enum Criticality {
        fatal,
        high,
        medium,
        low,
        Null;


        public static Criticality fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("fatal".equals(string)) {
                return fatal;
            }
            if ("high".equals(string)) {
                return high;
            }
            if ("medium".equals(string)) {
                return medium;
            }
            if ("low".equals(string)) {
                return low;
            }
            throw new Exception("Unknown Criticality code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case fatal: {
                    return "fatal";
                }
                case high: {
                    return "high";
                }
                case medium: {
                    return "medium";
                }
                case low: {
                    return "low";
                }
            }
            return "?";
        }
    }
}

