/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.formats.FormatUtilities;
import org.hl7.fhir.instance.model.AtomBase;
import org.hl7.fhir.instance.model.AtomCategory;
import org.hl7.fhir.instance.model.AtomEntry;
import org.hl7.fhir.instance.model.Resource;

public class AtomFeed
extends AtomBase {
    private Integer totalResults;
    private List<AtomEntry<? extends Resource>> entryList = new ArrayList<AtomEntry<? extends Resource>>();

    public List<AtomEntry<? extends Resource>> getEntryList() {
        return this.entryList;
    }

    public Integer getTotalResults() {
        return this.totalResults;
    }

    public void setTotalResults(Integer n) {
        this.totalResults = n;
    }

    public AtomEntry<? extends Resource> getById(String string) {
        for (AtomEntry<? extends Resource> atomEntry : this.entryList) {
            if (!atomEntry.getId().equals(string)) continue;
            return atomEntry;
        }
        return null;
    }

    public boolean isDocument() {
        return this.hasTag("http://hl7.org/fhir/tag", "http://hl7.org/fhir/tag/document");
    }

    private boolean hasTag(String string, String string2) {
        for (AtomCategory atomCategory : this.getTags()) {
            if (!string.equals(atomCategory.getScheme()) || !string2.equals(atomCategory.getTerm())) continue;
            return true;
        }
        return false;
    }

    public String getLogicalId(AtomEntry<? extends Resource> atomEntry) throws Exception {
        if (atomEntry.getId() == null) {
            throw new Exception("Unable to determine logical id for unknown resource");
        }
        if (this.getLinks().containsKey("fhir-base") && atomEntry.getId().startsWith(this.getLinks().get("fhir-base"))) {
            String string = atomEntry.getId().substring((this.getLinks().get("fhir-base") + atomEntry.getResource().getResourceType().toString()).length());
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if (FormatUtilities.isValidId(string)) {
                return string;
            }
            throw new Exception("Unable to determine logical id for resource " + atomEntry.getId());
        }
        if (atomEntry.getId().contains("/")) {
            String string = atomEntry.getId().substring(atomEntry.getId().lastIndexOf("/") + 1);
            if (FormatUtilities.isValidId(string)) {
                return string;
            }
            throw new Exception("Unable to determine logical id for resource " + atomEntry.getId());
        }
        throw new Exception("Unable to determine logical id for resource " + atomEntry.getId());
    }

    public String getVersionId(AtomEntry<? extends Resource> atomEntry) throws Exception {
        String string = atomEntry.getLinks().get("self");
        if (string == null) {
            throw new Exception("Unable to determine version id for resource " + atomEntry.getId());
        }
        String string2 = this.getLogicalId(atomEntry);
        if (!string.contains("/" + string2 + "/_history/")) {
            throw new Exception("Unable to determine version id for resource " + atomEntry.getId() + " (self = " + string + ")");
        }
        String string3 = string.substring(string.lastIndexOf("/" + string2 + "/_history/") + ("/" + string2 + "/_history/").length());
        if (FormatUtilities.isValidId(string3)) {
            return string3;
        }
        throw new Exception("Unable to determine version id for resource " + atomEntry.getId() + " (self = " + string + ")");
    }
}

