/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.List;
import org.hl7.fhir.instance.model.Base64BinaryType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;

public class Attachment
extends Type {
    protected CodeType contentType;
    protected CodeType language;
    protected Base64BinaryType data;
    protected UriType url;
    protected IntegerType size;
    protected Base64BinaryType hash;
    protected StringType title;
    private static final long serialVersionUID = 483430116L;

    public Attachment() {
    }

    public Attachment(CodeType codeType) {
        this.contentType = codeType;
    }

    public CodeType getContentType() {
        return this.contentType;
    }

    public Attachment setContentType(CodeType codeType) {
        this.contentType = codeType;
        return this;
    }

    public String getContentTypeSimple() {
        return this.contentType == null ? null : this.contentType.getValue();
    }

    public Attachment setContentTypeSimple(String string) {
        if (this.contentType == null) {
            this.contentType = new CodeType();
        }
        this.contentType.setValue(string);
        return this;
    }

    public CodeType getLanguage() {
        return this.language;
    }

    public Attachment setLanguage(CodeType codeType) {
        this.language = codeType;
        return this;
    }

    public String getLanguageSimple() {
        return this.language == null ? null : this.language.getValue();
    }

    public Attachment setLanguageSimple(String string) {
        if (string == null) {
            this.language = null;
        } else {
            if (this.language == null) {
                this.language = new CodeType();
            }
            this.language.setValue(string);
        }
        return this;
    }

    public Base64BinaryType getData() {
        return this.data;
    }

    public Attachment setData(Base64BinaryType base64BinaryType) {
        this.data = base64BinaryType;
        return this;
    }

    public byte[] getDataSimple() {
        return this.data == null ? null : this.data.getValue();
    }

    public Attachment setDataSimple(byte[] byArray) {
        if (byArray == null) {
            this.data = null;
        } else {
            if (this.data == null) {
                this.data = new Base64BinaryType();
            }
            this.data.setValue(byArray);
        }
        return this;
    }

    public UriType getUrl() {
        return this.url;
    }

    public Attachment setUrl(UriType uriType) {
        this.url = uriType;
        return this;
    }

    public String getUrlSimple() {
        return this.url == null ? null : this.url.getValue();
    }

    public Attachment setUrlSimple(String string) {
        if (string == null) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(string);
        }
        return this;
    }

    public IntegerType getSize() {
        return this.size;
    }

    public Attachment setSize(IntegerType integerType) {
        this.size = integerType;
        return this;
    }

    public int getSizeSimple() {
        return this.size == null ? null : Integer.valueOf(this.size.getValue());
    }

    public Attachment setSizeSimple(int n) {
        if (n == -1) {
            this.size = null;
        } else {
            if (this.size == null) {
                this.size = new IntegerType();
            }
            this.size.setValue(n);
        }
        return this;
    }

    public Base64BinaryType getHash() {
        return this.hash;
    }

    public Attachment setHash(Base64BinaryType base64BinaryType) {
        this.hash = base64BinaryType;
        return this;
    }

    public byte[] getHashSimple() {
        return this.hash == null ? null : this.hash.getValue();
    }

    public Attachment setHashSimple(byte[] byArray) {
        if (byArray == null) {
            this.hash = null;
        } else {
            if (this.hash == null) {
                this.hash = new Base64BinaryType();
            }
            this.hash.setValue(byArray);
        }
        return this;
    }

    public StringType getTitle() {
        return this.title;
    }

    public Attachment setTitle(StringType stringType) {
        this.title = stringType;
        return this;
    }

    public String getTitleSimple() {
        return this.title == null ? null : this.title.getValue();
    }

    public Attachment setTitleSimple(String string) {
        if (string == null) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(string);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("contentType", "code", "Identifies the type of the data in the attachment and allows a method to be chosen to interpret or render the data. Includes mime type parameters such as charset where appropriate.", 0, Integer.MAX_VALUE, this.contentType));
        list.add(new Property("language", "code", "The human language of the content. The value can be any valid value according to BCP 47.", 0, Integer.MAX_VALUE, this.language));
        list.add(new Property("data", "base64Binary", "The actual data of the attachment - a sequence of bytes. In XML, represented using base64.", 0, Integer.MAX_VALUE, this.data));
        list.add(new Property("url", "uri", "An alternative location where the data can be accessed.", 0, Integer.MAX_VALUE, this.url));
        list.add(new Property("size", "integer", "The number of bytes of data that make up this attachment.", 0, Integer.MAX_VALUE, this.size));
        list.add(new Property("hash", "base64Binary", "The calculated hash of the data using SHA-1. Represented using base64.", 0, Integer.MAX_VALUE, this.hash));
        list.add(new Property("title", "string", "A label or set of text to display in place of the data.", 0, Integer.MAX_VALUE, this.title));
    }

    @Override
    public Attachment copy() {
        Attachment attachment = new Attachment();
        attachment.contentType = this.contentType == null ? null : this.contentType.copy();
        attachment.language = this.language == null ? null : this.language.copy();
        attachment.data = this.data == null ? null : this.data.copy();
        attachment.url = this.url == null ? null : this.url.copy();
        attachment.size = this.size == null ? null : this.size.copy();
        attachment.hash = this.hash == null ? null : this.hash.copy();
        attachment.title = this.title == null ? null : this.title.copy();
        return attachment;
    }

    @Override
    protected Attachment typedCopy() {
        return this.copy();
    }
}

