/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.Extension;
import org.hl7.fhir.instance.model.Property;

public abstract class BackboneElement
extends Element {
    private List<Extension> modifierExtensions = new ArrayList<Extension>();

    public List<Extension> getModifierExtensions() {
        return this.modifierExtensions;
    }

    @Override
    public boolean hasExtensions() {
        return this.modifierExtensions.size() > 0 || super.hasExtensions();
    }

    @Override
    public boolean hasExtension(String string) {
        if (string == null) {
            return false;
        }
        for (Extension extension : this.modifierExtensions) {
            if (!string.equals(extension.getUrlSimple())) continue;
            return true;
        }
        return super.hasExtension(string);
    }

    @Override
    public Extension getExtension(String string) {
        if (string == null) {
            return null;
        }
        for (Extension extension : this.modifierExtensions) {
            if (!string.equals(extension.getUrlSimple())) continue;
            return extension;
        }
        return super.getExtension(string);
    }

    public boolean hasModifierExtensions() {
        return this.modifierExtensions.size() > 0;
    }

    public boolean hasModifierExtension(String string) {
        if (string == null) {
            return false;
        }
        for (Extension extension : this.modifierExtensions) {
            if (!string.equals(extension.getUrlSimple())) continue;
            return true;
        }
        return false;
    }

    public Extension getModifierExtension(String string) {
        if (string == null) {
            return null;
        }
        for (Extension extension : this.modifierExtensions) {
            if (!string.equals(extension.getUrlSimple())) continue;
            return extension;
        }
        return null;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("modifierExtension", "Extension", "XML Identifier - target for an id ref", 0, Integer.MAX_VALUE, this.modifierExtensions));
    }
}

