/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Condition;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Location;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;

public class CarePlan
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected ResourceReference patient;
    protected Patient patientTarget;
    protected Enumeration<CarePlanStatus> status;
    protected Period period;
    protected DateTimeType modified;
    protected List<ResourceReference> concern = new ArrayList<ResourceReference>();
    protected List<Condition> concernTarget = new ArrayList<Condition>();
    protected List<CarePlanParticipantComponent> participant = new ArrayList<CarePlanParticipantComponent>();
    protected List<CarePlanGoalComponent> goal = new ArrayList<CarePlanGoalComponent>();
    protected List<CarePlanActivityComponent> activity = new ArrayList<CarePlanActivityComponent>();
    protected StringType notes;
    private static final long serialVersionUID = 1455393599L;

    public CarePlan() {
    }

    public CarePlan(Enumeration<CarePlanStatus> enumeration) {
        this.status = enumeration;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public ResourceReference getPatient() {
        return this.patient;
    }

    public CarePlan setPatient(ResourceReference resourceReference) {
        this.patient = resourceReference;
        return this;
    }

    public Patient getPatientTarget() {
        return this.patientTarget;
    }

    public CarePlan setPatientTarget(Patient patient) {
        this.patientTarget = patient;
        return this;
    }

    public Enumeration<CarePlanStatus> getStatus() {
        return this.status;
    }

    public CarePlan setStatus(Enumeration<CarePlanStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public CarePlanStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public CarePlan setStatusSimple(CarePlanStatus carePlanStatus) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(carePlanStatus);
        return this;
    }

    public Period getPeriod() {
        return this.period;
    }

    public CarePlan setPeriod(Period period) {
        this.period = period;
        return this;
    }

    public DateTimeType getModified() {
        return this.modified;
    }

    public CarePlan setModified(DateTimeType dateTimeType) {
        this.modified = dateTimeType;
        return this;
    }

    public DateAndTime getModifiedSimple() {
        return this.modified == null ? null : this.modified.getValue();
    }

    public CarePlan setModifiedSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.modified = null;
        } else {
            if (this.modified == null) {
                this.modified = new DateTimeType();
            }
            this.modified.setValue(dateAndTime);
        }
        return this;
    }

    public List<ResourceReference> getConcern() {
        return this.concern;
    }

    public ResourceReference addConcern() {
        ResourceReference resourceReference = new ResourceReference();
        this.concern.add(resourceReference);
        return resourceReference;
    }

    public List<Condition> getConcernTarget() {
        return this.concernTarget;
    }

    public Condition addConcernTarget() {
        Condition condition = new Condition();
        this.concernTarget.add(condition);
        return condition;
    }

    public List<CarePlanParticipantComponent> getParticipant() {
        return this.participant;
    }

    public CarePlanParticipantComponent addParticipant() {
        CarePlanParticipantComponent carePlanParticipantComponent = new CarePlanParticipantComponent();
        this.participant.add(carePlanParticipantComponent);
        return carePlanParticipantComponent;
    }

    public List<CarePlanGoalComponent> getGoal() {
        return this.goal;
    }

    public CarePlanGoalComponent addGoal() {
        CarePlanGoalComponent carePlanGoalComponent = new CarePlanGoalComponent();
        this.goal.add(carePlanGoalComponent);
        return carePlanGoalComponent;
    }

    public List<CarePlanActivityComponent> getActivity() {
        return this.activity;
    }

    public CarePlanActivityComponent addActivity() {
        CarePlanActivityComponent carePlanActivityComponent = new CarePlanActivityComponent();
        this.activity.add(carePlanActivityComponent);
        return carePlanActivityComponent;
    }

    public StringType getNotes() {
        return this.notes;
    }

    public CarePlan setNotes(StringType stringType) {
        this.notes = stringType;
        return this;
    }

    public String getNotesSimple() {
        return this.notes == null ? null : this.notes.getValue();
    }

    public CarePlan setNotesSimple(String string) {
        if (string == null) {
            this.notes = null;
        } else {
            if (this.notes == null) {
                this.notes = new StringType();
            }
            this.notes.setValue(string);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "This records identifiers associated with this care plan that are defined by business processed and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("patient", "Resource(Patient)", "Identifies the patient/subject whose intended care is described by the plan.", 0, Integer.MAX_VALUE, this.patient));
        list.add(new Property("status", "code", "Indicates whether the plan is currently being acted upon, represents future intentions or is now just historical record.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("period", "Period", "Indicates when the plan did (or is intended to) come into effect and end.", 0, Integer.MAX_VALUE, this.period));
        list.add(new Property("modified", "dateTime", "Identifies the most recent date on which the plan has been revised.", 0, Integer.MAX_VALUE, this.modified));
        list.add(new Property("concern", "Resource(Condition)", "Identifies the conditions/problems/concerns/diagnoses/etc. whose management and/or mitigation are handled by this plan.", 0, Integer.MAX_VALUE, this.concern));
        list.add(new Property("participant", "", "Identifies all people and organizations who are expected to be involved in the care envisioned by this plan.", 0, Integer.MAX_VALUE, this.participant));
        list.add(new Property("goal", "", "Describes the intended objective(s) of carrying out the Care Plan.", 0, Integer.MAX_VALUE, this.goal));
        list.add(new Property("activity", "", "Identifies a planned action to occur as part of the plan.  For example, a medication to be used, lab tests to perform, self-monitoring, education, etc.", 0, Integer.MAX_VALUE, this.activity));
        list.add(new Property("notes", "string", "General notes about the care plan not covered elsewhere.", 0, Integer.MAX_VALUE, this.notes));
    }

    public CarePlan copy() {
        CarePlan carePlan = new CarePlan();
        carePlan.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            carePlan.identifier.add(element.copy());
        }
        carePlan.patient = this.patient == null ? null : this.patient.copy();
        carePlan.status = this.status == null ? null : this.status.copy();
        carePlan.period = this.period == null ? null : this.period.copy();
        carePlan.modified = this.modified == null ? null : this.modified.copy();
        carePlan.concern = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.concern) {
            carePlan.concern.add(resourceReference.copy());
        }
        carePlan.participant = new ArrayList<CarePlanParticipantComponent>();
        for (CarePlanParticipantComponent carePlanParticipantComponent : this.participant) {
            carePlan.participant.add(carePlanParticipantComponent.copy());
        }
        carePlan.goal = new ArrayList<CarePlanGoalComponent>();
        for (CarePlanGoalComponent carePlanGoalComponent : this.goal) {
            carePlan.goal.add(carePlanGoalComponent.copy());
        }
        carePlan.activity = new ArrayList<CarePlanActivityComponent>();
        for (CarePlanActivityComponent carePlanActivityComponent : this.activity) {
            carePlan.activity.add(carePlanActivityComponent.copy());
        }
        carePlan.notes = this.notes == null ? null : this.notes.copy();
        return carePlan;
    }

    protected CarePlan typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CarePlan;
    }

    public static class CarePlanActivitySimpleComponent
    extends BackboneElement {
        protected Enumeration<CarePlanActivityCategory> category;
        protected CodeableConcept code;
        protected Type timing;
        protected ResourceReference location;
        protected Location locationTarget;
        protected List<ResourceReference> performer = new ArrayList<ResourceReference>();
        protected List<Resource> performerTarget = new ArrayList<Resource>();
        protected ResourceReference product;
        protected Resource productTarget;
        protected Quantity dailyAmount;
        protected Quantity quantity;
        protected StringType details;
        private static final long serialVersionUID = -403342401L;

        public CarePlanActivitySimpleComponent() {
        }

        public CarePlanActivitySimpleComponent(Enumeration<CarePlanActivityCategory> enumeration) {
            this.category = enumeration;
        }

        public Enumeration<CarePlanActivityCategory> getCategory() {
            return this.category;
        }

        public CarePlanActivitySimpleComponent setCategory(Enumeration<CarePlanActivityCategory> enumeration) {
            this.category = enumeration;
            return this;
        }

        public CarePlanActivityCategory getCategorySimple() {
            return this.category == null ? null : this.category.getValue();
        }

        public CarePlanActivitySimpleComponent setCategorySimple(CarePlanActivityCategory carePlanActivityCategory) {
            if (this.category == null) {
                this.category = new Enumeration();
            }
            this.category.setValue(carePlanActivityCategory);
            return this;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public CarePlanActivitySimpleComponent setCode(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
            return this;
        }

        public Type getTiming() {
            return this.timing;
        }

        public CarePlanActivitySimpleComponent setTiming(Type type) {
            this.timing = type;
            return this;
        }

        public ResourceReference getLocation() {
            return this.location;
        }

        public CarePlanActivitySimpleComponent setLocation(ResourceReference resourceReference) {
            this.location = resourceReference;
            return this;
        }

        public Location getLocationTarget() {
            return this.locationTarget;
        }

        public CarePlanActivitySimpleComponent setLocationTarget(Location location) {
            this.locationTarget = location;
            return this;
        }

        public List<ResourceReference> getPerformer() {
            return this.performer;
        }

        public ResourceReference addPerformer() {
            ResourceReference resourceReference = new ResourceReference();
            this.performer.add(resourceReference);
            return resourceReference;
        }

        public List<Resource> getPerformerTarget() {
            return this.performerTarget;
        }

        public ResourceReference getProduct() {
            return this.product;
        }

        public CarePlanActivitySimpleComponent setProduct(ResourceReference resourceReference) {
            this.product = resourceReference;
            return this;
        }

        public Resource getProductTarget() {
            return this.productTarget;
        }

        public CarePlanActivitySimpleComponent setProductTarget(Resource resource) {
            this.productTarget = resource;
            return this;
        }

        public Quantity getDailyAmount() {
            return this.dailyAmount;
        }

        public CarePlanActivitySimpleComponent setDailyAmount(Quantity quantity) {
            this.dailyAmount = quantity;
            return this;
        }

        public Quantity getQuantity() {
            return this.quantity;
        }

        public CarePlanActivitySimpleComponent setQuantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public StringType getDetails() {
            return this.details;
        }

        public CarePlanActivitySimpleComponent setDetails(StringType stringType) {
            this.details = stringType;
            return this;
        }

        public String getDetailsSimple() {
            return this.details == null ? null : this.details.getValue();
        }

        public CarePlanActivitySimpleComponent setDetailsSimple(String string) {
            if (string == null) {
                this.details = null;
            } else {
                if (this.details == null) {
                    this.details = new StringType();
                }
                this.details.setValue(string);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("category", "code", "High-level categorization of the type of activity in a care plan.", 0, Integer.MAX_VALUE, this.category));
            list.add(new Property("code", "CodeableConcept", "Detailed description of the type of activity.  E.g. What lab test, what procedure, what kind of encounter.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("timing[x]", "Schedule|Period|string", "The period, timing or frequency upon which the described activity is to occur.", 0, Integer.MAX_VALUE, this.timing));
            list.add(new Property("location", "Resource(Location)", "Identifies the facility where the activity will occur.  E.g. home, hospital, specific clinic, etc.", 0, Integer.MAX_VALUE, this.location));
            list.add(new Property("performer", "Resource(Practitioner|Organization|RelatedPerson|Patient)", "Identifies who's expected to be involved in the activity.", 0, Integer.MAX_VALUE, this.performer));
            list.add(new Property("product", "Resource(Medication|Substance)", "Identifies the food, drug or other product being consumed or supplied in the activity.", 0, Integer.MAX_VALUE, this.product));
            list.add(new Property("dailyAmount", "Quantity", "Identifies the quantity expected to be consumed in a given day.", 0, Integer.MAX_VALUE, this.dailyAmount));
            list.add(new Property("quantity", "Quantity", "Identifies the quantity expected to be supplied.", 0, Integer.MAX_VALUE, this.quantity));
            list.add(new Property("details", "string", "This provides a textual description of constraints on the activity occurrence, including relation to other activities.  It may also include objectives, pre-conditions and end-conditions.  Finally, it may convey specifics about the activity such as body site, method, route, etc.", 0, Integer.MAX_VALUE, this.details));
        }

        public CarePlanActivitySimpleComponent copy() {
            CarePlanActivitySimpleComponent carePlanActivitySimpleComponent = new CarePlanActivitySimpleComponent();
            carePlanActivitySimpleComponent.category = this.category == null ? null : this.category.copy();
            carePlanActivitySimpleComponent.code = this.code == null ? null : this.code.copy();
            carePlanActivitySimpleComponent.timing = this.timing == null ? null : this.timing.copy();
            carePlanActivitySimpleComponent.location = this.location == null ? null : this.location.copy();
            carePlanActivitySimpleComponent.performer = new ArrayList<ResourceReference>();
            for (ResourceReference resourceReference : this.performer) {
                carePlanActivitySimpleComponent.performer.add(resourceReference.copy());
            }
            carePlanActivitySimpleComponent.product = this.product == null ? null : this.product.copy();
            carePlanActivitySimpleComponent.dailyAmount = this.dailyAmount == null ? null : this.dailyAmount.copy();
            carePlanActivitySimpleComponent.quantity = this.quantity == null ? null : this.quantity.copy();
            carePlanActivitySimpleComponent.details = this.details == null ? null : this.details.copy();
            return carePlanActivitySimpleComponent;
        }
    }

    public static class CarePlanActivityComponent
    extends BackboneElement {
        protected List<StringType> goal = new ArrayList<StringType>();
        protected Enumeration<CarePlanActivityStatus> status;
        protected BooleanType prohibited;
        protected List<ResourceReference> actionResulting = new ArrayList<ResourceReference>();
        protected List<Resource> actionResultingTarget = new ArrayList<Resource>();
        protected StringType notes;
        protected ResourceReference detail;
        protected Resource detailTarget;
        protected CarePlanActivitySimpleComponent simple;
        private static final long serialVersionUID = -2114558145L;

        public CarePlanActivityComponent() {
        }

        public CarePlanActivityComponent(BooleanType booleanType) {
            this.prohibited = booleanType;
        }

        public List<StringType> getGoal() {
            return this.goal;
        }

        public StringType addGoal() {
            StringType stringType = new StringType();
            this.goal.add(stringType);
            return stringType;
        }

        public StringType addGoalSimple(String string) {
            StringType stringType = new StringType();
            stringType.setValue(string);
            this.goal.add(stringType);
            return stringType;
        }

        public boolean hasGoalSimple(String string) {
            for (StringType stringType : this.goal) {
                if (!stringType.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }

        public Enumeration<CarePlanActivityStatus> getStatus() {
            return this.status;
        }

        public CarePlanActivityComponent setStatus(Enumeration<CarePlanActivityStatus> enumeration) {
            this.status = enumeration;
            return this;
        }

        public CarePlanActivityStatus getStatusSimple() {
            return this.status == null ? null : this.status.getValue();
        }

        public CarePlanActivityComponent setStatusSimple(CarePlanActivityStatus carePlanActivityStatus) {
            if (carePlanActivityStatus == null) {
                this.status = null;
            } else {
                if (this.status == null) {
                    this.status = new Enumeration();
                }
                this.status.setValue(carePlanActivityStatus);
            }
            return this;
        }

        public BooleanType getProhibited() {
            return this.prohibited;
        }

        public CarePlanActivityComponent setProhibited(BooleanType booleanType) {
            this.prohibited = booleanType;
            return this;
        }

        public boolean getProhibitedSimple() {
            return this.prohibited == null ? false : this.prohibited.getValue();
        }

        public CarePlanActivityComponent setProhibitedSimple(boolean bl) {
            if (this.prohibited == null) {
                this.prohibited = new BooleanType();
            }
            this.prohibited.setValue(bl);
            return this;
        }

        public List<ResourceReference> getActionResulting() {
            return this.actionResulting;
        }

        public ResourceReference addActionResulting() {
            ResourceReference resourceReference = new ResourceReference();
            this.actionResulting.add(resourceReference);
            return resourceReference;
        }

        public List<Resource> getActionResultingTarget() {
            return this.actionResultingTarget;
        }

        public StringType getNotes() {
            return this.notes;
        }

        public CarePlanActivityComponent setNotes(StringType stringType) {
            this.notes = stringType;
            return this;
        }

        public String getNotesSimple() {
            return this.notes == null ? null : this.notes.getValue();
        }

        public CarePlanActivityComponent setNotesSimple(String string) {
            if (string == null) {
                this.notes = null;
            } else {
                if (this.notes == null) {
                    this.notes = new StringType();
                }
                this.notes.setValue(string);
            }
            return this;
        }

        public ResourceReference getDetail() {
            return this.detail;
        }

        public CarePlanActivityComponent setDetail(ResourceReference resourceReference) {
            this.detail = resourceReference;
            return this;
        }

        public Resource getDetailTarget() {
            return this.detailTarget;
        }

        public CarePlanActivityComponent setDetailTarget(Resource resource) {
            this.detailTarget = resource;
            return this;
        }

        public CarePlanActivitySimpleComponent getSimple() {
            return this.simple;
        }

        public CarePlanActivityComponent setSimple(CarePlanActivitySimpleComponent carePlanActivitySimpleComponent) {
            this.simple = carePlanActivitySimpleComponent;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("goal", "idref", "Internal reference that identifies the goals that this activity is intended to contribute towards meeting.", 0, Integer.MAX_VALUE, this.goal));
            list.add(new Property("status", "code", "Identifies what progress is being made for the specific activity.", 0, Integer.MAX_VALUE, this.status));
            list.add(new Property("prohibited", "boolean", "If true, indicates that the described activity is one that must NOT be engaged in when following the plan.", 0, Integer.MAX_VALUE, this.prohibited));
            list.add(new Property("actionResulting", "Resource(Any)", "Resources that describe follow-on actions resulting from the plan, such as drug prescriptions, encounter records, appointments, etc.", 0, Integer.MAX_VALUE, this.actionResulting));
            list.add(new Property("notes", "string", "Notes about the execution of the activity.", 0, Integer.MAX_VALUE, this.notes));
            list.add(new Property("detail", "Resource(Procedure|MedicationPrescription|DiagnosticOrder|Encounter)", "The details of the proposed activity represented in a specific resource.", 0, Integer.MAX_VALUE, this.detail));
            list.add(new Property("simple", "", "A simple summary of details suitable for a general care plan system (e.g. form driven) that doesn't know about specific resources such as procedure etc.", 0, Integer.MAX_VALUE, this.simple));
        }

        public CarePlanActivityComponent copy() {
            CarePlanActivityComponent carePlanActivityComponent = new CarePlanActivityComponent();
            carePlanActivityComponent.goal = new ArrayList<StringType>();
            for (StringType type : this.goal) {
                carePlanActivityComponent.goal.add(type.copy());
            }
            carePlanActivityComponent.status = this.status == null ? null : this.status.copy();
            carePlanActivityComponent.prohibited = this.prohibited == null ? null : this.prohibited.copy();
            carePlanActivityComponent.actionResulting = new ArrayList<ResourceReference>();
            for (ResourceReference resourceReference : this.actionResulting) {
                carePlanActivityComponent.actionResulting.add(resourceReference.copy());
            }
            carePlanActivityComponent.notes = this.notes == null ? null : this.notes.copy();
            carePlanActivityComponent.detail = this.detail == null ? null : this.detail.copy();
            carePlanActivityComponent.simple = this.simple == null ? null : this.simple.copy();
            return carePlanActivityComponent;
        }
    }

    public static class CarePlanGoalComponent
    extends BackboneElement {
        protected StringType description;
        protected Enumeration<CarePlanGoalStatus> status;
        protected StringType notes;
        protected List<ResourceReference> concern = new ArrayList<ResourceReference>();
        protected List<Condition> concernTarget = new ArrayList<Condition>();
        private static final long serialVersionUID = -483526324L;

        public CarePlanGoalComponent() {
        }

        public CarePlanGoalComponent(StringType stringType) {
            this.description = stringType;
        }

        public StringType getDescription() {
            return this.description;
        }

        public CarePlanGoalComponent setDescription(StringType stringType) {
            this.description = stringType;
            return this;
        }

        public String getDescriptionSimple() {
            return this.description == null ? null : this.description.getValue();
        }

        public CarePlanGoalComponent setDescriptionSimple(String string) {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(string);
            return this;
        }

        public Enumeration<CarePlanGoalStatus> getStatus() {
            return this.status;
        }

        public CarePlanGoalComponent setStatus(Enumeration<CarePlanGoalStatus> enumeration) {
            this.status = enumeration;
            return this;
        }

        public CarePlanGoalStatus getStatusSimple() {
            return this.status == null ? null : this.status.getValue();
        }

        public CarePlanGoalComponent setStatusSimple(CarePlanGoalStatus carePlanGoalStatus) {
            if (carePlanGoalStatus == null) {
                this.status = null;
            } else {
                if (this.status == null) {
                    this.status = new Enumeration();
                }
                this.status.setValue(carePlanGoalStatus);
            }
            return this;
        }

        public StringType getNotes() {
            return this.notes;
        }

        public CarePlanGoalComponent setNotes(StringType stringType) {
            this.notes = stringType;
            return this;
        }

        public String getNotesSimple() {
            return this.notes == null ? null : this.notes.getValue();
        }

        public CarePlanGoalComponent setNotesSimple(String string) {
            if (string == null) {
                this.notes = null;
            } else {
                if (this.notes == null) {
                    this.notes = new StringType();
                }
                this.notes.setValue(string);
            }
            return this;
        }

        public List<ResourceReference> getConcern() {
            return this.concern;
        }

        public ResourceReference addConcern() {
            ResourceReference resourceReference = new ResourceReference();
            this.concern.add(resourceReference);
            return resourceReference;
        }

        public List<Condition> getConcernTarget() {
            return this.concernTarget;
        }

        public Condition addConcernTarget() {
            Condition condition = new Condition();
            this.concernTarget.add(condition);
            return condition;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("description", "string", "Human-readable description of a specific desired objective of the care plan.", 0, Integer.MAX_VALUE, this.description));
            list.add(new Property("status", "code", "Indicates whether the goal has been reached and is still considered relevant.", 0, Integer.MAX_VALUE, this.status));
            list.add(new Property("notes", "string", "Any comments related to the goal.", 0, Integer.MAX_VALUE, this.notes));
            list.add(new Property("concern", "Resource(Condition)", "The identified conditions that this goal relates to - the condition that caused it to be created, or that it is intended to address.", 0, Integer.MAX_VALUE, this.concern));
        }

        public CarePlanGoalComponent copy() {
            CarePlanGoalComponent carePlanGoalComponent = new CarePlanGoalComponent();
            carePlanGoalComponent.description = this.description == null ? null : this.description.copy();
            carePlanGoalComponent.status = this.status == null ? null : this.status.copy();
            carePlanGoalComponent.notes = this.notes == null ? null : this.notes.copy();
            carePlanGoalComponent.concern = new ArrayList<ResourceReference>();
            for (ResourceReference resourceReference : this.concern) {
                carePlanGoalComponent.concern.add(resourceReference.copy());
            }
            return carePlanGoalComponent;
        }
    }

    public static class CarePlanParticipantComponent
    extends BackboneElement {
        protected CodeableConcept role;
        protected ResourceReference member;
        protected Resource memberTarget;
        private static final long serialVersionUID = -1745583963L;

        public CarePlanParticipantComponent() {
        }

        public CarePlanParticipantComponent(ResourceReference resourceReference) {
            this.member = resourceReference;
        }

        public CodeableConcept getRole() {
            return this.role;
        }

        public CarePlanParticipantComponent setRole(CodeableConcept codeableConcept) {
            this.role = codeableConcept;
            return this;
        }

        public ResourceReference getMember() {
            return this.member;
        }

        public CarePlanParticipantComponent setMember(ResourceReference resourceReference) {
            this.member = resourceReference;
            return this;
        }

        public Resource getMemberTarget() {
            return this.memberTarget;
        }

        public CarePlanParticipantComponent setMemberTarget(Resource resource) {
            this.memberTarget = resource;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("role", "CodeableConcept", "Indicates specific responsibility of an individual within the care plan.  E.g. 'Primary physician', 'Team coordinator', 'Caregiver', etc.", 0, Integer.MAX_VALUE, this.role));
            list.add(new Property("member", "Resource(Practitioner|RelatedPerson|Patient|Organization)", "The specific person or organization who is participating/expected to participate in the care plan.", 0, Integer.MAX_VALUE, this.member));
        }

        public CarePlanParticipantComponent copy() {
            CarePlanParticipantComponent carePlanParticipantComponent = new CarePlanParticipantComponent();
            carePlanParticipantComponent.role = this.role == null ? null : this.role.copy();
            carePlanParticipantComponent.member = this.member == null ? null : this.member.copy();
            return carePlanParticipantComponent;
        }
    }

    public static class CarePlanActivityCategoryEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("diet".equals(string)) {
                return CarePlanActivityCategory.diet;
            }
            if ("drug".equals(string)) {
                return CarePlanActivityCategory.drug;
            }
            if ("encounter".equals(string)) {
                return CarePlanActivityCategory.encounter;
            }
            if ("observation".equals(string)) {
                return CarePlanActivityCategory.observation;
            }
            if ("procedure".equals(string)) {
                return CarePlanActivityCategory.procedure;
            }
            if ("supply".equals(string)) {
                return CarePlanActivityCategory.supply;
            }
            if ("other".equals(string)) {
                return CarePlanActivityCategory.other;
            }
            throw new Exception("Unknown CarePlanActivityCategory code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == CarePlanActivityCategory.diet) {
                return "diet";
            }
            if (enum_ == CarePlanActivityCategory.drug) {
                return "drug";
            }
            if (enum_ == CarePlanActivityCategory.encounter) {
                return "encounter";
            }
            if (enum_ == CarePlanActivityCategory.observation) {
                return "observation";
            }
            if (enum_ == CarePlanActivityCategory.procedure) {
                return "procedure";
            }
            if (enum_ == CarePlanActivityCategory.supply) {
                return "supply";
            }
            if (enum_ == CarePlanActivityCategory.other) {
                return "other";
            }
            return "?";
        }
    }

    public static enum CarePlanActivityCategory {
        diet,
        drug,
        encounter,
        observation,
        procedure,
        supply,
        other,
        Null;


        public static CarePlanActivityCategory fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("diet".equals(string)) {
                return diet;
            }
            if ("drug".equals(string)) {
                return drug;
            }
            if ("encounter".equals(string)) {
                return encounter;
            }
            if ("observation".equals(string)) {
                return observation;
            }
            if ("procedure".equals(string)) {
                return procedure;
            }
            if ("supply".equals(string)) {
                return supply;
            }
            if ("other".equals(string)) {
                return other;
            }
            throw new Exception("Unknown CarePlanActivityCategory code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case diet: {
                    return "diet";
                }
                case drug: {
                    return "drug";
                }
                case encounter: {
                    return "encounter";
                }
                case observation: {
                    return "observation";
                }
                case procedure: {
                    return "procedure";
                }
                case supply: {
                    return "supply";
                }
                case other: {
                    return "other";
                }
            }
            return "?";
        }
    }

    public static class CarePlanActivityStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("not started".equals(string)) {
                return CarePlanActivityStatus.notStarted;
            }
            if ("scheduled".equals(string)) {
                return CarePlanActivityStatus.scheduled;
            }
            if ("in progress".equals(string)) {
                return CarePlanActivityStatus.inProgress;
            }
            if ("on hold".equals(string)) {
                return CarePlanActivityStatus.onHold;
            }
            if ("completed".equals(string)) {
                return CarePlanActivityStatus.completed;
            }
            if ("cancelled".equals(string)) {
                return CarePlanActivityStatus.cancelled;
            }
            throw new Exception("Unknown CarePlanActivityStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == CarePlanActivityStatus.notStarted) {
                return "not started";
            }
            if (enum_ == CarePlanActivityStatus.scheduled) {
                return "scheduled";
            }
            if (enum_ == CarePlanActivityStatus.inProgress) {
                return "in progress";
            }
            if (enum_ == CarePlanActivityStatus.onHold) {
                return "on hold";
            }
            if (enum_ == CarePlanActivityStatus.completed) {
                return "completed";
            }
            if (enum_ == CarePlanActivityStatus.cancelled) {
                return "cancelled";
            }
            return "?";
        }
    }

    public static enum CarePlanActivityStatus {
        notStarted,
        scheduled,
        inProgress,
        onHold,
        completed,
        cancelled,
        Null;


        public static CarePlanActivityStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("not started".equals(string)) {
                return notStarted;
            }
            if ("scheduled".equals(string)) {
                return scheduled;
            }
            if ("in progress".equals(string)) {
                return inProgress;
            }
            if ("on hold".equals(string)) {
                return onHold;
            }
            if ("completed".equals(string)) {
                return completed;
            }
            if ("cancelled".equals(string)) {
                return cancelled;
            }
            throw new Exception("Unknown CarePlanActivityStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case notStarted: {
                    return "not started";
                }
                case scheduled: {
                    return "scheduled";
                }
                case inProgress: {
                    return "in progress";
                }
                case onHold: {
                    return "on hold";
                }
                case completed: {
                    return "completed";
                }
                case cancelled: {
                    return "cancelled";
                }
            }
            return "?";
        }
    }

    public static class CarePlanGoalStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("in progress".equals(string)) {
                return CarePlanGoalStatus.inProgress;
            }
            if ("achieved".equals(string)) {
                return CarePlanGoalStatus.achieved;
            }
            if ("sustaining".equals(string)) {
                return CarePlanGoalStatus.sustaining;
            }
            if ("cancelled".equals(string)) {
                return CarePlanGoalStatus.cancelled;
            }
            throw new Exception("Unknown CarePlanGoalStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == CarePlanGoalStatus.inProgress) {
                return "in progress";
            }
            if (enum_ == CarePlanGoalStatus.achieved) {
                return "achieved";
            }
            if (enum_ == CarePlanGoalStatus.sustaining) {
                return "sustaining";
            }
            if (enum_ == CarePlanGoalStatus.cancelled) {
                return "cancelled";
            }
            return "?";
        }
    }

    public static enum CarePlanGoalStatus {
        inProgress,
        achieved,
        sustaining,
        cancelled,
        Null;


        public static CarePlanGoalStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("in progress".equals(string)) {
                return inProgress;
            }
            if ("achieved".equals(string)) {
                return achieved;
            }
            if ("sustaining".equals(string)) {
                return sustaining;
            }
            if ("cancelled".equals(string)) {
                return cancelled;
            }
            throw new Exception("Unknown CarePlanGoalStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case inProgress: {
                    return "in progress";
                }
                case achieved: {
                    return "achieved";
                }
                case sustaining: {
                    return "sustaining";
                }
                case cancelled: {
                    return "cancelled";
                }
            }
            return "?";
        }
    }

    public static class CarePlanStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("planned".equals(string)) {
                return CarePlanStatus.planned;
            }
            if ("active".equals(string)) {
                return CarePlanStatus.active;
            }
            if ("completed".equals(string)) {
                return CarePlanStatus.completed;
            }
            throw new Exception("Unknown CarePlanStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == CarePlanStatus.planned) {
                return "planned";
            }
            if (enum_ == CarePlanStatus.active) {
                return "active";
            }
            if (enum_ == CarePlanStatus.completed) {
                return "completed";
            }
            return "?";
        }
    }

    public static enum CarePlanStatus {
        planned,
        active,
        completed,
        Null;


        public static CarePlanStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("planned".equals(string)) {
                return planned;
            }
            if ("active".equals(string)) {
                return active;
            }
            if ("completed".equals(string)) {
                return completed;
            }
            throw new Exception("Unknown CarePlanStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case planned: {
                    return "planned";
                }
                case active: {
                    return "active";
                }
                case completed: {
                    return "completed";
                }
            }
            return "?";
        }
    }
}

