/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;

public class CodeableConcept
extends Type {
    protected List<Coding> coding = new ArrayList<Coding>();
    protected StringType text;
    private static final long serialVersionUID = -642628655L;

    public List<Coding> getCoding() {
        return this.coding;
    }

    public Coding addCoding() {
        Coding coding = new Coding();
        this.coding.add(coding);
        return coding;
    }

    public StringType getText() {
        return this.text;
    }

    public CodeableConcept setText(StringType stringType) {
        this.text = stringType;
        return this;
    }

    public String getTextSimple() {
        return this.text == null ? null : this.text.getValue();
    }

    public CodeableConcept setTextSimple(String string) {
        if (string == null) {
            this.text = null;
        } else {
            if (this.text == null) {
                this.text = new StringType();
            }
            this.text.setValue(string);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("coding", "Coding", "A reference to a code defined by a terminology system.", 0, Integer.MAX_VALUE, this.coding));
        list.add(new Property("text", "string", "A human language representation of the concept as seen/selected/uttered by the user who entered the data and/or which represents the intended meaning of the user.", 0, Integer.MAX_VALUE, this.text));
    }

    @Override
    public CodeableConcept copy() {
        CodeableConcept codeableConcept = new CodeableConcept();
        codeableConcept.coding = new ArrayList<Coding>();
        for (Coding coding : this.coding) {
            codeableConcept.coding.add(coding.copy());
        }
        codeableConcept.text = this.text == null ? null : this.text.copy();
        return codeableConcept;
    }

    @Override
    protected CodeableConcept typedCopy() {
        return this.copy();
    }
}

