/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.List;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.ValueSet;

public class Coding
extends Type {
    protected UriType system;
    protected StringType version;
    protected CodeType code;
    protected StringType display;
    protected BooleanType primary;
    protected ResourceReference valueSet;
    protected ValueSet valueSetTarget;
    private static final long serialVersionUID = -2106166442L;

    public UriType getSystem() {
        return this.system;
    }

    public Coding setSystem(UriType uriType) {
        this.system = uriType;
        return this;
    }

    public String getSystemSimple() {
        return this.system == null ? null : this.system.getValue();
    }

    public Coding setSystemSimple(String string) {
        if (string == null) {
            this.system = null;
        } else {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(string);
        }
        return this;
    }

    public StringType getVersion() {
        return this.version;
    }

    public Coding setVersion(StringType stringType) {
        this.version = stringType;
        return this;
    }

    public String getVersionSimple() {
        return this.version == null ? null : this.version.getValue();
    }

    public Coding setVersionSimple(String string) {
        if (string == null) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(string);
        }
        return this;
    }

    public CodeType getCode() {
        return this.code;
    }

    public Coding setCode(CodeType codeType) {
        this.code = codeType;
        return this;
    }

    public String getCodeSimple() {
        return this.code == null ? null : this.code.getValue();
    }

    public Coding setCodeSimple(String string) {
        if (string == null) {
            this.code = null;
        } else {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(string);
        }
        return this;
    }

    public StringType getDisplay() {
        return this.display;
    }

    public Coding setDisplay(StringType stringType) {
        this.display = stringType;
        return this;
    }

    public String getDisplaySimple() {
        return this.display == null ? null : this.display.getValue();
    }

    public Coding setDisplaySimple(String string) {
        if (string == null) {
            this.display = null;
        } else {
            if (this.display == null) {
                this.display = new StringType();
            }
            this.display.setValue(string);
        }
        return this;
    }

    public BooleanType getPrimary() {
        return this.primary;
    }

    public Coding setPrimary(BooleanType booleanType) {
        this.primary = booleanType;
        return this;
    }

    public boolean getPrimarySimple() {
        return this.primary == null ? false : this.primary.getValue();
    }

    public Coding setPrimarySimple(boolean bl) {
        if (!bl) {
            this.primary = null;
        } else {
            if (this.primary == null) {
                this.primary = new BooleanType();
            }
            this.primary.setValue(bl);
        }
        return this;
    }

    public ResourceReference getValueSet() {
        return this.valueSet;
    }

    public Coding setValueSet(ResourceReference resourceReference) {
        this.valueSet = resourceReference;
        return this;
    }

    public ValueSet getValueSetTarget() {
        return this.valueSetTarget;
    }

    public Coding setValueSetTarget(ValueSet valueSet) {
        this.valueSetTarget = valueSet;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("system", "uri", "The identification of the code system that defines the meaning of the symbol in the code.", 0, Integer.MAX_VALUE, this.system));
        list.add(new Property("version", "string", "The version of the code system which was used when choosing this code. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured. and When the meaning is not guaranteed to be consistent, the version SHOULD be exchanged.", 0, Integer.MAX_VALUE, this.version));
        list.add(new Property("code", "code", "A symbol in syntax defined by the system. The symbol may be a predefined code or an expression in a syntax defined by the coding system (e.g. post-coordination).", 0, Integer.MAX_VALUE, this.code));
        list.add(new Property("display", "string", "A representation of the meaning of the code in the system, following the rules of the system.", 0, Integer.MAX_VALUE, this.display));
        list.add(new Property("primary", "boolean", "Indicates that this code was chosen by a user directly - i.e. off a pick list of available items (codes or displays).", 0, Integer.MAX_VALUE, this.primary));
        list.add(new Property("valueSet", "Resource(ValueSet)", "The set of possible coded values this coding was chosen from or constrained by.", 0, Integer.MAX_VALUE, this.valueSet));
    }

    @Override
    public Coding copy() {
        Coding coding = new Coding();
        coding.system = this.system == null ? null : this.system.copy();
        coding.version = this.version == null ? null : this.version.copy();
        coding.code = this.code == null ? null : this.code.copy();
        coding.display = this.display == null ? null : this.display.copy();
        coding.primary = this.primary == null ? null : this.primary.copy();
        coding.valueSet = this.valueSet == null ? null : this.valueSet.copy();
        return coding;
    }

    @Override
    protected Coding typedCopy() {
        return this.copy();
    }
}

