/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.Encounter;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;

public class Composition
extends Resource {
    protected Identifier identifier;
    protected DateTimeType date;
    protected CodeableConcept type;
    protected CodeableConcept class_;
    protected StringType title;
    protected Enumeration<CompositionStatus> status;
    protected Coding confidentiality;
    protected ResourceReference subject;
    protected Resource subjectTarget;
    protected List<ResourceReference> author = new ArrayList<ResourceReference>();
    protected List<Resource> authorTarget = new ArrayList<Resource>();
    protected List<CompositionAttesterComponent> attester = new ArrayList<CompositionAttesterComponent>();
    protected ResourceReference custodian;
    protected Organization custodianTarget;
    protected CompositionEventComponent event;
    protected ResourceReference encounter;
    protected Encounter encounterTarget;
    protected List<SectionComponent> section = new ArrayList<SectionComponent>();
    private static final long serialVersionUID = 665135617L;

    public Composition() {
    }

    public Composition(DateTimeType dateTimeType, CodeableConcept codeableConcept, Enumeration<CompositionStatus> enumeration, Coding coding, ResourceReference resourceReference) {
        this.date = dateTimeType;
        this.type = codeableConcept;
        this.status = enumeration;
        this.confidentiality = coding;
        this.subject = resourceReference;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Composition setIdentifier(Identifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public DateTimeType getDate() {
        return this.date;
    }

    public Composition setDate(DateTimeType dateTimeType) {
        this.date = dateTimeType;
        return this;
    }

    public DateAndTime getDateSimple() {
        return this.date == null ? null : this.date.getValue();
    }

    public Composition setDateSimple(DateAndTime dateAndTime) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(dateAndTime);
        return this;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Composition setType(CodeableConcept codeableConcept) {
        this.type = codeableConcept;
        return this;
    }

    public CodeableConcept getClass_() {
        return this.class_;
    }

    public Composition setClass_(CodeableConcept codeableConcept) {
        this.class_ = codeableConcept;
        return this;
    }

    public StringType getTitle() {
        return this.title;
    }

    public Composition setTitle(StringType stringType) {
        this.title = stringType;
        return this;
    }

    public String getTitleSimple() {
        return this.title == null ? null : this.title.getValue();
    }

    public Composition setTitleSimple(String string) {
        if (string == null) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(string);
        }
        return this;
    }

    public Enumeration<CompositionStatus> getStatus() {
        return this.status;
    }

    public Composition setStatus(Enumeration<CompositionStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public CompositionStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public Composition setStatusSimple(CompositionStatus compositionStatus) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(compositionStatus);
        return this;
    }

    public Coding getConfidentiality() {
        return this.confidentiality;
    }

    public Composition setConfidentiality(Coding coding) {
        this.confidentiality = coding;
        return this;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public Composition setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Composition setSubjectTarget(Resource resource) {
        this.subjectTarget = resource;
        return this;
    }

    public List<ResourceReference> getAuthor() {
        return this.author;
    }

    public ResourceReference addAuthor() {
        ResourceReference resourceReference = new ResourceReference();
        this.author.add(resourceReference);
        return resourceReference;
    }

    public List<Resource> getAuthorTarget() {
        return this.authorTarget;
    }

    public List<CompositionAttesterComponent> getAttester() {
        return this.attester;
    }

    public CompositionAttesterComponent addAttester() {
        CompositionAttesterComponent compositionAttesterComponent = new CompositionAttesterComponent();
        this.attester.add(compositionAttesterComponent);
        return compositionAttesterComponent;
    }

    public ResourceReference getCustodian() {
        return this.custodian;
    }

    public Composition setCustodian(ResourceReference resourceReference) {
        this.custodian = resourceReference;
        return this;
    }

    public Organization getCustodianTarget() {
        return this.custodianTarget;
    }

    public Composition setCustodianTarget(Organization organization) {
        this.custodianTarget = organization;
        return this;
    }

    public CompositionEventComponent getEvent() {
        return this.event;
    }

    public Composition setEvent(CompositionEventComponent compositionEventComponent) {
        this.event = compositionEventComponent;
        return this;
    }

    public ResourceReference getEncounter() {
        return this.encounter;
    }

    public Composition setEncounter(ResourceReference resourceReference) {
        this.encounter = resourceReference;
        return this;
    }

    public Encounter getEncounterTarget() {
        return this.encounterTarget;
    }

    public Composition setEncounterTarget(Encounter encounter) {
        this.encounterTarget = encounter;
        return this;
    }

    public List<SectionComponent> getSection() {
        return this.section;
    }

    public SectionComponent addSection() {
        SectionComponent sectionComponent = new SectionComponent();
        this.section.add(sectionComponent);
        return sectionComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "Logical Identifier for the composition, assigned when created. This identifier stays constant as the composition is changed over time.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("date", "dateTime", "The composition editing time, when the composition was last logically changed by the author.", 0, Integer.MAX_VALUE, this.date));
        list.add(new Property("type", "CodeableConcept", "Specifies the particular kind of composition (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the composition.", 0, Integer.MAX_VALUE, this.type));
        list.add(new Property("class", "CodeableConcept", "A categorization for the type of the composition. This may be implied by or derived from the code specified in the Composition Type.", 0, Integer.MAX_VALUE, this.class_));
        list.add(new Property("title", "string", "Official human-readable label for the composition.", 0, Integer.MAX_VALUE, this.title));
        list.add(new Property("status", "code", "The workflow/clinical status of this composition. The status is a marker for the clinical standing of the document.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("confidentiality", "Coding", "The code specifying the level of confidentiality of the Composition.", 0, Integer.MAX_VALUE, this.confidentiality));
        list.add(new Property("subject", "Resource(Patient|Practitioner|Group|Device|Location)", "Who or what the composition is about. The composition can be about a person, (patient or healthcare practitioner), a device (I.e. machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("author", "Resource(Practitioner|Device|Patient|RelatedPerson)", "Identifies who is responsible for the information in the composition.  (Not necessarily who typed it in.).", 0, Integer.MAX_VALUE, this.author));
        list.add(new Property("attester", "", "A participant who has attested to the accuracy of the composition/document.", 0, Integer.MAX_VALUE, this.attester));
        list.add(new Property("custodian", "Resource(Organization)", "Identifies the organization or group who is responsible for ongoing maintenance of and access to the composition/document information.", 0, Integer.MAX_VALUE, this.custodian));
        list.add(new Property("event", "", "The main event/act/item, such as a colonoscopy or an appendectomy, being documented.", 0, Integer.MAX_VALUE, this.event));
        list.add(new Property("encounter", "Resource(Encounter)", "Describes the clinical encounter or type of care this documentation is associated with.", 0, Integer.MAX_VALUE, this.encounter));
        list.add(new Property("section", "", "The root of the sections that make up the composition.", 0, Integer.MAX_VALUE, this.section));
    }

    public Composition copy() {
        Composition composition = new Composition();
        composition.identifier = this.identifier == null ? null : this.identifier.copy();
        composition.date = this.date == null ? null : this.date.copy();
        composition.type = this.type == null ? null : this.type.copy();
        composition.class_ = this.class_ == null ? null : this.class_.copy();
        composition.title = this.title == null ? null : this.title.copy();
        composition.status = this.status == null ? null : this.status.copy();
        composition.confidentiality = this.confidentiality == null ? null : this.confidentiality.copy();
        composition.subject = this.subject == null ? null : this.subject.copy();
        composition.author = new ArrayList<ResourceReference>();
        for (ResourceReference element : this.author) {
            composition.author.add(element.copy());
        }
        composition.attester = new ArrayList<CompositionAttesterComponent>();
        for (CompositionAttesterComponent compositionAttesterComponent : this.attester) {
            composition.attester.add(compositionAttesterComponent.copy());
        }
        composition.custodian = this.custodian == null ? null : this.custodian.copy();
        composition.event = this.event == null ? null : this.event.copy();
        composition.encounter = this.encounter == null ? null : this.encounter.copy();
        composition.section = new ArrayList<SectionComponent>();
        for (SectionComponent sectionComponent : this.section) {
            composition.section.add(sectionComponent.copy());
        }
        return composition;
    }

    protected Composition typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Composition;
    }

    public static class SectionComponent
    extends BackboneElement {
        protected StringType title;
        protected CodeableConcept code;
        protected ResourceReference subject;
        protected Resource subjectTarget;
        protected ResourceReference content;
        protected Resource contentTarget;
        protected List<SectionComponent> section = new ArrayList<SectionComponent>();
        private static final long serialVersionUID = -904255741L;

        public StringType getTitle() {
            return this.title;
        }

        public SectionComponent setTitle(StringType stringType) {
            this.title = stringType;
            return this;
        }

        public String getTitleSimple() {
            return this.title == null ? null : this.title.getValue();
        }

        public SectionComponent setTitleSimple(String string) {
            if (string == null) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(string);
            }
            return this;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public SectionComponent setCode(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
            return this;
        }

        public ResourceReference getSubject() {
            return this.subject;
        }

        public SectionComponent setSubject(ResourceReference resourceReference) {
            this.subject = resourceReference;
            return this;
        }

        public Resource getSubjectTarget() {
            return this.subjectTarget;
        }

        public SectionComponent setSubjectTarget(Resource resource) {
            this.subjectTarget = resource;
            return this;
        }

        public ResourceReference getContent() {
            return this.content;
        }

        public SectionComponent setContent(ResourceReference resourceReference) {
            this.content = resourceReference;
            return this;
        }

        public Resource getContentTarget() {
            return this.contentTarget;
        }

        public SectionComponent setContentTarget(Resource resource) {
            this.contentTarget = resource;
            return this;
        }

        public List<SectionComponent> getSection() {
            return this.section;
        }

        public SectionComponent addSection() {
            SectionComponent sectionComponent = new SectionComponent();
            this.section.add(sectionComponent);
            return sectionComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("title", "string", "The heading for this particular section.  This will be part of the rendered content for the document.", 0, Integer.MAX_VALUE, this.title));
            list.add(new Property("code", "CodeableConcept", "A code identifying the kind of content contained within the section.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("subject", "Resource(Patient|Group|Device)", "Identifies the primary subject of the section.", 0, Integer.MAX_VALUE, this.subject));
            list.add(new Property("content", "Resource(Any)", "Identifies the discrete data that provides the content for the section.", 0, Integer.MAX_VALUE, this.content));
            list.add(new Property("section", "@Composition.section", "A nested sub-section within this section.", 0, Integer.MAX_VALUE, this.section));
        }

        public SectionComponent copy() {
            SectionComponent sectionComponent = new SectionComponent();
            sectionComponent.title = this.title == null ? null : this.title.copy();
            sectionComponent.code = this.code == null ? null : this.code.copy();
            sectionComponent.subject = this.subject == null ? null : this.subject.copy();
            sectionComponent.content = this.content == null ? null : this.content.copy();
            sectionComponent.section = new ArrayList<SectionComponent>();
            for (SectionComponent sectionComponent2 : this.section) {
                sectionComponent.section.add(sectionComponent2.copy());
            }
            return sectionComponent;
        }
    }

    public static class CompositionEventComponent
    extends BackboneElement {
        protected List<CodeableConcept> code = new ArrayList<CodeableConcept>();
        protected Period period;
        protected List<ResourceReference> detail = new ArrayList<ResourceReference>();
        protected List<Resource> detailTarget = new ArrayList<Resource>();
        private static final long serialVersionUID = -1713925885L;

        public List<CodeableConcept> getCode() {
            return this.code;
        }

        public CodeableConcept addCode() {
            CodeableConcept codeableConcept = new CodeableConcept();
            this.code.add(codeableConcept);
            return codeableConcept;
        }

        public Period getPeriod() {
            return this.period;
        }

        public CompositionEventComponent setPeriod(Period period) {
            this.period = period;
            return this;
        }

        public List<ResourceReference> getDetail() {
            return this.detail;
        }

        public ResourceReference addDetail() {
            ResourceReference resourceReference = new ResourceReference();
            this.detail.add(resourceReference);
            return resourceReference;
        }

        public List<Resource> getDetailTarget() {
            return this.detailTarget;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "CodeableConcept", "This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the typeCode, such as a 'History and Physical Report' in which the procedure being documented is necessarily a 'History and Physical' act.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("period", "Period", "The period of time covered by the documentation. There is no assertion that the documentation is a complete representation for this period, only that it documents events during this time.", 0, Integer.MAX_VALUE, this.period));
            list.add(new Property("detail", "Resource(Any)", "Full details for the event(s) the composition/documentation consents.", 0, Integer.MAX_VALUE, this.detail));
        }

        public CompositionEventComponent copy() {
            CompositionEventComponent compositionEventComponent = new CompositionEventComponent();
            compositionEventComponent.code = new ArrayList<CodeableConcept>();
            for (CodeableConcept type : this.code) {
                compositionEventComponent.code.add(type.copy());
            }
            compositionEventComponent.period = this.period == null ? null : this.period.copy();
            compositionEventComponent.detail = new ArrayList<ResourceReference>();
            for (ResourceReference resourceReference : this.detail) {
                compositionEventComponent.detail.add(resourceReference.copy());
            }
            return compositionEventComponent;
        }
    }

    public static class CompositionAttesterComponent
    extends BackboneElement {
        protected List<Enumeration<CompositionAttestationMode>> mode = new ArrayList<Enumeration<CompositionAttestationMode>>();
        protected DateTimeType time;
        protected ResourceReference party;
        protected Resource partyTarget;
        private static final long serialVersionUID = 2056316894L;

        public List<Enumeration<CompositionAttestationMode>> getMode() {
            return this.mode;
        }

        public Enumeration<CompositionAttestationMode> addMode() {
            Enumeration<CompositionAttestationMode> enumeration = new Enumeration<CompositionAttestationMode>();
            this.mode.add(enumeration);
            return enumeration;
        }

        public Enumeration<CompositionAttestationMode> addModeSimple(CompositionAttestationMode compositionAttestationMode) {
            Enumeration<CompositionAttestationMode> enumeration = new Enumeration<CompositionAttestationMode>();
            enumeration.setValue(compositionAttestationMode);
            this.mode.add(enumeration);
            return enumeration;
        }

        public boolean hasModeSimple(CompositionAttestationMode compositionAttestationMode) {
            for (Enumeration<CompositionAttestationMode> enumeration : this.mode) {
                if (!enumeration.getValue().equals((Object)compositionAttestationMode)) continue;
                return true;
            }
            return false;
        }

        public DateTimeType getTime() {
            return this.time;
        }

        public CompositionAttesterComponent setTime(DateTimeType dateTimeType) {
            this.time = dateTimeType;
            return this;
        }

        public DateAndTime getTimeSimple() {
            return this.time == null ? null : this.time.getValue();
        }

        public CompositionAttesterComponent setTimeSimple(DateAndTime dateAndTime) {
            if (dateAndTime == null) {
                this.time = null;
            } else {
                if (this.time == null) {
                    this.time = new DateTimeType();
                }
                this.time.setValue(dateAndTime);
            }
            return this;
        }

        public ResourceReference getParty() {
            return this.party;
        }

        public CompositionAttesterComponent setParty(ResourceReference resourceReference) {
            this.party = resourceReference;
            return this;
        }

        public Resource getPartyTarget() {
            return this.partyTarget;
        }

        public CompositionAttesterComponent setPartyTarget(Resource resource) {
            this.partyTarget = resource;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("mode", "code", "The type of attestation the authenticator offers.", 0, Integer.MAX_VALUE, this.mode));
            list.add(new Property("time", "dateTime", "When composition was attested by the party.", 0, Integer.MAX_VALUE, this.time));
            list.add(new Property("party", "Resource(Patient|Practitioner|Organization)", "Who attested the composition in the specified way.", 0, Integer.MAX_VALUE, this.party));
        }

        public CompositionAttesterComponent copy() {
            CompositionAttesterComponent compositionAttesterComponent = new CompositionAttesterComponent();
            compositionAttesterComponent.mode = new ArrayList<Enumeration<CompositionAttestationMode>>();
            for (Enumeration<CompositionAttestationMode> enumeration : this.mode) {
                compositionAttesterComponent.mode.add((Enumeration<CompositionAttestationMode>)enumeration.copy());
            }
            compositionAttesterComponent.time = this.time == null ? null : this.time.copy();
            compositionAttesterComponent.party = this.party == null ? null : this.party.copy();
            return compositionAttesterComponent;
        }
    }

    public static class CompositionAttestationModeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("personal".equals(string)) {
                return CompositionAttestationMode.personal;
            }
            if ("professional".equals(string)) {
                return CompositionAttestationMode.professional;
            }
            if ("legal".equals(string)) {
                return CompositionAttestationMode.legal;
            }
            if ("official".equals(string)) {
                return CompositionAttestationMode.official;
            }
            throw new Exception("Unknown CompositionAttestationMode code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == CompositionAttestationMode.personal) {
                return "personal";
            }
            if (enum_ == CompositionAttestationMode.professional) {
                return "professional";
            }
            if (enum_ == CompositionAttestationMode.legal) {
                return "legal";
            }
            if (enum_ == CompositionAttestationMode.official) {
                return "official";
            }
            return "?";
        }
    }

    public static enum CompositionAttestationMode {
        personal,
        professional,
        legal,
        official,
        Null;


        public static CompositionAttestationMode fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("personal".equals(string)) {
                return personal;
            }
            if ("professional".equals(string)) {
                return professional;
            }
            if ("legal".equals(string)) {
                return legal;
            }
            if ("official".equals(string)) {
                return official;
            }
            throw new Exception("Unknown CompositionAttestationMode code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case personal: {
                    return "personal";
                }
                case professional: {
                    return "professional";
                }
                case legal: {
                    return "legal";
                }
                case official: {
                    return "official";
                }
            }
            return "?";
        }
    }

    public static class CompositionStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("preliminary".equals(string)) {
                return CompositionStatus.preliminary;
            }
            if ("final".equals(string)) {
                return CompositionStatus.final_;
            }
            if ("appended".equals(string)) {
                return CompositionStatus.appended;
            }
            if ("amended".equals(string)) {
                return CompositionStatus.amended;
            }
            if ("entered in error".equals(string)) {
                return CompositionStatus.enteredInError;
            }
            throw new Exception("Unknown CompositionStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == CompositionStatus.preliminary) {
                return "preliminary";
            }
            if (enum_ == CompositionStatus.final_) {
                return "final";
            }
            if (enum_ == CompositionStatus.appended) {
                return "appended";
            }
            if (enum_ == CompositionStatus.amended) {
                return "amended";
            }
            if (enum_ == CompositionStatus.enteredInError) {
                return "entered in error";
            }
            return "?";
        }
    }

    public static enum CompositionStatus {
        preliminary,
        final_,
        appended,
        amended,
        enteredInError,
        Null;


        public static CompositionStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("preliminary".equals(string)) {
                return preliminary;
            }
            if ("final".equals(string)) {
                return final_;
            }
            if ("appended".equals(string)) {
                return appended;
            }
            if ("amended".equals(string)) {
                return amended;
            }
            if ("entered in error".equals(string)) {
                return enteredInError;
            }
            throw new Exception("Unknown CompositionStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case preliminary: {
                    return "preliminary";
                }
                case final_: {
                    return "final";
                }
                case appended: {
                    return "appended";
                }
                case amended: {
                    return "amended";
                }
                case enteredInError: {
                    return "entered in error";
                }
            }
            return "?";
        }
    }
}

