/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.ValueSet;

public class ConceptMap
extends Resource {
    protected StringType identifier;
    protected StringType version;
    protected StringType name;
    protected StringType publisher;
    protected List<Contact> telecom = new ArrayList<Contact>();
    protected StringType description;
    protected StringType copyright;
    protected Enumeration<ValuesetStatus> status;
    protected BooleanType experimental;
    protected DateTimeType date;
    protected ResourceReference source;
    protected ValueSet sourceTarget;
    protected ResourceReference target;
    protected ValueSet targetTarget;
    protected List<ConceptMapConceptComponent> concept = new ArrayList<ConceptMapConceptComponent>();
    private static final long serialVersionUID = 1257205861L;

    public ConceptMap() {
    }

    public ConceptMap(StringType stringType, Enumeration<ValuesetStatus> enumeration, ResourceReference resourceReference, ResourceReference resourceReference2) {
        this.name = stringType;
        this.status = enumeration;
        this.source = resourceReference;
        this.target = resourceReference2;
    }

    public StringType getIdentifier() {
        return this.identifier;
    }

    public ConceptMap setIdentifier(StringType stringType) {
        this.identifier = stringType;
        return this;
    }

    public String getIdentifierSimple() {
        return this.identifier == null ? null : this.identifier.getValue();
    }

    public ConceptMap setIdentifierSimple(String string) {
        if (string == null) {
            this.identifier = null;
        } else {
            if (this.identifier == null) {
                this.identifier = new StringType();
            }
            this.identifier.setValue(string);
        }
        return this;
    }

    public StringType getVersion() {
        return this.version;
    }

    public ConceptMap setVersion(StringType stringType) {
        this.version = stringType;
        return this;
    }

    public String getVersionSimple() {
        return this.version == null ? null : this.version.getValue();
    }

    public ConceptMap setVersionSimple(String string) {
        if (string == null) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(string);
        }
        return this;
    }

    public StringType getName() {
        return this.name;
    }

    public ConceptMap setName(StringType stringType) {
        this.name = stringType;
        return this;
    }

    public String getNameSimple() {
        return this.name == null ? null : this.name.getValue();
    }

    public ConceptMap setNameSimple(String string) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(string);
        return this;
    }

    public StringType getPublisher() {
        return this.publisher;
    }

    public ConceptMap setPublisher(StringType stringType) {
        this.publisher = stringType;
        return this;
    }

    public String getPublisherSimple() {
        return this.publisher == null ? null : this.publisher.getValue();
    }

    public ConceptMap setPublisherSimple(String string) {
        if (string == null) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(string);
        }
        return this;
    }

    public List<Contact> getTelecom() {
        return this.telecom;
    }

    public Contact addTelecom() {
        Contact contact = new Contact();
        this.telecom.add(contact);
        return contact;
    }

    public StringType getDescription() {
        return this.description;
    }

    public ConceptMap setDescription(StringType stringType) {
        this.description = stringType;
        return this;
    }

    public String getDescriptionSimple() {
        return this.description == null ? null : this.description.getValue();
    }

    public ConceptMap setDescriptionSimple(String string) {
        if (string == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(string);
        }
        return this;
    }

    public StringType getCopyright() {
        return this.copyright;
    }

    public ConceptMap setCopyright(StringType stringType) {
        this.copyright = stringType;
        return this;
    }

    public String getCopyrightSimple() {
        return this.copyright == null ? null : this.copyright.getValue();
    }

    public ConceptMap setCopyrightSimple(String string) {
        if (string == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new StringType();
            }
            this.copyright.setValue(string);
        }
        return this;
    }

    public Enumeration<ValuesetStatus> getStatus() {
        return this.status;
    }

    public ConceptMap setStatus(Enumeration<ValuesetStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public ValuesetStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public ConceptMap setStatusSimple(ValuesetStatus valuesetStatus) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(valuesetStatus);
        return this;
    }

    public BooleanType getExperimental() {
        return this.experimental;
    }

    public ConceptMap setExperimental(BooleanType booleanType) {
        this.experimental = booleanType;
        return this;
    }

    public boolean getExperimentalSimple() {
        return this.experimental == null ? false : this.experimental.getValue();
    }

    public ConceptMap setExperimentalSimple(boolean bl) {
        if (!bl) {
            this.experimental = null;
        } else {
            if (this.experimental == null) {
                this.experimental = new BooleanType();
            }
            this.experimental.setValue(bl);
        }
        return this;
    }

    public DateTimeType getDate() {
        return this.date;
    }

    public ConceptMap setDate(DateTimeType dateTimeType) {
        this.date = dateTimeType;
        return this;
    }

    public DateAndTime getDateSimple() {
        return this.date == null ? null : this.date.getValue();
    }

    public ConceptMap setDateSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(dateAndTime);
        }
        return this;
    }

    public ResourceReference getSource() {
        return this.source;
    }

    public ConceptMap setSource(ResourceReference resourceReference) {
        this.source = resourceReference;
        return this;
    }

    public ValueSet getSourceTarget() {
        return this.sourceTarget;
    }

    public ConceptMap setSourceTarget(ValueSet valueSet) {
        this.sourceTarget = valueSet;
        return this;
    }

    public ResourceReference getTarget() {
        return this.target;
    }

    public ConceptMap setTarget(ResourceReference resourceReference) {
        this.target = resourceReference;
        return this;
    }

    public ValueSet getTargetTarget() {
        return this.targetTarget;
    }

    public ConceptMap setTargetTarget(ValueSet valueSet) {
        this.targetTarget = valueSet;
        return this;
    }

    public List<ConceptMapConceptComponent> getConcept() {
        return this.concept;
    }

    public ConceptMapConceptComponent addConcept() {
        ConceptMapConceptComponent conceptMapConceptComponent = new ConceptMapConceptComponent();
        this.concept.add(conceptMapConceptComponent);
        return conceptMapConceptComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "string", "The identifier that is used to identify this concept map when it is referenced in a specification, model, design or an instance (should be globally unique OID, UUID, or URI).", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("version", "string", "The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp.", 0, Integer.MAX_VALUE, this.version));
        list.add(new Property("name", "string", "A free text natural language name describing the concept map.", 0, Integer.MAX_VALUE, this.name));
        list.add(new Property("publisher", "string", "The name of the individual or organization that published the concept map.", 0, Integer.MAX_VALUE, this.publisher));
        list.add(new Property("telecom", "Contact", "Contacts of the publisher to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        list.add(new Property("description", "string", "A free text natural language description of the use of the concept map - reason for definition, conditions of use, etc.", 0, Integer.MAX_VALUE, this.description));
        list.add(new Property("copyright", "string", "A copyright statement relating to the concept map and/or its contents.", 0, Integer.MAX_VALUE, this.copyright));
        list.add(new Property("status", "code", "The status of the concept map.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("experimental", "boolean", "This ConceptMap was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        list.add(new Property("date", "dateTime", "The date that the concept map status was last changed.", 0, Integer.MAX_VALUE, this.date));
        list.add(new Property("source", "Resource(ValueSet)", "The source value set that specifies the concepts that are being mapped.", 0, Integer.MAX_VALUE, this.source));
        list.add(new Property("target", "Resource(ValueSet)", "The target value set provides context to the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, Integer.MAX_VALUE, this.target));
        list.add(new Property("concept", "", "Mappings for a concept from the source valueset.", 0, Integer.MAX_VALUE, this.concept));
    }

    public ConceptMap copy() {
        ConceptMap conceptMap = new ConceptMap();
        conceptMap.identifier = this.identifier == null ? null : this.identifier.copy();
        conceptMap.version = this.version == null ? null : this.version.copy();
        conceptMap.name = this.name == null ? null : this.name.copy();
        conceptMap.publisher = this.publisher == null ? null : this.publisher.copy();
        conceptMap.telecom = new ArrayList<Contact>();
        for (Contact element : this.telecom) {
            conceptMap.telecom.add(element.copy());
        }
        conceptMap.description = this.description == null ? null : this.description.copy();
        conceptMap.copyright = this.copyright == null ? null : this.copyright.copy();
        conceptMap.status = this.status == null ? null : this.status.copy();
        conceptMap.experimental = this.experimental == null ? null : this.experimental.copy();
        conceptMap.date = this.date == null ? null : this.date.copy();
        conceptMap.source = this.source == null ? null : this.source.copy();
        conceptMap.target = this.target == null ? null : this.target.copy();
        conceptMap.concept = new ArrayList<ConceptMapConceptComponent>();
        for (ConceptMapConceptComponent conceptMapConceptComponent : this.concept) {
            conceptMap.concept.add(conceptMapConceptComponent.copy());
        }
        return conceptMap;
    }

    protected ConceptMap typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ConceptMap;
    }

    public static class ConceptMapConceptMapComponent
    extends BackboneElement {
        protected UriType system;
        protected CodeType code;
        protected Enumeration<ConceptEquivalence> equivalence;
        protected StringType comments;
        protected List<OtherConceptComponent> product = new ArrayList<OtherConceptComponent>();
        private static final long serialVersionUID = -409087185L;

        public ConceptMapConceptMapComponent() {
        }

        public ConceptMapConceptMapComponent(Enumeration<ConceptEquivalence> enumeration) {
            this.equivalence = enumeration;
        }

        public UriType getSystem() {
            return this.system;
        }

        public ConceptMapConceptMapComponent setSystem(UriType uriType) {
            this.system = uriType;
            return this;
        }

        public String getSystemSimple() {
            return this.system == null ? null : this.system.getValue();
        }

        public ConceptMapConceptMapComponent setSystemSimple(String string) {
            if (string == null) {
                this.system = null;
            } else {
                if (this.system == null) {
                    this.system = new UriType();
                }
                this.system.setValue(string);
            }
            return this;
        }

        public CodeType getCode() {
            return this.code;
        }

        public ConceptMapConceptMapComponent setCode(CodeType codeType) {
            this.code = codeType;
            return this;
        }

        public String getCodeSimple() {
            return this.code == null ? null : this.code.getValue();
        }

        public ConceptMapConceptMapComponent setCodeSimple(String string) {
            if (string == null) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(string);
            }
            return this;
        }

        public Enumeration<ConceptEquivalence> getEquivalence() {
            return this.equivalence;
        }

        public ConceptMapConceptMapComponent setEquivalence(Enumeration<ConceptEquivalence> enumeration) {
            this.equivalence = enumeration;
            return this;
        }

        public ConceptEquivalence getEquivalenceSimple() {
            return this.equivalence == null ? null : this.equivalence.getValue();
        }

        public ConceptMapConceptMapComponent setEquivalenceSimple(ConceptEquivalence conceptEquivalence) {
            if (this.equivalence == null) {
                this.equivalence = new Enumeration();
            }
            this.equivalence.setValue(conceptEquivalence);
            return this;
        }

        public StringType getComments() {
            return this.comments;
        }

        public ConceptMapConceptMapComponent setComments(StringType stringType) {
            this.comments = stringType;
            return this;
        }

        public String getCommentsSimple() {
            return this.comments == null ? null : this.comments.getValue();
        }

        public ConceptMapConceptMapComponent setCommentsSimple(String string) {
            if (string == null) {
                this.comments = null;
            } else {
                if (this.comments == null) {
                    this.comments = new StringType();
                }
                this.comments.setValue(string);
            }
            return this;
        }

        public List<OtherConceptComponent> getProduct() {
            return this.product;
        }

        public OtherConceptComponent addProduct() {
            OtherConceptComponent otherConceptComponent = new OtherConceptComponent();
            this.product.add(otherConceptComponent);
            return otherConceptComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("system", "uri", "System of the target.", 0, Integer.MAX_VALUE, this.system));
            list.add(new Property("code", "code", "Code that identifies the target concept.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("equivalence", "code", "equal | equivalent | wider | subsumes | narrower | specialises | inexact | unmatched | disjoint.", 0, Integer.MAX_VALUE, this.equivalence));
            list.add(new Property("comments", "string", "Description of status/issues in mapping.", 0, Integer.MAX_VALUE, this.comments));
            list.add(new Property("product", "@ConceptMap.concept.dependsOn", "A set of additional outcomes from this mapping to other value sets. To properly execute this mapping, the specified value set must be mapped to some data element or source that is in context. The mapping may still be useful without a place for the additional data elements, but the equivalence cannot be relied on.", 0, Integer.MAX_VALUE, this.product));
        }

        public ConceptMapConceptMapComponent copy() {
            ConceptMapConceptMapComponent conceptMapConceptMapComponent = new ConceptMapConceptMapComponent();
            conceptMapConceptMapComponent.system = this.system == null ? null : this.system.copy();
            conceptMapConceptMapComponent.code = this.code == null ? null : this.code.copy();
            conceptMapConceptMapComponent.equivalence = this.equivalence == null ? null : this.equivalence.copy();
            conceptMapConceptMapComponent.comments = this.comments == null ? null : this.comments.copy();
            conceptMapConceptMapComponent.product = new ArrayList<OtherConceptComponent>();
            for (OtherConceptComponent otherConceptComponent : this.product) {
                conceptMapConceptMapComponent.product.add(otherConceptComponent.copy());
            }
            return conceptMapConceptMapComponent;
        }
    }

    public static class OtherConceptComponent
    extends BackboneElement {
        protected UriType concept;
        protected UriType system;
        protected CodeType code;
        private static final long serialVersionUID = -1863306043L;

        public OtherConceptComponent() {
        }

        public OtherConceptComponent(UriType uriType, UriType uriType2, CodeType codeType) {
            this.concept = uriType;
            this.system = uriType2;
            this.code = codeType;
        }

        public UriType getConcept() {
            return this.concept;
        }

        public OtherConceptComponent setConcept(UriType uriType) {
            this.concept = uriType;
            return this;
        }

        public String getConceptSimple() {
            return this.concept == null ? null : this.concept.getValue();
        }

        public OtherConceptComponent setConceptSimple(String string) {
            if (this.concept == null) {
                this.concept = new UriType();
            }
            this.concept.setValue(string);
            return this;
        }

        public UriType getSystem() {
            return this.system;
        }

        public OtherConceptComponent setSystem(UriType uriType) {
            this.system = uriType;
            return this;
        }

        public String getSystemSimple() {
            return this.system == null ? null : this.system.getValue();
        }

        public OtherConceptComponent setSystemSimple(String string) {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(string);
            return this;
        }

        public CodeType getCode() {
            return this.code;
        }

        public OtherConceptComponent setCode(CodeType codeType) {
            this.code = codeType;
            return this;
        }

        public String getCodeSimple() {
            return this.code == null ? null : this.code.getValue();
        }

        public OtherConceptComponent setCodeSimple(String string) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(string);
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("concept", "uri", "A reference to a specific concept that holds a coded value. This can be an element in a FHIR resource, or a specific reference to a data element in a different specification (e.g. v2) or a general reference to a kind of data field, or a reference to a value set with an appropriately narrow definition.", 0, Integer.MAX_VALUE, this.concept));
            list.add(new Property("system", "uri", "System for a concept in the referenced concept.", 0, Integer.MAX_VALUE, this.system));
            list.add(new Property("code", "code", "Code for a concept in the referenced concept.", 0, Integer.MAX_VALUE, this.code));
        }

        public OtherConceptComponent copy() {
            OtherConceptComponent otherConceptComponent = new OtherConceptComponent();
            otherConceptComponent.concept = this.concept == null ? null : this.concept.copy();
            otherConceptComponent.system = this.system == null ? null : this.system.copy();
            otherConceptComponent.code = this.code == null ? null : this.code.copy();
            return otherConceptComponent;
        }
    }

    public static class ConceptMapConceptComponent
    extends BackboneElement {
        protected UriType system;
        protected CodeType code;
        protected List<OtherConceptComponent> dependsOn = new ArrayList<OtherConceptComponent>();
        protected List<ConceptMapConceptMapComponent> map = new ArrayList<ConceptMapConceptMapComponent>();
        private static final long serialVersionUID = 448760663L;

        public ConceptMapConceptComponent() {
        }

        public ConceptMapConceptComponent(UriType uriType) {
            this.system = uriType;
        }

        public UriType getSystem() {
            return this.system;
        }

        public ConceptMapConceptComponent setSystem(UriType uriType) {
            this.system = uriType;
            return this;
        }

        public String getSystemSimple() {
            return this.system == null ? null : this.system.getValue();
        }

        public ConceptMapConceptComponent setSystemSimple(String string) {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(string);
            return this;
        }

        public CodeType getCode() {
            return this.code;
        }

        public ConceptMapConceptComponent setCode(CodeType codeType) {
            this.code = codeType;
            return this;
        }

        public String getCodeSimple() {
            return this.code == null ? null : this.code.getValue();
        }

        public ConceptMapConceptComponent setCodeSimple(String string) {
            if (string == null) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(string);
            }
            return this;
        }

        public List<OtherConceptComponent> getDependsOn() {
            return this.dependsOn;
        }

        public OtherConceptComponent addDependsOn() {
            OtherConceptComponent otherConceptComponent = new OtherConceptComponent();
            this.dependsOn.add(otherConceptComponent);
            return otherConceptComponent;
        }

        public List<ConceptMapConceptMapComponent> getMap() {
            return this.map;
        }

        public ConceptMapConceptMapComponent addMap() {
            ConceptMapConceptMapComponent conceptMapConceptMapComponent = new ConceptMapConceptMapComponent();
            this.map.add(conceptMapConceptMapComponent);
            return conceptMapConceptMapComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("system", "uri", "System that defines the concept being mapped.", 0, Integer.MAX_VALUE, this.system));
            list.add(new Property("code", "code", "Identifies concept being mapped.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("dependsOn", "", "A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified concept can be resolved, and it has the specified value.", 0, Integer.MAX_VALUE, this.dependsOn));
            list.add(new Property("map", "", "A concept from the target value set that this concept maps to.", 0, Integer.MAX_VALUE, this.map));
        }

        public ConceptMapConceptComponent copy() {
            ConceptMapConceptComponent conceptMapConceptComponent = new ConceptMapConceptComponent();
            conceptMapConceptComponent.system = this.system == null ? null : this.system.copy();
            conceptMapConceptComponent.code = this.code == null ? null : this.code.copy();
            conceptMapConceptComponent.dependsOn = new ArrayList<OtherConceptComponent>();
            for (OtherConceptComponent backboneElement : this.dependsOn) {
                conceptMapConceptComponent.dependsOn.add(backboneElement.copy());
            }
            conceptMapConceptComponent.map = new ArrayList<ConceptMapConceptMapComponent>();
            for (ConceptMapConceptMapComponent conceptMapConceptMapComponent : this.map) {
                conceptMapConceptComponent.map.add(conceptMapConceptMapComponent.copy());
            }
            return conceptMapConceptComponent;
        }
    }

    public static class ConceptEquivalenceEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("equal".equals(string)) {
                return ConceptEquivalence.equal;
            }
            if ("equivalent".equals(string)) {
                return ConceptEquivalence.equivalent;
            }
            if ("wider".equals(string)) {
                return ConceptEquivalence.wider;
            }
            if ("subsumes".equals(string)) {
                return ConceptEquivalence.subsumes;
            }
            if ("narrower".equals(string)) {
                return ConceptEquivalence.narrower;
            }
            if ("specialises".equals(string)) {
                return ConceptEquivalence.specialises;
            }
            if ("inexact".equals(string)) {
                return ConceptEquivalence.inexact;
            }
            if ("unmatched".equals(string)) {
                return ConceptEquivalence.unmatched;
            }
            if ("disjoint".equals(string)) {
                return ConceptEquivalence.disjoint;
            }
            throw new Exception("Unknown ConceptEquivalence code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ConceptEquivalence.equal) {
                return "equal";
            }
            if (enum_ == ConceptEquivalence.equivalent) {
                return "equivalent";
            }
            if (enum_ == ConceptEquivalence.wider) {
                return "wider";
            }
            if (enum_ == ConceptEquivalence.subsumes) {
                return "subsumes";
            }
            if (enum_ == ConceptEquivalence.narrower) {
                return "narrower";
            }
            if (enum_ == ConceptEquivalence.specialises) {
                return "specialises";
            }
            if (enum_ == ConceptEquivalence.inexact) {
                return "inexact";
            }
            if (enum_ == ConceptEquivalence.unmatched) {
                return "unmatched";
            }
            if (enum_ == ConceptEquivalence.disjoint) {
                return "disjoint";
            }
            return "?";
        }
    }

    public static enum ConceptEquivalence {
        equal,
        equivalent,
        wider,
        subsumes,
        narrower,
        specialises,
        inexact,
        unmatched,
        disjoint,
        Null;


        public static ConceptEquivalence fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("equal".equals(string)) {
                return equal;
            }
            if ("equivalent".equals(string)) {
                return equivalent;
            }
            if ("wider".equals(string)) {
                return wider;
            }
            if ("subsumes".equals(string)) {
                return subsumes;
            }
            if ("narrower".equals(string)) {
                return narrower;
            }
            if ("specialises".equals(string)) {
                return specialises;
            }
            if ("inexact".equals(string)) {
                return inexact;
            }
            if ("unmatched".equals(string)) {
                return unmatched;
            }
            if ("disjoint".equals(string)) {
                return disjoint;
            }
            throw new Exception("Unknown ConceptEquivalence code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case equal: {
                    return "equal";
                }
                case equivalent: {
                    return "equivalent";
                }
                case wider: {
                    return "wider";
                }
                case subsumes: {
                    return "subsumes";
                }
                case narrower: {
                    return "narrower";
                }
                case specialises: {
                    return "specialises";
                }
                case inexact: {
                    return "inexact";
                }
                case unmatched: {
                    return "unmatched";
                }
                case disjoint: {
                    return "disjoint";
                }
            }
            return "?";
        }
    }

    public static class ValuesetStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("draft".equals(string)) {
                return ValuesetStatus.draft;
            }
            if ("active".equals(string)) {
                return ValuesetStatus.active;
            }
            if ("retired".equals(string)) {
                return ValuesetStatus.retired;
            }
            throw new Exception("Unknown ValuesetStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ValuesetStatus.draft) {
                return "draft";
            }
            if (enum_ == ValuesetStatus.active) {
                return "active";
            }
            if (enum_ == ValuesetStatus.retired) {
                return "retired";
            }
            return "?";
        }
    }

    public static enum ValuesetStatus {
        draft,
        active,
        retired,
        Null;


        public static ValuesetStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("draft".equals(string)) {
                return draft;
            }
            if ("active".equals(string)) {
                return active;
            }
            if ("retired".equals(string)) {
                return retired;
            }
            throw new Exception("Unknown ValuesetStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case draft: {
                    return "draft";
                }
                case active: {
                    return "active";
                }
                case retired: {
                    return "retired";
                }
            }
            return "?";
        }
    }
}

