/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.Encounter;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;

public class Condition
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected ResourceReference subject;
    protected Patient subjectTarget;
    protected ResourceReference encounter;
    protected Encounter encounterTarget;
    protected ResourceReference asserter;
    protected Resource asserterTarget;
    protected DateType dateAsserted;
    protected CodeableConcept code;
    protected CodeableConcept category;
    protected Enumeration<ConditionStatus> status;
    protected CodeableConcept certainty;
    protected CodeableConcept severity;
    protected Type onset;
    protected Type abatement;
    protected ConditionStageComponent stage;
    protected List<ConditionEvidenceComponent> evidence = new ArrayList<ConditionEvidenceComponent>();
    protected List<ConditionLocationComponent> location = new ArrayList<ConditionLocationComponent>();
    protected List<ConditionRelatedItemComponent> relatedItem = new ArrayList<ConditionRelatedItemComponent>();
    protected StringType notes;
    private static final long serialVersionUID = 1246565689L;

    public Condition() {
    }

    public Condition(ResourceReference resourceReference, CodeableConcept codeableConcept, Enumeration<ConditionStatus> enumeration) {
        this.subject = resourceReference;
        this.code = codeableConcept;
        this.status = enumeration;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public Condition setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Patient getSubjectTarget() {
        return this.subjectTarget;
    }

    public Condition setSubjectTarget(Patient patient) {
        this.subjectTarget = patient;
        return this;
    }

    public ResourceReference getEncounter() {
        return this.encounter;
    }

    public Condition setEncounter(ResourceReference resourceReference) {
        this.encounter = resourceReference;
        return this;
    }

    public Encounter getEncounterTarget() {
        return this.encounterTarget;
    }

    public Condition setEncounterTarget(Encounter encounter) {
        this.encounterTarget = encounter;
        return this;
    }

    public ResourceReference getAsserter() {
        return this.asserter;
    }

    public Condition setAsserter(ResourceReference resourceReference) {
        this.asserter = resourceReference;
        return this;
    }

    public Resource getAsserterTarget() {
        return this.asserterTarget;
    }

    public Condition setAsserterTarget(Resource resource) {
        this.asserterTarget = resource;
        return this;
    }

    public DateType getDateAsserted() {
        return this.dateAsserted;
    }

    public Condition setDateAsserted(DateType dateType) {
        this.dateAsserted = dateType;
        return this;
    }

    public DateAndTime getDateAssertedSimple() {
        return this.dateAsserted == null ? null : this.dateAsserted.getValue();
    }

    public Condition setDateAssertedSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.dateAsserted = null;
        } else {
            if (this.dateAsserted == null) {
                this.dateAsserted = new DateType();
            }
            this.dateAsserted.setValue(dateAndTime);
        }
        return this;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public Condition setCode(CodeableConcept codeableConcept) {
        this.code = codeableConcept;
        return this;
    }

    public CodeableConcept getCategory() {
        return this.category;
    }

    public Condition setCategory(CodeableConcept codeableConcept) {
        this.category = codeableConcept;
        return this;
    }

    public Enumeration<ConditionStatus> getStatus() {
        return this.status;
    }

    public Condition setStatus(Enumeration<ConditionStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public ConditionStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public Condition setStatusSimple(ConditionStatus conditionStatus) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(conditionStatus);
        return this;
    }

    public CodeableConcept getCertainty() {
        return this.certainty;
    }

    public Condition setCertainty(CodeableConcept codeableConcept) {
        this.certainty = codeableConcept;
        return this;
    }

    public CodeableConcept getSeverity() {
        return this.severity;
    }

    public Condition setSeverity(CodeableConcept codeableConcept) {
        this.severity = codeableConcept;
        return this;
    }

    public Type getOnset() {
        return this.onset;
    }

    public Condition setOnset(Type type) {
        this.onset = type;
        return this;
    }

    public Type getAbatement() {
        return this.abatement;
    }

    public Condition setAbatement(Type type) {
        this.abatement = type;
        return this;
    }

    public ConditionStageComponent getStage() {
        return this.stage;
    }

    public Condition setStage(ConditionStageComponent conditionStageComponent) {
        this.stage = conditionStageComponent;
        return this;
    }

    public List<ConditionEvidenceComponent> getEvidence() {
        return this.evidence;
    }

    public ConditionEvidenceComponent addEvidence() {
        ConditionEvidenceComponent conditionEvidenceComponent = new ConditionEvidenceComponent();
        this.evidence.add(conditionEvidenceComponent);
        return conditionEvidenceComponent;
    }

    public List<ConditionLocationComponent> getLocation() {
        return this.location;
    }

    public ConditionLocationComponent addLocation() {
        ConditionLocationComponent conditionLocationComponent = new ConditionLocationComponent();
        this.location.add(conditionLocationComponent);
        return conditionLocationComponent;
    }

    public List<ConditionRelatedItemComponent> getRelatedItem() {
        return this.relatedItem;
    }

    public ConditionRelatedItemComponent addRelatedItem() {
        ConditionRelatedItemComponent conditionRelatedItemComponent = new ConditionRelatedItemComponent();
        this.relatedItem.add(conditionRelatedItemComponent);
        return conditionRelatedItemComponent;
    }

    public StringType getNotes() {
        return this.notes;
    }

    public Condition setNotes(StringType stringType) {
        this.notes = stringType;
        return this;
    }

    public String getNotesSimple() {
        return this.notes == null ? null : this.notes.getValue();
    }

    public Condition setNotesSimple(String string) {
        if (string == null) {
            this.notes = null;
        } else {
            if (this.notes == null) {
                this.notes = new StringType();
            }
            this.notes.setValue(string);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "This records identifiers associated with this condition that are defined by business processed and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("subject", "Resource(Patient)", "Indicates the patient who the condition record is associated with.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("encounter", "Resource(Encounter)", "Encounter during which the condition was first asserted.", 0, Integer.MAX_VALUE, this.encounter));
        list.add(new Property("asserter", "Resource(Practitioner|Patient)", "Person who takes responsibility for asserting the existence of the condition as part of the electronic record.", 0, Integer.MAX_VALUE, this.asserter));
        list.add(new Property("dateAsserted", "date", "Estimated or actual date the condition/problem/diagnosis was first detected/suspected.", 0, Integer.MAX_VALUE, this.dateAsserted));
        list.add(new Property("code", "CodeableConcept", "Identification of the condition, problem or diagnosis.", 0, Integer.MAX_VALUE, this.code));
        list.add(new Property("category", "CodeableConcept", "A category assigned to the condition. E.g. complaint | symptom | finding | diagnosis.", 0, Integer.MAX_VALUE, this.category));
        list.add(new Property("status", "code", "The clinical status of the condition.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("certainty", "CodeableConcept", "The degree of confidence that this condition is correct.", 0, Integer.MAX_VALUE, this.certainty));
        list.add(new Property("severity", "CodeableConcept", "A subjective assessment of the severity of the condition as evaluated by the clinician.", 0, Integer.MAX_VALUE, this.severity));
        list.add(new Property("onset[x]", "date|Age", "Estimated or actual date the condition began, in the opinion of the clinician.", 0, Integer.MAX_VALUE, this.onset));
        list.add(new Property("abatement[x]", "date|Age|boolean", "The date or estimated date that the condition resolved or went into remission. This is called 'abatement' because of the many overloaded connotations associated with 'remission' or 'resolution' - Conditions are never really resolved, but they can abate.", 0, Integer.MAX_VALUE, this.abatement));
        list.add(new Property("stage", "", "Clinical stage or grade of a condition. May include formal severity assessments.", 0, Integer.MAX_VALUE, this.stage));
        list.add(new Property("evidence", "", "Supporting Evidence / manifestations that are the basis on which this condition is suspected or confirmed.", 0, Integer.MAX_VALUE, this.evidence));
        list.add(new Property("location", "", "The anatomical location where this condition manifests itself.", 0, Integer.MAX_VALUE, this.location));
        list.add(new Property("relatedItem", "", "Further conditions, problems, diagnoses, procedures or events that are related in some way to this condition, or the substance that caused/triggered this Condition.", 0, Integer.MAX_VALUE, this.relatedItem));
        list.add(new Property("notes", "string", "Additional information about the Condition. This is a general notes/comments entry  for description of the Condition, its diagnosis and prognosis.", 0, Integer.MAX_VALUE, this.notes));
    }

    public Condition copy() {
        Condition condition = new Condition();
        condition.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            condition.identifier.add(element.copy());
        }
        condition.subject = this.subject == null ? null : this.subject.copy();
        condition.encounter = this.encounter == null ? null : this.encounter.copy();
        condition.asserter = this.asserter == null ? null : this.asserter.copy();
        condition.dateAsserted = this.dateAsserted == null ? null : this.dateAsserted.copy();
        condition.code = this.code == null ? null : this.code.copy();
        condition.category = this.category == null ? null : this.category.copy();
        condition.status = this.status == null ? null : this.status.copy();
        condition.certainty = this.certainty == null ? null : this.certainty.copy();
        condition.severity = this.severity == null ? null : this.severity.copy();
        condition.onset = this.onset == null ? null : this.onset.copy();
        condition.abatement = this.abatement == null ? null : this.abatement.copy();
        condition.stage = this.stage == null ? null : this.stage.copy();
        condition.evidence = new ArrayList<ConditionEvidenceComponent>();
        for (ConditionEvidenceComponent conditionEvidenceComponent : this.evidence) {
            condition.evidence.add(conditionEvidenceComponent.copy());
        }
        condition.location = new ArrayList<ConditionLocationComponent>();
        for (ConditionLocationComponent conditionLocationComponent : this.location) {
            condition.location.add(conditionLocationComponent.copy());
        }
        condition.relatedItem = new ArrayList<ConditionRelatedItemComponent>();
        for (ConditionRelatedItemComponent conditionRelatedItemComponent : this.relatedItem) {
            condition.relatedItem.add(conditionRelatedItemComponent.copy());
        }
        condition.notes = this.notes == null ? null : this.notes.copy();
        return condition;
    }

    protected Condition typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Condition;
    }

    public static class ConditionRelatedItemComponent
    extends BackboneElement {
        protected Enumeration<ConditionRelationshipType> type;
        protected CodeableConcept code;
        protected ResourceReference target;
        protected Resource targetTarget;
        private static final long serialVersionUID = -7869756L;

        public ConditionRelatedItemComponent() {
        }

        public ConditionRelatedItemComponent(Enumeration<ConditionRelationshipType> enumeration) {
            this.type = enumeration;
        }

        public Enumeration<ConditionRelationshipType> getType() {
            return this.type;
        }

        public ConditionRelatedItemComponent setType(Enumeration<ConditionRelationshipType> enumeration) {
            this.type = enumeration;
            return this;
        }

        public ConditionRelationshipType getTypeSimple() {
            return this.type == null ? null : this.type.getValue();
        }

        public ConditionRelatedItemComponent setTypeSimple(ConditionRelationshipType conditionRelationshipType) {
            if (this.type == null) {
                this.type = new Enumeration();
            }
            this.type.setValue(conditionRelationshipType);
            return this;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public ConditionRelatedItemComponent setCode(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
            return this;
        }

        public ResourceReference getTarget() {
            return this.target;
        }

        public ConditionRelatedItemComponent setTarget(ResourceReference resourceReference) {
            this.target = resourceReference;
            return this;
        }

        public Resource getTargetTarget() {
            return this.targetTarget;
        }

        public ConditionRelatedItemComponent setTargetTarget(Resource resource) {
            this.targetTarget = resource;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("type", "code", "The type of relationship that this condition has to the related item.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("code", "CodeableConcept", "Code that identifies the target of this relationship. The code takes the place of a detailed instance target.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("target", "Resource(Condition|Procedure|MedicationAdministration|Immunization|MedicationStatement)", "Target of the relationship.", 0, Integer.MAX_VALUE, this.target));
        }

        public ConditionRelatedItemComponent copy() {
            ConditionRelatedItemComponent conditionRelatedItemComponent = new ConditionRelatedItemComponent();
            conditionRelatedItemComponent.type = this.type == null ? null : this.type.copy();
            conditionRelatedItemComponent.code = this.code == null ? null : this.code.copy();
            conditionRelatedItemComponent.target = this.target == null ? null : this.target.copy();
            return conditionRelatedItemComponent;
        }
    }

    public static class ConditionLocationComponent
    extends BackboneElement {
        protected CodeableConcept code;
        protected StringType detail;
        private static final long serialVersionUID = -406205954L;

        public CodeableConcept getCode() {
            return this.code;
        }

        public ConditionLocationComponent setCode(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
            return this;
        }

        public StringType getDetail() {
            return this.detail;
        }

        public ConditionLocationComponent setDetail(StringType stringType) {
            this.detail = stringType;
            return this;
        }

        public String getDetailSimple() {
            return this.detail == null ? null : this.detail.getValue();
        }

        public ConditionLocationComponent setDetailSimple(String string) {
            if (string == null) {
                this.detail = null;
            } else {
                if (this.detail == null) {
                    this.detail = new StringType();
                }
                this.detail.setValue(string);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "CodeableConcept", "Code that identifies the structural location.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("detail", "string", "Detailed anatomical location information.", 0, Integer.MAX_VALUE, this.detail));
        }

        public ConditionLocationComponent copy() {
            ConditionLocationComponent conditionLocationComponent = new ConditionLocationComponent();
            conditionLocationComponent.code = this.code == null ? null : this.code.copy();
            conditionLocationComponent.detail = this.detail == null ? null : this.detail.copy();
            return conditionLocationComponent;
        }
    }

    public static class ConditionEvidenceComponent
    extends BackboneElement {
        protected CodeableConcept code;
        protected List<ResourceReference> detail = new ArrayList<ResourceReference>();
        protected List<Resource> detailTarget = new ArrayList<Resource>();
        private static final long serialVersionUID = 1835722845L;

        public CodeableConcept getCode() {
            return this.code;
        }

        public ConditionEvidenceComponent setCode(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
            return this;
        }

        public List<ResourceReference> getDetail() {
            return this.detail;
        }

        public ResourceReference addDetail() {
            ResourceReference resourceReference = new ResourceReference();
            this.detail.add(resourceReference);
            return resourceReference;
        }

        public List<Resource> getDetailTarget() {
            return this.detailTarget;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "CodeableConcept", "A manifestation or symptom that led to the recording of this condition.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("detail", "Resource(Any)", "Links to other relevant information, including pathology reports.", 0, Integer.MAX_VALUE, this.detail));
        }

        public ConditionEvidenceComponent copy() {
            ConditionEvidenceComponent conditionEvidenceComponent = new ConditionEvidenceComponent();
            conditionEvidenceComponent.code = this.code == null ? null : this.code.copy();
            conditionEvidenceComponent.detail = new ArrayList<ResourceReference>();
            for (ResourceReference resourceReference : this.detail) {
                conditionEvidenceComponent.detail.add(resourceReference.copy());
            }
            return conditionEvidenceComponent;
        }
    }

    public static class ConditionStageComponent
    extends BackboneElement {
        protected CodeableConcept summary;
        protected List<ResourceReference> assessment = new ArrayList<ResourceReference>();
        protected List<Resource> assessmentTarget = new ArrayList<Resource>();
        private static final long serialVersionUID = -1698066074L;

        public CodeableConcept getSummary() {
            return this.summary;
        }

        public ConditionStageComponent setSummary(CodeableConcept codeableConcept) {
            this.summary = codeableConcept;
            return this;
        }

        public List<ResourceReference> getAssessment() {
            return this.assessment;
        }

        public ResourceReference addAssessment() {
            ResourceReference resourceReference = new ResourceReference();
            this.assessment.add(resourceReference);
            return resourceReference;
        }

        public List<Resource> getAssessmentTarget() {
            return this.assessmentTarget;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("summary", "CodeableConcept", "A simple summary of the stage such as 'Stage 3'. The determination of the stage is disease-specific.", 0, Integer.MAX_VALUE, this.summary));
            list.add(new Property("assessment", "Resource(Any)", "Reference to a formal record of the evidence on which the staging assessment is based.", 0, Integer.MAX_VALUE, this.assessment));
        }

        public ConditionStageComponent copy() {
            ConditionStageComponent conditionStageComponent = new ConditionStageComponent();
            conditionStageComponent.summary = this.summary == null ? null : this.summary.copy();
            conditionStageComponent.assessment = new ArrayList<ResourceReference>();
            for (ResourceReference resourceReference : this.assessment) {
                conditionStageComponent.assessment.add(resourceReference.copy());
            }
            return conditionStageComponent;
        }
    }

    public static class ConditionRelationshipTypeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("due-to".equals(string)) {
                return ConditionRelationshipType.dueto;
            }
            if ("following".equals(string)) {
                return ConditionRelationshipType.following;
            }
            throw new Exception("Unknown ConditionRelationshipType code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ConditionRelationshipType.dueto) {
                return "due-to";
            }
            if (enum_ == ConditionRelationshipType.following) {
                return "following";
            }
            return "?";
        }
    }

    public static enum ConditionRelationshipType {
        dueto,
        following,
        Null;


        public static ConditionRelationshipType fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("due-to".equals(string)) {
                return dueto;
            }
            if ("following".equals(string)) {
                return following;
            }
            throw new Exception("Unknown ConditionRelationshipType code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case dueto: {
                    return "due-to";
                }
                case following: {
                    return "following";
                }
            }
            return "?";
        }
    }

    public static class ConditionStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("provisional".equals(string)) {
                return ConditionStatus.provisional;
            }
            if ("working".equals(string)) {
                return ConditionStatus.working;
            }
            if ("confirmed".equals(string)) {
                return ConditionStatus.confirmed;
            }
            if ("refuted".equals(string)) {
                return ConditionStatus.refuted;
            }
            throw new Exception("Unknown ConditionStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ConditionStatus.provisional) {
                return "provisional";
            }
            if (enum_ == ConditionStatus.working) {
                return "working";
            }
            if (enum_ == ConditionStatus.confirmed) {
                return "confirmed";
            }
            if (enum_ == ConditionStatus.refuted) {
                return "refuted";
            }
            return "?";
        }
    }

    public static enum ConditionStatus {
        provisional,
        working,
        confirmed,
        refuted,
        Null;


        public static ConditionStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("provisional".equals(string)) {
                return provisional;
            }
            if ("working".equals(string)) {
                return working;
            }
            if ("confirmed".equals(string)) {
                return confirmed;
            }
            if ("refuted".equals(string)) {
                return refuted;
            }
            throw new Exception("Unknown ConditionStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case provisional: {
                    return "provisional";
                }
                case working: {
                    return "working";
                }
                case confirmed: {
                    return "confirmed";
                }
                case refuted: {
                    return "refuted";
                }
            }
            return "?";
        }
    }
}

