/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Base64BinaryType;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.Profile;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.UriType;

public class Conformance
extends Resource {
    protected StringType identifier;
    protected StringType version;
    protected StringType name;
    protected StringType publisher;
    protected List<Contact> telecom = new ArrayList<Contact>();
    protected StringType description;
    protected Enumeration<ConformanceStatementStatus> status;
    protected BooleanType experimental;
    protected DateTimeType date;
    protected ConformanceSoftwareComponent software;
    protected ConformanceImplementationComponent implementation;
    protected IdType fhirVersion;
    protected BooleanType acceptUnknown;
    protected List<CodeType> format = new ArrayList<CodeType>();
    protected List<ResourceReference> profile = new ArrayList<ResourceReference>();
    protected List<Profile> profileTarget = new ArrayList<Profile>();
    protected List<ConformanceRestComponent> rest = new ArrayList<ConformanceRestComponent>();
    protected List<ConformanceMessagingComponent> messaging = new ArrayList<ConformanceMessagingComponent>();
    protected List<ConformanceDocumentComponent> document = new ArrayList<ConformanceDocumentComponent>();
    private static final long serialVersionUID = 1536079902L;

    public Conformance() {
    }

    public Conformance(StringType stringType, DateTimeType dateTimeType, IdType idType, BooleanType booleanType) {
        this.publisher = stringType;
        this.date = dateTimeType;
        this.fhirVersion = idType;
        this.acceptUnknown = booleanType;
    }

    public StringType getIdentifier() {
        return this.identifier;
    }

    public Conformance setIdentifier(StringType stringType) {
        this.identifier = stringType;
        return this;
    }

    public String getIdentifierSimple() {
        return this.identifier == null ? null : this.identifier.getValue();
    }

    public Conformance setIdentifierSimple(String string) {
        if (string == null) {
            this.identifier = null;
        } else {
            if (this.identifier == null) {
                this.identifier = new StringType();
            }
            this.identifier.setValue(string);
        }
        return this;
    }

    public StringType getVersion() {
        return this.version;
    }

    public Conformance setVersion(StringType stringType) {
        this.version = stringType;
        return this;
    }

    public String getVersionSimple() {
        return this.version == null ? null : this.version.getValue();
    }

    public Conformance setVersionSimple(String string) {
        if (string == null) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(string);
        }
        return this;
    }

    public StringType getName() {
        return this.name;
    }

    public Conformance setName(StringType stringType) {
        this.name = stringType;
        return this;
    }

    public String getNameSimple() {
        return this.name == null ? null : this.name.getValue();
    }

    public Conformance setNameSimple(String string) {
        if (string == null) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(string);
        }
        return this;
    }

    public StringType getPublisher() {
        return this.publisher;
    }

    public Conformance setPublisher(StringType stringType) {
        this.publisher = stringType;
        return this;
    }

    public String getPublisherSimple() {
        return this.publisher == null ? null : this.publisher.getValue();
    }

    public Conformance setPublisherSimple(String string) {
        if (this.publisher == null) {
            this.publisher = new StringType();
        }
        this.publisher.setValue(string);
        return this;
    }

    public List<Contact> getTelecom() {
        return this.telecom;
    }

    public Contact addTelecom() {
        Contact contact = new Contact();
        this.telecom.add(contact);
        return contact;
    }

    public StringType getDescription() {
        return this.description;
    }

    public Conformance setDescription(StringType stringType) {
        this.description = stringType;
        return this;
    }

    public String getDescriptionSimple() {
        return this.description == null ? null : this.description.getValue();
    }

    public Conformance setDescriptionSimple(String string) {
        if (string == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(string);
        }
        return this;
    }

    public Enumeration<ConformanceStatementStatus> getStatus() {
        return this.status;
    }

    public Conformance setStatus(Enumeration<ConformanceStatementStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public ConformanceStatementStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public Conformance setStatusSimple(ConformanceStatementStatus conformanceStatementStatus) {
        if (conformanceStatementStatus == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration();
            }
            this.status.setValue(conformanceStatementStatus);
        }
        return this;
    }

    public BooleanType getExperimental() {
        return this.experimental;
    }

    public Conformance setExperimental(BooleanType booleanType) {
        this.experimental = booleanType;
        return this;
    }

    public boolean getExperimentalSimple() {
        return this.experimental == null ? false : this.experimental.getValue();
    }

    public Conformance setExperimentalSimple(boolean bl) {
        if (!bl) {
            this.experimental = null;
        } else {
            if (this.experimental == null) {
                this.experimental = new BooleanType();
            }
            this.experimental.setValue(bl);
        }
        return this;
    }

    public DateTimeType getDate() {
        return this.date;
    }

    public Conformance setDate(DateTimeType dateTimeType) {
        this.date = dateTimeType;
        return this;
    }

    public DateAndTime getDateSimple() {
        return this.date == null ? null : this.date.getValue();
    }

    public Conformance setDateSimple(DateAndTime dateAndTime) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(dateAndTime);
        return this;
    }

    public ConformanceSoftwareComponent getSoftware() {
        return this.software;
    }

    public Conformance setSoftware(ConformanceSoftwareComponent conformanceSoftwareComponent) {
        this.software = conformanceSoftwareComponent;
        return this;
    }

    public ConformanceImplementationComponent getImplementation() {
        return this.implementation;
    }

    public Conformance setImplementation(ConformanceImplementationComponent conformanceImplementationComponent) {
        this.implementation = conformanceImplementationComponent;
        return this;
    }

    public IdType getFhirVersion() {
        return this.fhirVersion;
    }

    public Conformance setFhirVersion(IdType idType) {
        this.fhirVersion = idType;
        return this;
    }

    public String getFhirVersionSimple() {
        return this.fhirVersion == null ? null : this.fhirVersion.getValue();
    }

    public Conformance setFhirVersionSimple(String string) {
        if (this.fhirVersion == null) {
            this.fhirVersion = new IdType();
        }
        this.fhirVersion.setValue(string);
        return this;
    }

    public BooleanType getAcceptUnknown() {
        return this.acceptUnknown;
    }

    public Conformance setAcceptUnknown(BooleanType booleanType) {
        this.acceptUnknown = booleanType;
        return this;
    }

    public boolean getAcceptUnknownSimple() {
        return this.acceptUnknown == null ? false : this.acceptUnknown.getValue();
    }

    public Conformance setAcceptUnknownSimple(boolean bl) {
        if (this.acceptUnknown == null) {
            this.acceptUnknown = new BooleanType();
        }
        this.acceptUnknown.setValue(bl);
        return this;
    }

    public List<CodeType> getFormat() {
        return this.format;
    }

    public CodeType addFormat() {
        CodeType codeType = new CodeType();
        this.format.add(codeType);
        return codeType;
    }

    public CodeType addFormatSimple(String string) {
        CodeType codeType = new CodeType();
        codeType.setValue(string);
        this.format.add(codeType);
        return codeType;
    }

    public boolean hasFormatSimple(String string) {
        for (CodeType codeType : this.format) {
            if (!codeType.getValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    public List<ResourceReference> getProfile() {
        return this.profile;
    }

    public ResourceReference addProfile() {
        ResourceReference resourceReference = new ResourceReference();
        this.profile.add(resourceReference);
        return resourceReference;
    }

    public List<Profile> getProfileTarget() {
        return this.profileTarget;
    }

    public Profile addProfileTarget() {
        Profile profile = new Profile();
        this.profileTarget.add(profile);
        return profile;
    }

    public List<ConformanceRestComponent> getRest() {
        return this.rest;
    }

    public ConformanceRestComponent addRest() {
        ConformanceRestComponent conformanceRestComponent = new ConformanceRestComponent();
        this.rest.add(conformanceRestComponent);
        return conformanceRestComponent;
    }

    public List<ConformanceMessagingComponent> getMessaging() {
        return this.messaging;
    }

    public ConformanceMessagingComponent addMessaging() {
        ConformanceMessagingComponent conformanceMessagingComponent = new ConformanceMessagingComponent();
        this.messaging.add(conformanceMessagingComponent);
        return conformanceMessagingComponent;
    }

    public List<ConformanceDocumentComponent> getDocument() {
        return this.document;
    }

    public ConformanceDocumentComponent addDocument() {
        ConformanceDocumentComponent conformanceDocumentComponent = new ConformanceDocumentComponent();
        this.document.add(conformanceDocumentComponent);
        return conformanceDocumentComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "string", "The identifier that is used to identify this conformance statement when it is referenced in a specification, model, design or an instance (should be globally unique OID, UUID, or URI).", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("version", "string", "The identifier that is used to identify this version of the conformance statement when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp.", 0, Integer.MAX_VALUE, this.version));
        list.add(new Property("name", "string", "A free text natural language name identifying the conformance statement.", 0, Integer.MAX_VALUE, this.name));
        list.add(new Property("publisher", "string", "Name of Organization publishing this conformance statement.", 0, Integer.MAX_VALUE, this.publisher));
        list.add(new Property("telecom", "Contact", "Contacts for Organization relevant to this conformance statement.  The contacts may be a website, email, phone numbers, etc.", 0, Integer.MAX_VALUE, this.telecom));
        list.add(new Property("description", "string", "A free text natural language description of the conformance statement and its use. Typically, this is used when the profile describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP.", 0, Integer.MAX_VALUE, this.description));
        list.add(new Property("status", "code", "The status of this conformance statement.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("experimental", "boolean", "A flag to indicate that this conformance statement is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        list.add(new Property("date", "dateTime", "The date when the conformance statement was published.", 0, Integer.MAX_VALUE, this.date));
        list.add(new Property("software", "", "Software that is covered by this conformance statement.  It is used when the profile describes the capabilities of a particular software version, independent of an installation.", 0, Integer.MAX_VALUE, this.software));
        list.add(new Property("implementation", "", "Identifies a specific implementation instance that is described by the conformance statement - i.e. a particular installation, rather than the capabilities of a software program.", 0, Integer.MAX_VALUE, this.implementation));
        list.add(new Property("fhirVersion", "id", "The version of the FHIR specification on which this conformance statement is based.", 0, Integer.MAX_VALUE, this.fhirVersion));
        list.add(new Property("acceptUnknown", "boolean", "A flag that indicates whether the application accepts unknown elements as part of a resource.", 0, Integer.MAX_VALUE, this.acceptUnknown));
        list.add(new Property("format", "code", "A list of the formats supported by this implementation.", 0, Integer.MAX_VALUE, this.format));
        list.add(new Property("profile", "Resource(Profile)", "A list of profiles supported by the system. For a server, 'supported by the system' means the system hosts/produces a set of recourses, conformant to a particular profile, and allows its clients to search using this profile and to find appropriate data. For a client, it means the system will search by this profile and process data according to the guidance implicit in the profile.", 0, Integer.MAX_VALUE, this.profile));
        list.add(new Property("rest", "", "A definition of the restful capabilities of the solution, if any.", 0, Integer.MAX_VALUE, this.rest));
        list.add(new Property("messaging", "", "A description of the messaging capabilities of the solution.", 0, Integer.MAX_VALUE, this.messaging));
        list.add(new Property("document", "", "A document definition.", 0, Integer.MAX_VALUE, this.document));
    }

    public Conformance copy() {
        Conformance conformance = new Conformance();
        conformance.identifier = this.identifier == null ? null : this.identifier.copy();
        conformance.version = this.version == null ? null : this.version.copy();
        conformance.name = this.name == null ? null : this.name.copy();
        conformance.publisher = this.publisher == null ? null : this.publisher.copy();
        conformance.telecom = new ArrayList<Contact>();
        for (Contact element : this.telecom) {
            conformance.telecom.add(element.copy());
        }
        conformance.description = this.description == null ? null : this.description.copy();
        conformance.status = this.status == null ? null : this.status.copy();
        conformance.experimental = this.experimental == null ? null : this.experimental.copy();
        conformance.date = this.date == null ? null : this.date.copy();
        conformance.software = this.software == null ? null : this.software.copy();
        conformance.implementation = this.implementation == null ? null : this.implementation.copy();
        conformance.fhirVersion = this.fhirVersion == null ? null : this.fhirVersion.copy();
        conformance.acceptUnknown = this.acceptUnknown == null ? null : this.acceptUnknown.copy();
        conformance.format = new ArrayList<CodeType>();
        for (CodeType codeType : this.format) {
            conformance.format.add(codeType.copy());
        }
        conformance.profile = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.profile) {
            conformance.profile.add(resourceReference.copy());
        }
        conformance.rest = new ArrayList<ConformanceRestComponent>();
        for (ConformanceRestComponent conformanceRestComponent : this.rest) {
            conformance.rest.add(conformanceRestComponent.copy());
        }
        conformance.messaging = new ArrayList<ConformanceMessagingComponent>();
        for (ConformanceMessagingComponent conformanceMessagingComponent : this.messaging) {
            conformance.messaging.add(conformanceMessagingComponent.copy());
        }
        conformance.document = new ArrayList<ConformanceDocumentComponent>();
        for (ConformanceDocumentComponent conformanceDocumentComponent : this.document) {
            conformance.document.add(conformanceDocumentComponent.copy());
        }
        return conformance;
    }

    protected Conformance typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Conformance;
    }

    public static class ConformanceDocumentComponent
    extends BackboneElement {
        protected Enumeration<DocumentMode> mode;
        protected StringType documentation;
        protected ResourceReference profile;
        protected Profile profileTarget;
        private static final long serialVersionUID = 1730738206L;

        public ConformanceDocumentComponent() {
        }

        public ConformanceDocumentComponent(Enumeration<DocumentMode> enumeration, ResourceReference resourceReference) {
            this.mode = enumeration;
            this.profile = resourceReference;
        }

        public Enumeration<DocumentMode> getMode() {
            return this.mode;
        }

        public ConformanceDocumentComponent setMode(Enumeration<DocumentMode> enumeration) {
            this.mode = enumeration;
            return this;
        }

        public DocumentMode getModeSimple() {
            return this.mode == null ? null : this.mode.getValue();
        }

        public ConformanceDocumentComponent setModeSimple(DocumentMode documentMode) {
            if (this.mode == null) {
                this.mode = new Enumeration();
            }
            this.mode.setValue(documentMode);
            return this;
        }

        public StringType getDocumentation() {
            return this.documentation;
        }

        public ConformanceDocumentComponent setDocumentation(StringType stringType) {
            this.documentation = stringType;
            return this;
        }

        public String getDocumentationSimple() {
            return this.documentation == null ? null : this.documentation.getValue();
        }

        public ConformanceDocumentComponent setDocumentationSimple(String string) {
            if (string == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(string);
            }
            return this;
        }

        public ResourceReference getProfile() {
            return this.profile;
        }

        public ConformanceDocumentComponent setProfile(ResourceReference resourceReference) {
            this.profile = resourceReference;
            return this;
        }

        public Profile getProfileTarget() {
            return this.profileTarget;
        }

        public ConformanceDocumentComponent setProfileTarget(Profile profile) {
            this.profileTarget = profile;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("mode", "code", "Mode of this document declaration - whether application is producer or consumer.", 0, Integer.MAX_VALUE, this.mode));
            list.add(new Property("documentation", "string", "A description of how the application supports or uses the specified document profile.  For example, when are documents created, what action is taken with consumed documents, etc.", 0, Integer.MAX_VALUE, this.documentation));
            list.add(new Property("profile", "Resource(Profile)", "A constraint on a resource used in the document.", 0, Integer.MAX_VALUE, this.profile));
        }

        public ConformanceDocumentComponent copy() {
            ConformanceDocumentComponent conformanceDocumentComponent = new ConformanceDocumentComponent();
            conformanceDocumentComponent.mode = this.mode == null ? null : this.mode.copy();
            conformanceDocumentComponent.documentation = this.documentation == null ? null : this.documentation.copy();
            conformanceDocumentComponent.profile = this.profile == null ? null : this.profile.copy();
            return conformanceDocumentComponent;
        }
    }

    public static class ConformanceMessagingEventComponent
    extends BackboneElement {
        protected Coding code;
        protected Enumeration<MessageSignificanceCategory> category;
        protected Enumeration<MessageConformanceEventMode> mode;
        protected List<Coding> protocol = new ArrayList<Coding>();
        protected CodeType focus;
        protected ResourceReference request;
        protected Profile requestTarget;
        protected ResourceReference response;
        protected Profile responseTarget;
        protected StringType documentation;
        private static final long serialVersionUID = 1765976644L;

        public ConformanceMessagingEventComponent() {
        }

        public ConformanceMessagingEventComponent(Coding coding, Enumeration<MessageConformanceEventMode> enumeration, CodeType codeType, ResourceReference resourceReference, ResourceReference resourceReference2) {
            this.code = coding;
            this.mode = enumeration;
            this.focus = codeType;
            this.request = resourceReference;
            this.response = resourceReference2;
        }

        public Coding getCode() {
            return this.code;
        }

        public ConformanceMessagingEventComponent setCode(Coding coding) {
            this.code = coding;
            return this;
        }

        public Enumeration<MessageSignificanceCategory> getCategory() {
            return this.category;
        }

        public ConformanceMessagingEventComponent setCategory(Enumeration<MessageSignificanceCategory> enumeration) {
            this.category = enumeration;
            return this;
        }

        public MessageSignificanceCategory getCategorySimple() {
            return this.category == null ? null : this.category.getValue();
        }

        public ConformanceMessagingEventComponent setCategorySimple(MessageSignificanceCategory messageSignificanceCategory) {
            if (messageSignificanceCategory == null) {
                this.category = null;
            } else {
                if (this.category == null) {
                    this.category = new Enumeration();
                }
                this.category.setValue(messageSignificanceCategory);
            }
            return this;
        }

        public Enumeration<MessageConformanceEventMode> getMode() {
            return this.mode;
        }

        public ConformanceMessagingEventComponent setMode(Enumeration<MessageConformanceEventMode> enumeration) {
            this.mode = enumeration;
            return this;
        }

        public MessageConformanceEventMode getModeSimple() {
            return this.mode == null ? null : this.mode.getValue();
        }

        public ConformanceMessagingEventComponent setModeSimple(MessageConformanceEventMode messageConformanceEventMode) {
            if (this.mode == null) {
                this.mode = new Enumeration();
            }
            this.mode.setValue(messageConformanceEventMode);
            return this;
        }

        public List<Coding> getProtocol() {
            return this.protocol;
        }

        public Coding addProtocol() {
            Coding coding = new Coding();
            this.protocol.add(coding);
            return coding;
        }

        public CodeType getFocus() {
            return this.focus;
        }

        public ConformanceMessagingEventComponent setFocus(CodeType codeType) {
            this.focus = codeType;
            return this;
        }

        public String getFocusSimple() {
            return this.focus == null ? null : this.focus.getValue();
        }

        public ConformanceMessagingEventComponent setFocusSimple(String string) {
            if (this.focus == null) {
                this.focus = new CodeType();
            }
            this.focus.setValue(string);
            return this;
        }

        public ResourceReference getRequest() {
            return this.request;
        }

        public ConformanceMessagingEventComponent setRequest(ResourceReference resourceReference) {
            this.request = resourceReference;
            return this;
        }

        public Profile getRequestTarget() {
            return this.requestTarget;
        }

        public ConformanceMessagingEventComponent setRequestTarget(Profile profile) {
            this.requestTarget = profile;
            return this;
        }

        public ResourceReference getResponse() {
            return this.response;
        }

        public ConformanceMessagingEventComponent setResponse(ResourceReference resourceReference) {
            this.response = resourceReference;
            return this;
        }

        public Profile getResponseTarget() {
            return this.responseTarget;
        }

        public ConformanceMessagingEventComponent setResponseTarget(Profile profile) {
            this.responseTarget = profile;
            return this;
        }

        public StringType getDocumentation() {
            return this.documentation;
        }

        public ConformanceMessagingEventComponent setDocumentation(StringType stringType) {
            this.documentation = stringType;
            return this;
        }

        public String getDocumentationSimple() {
            return this.documentation == null ? null : this.documentation.getValue();
        }

        public ConformanceMessagingEventComponent setDocumentationSimple(String string) {
            if (string == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(string);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "Coding", "A coded identifier of a supported messaging event.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("category", "code", "The impact of the content of the message.", 0, Integer.MAX_VALUE, this.category));
            list.add(new Property("mode", "code", "The mode of this event declaration - whether application is sender or receiver.", 0, Integer.MAX_VALUE, this.mode));
            list.add(new Property("protocol", "Coding", "A list of the messaging transport protocol(s) identifiers, supported by this endpoint.", 0, Integer.MAX_VALUE, this.protocol));
            list.add(new Property("focus", "code", "A resource associated with the event.  This is the resource that defines the event.", 0, Integer.MAX_VALUE, this.focus));
            list.add(new Property("request", "Resource(Profile)", "Information about the request for this event.", 0, Integer.MAX_VALUE, this.request));
            list.add(new Property("response", "Resource(Profile)", "Information about the response for this event.", 0, Integer.MAX_VALUE, this.response));
            list.add(new Property("documentation", "string", "Guidance on how this event is handled, such as internal system trigger points, business rules, etc.", 0, Integer.MAX_VALUE, this.documentation));
        }

        public ConformanceMessagingEventComponent copy() {
            ConformanceMessagingEventComponent conformanceMessagingEventComponent = new ConformanceMessagingEventComponent();
            conformanceMessagingEventComponent.code = this.code == null ? null : this.code.copy();
            conformanceMessagingEventComponent.category = this.category == null ? null : this.category.copy();
            conformanceMessagingEventComponent.mode = this.mode == null ? null : this.mode.copy();
            conformanceMessagingEventComponent.protocol = new ArrayList<Coding>();
            for (Coding coding : this.protocol) {
                conformanceMessagingEventComponent.protocol.add(coding.copy());
            }
            conformanceMessagingEventComponent.focus = this.focus == null ? null : this.focus.copy();
            conformanceMessagingEventComponent.request = this.request == null ? null : this.request.copy();
            conformanceMessagingEventComponent.response = this.response == null ? null : this.response.copy();
            conformanceMessagingEventComponent.documentation = this.documentation == null ? null : this.documentation.copy();
            return conformanceMessagingEventComponent;
        }
    }

    public static class ConformanceMessagingComponent
    extends BackboneElement {
        protected UriType endpoint;
        protected IntegerType reliableCache;
        protected StringType documentation;
        protected List<ConformanceMessagingEventComponent> event = new ArrayList<ConformanceMessagingEventComponent>();
        private static final long serialVersionUID = -1845309943L;

        public UriType getEndpoint() {
            return this.endpoint;
        }

        public ConformanceMessagingComponent setEndpoint(UriType uriType) {
            this.endpoint = uriType;
            return this;
        }

        public String getEndpointSimple() {
            return this.endpoint == null ? null : this.endpoint.getValue();
        }

        public ConformanceMessagingComponent setEndpointSimple(String string) {
            if (string == null) {
                this.endpoint = null;
            } else {
                if (this.endpoint == null) {
                    this.endpoint = new UriType();
                }
                this.endpoint.setValue(string);
            }
            return this;
        }

        public IntegerType getReliableCache() {
            return this.reliableCache;
        }

        public ConformanceMessagingComponent setReliableCache(IntegerType integerType) {
            this.reliableCache = integerType;
            return this;
        }

        public int getReliableCacheSimple() {
            return this.reliableCache == null ? null : Integer.valueOf(this.reliableCache.getValue());
        }

        public ConformanceMessagingComponent setReliableCacheSimple(int n) {
            if (n == -1) {
                this.reliableCache = null;
            } else {
                if (this.reliableCache == null) {
                    this.reliableCache = new IntegerType();
                }
                this.reliableCache.setValue(n);
            }
            return this;
        }

        public StringType getDocumentation() {
            return this.documentation;
        }

        public ConformanceMessagingComponent setDocumentation(StringType stringType) {
            this.documentation = stringType;
            return this;
        }

        public String getDocumentationSimple() {
            return this.documentation == null ? null : this.documentation.getValue();
        }

        public ConformanceMessagingComponent setDocumentationSimple(String string) {
            if (string == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(string);
            }
            return this;
        }

        public List<ConformanceMessagingEventComponent> getEvent() {
            return this.event;
        }

        public ConformanceMessagingEventComponent addEvent() {
            ConformanceMessagingEventComponent conformanceMessagingEventComponent = new ConformanceMessagingEventComponent();
            this.event.add(conformanceMessagingEventComponent);
            return conformanceMessagingEventComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("endpoint", "uri", "An address to which messages and/or replies are to be sent.", 0, Integer.MAX_VALUE, this.endpoint));
            list.add(new Property("reliableCache", "integer", "Length if the receiver's reliable messaging cache (if a receiver) or how long the cache length on the receiver should be (if a sender).", 0, Integer.MAX_VALUE, this.reliableCache));
            list.add(new Property("documentation", "string", "Documentation about the system's messaging capabilities for this endpoint not otherwise documented by the conformance statement.  For example, process for becoming an authorized messaging exchange partner.", 0, Integer.MAX_VALUE, this.documentation));
            list.add(new Property("event", "", "A description of the solution's support for an event at this end point.", 0, Integer.MAX_VALUE, this.event));
        }

        public ConformanceMessagingComponent copy() {
            ConformanceMessagingComponent conformanceMessagingComponent = new ConformanceMessagingComponent();
            conformanceMessagingComponent.endpoint = this.endpoint == null ? null : this.endpoint.copy();
            conformanceMessagingComponent.reliableCache = this.reliableCache == null ? null : this.reliableCache.copy();
            conformanceMessagingComponent.documentation = this.documentation == null ? null : this.documentation.copy();
            conformanceMessagingComponent.event = new ArrayList<ConformanceMessagingEventComponent>();
            for (ConformanceMessagingEventComponent conformanceMessagingEventComponent : this.event) {
                conformanceMessagingComponent.event.add(conformanceMessagingEventComponent.copy());
            }
            return conformanceMessagingComponent;
        }
    }

    public static class ConformanceRestQueryComponent
    extends BackboneElement {
        protected StringType name;
        protected UriType definition;
        protected StringType documentation;
        protected List<ConformanceRestResourceSearchParamComponent> parameter = new ArrayList<ConformanceRestResourceSearchParamComponent>();
        private static final long serialVersionUID = -341304558L;

        public ConformanceRestQueryComponent() {
        }

        public ConformanceRestQueryComponent(StringType stringType, UriType uriType) {
            this.name = stringType;
            this.definition = uriType;
        }

        public StringType getName() {
            return this.name;
        }

        public ConformanceRestQueryComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public ConformanceRestQueryComponent setNameSimple(String string) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(string);
            return this;
        }

        public UriType getDefinition() {
            return this.definition;
        }

        public ConformanceRestQueryComponent setDefinition(UriType uriType) {
            this.definition = uriType;
            return this;
        }

        public String getDefinitionSimple() {
            return this.definition == null ? null : this.definition.getValue();
        }

        public ConformanceRestQueryComponent setDefinitionSimple(String string) {
            if (this.definition == null) {
                this.definition = new UriType();
            }
            this.definition.setValue(string);
            return this;
        }

        public StringType getDocumentation() {
            return this.documentation;
        }

        public ConformanceRestQueryComponent setDocumentation(StringType stringType) {
            this.documentation = stringType;
            return this;
        }

        public String getDocumentationSimple() {
            return this.documentation == null ? null : this.documentation.getValue();
        }

        public ConformanceRestQueryComponent setDocumentationSimple(String string) {
            if (string == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(string);
            }
            return this;
        }

        public List<ConformanceRestResourceSearchParamComponent> getParameter() {
            return this.parameter;
        }

        public ConformanceRestResourceSearchParamComponent addParameter() {
            ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent = new ConformanceRestResourceSearchParamComponent();
            this.parameter.add(conformanceRestResourceSearchParamComponent);
            return conformanceRestResourceSearchParamComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("name", "string", "The name of a query, which is used in the _query parameter when the query is called.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("definition", "uri", "Identifies the custom query, defined either in FHIR core or another profile.", 0, Integer.MAX_VALUE, this.definition));
            list.add(new Property("documentation", "string", "Additional information about how the query functions in this particular implementation.", 0, Integer.MAX_VALUE, this.documentation));
            list.add(new Property("parameter", "@Conformance.rest.resource.searchParam", "Identifies which of the parameters for the named query are supported.", 0, Integer.MAX_VALUE, this.parameter));
        }

        public ConformanceRestQueryComponent copy() {
            ConformanceRestQueryComponent conformanceRestQueryComponent = new ConformanceRestQueryComponent();
            conformanceRestQueryComponent.name = this.name == null ? null : this.name.copy();
            conformanceRestQueryComponent.definition = this.definition == null ? null : this.definition.copy();
            conformanceRestQueryComponent.documentation = this.documentation == null ? null : this.documentation.copy();
            conformanceRestQueryComponent.parameter = new ArrayList<ConformanceRestResourceSearchParamComponent>();
            for (ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent : this.parameter) {
                conformanceRestQueryComponent.parameter.add(conformanceRestResourceSearchParamComponent.copy());
            }
            return conformanceRestQueryComponent;
        }
    }

    public static class ConformanceRestOperationComponent
    extends BackboneElement {
        protected Enumeration<SystemRestfulOperation> code;
        protected StringType documentation;
        private static final long serialVersionUID = -642136532L;

        public ConformanceRestOperationComponent() {
        }

        public ConformanceRestOperationComponent(Enumeration<SystemRestfulOperation> enumeration) {
            this.code = enumeration;
        }

        public Enumeration<SystemRestfulOperation> getCode() {
            return this.code;
        }

        public ConformanceRestOperationComponent setCode(Enumeration<SystemRestfulOperation> enumeration) {
            this.code = enumeration;
            return this;
        }

        public SystemRestfulOperation getCodeSimple() {
            return this.code == null ? null : this.code.getValue();
        }

        public ConformanceRestOperationComponent setCodeSimple(SystemRestfulOperation systemRestfulOperation) {
            if (this.code == null) {
                this.code = new Enumeration();
            }
            this.code.setValue(systemRestfulOperation);
            return this;
        }

        public StringType getDocumentation() {
            return this.documentation;
        }

        public ConformanceRestOperationComponent setDocumentation(StringType stringType) {
            this.documentation = stringType;
            return this;
        }

        public String getDocumentationSimple() {
            return this.documentation == null ? null : this.documentation.getValue();
        }

        public ConformanceRestOperationComponent setDocumentationSimple(String string) {
            if (string == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(string);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "code", "A coded identifier of the operation, supported by the system.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("documentation", "string", "Guidance specific to the implementation of this operation, such as limitations on the kind of transactions allowed, or information about system wide search is implemented.", 0, Integer.MAX_VALUE, this.documentation));
        }

        public ConformanceRestOperationComponent copy() {
            ConformanceRestOperationComponent conformanceRestOperationComponent = new ConformanceRestOperationComponent();
            conformanceRestOperationComponent.code = this.code == null ? null : this.code.copy();
            conformanceRestOperationComponent.documentation = this.documentation == null ? null : this.documentation.copy();
            return conformanceRestOperationComponent;
        }
    }

    public static class ConformanceRestResourceSearchParamComponent
    extends BackboneElement {
        protected StringType name;
        protected UriType definition;
        protected Enumeration<SearchParamType> type;
        protected StringType documentation;
        protected List<CodeType> target = new ArrayList<CodeType>();
        protected List<StringType> chain = new ArrayList<StringType>();
        private static final long serialVersionUID = -1498791020L;

        public ConformanceRestResourceSearchParamComponent() {
        }

        public ConformanceRestResourceSearchParamComponent(StringType stringType, Enumeration<SearchParamType> enumeration) {
            this.name = stringType;
            this.type = enumeration;
        }

        public StringType getName() {
            return this.name;
        }

        public ConformanceRestResourceSearchParamComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public ConformanceRestResourceSearchParamComponent setNameSimple(String string) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(string);
            return this;
        }

        public UriType getDefinition() {
            return this.definition;
        }

        public ConformanceRestResourceSearchParamComponent setDefinition(UriType uriType) {
            this.definition = uriType;
            return this;
        }

        public String getDefinitionSimple() {
            return this.definition == null ? null : this.definition.getValue();
        }

        public ConformanceRestResourceSearchParamComponent setDefinitionSimple(String string) {
            if (string == null) {
                this.definition = null;
            } else {
                if (this.definition == null) {
                    this.definition = new UriType();
                }
                this.definition.setValue(string);
            }
            return this;
        }

        public Enumeration<SearchParamType> getType() {
            return this.type;
        }

        public ConformanceRestResourceSearchParamComponent setType(Enumeration<SearchParamType> enumeration) {
            this.type = enumeration;
            return this;
        }

        public SearchParamType getTypeSimple() {
            return this.type == null ? null : this.type.getValue();
        }

        public ConformanceRestResourceSearchParamComponent setTypeSimple(SearchParamType searchParamType) {
            if (this.type == null) {
                this.type = new Enumeration();
            }
            this.type.setValue(searchParamType);
            return this;
        }

        public StringType getDocumentation() {
            return this.documentation;
        }

        public ConformanceRestResourceSearchParamComponent setDocumentation(StringType stringType) {
            this.documentation = stringType;
            return this;
        }

        public String getDocumentationSimple() {
            return this.documentation == null ? null : this.documentation.getValue();
        }

        public ConformanceRestResourceSearchParamComponent setDocumentationSimple(String string) {
            if (string == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(string);
            }
            return this;
        }

        public List<CodeType> getTarget() {
            return this.target;
        }

        public CodeType addTarget() {
            CodeType codeType = new CodeType();
            this.target.add(codeType);
            return codeType;
        }

        public CodeType addTargetSimple(String string) {
            CodeType codeType = new CodeType();
            codeType.setValue(string);
            this.target.add(codeType);
            return codeType;
        }

        public boolean hasTargetSimple(String string) {
            for (CodeType codeType : this.target) {
                if (!codeType.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }

        public List<StringType> getChain() {
            return this.chain;
        }

        public StringType addChain() {
            StringType stringType = new StringType();
            this.chain.add(stringType);
            return stringType;
        }

        public StringType addChainSimple(String string) {
            StringType stringType = new StringType();
            stringType.setValue(string);
            this.chain.add(stringType);
            return stringType;
        }

        public boolean hasChainSimple(String string) {
            for (StringType stringType : this.chain) {
                if (!stringType.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("name", "string", "The name of the search parameter used in the interface.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("definition", "uri", "A formal reference to where this parameter was first defined, so that a client can be confident of the meaning of the search parameter.", 0, Integer.MAX_VALUE, this.definition));
            list.add(new Property("type", "code", "The type of value a search parameter refers to, and how the content is interpreted.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("documentation", "string", "This allows documentation of any distinct behaviors about how the search parameter is used.  For example, text matching algorithms.", 0, Integer.MAX_VALUE, this.documentation));
            list.add(new Property("target", "code", "Types of resource (if a resource is referenced).", 0, Integer.MAX_VALUE, this.target));
            list.add(new Property("chain", "string", "Chained names supported.", 0, Integer.MAX_VALUE, this.chain));
        }

        public ConformanceRestResourceSearchParamComponent copy() {
            ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent = new ConformanceRestResourceSearchParamComponent();
            conformanceRestResourceSearchParamComponent.name = this.name == null ? null : this.name.copy();
            conformanceRestResourceSearchParamComponent.definition = this.definition == null ? null : this.definition.copy();
            conformanceRestResourceSearchParamComponent.type = this.type == null ? null : this.type.copy();
            conformanceRestResourceSearchParamComponent.documentation = this.documentation == null ? null : this.documentation.copy();
            conformanceRestResourceSearchParamComponent.target = new ArrayList<CodeType>();
            for (CodeType primitiveType : this.target) {
                conformanceRestResourceSearchParamComponent.target.add(primitiveType.copy());
            }
            conformanceRestResourceSearchParamComponent.chain = new ArrayList<StringType>();
            for (StringType stringType : this.chain) {
                conformanceRestResourceSearchParamComponent.chain.add(stringType.copy());
            }
            return conformanceRestResourceSearchParamComponent;
        }
    }

    public static class ConformanceRestResourceOperationComponent
    extends BackboneElement {
        protected Enumeration<TypeRestfulOperation> code;
        protected StringType documentation;
        private static final long serialVersionUID = -1045357385L;

        public ConformanceRestResourceOperationComponent() {
        }

        public ConformanceRestResourceOperationComponent(Enumeration<TypeRestfulOperation> enumeration) {
            this.code = enumeration;
        }

        public Enumeration<TypeRestfulOperation> getCode() {
            return this.code;
        }

        public ConformanceRestResourceOperationComponent setCode(Enumeration<TypeRestfulOperation> enumeration) {
            this.code = enumeration;
            return this;
        }

        public TypeRestfulOperation getCodeSimple() {
            return this.code == null ? null : this.code.getValue();
        }

        public ConformanceRestResourceOperationComponent setCodeSimple(TypeRestfulOperation typeRestfulOperation) {
            if (this.code == null) {
                this.code = new Enumeration();
            }
            this.code.setValue(typeRestfulOperation);
            return this;
        }

        public StringType getDocumentation() {
            return this.documentation;
        }

        public ConformanceRestResourceOperationComponent setDocumentation(StringType stringType) {
            this.documentation = stringType;
            return this;
        }

        public String getDocumentationSimple() {
            return this.documentation == null ? null : this.documentation.getValue();
        }

        public ConformanceRestResourceOperationComponent setDocumentationSimple(String string) {
            if (string == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(string);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "code", "Coded identifier of the operation, supported by the system resource.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("documentation", "string", "Guidance specific to the implementation of this operation, such as 'delete is a logical delete' or 'updates are only allowed with version id' or 'creates permitted from pre-authorized certificates only'.", 0, Integer.MAX_VALUE, this.documentation));
        }

        public ConformanceRestResourceOperationComponent copy() {
            ConformanceRestResourceOperationComponent conformanceRestResourceOperationComponent = new ConformanceRestResourceOperationComponent();
            conformanceRestResourceOperationComponent.code = this.code == null ? null : this.code.copy();
            conformanceRestResourceOperationComponent.documentation = this.documentation == null ? null : this.documentation.copy();
            return conformanceRestResourceOperationComponent;
        }
    }

    public static class ConformanceRestResourceComponent
    extends BackboneElement {
        protected CodeType type;
        protected ResourceReference profile;
        protected Profile profileTarget;
        protected List<ConformanceRestResourceOperationComponent> operation = new ArrayList<ConformanceRestResourceOperationComponent>();
        protected BooleanType readHistory;
        protected BooleanType updateCreate;
        protected List<StringType> searchInclude = new ArrayList<StringType>();
        protected List<ConformanceRestResourceSearchParamComponent> searchParam = new ArrayList<ConformanceRestResourceSearchParamComponent>();
        private static final long serialVersionUID = 293157908L;

        public ConformanceRestResourceComponent() {
        }

        public ConformanceRestResourceComponent(CodeType codeType) {
            this.type = codeType;
        }

        public CodeType getType() {
            return this.type;
        }

        public ConformanceRestResourceComponent setType(CodeType codeType) {
            this.type = codeType;
            return this;
        }

        public String getTypeSimple() {
            return this.type == null ? null : this.type.getValue();
        }

        public ConformanceRestResourceComponent setTypeSimple(String string) {
            if (this.type == null) {
                this.type = new CodeType();
            }
            this.type.setValue(string);
            return this;
        }

        public ResourceReference getProfile() {
            return this.profile;
        }

        public ConformanceRestResourceComponent setProfile(ResourceReference resourceReference) {
            this.profile = resourceReference;
            return this;
        }

        public Profile getProfileTarget() {
            return this.profileTarget;
        }

        public ConformanceRestResourceComponent setProfileTarget(Profile profile) {
            this.profileTarget = profile;
            return this;
        }

        public List<ConformanceRestResourceOperationComponent> getOperation() {
            return this.operation;
        }

        public ConformanceRestResourceOperationComponent addOperation() {
            ConformanceRestResourceOperationComponent conformanceRestResourceOperationComponent = new ConformanceRestResourceOperationComponent();
            this.operation.add(conformanceRestResourceOperationComponent);
            return conformanceRestResourceOperationComponent;
        }

        public BooleanType getReadHistory() {
            return this.readHistory;
        }

        public ConformanceRestResourceComponent setReadHistory(BooleanType booleanType) {
            this.readHistory = booleanType;
            return this;
        }

        public boolean getReadHistorySimple() {
            return this.readHistory == null ? false : this.readHistory.getValue();
        }

        public ConformanceRestResourceComponent setReadHistorySimple(boolean bl) {
            if (!bl) {
                this.readHistory = null;
            } else {
                if (this.readHistory == null) {
                    this.readHistory = new BooleanType();
                }
                this.readHistory.setValue(bl);
            }
            return this;
        }

        public BooleanType getUpdateCreate() {
            return this.updateCreate;
        }

        public ConformanceRestResourceComponent setUpdateCreate(BooleanType booleanType) {
            this.updateCreate = booleanType;
            return this;
        }

        public boolean getUpdateCreateSimple() {
            return this.updateCreate == null ? false : this.updateCreate.getValue();
        }

        public ConformanceRestResourceComponent setUpdateCreateSimple(boolean bl) {
            if (!bl) {
                this.updateCreate = null;
            } else {
                if (this.updateCreate == null) {
                    this.updateCreate = new BooleanType();
                }
                this.updateCreate.setValue(bl);
            }
            return this;
        }

        public List<StringType> getSearchInclude() {
            return this.searchInclude;
        }

        public StringType addSearchInclude() {
            StringType stringType = new StringType();
            this.searchInclude.add(stringType);
            return stringType;
        }

        public StringType addSearchIncludeSimple(String string) {
            StringType stringType = new StringType();
            stringType.setValue(string);
            this.searchInclude.add(stringType);
            return stringType;
        }

        public boolean hasSearchIncludeSimple(String string) {
            for (StringType stringType : this.searchInclude) {
                if (!stringType.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }

        public List<ConformanceRestResourceSearchParamComponent> getSearchParam() {
            return this.searchParam;
        }

        public ConformanceRestResourceSearchParamComponent addSearchParam() {
            ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent = new ConformanceRestResourceSearchParamComponent();
            this.searchParam.add(conformanceRestResourceSearchParamComponent);
            return conformanceRestResourceSearchParamComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("type", "code", "A type of resource exposed via the restful interface.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("profile", "Resource(Profile)", "A specification of the profile that describes the solution's support for the resource, including any constraints on cardinality, bindings, lengths or other limitations.", 0, Integer.MAX_VALUE, this.profile));
            list.add(new Property("operation", "", "Identifies a restful operation supported by the solution.", 0, Integer.MAX_VALUE, this.operation));
            list.add(new Property("readHistory", "boolean", "A flag for whether the server is able to return past versions as part of the vRead operation.", 0, Integer.MAX_VALUE, this.readHistory));
            list.add(new Property("updateCreate", "boolean", "A flag to indicate that the server allows the client to create new identities on the server. If the update operation is used (client) or allowed (server) to a new location where a resource doesn't already exist. This means that the server allows the client to create new identities on the server.", 0, Integer.MAX_VALUE, this.updateCreate));
            list.add(new Property("searchInclude", "string", "A list of _include values supported by the server.", 0, Integer.MAX_VALUE, this.searchInclude));
            list.add(new Property("searchParam", "", "Additional search parameters for implementations to support and/or make use of.", 0, Integer.MAX_VALUE, this.searchParam));
        }

        public ConformanceRestResourceComponent copy() {
            ConformanceRestResourceComponent conformanceRestResourceComponent = new ConformanceRestResourceComponent();
            conformanceRestResourceComponent.type = this.type == null ? null : this.type.copy();
            conformanceRestResourceComponent.profile = this.profile == null ? null : this.profile.copy();
            conformanceRestResourceComponent.operation = new ArrayList<ConformanceRestResourceOperationComponent>();
            for (ConformanceRestResourceOperationComponent element : this.operation) {
                conformanceRestResourceComponent.operation.add(element.copy());
            }
            conformanceRestResourceComponent.readHistory = this.readHistory == null ? null : this.readHistory.copy();
            conformanceRestResourceComponent.updateCreate = this.updateCreate == null ? null : this.updateCreate.copy();
            conformanceRestResourceComponent.searchInclude = new ArrayList<StringType>();
            for (StringType stringType : this.searchInclude) {
                conformanceRestResourceComponent.searchInclude.add(stringType.copy());
            }
            conformanceRestResourceComponent.searchParam = new ArrayList<ConformanceRestResourceSearchParamComponent>();
            for (ConformanceRestResourceSearchParamComponent conformanceRestResourceSearchParamComponent : this.searchParam) {
                conformanceRestResourceComponent.searchParam.add(conformanceRestResourceSearchParamComponent.copy());
            }
            return conformanceRestResourceComponent;
        }
    }

    public static class ConformanceRestSecurityCertificateComponent
    extends BackboneElement {
        protected CodeType type;
        protected Base64BinaryType blob;
        private static final long serialVersionUID = 2092655854L;

        public CodeType getType() {
            return this.type;
        }

        public ConformanceRestSecurityCertificateComponent setType(CodeType codeType) {
            this.type = codeType;
            return this;
        }

        public String getTypeSimple() {
            return this.type == null ? null : this.type.getValue();
        }

        public ConformanceRestSecurityCertificateComponent setTypeSimple(String string) {
            if (string == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new CodeType();
                }
                this.type.setValue(string);
            }
            return this;
        }

        public Base64BinaryType getBlob() {
            return this.blob;
        }

        public ConformanceRestSecurityCertificateComponent setBlob(Base64BinaryType base64BinaryType) {
            this.blob = base64BinaryType;
            return this;
        }

        public byte[] getBlobSimple() {
            return this.blob == null ? null : this.blob.getValue();
        }

        public ConformanceRestSecurityCertificateComponent setBlobSimple(byte[] byArray) {
            if (byArray == null) {
                this.blob = null;
            } else {
                if (this.blob == null) {
                    this.blob = new Base64BinaryType();
                }
                this.blob.setValue(byArray);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("type", "code", "Mime type for certificate.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("blob", "base64Binary", "Actual certificate.", 0, Integer.MAX_VALUE, this.blob));
        }

        public ConformanceRestSecurityCertificateComponent copy() {
            ConformanceRestSecurityCertificateComponent conformanceRestSecurityCertificateComponent = new ConformanceRestSecurityCertificateComponent();
            conformanceRestSecurityCertificateComponent.type = this.type == null ? null : this.type.copy();
            conformanceRestSecurityCertificateComponent.blob = this.blob == null ? null : this.blob.copy();
            return conformanceRestSecurityCertificateComponent;
        }
    }

    public static class ConformanceRestSecurityComponent
    extends BackboneElement {
        protected BooleanType cors;
        protected List<CodeableConcept> service = new ArrayList<CodeableConcept>();
        protected StringType description;
        protected List<ConformanceRestSecurityCertificateComponent> certificate = new ArrayList<ConformanceRestSecurityCertificateComponent>();
        private static final long serialVersionUID = -1974024888L;

        public BooleanType getCors() {
            return this.cors;
        }

        public ConformanceRestSecurityComponent setCors(BooleanType booleanType) {
            this.cors = booleanType;
            return this;
        }

        public boolean getCorsSimple() {
            return this.cors == null ? false : this.cors.getValue();
        }

        public ConformanceRestSecurityComponent setCorsSimple(boolean bl) {
            if (!bl) {
                this.cors = null;
            } else {
                if (this.cors == null) {
                    this.cors = new BooleanType();
                }
                this.cors.setValue(bl);
            }
            return this;
        }

        public List<CodeableConcept> getService() {
            return this.service;
        }

        public CodeableConcept addService() {
            CodeableConcept codeableConcept = new CodeableConcept();
            this.service.add(codeableConcept);
            return codeableConcept;
        }

        public StringType getDescription() {
            return this.description;
        }

        public ConformanceRestSecurityComponent setDescription(StringType stringType) {
            this.description = stringType;
            return this;
        }

        public String getDescriptionSimple() {
            return this.description == null ? null : this.description.getValue();
        }

        public ConformanceRestSecurityComponent setDescriptionSimple(String string) {
            if (string == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(string);
            }
            return this;
        }

        public List<ConformanceRestSecurityCertificateComponent> getCertificate() {
            return this.certificate;
        }

        public ConformanceRestSecurityCertificateComponent addCertificate() {
            ConformanceRestSecurityCertificateComponent conformanceRestSecurityCertificateComponent = new ConformanceRestSecurityCertificateComponent();
            this.certificate.add(conformanceRestSecurityCertificateComponent);
            return conformanceRestSecurityCertificateComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("cors", "boolean", "Server adds CORS headers when responding to requests - this enables javascript applications to yuse the server.", 0, Integer.MAX_VALUE, this.cors));
            list.add(new Property("service", "CodeableConcept", "Types of security services are supported/required by the system.", 0, Integer.MAX_VALUE, this.service));
            list.add(new Property("description", "string", "General description of how security works.", 0, Integer.MAX_VALUE, this.description));
            list.add(new Property("certificate", "", "Certificates associated with security profiles.", 0, Integer.MAX_VALUE, this.certificate));
        }

        public ConformanceRestSecurityComponent copy() {
            ConformanceRestSecurityComponent conformanceRestSecurityComponent = new ConformanceRestSecurityComponent();
            conformanceRestSecurityComponent.cors = this.cors == null ? null : this.cors.copy();
            conformanceRestSecurityComponent.service = new ArrayList<CodeableConcept>();
            for (CodeableConcept element : this.service) {
                conformanceRestSecurityComponent.service.add(element.copy());
            }
            conformanceRestSecurityComponent.description = this.description == null ? null : this.description.copy();
            conformanceRestSecurityComponent.certificate = new ArrayList<ConformanceRestSecurityCertificateComponent>();
            for (ConformanceRestSecurityCertificateComponent conformanceRestSecurityCertificateComponent : this.certificate) {
                conformanceRestSecurityComponent.certificate.add(conformanceRestSecurityCertificateComponent.copy());
            }
            return conformanceRestSecurityComponent;
        }
    }

    public static class ConformanceRestComponent
    extends BackboneElement {
        protected Enumeration<RestfulConformanceMode> mode;
        protected StringType documentation;
        protected ConformanceRestSecurityComponent security;
        protected List<ConformanceRestResourceComponent> resource = new ArrayList<ConformanceRestResourceComponent>();
        protected List<ConformanceRestOperationComponent> operation = new ArrayList<ConformanceRestOperationComponent>();
        protected List<ConformanceRestQueryComponent> query = new ArrayList<ConformanceRestQueryComponent>();
        protected List<UriType> documentMailbox = new ArrayList<UriType>();
        private static final long serialVersionUID = 842556556L;

        public ConformanceRestComponent() {
        }

        public ConformanceRestComponent(Enumeration<RestfulConformanceMode> enumeration) {
            this.mode = enumeration;
        }

        public Enumeration<RestfulConformanceMode> getMode() {
            return this.mode;
        }

        public ConformanceRestComponent setMode(Enumeration<RestfulConformanceMode> enumeration) {
            this.mode = enumeration;
            return this;
        }

        public RestfulConformanceMode getModeSimple() {
            return this.mode == null ? null : this.mode.getValue();
        }

        public ConformanceRestComponent setModeSimple(RestfulConformanceMode restfulConformanceMode) {
            if (this.mode == null) {
                this.mode = new Enumeration();
            }
            this.mode.setValue(restfulConformanceMode);
            return this;
        }

        public StringType getDocumentation() {
            return this.documentation;
        }

        public ConformanceRestComponent setDocumentation(StringType stringType) {
            this.documentation = stringType;
            return this;
        }

        public String getDocumentationSimple() {
            return this.documentation == null ? null : this.documentation.getValue();
        }

        public ConformanceRestComponent setDocumentationSimple(String string) {
            if (string == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(string);
            }
            return this;
        }

        public ConformanceRestSecurityComponent getSecurity() {
            return this.security;
        }

        public ConformanceRestComponent setSecurity(ConformanceRestSecurityComponent conformanceRestSecurityComponent) {
            this.security = conformanceRestSecurityComponent;
            return this;
        }

        public List<ConformanceRestResourceComponent> getResource() {
            return this.resource;
        }

        public ConformanceRestResourceComponent addResource() {
            ConformanceRestResourceComponent conformanceRestResourceComponent = new ConformanceRestResourceComponent();
            this.resource.add(conformanceRestResourceComponent);
            return conformanceRestResourceComponent;
        }

        public List<ConformanceRestOperationComponent> getOperation() {
            return this.operation;
        }

        public ConformanceRestOperationComponent addOperation() {
            ConformanceRestOperationComponent conformanceRestOperationComponent = new ConformanceRestOperationComponent();
            this.operation.add(conformanceRestOperationComponent);
            return conformanceRestOperationComponent;
        }

        public List<ConformanceRestQueryComponent> getQuery() {
            return this.query;
        }

        public ConformanceRestQueryComponent addQuery() {
            ConformanceRestQueryComponent conformanceRestQueryComponent = new ConformanceRestQueryComponent();
            this.query.add(conformanceRestQueryComponent);
            return conformanceRestQueryComponent;
        }

        public List<UriType> getDocumentMailbox() {
            return this.documentMailbox;
        }

        public UriType addDocumentMailbox() {
            UriType uriType = new UriType();
            this.documentMailbox.add(uriType);
            return uriType;
        }

        public UriType addDocumentMailboxSimple(String string) {
            UriType uriType = new UriType();
            uriType.setValue(string);
            this.documentMailbox.add(uriType);
            return uriType;
        }

        public boolean hasDocumentMailboxSimple(String string) {
            for (UriType uriType : this.documentMailbox) {
                if (!uriType.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("mode", "code", "Identifies whether this portion of the statement is describing ability to initiate or receive restful operations.", 0, Integer.MAX_VALUE, this.mode));
            list.add(new Property("documentation", "string", "Information about the system's restful capabilities that apply across all applications, such as security.", 0, Integer.MAX_VALUE, this.documentation));
            list.add(new Property("security", "", "Information about security of implementation.", 0, Integer.MAX_VALUE, this.security));
            list.add(new Property("resource", "", "A specification of the restful capabilities of the solution for a specific resource type.", 0, Integer.MAX_VALUE, this.resource));
            list.add(new Property("operation", "", "A specification of restful operations supported by the system.", 0, Integer.MAX_VALUE, this.operation));
            list.add(new Property("query", "", "Definition of a named query and its parameters and their meaning.", 0, Integer.MAX_VALUE, this.query));
            list.add(new Property("documentMailbox", "uri", "A list of profiles that this server implements for accepting documents in the mailbox. If this list is empty, then documents are not accepted. The base specification has the profile identifier 'http://hl7.org/fhir/documents/mailbox'. Other specifications can declare their own identifier for this purpose.", 0, Integer.MAX_VALUE, this.documentMailbox));
        }

        public ConformanceRestComponent copy() {
            ConformanceRestComponent conformanceRestComponent = new ConformanceRestComponent();
            conformanceRestComponent.mode = this.mode == null ? null : this.mode.copy();
            conformanceRestComponent.documentation = this.documentation == null ? null : this.documentation.copy();
            conformanceRestComponent.security = this.security == null ? null : this.security.copy();
            conformanceRestComponent.resource = new ArrayList<ConformanceRestResourceComponent>();
            for (ConformanceRestResourceComponent element : this.resource) {
                conformanceRestComponent.resource.add(element.copy());
            }
            conformanceRestComponent.operation = new ArrayList<ConformanceRestOperationComponent>();
            for (ConformanceRestOperationComponent conformanceRestOperationComponent : this.operation) {
                conformanceRestComponent.operation.add(conformanceRestOperationComponent.copy());
            }
            conformanceRestComponent.query = new ArrayList<ConformanceRestQueryComponent>();
            for (ConformanceRestQueryComponent conformanceRestQueryComponent : this.query) {
                conformanceRestComponent.query.add(conformanceRestQueryComponent.copy());
            }
            conformanceRestComponent.documentMailbox = new ArrayList<UriType>();
            for (UriType uriType : this.documentMailbox) {
                conformanceRestComponent.documentMailbox.add(uriType.copy());
            }
            return conformanceRestComponent;
        }
    }

    public static class ConformanceImplementationComponent
    extends BackboneElement {
        protected StringType description;
        protected UriType url;
        private static final long serialVersionUID = -289238508L;

        public ConformanceImplementationComponent() {
        }

        public ConformanceImplementationComponent(StringType stringType) {
            this.description = stringType;
        }

        public StringType getDescription() {
            return this.description;
        }

        public ConformanceImplementationComponent setDescription(StringType stringType) {
            this.description = stringType;
            return this;
        }

        public String getDescriptionSimple() {
            return this.description == null ? null : this.description.getValue();
        }

        public ConformanceImplementationComponent setDescriptionSimple(String string) {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(string);
            return this;
        }

        public UriType getUrl() {
            return this.url;
        }

        public ConformanceImplementationComponent setUrl(UriType uriType) {
            this.url = uriType;
            return this;
        }

        public String getUrlSimple() {
            return this.url == null ? null : this.url.getValue();
        }

        public ConformanceImplementationComponent setUrlSimple(String string) {
            if (string == null) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UriType();
                }
                this.url.setValue(string);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("description", "string", "Information about the specific installation that this conformance statement relates to.", 0, Integer.MAX_VALUE, this.description));
            list.add(new Property("url", "uri", "A base URL for the implementation.  This forms the base for REST interfaces as well as the mailbox and document interfaces.", 0, Integer.MAX_VALUE, this.url));
        }

        public ConformanceImplementationComponent copy() {
            ConformanceImplementationComponent conformanceImplementationComponent = new ConformanceImplementationComponent();
            conformanceImplementationComponent.description = this.description == null ? null : this.description.copy();
            conformanceImplementationComponent.url = this.url == null ? null : this.url.copy();
            return conformanceImplementationComponent;
        }
    }

    public static class ConformanceSoftwareComponent
    extends BackboneElement {
        protected StringType name;
        protected StringType version;
        protected DateTimeType releaseDate;
        private static final long serialVersionUID = 1819769027L;

        public ConformanceSoftwareComponent() {
        }

        public ConformanceSoftwareComponent(StringType stringType) {
            this.name = stringType;
        }

        public StringType getName() {
            return this.name;
        }

        public ConformanceSoftwareComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public ConformanceSoftwareComponent setNameSimple(String string) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(string);
            return this;
        }

        public StringType getVersion() {
            return this.version;
        }

        public ConformanceSoftwareComponent setVersion(StringType stringType) {
            this.version = stringType;
            return this;
        }

        public String getVersionSimple() {
            return this.version == null ? null : this.version.getValue();
        }

        public ConformanceSoftwareComponent setVersionSimple(String string) {
            if (string == null) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(string);
            }
            return this;
        }

        public DateTimeType getReleaseDate() {
            return this.releaseDate;
        }

        public ConformanceSoftwareComponent setReleaseDate(DateTimeType dateTimeType) {
            this.releaseDate = dateTimeType;
            return this;
        }

        public DateAndTime getReleaseDateSimple() {
            return this.releaseDate == null ? null : this.releaseDate.getValue();
        }

        public ConformanceSoftwareComponent setReleaseDateSimple(DateAndTime dateAndTime) {
            if (dateAndTime == null) {
                this.releaseDate = null;
            } else {
                if (this.releaseDate == null) {
                    this.releaseDate = new DateTimeType();
                }
                this.releaseDate.setValue(dateAndTime);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("name", "string", "Name software is known by.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("version", "string", "The version identifier for the software covered by this statement.", 0, Integer.MAX_VALUE, this.version));
            list.add(new Property("releaseDate", "dateTime", "Date this version of the software released.", 0, Integer.MAX_VALUE, this.releaseDate));
        }

        public ConformanceSoftwareComponent copy() {
            ConformanceSoftwareComponent conformanceSoftwareComponent = new ConformanceSoftwareComponent();
            conformanceSoftwareComponent.name = this.name == null ? null : this.name.copy();
            conformanceSoftwareComponent.version = this.version == null ? null : this.version.copy();
            conformanceSoftwareComponent.releaseDate = this.releaseDate == null ? null : this.releaseDate.copy();
            return conformanceSoftwareComponent;
        }
    }

    public static class DocumentModeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("producer".equals(string)) {
                return DocumentMode.producer;
            }
            if ("consumer".equals(string)) {
                return DocumentMode.consumer;
            }
            throw new Exception("Unknown DocumentMode code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == DocumentMode.producer) {
                return "producer";
            }
            if (enum_ == DocumentMode.consumer) {
                return "consumer";
            }
            return "?";
        }
    }

    public static enum DocumentMode {
        producer,
        consumer,
        Null;


        public static DocumentMode fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("producer".equals(string)) {
                return producer;
            }
            if ("consumer".equals(string)) {
                return consumer;
            }
            throw new Exception("Unknown DocumentMode code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case producer: {
                    return "producer";
                }
                case consumer: {
                    return "consumer";
                }
            }
            return "?";
        }
    }

    public static class MessageConformanceEventModeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("sender".equals(string)) {
                return MessageConformanceEventMode.sender;
            }
            if ("receiver".equals(string)) {
                return MessageConformanceEventMode.receiver;
            }
            throw new Exception("Unknown MessageConformanceEventMode code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == MessageConformanceEventMode.sender) {
                return "sender";
            }
            if (enum_ == MessageConformanceEventMode.receiver) {
                return "receiver";
            }
            return "?";
        }
    }

    public static enum MessageConformanceEventMode {
        sender,
        receiver,
        Null;


        public static MessageConformanceEventMode fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("sender".equals(string)) {
                return sender;
            }
            if ("receiver".equals(string)) {
                return receiver;
            }
            throw new Exception("Unknown MessageConformanceEventMode code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case sender: {
                    return "sender";
                }
                case receiver: {
                    return "receiver";
                }
            }
            return "?";
        }
    }

    public static class MessageSignificanceCategoryEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("Consequence".equals(string)) {
                return MessageSignificanceCategory.consequence;
            }
            if ("Currency".equals(string)) {
                return MessageSignificanceCategory.currency;
            }
            if ("Notification".equals(string)) {
                return MessageSignificanceCategory.notification;
            }
            throw new Exception("Unknown MessageSignificanceCategory code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == MessageSignificanceCategory.consequence) {
                return "Consequence";
            }
            if (enum_ == MessageSignificanceCategory.currency) {
                return "Currency";
            }
            if (enum_ == MessageSignificanceCategory.notification) {
                return "Notification";
            }
            return "?";
        }
    }

    public static enum MessageSignificanceCategory {
        consequence,
        currency,
        notification,
        Null;


        public static MessageSignificanceCategory fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("Consequence".equals(string)) {
                return consequence;
            }
            if ("Currency".equals(string)) {
                return currency;
            }
            if ("Notification".equals(string)) {
                return notification;
            }
            throw new Exception("Unknown MessageSignificanceCategory code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case consequence: {
                    return "Consequence";
                }
                case currency: {
                    return "Currency";
                }
                case notification: {
                    return "Notification";
                }
            }
            return "?";
        }
    }

    public static class SystemRestfulOperationEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("transaction".equals(string)) {
                return SystemRestfulOperation.transaction;
            }
            if ("search-system".equals(string)) {
                return SystemRestfulOperation.searchsystem;
            }
            if ("history-system".equals(string)) {
                return SystemRestfulOperation.historysystem;
            }
            throw new Exception("Unknown SystemRestfulOperation code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == SystemRestfulOperation.transaction) {
                return "transaction";
            }
            if (enum_ == SystemRestfulOperation.searchsystem) {
                return "search-system";
            }
            if (enum_ == SystemRestfulOperation.historysystem) {
                return "history-system";
            }
            return "?";
        }
    }

    public static enum SystemRestfulOperation {
        transaction,
        searchsystem,
        historysystem,
        Null;


        public static SystemRestfulOperation fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("transaction".equals(string)) {
                return transaction;
            }
            if ("search-system".equals(string)) {
                return searchsystem;
            }
            if ("history-system".equals(string)) {
                return historysystem;
            }
            throw new Exception("Unknown SystemRestfulOperation code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case transaction: {
                    return "transaction";
                }
                case searchsystem: {
                    return "search-system";
                }
                case historysystem: {
                    return "history-system";
                }
            }
            return "?";
        }
    }

    public static class SearchParamTypeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("number".equals(string)) {
                return SearchParamType.number;
            }
            if ("date".equals(string)) {
                return SearchParamType.date;
            }
            if ("string".equals(string)) {
                return SearchParamType.string;
            }
            if ("token".equals(string)) {
                return SearchParamType.token;
            }
            if ("reference".equals(string)) {
                return SearchParamType.reference;
            }
            if ("composite".equals(string)) {
                return SearchParamType.composite;
            }
            if ("quantity".equals(string)) {
                return SearchParamType.quantity;
            }
            throw new Exception("Unknown SearchParamType code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == SearchParamType.number) {
                return "number";
            }
            if (enum_ == SearchParamType.date) {
                return "date";
            }
            if (enum_ == SearchParamType.string) {
                return "string";
            }
            if (enum_ == SearchParamType.token) {
                return "token";
            }
            if (enum_ == SearchParamType.reference) {
                return "reference";
            }
            if (enum_ == SearchParamType.composite) {
                return "composite";
            }
            if (enum_ == SearchParamType.quantity) {
                return "quantity";
            }
            return "?";
        }
    }

    public static enum SearchParamType {
        number,
        date,
        string,
        token,
        reference,
        composite,
        quantity,
        Null;


        public static SearchParamType fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("number".equals(string)) {
                return number;
            }
            if ("date".equals(string)) {
                return date;
            }
            if ("string".equals(string)) {
                return SearchParamType.string;
            }
            if ("token".equals(string)) {
                return token;
            }
            if ("reference".equals(string)) {
                return reference;
            }
            if ("composite".equals(string)) {
                return composite;
            }
            if ("quantity".equals(string)) {
                return quantity;
            }
            throw new Exception("Unknown SearchParamType code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case number: {
                    return "number";
                }
                case date: {
                    return "date";
                }
                case string: {
                    return "string";
                }
                case token: {
                    return "token";
                }
                case reference: {
                    return "reference";
                }
                case composite: {
                    return "composite";
                }
                case quantity: {
                    return "quantity";
                }
            }
            return "?";
        }
    }

    public static class TypeRestfulOperationEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("read".equals(string)) {
                return TypeRestfulOperation.read;
            }
            if ("vread".equals(string)) {
                return TypeRestfulOperation.vread;
            }
            if ("update".equals(string)) {
                return TypeRestfulOperation.update;
            }
            if ("delete".equals(string)) {
                return TypeRestfulOperation.delete;
            }
            if ("history-instance".equals(string)) {
                return TypeRestfulOperation.historyinstance;
            }
            if ("validate".equals(string)) {
                return TypeRestfulOperation.validate;
            }
            if ("history-type".equals(string)) {
                return TypeRestfulOperation.historytype;
            }
            if ("create".equals(string)) {
                return TypeRestfulOperation.create;
            }
            if ("search-type".equals(string)) {
                return TypeRestfulOperation.searchtype;
            }
            throw new Exception("Unknown TypeRestfulOperation code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == TypeRestfulOperation.read) {
                return "read";
            }
            if (enum_ == TypeRestfulOperation.vread) {
                return "vread";
            }
            if (enum_ == TypeRestfulOperation.update) {
                return "update";
            }
            if (enum_ == TypeRestfulOperation.delete) {
                return "delete";
            }
            if (enum_ == TypeRestfulOperation.historyinstance) {
                return "history-instance";
            }
            if (enum_ == TypeRestfulOperation.validate) {
                return "validate";
            }
            if (enum_ == TypeRestfulOperation.historytype) {
                return "history-type";
            }
            if (enum_ == TypeRestfulOperation.create) {
                return "create";
            }
            if (enum_ == TypeRestfulOperation.searchtype) {
                return "search-type";
            }
            return "?";
        }
    }

    public static enum TypeRestfulOperation {
        read,
        vread,
        update,
        delete,
        historyinstance,
        validate,
        historytype,
        create,
        searchtype,
        Null;


        public static TypeRestfulOperation fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("read".equals(string)) {
                return read;
            }
            if ("vread".equals(string)) {
                return vread;
            }
            if ("update".equals(string)) {
                return update;
            }
            if ("delete".equals(string)) {
                return delete;
            }
            if ("history-instance".equals(string)) {
                return historyinstance;
            }
            if ("validate".equals(string)) {
                return validate;
            }
            if ("history-type".equals(string)) {
                return historytype;
            }
            if ("create".equals(string)) {
                return create;
            }
            if ("search-type".equals(string)) {
                return searchtype;
            }
            throw new Exception("Unknown TypeRestfulOperation code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case read: {
                    return "read";
                }
                case vread: {
                    return "vread";
                }
                case update: {
                    return "update";
                }
                case delete: {
                    return "delete";
                }
                case historyinstance: {
                    return "history-instance";
                }
                case validate: {
                    return "validate";
                }
                case historytype: {
                    return "history-type";
                }
                case create: {
                    return "create";
                }
                case searchtype: {
                    return "search-type";
                }
            }
            return "?";
        }
    }

    public static class RestfulConformanceModeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("client".equals(string)) {
                return RestfulConformanceMode.client;
            }
            if ("server".equals(string)) {
                return RestfulConformanceMode.server;
            }
            throw new Exception("Unknown RestfulConformanceMode code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == RestfulConformanceMode.client) {
                return "client";
            }
            if (enum_ == RestfulConformanceMode.server) {
                return "server";
            }
            return "?";
        }
    }

    public static enum RestfulConformanceMode {
        client,
        server,
        Null;


        public static RestfulConformanceMode fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("client".equals(string)) {
                return client;
            }
            if ("server".equals(string)) {
                return server;
            }
            throw new Exception("Unknown RestfulConformanceMode code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case client: {
                    return "client";
                }
                case server: {
                    return "server";
                }
            }
            return "?";
        }
    }

    public static class ConformanceStatementStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("draft".equals(string)) {
                return ConformanceStatementStatus.draft;
            }
            if ("active".equals(string)) {
                return ConformanceStatementStatus.active;
            }
            if ("retired".equals(string)) {
                return ConformanceStatementStatus.retired;
            }
            throw new Exception("Unknown ConformanceStatementStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ConformanceStatementStatus.draft) {
                return "draft";
            }
            if (enum_ == ConformanceStatementStatus.active) {
                return "active";
            }
            if (enum_ == ConformanceStatementStatus.retired) {
                return "retired";
            }
            return "?";
        }
    }

    public static enum ConformanceStatementStatus {
        draft,
        active,
        retired,
        Null;


        public static ConformanceStatementStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("draft".equals(string)) {
                return draft;
            }
            if ("active".equals(string)) {
                return active;
            }
            if ("retired".equals(string)) {
                return retired;
            }
            throw new Exception("Unknown ConformanceStatementStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case draft: {
                    return "draft";
                }
                case active: {
                    return "active";
                }
                case retired: {
                    return "retired";
                }
            }
            return "?";
        }
    }
}

