/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.List;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;

public class Contact
extends Type {
    protected Enumeration<ContactSystem> system;
    protected StringType value;
    protected Enumeration<ContactUse> use;
    protected Period period;
    private static final long serialVersionUID = 1117502294L;

    public Enumeration<ContactSystem> getSystem() {
        return this.system;
    }

    public Contact setSystem(Enumeration<ContactSystem> enumeration) {
        this.system = enumeration;
        return this;
    }

    public ContactSystem getSystemSimple() {
        return this.system == null ? null : this.system.getValue();
    }

    public Contact setSystemSimple(ContactSystem contactSystem) {
        if (contactSystem == null) {
            this.system = null;
        } else {
            if (this.system == null) {
                this.system = new Enumeration();
            }
            this.system.setValue(contactSystem);
        }
        return this;
    }

    public StringType getValue() {
        return this.value;
    }

    public Contact setValue(StringType stringType) {
        this.value = stringType;
        return this;
    }

    public String getValueSimple() {
        return this.value == null ? null : this.value.getValue();
    }

    public Contact setValueSimple(String string) {
        if (string == null) {
            this.value = null;
        } else {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(string);
        }
        return this;
    }

    public Enumeration<ContactUse> getUse() {
        return this.use;
    }

    public Contact setUse(Enumeration<ContactUse> enumeration) {
        this.use = enumeration;
        return this;
    }

    public ContactUse getUseSimple() {
        return this.use == null ? null : this.use.getValue();
    }

    public Contact setUseSimple(ContactUse contactUse) {
        if (contactUse == null) {
            this.use = null;
        } else {
            if (this.use == null) {
                this.use = new Enumeration();
            }
            this.use.setValue(contactUse);
        }
        return this;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Contact setPeriod(Period period) {
        this.period = period;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("system", "code", "Telecommunications form for contact - what communications system is required to make use of the contact.", 0, Integer.MAX_VALUE, this.system));
        list.add(new Property("value", "string", "The actual contact details, in a form that is meaningful to the designated communication system (i.e. phone number or email address).", 0, Integer.MAX_VALUE, this.value));
        list.add(new Property("use", "code", "Identifies the purpose for the address.", 0, Integer.MAX_VALUE, this.use));
        list.add(new Property("period", "Period", "Time period when the contact was/is in use.", 0, Integer.MAX_VALUE, this.period));
    }

    @Override
    public Contact copy() {
        Contact contact = new Contact();
        contact.system = this.system == null ? null : this.system.copy();
        contact.value = this.value == null ? null : this.value.copy();
        contact.use = this.use == null ? null : this.use.copy();
        contact.period = this.period == null ? null : this.period.copy();
        return contact;
    }

    @Override
    protected Contact typedCopy() {
        return this.copy();
    }

    public static class ContactUseEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("home".equals(string)) {
                return ContactUse.home;
            }
            if ("work".equals(string)) {
                return ContactUse.work;
            }
            if ("temp".equals(string)) {
                return ContactUse.temp;
            }
            if ("old".equals(string)) {
                return ContactUse.old;
            }
            if ("mobile".equals(string)) {
                return ContactUse.mobile;
            }
            throw new Exception("Unknown ContactUse code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ContactUse.home) {
                return "home";
            }
            if (enum_ == ContactUse.work) {
                return "work";
            }
            if (enum_ == ContactUse.temp) {
                return "temp";
            }
            if (enum_ == ContactUse.old) {
                return "old";
            }
            if (enum_ == ContactUse.mobile) {
                return "mobile";
            }
            return "?";
        }
    }

    public static enum ContactUse {
        home,
        work,
        temp,
        old,
        mobile,
        Null;


        public static ContactUse fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("home".equals(string)) {
                return home;
            }
            if ("work".equals(string)) {
                return work;
            }
            if ("temp".equals(string)) {
                return temp;
            }
            if ("old".equals(string)) {
                return old;
            }
            if ("mobile".equals(string)) {
                return mobile;
            }
            throw new Exception("Unknown ContactUse code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case home: {
                    return "home";
                }
                case work: {
                    return "work";
                }
                case temp: {
                    return "temp";
                }
                case old: {
                    return "old";
                }
                case mobile: {
                    return "mobile";
                }
            }
            return "?";
        }
    }

    public static class ContactSystemEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("phone".equals(string)) {
                return ContactSystem.phone;
            }
            if ("fax".equals(string)) {
                return ContactSystem.fax;
            }
            if ("email".equals(string)) {
                return ContactSystem.email;
            }
            if ("url".equals(string)) {
                return ContactSystem.url;
            }
            throw new Exception("Unknown ContactSystem code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ContactSystem.phone) {
                return "phone";
            }
            if (enum_ == ContactSystem.fax) {
                return "fax";
            }
            if (enum_ == ContactSystem.email) {
                return "email";
            }
            if (enum_ == ContactSystem.url) {
                return "url";
            }
            return "?";
        }
    }

    public static enum ContactSystem {
        phone,
        fax,
        email,
        url,
        Null;


        public static ContactSystem fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("phone".equals(string)) {
                return phone;
            }
            if ("fax".equals(string)) {
                return fax;
            }
            if ("email".equals(string)) {
                return email;
            }
            if ("url".equals(string)) {
                return url;
            }
            throw new Exception("Unknown ContactSystem code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case phone: {
                    return "phone";
                }
                case fax: {
                    return "fax";
                }
                case email: {
                    return "email";
                }
                case url: {
                    return "url";
                }
            }
            return "?";
        }
    }
}

