/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.hl7.fhir.utilities.Utilities;

public class DateAndTime {
    private int year;
    private int month;
    private int day;
    private boolean time;
    private int hour;
    private int minute;
    private boolean seconds;
    private int second;
    private int fractions;
    private int fraction;
    private Boolean timezone;
    private int tzHour;
    private int tzMin;

    public DateAndTime(String string) throws ParseException {
        String string2;
        String string3 = null;
        if (string.endsWith("Z")) {
            string2 = string.substring(0, string.length() - 1);
            this.timezone = false;
        } else if (string.lastIndexOf("-") > 8) {
            string2 = string.substring(0, string.lastIndexOf("-"));
            string3 = string.substring(string.lastIndexOf("-"));
        } else if (string.lastIndexOf("+") > 8) {
            string2 = string.substring(0, string.lastIndexOf("+"));
            string3 = string.substring(string.lastIndexOf("+"));
        } else {
            string2 = string;
            string3 = null;
            this.timezone = null;
        }
        int n = 0;
        try {
            int n2;
            int n3 = n2 = string2.startsWith("-") ? string2.substring(1).indexOf("-") + 1 : string2.indexOf("-");
            if (n2 == -1) {
                n2 = 4;
            }
            this.setYear(DateAndTime.readField(string2, 0, n2));
            n = n2;
            if (string2.length() >= n2 + 3) {
                this.setMonth(DateAndTime.readField(string2, n2 + 1, 2));
            }
            n = n2 + 4;
            if (string2.length() >= n2 + 6) {
                this.setDay(DateAndTime.readField(string2, n2 + 4, 2));
            }
            n = n2 + 7;
            if (string2.length() >= n2 + 9) {
                this.setHour(DateAndTime.readField(string2, n2 + 7, 2));
            }
            n = n2 + 10;
            if (string2.length() >= n2 + 12) {
                this.setMinute(DateAndTime.readField(string2, n2 + 10, 2));
            }
            n = n2 + 13;
            if (string2.length() >= n2 + 15) {
                this.setSecond(DateAndTime.readField(string2, n2 + 13, 2));
            }
            n = n2 + 16;
            if (string2.length() >= n2 + 17) {
                this.setFractions(string2.length() - (n2 + 16));
                this.setFraction(DateAndTime.readField(string2, n2 + 16, this.fractions));
            }
            if (string3 != null) {
                this.setTzHour(DateAndTime.readField(string3, 0, 3));
                this.setTzMin(DateAndTime.readField(string3, 4, 2));
            }
        }
        catch (Exception exception) {
            throw new ParseException("The date '" + string + "' is not a valid Date Time Format at character " + Integer.toString(n), n);
        }
    }

    private static int readField(String string, int n, int n2) {
        String string2 = string.substring(n, n + n2);
        return Integer.parseInt(string2);
    }

    public DateAndTime(Calendar calendar) {
        this.setCalendar(calendar);
    }

    private void setCalendar(Calendar calendar) {
        this.setYear(calendar.get(1));
        this.setMonth(calendar.get(2) + 1);
        this.setDay(calendar.get(5));
        this.setHour(calendar.get(11));
        this.setMinute(calendar.get(12));
        this.setSecond(calendar.get(13));
        if (calendar.get(14) > 0) {
            this.setFractions(3);
            try {
                this.setFraction(calendar.get(14));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (calendar.getTimeZone() != null) {
            int n = calendar.getTimeZone().getOffset(calendar.getTime().getTime());
            this.setTzHour(n / 3600000);
            this.setTzMin((n -= this.tzHour * 60 * 60 * 1000) / 60000);
        }
    }

    public DateAndTime(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.setCalendar(gregorianCalendar);
    }

    private DateAndTime() {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Utilities.padLeft(Integer.toString(this.year), '0', 4));
        if (this.month != 0) {
            stringBuilder.append("-");
            stringBuilder.append(Utilities.padLeft(Integer.toString(this.month), '0', 2));
            if (this.day != 0) {
                stringBuilder.append("-");
                stringBuilder.append(Utilities.padLeft(Integer.toString(this.day), '0', 2));
                if (this.time) {
                    stringBuilder.append("T");
                    stringBuilder.append(Utilities.padLeft(Integer.toString(this.hour), '0', 2));
                    stringBuilder.append(":");
                    stringBuilder.append(Utilities.padLeft(Integer.toString(this.minute), '0', 2));
                    if (this.seconds) {
                        stringBuilder.append(":");
                        stringBuilder.append(Utilities.padLeft(Integer.toString(this.second), '0', 2));
                        if (this.fractions > 0) {
                            stringBuilder.append(".");
                            stringBuilder.append(Utilities.padLeft(Integer.toString(this.fraction), '0', this.fractions));
                        }
                    }
                }
                if (this.timezone != null) {
                    if (!this.timezone.booleanValue()) {
                        stringBuilder.append("Z");
                    } else {
                        if (this.tzHour > 0) {
                            stringBuilder.append("+");
                            stringBuilder.append(Utilities.padLeft(Integer.toString(this.tzHour), '0', 2));
                        } else {
                            stringBuilder.append("-");
                            stringBuilder.append(Utilities.padLeft(Integer.toString(-this.tzHour), '0', 2));
                        }
                        stringBuilder.append(":");
                        stringBuilder.append(Utilities.padLeft(Integer.toString(this.tzMin), '0', 2));
                    }
                }
            }
        }
        return stringBuilder.toString();
    }

    public Calendar toCalendar() {
        Calendar calendar = null;
        if (this.timezone == null) {
            calendar = Calendar.getInstance();
        } else {
            TimeZone timeZone = this.timezone == false ? TimeZone.getTimeZone("GMT + 00 : 00") : (this.tzHour < 0 ? TimeZone.getTimeZone("GMT - " + Utilities.padLeft(Integer.toString(-this.tzHour), '0', 2) + " : " + Integer.toString(this.tzMin, 2)) : TimeZone.getTimeZone("GMT + " + Utilities.padLeft(Integer.toString(this.tzHour), '0', 2) + " : " + Integer.toString(this.tzMin, 2)));
            calendar = Calendar.getInstance(timeZone);
        }
        calendar.set(1, this.year);
        if (this.month > 0) {
            calendar.set(2, this.month);
            if (this.day > 0) {
                calendar.set(5, this.day);
                if (this.time) {
                    calendar.set(10, this.hour);
                    calendar.set(12, this.minute);
                    if (this.seconds) {
                        calendar.set(13, this.second);
                    }
                }
            }
        }
        return calendar;
    }

    public Date toDate() {
        return null;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int n) {
        this.year = n;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int n) {
        this.month = n;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int n) {
        this.day = n;
    }

    public boolean isTime() {
        return this.time;
    }

    public void setTime(boolean bl) {
        this.time = bl;
        if (!bl) {
            this.setSeconds(false);
        }
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int n) {
        this.time = true;
        this.hour = n;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int n) {
        this.time = true;
        this.minute = n;
    }

    public boolean isSeconds() {
        return this.seconds;
    }

    public void setSeconds(boolean bl) {
        this.seconds = bl;
        if (!bl) {
            this.setFractions(0);
        }
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int n) {
        this.time = true;
        this.seconds = true;
        this.second = n;
    }

    public int getFractions() {
        return this.fractions;
    }

    public void setFractions(int n) {
        this.fractions = n;
    }

    public int getFraction() {
        return this.fraction;
    }

    public void setFraction(int n) throws Exception {
        this.fraction = n;
        if (this.fraction == 0) {
            throw new Exception("set 'fractions' before setting 'fraction'");
        }
    }

    public Boolean getTimezone() {
        return this.timezone;
    }

    public void setTimezone(Boolean bl) {
        this.timezone = bl;
    }

    public int getTzHour() {
        return this.tzHour;
    }

    public void setTzHour(int n) {
        this.tzHour = n;
        this.timezone = true;
    }

    public int getTzMin() {
        return this.tzMin;
    }

    public void setTzMin(int n) {
        this.tzMin = n;
        this.timezone = true;
    }

    public static DateAndTime now() {
        return new DateAndTime(Calendar.getInstance());
    }

    public static DateAndTime parseV3(String string) throws ParseException {
        String string2;
        DateAndTime dateAndTime = new DateAndTime();
        String string3 = null;
        if (string.endsWith("Z")) {
            string2 = string.substring(0, string.length() - 1);
            dateAndTime.timezone = false;
        } else if (string.lastIndexOf("-") > 0) {
            string2 = string.substring(0, string.lastIndexOf("-"));
            string3 = string.substring(string.lastIndexOf("-"));
        } else if (string.lastIndexOf("+") > 0) {
            string2 = string.substring(0, string.lastIndexOf("+"));
            string3 = string.substring(string.lastIndexOf("+"));
        } else {
            string2 = string;
            string3 = null;
            dateAndTime.timezone = null;
        }
        int n = 0;
        try {
            dateAndTime.setYear(DateAndTime.readField(string2, 0, 4));
            n = 4;
            if (string2.length() >= 6) {
                dateAndTime.setMonth(DateAndTime.readField(string2, 4, 2));
            }
            n = 6;
            if (string2.length() >= 8) {
                dateAndTime.setDay(DateAndTime.readField(string2, 6, 2));
            }
            n = 8;
            if (string2.length() >= 10) {
                dateAndTime.setHour(DateAndTime.readField(string2, 8, 2));
            }
            n = 10;
            if (string2.length() >= 12) {
                dateAndTime.setMinute(DateAndTime.readField(string2, 10, 2));
            }
            n = 12;
            if (string2.length() >= 14) {
                dateAndTime.setSecond(DateAndTime.readField(string2, 12, 2));
            }
            n = 15;
            if (string2.length() >= 16) {
                dateAndTime.setFractions(string2.length() - 15);
                dateAndTime.setFraction(DateAndTime.readField(string2, 15, dateAndTime.fractions));
            }
            if (string3 != null) {
                dateAndTime.setTzHour(DateAndTime.readField(string3, 0, 3));
                dateAndTime.setTzMin(DateAndTime.readField(string3, 3, 2));
            }
        }
        catch (Exception exception) {
            throw new ParseException("The date '" + string + "' is not a valid Date Time Format at character " + Integer.toString(n), n);
        }
        return dateAndTime;
    }

    public DateAndTime expandTime() {
        this.time = true;
        this.seconds = true;
        this.timezone = true;
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getOffset(new Date().getTime());
        this.setTzHour(n / 3600000);
        this.setTzMin((n -= this.tzHour * 60 * 60 * 1000) / 60000);
        return this;
    }

    public String toHumanDisplay() {
        if (this.isTime()) {
            return Integer.toString(this.day) + "-" + this.getMonthCode() + " " + Integer.toString(this.getYear()) + " " + Integer.toString(this.hour) + ":" + Integer.toString(this.minute);
        }
        return Integer.toString(this.day) + "-" + this.getMonthCode() + " " + Integer.toString(this.getYear());
    }

    private String getMonthCode() {
        switch (this.month) {
            case 1: {
                return "Jan";
            }
            case 2: {
                return "Feb";
            }
            case 3: {
                return "Mar";
            }
            case 4: {
                return "Apr";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "Jun";
            }
            case 7: {
                return "Jul";
            }
            case 8: {
                return "Aug";
            }
            case 9: {
                return "Sep";
            }
            case 10: {
                return "Oct";
            }
            case 11: {
                return "Nov";
            }
            case 12: {
                return "Dec";
            }
        }
        return null;
    }

    public void add(int n, int n2) {
        switch (n) {
            case 1: {
                this.year += n2;
                break;
            }
            case 2: {
                int n3 = this.month + n2;
                this.month = n3 % 12;
                if (n3 >= 0 && n3 < 12) break;
                this.add(1, n3 / 12);
                break;
            }
            case 6: {
                int n4 = this.day + n2;
                this.day = n4 % 30;
                if (n4 >= 0 && n4 < 30) break;
                this.add(1, n4 / 30);
                break;
            }
            case 10: {
                int n5 = this.hour + n2;
                this.time = true;
                this.hour = n5 % 24;
                if (n5 >= 0 && n5 < 24) break;
                this.add(6, n5 / 24);
                break;
            }
            case 12: {
                int n6 = this.minute + n2;
                this.time = true;
                this.minute = n6 % 60;
                if (n6 >= 0 && n6 < 60) break;
                this.add(10, n6 / 60);
                break;
            }
            case 13: {
                int n7 = this.second + n2;
                this.seconds = true;
                this.second = n7 % 60;
                if (n7 >= 0 && n7 < 60) break;
                this.add(12, n7 / 60);
            }
        }
    }

    public boolean before(DateAndTime dateAndTime) {
        if (this.year != dateAndTime.year) {
            return this.year < dateAndTime.year;
        }
        if (this.month != dateAndTime.month) {
            return this.month < dateAndTime.month;
        }
        if (this.day != dateAndTime.day) {
            return this.day < dateAndTime.day;
        }
        if (this.hour != dateAndTime.hour) {
            return this.hour < dateAndTime.hour;
        }
        if (this.minute != dateAndTime.minute) {
            return this.minute < dateAndTime.minute;
        }
        if (this.second != dateAndTime.second) {
            return this.second < dateAndTime.second;
        }
        if (this.fraction != dateAndTime.fraction) {
            return this.fraction < dateAndTime.fraction;
        }
        return false;
    }
}

