/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Location;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.UriType;

public class Device
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected CodeableConcept type;
    protected StringType manufacturer;
    protected StringType model;
    protected StringType version;
    protected DateType expiry;
    protected StringType udi;
    protected StringType lotNumber;
    protected ResourceReference owner;
    protected Organization ownerTarget;
    protected ResourceReference location;
    protected Location locationTarget;
    protected ResourceReference patient;
    protected Patient patientTarget;
    protected List<Contact> contact = new ArrayList<Contact>();
    protected UriType url;
    private static final long serialVersionUID = 1596756464L;

    public Device() {
    }

    public Device(CodeableConcept codeableConcept) {
        this.type = codeableConcept;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Device setType(CodeableConcept codeableConcept) {
        this.type = codeableConcept;
        return this;
    }

    public StringType getManufacturer() {
        return this.manufacturer;
    }

    public Device setManufacturer(StringType stringType) {
        this.manufacturer = stringType;
        return this;
    }

    public String getManufacturerSimple() {
        return this.manufacturer == null ? null : this.manufacturer.getValue();
    }

    public Device setManufacturerSimple(String string) {
        if (string == null) {
            this.manufacturer = null;
        } else {
            if (this.manufacturer == null) {
                this.manufacturer = new StringType();
            }
            this.manufacturer.setValue(string);
        }
        return this;
    }

    public StringType getModel() {
        return this.model;
    }

    public Device setModel(StringType stringType) {
        this.model = stringType;
        return this;
    }

    public String getModelSimple() {
        return this.model == null ? null : this.model.getValue();
    }

    public Device setModelSimple(String string) {
        if (string == null) {
            this.model = null;
        } else {
            if (this.model == null) {
                this.model = new StringType();
            }
            this.model.setValue(string);
        }
        return this;
    }

    public StringType getVersion() {
        return this.version;
    }

    public Device setVersion(StringType stringType) {
        this.version = stringType;
        return this;
    }

    public String getVersionSimple() {
        return this.version == null ? null : this.version.getValue();
    }

    public Device setVersionSimple(String string) {
        if (string == null) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(string);
        }
        return this;
    }

    public DateType getExpiry() {
        return this.expiry;
    }

    public Device setExpiry(DateType dateType) {
        this.expiry = dateType;
        return this;
    }

    public DateAndTime getExpirySimple() {
        return this.expiry == null ? null : this.expiry.getValue();
    }

    public Device setExpirySimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.expiry = null;
        } else {
            if (this.expiry == null) {
                this.expiry = new DateType();
            }
            this.expiry.setValue(dateAndTime);
        }
        return this;
    }

    public StringType getUdi() {
        return this.udi;
    }

    public Device setUdi(StringType stringType) {
        this.udi = stringType;
        return this;
    }

    public String getUdiSimple() {
        return this.udi == null ? null : this.udi.getValue();
    }

    public Device setUdiSimple(String string) {
        if (string == null) {
            this.udi = null;
        } else {
            if (this.udi == null) {
                this.udi = new StringType();
            }
            this.udi.setValue(string);
        }
        return this;
    }

    public StringType getLotNumber() {
        return this.lotNumber;
    }

    public Device setLotNumber(StringType stringType) {
        this.lotNumber = stringType;
        return this;
    }

    public String getLotNumberSimple() {
        return this.lotNumber == null ? null : this.lotNumber.getValue();
    }

    public Device setLotNumberSimple(String string) {
        if (string == null) {
            this.lotNumber = null;
        } else {
            if (this.lotNumber == null) {
                this.lotNumber = new StringType();
            }
            this.lotNumber.setValue(string);
        }
        return this;
    }

    public ResourceReference getOwner() {
        return this.owner;
    }

    public Device setOwner(ResourceReference resourceReference) {
        this.owner = resourceReference;
        return this;
    }

    public Organization getOwnerTarget() {
        return this.ownerTarget;
    }

    public Device setOwnerTarget(Organization organization) {
        this.ownerTarget = organization;
        return this;
    }

    public ResourceReference getLocation() {
        return this.location;
    }

    public Device setLocation(ResourceReference resourceReference) {
        this.location = resourceReference;
        return this;
    }

    public Location getLocationTarget() {
        return this.locationTarget;
    }

    public Device setLocationTarget(Location location) {
        this.locationTarget = location;
        return this;
    }

    public ResourceReference getPatient() {
        return this.patient;
    }

    public Device setPatient(ResourceReference resourceReference) {
        this.patient = resourceReference;
        return this;
    }

    public Patient getPatientTarget() {
        return this.patientTarget;
    }

    public Device setPatientTarget(Patient patient) {
        this.patientTarget = patient;
        return this;
    }

    public List<Contact> getContact() {
        return this.contact;
    }

    public Contact addContact() {
        Contact contact = new Contact();
        this.contact.add(contact);
        return contact;
    }

    public UriType getUrl() {
        return this.url;
    }

    public Device setUrl(UriType uriType) {
        this.url = uriType;
        return this;
    }

    public String getUrlSimple() {
        return this.url == null ? null : this.url.getValue();
    }

    public Device setUrlSimple(String string) {
        if (string == null) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(string);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "Identifiers assigned to this device by various organizations. The most likely organizations to assign identifiers are the manufacturer and the owner, though regulatory agencies may also assign an identifier. The identifiers identify the particular device, not the kind of device.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("type", "CodeableConcept", "A kind of this device.", 0, Integer.MAX_VALUE, this.type));
        list.add(new Property("manufacturer", "string", "A name of the manufacturer.", 0, Integer.MAX_VALUE, this.manufacturer));
        list.add(new Property("model", "string", "The 'model' - an identifier assigned by the manufacturer to identify the product by its type. This number is shared by the all devices sold as the same type.", 0, Integer.MAX_VALUE, this.model));
        list.add(new Property("version", "string", "The version of the device, if the device has multiple releases under the same model, or if the device is software or carries firmware.", 0, Integer.MAX_VALUE, this.version));
        list.add(new Property("expiry", "date", "Date of expiry of this device (if applicable).", 0, Integer.MAX_VALUE, this.expiry));
        list.add(new Property("udi", "string", "FDA Mandated Unique Device Identifier. Use the human readable information (the content that the user sees, which is sometimes different to the exact syntax represented in the barcode)  - see http://www.fda.gov/MedicalDevices/DeviceRegulationandGuidance/UniqueDeviceIdentification/default.htm.", 0, Integer.MAX_VALUE, this.udi));
        list.add(new Property("lotNumber", "string", "Lot number assigned by the manufacturer.", 0, Integer.MAX_VALUE, this.lotNumber));
        list.add(new Property("owner", "Resource(Organization)", "An organization that is responsible for the provision and ongoing maintenance of the device.", 0, Integer.MAX_VALUE, this.owner));
        list.add(new Property("location", "Resource(Location)", "The resource may be found in a literal location (i.e. GPS coordinates), a logical place (i.e. 'in/with the patient'), or a coded location.", 0, Integer.MAX_VALUE, this.location));
        list.add(new Property("patient", "Resource(Patient)", "Patient information, if the resource is affixed to a person.", 0, Integer.MAX_VALUE, this.patient));
        list.add(new Property("contact", "Contact", "Contact details for an organization or a particular human that is responsible for the device.", 0, Integer.MAX_VALUE, this.contact));
        list.add(new Property("url", "uri", "A network address on which the device may be contacted directly.", 0, Integer.MAX_VALUE, this.url));
    }

    public Device copy() {
        Device device = new Device();
        device.identifier = new ArrayList<Identifier>();
        for (Identifier type : this.identifier) {
            device.identifier.add(type.copy());
        }
        device.type = this.type == null ? null : this.type.copy();
        device.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        device.model = this.model == null ? null : this.model.copy();
        device.version = this.version == null ? null : this.version.copy();
        device.expiry = this.expiry == null ? null : this.expiry.copy();
        device.udi = this.udi == null ? null : this.udi.copy();
        device.lotNumber = this.lotNumber == null ? null : this.lotNumber.copy();
        device.owner = this.owner == null ? null : this.owner.copy();
        device.location = this.location == null ? null : this.location.copy();
        device.patient = this.patient == null ? null : this.patient.copy();
        device.contact = new ArrayList<Contact>();
        for (Contact contact : this.contact) {
            device.contact.add(contact.copy());
        }
        device.url = this.url == null ? null : this.url.copy();
        return device;
    }

    protected Device typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Device;
    }
}

