/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.Device;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.Observation;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;

public class DeviceObservationReport
extends Resource {
    protected InstantType instant;
    protected Identifier identifier;
    protected ResourceReference source;
    protected Device sourceTarget;
    protected ResourceReference subject;
    protected Resource subjectTarget;
    protected List<DeviceObservationReportVirtualDeviceComponent> virtualDevice = new ArrayList<DeviceObservationReportVirtualDeviceComponent>();
    private static final long serialVersionUID = -1068505466L;

    public DeviceObservationReport() {
    }

    public DeviceObservationReport(InstantType instantType, ResourceReference resourceReference) {
        this.instant = instantType;
        this.source = resourceReference;
    }

    public InstantType getInstant() {
        return this.instant;
    }

    public DeviceObservationReport setInstant(InstantType instantType) {
        this.instant = instantType;
        return this;
    }

    public DateAndTime getInstantSimple() {
        return this.instant == null ? null : this.instant.getValue();
    }

    public DeviceObservationReport setInstantSimple(DateAndTime dateAndTime) {
        if (this.instant == null) {
            this.instant = new InstantType();
        }
        this.instant.setValue(dateAndTime);
        return this;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public DeviceObservationReport setIdentifier(Identifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public ResourceReference getSource() {
        return this.source;
    }

    public DeviceObservationReport setSource(ResourceReference resourceReference) {
        this.source = resourceReference;
        return this;
    }

    public Device getSourceTarget() {
        return this.sourceTarget;
    }

    public DeviceObservationReport setSourceTarget(Device device) {
        this.sourceTarget = device;
        return this;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public DeviceObservationReport setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public DeviceObservationReport setSubjectTarget(Resource resource) {
        this.subjectTarget = resource;
        return this;
    }

    public List<DeviceObservationReportVirtualDeviceComponent> getVirtualDevice() {
        return this.virtualDevice;
    }

    public DeviceObservationReportVirtualDeviceComponent addVirtualDevice() {
        DeviceObservationReportVirtualDeviceComponent deviceObservationReportVirtualDeviceComponent = new DeviceObservationReportVirtualDeviceComponent();
        this.virtualDevice.add(deviceObservationReportVirtualDeviceComponent);
        return deviceObservationReportVirtualDeviceComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("instant", "instant", "The point in time that the values are reported.", 0, Integer.MAX_VALUE, this.instant));
        list.add(new Property("identifier", "Identifier", "An identifier assigned to this observation bu the source device that made the observation.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("source", "Resource(Device)", "Identification information for the device that is the source of the data.", 0, Integer.MAX_VALUE, this.source));
        list.add(new Property("subject", "Resource(Patient|Device|Location)", "The subject of the measurement.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("virtualDevice", "", "A medical-related subsystem of a medical device.", 0, Integer.MAX_VALUE, this.virtualDevice));
    }

    public DeviceObservationReport copy() {
        DeviceObservationReport deviceObservationReport = new DeviceObservationReport();
        deviceObservationReport.instant = this.instant == null ? null : this.instant.copy();
        deviceObservationReport.identifier = this.identifier == null ? null : this.identifier.copy();
        deviceObservationReport.source = this.source == null ? null : this.source.copy();
        deviceObservationReport.subject = this.subject == null ? null : this.subject.copy();
        deviceObservationReport.virtualDevice = new ArrayList<DeviceObservationReportVirtualDeviceComponent>();
        for (DeviceObservationReportVirtualDeviceComponent deviceObservationReportVirtualDeviceComponent : this.virtualDevice) {
            deviceObservationReport.virtualDevice.add(deviceObservationReportVirtualDeviceComponent.copy());
        }
        return deviceObservationReport;
    }

    protected DeviceObservationReport typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DeviceObservationReport;
    }

    public static class DeviceObservationReportVirtualDeviceChannelMetricComponent
    extends BackboneElement {
        protected ResourceReference observation;
        protected Observation observationTarget;
        private static final long serialVersionUID = -753705470L;

        public DeviceObservationReportVirtualDeviceChannelMetricComponent() {
        }

        public DeviceObservationReportVirtualDeviceChannelMetricComponent(ResourceReference resourceReference) {
            this.observation = resourceReference;
        }

        public ResourceReference getObservation() {
            return this.observation;
        }

        public DeviceObservationReportVirtualDeviceChannelMetricComponent setObservation(ResourceReference resourceReference) {
            this.observation = resourceReference;
            return this;
        }

        public Observation getObservationTarget() {
            return this.observationTarget;
        }

        public DeviceObservationReportVirtualDeviceChannelMetricComponent setObservationTarget(Observation observation) {
            this.observationTarget = observation;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("observation", "Resource(Observation)", "The data for the metric.", 0, Integer.MAX_VALUE, this.observation));
        }

        public DeviceObservationReportVirtualDeviceChannelMetricComponent copy() {
            DeviceObservationReportVirtualDeviceChannelMetricComponent deviceObservationReportVirtualDeviceChannelMetricComponent = new DeviceObservationReportVirtualDeviceChannelMetricComponent();
            deviceObservationReportVirtualDeviceChannelMetricComponent.observation = this.observation == null ? null : this.observation.copy();
            return deviceObservationReportVirtualDeviceChannelMetricComponent;
        }
    }

    public static class DeviceObservationReportVirtualDeviceChannelComponent
    extends BackboneElement {
        protected CodeableConcept code;
        protected List<DeviceObservationReportVirtualDeviceChannelMetricComponent> metric = new ArrayList<DeviceObservationReportVirtualDeviceChannelMetricComponent>();
        private static final long serialVersionUID = 1868788989L;

        public CodeableConcept getCode() {
            return this.code;
        }

        public DeviceObservationReportVirtualDeviceChannelComponent setCode(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
            return this;
        }

        public List<DeviceObservationReportVirtualDeviceChannelMetricComponent> getMetric() {
            return this.metric;
        }

        public DeviceObservationReportVirtualDeviceChannelMetricComponent addMetric() {
            DeviceObservationReportVirtualDeviceChannelMetricComponent deviceObservationReportVirtualDeviceChannelMetricComponent = new DeviceObservationReportVirtualDeviceChannelMetricComponent();
            this.metric.add(deviceObservationReportVirtualDeviceChannelMetricComponent);
            return deviceObservationReportVirtualDeviceChannelMetricComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "CodeableConcept", "Describes the channel.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("metric", "", "A piece of measured or derived data that is reported by the machine.", 0, Integer.MAX_VALUE, this.metric));
        }

        public DeviceObservationReportVirtualDeviceChannelComponent copy() {
            DeviceObservationReportVirtualDeviceChannelComponent deviceObservationReportVirtualDeviceChannelComponent = new DeviceObservationReportVirtualDeviceChannelComponent();
            deviceObservationReportVirtualDeviceChannelComponent.code = this.code == null ? null : this.code.copy();
            deviceObservationReportVirtualDeviceChannelComponent.metric = new ArrayList<DeviceObservationReportVirtualDeviceChannelMetricComponent>();
            for (DeviceObservationReportVirtualDeviceChannelMetricComponent deviceObservationReportVirtualDeviceChannelMetricComponent : this.metric) {
                deviceObservationReportVirtualDeviceChannelComponent.metric.add(deviceObservationReportVirtualDeviceChannelMetricComponent.copy());
            }
            return deviceObservationReportVirtualDeviceChannelComponent;
        }
    }

    public static class DeviceObservationReportVirtualDeviceComponent
    extends BackboneElement {
        protected CodeableConcept code;
        protected List<DeviceObservationReportVirtualDeviceChannelComponent> channel = new ArrayList<DeviceObservationReportVirtualDeviceChannelComponent>();
        private static final long serialVersionUID = -396624204L;

        public CodeableConcept getCode() {
            return this.code;
        }

        public DeviceObservationReportVirtualDeviceComponent setCode(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
            return this;
        }

        public List<DeviceObservationReportVirtualDeviceChannelComponent> getChannel() {
            return this.channel;
        }

        public DeviceObservationReportVirtualDeviceChannelComponent addChannel() {
            DeviceObservationReportVirtualDeviceChannelComponent deviceObservationReportVirtualDeviceChannelComponent = new DeviceObservationReportVirtualDeviceChannelComponent();
            this.channel.add(deviceObservationReportVirtualDeviceChannelComponent);
            return deviceObservationReportVirtualDeviceChannelComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "CodeableConcept", "Describes the compartment.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("channel", "", "Groups together physiological measurement data and derived data.", 0, Integer.MAX_VALUE, this.channel));
        }

        public DeviceObservationReportVirtualDeviceComponent copy() {
            DeviceObservationReportVirtualDeviceComponent deviceObservationReportVirtualDeviceComponent = new DeviceObservationReportVirtualDeviceComponent();
            deviceObservationReportVirtualDeviceComponent.code = this.code == null ? null : this.code.copy();
            deviceObservationReportVirtualDeviceComponent.channel = new ArrayList<DeviceObservationReportVirtualDeviceChannelComponent>();
            for (DeviceObservationReportVirtualDeviceChannelComponent deviceObservationReportVirtualDeviceChannelComponent : this.channel) {
                deviceObservationReportVirtualDeviceComponent.channel.add(deviceObservationReportVirtualDeviceChannelComponent.copy());
            }
            return deviceObservationReportVirtualDeviceComponent;
        }
    }
}

