/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.Encounter;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.Specimen;
import org.hl7.fhir.instance.model.StringType;

public class DiagnosticOrder
extends Resource {
    protected ResourceReference subject;
    protected Resource subjectTarget;
    protected ResourceReference orderer;
    protected Practitioner ordererTarget;
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected ResourceReference encounter;
    protected Encounter encounterTarget;
    protected StringType clinicalNotes;
    protected List<ResourceReference> specimen = new ArrayList<ResourceReference>();
    protected List<Specimen> specimenTarget = new ArrayList<Specimen>();
    protected Enumeration<DiagnosticOrderStatus> status;
    protected Enumeration<DiagnosticOrderPriority> priority;
    protected List<DiagnosticOrderEventComponent> event = new ArrayList<DiagnosticOrderEventComponent>();
    protected List<DiagnosticOrderItemComponent> item = new ArrayList<DiagnosticOrderItemComponent>();
    private static final long serialVersionUID = -424750256L;

    public DiagnosticOrder() {
    }

    public DiagnosticOrder(ResourceReference resourceReference) {
        this.subject = resourceReference;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public DiagnosticOrder setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public DiagnosticOrder setSubjectTarget(Resource resource) {
        this.subjectTarget = resource;
        return this;
    }

    public ResourceReference getOrderer() {
        return this.orderer;
    }

    public DiagnosticOrder setOrderer(ResourceReference resourceReference) {
        this.orderer = resourceReference;
        return this;
    }

    public Practitioner getOrdererTarget() {
        return this.ordererTarget;
    }

    public DiagnosticOrder setOrdererTarget(Practitioner practitioner) {
        this.ordererTarget = practitioner;
        return this;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public ResourceReference getEncounter() {
        return this.encounter;
    }

    public DiagnosticOrder setEncounter(ResourceReference resourceReference) {
        this.encounter = resourceReference;
        return this;
    }

    public Encounter getEncounterTarget() {
        return this.encounterTarget;
    }

    public DiagnosticOrder setEncounterTarget(Encounter encounter) {
        this.encounterTarget = encounter;
        return this;
    }

    public StringType getClinicalNotes() {
        return this.clinicalNotes;
    }

    public DiagnosticOrder setClinicalNotes(StringType stringType) {
        this.clinicalNotes = stringType;
        return this;
    }

    public String getClinicalNotesSimple() {
        return this.clinicalNotes == null ? null : this.clinicalNotes.getValue();
    }

    public DiagnosticOrder setClinicalNotesSimple(String string) {
        if (string == null) {
            this.clinicalNotes = null;
        } else {
            if (this.clinicalNotes == null) {
                this.clinicalNotes = new StringType();
            }
            this.clinicalNotes.setValue(string);
        }
        return this;
    }

    public List<ResourceReference> getSpecimen() {
        return this.specimen;
    }

    public ResourceReference addSpecimen() {
        ResourceReference resourceReference = new ResourceReference();
        this.specimen.add(resourceReference);
        return resourceReference;
    }

    public List<Specimen> getSpecimenTarget() {
        return this.specimenTarget;
    }

    public Specimen addSpecimenTarget() {
        Specimen specimen = new Specimen();
        this.specimenTarget.add(specimen);
        return specimen;
    }

    public Enumeration<DiagnosticOrderStatus> getStatus() {
        return this.status;
    }

    public DiagnosticOrder setStatus(Enumeration<DiagnosticOrderStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public DiagnosticOrderStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public DiagnosticOrder setStatusSimple(DiagnosticOrderStatus diagnosticOrderStatus) {
        if (diagnosticOrderStatus == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration();
            }
            this.status.setValue(diagnosticOrderStatus);
        }
        return this;
    }

    public Enumeration<DiagnosticOrderPriority> getPriority() {
        return this.priority;
    }

    public DiagnosticOrder setPriority(Enumeration<DiagnosticOrderPriority> enumeration) {
        this.priority = enumeration;
        return this;
    }

    public DiagnosticOrderPriority getPrioritySimple() {
        return this.priority == null ? null : this.priority.getValue();
    }

    public DiagnosticOrder setPrioritySimple(DiagnosticOrderPriority diagnosticOrderPriority) {
        if (diagnosticOrderPriority == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration();
            }
            this.priority.setValue(diagnosticOrderPriority);
        }
        return this;
    }

    public List<DiagnosticOrderEventComponent> getEvent() {
        return this.event;
    }

    public DiagnosticOrderEventComponent addEvent() {
        DiagnosticOrderEventComponent diagnosticOrderEventComponent = new DiagnosticOrderEventComponent();
        this.event.add(diagnosticOrderEventComponent);
        return diagnosticOrderEventComponent;
    }

    public List<DiagnosticOrderItemComponent> getItem() {
        return this.item;
    }

    public DiagnosticOrderItemComponent addItem() {
        DiagnosticOrderItemComponent diagnosticOrderItemComponent = new DiagnosticOrderItemComponent();
        this.item.add(diagnosticOrderItemComponent);
        return diagnosticOrderItemComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("subject", "Resource(Patient|Group|Location|Device)", "Who or what the investigation is to be performed on. This is usually a human patient, but diagnostic tests can also be requested on animals, groups of humans or animals, devices such as dialysis machines, or even locations (typically for environmental scans).", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("orderer", "Resource(Practitioner)", "The practitioner that holds legal responsibility for ordering the investigation.", 0, Integer.MAX_VALUE, this.orderer));
        list.add(new Property("identifier", "Identifier", "Identifiers assigned to this order by the order or by the receiver.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("encounter", "Resource(Encounter)", "An encounter that provides additional informaton about the healthcare context in which this request is made.", 0, Integer.MAX_VALUE, this.encounter));
        list.add(new Property("clinicalNotes", "string", "An explanation or justification for why this diagnostic investigation is being requested.", 0, Integer.MAX_VALUE, this.clinicalNotes));
        list.add(new Property("specimen", "Resource(Specimen)", "One or more specimens that the diagnostic investigation is about.", 0, Integer.MAX_VALUE, this.specimen));
        list.add(new Property("status", "code", "The status of the order.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("priority", "code", "The clinical priority associated with this order.", 0, Integer.MAX_VALUE, this.priority));
        list.add(new Property("event", "", "A summary of the events of interest that have occurred as the request is processed. E.g. when the order was made, various processing steps (specimens received), when it was completed.", 0, Integer.MAX_VALUE, this.event));
        list.add(new Property("item", "", "The specific diagnostic investigations that are requested as part of this request. Sometimes, there can only be one item per request, but in most contexts, more than one investigation can be requested.", 0, Integer.MAX_VALUE, this.item));
    }

    public DiagnosticOrder copy() {
        DiagnosticOrder diagnosticOrder = new DiagnosticOrder();
        diagnosticOrder.subject = this.subject == null ? null : this.subject.copy();
        diagnosticOrder.orderer = this.orderer == null ? null : this.orderer.copy();
        diagnosticOrder.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            diagnosticOrder.identifier.add(element.copy());
        }
        diagnosticOrder.encounter = this.encounter == null ? null : this.encounter.copy();
        diagnosticOrder.clinicalNotes = this.clinicalNotes == null ? null : this.clinicalNotes.copy();
        diagnosticOrder.specimen = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.specimen) {
            diagnosticOrder.specimen.add(resourceReference.copy());
        }
        diagnosticOrder.status = this.status == null ? null : this.status.copy();
        diagnosticOrder.priority = this.priority == null ? null : this.priority.copy();
        diagnosticOrder.event = new ArrayList<DiagnosticOrderEventComponent>();
        for (DiagnosticOrderEventComponent diagnosticOrderEventComponent : this.event) {
            diagnosticOrder.event.add(diagnosticOrderEventComponent.copy());
        }
        diagnosticOrder.item = new ArrayList<DiagnosticOrderItemComponent>();
        for (DiagnosticOrderItemComponent diagnosticOrderItemComponent : this.item) {
            diagnosticOrder.item.add(diagnosticOrderItemComponent.copy());
        }
        return diagnosticOrder;
    }

    protected DiagnosticOrder typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DiagnosticOrder;
    }

    public static class DiagnosticOrderItemComponent
    extends BackboneElement {
        protected CodeableConcept code;
        protected List<ResourceReference> specimen = new ArrayList<ResourceReference>();
        protected List<Specimen> specimenTarget = new ArrayList<Specimen>();
        protected CodeableConcept bodySite;
        protected Enumeration<DiagnosticOrderStatus> status;
        protected List<DiagnosticOrderEventComponent> event = new ArrayList<DiagnosticOrderEventComponent>();
        private static final long serialVersionUID = -326190686L;

        public DiagnosticOrderItemComponent() {
        }

        public DiagnosticOrderItemComponent(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public DiagnosticOrderItemComponent setCode(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
            return this;
        }

        public List<ResourceReference> getSpecimen() {
            return this.specimen;
        }

        public ResourceReference addSpecimen() {
            ResourceReference resourceReference = new ResourceReference();
            this.specimen.add(resourceReference);
            return resourceReference;
        }

        public List<Specimen> getSpecimenTarget() {
            return this.specimenTarget;
        }

        public Specimen addSpecimenTarget() {
            Specimen specimen = new Specimen();
            this.specimenTarget.add(specimen);
            return specimen;
        }

        public CodeableConcept getBodySite() {
            return this.bodySite;
        }

        public DiagnosticOrderItemComponent setBodySite(CodeableConcept codeableConcept) {
            this.bodySite = codeableConcept;
            return this;
        }

        public Enumeration<DiagnosticOrderStatus> getStatus() {
            return this.status;
        }

        public DiagnosticOrderItemComponent setStatus(Enumeration<DiagnosticOrderStatus> enumeration) {
            this.status = enumeration;
            return this;
        }

        public DiagnosticOrderStatus getStatusSimple() {
            return this.status == null ? null : this.status.getValue();
        }

        public DiagnosticOrderItemComponent setStatusSimple(DiagnosticOrderStatus diagnosticOrderStatus) {
            if (diagnosticOrderStatus == null) {
                this.status = null;
            } else {
                if (this.status == null) {
                    this.status = new Enumeration();
                }
                this.status.setValue(diagnosticOrderStatus);
            }
            return this;
        }

        public List<DiagnosticOrderEventComponent> getEvent() {
            return this.event;
        }

        public DiagnosticOrderEventComponent addEvent() {
            DiagnosticOrderEventComponent diagnosticOrderEventComponent = new DiagnosticOrderEventComponent();
            this.event.add(diagnosticOrderEventComponent);
            return diagnosticOrderEventComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "CodeableConcept", "A code that identifies a particular diagnostic investigation, or panel of investigations, that have been requested.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("specimen", "Resource(Specimen)", "If the item is related to a specific speciment.", 0, Integer.MAX_VALUE, this.specimen));
            list.add(new Property("bodySite", "CodeableConcept", "Anatomical location where the request test should be performed.", 0, Integer.MAX_VALUE, this.bodySite));
            list.add(new Property("status", "code", "The status of this individual item within the order.", 0, Integer.MAX_VALUE, this.status));
            list.add(new Property("event", "@DiagnosticOrder.event", "A summary of the events of interest that have occurred as this item of the request is processed.", 0, Integer.MAX_VALUE, this.event));
        }

        public DiagnosticOrderItemComponent copy() {
            DiagnosticOrderItemComponent diagnosticOrderItemComponent = new DiagnosticOrderItemComponent();
            diagnosticOrderItemComponent.code = this.code == null ? null : this.code.copy();
            diagnosticOrderItemComponent.specimen = new ArrayList<ResourceReference>();
            for (ResourceReference element : this.specimen) {
                diagnosticOrderItemComponent.specimen.add(element.copy());
            }
            diagnosticOrderItemComponent.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            diagnosticOrderItemComponent.status = this.status == null ? null : this.status.copy();
            diagnosticOrderItemComponent.event = new ArrayList<DiagnosticOrderEventComponent>();
            for (DiagnosticOrderEventComponent diagnosticOrderEventComponent : this.event) {
                diagnosticOrderItemComponent.event.add(diagnosticOrderEventComponent.copy());
            }
            return diagnosticOrderItemComponent;
        }
    }

    public static class DiagnosticOrderEventComponent
    extends BackboneElement {
        protected Enumeration<DiagnosticOrderStatus> status;
        protected CodeableConcept description;
        protected DateTimeType dateTime;
        protected ResourceReference actor;
        protected Resource actorTarget;
        private static final long serialVersionUID = -2127877353L;

        public DiagnosticOrderEventComponent() {
        }

        public DiagnosticOrderEventComponent(Enumeration<DiagnosticOrderStatus> enumeration, DateTimeType dateTimeType) {
            this.status = enumeration;
            this.dateTime = dateTimeType;
        }

        public Enumeration<DiagnosticOrderStatus> getStatus() {
            return this.status;
        }

        public DiagnosticOrderEventComponent setStatus(Enumeration<DiagnosticOrderStatus> enumeration) {
            this.status = enumeration;
            return this;
        }

        public DiagnosticOrderStatus getStatusSimple() {
            return this.status == null ? null : this.status.getValue();
        }

        public DiagnosticOrderEventComponent setStatusSimple(DiagnosticOrderStatus diagnosticOrderStatus) {
            if (this.status == null) {
                this.status = new Enumeration();
            }
            this.status.setValue(diagnosticOrderStatus);
            return this;
        }

        public CodeableConcept getDescription() {
            return this.description;
        }

        public DiagnosticOrderEventComponent setDescription(CodeableConcept codeableConcept) {
            this.description = codeableConcept;
            return this;
        }

        public DateTimeType getDateTime() {
            return this.dateTime;
        }

        public DiagnosticOrderEventComponent setDateTime(DateTimeType dateTimeType) {
            this.dateTime = dateTimeType;
            return this;
        }

        public DateAndTime getDateTimeSimple() {
            return this.dateTime == null ? null : this.dateTime.getValue();
        }

        public DiagnosticOrderEventComponent setDateTimeSimple(DateAndTime dateAndTime) {
            if (this.dateTime == null) {
                this.dateTime = new DateTimeType();
            }
            this.dateTime.setValue(dateAndTime);
            return this;
        }

        public ResourceReference getActor() {
            return this.actor;
        }

        public DiagnosticOrderEventComponent setActor(ResourceReference resourceReference) {
            this.actor = resourceReference;
            return this;
        }

        public Resource getActorTarget() {
            return this.actorTarget;
        }

        public DiagnosticOrderEventComponent setActorTarget(Resource resource) {
            this.actorTarget = resource;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("status", "code", "The status for the event.", 0, Integer.MAX_VALUE, this.status));
            list.add(new Property("description", "CodeableConcept", "Additional information about the event that occurred - e.g. if the status remained unchanged.", 0, Integer.MAX_VALUE, this.description));
            list.add(new Property("dateTime", "dateTime", "The date/time at which the event occurred.", 0, Integer.MAX_VALUE, this.dateTime));
            list.add(new Property("actor", "Resource(Practitioner|Device)", "The person who was responsible for performing or recording the action.", 0, Integer.MAX_VALUE, this.actor));
        }

        public DiagnosticOrderEventComponent copy() {
            DiagnosticOrderEventComponent diagnosticOrderEventComponent = new DiagnosticOrderEventComponent();
            diagnosticOrderEventComponent.status = this.status == null ? null : this.status.copy();
            diagnosticOrderEventComponent.description = this.description == null ? null : this.description.copy();
            diagnosticOrderEventComponent.dateTime = this.dateTime == null ? null : this.dateTime.copy();
            diagnosticOrderEventComponent.actor = this.actor == null ? null : this.actor.copy();
            return diagnosticOrderEventComponent;
        }
    }

    public static class DiagnosticOrderPriorityEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("routine".equals(string)) {
                return DiagnosticOrderPriority.routine;
            }
            if ("urgent".equals(string)) {
                return DiagnosticOrderPriority.urgent;
            }
            if ("stat".equals(string)) {
                return DiagnosticOrderPriority.stat;
            }
            if ("asap".equals(string)) {
                return DiagnosticOrderPriority.asap;
            }
            throw new Exception("Unknown DiagnosticOrderPriority code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == DiagnosticOrderPriority.routine) {
                return "routine";
            }
            if (enum_ == DiagnosticOrderPriority.urgent) {
                return "urgent";
            }
            if (enum_ == DiagnosticOrderPriority.stat) {
                return "stat";
            }
            if (enum_ == DiagnosticOrderPriority.asap) {
                return "asap";
            }
            return "?";
        }
    }

    public static enum DiagnosticOrderPriority {
        routine,
        urgent,
        stat,
        asap,
        Null;


        public static DiagnosticOrderPriority fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("routine".equals(string)) {
                return routine;
            }
            if ("urgent".equals(string)) {
                return urgent;
            }
            if ("stat".equals(string)) {
                return stat;
            }
            if ("asap".equals(string)) {
                return asap;
            }
            throw new Exception("Unknown DiagnosticOrderPriority code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case routine: {
                    return "routine";
                }
                case urgent: {
                    return "urgent";
                }
                case stat: {
                    return "stat";
                }
                case asap: {
                    return "asap";
                }
            }
            return "?";
        }
    }

    public static class DiagnosticOrderStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("requested".equals(string)) {
                return DiagnosticOrderStatus.requested;
            }
            if ("received".equals(string)) {
                return DiagnosticOrderStatus.received;
            }
            if ("accepted".equals(string)) {
                return DiagnosticOrderStatus.accepted;
            }
            if ("in progress".equals(string)) {
                return DiagnosticOrderStatus.inProgress;
            }
            if ("review".equals(string)) {
                return DiagnosticOrderStatus.review;
            }
            if ("completed".equals(string)) {
                return DiagnosticOrderStatus.completed;
            }
            if ("suspended".equals(string)) {
                return DiagnosticOrderStatus.suspended;
            }
            if ("rejected".equals(string)) {
                return DiagnosticOrderStatus.rejected;
            }
            if ("failed".equals(string)) {
                return DiagnosticOrderStatus.failed;
            }
            throw new Exception("Unknown DiagnosticOrderStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == DiagnosticOrderStatus.requested) {
                return "requested";
            }
            if (enum_ == DiagnosticOrderStatus.received) {
                return "received";
            }
            if (enum_ == DiagnosticOrderStatus.accepted) {
                return "accepted";
            }
            if (enum_ == DiagnosticOrderStatus.inProgress) {
                return "in progress";
            }
            if (enum_ == DiagnosticOrderStatus.review) {
                return "review";
            }
            if (enum_ == DiagnosticOrderStatus.completed) {
                return "completed";
            }
            if (enum_ == DiagnosticOrderStatus.suspended) {
                return "suspended";
            }
            if (enum_ == DiagnosticOrderStatus.rejected) {
                return "rejected";
            }
            if (enum_ == DiagnosticOrderStatus.failed) {
                return "failed";
            }
            return "?";
        }
    }

    public static enum DiagnosticOrderStatus {
        requested,
        received,
        accepted,
        inProgress,
        review,
        completed,
        suspended,
        rejected,
        failed,
        Null;


        public static DiagnosticOrderStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("requested".equals(string)) {
                return requested;
            }
            if ("received".equals(string)) {
                return received;
            }
            if ("accepted".equals(string)) {
                return accepted;
            }
            if ("in progress".equals(string)) {
                return inProgress;
            }
            if ("review".equals(string)) {
                return review;
            }
            if ("completed".equals(string)) {
                return completed;
            }
            if ("suspended".equals(string)) {
                return suspended;
            }
            if ("rejected".equals(string)) {
                return rejected;
            }
            if ("failed".equals(string)) {
                return failed;
            }
            throw new Exception("Unknown DiagnosticOrderStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case requested: {
                    return "requested";
                }
                case received: {
                    return "received";
                }
                case accepted: {
                    return "accepted";
                }
                case inProgress: {
                    return "in progress";
                }
                case review: {
                    return "review";
                }
                case completed: {
                    return "completed";
                }
                case suspended: {
                    return "suspended";
                }
                case rejected: {
                    return "rejected";
                }
                case failed: {
                    return "failed";
                }
            }
            return "?";
        }
    }
}

