/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DiagnosticOrder;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.ImagingStudy;
import org.hl7.fhir.instance.model.Media;
import org.hl7.fhir.instance.model.Observation;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.Specimen;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;

public class DiagnosticReport
extends Resource {
    protected CodeableConcept name;
    protected Enumeration<DiagnosticReportStatus> status;
    protected DateTimeType issued;
    protected ResourceReference subject;
    protected Resource subjectTarget;
    protected ResourceReference performer;
    protected Resource performerTarget;
    protected Identifier identifier;
    protected List<ResourceReference> requestDetail = new ArrayList<ResourceReference>();
    protected List<DiagnosticOrder> requestDetailTarget = new ArrayList<DiagnosticOrder>();
    protected CodeableConcept serviceCategory;
    protected Type diagnostic;
    protected List<ResourceReference> specimen = new ArrayList<ResourceReference>();
    protected List<Specimen> specimenTarget = new ArrayList<Specimen>();
    protected List<ResourceReference> result = new ArrayList<ResourceReference>();
    protected List<Observation> resultTarget = new ArrayList<Observation>();
    protected List<ResourceReference> imagingStudy = new ArrayList<ResourceReference>();
    protected List<ImagingStudy> imagingStudyTarget = new ArrayList<ImagingStudy>();
    protected List<DiagnosticReportImageComponent> image = new ArrayList<DiagnosticReportImageComponent>();
    protected StringType conclusion;
    protected List<CodeableConcept> codedDiagnosis = new ArrayList<CodeableConcept>();
    protected List<Attachment> presentedForm = new ArrayList<Attachment>();
    private static final long serialVersionUID = -117351753L;

    public DiagnosticReport() {
    }

    public DiagnosticReport(CodeableConcept codeableConcept, Enumeration<DiagnosticReportStatus> enumeration, DateTimeType dateTimeType, ResourceReference resourceReference, ResourceReference resourceReference2, Type type) {
        this.name = codeableConcept;
        this.status = enumeration;
        this.issued = dateTimeType;
        this.subject = resourceReference;
        this.performer = resourceReference2;
        this.diagnostic = type;
    }

    public CodeableConcept getName() {
        return this.name;
    }

    public DiagnosticReport setName(CodeableConcept codeableConcept) {
        this.name = codeableConcept;
        return this;
    }

    public Enumeration<DiagnosticReportStatus> getStatus() {
        return this.status;
    }

    public DiagnosticReport setStatus(Enumeration<DiagnosticReportStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public DiagnosticReportStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public DiagnosticReport setStatusSimple(DiagnosticReportStatus diagnosticReportStatus) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(diagnosticReportStatus);
        return this;
    }

    public DateTimeType getIssued() {
        return this.issued;
    }

    public DiagnosticReport setIssued(DateTimeType dateTimeType) {
        this.issued = dateTimeType;
        return this;
    }

    public DateAndTime getIssuedSimple() {
        return this.issued == null ? null : this.issued.getValue();
    }

    public DiagnosticReport setIssuedSimple(DateAndTime dateAndTime) {
        if (this.issued == null) {
            this.issued = new DateTimeType();
        }
        this.issued.setValue(dateAndTime);
        return this;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public DiagnosticReport setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public DiagnosticReport setSubjectTarget(Resource resource) {
        this.subjectTarget = resource;
        return this;
    }

    public ResourceReference getPerformer() {
        return this.performer;
    }

    public DiagnosticReport setPerformer(ResourceReference resourceReference) {
        this.performer = resourceReference;
        return this;
    }

    public Resource getPerformerTarget() {
        return this.performerTarget;
    }

    public DiagnosticReport setPerformerTarget(Resource resource) {
        this.performerTarget = resource;
        return this;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public DiagnosticReport setIdentifier(Identifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public List<ResourceReference> getRequestDetail() {
        return this.requestDetail;
    }

    public ResourceReference addRequestDetail() {
        ResourceReference resourceReference = new ResourceReference();
        this.requestDetail.add(resourceReference);
        return resourceReference;
    }

    public List<DiagnosticOrder> getRequestDetailTarget() {
        return this.requestDetailTarget;
    }

    public DiagnosticOrder addRequestDetailTarget() {
        DiagnosticOrder diagnosticOrder = new DiagnosticOrder();
        this.requestDetailTarget.add(diagnosticOrder);
        return diagnosticOrder;
    }

    public CodeableConcept getServiceCategory() {
        return this.serviceCategory;
    }

    public DiagnosticReport setServiceCategory(CodeableConcept codeableConcept) {
        this.serviceCategory = codeableConcept;
        return this;
    }

    public Type getDiagnostic() {
        return this.diagnostic;
    }

    public DiagnosticReport setDiagnostic(Type type) {
        this.diagnostic = type;
        return this;
    }

    public List<ResourceReference> getSpecimen() {
        return this.specimen;
    }

    public ResourceReference addSpecimen() {
        ResourceReference resourceReference = new ResourceReference();
        this.specimen.add(resourceReference);
        return resourceReference;
    }

    public List<Specimen> getSpecimenTarget() {
        return this.specimenTarget;
    }

    public Specimen addSpecimenTarget() {
        Specimen specimen = new Specimen();
        this.specimenTarget.add(specimen);
        return specimen;
    }

    public List<ResourceReference> getResult() {
        return this.result;
    }

    public ResourceReference addResult() {
        ResourceReference resourceReference = new ResourceReference();
        this.result.add(resourceReference);
        return resourceReference;
    }

    public List<Observation> getResultTarget() {
        return this.resultTarget;
    }

    public Observation addResultTarget() {
        Observation observation = new Observation();
        this.resultTarget.add(observation);
        return observation;
    }

    public List<ResourceReference> getImagingStudy() {
        return this.imagingStudy;
    }

    public ResourceReference addImagingStudy() {
        ResourceReference resourceReference = new ResourceReference();
        this.imagingStudy.add(resourceReference);
        return resourceReference;
    }

    public List<ImagingStudy> getImagingStudyTarget() {
        return this.imagingStudyTarget;
    }

    public ImagingStudy addImagingStudyTarget() {
        ImagingStudy imagingStudy = new ImagingStudy();
        this.imagingStudyTarget.add(imagingStudy);
        return imagingStudy;
    }

    public List<DiagnosticReportImageComponent> getImage() {
        return this.image;
    }

    public DiagnosticReportImageComponent addImage() {
        DiagnosticReportImageComponent diagnosticReportImageComponent = new DiagnosticReportImageComponent();
        this.image.add(diagnosticReportImageComponent);
        return diagnosticReportImageComponent;
    }

    public StringType getConclusion() {
        return this.conclusion;
    }

    public DiagnosticReport setConclusion(StringType stringType) {
        this.conclusion = stringType;
        return this;
    }

    public String getConclusionSimple() {
        return this.conclusion == null ? null : this.conclusion.getValue();
    }

    public DiagnosticReport setConclusionSimple(String string) {
        if (string == null) {
            this.conclusion = null;
        } else {
            if (this.conclusion == null) {
                this.conclusion = new StringType();
            }
            this.conclusion.setValue(string);
        }
        return this;
    }

    public List<CodeableConcept> getCodedDiagnosis() {
        return this.codedDiagnosis;
    }

    public CodeableConcept addCodedDiagnosis() {
        CodeableConcept codeableConcept = new CodeableConcept();
        this.codedDiagnosis.add(codeableConcept);
        return codeableConcept;
    }

    public List<Attachment> getPresentedForm() {
        return this.presentedForm;
    }

    public Attachment addPresentedForm() {
        Attachment attachment = new Attachment();
        this.presentedForm.add(attachment);
        return attachment;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("name", "CodeableConcept", "A code or name that describes this diagnostic report.", 0, Integer.MAX_VALUE, this.name));
        list.add(new Property("status", "code", "The status of the diagnostic report as a whole.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("issued", "dateTime", "The date and/or time that this version of the report was released from the source diagnostic service.", 0, Integer.MAX_VALUE, this.issued));
        list.add(new Property("subject", "Resource(Patient|Group|Device|Location)", "The subject of the report. Usually, but not always, this is a patient. However diagnostic services also perform analyses on specimens collected from a variety of other sources.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("performer", "Resource(Practitioner|Organization)", "The diagnostic service that is responsible for issuing the report.", 0, Integer.MAX_VALUE, this.performer));
        list.add(new Property("identifier", "Identifier", "The local ID assigned to the report by the order filler, usually by the Information System of the diagnostic service provider.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("requestDetail", "Resource(DiagnosticOrder)", "Details concerning a test requested.", 0, Integer.MAX_VALUE, this.requestDetail));
        list.add(new Property("serviceCategory", "CodeableConcept", "The section of the diagnostic service that performs the examination e.g. biochemistry, hematology, MRI.", 0, Integer.MAX_VALUE, this.serviceCategory));
        list.add(new Property("diagnostic[x]", "dateTime|Period", "The time or time-period the observed values are related to. This is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.", 0, Integer.MAX_VALUE, this.diagnostic));
        list.add(new Property("specimen", "Resource(Specimen)", "Details about the specimens on which this Disagnostic report is based.", 0, Integer.MAX_VALUE, this.specimen));
        list.add(new Property("result", "Resource(Observation)", "Observations that are part of this diagnostic report. Observations can be simple name/value pairs (e.g. 'atomic' results), or they can be grouping observations that include references to other members of the group (e.g. 'panels').", 0, Integer.MAX_VALUE, this.result));
        list.add(new Property("imagingStudy", "Resource(ImagingStudy)", "One or more links to full details of any imaging performed during the diagnostic investigation. Typically, this is imaging performed by DICOM enabled modalities, but this is not required. A fully enabled PACS viewer can use this information to provide views of the source images.", 0, Integer.MAX_VALUE, this.imagingStudy));
        list.add(new Property("image", "", "A list of key images associated with this report. The images are generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest).", 0, Integer.MAX_VALUE, this.image));
        list.add(new Property("conclusion", "string", "Concise and clinically contextualized narrative interpretation of the diagnostic report.", 0, Integer.MAX_VALUE, this.conclusion));
        list.add(new Property("codedDiagnosis", "CodeableConcept", "Codes for the conclusion.", 0, Integer.MAX_VALUE, this.codedDiagnosis));
        list.add(new Property("presentedForm", "Attachment", "Rich text representation of the entire result as issued by the diagnostic service. Multiple formats are allowed but they SHALL be semantically equivalent.", 0, Integer.MAX_VALUE, this.presentedForm));
    }

    public DiagnosticReport copy() {
        DiagnosticReport diagnosticReport = new DiagnosticReport();
        diagnosticReport.name = this.name == null ? null : this.name.copy();
        diagnosticReport.status = this.status == null ? null : this.status.copy();
        diagnosticReport.issued = this.issued == null ? null : this.issued.copy();
        diagnosticReport.subject = this.subject == null ? null : this.subject.copy();
        diagnosticReport.performer = this.performer == null ? null : this.performer.copy();
        diagnosticReport.identifier = this.identifier == null ? null : this.identifier.copy();
        diagnosticReport.requestDetail = new ArrayList<ResourceReference>();
        for (ResourceReference element : this.requestDetail) {
            diagnosticReport.requestDetail.add(element.copy());
        }
        diagnosticReport.serviceCategory = this.serviceCategory == null ? null : this.serviceCategory.copy();
        diagnosticReport.diagnostic = this.diagnostic == null ? null : this.diagnostic.copy();
        diagnosticReport.specimen = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.specimen) {
            diagnosticReport.specimen.add(resourceReference.copy());
        }
        diagnosticReport.result = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.result) {
            diagnosticReport.result.add(resourceReference.copy());
        }
        diagnosticReport.imagingStudy = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.imagingStudy) {
            diagnosticReport.imagingStudy.add(resourceReference.copy());
        }
        diagnosticReport.image = new ArrayList<DiagnosticReportImageComponent>();
        for (DiagnosticReportImageComponent diagnosticReportImageComponent : this.image) {
            diagnosticReport.image.add(diagnosticReportImageComponent.copy());
        }
        diagnosticReport.conclusion = this.conclusion == null ? null : this.conclusion.copy();
        diagnosticReport.codedDiagnosis = new ArrayList<CodeableConcept>();
        for (CodeableConcept codeableConcept : this.codedDiagnosis) {
            diagnosticReport.codedDiagnosis.add(codeableConcept.copy());
        }
        diagnosticReport.presentedForm = new ArrayList<Attachment>();
        for (Attachment attachment : this.presentedForm) {
            diagnosticReport.presentedForm.add(attachment.copy());
        }
        return diagnosticReport;
    }

    protected DiagnosticReport typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DiagnosticReport;
    }

    public static class DiagnosticReportImageComponent
    extends BackboneElement {
        protected StringType comment;
        protected ResourceReference link;
        protected Media linkTarget;
        private static final long serialVersionUID = -910272270L;

        public DiagnosticReportImageComponent() {
        }

        public DiagnosticReportImageComponent(ResourceReference resourceReference) {
            this.link = resourceReference;
        }

        public StringType getComment() {
            return this.comment;
        }

        public DiagnosticReportImageComponent setComment(StringType stringType) {
            this.comment = stringType;
            return this;
        }

        public String getCommentSimple() {
            return this.comment == null ? null : this.comment.getValue();
        }

        public DiagnosticReportImageComponent setCommentSimple(String string) {
            if (string == null) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(string);
            }
            return this;
        }

        public ResourceReference getLink() {
            return this.link;
        }

        public DiagnosticReportImageComponent setLink(ResourceReference resourceReference) {
            this.link = resourceReference;
            return this;
        }

        public Media getLinkTarget() {
            return this.linkTarget;
        }

        public DiagnosticReportImageComponent setLinkTarget(Media media) {
            this.linkTarget = media;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("comment", "string", "A comment about the image. Typically, this is used to provide an explanation for why the image is included, or to draw the viewer's attention to important features.", 0, Integer.MAX_VALUE, this.comment));
            list.add(new Property("link", "Resource(Media)", "Reference to the image source.", 0, Integer.MAX_VALUE, this.link));
        }

        public DiagnosticReportImageComponent copy() {
            DiagnosticReportImageComponent diagnosticReportImageComponent = new DiagnosticReportImageComponent();
            diagnosticReportImageComponent.comment = this.comment == null ? null : this.comment.copy();
            diagnosticReportImageComponent.link = this.link == null ? null : this.link.copy();
            return diagnosticReportImageComponent;
        }
    }

    public static class DiagnosticReportStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("registered".equals(string)) {
                return DiagnosticReportStatus.registered;
            }
            if ("partial".equals(string)) {
                return DiagnosticReportStatus.partial;
            }
            if ("final".equals(string)) {
                return DiagnosticReportStatus.final_;
            }
            if ("corrected".equals(string)) {
                return DiagnosticReportStatus.corrected;
            }
            if ("amended".equals(string)) {
                return DiagnosticReportStatus.amended;
            }
            if ("appended".equals(string)) {
                return DiagnosticReportStatus.appended;
            }
            if ("cancelled".equals(string)) {
                return DiagnosticReportStatus.cancelled;
            }
            if ("entered in error".equals(string)) {
                return DiagnosticReportStatus.enteredInError;
            }
            throw new Exception("Unknown DiagnosticReportStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == DiagnosticReportStatus.registered) {
                return "registered";
            }
            if (enum_ == DiagnosticReportStatus.partial) {
                return "partial";
            }
            if (enum_ == DiagnosticReportStatus.final_) {
                return "final";
            }
            if (enum_ == DiagnosticReportStatus.corrected) {
                return "corrected";
            }
            if (enum_ == DiagnosticReportStatus.amended) {
                return "amended";
            }
            if (enum_ == DiagnosticReportStatus.appended) {
                return "appended";
            }
            if (enum_ == DiagnosticReportStatus.cancelled) {
                return "cancelled";
            }
            if (enum_ == DiagnosticReportStatus.enteredInError) {
                return "entered in error";
            }
            return "?";
        }
    }

    public static enum DiagnosticReportStatus {
        registered,
        partial,
        final_,
        corrected,
        amended,
        appended,
        cancelled,
        enteredInError,
        Null;


        public static DiagnosticReportStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("registered".equals(string)) {
                return registered;
            }
            if ("partial".equals(string)) {
                return partial;
            }
            if ("final".equals(string)) {
                return final_;
            }
            if ("corrected".equals(string)) {
                return corrected;
            }
            if ("amended".equals(string)) {
                return amended;
            }
            if ("appended".equals(string)) {
                return appended;
            }
            if ("cancelled".equals(string)) {
                return cancelled;
            }
            if ("entered in error".equals(string)) {
                return enteredInError;
            }
            throw new Exception("Unknown DiagnosticReportStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case registered: {
                    return "registered";
                }
                case partial: {
                    return "partial";
                }
                case final_: {
                    return "final";
                }
                case corrected: {
                    return "corrected";
                }
                case amended: {
                    return "amended";
                }
                case appended: {
                    return "appended";
                }
                case cancelled: {
                    return "cancelled";
                }
                case enteredInError: {
                    return "entered in error";
                }
            }
            return "?";
        }
    }
}

