/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.UriType;

public class DocumentManifest
extends Resource {
    protected Identifier masterIdentifier;
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected List<ResourceReference> subject = new ArrayList<ResourceReference>();
    protected List<Resource> subjectTarget = new ArrayList<Resource>();
    protected List<ResourceReference> recipient = new ArrayList<ResourceReference>();
    protected List<Resource> recipientTarget = new ArrayList<Resource>();
    protected CodeableConcept type;
    protected List<ResourceReference> author = new ArrayList<ResourceReference>();
    protected List<Resource> authorTarget = new ArrayList<Resource>();
    protected DateTimeType created;
    protected UriType source;
    protected Enumeration<DocumentReferenceStatus> status;
    protected ResourceReference supercedes;
    protected DocumentManifest supercedesTarget;
    protected StringType description;
    protected CodeableConcept confidentiality;
    protected List<ResourceReference> content = new ArrayList<ResourceReference>();
    protected List<Resource> contentTarget = new ArrayList<Resource>();
    private static final long serialVersionUID = -1745022706L;

    public DocumentManifest() {
    }

    public DocumentManifest(Identifier identifier, Enumeration<DocumentReferenceStatus> enumeration) {
        this.masterIdentifier = identifier;
        this.status = enumeration;
    }

    public Identifier getMasterIdentifier() {
        return this.masterIdentifier;
    }

    public DocumentManifest setMasterIdentifier(Identifier identifier) {
        this.masterIdentifier = identifier;
        return this;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public List<ResourceReference> getSubject() {
        return this.subject;
    }

    public ResourceReference addSubject() {
        ResourceReference resourceReference = new ResourceReference();
        this.subject.add(resourceReference);
        return resourceReference;
    }

    public List<Resource> getSubjectTarget() {
        return this.subjectTarget;
    }

    public List<ResourceReference> getRecipient() {
        return this.recipient;
    }

    public ResourceReference addRecipient() {
        ResourceReference resourceReference = new ResourceReference();
        this.recipient.add(resourceReference);
        return resourceReference;
    }

    public List<Resource> getRecipientTarget() {
        return this.recipientTarget;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public DocumentManifest setType(CodeableConcept codeableConcept) {
        this.type = codeableConcept;
        return this;
    }

    public List<ResourceReference> getAuthor() {
        return this.author;
    }

    public ResourceReference addAuthor() {
        ResourceReference resourceReference = new ResourceReference();
        this.author.add(resourceReference);
        return resourceReference;
    }

    public List<Resource> getAuthorTarget() {
        return this.authorTarget;
    }

    public DateTimeType getCreated() {
        return this.created;
    }

    public DocumentManifest setCreated(DateTimeType dateTimeType) {
        this.created = dateTimeType;
        return this;
    }

    public DateAndTime getCreatedSimple() {
        return this.created == null ? null : this.created.getValue();
    }

    public DocumentManifest setCreatedSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(dateAndTime);
        }
        return this;
    }

    public UriType getSource() {
        return this.source;
    }

    public DocumentManifest setSource(UriType uriType) {
        this.source = uriType;
        return this;
    }

    public String getSourceSimple() {
        return this.source == null ? null : this.source.getValue();
    }

    public DocumentManifest setSourceSimple(String string) {
        if (string == null) {
            this.source = null;
        } else {
            if (this.source == null) {
                this.source = new UriType();
            }
            this.source.setValue(string);
        }
        return this;
    }

    public Enumeration<DocumentReferenceStatus> getStatus() {
        return this.status;
    }

    public DocumentManifest setStatus(Enumeration<DocumentReferenceStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public DocumentReferenceStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public DocumentManifest setStatusSimple(DocumentReferenceStatus documentReferenceStatus) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(documentReferenceStatus);
        return this;
    }

    public ResourceReference getSupercedes() {
        return this.supercedes;
    }

    public DocumentManifest setSupercedes(ResourceReference resourceReference) {
        this.supercedes = resourceReference;
        return this;
    }

    public DocumentManifest getSupercedesTarget() {
        return this.supercedesTarget;
    }

    public DocumentManifest setSupercedesTarget(DocumentManifest documentManifest) {
        this.supercedesTarget = documentManifest;
        return this;
    }

    public StringType getDescription() {
        return this.description;
    }

    public DocumentManifest setDescription(StringType stringType) {
        this.description = stringType;
        return this;
    }

    public String getDescriptionSimple() {
        return this.description == null ? null : this.description.getValue();
    }

    public DocumentManifest setDescriptionSimple(String string) {
        if (string == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(string);
        }
        return this;
    }

    public CodeableConcept getConfidentiality() {
        return this.confidentiality;
    }

    public DocumentManifest setConfidentiality(CodeableConcept codeableConcept) {
        this.confidentiality = codeableConcept;
        return this;
    }

    public List<ResourceReference> getContent() {
        return this.content;
    }

    public ResourceReference addContent() {
        ResourceReference resourceReference = new ResourceReference();
        this.content.add(resourceReference);
        return resourceReference;
    }

    public List<Resource> getContentTarget() {
        return this.contentTarget;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("masterIdentifier", "Identifier", "A single identifier that uniquely identifies this manifest. Principally used to refer to the manifest in non-FHIR contexts.", 0, Integer.MAX_VALUE, this.masterIdentifier));
        list.add(new Property("identifier", "Identifier", "Other identifiers associated with the document, including version independent, source record and workflow related identifiers.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("subject", "Resource(Patient|Practitioner|Group|Device)", "Who or what the set of documents is about. The documents can be about a person, (patient or healthcare practitioner), a device (i.e. machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure). If the documents cross more than one subject, then more than one subject is allowed here (unusual use case).", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("recipient", "Resource(Patient|Practitioner|Organization)", "A patient, practitioner, or organization for which this set of documents is intended.", 0, Integer.MAX_VALUE, this.recipient));
        list.add(new Property("type", "CodeableConcept", "Specifies the kind of this set of documents (e.g. Patient Summary, Discharge Summary, Prescription, etc.). The type of a set of documents may be the same as one of the documents in it - especially if there is only one - but it may be wider.", 0, Integer.MAX_VALUE, this.type));
        list.add(new Property("author", "Resource(Practitioner|Device|Patient|RelatedPerson)", "Identifies who is responsible for adding the information to the document.", 0, Integer.MAX_VALUE, this.author));
        list.add(new Property("created", "dateTime", "When the document manifest was created for submission to the server (not necessarily the same thing as the actual resource last modified time, since it may be modified, replicated etc).", 0, Integer.MAX_VALUE, this.created));
        list.add(new Property("source", "uri", "Identifies the source system, application, or software that produced the document manifest.", 0, Integer.MAX_VALUE, this.source));
        list.add(new Property("status", "code", "The status of this document manifest.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("supercedes", "Resource(DocumentManifest)", "Whether this document manifest replaces another.", 0, Integer.MAX_VALUE, this.supercedes));
        list.add(new Property("description", "string", "Human-readable description of the source document. This is sometimes known as the 'title'.", 0, Integer.MAX_VALUE, this.description));
        list.add(new Property("confidentiality", "CodeableConcept", "A code specifying the level of confidentiality of this set of Documents.", 0, Integer.MAX_VALUE, this.confidentiality));
        list.add(new Property("content", "Resource(DocumentReference|Binary|Media)", "The list of resources that describe the parts of this document reference. Usually, these would be document references, but direct references to binary attachments and images are also allowed.", 0, Integer.MAX_VALUE, this.content));
    }

    public DocumentManifest copy() {
        DocumentManifest documentManifest = new DocumentManifest();
        documentManifest.masterIdentifier = this.masterIdentifier == null ? null : this.masterIdentifier.copy();
        documentManifest.identifier = new ArrayList<Identifier>();
        for (Identifier type : this.identifier) {
            documentManifest.identifier.add(type.copy());
        }
        documentManifest.subject = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.subject) {
            documentManifest.subject.add(resourceReference.copy());
        }
        documentManifest.recipient = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.recipient) {
            documentManifest.recipient.add(resourceReference.copy());
        }
        documentManifest.type = this.type == null ? null : this.type.copy();
        documentManifest.author = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.author) {
            documentManifest.author.add(resourceReference.copy());
        }
        documentManifest.created = this.created == null ? null : this.created.copy();
        documentManifest.source = this.source == null ? null : this.source.copy();
        documentManifest.status = this.status == null ? null : this.status.copy();
        documentManifest.supercedes = this.supercedes == null ? null : this.supercedes.copy();
        documentManifest.description = this.description == null ? null : this.description.copy();
        documentManifest.confidentiality = this.confidentiality == null ? null : this.confidentiality.copy();
        documentManifest.content = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.content) {
            documentManifest.content.add(resourceReference.copy());
        }
        return documentManifest;
    }

    protected DocumentManifest typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DocumentManifest;
    }

    public static class DocumentReferenceStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("current".equals(string)) {
                return DocumentReferenceStatus.current;
            }
            if ("superceded".equals(string)) {
                return DocumentReferenceStatus.superceded;
            }
            if ("entered in error".equals(string)) {
                return DocumentReferenceStatus.enteredInError;
            }
            throw new Exception("Unknown DocumentReferenceStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == DocumentReferenceStatus.current) {
                return "current";
            }
            if (enum_ == DocumentReferenceStatus.superceded) {
                return "superceded";
            }
            if (enum_ == DocumentReferenceStatus.enteredInError) {
                return "entered in error";
            }
            return "?";
        }
    }

    public static enum DocumentReferenceStatus {
        current,
        superceded,
        enteredInError,
        Null;


        public static DocumentReferenceStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("current".equals(string)) {
                return current;
            }
            if ("superceded".equals(string)) {
                return superceded;
            }
            if ("entered in error".equals(string)) {
                return enteredInError;
            }
            throw new Exception("Unknown DocumentReferenceStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case current: {
                    return "current";
                }
                case superceded: {
                    return "superceded";
                }
                case enteredInError: {
                    return "entered in error";
                }
            }
            return "?";
        }
    }
}

