/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.UriType;

public class DocumentReference
extends Resource {
    protected Identifier masterIdentifier;
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected ResourceReference subject;
    protected Resource subjectTarget;
    protected CodeableConcept type;
    protected CodeableConcept class_;
    protected List<ResourceReference> author = new ArrayList<ResourceReference>();
    protected List<Resource> authorTarget = new ArrayList<Resource>();
    protected ResourceReference custodian;
    protected Organization custodianTarget;
    protected UriType policyManager;
    protected ResourceReference authenticator;
    protected Resource authenticatorTarget;
    protected DateTimeType created;
    protected InstantType indexed;
    protected Enumeration<DocumentReferenceStatus> status;
    protected CodeableConcept docStatus;
    protected List<DocumentReferenceRelatesToComponent> relatesTo = new ArrayList<DocumentReferenceRelatesToComponent>();
    protected StringType description;
    protected List<CodeableConcept> confidentiality = new ArrayList<CodeableConcept>();
    protected CodeType primaryLanguage;
    protected CodeType mimeType;
    protected List<UriType> format = new ArrayList<UriType>();
    protected IntegerType size;
    protected StringType hash;
    protected UriType location;
    protected DocumentReferenceServiceComponent service;
    protected DocumentReferenceContextComponent context;
    private static final long serialVersionUID = -1872142526L;

    public DocumentReference() {
    }

    public DocumentReference(Identifier identifier, ResourceReference resourceReference, CodeableConcept codeableConcept, InstantType instantType, Enumeration<DocumentReferenceStatus> enumeration, CodeType codeType) {
        this.masterIdentifier = identifier;
        this.subject = resourceReference;
        this.type = codeableConcept;
        this.indexed = instantType;
        this.status = enumeration;
        this.mimeType = codeType;
    }

    public Identifier getMasterIdentifier() {
        return this.masterIdentifier;
    }

    public DocumentReference setMasterIdentifier(Identifier identifier) {
        this.masterIdentifier = identifier;
        return this;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public DocumentReference setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public DocumentReference setSubjectTarget(Resource resource) {
        this.subjectTarget = resource;
        return this;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public DocumentReference setType(CodeableConcept codeableConcept) {
        this.type = codeableConcept;
        return this;
    }

    public CodeableConcept getClass_() {
        return this.class_;
    }

    public DocumentReference setClass_(CodeableConcept codeableConcept) {
        this.class_ = codeableConcept;
        return this;
    }

    public List<ResourceReference> getAuthor() {
        return this.author;
    }

    public ResourceReference addAuthor() {
        ResourceReference resourceReference = new ResourceReference();
        this.author.add(resourceReference);
        return resourceReference;
    }

    public List<Resource> getAuthorTarget() {
        return this.authorTarget;
    }

    public ResourceReference getCustodian() {
        return this.custodian;
    }

    public DocumentReference setCustodian(ResourceReference resourceReference) {
        this.custodian = resourceReference;
        return this;
    }

    public Organization getCustodianTarget() {
        return this.custodianTarget;
    }

    public DocumentReference setCustodianTarget(Organization organization) {
        this.custodianTarget = organization;
        return this;
    }

    public UriType getPolicyManager() {
        return this.policyManager;
    }

    public DocumentReference setPolicyManager(UriType uriType) {
        this.policyManager = uriType;
        return this;
    }

    public String getPolicyManagerSimple() {
        return this.policyManager == null ? null : this.policyManager.getValue();
    }

    public DocumentReference setPolicyManagerSimple(String string) {
        if (string == null) {
            this.policyManager = null;
        } else {
            if (this.policyManager == null) {
                this.policyManager = new UriType();
            }
            this.policyManager.setValue(string);
        }
        return this;
    }

    public ResourceReference getAuthenticator() {
        return this.authenticator;
    }

    public DocumentReference setAuthenticator(ResourceReference resourceReference) {
        this.authenticator = resourceReference;
        return this;
    }

    public Resource getAuthenticatorTarget() {
        return this.authenticatorTarget;
    }

    public DocumentReference setAuthenticatorTarget(Resource resource) {
        this.authenticatorTarget = resource;
        return this;
    }

    public DateTimeType getCreated() {
        return this.created;
    }

    public DocumentReference setCreated(DateTimeType dateTimeType) {
        this.created = dateTimeType;
        return this;
    }

    public DateAndTime getCreatedSimple() {
        return this.created == null ? null : this.created.getValue();
    }

    public DocumentReference setCreatedSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(dateAndTime);
        }
        return this;
    }

    public InstantType getIndexed() {
        return this.indexed;
    }

    public DocumentReference setIndexed(InstantType instantType) {
        this.indexed = instantType;
        return this;
    }

    public DateAndTime getIndexedSimple() {
        return this.indexed == null ? null : this.indexed.getValue();
    }

    public DocumentReference setIndexedSimple(DateAndTime dateAndTime) {
        if (this.indexed == null) {
            this.indexed = new InstantType();
        }
        this.indexed.setValue(dateAndTime);
        return this;
    }

    public Enumeration<DocumentReferenceStatus> getStatus() {
        return this.status;
    }

    public DocumentReference setStatus(Enumeration<DocumentReferenceStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public DocumentReferenceStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public DocumentReference setStatusSimple(DocumentReferenceStatus documentReferenceStatus) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(documentReferenceStatus);
        return this;
    }

    public CodeableConcept getDocStatus() {
        return this.docStatus;
    }

    public DocumentReference setDocStatus(CodeableConcept codeableConcept) {
        this.docStatus = codeableConcept;
        return this;
    }

    public List<DocumentReferenceRelatesToComponent> getRelatesTo() {
        return this.relatesTo;
    }

    public DocumentReferenceRelatesToComponent addRelatesTo() {
        DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent = new DocumentReferenceRelatesToComponent();
        this.relatesTo.add(documentReferenceRelatesToComponent);
        return documentReferenceRelatesToComponent;
    }

    public StringType getDescription() {
        return this.description;
    }

    public DocumentReference setDescription(StringType stringType) {
        this.description = stringType;
        return this;
    }

    public String getDescriptionSimple() {
        return this.description == null ? null : this.description.getValue();
    }

    public DocumentReference setDescriptionSimple(String string) {
        if (string == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(string);
        }
        return this;
    }

    public List<CodeableConcept> getConfidentiality() {
        return this.confidentiality;
    }

    public CodeableConcept addConfidentiality() {
        CodeableConcept codeableConcept = new CodeableConcept();
        this.confidentiality.add(codeableConcept);
        return codeableConcept;
    }

    public CodeType getPrimaryLanguage() {
        return this.primaryLanguage;
    }

    public DocumentReference setPrimaryLanguage(CodeType codeType) {
        this.primaryLanguage = codeType;
        return this;
    }

    public String getPrimaryLanguageSimple() {
        return this.primaryLanguage == null ? null : this.primaryLanguage.getValue();
    }

    public DocumentReference setPrimaryLanguageSimple(String string) {
        if (string == null) {
            this.primaryLanguage = null;
        } else {
            if (this.primaryLanguage == null) {
                this.primaryLanguage = new CodeType();
            }
            this.primaryLanguage.setValue(string);
        }
        return this;
    }

    public CodeType getMimeType() {
        return this.mimeType;
    }

    public DocumentReference setMimeType(CodeType codeType) {
        this.mimeType = codeType;
        return this;
    }

    public String getMimeTypeSimple() {
        return this.mimeType == null ? null : this.mimeType.getValue();
    }

    public DocumentReference setMimeTypeSimple(String string) {
        if (this.mimeType == null) {
            this.mimeType = new CodeType();
        }
        this.mimeType.setValue(string);
        return this;
    }

    public List<UriType> getFormat() {
        return this.format;
    }

    public UriType addFormat() {
        UriType uriType = new UriType();
        this.format.add(uriType);
        return uriType;
    }

    public UriType addFormatSimple(String string) {
        UriType uriType = new UriType();
        uriType.setValue(string);
        this.format.add(uriType);
        return uriType;
    }

    public boolean hasFormatSimple(String string) {
        for (UriType uriType : this.format) {
            if (!uriType.getValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    public IntegerType getSize() {
        return this.size;
    }

    public DocumentReference setSize(IntegerType integerType) {
        this.size = integerType;
        return this;
    }

    public int getSizeSimple() {
        return this.size == null ? null : Integer.valueOf(this.size.getValue());
    }

    public DocumentReference setSizeSimple(int n) {
        if (n == -1) {
            this.size = null;
        } else {
            if (this.size == null) {
                this.size = new IntegerType();
            }
            this.size.setValue(n);
        }
        return this;
    }

    public StringType getHash() {
        return this.hash;
    }

    public DocumentReference setHash(StringType stringType) {
        this.hash = stringType;
        return this;
    }

    public String getHashSimple() {
        return this.hash == null ? null : this.hash.getValue();
    }

    public DocumentReference setHashSimple(String string) {
        if (string == null) {
            this.hash = null;
        } else {
            if (this.hash == null) {
                this.hash = new StringType();
            }
            this.hash.setValue(string);
        }
        return this;
    }

    public UriType getLocation() {
        return this.location;
    }

    public DocumentReference setLocation(UriType uriType) {
        this.location = uriType;
        return this;
    }

    public String getLocationSimple() {
        return this.location == null ? null : this.location.getValue();
    }

    public DocumentReference setLocationSimple(String string) {
        if (string == null) {
            this.location = null;
        } else {
            if (this.location == null) {
                this.location = new UriType();
            }
            this.location.setValue(string);
        }
        return this;
    }

    public DocumentReferenceServiceComponent getService() {
        return this.service;
    }

    public DocumentReference setService(DocumentReferenceServiceComponent documentReferenceServiceComponent) {
        this.service = documentReferenceServiceComponent;
        return this;
    }

    public DocumentReferenceContextComponent getContext() {
        return this.context;
    }

    public DocumentReference setContext(DocumentReferenceContextComponent documentReferenceContextComponent) {
        this.context = documentReferenceContextComponent;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("masterIdentifier", "Identifier", "Document identifier as assigned by the source of the document. This identifier is specific to this version of the document. This unique identifier may be used elsewhere to identify this version of the document.", 0, Integer.MAX_VALUE, this.masterIdentifier));
        list.add(new Property("identifier", "Identifier", "Other identifiers associated with the document, including version independent, source record and workflow related identifiers.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("subject", "Resource(Patient|Practitioner|Group|Device)", "Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (I.e. machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure).", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("type", "CodeableConcept", "Specifies the particular kind of document (e.g. Patient Summary, Discharge Summary, Prescription, etc.).", 0, Integer.MAX_VALUE, this.type));
        list.add(new Property("class", "CodeableConcept", "A categorization for the type of the document. This may be implied by or derived from the code specified in the Document Type.", 0, Integer.MAX_VALUE, this.class_));
        list.add(new Property("author", "Resource(Practitioner|Device|Patient|RelatedPerson)", "Identifies who is responsible for adding the information to the document.", 0, Integer.MAX_VALUE, this.author));
        list.add(new Property("custodian", "Resource(Organization)", "Identifies the organization or group who is responsible for ongoing maintenance of and access to the document.", 0, Integer.MAX_VALUE, this.custodian));
        list.add(new Property("policyManager", "uri", "A reference to a domain or server that manages policies under which the document is accessed and/or made available.", 0, Integer.MAX_VALUE, this.policyManager));
        list.add(new Property("authenticator", "Resource(Practitioner|Organization)", "Which person or organization authenticates that this document is valid.", 0, Integer.MAX_VALUE, this.authenticator));
        list.add(new Property("created", "dateTime", "When the document was created.", 0, Integer.MAX_VALUE, this.created));
        list.add(new Property("indexed", "instant", "When the document reference was created.", 0, Integer.MAX_VALUE, this.indexed));
        list.add(new Property("status", "code", "The status of this document reference.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("docStatus", "CodeableConcept", "The status of the underlying document.", 0, Integer.MAX_VALUE, this.docStatus));
        list.add(new Property("relatesTo", "", "Relationships that this document has with other document references that already exist.", 0, Integer.MAX_VALUE, this.relatesTo));
        list.add(new Property("description", "string", "Human-readable description of the source document. This is sometimes known as the 'title'.", 0, Integer.MAX_VALUE, this.description));
        list.add(new Property("confidentiality", "CodeableConcept", "A code specifying the level of confidentiality of the XDS Document.", 0, Integer.MAX_VALUE, this.confidentiality));
        list.add(new Property("primaryLanguage", "code", "The primary language in which the source document is written.", 0, Integer.MAX_VALUE, this.primaryLanguage));
        list.add(new Property("mimeType", "code", "The mime type of the source document.", 0, Integer.MAX_VALUE, this.mimeType));
        list.add(new Property("format", "uri", "An identifier that identifies that the format and content of the document conforms to additional rules beyond the base format indicated in the mimeType.", 0, Integer.MAX_VALUE, this.format));
        list.add(new Property("size", "integer", "The size of the source document this reference refers to in bytes.", 0, Integer.MAX_VALUE, this.size));
        list.add(new Property("hash", "string", "A hash of the source document to ensure that changes have not occurred.", 0, Integer.MAX_VALUE, this.hash));
        list.add(new Property("location", "uri", "A url at which the document can be accessed.", 0, Integer.MAX_VALUE, this.location));
        list.add(new Property("service", "", "A description of a service call that can be used to retrieve the document.", 0, Integer.MAX_VALUE, this.service));
        list.add(new Property("context", "", "The clinical context in which the document was prepared.", 0, Integer.MAX_VALUE, this.context));
    }

    public DocumentReference copy() {
        DocumentReference documentReference = new DocumentReference();
        documentReference.masterIdentifier = this.masterIdentifier == null ? null : this.masterIdentifier.copy();
        documentReference.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            documentReference.identifier.add(element.copy());
        }
        documentReference.subject = this.subject == null ? null : this.subject.copy();
        documentReference.type = this.type == null ? null : this.type.copy();
        documentReference.class_ = this.class_ == null ? null : this.class_.copy();
        documentReference.author = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.author) {
            documentReference.author.add(resourceReference.copy());
        }
        documentReference.custodian = this.custodian == null ? null : this.custodian.copy();
        documentReference.policyManager = this.policyManager == null ? null : this.policyManager.copy();
        documentReference.authenticator = this.authenticator == null ? null : this.authenticator.copy();
        documentReference.created = this.created == null ? null : this.created.copy();
        documentReference.indexed = this.indexed == null ? null : this.indexed.copy();
        documentReference.status = this.status == null ? null : this.status.copy();
        documentReference.docStatus = this.docStatus == null ? null : this.docStatus.copy();
        documentReference.relatesTo = new ArrayList<DocumentReferenceRelatesToComponent>();
        for (DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent : this.relatesTo) {
            documentReference.relatesTo.add(documentReferenceRelatesToComponent.copy());
        }
        documentReference.description = this.description == null ? null : this.description.copy();
        documentReference.confidentiality = new ArrayList<CodeableConcept>();
        for (CodeableConcept codeableConcept : this.confidentiality) {
            documentReference.confidentiality.add(codeableConcept.copy());
        }
        documentReference.primaryLanguage = this.primaryLanguage == null ? null : this.primaryLanguage.copy();
        documentReference.mimeType = this.mimeType == null ? null : this.mimeType.copy();
        documentReference.format = new ArrayList<UriType>();
        for (UriType uriType : this.format) {
            documentReference.format.add(uriType.copy());
        }
        documentReference.size = this.size == null ? null : this.size.copy();
        documentReference.hash = this.hash == null ? null : this.hash.copy();
        documentReference.location = this.location == null ? null : this.location.copy();
        documentReference.service = this.service == null ? null : this.service.copy();
        documentReference.context = this.context == null ? null : this.context.copy();
        return documentReference;
    }

    protected DocumentReference typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DocumentReference;
    }

    public static class DocumentReferenceContextComponent
    extends BackboneElement {
        protected List<CodeableConcept> event = new ArrayList<CodeableConcept>();
        protected Period period;
        protected CodeableConcept facilityType;
        private static final long serialVersionUID = -1443761333L;

        public List<CodeableConcept> getEvent() {
            return this.event;
        }

        public CodeableConcept addEvent() {
            CodeableConcept codeableConcept = new CodeableConcept();
            this.event.add(codeableConcept);
            return codeableConcept;
        }

        public Period getPeriod() {
            return this.period;
        }

        public DocumentReferenceContextComponent setPeriod(Period period) {
            this.period = period;
            return this;
        }

        public CodeableConcept getFacilityType() {
            return this.facilityType;
        }

        public DocumentReferenceContextComponent setFacilityType(CodeableConcept codeableConcept) {
            this.facilityType = codeableConcept;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("event", "CodeableConcept", "This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the typeCode, such as a 'History and Physical Report' in which the procedure being documented is necessarily a 'History and Physical' act.", 0, Integer.MAX_VALUE, this.event));
            list.add(new Property("period", "Period", "The time period over which the service that is described by the document was provided.", 0, Integer.MAX_VALUE, this.period));
            list.add(new Property("facilityType", "CodeableConcept", "The kind of facility where the patient was seen.", 0, Integer.MAX_VALUE, this.facilityType));
        }

        public DocumentReferenceContextComponent copy() {
            DocumentReferenceContextComponent documentReferenceContextComponent = new DocumentReferenceContextComponent();
            documentReferenceContextComponent.event = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.event) {
                documentReferenceContextComponent.event.add(codeableConcept.copy());
            }
            documentReferenceContextComponent.period = this.period == null ? null : this.period.copy();
            documentReferenceContextComponent.facilityType = this.facilityType == null ? null : this.facilityType.copy();
            return documentReferenceContextComponent;
        }
    }

    public static class DocumentReferenceServiceParameterComponent
    extends BackboneElement {
        protected StringType name;
        protected StringType value;
        private static final long serialVersionUID = 395259392L;

        public DocumentReferenceServiceParameterComponent() {
        }

        public DocumentReferenceServiceParameterComponent(StringType stringType) {
            this.name = stringType;
        }

        public StringType getName() {
            return this.name;
        }

        public DocumentReferenceServiceParameterComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public DocumentReferenceServiceParameterComponent setNameSimple(String string) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(string);
            return this;
        }

        public StringType getValue() {
            return this.value;
        }

        public DocumentReferenceServiceParameterComponent setValue(StringType stringType) {
            this.value = stringType;
            return this;
        }

        public String getValueSimple() {
            return this.value == null ? null : this.value.getValue();
        }

        public DocumentReferenceServiceParameterComponent setValueSimple(String string) {
            if (string == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new StringType();
                }
                this.value.setValue(string);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("name", "string", "The name of a parameter.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("value", "string", "The value of the named parameter.", 0, Integer.MAX_VALUE, this.value));
        }

        public DocumentReferenceServiceParameterComponent copy() {
            DocumentReferenceServiceParameterComponent documentReferenceServiceParameterComponent = new DocumentReferenceServiceParameterComponent();
            documentReferenceServiceParameterComponent.name = this.name == null ? null : this.name.copy();
            documentReferenceServiceParameterComponent.value = this.value == null ? null : this.value.copy();
            return documentReferenceServiceParameterComponent;
        }
    }

    public static class DocumentReferenceServiceComponent
    extends BackboneElement {
        protected CodeableConcept type;
        protected StringType address;
        protected List<DocumentReferenceServiceParameterComponent> parameter = new ArrayList<DocumentReferenceServiceParameterComponent>();
        private static final long serialVersionUID = 1809166750L;

        public DocumentReferenceServiceComponent() {
        }

        public DocumentReferenceServiceComponent(CodeableConcept codeableConcept) {
            this.type = codeableConcept;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public DocumentReferenceServiceComponent setType(CodeableConcept codeableConcept) {
            this.type = codeableConcept;
            return this;
        }

        public StringType getAddress() {
            return this.address;
        }

        public DocumentReferenceServiceComponent setAddress(StringType stringType) {
            this.address = stringType;
            return this;
        }

        public String getAddressSimple() {
            return this.address == null ? null : this.address.getValue();
        }

        public DocumentReferenceServiceComponent setAddressSimple(String string) {
            if (string == null) {
                this.address = null;
            } else {
                if (this.address == null) {
                    this.address = new StringType();
                }
                this.address.setValue(string);
            }
            return this;
        }

        public List<DocumentReferenceServiceParameterComponent> getParameter() {
            return this.parameter;
        }

        public DocumentReferenceServiceParameterComponent addParameter() {
            DocumentReferenceServiceParameterComponent documentReferenceServiceParameterComponent = new DocumentReferenceServiceParameterComponent();
            this.parameter.add(documentReferenceServiceParameterComponent);
            return documentReferenceServiceParameterComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("type", "CodeableConcept", "The type of the service that can be used to access the documents.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("address", "string", "Where the service end-point is located.", 0, Integer.MAX_VALUE, this.address));
            list.add(new Property("parameter", "", "A list of named parameters that is used in the service call.", 0, Integer.MAX_VALUE, this.parameter));
        }

        public DocumentReferenceServiceComponent copy() {
            DocumentReferenceServiceComponent documentReferenceServiceComponent = new DocumentReferenceServiceComponent();
            documentReferenceServiceComponent.type = this.type == null ? null : this.type.copy();
            documentReferenceServiceComponent.address = this.address == null ? null : this.address.copy();
            documentReferenceServiceComponent.parameter = new ArrayList<DocumentReferenceServiceParameterComponent>();
            for (DocumentReferenceServiceParameterComponent documentReferenceServiceParameterComponent : this.parameter) {
                documentReferenceServiceComponent.parameter.add(documentReferenceServiceParameterComponent.copy());
            }
            return documentReferenceServiceComponent;
        }
    }

    public static class DocumentReferenceRelatesToComponent
    extends BackboneElement {
        protected Enumeration<DocumentRelationshipType> code;
        protected ResourceReference target;
        protected DocumentReference targetTarget;
        private static final long serialVersionUID = -548377577L;

        public DocumentReferenceRelatesToComponent() {
        }

        public DocumentReferenceRelatesToComponent(Enumeration<DocumentRelationshipType> enumeration, ResourceReference resourceReference) {
            this.code = enumeration;
            this.target = resourceReference;
        }

        public Enumeration<DocumentRelationshipType> getCode() {
            return this.code;
        }

        public DocumentReferenceRelatesToComponent setCode(Enumeration<DocumentRelationshipType> enumeration) {
            this.code = enumeration;
            return this;
        }

        public DocumentRelationshipType getCodeSimple() {
            return this.code == null ? null : this.code.getValue();
        }

        public DocumentReferenceRelatesToComponent setCodeSimple(DocumentRelationshipType documentRelationshipType) {
            if (this.code == null) {
                this.code = new Enumeration();
            }
            this.code.setValue(documentRelationshipType);
            return this;
        }

        public ResourceReference getTarget() {
            return this.target;
        }

        public DocumentReferenceRelatesToComponent setTarget(ResourceReference resourceReference) {
            this.target = resourceReference;
            return this;
        }

        public DocumentReference getTargetTarget() {
            return this.targetTarget;
        }

        public DocumentReferenceRelatesToComponent setTargetTarget(DocumentReference documentReference) {
            this.targetTarget = documentReference;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "code", "The type of relationship that this document has with anther document.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("target", "Resource(DocumentReference)", "The target document of this relationship.", 0, Integer.MAX_VALUE, this.target));
        }

        public DocumentReferenceRelatesToComponent copy() {
            DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent = new DocumentReferenceRelatesToComponent();
            documentReferenceRelatesToComponent.code = this.code == null ? null : this.code.copy();
            documentReferenceRelatesToComponent.target = this.target == null ? null : this.target.copy();
            return documentReferenceRelatesToComponent;
        }
    }

    public static class DocumentRelationshipTypeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("replaces".equals(string)) {
                return DocumentRelationshipType.replaces;
            }
            if ("transforms".equals(string)) {
                return DocumentRelationshipType.transforms;
            }
            if ("signs".equals(string)) {
                return DocumentRelationshipType.signs;
            }
            if ("appends".equals(string)) {
                return DocumentRelationshipType.appends;
            }
            throw new Exception("Unknown DocumentRelationshipType code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == DocumentRelationshipType.replaces) {
                return "replaces";
            }
            if (enum_ == DocumentRelationshipType.transforms) {
                return "transforms";
            }
            if (enum_ == DocumentRelationshipType.signs) {
                return "signs";
            }
            if (enum_ == DocumentRelationshipType.appends) {
                return "appends";
            }
            return "?";
        }
    }

    public static enum DocumentRelationshipType {
        replaces,
        transforms,
        signs,
        appends,
        Null;


        public static DocumentRelationshipType fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("replaces".equals(string)) {
                return replaces;
            }
            if ("transforms".equals(string)) {
                return transforms;
            }
            if ("signs".equals(string)) {
                return signs;
            }
            if ("appends".equals(string)) {
                return appends;
            }
            throw new Exception("Unknown DocumentRelationshipType code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case replaces: {
                    return "replaces";
                }
                case transforms: {
                    return "transforms";
                }
                case signs: {
                    return "signs";
                }
                case appends: {
                    return "appends";
                }
            }
            return "?";
        }
    }

    public static class DocumentReferenceStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("current".equals(string)) {
                return DocumentReferenceStatus.current;
            }
            if ("superceded".equals(string)) {
                return DocumentReferenceStatus.superceded;
            }
            if ("entered in error".equals(string)) {
                return DocumentReferenceStatus.enteredInError;
            }
            throw new Exception("Unknown DocumentReferenceStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == DocumentReferenceStatus.current) {
                return "current";
            }
            if (enum_ == DocumentReferenceStatus.superceded) {
                return "superceded";
            }
            if (enum_ == DocumentReferenceStatus.enteredInError) {
                return "entered in error";
            }
            return "?";
        }
    }

    public static enum DocumentReferenceStatus {
        current,
        superceded,
        enteredInError,
        Null;


        public static DocumentReferenceStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("current".equals(string)) {
                return current;
            }
            if ("superceded".equals(string)) {
                return superceded;
            }
            if ("entered in error".equals(string)) {
                return enteredInError;
            }
            throw new Exception("Unknown DocumentReferenceStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case current: {
                    return "current";
                }
                case superceded: {
                    return "superceded";
                }
                case enteredInError: {
                    return "entered in error";
                }
            }
            return "?";
        }
    }
}

