/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.Extension;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.UriType;

public abstract class Element
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String xmlId;
    private List<Extension> extensions = new ArrayList<Extension>();
    private List<String> xmlComments;
    private Map<String, String> tags;

    public String getXmlId() {
        return this.xmlId;
    }

    public void setXmlId(String string) {
        this.xmlId = string;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public boolean hasExtensions() {
        return this.extensions.size() > 0;
    }

    public boolean hasExtension(String string) {
        if (string == null) {
            return false;
        }
        for (Extension extension : this.extensions) {
            if (!string.equals(extension.getUrlSimple())) continue;
            return true;
        }
        return false;
    }

    public Extension getExtension(String string) {
        if (string == null) {
            return null;
        }
        for (Extension extension : this.extensions) {
            if (!string.equals(extension.getUrlSimple())) continue;
            return extension;
        }
        return null;
    }

    public void setStringExtension(String string, String string2) {
        Extension extension = this.getExtension(string);
        if (extension != null) {
            extension.setValue(new StringType(string2));
        } else {
            this.extensions.add(new Extension(new UriType(string)).setValue(new StringType(string2)));
        }
    }

    public List<Property> children() {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        this.listChildren(arrayList);
        return arrayList;
    }

    protected void listChildren(List<Property> list) {
        list.add(new Property("extension", "Extension", "XML Identifier - target for an id ref", 0, Integer.MAX_VALUE, this.extensions));
    }

    public Property getChildByName(String string) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        this.listChildren(arrayList);
        for (Property property : arrayList) {
            if (!property.getName().equals(string)) continue;
            return property;
        }
        return null;
    }

    public List<String> getXmlComments() {
        if (this.xmlComments == null) {
            this.xmlComments = new ArrayList<String>();
        }
        return this.xmlComments;
    }

    public String getTag(String string) {
        if (this.tags == null) {
            return null;
        }
        return this.tags.get(string);
    }

    public void setTag(String string, String string2) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(string, string2);
    }
}

