/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Duration;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Location;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;

public class Encounter
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected Enumeration<EncounterState> status;
    protected Enumeration<EncounterClass> class_;
    protected List<CodeableConcept> type = new ArrayList<CodeableConcept>();
    protected ResourceReference subject;
    protected Patient subjectTarget;
    protected List<EncounterParticipantComponent> participant = new ArrayList<EncounterParticipantComponent>();
    protected Period period;
    protected Duration length;
    protected CodeableConcept reason;
    protected ResourceReference indication;
    protected Resource indicationTarget;
    protected CodeableConcept priority;
    protected EncounterHospitalizationComponent hospitalization;
    protected List<EncounterLocationComponent> location = new ArrayList<EncounterLocationComponent>();
    protected ResourceReference serviceProvider;
    protected Organization serviceProviderTarget;
    protected ResourceReference partOf;
    protected Encounter partOfTarget;
    private static final long serialVersionUID = 1471288836L;

    public Encounter() {
    }

    public Encounter(Enumeration<EncounterState> enumeration, Enumeration<EncounterClass> enumeration2) {
        this.status = enumeration;
        this.class_ = enumeration2;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public Enumeration<EncounterState> getStatus() {
        return this.status;
    }

    public Encounter setStatus(Enumeration<EncounterState> enumeration) {
        this.status = enumeration;
        return this;
    }

    public EncounterState getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public Encounter setStatusSimple(EncounterState encounterState) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(encounterState);
        return this;
    }

    public Enumeration<EncounterClass> getClass_() {
        return this.class_;
    }

    public Encounter setClass_(Enumeration<EncounterClass> enumeration) {
        this.class_ = enumeration;
        return this;
    }

    public EncounterClass getClass_Simple() {
        return this.class_ == null ? null : this.class_.getValue();
    }

    public Encounter setClass_Simple(EncounterClass encounterClass) {
        if (this.class_ == null) {
            this.class_ = new Enumeration();
        }
        this.class_.setValue(encounterClass);
        return this;
    }

    public List<CodeableConcept> getType() {
        return this.type;
    }

    public CodeableConcept addType() {
        CodeableConcept codeableConcept = new CodeableConcept();
        this.type.add(codeableConcept);
        return codeableConcept;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public Encounter setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Patient getSubjectTarget() {
        return this.subjectTarget;
    }

    public Encounter setSubjectTarget(Patient patient) {
        this.subjectTarget = patient;
        return this;
    }

    public List<EncounterParticipantComponent> getParticipant() {
        return this.participant;
    }

    public EncounterParticipantComponent addParticipant() {
        EncounterParticipantComponent encounterParticipantComponent = new EncounterParticipantComponent();
        this.participant.add(encounterParticipantComponent);
        return encounterParticipantComponent;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Encounter setPeriod(Period period) {
        this.period = period;
        return this;
    }

    public Duration getLength() {
        return this.length;
    }

    public Encounter setLength(Duration duration) {
        this.length = duration;
        return this;
    }

    public CodeableConcept getReason() {
        return this.reason;
    }

    public Encounter setReason(CodeableConcept codeableConcept) {
        this.reason = codeableConcept;
        return this;
    }

    public ResourceReference getIndication() {
        return this.indication;
    }

    public Encounter setIndication(ResourceReference resourceReference) {
        this.indication = resourceReference;
        return this;
    }

    public Resource getIndicationTarget() {
        return this.indicationTarget;
    }

    public Encounter setIndicationTarget(Resource resource) {
        this.indicationTarget = resource;
        return this;
    }

    public CodeableConcept getPriority() {
        return this.priority;
    }

    public Encounter setPriority(CodeableConcept codeableConcept) {
        this.priority = codeableConcept;
        return this;
    }

    public EncounterHospitalizationComponent getHospitalization() {
        return this.hospitalization;
    }

    public Encounter setHospitalization(EncounterHospitalizationComponent encounterHospitalizationComponent) {
        this.hospitalization = encounterHospitalizationComponent;
        return this;
    }

    public List<EncounterLocationComponent> getLocation() {
        return this.location;
    }

    public EncounterLocationComponent addLocation() {
        EncounterLocationComponent encounterLocationComponent = new EncounterLocationComponent();
        this.location.add(encounterLocationComponent);
        return encounterLocationComponent;
    }

    public ResourceReference getServiceProvider() {
        return this.serviceProvider;
    }

    public Encounter setServiceProvider(ResourceReference resourceReference) {
        this.serviceProvider = resourceReference;
        return this;
    }

    public Organization getServiceProviderTarget() {
        return this.serviceProviderTarget;
    }

    public Encounter setServiceProviderTarget(Organization organization) {
        this.serviceProviderTarget = organization;
        return this;
    }

    public ResourceReference getPartOf() {
        return this.partOf;
    }

    public Encounter setPartOf(ResourceReference resourceReference) {
        this.partOf = resourceReference;
        return this;
    }

    public Encounter getPartOfTarget() {
        return this.partOfTarget;
    }

    public Encounter setPartOfTarget(Encounter encounter) {
        this.partOfTarget = encounter;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "Identifier(s) by which this encounter is known.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("status", "code", "planned | in progress | onleave | finished | cancelled.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("class", "code", "inpatient | outpatient | ambulatory | emergency +.", 0, Integer.MAX_VALUE, this.class_));
        list.add(new Property("type", "CodeableConcept", "Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).", 0, Integer.MAX_VALUE, this.type));
        list.add(new Property("subject", "Resource(Patient)", "The patient present at the encounter.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("participant", "", "The main practitioner responsible for providing the service.", 0, Integer.MAX_VALUE, this.participant));
        list.add(new Property("period", "Period", "The start and end time of the encounter.", 0, Integer.MAX_VALUE, this.period));
        list.add(new Property("length", "Duration", "Quantity of time the encounter lasted. This excludes the time during leaves of absence.", 0, Integer.MAX_VALUE, this.length));
        list.add(new Property("reason", "CodeableConcept", "Reason the encounter takes place, expressed as a code. For admissions, this can be used for a coded admission diagnosis.", 0, Integer.MAX_VALUE, this.reason));
        list.add(new Property("indication", "Resource(Any)", "Reason the encounter takes place, as specified using information from another resource. For admissions, this is the admission diagnosis.", 0, Integer.MAX_VALUE, this.indication));
        list.add(new Property("priority", "CodeableConcept", "Indicates the urgency of the encounter.", 0, Integer.MAX_VALUE, this.priority));
        list.add(new Property("hospitalization", "", "Details about an admission to a clinic.", 0, Integer.MAX_VALUE, this.hospitalization));
        list.add(new Property("location", "", "List of locations at which the patient has been.", 0, Integer.MAX_VALUE, this.location));
        list.add(new Property("serviceProvider", "Resource(Organization)", "Department or team providing care.", 0, Integer.MAX_VALUE, this.serviceProvider));
        list.add(new Property("partOf", "Resource(Encounter)", "Another Encounter of which this encounter is a part of (administratively or in time).", 0, Integer.MAX_VALUE, this.partOf));
    }

    public Encounter copy() {
        Encounter encounter = new Encounter();
        encounter.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            encounter.identifier.add(element.copy());
        }
        encounter.status = this.status == null ? null : this.status.copy();
        encounter.class_ = this.class_ == null ? null : this.class_.copy();
        encounter.type = new ArrayList<CodeableConcept>();
        for (CodeableConcept codeableConcept : this.type) {
            encounter.type.add(codeableConcept.copy());
        }
        encounter.subject = this.subject == null ? null : this.subject.copy();
        encounter.participant = new ArrayList<EncounterParticipantComponent>();
        for (EncounterParticipantComponent encounterParticipantComponent : this.participant) {
            encounter.participant.add(encounterParticipantComponent.copy());
        }
        encounter.period = this.period == null ? null : this.period.copy();
        encounter.length = this.length == null ? null : this.length.copy();
        encounter.reason = this.reason == null ? null : this.reason.copy();
        encounter.indication = this.indication == null ? null : this.indication.copy();
        encounter.priority = this.priority == null ? null : this.priority.copy();
        encounter.hospitalization = this.hospitalization == null ? null : this.hospitalization.copy();
        encounter.location = new ArrayList<EncounterLocationComponent>();
        for (EncounterLocationComponent encounterLocationComponent : this.location) {
            encounter.location.add(encounterLocationComponent.copy());
        }
        encounter.serviceProvider = this.serviceProvider == null ? null : this.serviceProvider.copy();
        encounter.partOf = this.partOf == null ? null : this.partOf.copy();
        return encounter;
    }

    protected Encounter typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Encounter;
    }

    public static class EncounterLocationComponent
    extends BackboneElement {
        protected ResourceReference location;
        protected Location locationTarget;
        protected Period period;
        private static final long serialVersionUID = 1444463345L;

        public EncounterLocationComponent() {
        }

        public EncounterLocationComponent(ResourceReference resourceReference, Period period) {
            this.location = resourceReference;
            this.period = period;
        }

        public ResourceReference getLocation() {
            return this.location;
        }

        public EncounterLocationComponent setLocation(ResourceReference resourceReference) {
            this.location = resourceReference;
            return this;
        }

        public Location getLocationTarget() {
            return this.locationTarget;
        }

        public EncounterLocationComponent setLocationTarget(Location location) {
            this.locationTarget = location;
            return this;
        }

        public Period getPeriod() {
            return this.period;
        }

        public EncounterLocationComponent setPeriod(Period period) {
            this.period = period;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("location", "Resource(Location)", "The location where the encounter takes place.", 0, Integer.MAX_VALUE, this.location));
            list.add(new Property("period", "Period", "Time period during which the patient was present at the location.", 0, Integer.MAX_VALUE, this.period));
        }

        public EncounterLocationComponent copy() {
            EncounterLocationComponent encounterLocationComponent = new EncounterLocationComponent();
            encounterLocationComponent.location = this.location == null ? null : this.location.copy();
            encounterLocationComponent.period = this.period == null ? null : this.period.copy();
            return encounterLocationComponent;
        }
    }

    public static class EncounterHospitalizationAccomodationComponent
    extends BackboneElement {
        protected ResourceReference bed;
        protected Location bedTarget;
        protected Period period;
        private static final long serialVersionUID = 1820878877L;

        public ResourceReference getBed() {
            return this.bed;
        }

        public EncounterHospitalizationAccomodationComponent setBed(ResourceReference resourceReference) {
            this.bed = resourceReference;
            return this;
        }

        public Location getBedTarget() {
            return this.bedTarget;
        }

        public EncounterHospitalizationAccomodationComponent setBedTarget(Location location) {
            this.bedTarget = location;
            return this;
        }

        public Period getPeriod() {
            return this.period;
        }

        public EncounterHospitalizationAccomodationComponent setPeriod(Period period) {
            this.period = period;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("bed", "Resource(Location)", "The bed that is assigned to the patient.", 0, Integer.MAX_VALUE, this.bed));
            list.add(new Property("period", "Period", "Period during which the patient was assigned the bed.", 0, Integer.MAX_VALUE, this.period));
        }

        public EncounterHospitalizationAccomodationComponent copy() {
            EncounterHospitalizationAccomodationComponent encounterHospitalizationAccomodationComponent = new EncounterHospitalizationAccomodationComponent();
            encounterHospitalizationAccomodationComponent.bed = this.bed == null ? null : this.bed.copy();
            encounterHospitalizationAccomodationComponent.period = this.period == null ? null : this.period.copy();
            return encounterHospitalizationAccomodationComponent;
        }
    }

    public static class EncounterHospitalizationComponent
    extends BackboneElement {
        protected Identifier preAdmissionIdentifier;
        protected ResourceReference origin;
        protected Location originTarget;
        protected CodeableConcept admitSource;
        protected Period period;
        protected List<EncounterHospitalizationAccomodationComponent> accomodation = new ArrayList<EncounterHospitalizationAccomodationComponent>();
        protected CodeableConcept diet;
        protected List<CodeableConcept> specialCourtesy = new ArrayList<CodeableConcept>();
        protected List<CodeableConcept> specialArrangement = new ArrayList<CodeableConcept>();
        protected ResourceReference destination;
        protected Location destinationTarget;
        protected CodeableConcept dischargeDisposition;
        protected ResourceReference dischargeDiagnosis;
        protected Resource dischargeDiagnosisTarget;
        protected BooleanType reAdmission;
        private static final long serialVersionUID = -521461330L;

        public Identifier getPreAdmissionIdentifier() {
            return this.preAdmissionIdentifier;
        }

        public EncounterHospitalizationComponent setPreAdmissionIdentifier(Identifier identifier) {
            this.preAdmissionIdentifier = identifier;
            return this;
        }

        public ResourceReference getOrigin() {
            return this.origin;
        }

        public EncounterHospitalizationComponent setOrigin(ResourceReference resourceReference) {
            this.origin = resourceReference;
            return this;
        }

        public Location getOriginTarget() {
            return this.originTarget;
        }

        public EncounterHospitalizationComponent setOriginTarget(Location location) {
            this.originTarget = location;
            return this;
        }

        public CodeableConcept getAdmitSource() {
            return this.admitSource;
        }

        public EncounterHospitalizationComponent setAdmitSource(CodeableConcept codeableConcept) {
            this.admitSource = codeableConcept;
            return this;
        }

        public Period getPeriod() {
            return this.period;
        }

        public EncounterHospitalizationComponent setPeriod(Period period) {
            this.period = period;
            return this;
        }

        public List<EncounterHospitalizationAccomodationComponent> getAccomodation() {
            return this.accomodation;
        }

        public EncounterHospitalizationAccomodationComponent addAccomodation() {
            EncounterHospitalizationAccomodationComponent encounterHospitalizationAccomodationComponent = new EncounterHospitalizationAccomodationComponent();
            this.accomodation.add(encounterHospitalizationAccomodationComponent);
            return encounterHospitalizationAccomodationComponent;
        }

        public CodeableConcept getDiet() {
            return this.diet;
        }

        public EncounterHospitalizationComponent setDiet(CodeableConcept codeableConcept) {
            this.diet = codeableConcept;
            return this;
        }

        public List<CodeableConcept> getSpecialCourtesy() {
            return this.specialCourtesy;
        }

        public CodeableConcept addSpecialCourtesy() {
            CodeableConcept codeableConcept = new CodeableConcept();
            this.specialCourtesy.add(codeableConcept);
            return codeableConcept;
        }

        public List<CodeableConcept> getSpecialArrangement() {
            return this.specialArrangement;
        }

        public CodeableConcept addSpecialArrangement() {
            CodeableConcept codeableConcept = new CodeableConcept();
            this.specialArrangement.add(codeableConcept);
            return codeableConcept;
        }

        public ResourceReference getDestination() {
            return this.destination;
        }

        public EncounterHospitalizationComponent setDestination(ResourceReference resourceReference) {
            this.destination = resourceReference;
            return this;
        }

        public Location getDestinationTarget() {
            return this.destinationTarget;
        }

        public EncounterHospitalizationComponent setDestinationTarget(Location location) {
            this.destinationTarget = location;
            return this;
        }

        public CodeableConcept getDischargeDisposition() {
            return this.dischargeDisposition;
        }

        public EncounterHospitalizationComponent setDischargeDisposition(CodeableConcept codeableConcept) {
            this.dischargeDisposition = codeableConcept;
            return this;
        }

        public ResourceReference getDischargeDiagnosis() {
            return this.dischargeDiagnosis;
        }

        public EncounterHospitalizationComponent setDischargeDiagnosis(ResourceReference resourceReference) {
            this.dischargeDiagnosis = resourceReference;
            return this;
        }

        public Resource getDischargeDiagnosisTarget() {
            return this.dischargeDiagnosisTarget;
        }

        public EncounterHospitalizationComponent setDischargeDiagnosisTarget(Resource resource) {
            this.dischargeDiagnosisTarget = resource;
            return this;
        }

        public BooleanType getReAdmission() {
            return this.reAdmission;
        }

        public EncounterHospitalizationComponent setReAdmission(BooleanType booleanType) {
            this.reAdmission = booleanType;
            return this;
        }

        public boolean getReAdmissionSimple() {
            return this.reAdmission == null ? false : this.reAdmission.getValue();
        }

        public EncounterHospitalizationComponent setReAdmissionSimple(boolean bl) {
            if (!bl) {
                this.reAdmission = null;
            } else {
                if (this.reAdmission == null) {
                    this.reAdmission = new BooleanType();
                }
                this.reAdmission.setValue(bl);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("preAdmissionIdentifier", "Identifier", "Pre-admission identifier.", 0, Integer.MAX_VALUE, this.preAdmissionIdentifier));
            list.add(new Property("origin", "Resource(Location)", "The location from which the patient came before admission.", 0, Integer.MAX_VALUE, this.origin));
            list.add(new Property("admitSource", "CodeableConcept", "From where patient was admitted (physician referral, transfer).", 0, Integer.MAX_VALUE, this.admitSource));
            list.add(new Property("period", "Period", "Period during which the patient was admitted.", 0, Integer.MAX_VALUE, this.period));
            list.add(new Property("accomodation", "", "Where the patient stays during this encounter.", 0, Integer.MAX_VALUE, this.accomodation));
            list.add(new Property("diet", "CodeableConcept", "Dietary restrictions for the patient.", 0, Integer.MAX_VALUE, this.diet));
            list.add(new Property("specialCourtesy", "CodeableConcept", "Special courtesies (VIP, board member).", 0, Integer.MAX_VALUE, this.specialCourtesy));
            list.add(new Property("specialArrangement", "CodeableConcept", "Wheelchair, translator, stretcher, etc.", 0, Integer.MAX_VALUE, this.specialArrangement));
            list.add(new Property("destination", "Resource(Location)", "Location to which the patient is discharged.", 0, Integer.MAX_VALUE, this.destination));
            list.add(new Property("dischargeDisposition", "CodeableConcept", "Category or kind of location after discharge.", 0, Integer.MAX_VALUE, this.dischargeDisposition));
            list.add(new Property("dischargeDiagnosis", "Resource(Any)", "The final diagnosis given a patient before release from the hospital after all testing, surgery, and workup are complete.", 0, Integer.MAX_VALUE, this.dischargeDiagnosis));
            list.add(new Property("reAdmission", "boolean", "Whether this hospitalization is a readmission.", 0, Integer.MAX_VALUE, this.reAdmission));
        }

        public EncounterHospitalizationComponent copy() {
            EncounterHospitalizationComponent encounterHospitalizationComponent = new EncounterHospitalizationComponent();
            encounterHospitalizationComponent.preAdmissionIdentifier = this.preAdmissionIdentifier == null ? null : this.preAdmissionIdentifier.copy();
            encounterHospitalizationComponent.origin = this.origin == null ? null : this.origin.copy();
            encounterHospitalizationComponent.admitSource = this.admitSource == null ? null : this.admitSource.copy();
            encounterHospitalizationComponent.period = this.period == null ? null : this.period.copy();
            encounterHospitalizationComponent.accomodation = new ArrayList<EncounterHospitalizationAccomodationComponent>();
            for (EncounterHospitalizationAccomodationComponent element : this.accomodation) {
                encounterHospitalizationComponent.accomodation.add(element.copy());
            }
            encounterHospitalizationComponent.diet = this.diet == null ? null : this.diet.copy();
            encounterHospitalizationComponent.specialCourtesy = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.specialCourtesy) {
                encounterHospitalizationComponent.specialCourtesy.add(codeableConcept.copy());
            }
            encounterHospitalizationComponent.specialArrangement = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.specialArrangement) {
                encounterHospitalizationComponent.specialArrangement.add(codeableConcept.copy());
            }
            encounterHospitalizationComponent.destination = this.destination == null ? null : this.destination.copy();
            encounterHospitalizationComponent.dischargeDisposition = this.dischargeDisposition == null ? null : this.dischargeDisposition.copy();
            encounterHospitalizationComponent.dischargeDiagnosis = this.dischargeDiagnosis == null ? null : this.dischargeDiagnosis.copy();
            encounterHospitalizationComponent.reAdmission = this.reAdmission == null ? null : this.reAdmission.copy();
            return encounterHospitalizationComponent;
        }
    }

    public static class EncounterParticipantComponent
    extends BackboneElement {
        protected List<CodeableConcept> type = new ArrayList<CodeableConcept>();
        protected ResourceReference individual;
        protected Resource individualTarget;
        private static final long serialVersionUID = 982307509L;

        public List<CodeableConcept> getType() {
            return this.type;
        }

        public CodeableConcept addType() {
            CodeableConcept codeableConcept = new CodeableConcept();
            this.type.add(codeableConcept);
            return codeableConcept;
        }

        public ResourceReference getIndividual() {
            return this.individual;
        }

        public EncounterParticipantComponent setIndividual(ResourceReference resourceReference) {
            this.individual = resourceReference;
            return this;
        }

        public Resource getIndividualTarget() {
            return this.individualTarget;
        }

        public EncounterParticipantComponent setIndividualTarget(Resource resource) {
            this.individualTarget = resource;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("type", "CodeableConcept", "Role of participant in encounter.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("individual", "Resource(Practitioner|RelatedPerson)", "Persons involved in the encounter other than the patient.", 0, Integer.MAX_VALUE, this.individual));
        }

        public EncounterParticipantComponent copy() {
            EncounterParticipantComponent encounterParticipantComponent = new EncounterParticipantComponent();
            encounterParticipantComponent.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.type) {
                encounterParticipantComponent.type.add(codeableConcept.copy());
            }
            encounterParticipantComponent.individual = this.individual == null ? null : this.individual.copy();
            return encounterParticipantComponent;
        }
    }

    public static class EncounterClassEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("inpatient".equals(string)) {
                return EncounterClass.inpatient;
            }
            if ("outpatient".equals(string)) {
                return EncounterClass.outpatient;
            }
            if ("ambulatory".equals(string)) {
                return EncounterClass.ambulatory;
            }
            if ("emergency".equals(string)) {
                return EncounterClass.emergency;
            }
            if ("home".equals(string)) {
                return EncounterClass.home;
            }
            if ("field".equals(string)) {
                return EncounterClass.field;
            }
            if ("daytime".equals(string)) {
                return EncounterClass.daytime;
            }
            if ("virtual".equals(string)) {
                return EncounterClass.virtual;
            }
            throw new Exception("Unknown EncounterClass code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == EncounterClass.inpatient) {
                return "inpatient";
            }
            if (enum_ == EncounterClass.outpatient) {
                return "outpatient";
            }
            if (enum_ == EncounterClass.ambulatory) {
                return "ambulatory";
            }
            if (enum_ == EncounterClass.emergency) {
                return "emergency";
            }
            if (enum_ == EncounterClass.home) {
                return "home";
            }
            if (enum_ == EncounterClass.field) {
                return "field";
            }
            if (enum_ == EncounterClass.daytime) {
                return "daytime";
            }
            if (enum_ == EncounterClass.virtual) {
                return "virtual";
            }
            return "?";
        }
    }

    public static enum EncounterClass {
        inpatient,
        outpatient,
        ambulatory,
        emergency,
        home,
        field,
        daytime,
        virtual,
        Null;


        public static EncounterClass fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("inpatient".equals(string)) {
                return inpatient;
            }
            if ("outpatient".equals(string)) {
                return outpatient;
            }
            if ("ambulatory".equals(string)) {
                return ambulatory;
            }
            if ("emergency".equals(string)) {
                return emergency;
            }
            if ("home".equals(string)) {
                return home;
            }
            if ("field".equals(string)) {
                return field;
            }
            if ("daytime".equals(string)) {
                return daytime;
            }
            if ("virtual".equals(string)) {
                return virtual;
            }
            throw new Exception("Unknown EncounterClass code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case inpatient: {
                    return "inpatient";
                }
                case outpatient: {
                    return "outpatient";
                }
                case ambulatory: {
                    return "ambulatory";
                }
                case emergency: {
                    return "emergency";
                }
                case home: {
                    return "home";
                }
                case field: {
                    return "field";
                }
                case daytime: {
                    return "daytime";
                }
                case virtual: {
                    return "virtual";
                }
            }
            return "?";
        }
    }

    public static class EncounterStateEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("planned".equals(string)) {
                return EncounterState.planned;
            }
            if ("in progress".equals(string)) {
                return EncounterState.inProgress;
            }
            if ("onleave".equals(string)) {
                return EncounterState.onleave;
            }
            if ("finished".equals(string)) {
                return EncounterState.finished;
            }
            if ("cancelled".equals(string)) {
                return EncounterState.cancelled;
            }
            throw new Exception("Unknown EncounterState code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == EncounterState.planned) {
                return "planned";
            }
            if (enum_ == EncounterState.inProgress) {
                return "in progress";
            }
            if (enum_ == EncounterState.onleave) {
                return "onleave";
            }
            if (enum_ == EncounterState.finished) {
                return "finished";
            }
            if (enum_ == EncounterState.cancelled) {
                return "cancelled";
            }
            return "?";
        }
    }

    public static enum EncounterState {
        planned,
        inProgress,
        onleave,
        finished,
        cancelled,
        Null;


        public static EncounterState fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("planned".equals(string)) {
                return planned;
            }
            if ("in progress".equals(string)) {
                return inProgress;
            }
            if ("onleave".equals(string)) {
                return onleave;
            }
            if ("finished".equals(string)) {
                return finished;
            }
            if ("cancelled".equals(string)) {
                return cancelled;
            }
            throw new Exception("Unknown EncounterState code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case planned: {
                    return "planned";
                }
                case inProgress: {
                    return "in progress";
                }
                case onleave: {
                    return "onleave";
                }
                case finished: {
                    return "finished";
                }
                case cancelled: {
                    return "cancelled";
                }
            }
            return "?";
        }
    }
}

