/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.List;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;

public class Extension
extends Element {
    protected UriType url;
    protected Type value;
    private static final long serialVersionUID = 86382982L;

    public Extension() {
    }

    public Extension(UriType uriType) {
        this.url = uriType;
    }

    public UriType getUrl() {
        return this.url;
    }

    public Extension setUrl(UriType uriType) {
        this.url = uriType;
        return this;
    }

    public String getUrlSimple() {
        return this.url == null ? null : this.url.getValue();
    }

    public Extension setUrlSimple(String string) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(string);
        return this;
    }

    public Type getValue() {
        return this.value;
    }

    public Extension setValue(Type type) {
        this.value = type;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("url", "uri", "Source of the definition for the extension code - a logical name or a URL.", 0, Integer.MAX_VALUE, this.url));
        list.add(new Property("value[x]", "*", "Value of extension - may be a resource or one of a constrained set of the data types (see Extensibility in the spec for list).", 0, Integer.MAX_VALUE, this.value));
    }

    public Extension copy() {
        Extension extension = new Extension();
        extension.url = this.url == null ? null : this.url.copy();
        extension.value = this.value == null ? null : this.value.copy();
        return extension;
    }

    protected Extension typedCopy() {
        return this.copy();
    }
}

