/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.net.URISyntaxException;
import java.text.ParseException;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.Extension;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.Narrative;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public class Factory {
    public static IdType newId(String string) {
        if (string == null) {
            return null;
        }
        IdType idType = new IdType();
        idType.setValue(string);
        return idType;
    }

    public static StringType newString(String string) {
        if (string == null) {
            return null;
        }
        StringType stringType = new StringType();
        stringType.setValue(string);
        return stringType;
    }

    public static UriType newUri(String string) throws URISyntaxException {
        if (string == null) {
            return null;
        }
        UriType uriType = new UriType();
        uriType.setValue(string);
        return uriType;
    }

    public static DateTimeType newDateTime(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        DateTimeType dateTimeType = new DateTimeType();
        dateTimeType.setValue(new DateAndTime(string));
        return dateTimeType;
    }

    public static DateType newDate(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        DateType dateType = new DateType();
        dateType.setValue(new DateAndTime(string));
        return dateType;
    }

    public static CodeType newCode(String string) {
        if (string == null) {
            return null;
        }
        CodeType codeType = new CodeType();
        codeType.setValue(string);
        return codeType;
    }

    public static IntegerType newInteger(int n) {
        IntegerType integerType = new IntegerType();
        integerType.setValue(n);
        return integerType;
    }

    public static IntegerType newInteger(Integer n) {
        if (n == null) {
            return null;
        }
        IntegerType integerType = new IntegerType();
        integerType.setValue(n);
        return integerType;
    }

    public static BooleanType newBoolean(boolean bl) {
        BooleanType booleanType = new BooleanType();
        booleanType.setValue(bl);
        return booleanType;
    }

    public static Contact newContact(Contact.ContactSystem contactSystem, String string) {
        Contact contact = new Contact();
        contact.setSystemSimple(contactSystem);
        contact.setValue(Factory.newString(string));
        return contact;
    }

    public static Extension newExtension(String string, Type type, boolean bl) throws Exception {
        if (!bl && type == null) {
            return null;
        }
        Extension extension = new Extension();
        extension.setUrlSimple(string);
        extension.setValue(type);
        return extension;
    }

    public static CodeableConcept newCodeableConcept(String string, String string2, String string3) throws Exception {
        CodeableConcept codeableConcept = new CodeableConcept();
        Coding coding = new Coding();
        coding.setCodeSimple(string);
        coding.setSystemSimple(string2);
        coding.setDisplaySimple(string3);
        codeableConcept.getCoding().add(coding);
        return codeableConcept;
    }

    public static ResourceReference makeResourceReference(String string) throws Exception {
        ResourceReference resourceReference = new ResourceReference();
        resourceReference.setReferenceSimple(string);
        return resourceReference;
    }

    public static DateTimeType nowDateTime() {
        DateTimeType dateTimeType = new DateTimeType();
        dateTimeType.setValue(DateAndTime.now());
        return dateTimeType;
    }

    public static Narrative newNarrative(Narrative.NarrativeStatus narrativeStatus, String string) throws Exception {
        Narrative narrative = new Narrative();
        narrative.setStatusSimple(narrativeStatus);
        narrative.setDiv(new XhtmlParser().parseFragment("<div>" + Utilities.escapeXml(string) + "</div>"));
        return narrative;
    }

    public InstantType nowInstant() {
        InstantType instantType = new InstantType();
        instantType.setValue(DateAndTime.now());
        return instantType;
    }
}

