/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;

public class FamilyHistory
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected ResourceReference subject;
    protected Patient subjectTarget;
    protected StringType note;
    protected List<FamilyHistoryRelationComponent> relation = new ArrayList<FamilyHistoryRelationComponent>();
    private static final long serialVersionUID = 1534109677L;

    public FamilyHistory() {
    }

    public FamilyHistory(ResourceReference resourceReference) {
        this.subject = resourceReference;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public FamilyHistory setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Patient getSubjectTarget() {
        return this.subjectTarget;
    }

    public FamilyHistory setSubjectTarget(Patient patient) {
        this.subjectTarget = patient;
        return this;
    }

    public StringType getNote() {
        return this.note;
    }

    public FamilyHistory setNote(StringType stringType) {
        this.note = stringType;
        return this;
    }

    public String getNoteSimple() {
        return this.note == null ? null : this.note.getValue();
    }

    public FamilyHistory setNoteSimple(String string) {
        if (string == null) {
            this.note = null;
        } else {
            if (this.note == null) {
                this.note = new StringType();
            }
            this.note.setValue(string);
        }
        return this;
    }

    public List<FamilyHistoryRelationComponent> getRelation() {
        return this.relation;
    }

    public FamilyHistoryRelationComponent addRelation() {
        FamilyHistoryRelationComponent familyHistoryRelationComponent = new FamilyHistoryRelationComponent();
        this.relation.add(familyHistoryRelationComponent);
        return familyHistoryRelationComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "This records identifiers associated with this family history record that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("subject", "Resource(Patient)", "The person who this history concerns.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("note", "string", "Conveys information about family history not specific to individual relations.", 0, Integer.MAX_VALUE, this.note));
        list.add(new Property("relation", "", "The related person. Each FamilyHistory resource contains the entire family history for a single person.", 0, Integer.MAX_VALUE, this.relation));
    }

    public FamilyHistory copy() {
        FamilyHistory familyHistory = new FamilyHistory();
        familyHistory.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            familyHistory.identifier.add(element.copy());
        }
        familyHistory.subject = this.subject == null ? null : this.subject.copy();
        familyHistory.note = this.note == null ? null : this.note.copy();
        familyHistory.relation = new ArrayList<FamilyHistoryRelationComponent>();
        for (FamilyHistoryRelationComponent familyHistoryRelationComponent : this.relation) {
            familyHistory.relation.add(familyHistoryRelationComponent.copy());
        }
        return familyHistory;
    }

    protected FamilyHistory typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.FamilyHistory;
    }

    public static class FamilyHistoryRelationConditionComponent
    extends BackboneElement {
        protected CodeableConcept type;
        protected CodeableConcept outcome;
        protected Type onset;
        protected StringType note;
        private static final long serialVersionUID = -1664709272L;

        public FamilyHistoryRelationConditionComponent() {
        }

        public FamilyHistoryRelationConditionComponent(CodeableConcept codeableConcept) {
            this.type = codeableConcept;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public FamilyHistoryRelationConditionComponent setType(CodeableConcept codeableConcept) {
            this.type = codeableConcept;
            return this;
        }

        public CodeableConcept getOutcome() {
            return this.outcome;
        }

        public FamilyHistoryRelationConditionComponent setOutcome(CodeableConcept codeableConcept) {
            this.outcome = codeableConcept;
            return this;
        }

        public Type getOnset() {
            return this.onset;
        }

        public FamilyHistoryRelationConditionComponent setOnset(Type type) {
            this.onset = type;
            return this;
        }

        public StringType getNote() {
            return this.note;
        }

        public FamilyHistoryRelationConditionComponent setNote(StringType stringType) {
            this.note = stringType;
            return this;
        }

        public String getNoteSimple() {
            return this.note == null ? null : this.note.getValue();
        }

        public FamilyHistoryRelationConditionComponent setNoteSimple(String string) {
            if (string == null) {
                this.note = null;
            } else {
                if (this.note == null) {
                    this.note = new StringType();
                }
                this.note.setValue(string);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("type", "CodeableConcept", "The actual condition specified. Could be a coded condition (like MI or Diabetes) or a less specific string like 'cancer' depending on how much is known about the condition and the capabilities of the creating system.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("outcome", "CodeableConcept", "Indicates what happened as a result of this condition.  If the condition resulted in death, deceased date is captured on the relation.", 0, Integer.MAX_VALUE, this.outcome));
            list.add(new Property("onset[x]", "Age|Range|string", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, Integer.MAX_VALUE, this.onset));
            list.add(new Property("note", "string", "An area where general notes can be placed about this specific condition.", 0, Integer.MAX_VALUE, this.note));
        }

        public FamilyHistoryRelationConditionComponent copy() {
            FamilyHistoryRelationConditionComponent familyHistoryRelationConditionComponent = new FamilyHistoryRelationConditionComponent();
            familyHistoryRelationConditionComponent.type = this.type == null ? null : this.type.copy();
            familyHistoryRelationConditionComponent.outcome = this.outcome == null ? null : this.outcome.copy();
            familyHistoryRelationConditionComponent.onset = this.onset == null ? null : this.onset.copy();
            familyHistoryRelationConditionComponent.note = this.note == null ? null : this.note.copy();
            return familyHistoryRelationConditionComponent;
        }
    }

    public static class FamilyHistoryRelationComponent
    extends BackboneElement {
        protected StringType name;
        protected CodeableConcept relationship;
        protected Type born;
        protected Type deceased;
        protected StringType note;
        protected List<FamilyHistoryRelationConditionComponent> condition = new ArrayList<FamilyHistoryRelationConditionComponent>();
        private static final long serialVersionUID = -234064669L;

        public FamilyHistoryRelationComponent() {
        }

        public FamilyHistoryRelationComponent(CodeableConcept codeableConcept) {
            this.relationship = codeableConcept;
        }

        public StringType getName() {
            return this.name;
        }

        public FamilyHistoryRelationComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public FamilyHistoryRelationComponent setNameSimple(String string) {
            if (string == null) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(string);
            }
            return this;
        }

        public CodeableConcept getRelationship() {
            return this.relationship;
        }

        public FamilyHistoryRelationComponent setRelationship(CodeableConcept codeableConcept) {
            this.relationship = codeableConcept;
            return this;
        }

        public Type getBorn() {
            return this.born;
        }

        public FamilyHistoryRelationComponent setBorn(Type type) {
            this.born = type;
            return this;
        }

        public Type getDeceased() {
            return this.deceased;
        }

        public FamilyHistoryRelationComponent setDeceased(Type type) {
            this.deceased = type;
            return this;
        }

        public StringType getNote() {
            return this.note;
        }

        public FamilyHistoryRelationComponent setNote(StringType stringType) {
            this.note = stringType;
            return this;
        }

        public String getNoteSimple() {
            return this.note == null ? null : this.note.getValue();
        }

        public FamilyHistoryRelationComponent setNoteSimple(String string) {
            if (string == null) {
                this.note = null;
            } else {
                if (this.note == null) {
                    this.note = new StringType();
                }
                this.note.setValue(string);
            }
            return this;
        }

        public List<FamilyHistoryRelationConditionComponent> getCondition() {
            return this.condition;
        }

        public FamilyHistoryRelationConditionComponent addCondition() {
            FamilyHistoryRelationConditionComponent familyHistoryRelationConditionComponent = new FamilyHistoryRelationConditionComponent();
            this.condition.add(familyHistoryRelationConditionComponent);
            return familyHistoryRelationConditionComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("name", "string", "This will either be a name or a description.  E.g. 'Aunt Susan', 'my cousin with the red hair'.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("relationship", "CodeableConcept", "The type of relationship this person has to the patient (father, mother, brother etc.).", 0, Integer.MAX_VALUE, this.relationship));
            list.add(new Property("born[x]", "Period|date|string", "The actual or approximate date of birth of the relative.", 0, Integer.MAX_VALUE, this.born));
            list.add(new Property("deceased[x]", "boolean|Age|Range|date|string", "If this resource is indicating that the related person is deceased, then an indicator of whether the person is deceased (yes) or not (no) or the age or age range or description of age at death - can be indicated here. If the reason for death is known, then it can be indicated in the outcome code of the condition - in this case the deceased property should still be set.", 0, Integer.MAX_VALUE, this.deceased));
            list.add(new Property("note", "string", "This property allows a non condition-specific note to the made about the related person. Ideally, the note would be in the condition property, but this is not always possible.", 0, Integer.MAX_VALUE, this.note));
            list.add(new Property("condition", "", "The significant Conditions (or condition) that the family member had. This is a repeating section to allow a system to represent more than one condition per resource, though there is nothing stopping multiple resources - one per condition.", 0, Integer.MAX_VALUE, this.condition));
        }

        public FamilyHistoryRelationComponent copy() {
            FamilyHistoryRelationComponent familyHistoryRelationComponent = new FamilyHistoryRelationComponent();
            familyHistoryRelationComponent.name = this.name == null ? null : this.name.copy();
            familyHistoryRelationComponent.relationship = this.relationship == null ? null : this.relationship.copy();
            familyHistoryRelationComponent.born = this.born == null ? null : this.born.copy();
            familyHistoryRelationComponent.deceased = this.deceased == null ? null : this.deceased.copy();
            familyHistoryRelationComponent.note = this.note == null ? null : this.note.copy();
            familyHistoryRelationComponent.condition = new ArrayList<FamilyHistoryRelationConditionComponent>();
            for (FamilyHistoryRelationConditionComponent familyHistoryRelationConditionComponent : this.condition) {
                familyHistoryRelationComponent.condition.add(familyHistoryRelationConditionComponent.copy());
            }
            return familyHistoryRelationComponent;
        }
    }
}

