/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;

public class Group
extends Resource {
    protected Identifier identifier;
    protected Enumeration<GroupType> type;
    protected BooleanType actual;
    protected CodeableConcept code;
    protected StringType name;
    protected IntegerType quantity;
    protected List<GroupCharacteristicComponent> characteristic = new ArrayList<GroupCharacteristicComponent>();
    protected List<ResourceReference> member = new ArrayList<ResourceReference>();
    protected List<Resource> memberTarget = new ArrayList<Resource>();
    private static final long serialVersionUID = -1925725072L;

    public Group() {
    }

    public Group(Enumeration<GroupType> enumeration, BooleanType booleanType) {
        this.type = enumeration;
        this.actual = booleanType;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Group setIdentifier(Identifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public Enumeration<GroupType> getType() {
        return this.type;
    }

    public Group setType(Enumeration<GroupType> enumeration) {
        this.type = enumeration;
        return this;
    }

    public GroupType getTypeSimple() {
        return this.type == null ? null : this.type.getValue();
    }

    public Group setTypeSimple(GroupType groupType) {
        if (this.type == null) {
            this.type = new Enumeration();
        }
        this.type.setValue(groupType);
        return this;
    }

    public BooleanType getActual() {
        return this.actual;
    }

    public Group setActual(BooleanType booleanType) {
        this.actual = booleanType;
        return this;
    }

    public boolean getActualSimple() {
        return this.actual == null ? false : this.actual.getValue();
    }

    public Group setActualSimple(boolean bl) {
        if (this.actual == null) {
            this.actual = new BooleanType();
        }
        this.actual.setValue(bl);
        return this;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public Group setCode(CodeableConcept codeableConcept) {
        this.code = codeableConcept;
        return this;
    }

    public StringType getName() {
        return this.name;
    }

    public Group setName(StringType stringType) {
        this.name = stringType;
        return this;
    }

    public String getNameSimple() {
        return this.name == null ? null : this.name.getValue();
    }

    public Group setNameSimple(String string) {
        if (string == null) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(string);
        }
        return this;
    }

    public IntegerType getQuantity() {
        return this.quantity;
    }

    public Group setQuantity(IntegerType integerType) {
        this.quantity = integerType;
        return this;
    }

    public int getQuantitySimple() {
        return this.quantity == null ? null : Integer.valueOf(this.quantity.getValue());
    }

    public Group setQuantitySimple(int n) {
        if (n == -1) {
            this.quantity = null;
        } else {
            if (this.quantity == null) {
                this.quantity = new IntegerType();
            }
            this.quantity.setValue(n);
        }
        return this;
    }

    public List<GroupCharacteristicComponent> getCharacteristic() {
        return this.characteristic;
    }

    public GroupCharacteristicComponent addCharacteristic() {
        GroupCharacteristicComponent groupCharacteristicComponent = new GroupCharacteristicComponent();
        this.characteristic.add(groupCharacteristicComponent);
        return groupCharacteristicComponent;
    }

    public List<ResourceReference> getMember() {
        return this.member;
    }

    public ResourceReference addMember() {
        ResourceReference resourceReference = new ResourceReference();
        this.member.add(resourceReference);
        return resourceReference;
    }

    public List<Resource> getMemberTarget() {
        return this.memberTarget;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "A unique business identifier for this group.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("type", "code", "Identifies the broad classification of the kind of resources the group includes.", 0, Integer.MAX_VALUE, this.type));
        list.add(new Property("actual", "boolean", "If true, indicates that the resource refers to a specific group of real individuals.  If false, the group defines a set of intended individuals.", 0, Integer.MAX_VALUE, this.actual));
        list.add(new Property("code", "CodeableConcept", "Provides a specific type of resource the group includes.  E.g. 'cow', 'syringe', etc.", 0, Integer.MAX_VALUE, this.code));
        list.add(new Property("name", "string", "A label assigned to the group for human identification and communication.", 0, Integer.MAX_VALUE, this.name));
        list.add(new Property("quantity", "integer", "A count of the number of resource instances that are part of the group.", 0, Integer.MAX_VALUE, this.quantity));
        list.add(new Property("characteristic", "", "Identifies the traits shared by members of the group.", 0, Integer.MAX_VALUE, this.characteristic));
        list.add(new Property("member", "Resource(Patient|Practitioner|Device|Medication|Substance)", "Identifies the resource instances that are members of the group.", 0, Integer.MAX_VALUE, this.member));
    }

    public Group copy() {
        Group group = new Group();
        group.identifier = this.identifier == null ? null : this.identifier.copy();
        group.type = this.type == null ? null : this.type.copy();
        group.actual = this.actual == null ? null : this.actual.copy();
        group.code = this.code == null ? null : this.code.copy();
        group.name = this.name == null ? null : this.name.copy();
        group.quantity = this.quantity == null ? null : this.quantity.copy();
        group.characteristic = new ArrayList<GroupCharacteristicComponent>();
        for (GroupCharacteristicComponent element : this.characteristic) {
            group.characteristic.add(element.copy());
        }
        group.member = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.member) {
            group.member.add(resourceReference.copy());
        }
        return group;
    }

    protected Group typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Group;
    }

    public static class GroupCharacteristicComponent
    extends BackboneElement {
        protected CodeableConcept code;
        protected Type value;
        protected BooleanType exclude;
        private static final long serialVersionUID = 803478031L;

        public GroupCharacteristicComponent() {
        }

        public GroupCharacteristicComponent(CodeableConcept codeableConcept, Type type, BooleanType booleanType) {
            this.code = codeableConcept;
            this.value = type;
            this.exclude = booleanType;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public GroupCharacteristicComponent setCode(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public GroupCharacteristicComponent setValue(Type type) {
            this.value = type;
            return this;
        }

        public BooleanType getExclude() {
            return this.exclude;
        }

        public GroupCharacteristicComponent setExclude(BooleanType booleanType) {
            this.exclude = booleanType;
            return this;
        }

        public boolean getExcludeSimple() {
            return this.exclude == null ? false : this.exclude.getValue();
        }

        public GroupCharacteristicComponent setExcludeSimple(boolean bl) {
            if (this.exclude == null) {
                this.exclude = new BooleanType();
            }
            this.exclude.setValue(bl);
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "CodeableConcept", "A code that identifies the kind of trait being asserted.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("value[x]", "CodeableConcept|boolean|Quantity|Range", "The value of the trait that holds (or does not hold - see 'exclude') for members of the group.", 0, Integer.MAX_VALUE, this.value));
            list.add(new Property("exclude", "boolean", "If true, indicates the characteristic is one that is NOT held by members of the group.", 0, Integer.MAX_VALUE, this.exclude));
        }

        public GroupCharacteristicComponent copy() {
            GroupCharacteristicComponent groupCharacteristicComponent = new GroupCharacteristicComponent();
            groupCharacteristicComponent.code = this.code == null ? null : this.code.copy();
            groupCharacteristicComponent.value = this.value == null ? null : this.value.copy();
            groupCharacteristicComponent.exclude = this.exclude == null ? null : this.exclude.copy();
            return groupCharacteristicComponent;
        }
    }

    public static class GroupTypeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("person".equals(string)) {
                return GroupType.person;
            }
            if ("animal".equals(string)) {
                return GroupType.animal;
            }
            if ("practitioner".equals(string)) {
                return GroupType.practitioner;
            }
            if ("device".equals(string)) {
                return GroupType.device;
            }
            if ("medication".equals(string)) {
                return GroupType.medication;
            }
            if ("substance".equals(string)) {
                return GroupType.substance;
            }
            throw new Exception("Unknown GroupType code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == GroupType.person) {
                return "person";
            }
            if (enum_ == GroupType.animal) {
                return "animal";
            }
            if (enum_ == GroupType.practitioner) {
                return "practitioner";
            }
            if (enum_ == GroupType.device) {
                return "device";
            }
            if (enum_ == GroupType.medication) {
                return "medication";
            }
            if (enum_ == GroupType.substance) {
                return "substance";
            }
            return "?";
        }
    }

    public static enum GroupType {
        person,
        animal,
        practitioner,
        device,
        medication,
        substance,
        Null;


        public static GroupType fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("person".equals(string)) {
                return person;
            }
            if ("animal".equals(string)) {
                return animal;
            }
            if ("practitioner".equals(string)) {
                return practitioner;
            }
            if ("device".equals(string)) {
                return device;
            }
            if ("medication".equals(string)) {
                return medication;
            }
            if ("substance".equals(string)) {
                return substance;
            }
            throw new Exception("Unknown GroupType code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case person: {
                    return "person";
                }
                case animal: {
                    return "animal";
                }
                case practitioner: {
                    return "practitioner";
                }
                case device: {
                    return "device";
                }
                case medication: {
                    return "medication";
                }
                case substance: {
                    return "substance";
                }
            }
            return "?";
        }
    }
}

