/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;

public class HumanName
extends Type {
    protected Enumeration<NameUse> use;
    protected StringType text;
    protected List<StringType> family = new ArrayList<StringType>();
    protected List<StringType> given = new ArrayList<StringType>();
    protected List<StringType> prefix = new ArrayList<StringType>();
    protected List<StringType> suffix = new ArrayList<StringType>();
    protected Period period;
    private static final long serialVersionUID = -512452810L;

    public Enumeration<NameUse> getUse() {
        return this.use;
    }

    public HumanName setUse(Enumeration<NameUse> enumeration) {
        this.use = enumeration;
        return this;
    }

    public NameUse getUseSimple() {
        return this.use == null ? null : this.use.getValue();
    }

    public HumanName setUseSimple(NameUse nameUse) {
        if (nameUse == null) {
            this.use = null;
        } else {
            if (this.use == null) {
                this.use = new Enumeration();
            }
            this.use.setValue(nameUse);
        }
        return this;
    }

    public StringType getText() {
        return this.text;
    }

    public HumanName setText(StringType stringType) {
        this.text = stringType;
        return this;
    }

    public String getTextSimple() {
        return this.text == null ? null : this.text.getValue();
    }

    public HumanName setTextSimple(String string) {
        if (string == null) {
            this.text = null;
        } else {
            if (this.text == null) {
                this.text = new StringType();
            }
            this.text.setValue(string);
        }
        return this;
    }

    public List<StringType> getFamily() {
        return this.family;
    }

    public StringType addFamily() {
        StringType stringType = new StringType();
        this.family.add(stringType);
        return stringType;
    }

    public StringType addFamilySimple(String string) {
        StringType stringType = new StringType();
        stringType.setValue(string);
        this.family.add(stringType);
        return stringType;
    }

    public boolean hasFamilySimple(String string) {
        for (StringType stringType : this.family) {
            if (!stringType.getValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getGiven() {
        return this.given;
    }

    public StringType addGiven() {
        StringType stringType = new StringType();
        this.given.add(stringType);
        return stringType;
    }

    public StringType addGivenSimple(String string) {
        StringType stringType = new StringType();
        stringType.setValue(string);
        this.given.add(stringType);
        return stringType;
    }

    public boolean hasGivenSimple(String string) {
        for (StringType stringType : this.given) {
            if (!stringType.getValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getPrefix() {
        return this.prefix;
    }

    public StringType addPrefix() {
        StringType stringType = new StringType();
        this.prefix.add(stringType);
        return stringType;
    }

    public StringType addPrefixSimple(String string) {
        StringType stringType = new StringType();
        stringType.setValue(string);
        this.prefix.add(stringType);
        return stringType;
    }

    public boolean hasPrefixSimple(String string) {
        for (StringType stringType : this.prefix) {
            if (!stringType.getValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getSuffix() {
        return this.suffix;
    }

    public StringType addSuffix() {
        StringType stringType = new StringType();
        this.suffix.add(stringType);
        return stringType;
    }

    public StringType addSuffixSimple(String string) {
        StringType stringType = new StringType();
        stringType.setValue(string);
        this.suffix.add(stringType);
        return stringType;
    }

    public boolean hasSuffixSimple(String string) {
        for (StringType stringType : this.suffix) {
            if (!stringType.getValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Period getPeriod() {
        return this.period;
    }

    public HumanName setPeriod(Period period) {
        this.period = period;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("use", "code", "Identifies the purpose for this name.", 0, Integer.MAX_VALUE, this.use));
        list.add(new Property("text", "string", "A full text representation of the name.", 0, Integer.MAX_VALUE, this.text));
        list.add(new Property("family", "string", "The part of a name that links to the genealogy. In some cultures (e.g. Eritrea) the family name of a son is the first name of his father.", 0, Integer.MAX_VALUE, this.family));
        list.add(new Property("given", "string", "Given name.", 0, Integer.MAX_VALUE, this.given));
        list.add(new Property("prefix", "string", "Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the start of the name.", 0, Integer.MAX_VALUE, this.prefix));
        list.add(new Property("suffix", "string", "Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the end of the name.", 0, Integer.MAX_VALUE, this.suffix));
        list.add(new Property("period", "Period", "Indicates the period of time when this name was valid for the named person.", 0, Integer.MAX_VALUE, this.period));
    }

    @Override
    public HumanName copy() {
        HumanName humanName = new HumanName();
        humanName.use = this.use == null ? null : this.use.copy();
        humanName.text = this.text == null ? null : this.text.copy();
        humanName.family = new ArrayList<StringType>();
        for (StringType stringType : this.family) {
            humanName.family.add(stringType.copy());
        }
        humanName.given = new ArrayList<StringType>();
        for (StringType stringType : this.given) {
            humanName.given.add(stringType.copy());
        }
        humanName.prefix = new ArrayList<StringType>();
        for (StringType stringType : this.prefix) {
            humanName.prefix.add(stringType.copy());
        }
        humanName.suffix = new ArrayList<StringType>();
        for (StringType stringType : this.suffix) {
            humanName.suffix.add(stringType.copy());
        }
        humanName.period = this.period == null ? null : this.period.copy();
        return humanName;
    }

    @Override
    protected HumanName typedCopy() {
        return this.copy();
    }

    public static class NameUseEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("usual".equals(string)) {
                return NameUse.usual;
            }
            if ("official".equals(string)) {
                return NameUse.official;
            }
            if ("temp".equals(string)) {
                return NameUse.temp;
            }
            if ("nickname".equals(string)) {
                return NameUse.nickname;
            }
            if ("anonymous".equals(string)) {
                return NameUse.anonymous;
            }
            if ("old".equals(string)) {
                return NameUse.old;
            }
            if ("maiden".equals(string)) {
                return NameUse.maiden;
            }
            throw new Exception("Unknown NameUse code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == NameUse.usual) {
                return "usual";
            }
            if (enum_ == NameUse.official) {
                return "official";
            }
            if (enum_ == NameUse.temp) {
                return "temp";
            }
            if (enum_ == NameUse.nickname) {
                return "nickname";
            }
            if (enum_ == NameUse.anonymous) {
                return "anonymous";
            }
            if (enum_ == NameUse.old) {
                return "old";
            }
            if (enum_ == NameUse.maiden) {
                return "maiden";
            }
            return "?";
        }
    }

    public static enum NameUse {
        usual,
        official,
        temp,
        nickname,
        anonymous,
        old,
        maiden,
        Null;


        public static NameUse fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("usual".equals(string)) {
                return usual;
            }
            if ("official".equals(string)) {
                return official;
            }
            if ("temp".equals(string)) {
                return temp;
            }
            if ("nickname".equals(string)) {
                return nickname;
            }
            if ("anonymous".equals(string)) {
                return anonymous;
            }
            if ("old".equals(string)) {
                return old;
            }
            if ("maiden".equals(string)) {
                return maiden;
            }
            throw new Exception("Unknown NameUse code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case usual: {
                    return "usual";
                }
                case official: {
                    return "official";
                }
                case temp: {
                    return "temp";
                }
                case nickname: {
                    return "nickname";
                }
                case anonymous: {
                    return "anonymous";
                }
                case old: {
                    return "old";
                }
                case maiden: {
                    return "maiden";
                }
            }
            return "?";
        }
    }
}

