/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.List;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;

public class Identifier
extends Type {
    protected Enumeration<IdentifierUse> use;
    protected StringType label;
    protected UriType system;
    protected StringType value;
    protected Period period;
    protected ResourceReference assigner;
    protected Organization assignerTarget;
    private static final long serialVersionUID = -892620253L;

    public Enumeration<IdentifierUse> getUse() {
        return this.use;
    }

    public Identifier setUse(Enumeration<IdentifierUse> enumeration) {
        this.use = enumeration;
        return this;
    }

    public IdentifierUse getUseSimple() {
        return this.use == null ? null : this.use.getValue();
    }

    public Identifier setUseSimple(IdentifierUse identifierUse) {
        if (identifierUse == null) {
            this.use = null;
        } else {
            if (this.use == null) {
                this.use = new Enumeration();
            }
            this.use.setValue(identifierUse);
        }
        return this;
    }

    public StringType getLabel() {
        return this.label;
    }

    public Identifier setLabel(StringType stringType) {
        this.label = stringType;
        return this;
    }

    public String getLabelSimple() {
        return this.label == null ? null : this.label.getValue();
    }

    public Identifier setLabelSimple(String string) {
        if (string == null) {
            this.label = null;
        } else {
            if (this.label == null) {
                this.label = new StringType();
            }
            this.label.setValue(string);
        }
        return this;
    }

    public UriType getSystem() {
        return this.system;
    }

    public Identifier setSystem(UriType uriType) {
        this.system = uriType;
        return this;
    }

    public String getSystemSimple() {
        return this.system == null ? null : this.system.getValue();
    }

    public Identifier setSystemSimple(String string) {
        if (string == null) {
            this.system = null;
        } else {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(string);
        }
        return this;
    }

    public StringType getValue() {
        return this.value;
    }

    public Identifier setValue(StringType stringType) {
        this.value = stringType;
        return this;
    }

    public String getValueSimple() {
        return this.value == null ? null : this.value.getValue();
    }

    public Identifier setValueSimple(String string) {
        if (string == null) {
            this.value = null;
        } else {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(string);
        }
        return this;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Identifier setPeriod(Period period) {
        this.period = period;
        return this;
    }

    public ResourceReference getAssigner() {
        return this.assigner;
    }

    public Identifier setAssigner(ResourceReference resourceReference) {
        this.assigner = resourceReference;
        return this;
    }

    public Organization getAssignerTarget() {
        return this.assignerTarget;
    }

    public Identifier setAssignerTarget(Organization organization) {
        this.assignerTarget = organization;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("use", "code", "The purpose of this identifier.", 0, Integer.MAX_VALUE, this.use));
        list.add(new Property("label", "string", "A text string for the identifier that can be displayed to a human so they can recognize the identifier.", 0, Integer.MAX_VALUE, this.label));
        list.add(new Property("system", "uri", "Establishes the namespace in which set of possible id values is unique.", 0, Integer.MAX_VALUE, this.system));
        list.add(new Property("value", "string", "The portion of the identifier typically displayed to the user and which is unique within the context of the system.", 0, Integer.MAX_VALUE, this.value));
        list.add(new Property("period", "Period", "Time period during which identifier is/was valid for use.", 0, Integer.MAX_VALUE, this.period));
        list.add(new Property("assigner", "Resource(Organization)", "Organization that issued/manages the identifier.", 0, Integer.MAX_VALUE, this.assigner));
    }

    @Override
    public Identifier copy() {
        Identifier identifier = new Identifier();
        identifier.use = this.use == null ? null : this.use.copy();
        identifier.label = this.label == null ? null : this.label.copy();
        identifier.system = this.system == null ? null : this.system.copy();
        identifier.value = this.value == null ? null : this.value.copy();
        identifier.period = this.period == null ? null : this.period.copy();
        identifier.assigner = this.assigner == null ? null : this.assigner.copy();
        return identifier;
    }

    @Override
    protected Identifier typedCopy() {
        return this.copy();
    }

    public static class IdentifierUseEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("usual".equals(string)) {
                return IdentifierUse.usual;
            }
            if ("official".equals(string)) {
                return IdentifierUse.official;
            }
            if ("temp".equals(string)) {
                return IdentifierUse.temp;
            }
            if ("secondary".equals(string)) {
                return IdentifierUse.secondary;
            }
            throw new Exception("Unknown IdentifierUse code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == IdentifierUse.usual) {
                return "usual";
            }
            if (enum_ == IdentifierUse.official) {
                return "official";
            }
            if (enum_ == IdentifierUse.temp) {
                return "temp";
            }
            if (enum_ == IdentifierUse.secondary) {
                return "secondary";
            }
            return "?";
        }
    }

    public static enum IdentifierUse {
        usual,
        official,
        temp,
        secondary,
        Null;


        public static IdentifierUse fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("usual".equals(string)) {
                return usual;
            }
            if ("official".equals(string)) {
                return official;
            }
            if ("temp".equals(string)) {
                return temp;
            }
            if ("secondary".equals(string)) {
                return secondary;
            }
            throw new Exception("Unknown IdentifierUse code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case usual: {
                    return "usual";
                }
                case official: {
                    return "official";
                }
                case temp: {
                    return "temp";
                }
                case secondary: {
                    return "secondary";
                }
            }
            return "?";
        }
    }
}

