/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DiagnosticOrder;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.OidType;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.UriType;

public class ImagingStudy
extends Resource {
    protected DateTimeType dateTime;
    protected ResourceReference subject;
    protected Patient subjectTarget;
    protected OidType uid;
    protected Identifier accessionNo;
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected List<ResourceReference> order = new ArrayList<ResourceReference>();
    protected List<DiagnosticOrder> orderTarget = new ArrayList<DiagnosticOrder>();
    protected List<Enumeration<ImagingModality>> modality = new ArrayList<Enumeration<ImagingModality>>();
    protected ResourceReference referrer;
    protected Practitioner referrerTarget;
    protected Enumeration<InstanceAvailability> availability;
    protected UriType url;
    protected IntegerType numberOfSeries;
    protected IntegerType numberOfInstances;
    protected StringType clinicalInformation;
    protected List<Coding> procedure = new ArrayList<Coding>();
    protected ResourceReference interpreter;
    protected Practitioner interpreterTarget;
    protected StringType description;
    protected List<ImagingStudySeriesComponent> series = new ArrayList<ImagingStudySeriesComponent>();
    private static final long serialVersionUID = -358913729L;

    public ImagingStudy() {
    }

    public ImagingStudy(ResourceReference resourceReference, OidType oidType, IntegerType integerType, IntegerType integerType2) {
        this.subject = resourceReference;
        this.uid = oidType;
        this.numberOfSeries = integerType;
        this.numberOfInstances = integerType2;
    }

    public DateTimeType getDateTime() {
        return this.dateTime;
    }

    public ImagingStudy setDateTime(DateTimeType dateTimeType) {
        this.dateTime = dateTimeType;
        return this;
    }

    public DateAndTime getDateTimeSimple() {
        return this.dateTime == null ? null : this.dateTime.getValue();
    }

    public ImagingStudy setDateTimeSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.dateTime = null;
        } else {
            if (this.dateTime == null) {
                this.dateTime = new DateTimeType();
            }
            this.dateTime.setValue(dateAndTime);
        }
        return this;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public ImagingStudy setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Patient getSubjectTarget() {
        return this.subjectTarget;
    }

    public ImagingStudy setSubjectTarget(Patient patient) {
        this.subjectTarget = patient;
        return this;
    }

    public OidType getUid() {
        return this.uid;
    }

    public ImagingStudy setUid(OidType oidType) {
        this.uid = oidType;
        return this;
    }

    public String getUidSimple() {
        return this.uid == null ? null : this.uid.getValue();
    }

    public ImagingStudy setUidSimple(String string) {
        if (this.uid == null) {
            this.uid = new OidType();
        }
        this.uid.setValue(string);
        return this;
    }

    public Identifier getAccessionNo() {
        return this.accessionNo;
    }

    public ImagingStudy setAccessionNo(Identifier identifier) {
        this.accessionNo = identifier;
        return this;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public List<ResourceReference> getOrder() {
        return this.order;
    }

    public ResourceReference addOrder() {
        ResourceReference resourceReference = new ResourceReference();
        this.order.add(resourceReference);
        return resourceReference;
    }

    public List<DiagnosticOrder> getOrderTarget() {
        return this.orderTarget;
    }

    public DiagnosticOrder addOrderTarget() {
        DiagnosticOrder diagnosticOrder = new DiagnosticOrder();
        this.orderTarget.add(diagnosticOrder);
        return diagnosticOrder;
    }

    public List<Enumeration<ImagingModality>> getModality() {
        return this.modality;
    }

    public Enumeration<ImagingModality> addModality() {
        Enumeration<ImagingModality> enumeration = new Enumeration<ImagingModality>();
        this.modality.add(enumeration);
        return enumeration;
    }

    public Enumeration<ImagingModality> addModalitySimple(ImagingModality imagingModality) {
        Enumeration<ImagingModality> enumeration = new Enumeration<ImagingModality>();
        enumeration.setValue(imagingModality);
        this.modality.add(enumeration);
        return enumeration;
    }

    public boolean hasModalitySimple(ImagingModality imagingModality) {
        for (Enumeration<ImagingModality> enumeration : this.modality) {
            if (!enumeration.getValue().equals((Object)imagingModality)) continue;
            return true;
        }
        return false;
    }

    public ResourceReference getReferrer() {
        return this.referrer;
    }

    public ImagingStudy setReferrer(ResourceReference resourceReference) {
        this.referrer = resourceReference;
        return this;
    }

    public Practitioner getReferrerTarget() {
        return this.referrerTarget;
    }

    public ImagingStudy setReferrerTarget(Practitioner practitioner) {
        this.referrerTarget = practitioner;
        return this;
    }

    public Enumeration<InstanceAvailability> getAvailability() {
        return this.availability;
    }

    public ImagingStudy setAvailability(Enumeration<InstanceAvailability> enumeration) {
        this.availability = enumeration;
        return this;
    }

    public InstanceAvailability getAvailabilitySimple() {
        return this.availability == null ? null : this.availability.getValue();
    }

    public ImagingStudy setAvailabilitySimple(InstanceAvailability instanceAvailability) {
        if (instanceAvailability == null) {
            this.availability = null;
        } else {
            if (this.availability == null) {
                this.availability = new Enumeration();
            }
            this.availability.setValue(instanceAvailability);
        }
        return this;
    }

    public UriType getUrl() {
        return this.url;
    }

    public ImagingStudy setUrl(UriType uriType) {
        this.url = uriType;
        return this;
    }

    public String getUrlSimple() {
        return this.url == null ? null : this.url.getValue();
    }

    public ImagingStudy setUrlSimple(String string) {
        if (string == null) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(string);
        }
        return this;
    }

    public IntegerType getNumberOfSeries() {
        return this.numberOfSeries;
    }

    public ImagingStudy setNumberOfSeries(IntegerType integerType) {
        this.numberOfSeries = integerType;
        return this;
    }

    public int getNumberOfSeriesSimple() {
        return this.numberOfSeries == null ? null : Integer.valueOf(this.numberOfSeries.getValue());
    }

    public ImagingStudy setNumberOfSeriesSimple(int n) {
        if (this.numberOfSeries == null) {
            this.numberOfSeries = new IntegerType();
        }
        this.numberOfSeries.setValue(n);
        return this;
    }

    public IntegerType getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public ImagingStudy setNumberOfInstances(IntegerType integerType) {
        this.numberOfInstances = integerType;
        return this;
    }

    public int getNumberOfInstancesSimple() {
        return this.numberOfInstances == null ? null : Integer.valueOf(this.numberOfInstances.getValue());
    }

    public ImagingStudy setNumberOfInstancesSimple(int n) {
        if (this.numberOfInstances == null) {
            this.numberOfInstances = new IntegerType();
        }
        this.numberOfInstances.setValue(n);
        return this;
    }

    public StringType getClinicalInformation() {
        return this.clinicalInformation;
    }

    public ImagingStudy setClinicalInformation(StringType stringType) {
        this.clinicalInformation = stringType;
        return this;
    }

    public String getClinicalInformationSimple() {
        return this.clinicalInformation == null ? null : this.clinicalInformation.getValue();
    }

    public ImagingStudy setClinicalInformationSimple(String string) {
        if (string == null) {
            this.clinicalInformation = null;
        } else {
            if (this.clinicalInformation == null) {
                this.clinicalInformation = new StringType();
            }
            this.clinicalInformation.setValue(string);
        }
        return this;
    }

    public List<Coding> getProcedure() {
        return this.procedure;
    }

    public Coding addProcedure() {
        Coding coding = new Coding();
        this.procedure.add(coding);
        return coding;
    }

    public ResourceReference getInterpreter() {
        return this.interpreter;
    }

    public ImagingStudy setInterpreter(ResourceReference resourceReference) {
        this.interpreter = resourceReference;
        return this;
    }

    public Practitioner getInterpreterTarget() {
        return this.interpreterTarget;
    }

    public ImagingStudy setInterpreterTarget(Practitioner practitioner) {
        this.interpreterTarget = practitioner;
        return this;
    }

    public StringType getDescription() {
        return this.description;
    }

    public ImagingStudy setDescription(StringType stringType) {
        this.description = stringType;
        return this;
    }

    public String getDescriptionSimple() {
        return this.description == null ? null : this.description.getValue();
    }

    public ImagingStudy setDescriptionSimple(String string) {
        if (string == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(string);
        }
        return this;
    }

    public List<ImagingStudySeriesComponent> getSeries() {
        return this.series;
    }

    public ImagingStudySeriesComponent addSeries() {
        ImagingStudySeriesComponent imagingStudySeriesComponent = new ImagingStudySeriesComponent();
        this.series.add(imagingStudySeriesComponent);
        return imagingStudySeriesComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("dateTime", "dateTime", "Date and Time the study took place.", 0, Integer.MAX_VALUE, this.dateTime));
        list.add(new Property("subject", "Resource(Patient)", "Who the images are of.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("uid", "oid", "Formal identifier for the study.", 0, Integer.MAX_VALUE, this.uid));
        list.add(new Property("accessionNo", "Identifier", "Accession Number.", 0, Integer.MAX_VALUE, this.accessionNo));
        list.add(new Property("identifier", "Identifier", "Other identifiers for the study.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("order", "Resource(DiagnosticOrder)", "A list of the diagnostic orders that resulted in this imaging study being performed.", 0, Integer.MAX_VALUE, this.order));
        list.add(new Property("modality", "code", "A list of all the Series.ImageModality values that are actual acquisition modalities, i.e. those in the DICOM Context Group 29 (value set OID 1.2.840.10008.6.1.19).", 0, Integer.MAX_VALUE, this.modality));
        list.add(new Property("referrer", "Resource(Practitioner)", "The requesting/referring physician.", 0, Integer.MAX_VALUE, this.referrer));
        list.add(new Property("availability", "code", "Availability of study (online, offline or nearline).", 0, Integer.MAX_VALUE, this.availability));
        list.add(new Property("url", "uri", "WADO-RS URI where Study is available.", 0, Integer.MAX_VALUE, this.url));
        list.add(new Property("numberOfSeries", "integer", "Number of Series in Study.", 0, Integer.MAX_VALUE, this.numberOfSeries));
        list.add(new Property("numberOfInstances", "integer", "Number of SOP Instances in Study.", 0, Integer.MAX_VALUE, this.numberOfInstances));
        list.add(new Property("clinicalInformation", "string", "Diagnoses etc provided with request.", 0, Integer.MAX_VALUE, this.clinicalInformation));
        list.add(new Property("procedure", "Coding", "Type of procedure performed.", 0, Integer.MAX_VALUE, this.procedure));
        list.add(new Property("interpreter", "Resource(Practitioner)", "Who read study and interpreted the images.", 0, Integer.MAX_VALUE, this.interpreter));
        list.add(new Property("description", "string", "Institution-generated description or classification of the Study (component) performed.", 0, Integer.MAX_VALUE, this.description));
        list.add(new Property("series", "", "Each study has one or more series of image instances.", 0, Integer.MAX_VALUE, this.series));
    }

    public ImagingStudy copy() {
        ImagingStudy imagingStudy = new ImagingStudy();
        imagingStudy.dateTime = this.dateTime == null ? null : this.dateTime.copy();
        imagingStudy.subject = this.subject == null ? null : this.subject.copy();
        imagingStudy.uid = this.uid == null ? null : this.uid.copy();
        imagingStudy.accessionNo = this.accessionNo == null ? null : this.accessionNo.copy();
        imagingStudy.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            imagingStudy.identifier.add(element.copy());
        }
        imagingStudy.order = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.order) {
            imagingStudy.order.add(resourceReference.copy());
        }
        imagingStudy.modality = new ArrayList<Enumeration<ImagingModality>>();
        for (Enumeration enumeration : this.modality) {
            imagingStudy.modality.add((Enumeration<ImagingModality>)enumeration.copy());
        }
        imagingStudy.referrer = this.referrer == null ? null : this.referrer.copy();
        imagingStudy.availability = this.availability == null ? null : this.availability.copy();
        imagingStudy.url = this.url == null ? null : this.url.copy();
        imagingStudy.numberOfSeries = this.numberOfSeries == null ? null : this.numberOfSeries.copy();
        imagingStudy.numberOfInstances = this.numberOfInstances == null ? null : this.numberOfInstances.copy();
        imagingStudy.clinicalInformation = this.clinicalInformation == null ? null : this.clinicalInformation.copy();
        imagingStudy.procedure = new ArrayList<Coding>();
        for (Coding coding : this.procedure) {
            imagingStudy.procedure.add(coding.copy());
        }
        imagingStudy.interpreter = this.interpreter == null ? null : this.interpreter.copy();
        imagingStudy.description = this.description == null ? null : this.description.copy();
        imagingStudy.series = new ArrayList<ImagingStudySeriesComponent>();
        for (ImagingStudySeriesComponent imagingStudySeriesComponent : this.series) {
            imagingStudy.series.add(imagingStudySeriesComponent.copy());
        }
        return imagingStudy;
    }

    protected ImagingStudy typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImagingStudy;
    }

    public static class ImagingStudySeriesInstanceComponent
    extends BackboneElement {
        protected IntegerType number;
        protected OidType uid;
        protected OidType sopclass;
        protected StringType type;
        protected StringType title;
        protected UriType url;
        protected ResourceReference attachment;
        protected Resource attachmentTarget;
        private static final long serialVersionUID = 1782301410L;

        public ImagingStudySeriesInstanceComponent() {
        }

        public ImagingStudySeriesInstanceComponent(OidType oidType, OidType oidType2) {
            this.uid = oidType;
            this.sopclass = oidType2;
        }

        public IntegerType getNumber() {
            return this.number;
        }

        public ImagingStudySeriesInstanceComponent setNumber(IntegerType integerType) {
            this.number = integerType;
            return this;
        }

        public int getNumberSimple() {
            return this.number == null ? null : Integer.valueOf(this.number.getValue());
        }

        public ImagingStudySeriesInstanceComponent setNumberSimple(int n) {
            if (n == -1) {
                this.number = null;
            } else {
                if (this.number == null) {
                    this.number = new IntegerType();
                }
                this.number.setValue(n);
            }
            return this;
        }

        public OidType getUid() {
            return this.uid;
        }

        public ImagingStudySeriesInstanceComponent setUid(OidType oidType) {
            this.uid = oidType;
            return this;
        }

        public String getUidSimple() {
            return this.uid == null ? null : this.uid.getValue();
        }

        public ImagingStudySeriesInstanceComponent setUidSimple(String string) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(string);
            return this;
        }

        public OidType getSopclass() {
            return this.sopclass;
        }

        public ImagingStudySeriesInstanceComponent setSopclass(OidType oidType) {
            this.sopclass = oidType;
            return this;
        }

        public String getSopclassSimple() {
            return this.sopclass == null ? null : this.sopclass.getValue();
        }

        public ImagingStudySeriesInstanceComponent setSopclassSimple(String string) {
            if (this.sopclass == null) {
                this.sopclass = new OidType();
            }
            this.sopclass.setValue(string);
            return this;
        }

        public StringType getType() {
            return this.type;
        }

        public ImagingStudySeriesInstanceComponent setType(StringType stringType) {
            this.type = stringType;
            return this;
        }

        public String getTypeSimple() {
            return this.type == null ? null : this.type.getValue();
        }

        public ImagingStudySeriesInstanceComponent setTypeSimple(String string) {
            if (string == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new StringType();
                }
                this.type.setValue(string);
            }
            return this;
        }

        public StringType getTitle() {
            return this.title;
        }

        public ImagingStudySeriesInstanceComponent setTitle(StringType stringType) {
            this.title = stringType;
            return this;
        }

        public String getTitleSimple() {
            return this.title == null ? null : this.title.getValue();
        }

        public ImagingStudySeriesInstanceComponent setTitleSimple(String string) {
            if (string == null) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(string);
            }
            return this;
        }

        public UriType getUrl() {
            return this.url;
        }

        public ImagingStudySeriesInstanceComponent setUrl(UriType uriType) {
            this.url = uriType;
            return this;
        }

        public String getUrlSimple() {
            return this.url == null ? null : this.url.getValue();
        }

        public ImagingStudySeriesInstanceComponent setUrlSimple(String string) {
            if (string == null) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UriType();
                }
                this.url.setValue(string);
            }
            return this;
        }

        public ResourceReference getAttachment() {
            return this.attachment;
        }

        public ImagingStudySeriesInstanceComponent setAttachment(ResourceReference resourceReference) {
            this.attachment = resourceReference;
            return this;
        }

        public Resource getAttachmentTarget() {
            return this.attachmentTarget;
        }

        public ImagingStudySeriesInstanceComponent setAttachmentTarget(Resource resource) {
            this.attachmentTarget = resource;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("number", "integer", "The number of this image in the series.", 0, Integer.MAX_VALUE, this.number));
            list.add(new Property("uid", "oid", "Formal identifier for this image.", 0, Integer.MAX_VALUE, this.uid));
            list.add(new Property("sopclass", "oid", "DICOM Image type.", 0, Integer.MAX_VALUE, this.sopclass));
            list.add(new Property("type", "string", "Type of instance (image etc) (0004,1430).", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("title", "string", "Description (0070,0080 | 0040,A043 > 0008,0104 | 0042,0010 | 0008,0008).", 0, Integer.MAX_VALUE, this.title));
            list.add(new Property("url", "uri", "WADO-RS url where image is available.", 0, Integer.MAX_VALUE, this.url));
            list.add(new Property("attachment", "Resource(Any)", "A FHIR resource with content for this instance.", 0, Integer.MAX_VALUE, this.attachment));
        }

        public ImagingStudySeriesInstanceComponent copy() {
            ImagingStudySeriesInstanceComponent imagingStudySeriesInstanceComponent = new ImagingStudySeriesInstanceComponent();
            imagingStudySeriesInstanceComponent.number = this.number == null ? null : this.number.copy();
            imagingStudySeriesInstanceComponent.uid = this.uid == null ? null : this.uid.copy();
            imagingStudySeriesInstanceComponent.sopclass = this.sopclass == null ? null : this.sopclass.copy();
            imagingStudySeriesInstanceComponent.type = this.type == null ? null : this.type.copy();
            imagingStudySeriesInstanceComponent.title = this.title == null ? null : this.title.copy();
            imagingStudySeriesInstanceComponent.url = this.url == null ? null : this.url.copy();
            imagingStudySeriesInstanceComponent.attachment = this.attachment == null ? null : this.attachment.copy();
            return imagingStudySeriesInstanceComponent;
        }
    }

    public static class ImagingStudySeriesComponent
    extends BackboneElement {
        protected IntegerType number;
        protected Enumeration<Modality> modality;
        protected OidType uid;
        protected StringType description;
        protected IntegerType numberOfInstances;
        protected Enumeration<InstanceAvailability> availability;
        protected UriType url;
        protected Coding bodySite;
        protected DateTimeType dateTime;
        protected List<ImagingStudySeriesInstanceComponent> instance = new ArrayList<ImagingStudySeriesInstanceComponent>();
        private static final long serialVersionUID = 1575647295L;

        public ImagingStudySeriesComponent() {
        }

        public ImagingStudySeriesComponent(Enumeration<Modality> enumeration, OidType oidType, IntegerType integerType) {
            this.modality = enumeration;
            this.uid = oidType;
            this.numberOfInstances = integerType;
        }

        public IntegerType getNumber() {
            return this.number;
        }

        public ImagingStudySeriesComponent setNumber(IntegerType integerType) {
            this.number = integerType;
            return this;
        }

        public int getNumberSimple() {
            return this.number == null ? null : Integer.valueOf(this.number.getValue());
        }

        public ImagingStudySeriesComponent setNumberSimple(int n) {
            if (n == -1) {
                this.number = null;
            } else {
                if (this.number == null) {
                    this.number = new IntegerType();
                }
                this.number.setValue(n);
            }
            return this;
        }

        public Enumeration<Modality> getModality() {
            return this.modality;
        }

        public ImagingStudySeriesComponent setModality(Enumeration<Modality> enumeration) {
            this.modality = enumeration;
            return this;
        }

        public Modality getModalitySimple() {
            return this.modality == null ? null : this.modality.getValue();
        }

        public ImagingStudySeriesComponent setModalitySimple(Modality modality) {
            if (this.modality == null) {
                this.modality = new Enumeration();
            }
            this.modality.setValue(modality);
            return this;
        }

        public OidType getUid() {
            return this.uid;
        }

        public ImagingStudySeriesComponent setUid(OidType oidType) {
            this.uid = oidType;
            return this;
        }

        public String getUidSimple() {
            return this.uid == null ? null : this.uid.getValue();
        }

        public ImagingStudySeriesComponent setUidSimple(String string) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(string);
            return this;
        }

        public StringType getDescription() {
            return this.description;
        }

        public ImagingStudySeriesComponent setDescription(StringType stringType) {
            this.description = stringType;
            return this;
        }

        public String getDescriptionSimple() {
            return this.description == null ? null : this.description.getValue();
        }

        public ImagingStudySeriesComponent setDescriptionSimple(String string) {
            if (string == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(string);
            }
            return this;
        }

        public IntegerType getNumberOfInstances() {
            return this.numberOfInstances;
        }

        public ImagingStudySeriesComponent setNumberOfInstances(IntegerType integerType) {
            this.numberOfInstances = integerType;
            return this;
        }

        public int getNumberOfInstancesSimple() {
            return this.numberOfInstances == null ? null : Integer.valueOf(this.numberOfInstances.getValue());
        }

        public ImagingStudySeriesComponent setNumberOfInstancesSimple(int n) {
            if (this.numberOfInstances == null) {
                this.numberOfInstances = new IntegerType();
            }
            this.numberOfInstances.setValue(n);
            return this;
        }

        public Enumeration<InstanceAvailability> getAvailability() {
            return this.availability;
        }

        public ImagingStudySeriesComponent setAvailability(Enumeration<InstanceAvailability> enumeration) {
            this.availability = enumeration;
            return this;
        }

        public InstanceAvailability getAvailabilitySimple() {
            return this.availability == null ? null : this.availability.getValue();
        }

        public ImagingStudySeriesComponent setAvailabilitySimple(InstanceAvailability instanceAvailability) {
            if (instanceAvailability == null) {
                this.availability = null;
            } else {
                if (this.availability == null) {
                    this.availability = new Enumeration();
                }
                this.availability.setValue(instanceAvailability);
            }
            return this;
        }

        public UriType getUrl() {
            return this.url;
        }

        public ImagingStudySeriesComponent setUrl(UriType uriType) {
            this.url = uriType;
            return this;
        }

        public String getUrlSimple() {
            return this.url == null ? null : this.url.getValue();
        }

        public ImagingStudySeriesComponent setUrlSimple(String string) {
            if (string == null) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UriType();
                }
                this.url.setValue(string);
            }
            return this;
        }

        public Coding getBodySite() {
            return this.bodySite;
        }

        public ImagingStudySeriesComponent setBodySite(Coding coding) {
            this.bodySite = coding;
            return this;
        }

        public DateTimeType getDateTime() {
            return this.dateTime;
        }

        public ImagingStudySeriesComponent setDateTime(DateTimeType dateTimeType) {
            this.dateTime = dateTimeType;
            return this;
        }

        public DateAndTime getDateTimeSimple() {
            return this.dateTime == null ? null : this.dateTime.getValue();
        }

        public ImagingStudySeriesComponent setDateTimeSimple(DateAndTime dateAndTime) {
            if (dateAndTime == null) {
                this.dateTime = null;
            } else {
                if (this.dateTime == null) {
                    this.dateTime = new DateTimeType();
                }
                this.dateTime.setValue(dateAndTime);
            }
            return this;
        }

        public List<ImagingStudySeriesInstanceComponent> getInstance() {
            return this.instance;
        }

        public ImagingStudySeriesInstanceComponent addInstance() {
            ImagingStudySeriesInstanceComponent imagingStudySeriesInstanceComponent = new ImagingStudySeriesInstanceComponent();
            this.instance.add(imagingStudySeriesInstanceComponent);
            return imagingStudySeriesInstanceComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("number", "integer", "The number of this series in the overall sequence.", 0, Integer.MAX_VALUE, this.number));
            list.add(new Property("modality", "code", "The modality of this series sequence.", 0, Integer.MAX_VALUE, this.modality));
            list.add(new Property("uid", "oid", "Formal identifier for this series.", 0, Integer.MAX_VALUE, this.uid));
            list.add(new Property("description", "string", "A description of the series.", 0, Integer.MAX_VALUE, this.description));
            list.add(new Property("numberOfInstances", "integer", "Sequence that contains attributes from the.", 0, Integer.MAX_VALUE, this.numberOfInstances));
            list.add(new Property("availability", "code", "Availability of series (online, offline or nearline).", 0, Integer.MAX_VALUE, this.availability));
            list.add(new Property("url", "uri", "WADO-RS URI where Series is available.", 0, Integer.MAX_VALUE, this.url));
            list.add(new Property("bodySite", "Coding", "Body part examined. See  DICOM Part 16 Annex L for the mapping from DICOM to Snomed.", 0, Integer.MAX_VALUE, this.bodySite));
            list.add(new Property("dateTime", "dateTime", "When the series started.", 0, Integer.MAX_VALUE, this.dateTime));
            list.add(new Property("instance", "", "A single image taken from a patient.", 0, Integer.MAX_VALUE, this.instance));
        }

        public ImagingStudySeriesComponent copy() {
            ImagingStudySeriesComponent imagingStudySeriesComponent = new ImagingStudySeriesComponent();
            imagingStudySeriesComponent.number = this.number == null ? null : this.number.copy();
            imagingStudySeriesComponent.modality = this.modality == null ? null : this.modality.copy();
            imagingStudySeriesComponent.uid = this.uid == null ? null : this.uid.copy();
            imagingStudySeriesComponent.description = this.description == null ? null : this.description.copy();
            imagingStudySeriesComponent.numberOfInstances = this.numberOfInstances == null ? null : this.numberOfInstances.copy();
            imagingStudySeriesComponent.availability = this.availability == null ? null : this.availability.copy();
            imagingStudySeriesComponent.url = this.url == null ? null : this.url.copy();
            imagingStudySeriesComponent.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            imagingStudySeriesComponent.dateTime = this.dateTime == null ? null : this.dateTime.copy();
            imagingStudySeriesComponent.instance = new ArrayList<ImagingStudySeriesInstanceComponent>();
            for (ImagingStudySeriesInstanceComponent imagingStudySeriesInstanceComponent : this.instance) {
                imagingStudySeriesComponent.instance.add(imagingStudySeriesInstanceComponent.copy());
            }
            return imagingStudySeriesComponent;
        }
    }

    public static class ModalityEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("AR".equals(string)) {
                return Modality.aR;
            }
            if ("AU".equals(string)) {
                return Modality.aU;
            }
            if ("BDUS".equals(string)) {
                return Modality.bDUS;
            }
            if ("BI".equals(string)) {
                return Modality.bI;
            }
            if ("BMD".equals(string)) {
                return Modality.bMD;
            }
            if ("CR".equals(string)) {
                return Modality.cR;
            }
            if ("CT".equals(string)) {
                return Modality.cT;
            }
            if ("DG".equals(string)) {
                return Modality.dG;
            }
            if ("DX".equals(string)) {
                return Modality.dX;
            }
            if ("ECG".equals(string)) {
                return Modality.eCG;
            }
            if ("EPS".equals(string)) {
                return Modality.ePS;
            }
            if ("ES".equals(string)) {
                return Modality.eS;
            }
            if ("GM".equals(string)) {
                return Modality.gM;
            }
            if ("HC".equals(string)) {
                return Modality.hC;
            }
            if ("HD".equals(string)) {
                return Modality.hD;
            }
            if ("IO".equals(string)) {
                return Modality.iO;
            }
            if ("IVOCT".equals(string)) {
                return Modality.iVOCT;
            }
            if ("IVUS".equals(string)) {
                return Modality.iVUS;
            }
            if ("KER".equals(string)) {
                return Modality.kER;
            }
            if ("KO".equals(string)) {
                return Modality.kO;
            }
            if ("LEN".equals(string)) {
                return Modality.lEN;
            }
            if ("LS".equals(string)) {
                return Modality.lS;
            }
            if ("MG".equals(string)) {
                return Modality.mG;
            }
            if ("MR".equals(string)) {
                return Modality.mR;
            }
            if ("NM".equals(string)) {
                return Modality.nM;
            }
            if ("OAM".equals(string)) {
                return Modality.oAM;
            }
            if ("OCT".equals(string)) {
                return Modality.oCT;
            }
            if ("OP".equals(string)) {
                return Modality.oP;
            }
            if ("OPM".equals(string)) {
                return Modality.oPM;
            }
            if ("OPT".equals(string)) {
                return Modality.oPT;
            }
            if ("OPV".equals(string)) {
                return Modality.oPV;
            }
            if ("OT".equals(string)) {
                return Modality.oT;
            }
            if ("PR".equals(string)) {
                return Modality.pR;
            }
            if ("PT".equals(string)) {
                return Modality.pT;
            }
            if ("PX".equals(string)) {
                return Modality.pX;
            }
            if ("REG".equals(string)) {
                return Modality.rEG;
            }
            if ("RF".equals(string)) {
                return Modality.rF;
            }
            if ("RG".equals(string)) {
                return Modality.rG;
            }
            if ("RTDOSE".equals(string)) {
                return Modality.rTDOSE;
            }
            if ("RTIMAGE".equals(string)) {
                return Modality.rTIMAGE;
            }
            if ("RTPLAN".equals(string)) {
                return Modality.rTPLAN;
            }
            if ("RTRECORD".equals(string)) {
                return Modality.rTRECORD;
            }
            if ("RTSTRUCT".equals(string)) {
                return Modality.rTSTRUCT;
            }
            if ("SEG".equals(string)) {
                return Modality.sEG;
            }
            if ("SM".equals(string)) {
                return Modality.sM;
            }
            if ("SMR".equals(string)) {
                return Modality.sMR;
            }
            if ("SR".equals(string)) {
                return Modality.sR;
            }
            if ("SRF".equals(string)) {
                return Modality.sRF;
            }
            if ("TG".equals(string)) {
                return Modality.tG;
            }
            if ("US".equals(string)) {
                return Modality.uS;
            }
            if ("VA".equals(string)) {
                return Modality.vA;
            }
            if ("XA".equals(string)) {
                return Modality.xA;
            }
            if ("XC".equals(string)) {
                return Modality.xC;
            }
            throw new Exception("Unknown Modality code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == Modality.aR) {
                return "AR";
            }
            if (enum_ == Modality.aU) {
                return "AU";
            }
            if (enum_ == Modality.bDUS) {
                return "BDUS";
            }
            if (enum_ == Modality.bI) {
                return "BI";
            }
            if (enum_ == Modality.bMD) {
                return "BMD";
            }
            if (enum_ == Modality.cR) {
                return "CR";
            }
            if (enum_ == Modality.cT) {
                return "CT";
            }
            if (enum_ == Modality.dG) {
                return "DG";
            }
            if (enum_ == Modality.dX) {
                return "DX";
            }
            if (enum_ == Modality.eCG) {
                return "ECG";
            }
            if (enum_ == Modality.ePS) {
                return "EPS";
            }
            if (enum_ == Modality.eS) {
                return "ES";
            }
            if (enum_ == Modality.gM) {
                return "GM";
            }
            if (enum_ == Modality.hC) {
                return "HC";
            }
            if (enum_ == Modality.hD) {
                return "HD";
            }
            if (enum_ == Modality.iO) {
                return "IO";
            }
            if (enum_ == Modality.iVOCT) {
                return "IVOCT";
            }
            if (enum_ == Modality.iVUS) {
                return "IVUS";
            }
            if (enum_ == Modality.kER) {
                return "KER";
            }
            if (enum_ == Modality.kO) {
                return "KO";
            }
            if (enum_ == Modality.lEN) {
                return "LEN";
            }
            if (enum_ == Modality.lS) {
                return "LS";
            }
            if (enum_ == Modality.mG) {
                return "MG";
            }
            if (enum_ == Modality.mR) {
                return "MR";
            }
            if (enum_ == Modality.nM) {
                return "NM";
            }
            if (enum_ == Modality.oAM) {
                return "OAM";
            }
            if (enum_ == Modality.oCT) {
                return "OCT";
            }
            if (enum_ == Modality.oP) {
                return "OP";
            }
            if (enum_ == Modality.oPM) {
                return "OPM";
            }
            if (enum_ == Modality.oPT) {
                return "OPT";
            }
            if (enum_ == Modality.oPV) {
                return "OPV";
            }
            if (enum_ == Modality.oT) {
                return "OT";
            }
            if (enum_ == Modality.pR) {
                return "PR";
            }
            if (enum_ == Modality.pT) {
                return "PT";
            }
            if (enum_ == Modality.pX) {
                return "PX";
            }
            if (enum_ == Modality.rEG) {
                return "REG";
            }
            if (enum_ == Modality.rF) {
                return "RF";
            }
            if (enum_ == Modality.rG) {
                return "RG";
            }
            if (enum_ == Modality.rTDOSE) {
                return "RTDOSE";
            }
            if (enum_ == Modality.rTIMAGE) {
                return "RTIMAGE";
            }
            if (enum_ == Modality.rTPLAN) {
                return "RTPLAN";
            }
            if (enum_ == Modality.rTRECORD) {
                return "RTRECORD";
            }
            if (enum_ == Modality.rTSTRUCT) {
                return "RTSTRUCT";
            }
            if (enum_ == Modality.sEG) {
                return "SEG";
            }
            if (enum_ == Modality.sM) {
                return "SM";
            }
            if (enum_ == Modality.sMR) {
                return "SMR";
            }
            if (enum_ == Modality.sR) {
                return "SR";
            }
            if (enum_ == Modality.sRF) {
                return "SRF";
            }
            if (enum_ == Modality.tG) {
                return "TG";
            }
            if (enum_ == Modality.uS) {
                return "US";
            }
            if (enum_ == Modality.vA) {
                return "VA";
            }
            if (enum_ == Modality.xA) {
                return "XA";
            }
            if (enum_ == Modality.xC) {
                return "XC";
            }
            return "?";
        }
    }

    public static enum Modality {
        aR,
        aU,
        bDUS,
        bI,
        bMD,
        cR,
        cT,
        dG,
        dX,
        eCG,
        ePS,
        eS,
        gM,
        hC,
        hD,
        iO,
        iVOCT,
        iVUS,
        kER,
        kO,
        lEN,
        lS,
        mG,
        mR,
        nM,
        oAM,
        oCT,
        oP,
        oPM,
        oPT,
        oPV,
        oT,
        pR,
        pT,
        pX,
        rEG,
        rF,
        rG,
        rTDOSE,
        rTIMAGE,
        rTPLAN,
        rTRECORD,
        rTSTRUCT,
        sEG,
        sM,
        sMR,
        sR,
        sRF,
        tG,
        uS,
        vA,
        xA,
        xC,
        Null;


        public static Modality fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("AR".equals(string)) {
                return aR;
            }
            if ("AU".equals(string)) {
                return aU;
            }
            if ("BDUS".equals(string)) {
                return bDUS;
            }
            if ("BI".equals(string)) {
                return bI;
            }
            if ("BMD".equals(string)) {
                return bMD;
            }
            if ("CR".equals(string)) {
                return cR;
            }
            if ("CT".equals(string)) {
                return cT;
            }
            if ("DG".equals(string)) {
                return dG;
            }
            if ("DX".equals(string)) {
                return dX;
            }
            if ("ECG".equals(string)) {
                return eCG;
            }
            if ("EPS".equals(string)) {
                return ePS;
            }
            if ("ES".equals(string)) {
                return eS;
            }
            if ("GM".equals(string)) {
                return gM;
            }
            if ("HC".equals(string)) {
                return hC;
            }
            if ("HD".equals(string)) {
                return hD;
            }
            if ("IO".equals(string)) {
                return iO;
            }
            if ("IVOCT".equals(string)) {
                return iVOCT;
            }
            if ("IVUS".equals(string)) {
                return iVUS;
            }
            if ("KER".equals(string)) {
                return kER;
            }
            if ("KO".equals(string)) {
                return kO;
            }
            if ("LEN".equals(string)) {
                return lEN;
            }
            if ("LS".equals(string)) {
                return lS;
            }
            if ("MG".equals(string)) {
                return mG;
            }
            if ("MR".equals(string)) {
                return mR;
            }
            if ("NM".equals(string)) {
                return nM;
            }
            if ("OAM".equals(string)) {
                return oAM;
            }
            if ("OCT".equals(string)) {
                return oCT;
            }
            if ("OP".equals(string)) {
                return oP;
            }
            if ("OPM".equals(string)) {
                return oPM;
            }
            if ("OPT".equals(string)) {
                return oPT;
            }
            if ("OPV".equals(string)) {
                return oPV;
            }
            if ("OT".equals(string)) {
                return oT;
            }
            if ("PR".equals(string)) {
                return pR;
            }
            if ("PT".equals(string)) {
                return pT;
            }
            if ("PX".equals(string)) {
                return pX;
            }
            if ("REG".equals(string)) {
                return rEG;
            }
            if ("RF".equals(string)) {
                return rF;
            }
            if ("RG".equals(string)) {
                return rG;
            }
            if ("RTDOSE".equals(string)) {
                return rTDOSE;
            }
            if ("RTIMAGE".equals(string)) {
                return rTIMAGE;
            }
            if ("RTPLAN".equals(string)) {
                return rTPLAN;
            }
            if ("RTRECORD".equals(string)) {
                return rTRECORD;
            }
            if ("RTSTRUCT".equals(string)) {
                return rTSTRUCT;
            }
            if ("SEG".equals(string)) {
                return sEG;
            }
            if ("SM".equals(string)) {
                return sM;
            }
            if ("SMR".equals(string)) {
                return sMR;
            }
            if ("SR".equals(string)) {
                return sR;
            }
            if ("SRF".equals(string)) {
                return sRF;
            }
            if ("TG".equals(string)) {
                return tG;
            }
            if ("US".equals(string)) {
                return uS;
            }
            if ("VA".equals(string)) {
                return vA;
            }
            if ("XA".equals(string)) {
                return xA;
            }
            if ("XC".equals(string)) {
                return xC;
            }
            throw new Exception("Unknown Modality code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case aR: {
                    return "AR";
                }
                case aU: {
                    return "AU";
                }
                case bDUS: {
                    return "BDUS";
                }
                case bI: {
                    return "BI";
                }
                case bMD: {
                    return "BMD";
                }
                case cR: {
                    return "CR";
                }
                case cT: {
                    return "CT";
                }
                case dG: {
                    return "DG";
                }
                case dX: {
                    return "DX";
                }
                case eCG: {
                    return "ECG";
                }
                case ePS: {
                    return "EPS";
                }
                case eS: {
                    return "ES";
                }
                case gM: {
                    return "GM";
                }
                case hC: {
                    return "HC";
                }
                case hD: {
                    return "HD";
                }
                case iO: {
                    return "IO";
                }
                case iVOCT: {
                    return "IVOCT";
                }
                case iVUS: {
                    return "IVUS";
                }
                case kER: {
                    return "KER";
                }
                case kO: {
                    return "KO";
                }
                case lEN: {
                    return "LEN";
                }
                case lS: {
                    return "LS";
                }
                case mG: {
                    return "MG";
                }
                case mR: {
                    return "MR";
                }
                case nM: {
                    return "NM";
                }
                case oAM: {
                    return "OAM";
                }
                case oCT: {
                    return "OCT";
                }
                case oP: {
                    return "OP";
                }
                case oPM: {
                    return "OPM";
                }
                case oPT: {
                    return "OPT";
                }
                case oPV: {
                    return "OPV";
                }
                case oT: {
                    return "OT";
                }
                case pR: {
                    return "PR";
                }
                case pT: {
                    return "PT";
                }
                case pX: {
                    return "PX";
                }
                case rEG: {
                    return "REG";
                }
                case rF: {
                    return "RF";
                }
                case rG: {
                    return "RG";
                }
                case rTDOSE: {
                    return "RTDOSE";
                }
                case rTIMAGE: {
                    return "RTIMAGE";
                }
                case rTPLAN: {
                    return "RTPLAN";
                }
                case rTRECORD: {
                    return "RTRECORD";
                }
                case rTSTRUCT: {
                    return "RTSTRUCT";
                }
                case sEG: {
                    return "SEG";
                }
                case sM: {
                    return "SM";
                }
                case sMR: {
                    return "SMR";
                }
                case sR: {
                    return "SR";
                }
                case sRF: {
                    return "SRF";
                }
                case tG: {
                    return "TG";
                }
                case uS: {
                    return "US";
                }
                case vA: {
                    return "VA";
                }
                case xA: {
                    return "XA";
                }
                case xC: {
                    return "XC";
                }
            }
            return "?";
        }
    }

    public static class InstanceAvailabilityEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("ONLINE".equals(string)) {
                return InstanceAvailability.oNLINE;
            }
            if ("OFFLINE".equals(string)) {
                return InstanceAvailability.oFFLINE;
            }
            if ("NEARLINE".equals(string)) {
                return InstanceAvailability.nEARLINE;
            }
            if ("UNAVAILABLE".equals(string)) {
                return InstanceAvailability.uNAVAILABLE;
            }
            throw new Exception("Unknown InstanceAvailability code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == InstanceAvailability.oNLINE) {
                return "ONLINE";
            }
            if (enum_ == InstanceAvailability.oFFLINE) {
                return "OFFLINE";
            }
            if (enum_ == InstanceAvailability.nEARLINE) {
                return "NEARLINE";
            }
            if (enum_ == InstanceAvailability.uNAVAILABLE) {
                return "UNAVAILABLE";
            }
            return "?";
        }
    }

    public static enum InstanceAvailability {
        oNLINE,
        oFFLINE,
        nEARLINE,
        uNAVAILABLE,
        Null;


        public static InstanceAvailability fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("ONLINE".equals(string)) {
                return oNLINE;
            }
            if ("OFFLINE".equals(string)) {
                return oFFLINE;
            }
            if ("NEARLINE".equals(string)) {
                return nEARLINE;
            }
            if ("UNAVAILABLE".equals(string)) {
                return uNAVAILABLE;
            }
            throw new Exception("Unknown InstanceAvailability code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case oNLINE: {
                    return "ONLINE";
                }
                case oFFLINE: {
                    return "OFFLINE";
                }
                case nEARLINE: {
                    return "NEARLINE";
                }
                case uNAVAILABLE: {
                    return "UNAVAILABLE";
                }
            }
            return "?";
        }
    }

    public static class ImagingModalityEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("AR".equals(string)) {
                return ImagingModality.aR;
            }
            if ("BMD".equals(string)) {
                return ImagingModality.bMD;
            }
            if ("BDUS".equals(string)) {
                return ImagingModality.bDUS;
            }
            if ("EPS".equals(string)) {
                return ImagingModality.ePS;
            }
            if ("CR".equals(string)) {
                return ImagingModality.cR;
            }
            if ("CT".equals(string)) {
                return ImagingModality.cT;
            }
            if ("DX".equals(string)) {
                return ImagingModality.dX;
            }
            if ("ECG".equals(string)) {
                return ImagingModality.eCG;
            }
            if ("ES".equals(string)) {
                return ImagingModality.eS;
            }
            if ("XC".equals(string)) {
                return ImagingModality.xC;
            }
            if ("GM".equals(string)) {
                return ImagingModality.gM;
            }
            if ("HD".equals(string)) {
                return ImagingModality.hD;
            }
            if ("IO".equals(string)) {
                return ImagingModality.iO;
            }
            if ("IVOCT".equals(string)) {
                return ImagingModality.iVOCT;
            }
            if ("IVUS".equals(string)) {
                return ImagingModality.iVUS;
            }
            if ("KER".equals(string)) {
                return ImagingModality.kER;
            }
            if ("LEN".equals(string)) {
                return ImagingModality.lEN;
            }
            if ("MR".equals(string)) {
                return ImagingModality.mR;
            }
            if ("MG".equals(string)) {
                return ImagingModality.mG;
            }
            if ("NM".equals(string)) {
                return ImagingModality.nM;
            }
            if ("OAM".equals(string)) {
                return ImagingModality.oAM;
            }
            if ("OCT".equals(string)) {
                return ImagingModality.oCT;
            }
            if ("OPM".equals(string)) {
                return ImagingModality.oPM;
            }
            if ("OP".equals(string)) {
                return ImagingModality.oP;
            }
            if ("OPR".equals(string)) {
                return ImagingModality.oPR;
            }
            if ("OPT".equals(string)) {
                return ImagingModality.oPT;
            }
            if ("OPV".equals(string)) {
                return ImagingModality.oPV;
            }
            if ("PX".equals(string)) {
                return ImagingModality.pX;
            }
            if ("PT".equals(string)) {
                return ImagingModality.pT;
            }
            if ("RF".equals(string)) {
                return ImagingModality.rF;
            }
            if ("RG".equals(string)) {
                return ImagingModality.rG;
            }
            if ("SM".equals(string)) {
                return ImagingModality.sM;
            }
            if ("SRF".equals(string)) {
                return ImagingModality.sRF;
            }
            if ("US".equals(string)) {
                return ImagingModality.uS;
            }
            if ("VA".equals(string)) {
                return ImagingModality.vA;
            }
            if ("XA".equals(string)) {
                return ImagingModality.xA;
            }
            throw new Exception("Unknown ImagingModality code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ImagingModality.aR) {
                return "AR";
            }
            if (enum_ == ImagingModality.bMD) {
                return "BMD";
            }
            if (enum_ == ImagingModality.bDUS) {
                return "BDUS";
            }
            if (enum_ == ImagingModality.ePS) {
                return "EPS";
            }
            if (enum_ == ImagingModality.cR) {
                return "CR";
            }
            if (enum_ == ImagingModality.cT) {
                return "CT";
            }
            if (enum_ == ImagingModality.dX) {
                return "DX";
            }
            if (enum_ == ImagingModality.eCG) {
                return "ECG";
            }
            if (enum_ == ImagingModality.eS) {
                return "ES";
            }
            if (enum_ == ImagingModality.xC) {
                return "XC";
            }
            if (enum_ == ImagingModality.gM) {
                return "GM";
            }
            if (enum_ == ImagingModality.hD) {
                return "HD";
            }
            if (enum_ == ImagingModality.iO) {
                return "IO";
            }
            if (enum_ == ImagingModality.iVOCT) {
                return "IVOCT";
            }
            if (enum_ == ImagingModality.iVUS) {
                return "IVUS";
            }
            if (enum_ == ImagingModality.kER) {
                return "KER";
            }
            if (enum_ == ImagingModality.lEN) {
                return "LEN";
            }
            if (enum_ == ImagingModality.mR) {
                return "MR";
            }
            if (enum_ == ImagingModality.mG) {
                return "MG";
            }
            if (enum_ == ImagingModality.nM) {
                return "NM";
            }
            if (enum_ == ImagingModality.oAM) {
                return "OAM";
            }
            if (enum_ == ImagingModality.oCT) {
                return "OCT";
            }
            if (enum_ == ImagingModality.oPM) {
                return "OPM";
            }
            if (enum_ == ImagingModality.oP) {
                return "OP";
            }
            if (enum_ == ImagingModality.oPR) {
                return "OPR";
            }
            if (enum_ == ImagingModality.oPT) {
                return "OPT";
            }
            if (enum_ == ImagingModality.oPV) {
                return "OPV";
            }
            if (enum_ == ImagingModality.pX) {
                return "PX";
            }
            if (enum_ == ImagingModality.pT) {
                return "PT";
            }
            if (enum_ == ImagingModality.rF) {
                return "RF";
            }
            if (enum_ == ImagingModality.rG) {
                return "RG";
            }
            if (enum_ == ImagingModality.sM) {
                return "SM";
            }
            if (enum_ == ImagingModality.sRF) {
                return "SRF";
            }
            if (enum_ == ImagingModality.uS) {
                return "US";
            }
            if (enum_ == ImagingModality.vA) {
                return "VA";
            }
            if (enum_ == ImagingModality.xA) {
                return "XA";
            }
            return "?";
        }
    }

    public static enum ImagingModality {
        aR,
        bMD,
        bDUS,
        ePS,
        cR,
        cT,
        dX,
        eCG,
        eS,
        xC,
        gM,
        hD,
        iO,
        iVOCT,
        iVUS,
        kER,
        lEN,
        mR,
        mG,
        nM,
        oAM,
        oCT,
        oPM,
        oP,
        oPR,
        oPT,
        oPV,
        pX,
        pT,
        rF,
        rG,
        sM,
        sRF,
        uS,
        vA,
        xA,
        Null;


        public static ImagingModality fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("AR".equals(string)) {
                return aR;
            }
            if ("BMD".equals(string)) {
                return bMD;
            }
            if ("BDUS".equals(string)) {
                return bDUS;
            }
            if ("EPS".equals(string)) {
                return ePS;
            }
            if ("CR".equals(string)) {
                return cR;
            }
            if ("CT".equals(string)) {
                return cT;
            }
            if ("DX".equals(string)) {
                return dX;
            }
            if ("ECG".equals(string)) {
                return eCG;
            }
            if ("ES".equals(string)) {
                return eS;
            }
            if ("XC".equals(string)) {
                return xC;
            }
            if ("GM".equals(string)) {
                return gM;
            }
            if ("HD".equals(string)) {
                return hD;
            }
            if ("IO".equals(string)) {
                return iO;
            }
            if ("IVOCT".equals(string)) {
                return iVOCT;
            }
            if ("IVUS".equals(string)) {
                return iVUS;
            }
            if ("KER".equals(string)) {
                return kER;
            }
            if ("LEN".equals(string)) {
                return lEN;
            }
            if ("MR".equals(string)) {
                return mR;
            }
            if ("MG".equals(string)) {
                return mG;
            }
            if ("NM".equals(string)) {
                return nM;
            }
            if ("OAM".equals(string)) {
                return oAM;
            }
            if ("OCT".equals(string)) {
                return oCT;
            }
            if ("OPM".equals(string)) {
                return oPM;
            }
            if ("OP".equals(string)) {
                return oP;
            }
            if ("OPR".equals(string)) {
                return oPR;
            }
            if ("OPT".equals(string)) {
                return oPT;
            }
            if ("OPV".equals(string)) {
                return oPV;
            }
            if ("PX".equals(string)) {
                return pX;
            }
            if ("PT".equals(string)) {
                return pT;
            }
            if ("RF".equals(string)) {
                return rF;
            }
            if ("RG".equals(string)) {
                return rG;
            }
            if ("SM".equals(string)) {
                return sM;
            }
            if ("SRF".equals(string)) {
                return sRF;
            }
            if ("US".equals(string)) {
                return uS;
            }
            if ("VA".equals(string)) {
                return vA;
            }
            if ("XA".equals(string)) {
                return xA;
            }
            throw new Exception("Unknown ImagingModality code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case aR: {
                    return "AR";
                }
                case bMD: {
                    return "BMD";
                }
                case bDUS: {
                    return "BDUS";
                }
                case ePS: {
                    return "EPS";
                }
                case cR: {
                    return "CR";
                }
                case cT: {
                    return "CT";
                }
                case dX: {
                    return "DX";
                }
                case eCG: {
                    return "ECG";
                }
                case eS: {
                    return "ES";
                }
                case xC: {
                    return "XC";
                }
                case gM: {
                    return "GM";
                }
                case hD: {
                    return "HD";
                }
                case iO: {
                    return "IO";
                }
                case iVOCT: {
                    return "IVOCT";
                }
                case iVUS: {
                    return "IVUS";
                }
                case kER: {
                    return "KER";
                }
                case lEN: {
                    return "LEN";
                }
                case mR: {
                    return "MR";
                }
                case mG: {
                    return "MG";
                }
                case nM: {
                    return "NM";
                }
                case oAM: {
                    return "OAM";
                }
                case oCT: {
                    return "OCT";
                }
                case oPM: {
                    return "OPM";
                }
                case oP: {
                    return "OP";
                }
                case oPR: {
                    return "OPR";
                }
                case oPT: {
                    return "OPT";
                }
                case oPV: {
                    return "OPV";
                }
                case pX: {
                    return "PX";
                }
                case pT: {
                    return "PT";
                }
                case rF: {
                    return "RF";
                }
                case rG: {
                    return "RG";
                }
                case sM: {
                    return "SM";
                }
                case sRF: {
                    return "SRF";
                }
                case uS: {
                    return "US";
                }
                case vA: {
                    return "VA";
                }
                case xA: {
                    return "XA";
                }
            }
            return "?";
        }
    }
}

