/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.Location;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;

public class Immunization
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected DateTimeType date;
    protected CodeableConcept vaccineType;
    protected ResourceReference subject;
    protected Patient subjectTarget;
    protected BooleanType refusedIndicator;
    protected BooleanType reported;
    protected ResourceReference performer;
    protected Practitioner performerTarget;
    protected ResourceReference requester;
    protected Practitioner requesterTarget;
    protected ResourceReference manufacturer;
    protected Organization manufacturerTarget;
    protected ResourceReference location;
    protected Location locationTarget;
    protected StringType lotNumber;
    protected DateType expirationDate;
    protected CodeableConcept site;
    protected CodeableConcept route;
    protected Quantity doseQuantity;
    protected ImmunizationExplanationComponent explanation;
    protected List<ImmunizationReactionComponent> reaction = new ArrayList<ImmunizationReactionComponent>();
    protected List<ImmunizationVaccinationProtocolComponent> vaccinationProtocol = new ArrayList<ImmunizationVaccinationProtocolComponent>();
    private static final long serialVersionUID = 927863190L;

    public Immunization() {
    }

    public Immunization(DateTimeType dateTimeType, CodeableConcept codeableConcept, ResourceReference resourceReference, BooleanType booleanType, BooleanType booleanType2) {
        this.date = dateTimeType;
        this.vaccineType = codeableConcept;
        this.subject = resourceReference;
        this.refusedIndicator = booleanType;
        this.reported = booleanType2;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public DateTimeType getDate() {
        return this.date;
    }

    public Immunization setDate(DateTimeType dateTimeType) {
        this.date = dateTimeType;
        return this;
    }

    public DateAndTime getDateSimple() {
        return this.date == null ? null : this.date.getValue();
    }

    public Immunization setDateSimple(DateAndTime dateAndTime) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(dateAndTime);
        return this;
    }

    public CodeableConcept getVaccineType() {
        return this.vaccineType;
    }

    public Immunization setVaccineType(CodeableConcept codeableConcept) {
        this.vaccineType = codeableConcept;
        return this;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public Immunization setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Patient getSubjectTarget() {
        return this.subjectTarget;
    }

    public Immunization setSubjectTarget(Patient patient) {
        this.subjectTarget = patient;
        return this;
    }

    public BooleanType getRefusedIndicator() {
        return this.refusedIndicator;
    }

    public Immunization setRefusedIndicator(BooleanType booleanType) {
        this.refusedIndicator = booleanType;
        return this;
    }

    public boolean getRefusedIndicatorSimple() {
        return this.refusedIndicator == null ? false : this.refusedIndicator.getValue();
    }

    public Immunization setRefusedIndicatorSimple(boolean bl) {
        if (this.refusedIndicator == null) {
            this.refusedIndicator = new BooleanType();
        }
        this.refusedIndicator.setValue(bl);
        return this;
    }

    public BooleanType getReported() {
        return this.reported;
    }

    public Immunization setReported(BooleanType booleanType) {
        this.reported = booleanType;
        return this;
    }

    public boolean getReportedSimple() {
        return this.reported == null ? false : this.reported.getValue();
    }

    public Immunization setReportedSimple(boolean bl) {
        if (this.reported == null) {
            this.reported = new BooleanType();
        }
        this.reported.setValue(bl);
        return this;
    }

    public ResourceReference getPerformer() {
        return this.performer;
    }

    public Immunization setPerformer(ResourceReference resourceReference) {
        this.performer = resourceReference;
        return this;
    }

    public Practitioner getPerformerTarget() {
        return this.performerTarget;
    }

    public Immunization setPerformerTarget(Practitioner practitioner) {
        this.performerTarget = practitioner;
        return this;
    }

    public ResourceReference getRequester() {
        return this.requester;
    }

    public Immunization setRequester(ResourceReference resourceReference) {
        this.requester = resourceReference;
        return this;
    }

    public Practitioner getRequesterTarget() {
        return this.requesterTarget;
    }

    public Immunization setRequesterTarget(Practitioner practitioner) {
        this.requesterTarget = practitioner;
        return this;
    }

    public ResourceReference getManufacturer() {
        return this.manufacturer;
    }

    public Immunization setManufacturer(ResourceReference resourceReference) {
        this.manufacturer = resourceReference;
        return this;
    }

    public Organization getManufacturerTarget() {
        return this.manufacturerTarget;
    }

    public Immunization setManufacturerTarget(Organization organization) {
        this.manufacturerTarget = organization;
        return this;
    }

    public ResourceReference getLocation() {
        return this.location;
    }

    public Immunization setLocation(ResourceReference resourceReference) {
        this.location = resourceReference;
        return this;
    }

    public Location getLocationTarget() {
        return this.locationTarget;
    }

    public Immunization setLocationTarget(Location location) {
        this.locationTarget = location;
        return this;
    }

    public StringType getLotNumber() {
        return this.lotNumber;
    }

    public Immunization setLotNumber(StringType stringType) {
        this.lotNumber = stringType;
        return this;
    }

    public String getLotNumberSimple() {
        return this.lotNumber == null ? null : this.lotNumber.getValue();
    }

    public Immunization setLotNumberSimple(String string) {
        if (string == null) {
            this.lotNumber = null;
        } else {
            if (this.lotNumber == null) {
                this.lotNumber = new StringType();
            }
            this.lotNumber.setValue(string);
        }
        return this;
    }

    public DateType getExpirationDate() {
        return this.expirationDate;
    }

    public Immunization setExpirationDate(DateType dateType) {
        this.expirationDate = dateType;
        return this;
    }

    public DateAndTime getExpirationDateSimple() {
        return this.expirationDate == null ? null : this.expirationDate.getValue();
    }

    public Immunization setExpirationDateSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.expirationDate = null;
        } else {
            if (this.expirationDate == null) {
                this.expirationDate = new DateType();
            }
            this.expirationDate.setValue(dateAndTime);
        }
        return this;
    }

    public CodeableConcept getSite() {
        return this.site;
    }

    public Immunization setSite(CodeableConcept codeableConcept) {
        this.site = codeableConcept;
        return this;
    }

    public CodeableConcept getRoute() {
        return this.route;
    }

    public Immunization setRoute(CodeableConcept codeableConcept) {
        this.route = codeableConcept;
        return this;
    }

    public Quantity getDoseQuantity() {
        return this.doseQuantity;
    }

    public Immunization setDoseQuantity(Quantity quantity) {
        this.doseQuantity = quantity;
        return this;
    }

    public ImmunizationExplanationComponent getExplanation() {
        return this.explanation;
    }

    public Immunization setExplanation(ImmunizationExplanationComponent immunizationExplanationComponent) {
        this.explanation = immunizationExplanationComponent;
        return this;
    }

    public List<ImmunizationReactionComponent> getReaction() {
        return this.reaction;
    }

    public ImmunizationReactionComponent addReaction() {
        ImmunizationReactionComponent immunizationReactionComponent = new ImmunizationReactionComponent();
        this.reaction.add(immunizationReactionComponent);
        return immunizationReactionComponent;
    }

    public List<ImmunizationVaccinationProtocolComponent> getVaccinationProtocol() {
        return this.vaccinationProtocol;
    }

    public ImmunizationVaccinationProtocolComponent addVaccinationProtocol() {
        ImmunizationVaccinationProtocolComponent immunizationVaccinationProtocolComponent = new ImmunizationVaccinationProtocolComponent();
        this.vaccinationProtocol.add(immunizationVaccinationProtocolComponent);
        return immunizationVaccinationProtocolComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "A unique identifier assigned to this adverse reaction record.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("date", "dateTime", "Date vaccine administered or was to be administered.", 0, Integer.MAX_VALUE, this.date));
        list.add(new Property("vaccineType", "CodeableConcept", "Vaccine that was administered or was to be administered.", 0, Integer.MAX_VALUE, this.vaccineType));
        list.add(new Property("subject", "Resource(Patient)", "The patient to whom the vaccine was to be administered.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("refusedIndicator", "boolean", "Indicates if the vaccination was refused.", 0, Integer.MAX_VALUE, this.refusedIndicator));
        list.add(new Property("reported", "boolean", "True if this administration was reported rather than directly administered.", 0, Integer.MAX_VALUE, this.reported));
        list.add(new Property("performer", "Resource(Practitioner)", "Clinician who administered the vaccine.", 0, Integer.MAX_VALUE, this.performer));
        list.add(new Property("requester", "Resource(Practitioner)", "Clinician who ordered the vaccination.", 0, Integer.MAX_VALUE, this.requester));
        list.add(new Property("manufacturer", "Resource(Organization)", "Name of vaccine manufacturer.", 0, Integer.MAX_VALUE, this.manufacturer));
        list.add(new Property("location", "Resource(Location)", "The service delivery location where the vaccine administration occurred.", 0, Integer.MAX_VALUE, this.location));
        list.add(new Property("lotNumber", "string", "Lot number of the  vaccine product.", 0, Integer.MAX_VALUE, this.lotNumber));
        list.add(new Property("expirationDate", "date", "Date vaccine batch expires.", 0, Integer.MAX_VALUE, this.expirationDate));
        list.add(new Property("site", "CodeableConcept", "Body site where vaccine was administered.", 0, Integer.MAX_VALUE, this.site));
        list.add(new Property("route", "CodeableConcept", "The path by which the vaccine product is taken into the body.", 0, Integer.MAX_VALUE, this.route));
        list.add(new Property("doseQuantity", "Quantity", "The quantity of vaccine product that was administered.", 0, Integer.MAX_VALUE, this.doseQuantity));
        list.add(new Property("explanation", "", "Reasons why a vaccine was administered or refused.", 0, Integer.MAX_VALUE, this.explanation));
        list.add(new Property("reaction", "", "Categorical data indicating that an adverse event is associated in time to an immunization.", 0, Integer.MAX_VALUE, this.reaction));
        list.add(new Property("vaccinationProtocol", "", "Contains information about the protocol(s) under which the vaccine was administered.", 0, Integer.MAX_VALUE, this.vaccinationProtocol));
    }

    public Immunization copy() {
        Immunization immunization = new Immunization();
        immunization.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            immunization.identifier.add(element.copy());
        }
        immunization.date = this.date == null ? null : this.date.copy();
        immunization.vaccineType = this.vaccineType == null ? null : this.vaccineType.copy();
        immunization.subject = this.subject == null ? null : this.subject.copy();
        immunization.refusedIndicator = this.refusedIndicator == null ? null : this.refusedIndicator.copy();
        immunization.reported = this.reported == null ? null : this.reported.copy();
        immunization.performer = this.performer == null ? null : this.performer.copy();
        immunization.requester = this.requester == null ? null : this.requester.copy();
        immunization.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        immunization.location = this.location == null ? null : this.location.copy();
        immunization.lotNumber = this.lotNumber == null ? null : this.lotNumber.copy();
        immunization.expirationDate = this.expirationDate == null ? null : this.expirationDate.copy();
        immunization.site = this.site == null ? null : this.site.copy();
        immunization.route = this.route == null ? null : this.route.copy();
        immunization.doseQuantity = this.doseQuantity == null ? null : this.doseQuantity.copy();
        immunization.explanation = this.explanation == null ? null : this.explanation.copy();
        immunization.reaction = new ArrayList<ImmunizationReactionComponent>();
        for (ImmunizationReactionComponent immunizationReactionComponent : this.reaction) {
            immunization.reaction.add(immunizationReactionComponent.copy());
        }
        immunization.vaccinationProtocol = new ArrayList<ImmunizationVaccinationProtocolComponent>();
        for (ImmunizationVaccinationProtocolComponent immunizationVaccinationProtocolComponent : this.vaccinationProtocol) {
            immunization.vaccinationProtocol.add(immunizationVaccinationProtocolComponent.copy());
        }
        return immunization;
    }

    protected Immunization typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Immunization;
    }

    public static class ImmunizationVaccinationProtocolComponent
    extends BackboneElement {
        protected IntegerType doseSequence;
        protected StringType description;
        protected ResourceReference authority;
        protected Organization authorityTarget;
        protected StringType series;
        protected IntegerType seriesDoses;
        protected CodeableConcept doseTarget;
        protected CodeableConcept doseStatus;
        protected CodeableConcept doseStatusReason;
        private static final long serialVersionUID = -619399794L;

        public ImmunizationVaccinationProtocolComponent() {
        }

        public ImmunizationVaccinationProtocolComponent(IntegerType integerType, CodeableConcept codeableConcept, CodeableConcept codeableConcept2) {
            this.doseSequence = integerType;
            this.doseTarget = codeableConcept;
            this.doseStatus = codeableConcept2;
        }

        public IntegerType getDoseSequence() {
            return this.doseSequence;
        }

        public ImmunizationVaccinationProtocolComponent setDoseSequence(IntegerType integerType) {
            this.doseSequence = integerType;
            return this;
        }

        public int getDoseSequenceSimple() {
            return this.doseSequence == null ? null : Integer.valueOf(this.doseSequence.getValue());
        }

        public ImmunizationVaccinationProtocolComponent setDoseSequenceSimple(int n) {
            if (this.doseSequence == null) {
                this.doseSequence = new IntegerType();
            }
            this.doseSequence.setValue(n);
            return this;
        }

        public StringType getDescription() {
            return this.description;
        }

        public ImmunizationVaccinationProtocolComponent setDescription(StringType stringType) {
            this.description = stringType;
            return this;
        }

        public String getDescriptionSimple() {
            return this.description == null ? null : this.description.getValue();
        }

        public ImmunizationVaccinationProtocolComponent setDescriptionSimple(String string) {
            if (string == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(string);
            }
            return this;
        }

        public ResourceReference getAuthority() {
            return this.authority;
        }

        public ImmunizationVaccinationProtocolComponent setAuthority(ResourceReference resourceReference) {
            this.authority = resourceReference;
            return this;
        }

        public Organization getAuthorityTarget() {
            return this.authorityTarget;
        }

        public ImmunizationVaccinationProtocolComponent setAuthorityTarget(Organization organization) {
            this.authorityTarget = organization;
            return this;
        }

        public StringType getSeries() {
            return this.series;
        }

        public ImmunizationVaccinationProtocolComponent setSeries(StringType stringType) {
            this.series = stringType;
            return this;
        }

        public String getSeriesSimple() {
            return this.series == null ? null : this.series.getValue();
        }

        public ImmunizationVaccinationProtocolComponent setSeriesSimple(String string) {
            if (string == null) {
                this.series = null;
            } else {
                if (this.series == null) {
                    this.series = new StringType();
                }
                this.series.setValue(string);
            }
            return this;
        }

        public IntegerType getSeriesDoses() {
            return this.seriesDoses;
        }

        public ImmunizationVaccinationProtocolComponent setSeriesDoses(IntegerType integerType) {
            this.seriesDoses = integerType;
            return this;
        }

        public int getSeriesDosesSimple() {
            return this.seriesDoses == null ? null : Integer.valueOf(this.seriesDoses.getValue());
        }

        public ImmunizationVaccinationProtocolComponent setSeriesDosesSimple(int n) {
            if (n == -1) {
                this.seriesDoses = null;
            } else {
                if (this.seriesDoses == null) {
                    this.seriesDoses = new IntegerType();
                }
                this.seriesDoses.setValue(n);
            }
            return this;
        }

        public CodeableConcept getDoseTarget() {
            return this.doseTarget;
        }

        public ImmunizationVaccinationProtocolComponent setDoseTarget(CodeableConcept codeableConcept) {
            this.doseTarget = codeableConcept;
            return this;
        }

        public CodeableConcept getDoseStatus() {
            return this.doseStatus;
        }

        public ImmunizationVaccinationProtocolComponent setDoseStatus(CodeableConcept codeableConcept) {
            this.doseStatus = codeableConcept;
            return this;
        }

        public CodeableConcept getDoseStatusReason() {
            return this.doseStatusReason;
        }

        public ImmunizationVaccinationProtocolComponent setDoseStatusReason(CodeableConcept codeableConcept) {
            this.doseStatusReason = codeableConcept;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("doseSequence", "integer", "Nominal position in a series.", 0, Integer.MAX_VALUE, this.doseSequence));
            list.add(new Property("description", "string", "Contains the description about the protocol under which the vaccine was administered.", 0, Integer.MAX_VALUE, this.description));
            list.add(new Property("authority", "Resource(Organization)", "Indicates the authority who published the protocol?  E.g. ACIP.", 0, Integer.MAX_VALUE, this.authority));
            list.add(new Property("series", "string", "One possible path to achieve presumed immunity against a disease - within the context of an authority.", 0, Integer.MAX_VALUE, this.series));
            list.add(new Property("seriesDoses", "integer", "The recommended number of doses to achieve immunity.", 0, Integer.MAX_VALUE, this.seriesDoses));
            list.add(new Property("doseTarget", "CodeableConcept", "The targeted disease.", 0, Integer.MAX_VALUE, this.doseTarget));
            list.add(new Property("doseStatus", "CodeableConcept", "Indicates if the immunization event should 'count' against  the protocol.", 0, Integer.MAX_VALUE, this.doseStatus));
            list.add(new Property("doseStatusReason", "CodeableConcept", "Provides an explanation as to why a immunization event should or should not count against the protocol.", 0, Integer.MAX_VALUE, this.doseStatusReason));
        }

        public ImmunizationVaccinationProtocolComponent copy() {
            ImmunizationVaccinationProtocolComponent immunizationVaccinationProtocolComponent = new ImmunizationVaccinationProtocolComponent();
            immunizationVaccinationProtocolComponent.doseSequence = this.doseSequence == null ? null : this.doseSequence.copy();
            immunizationVaccinationProtocolComponent.description = this.description == null ? null : this.description.copy();
            immunizationVaccinationProtocolComponent.authority = this.authority == null ? null : this.authority.copy();
            immunizationVaccinationProtocolComponent.series = this.series == null ? null : this.series.copy();
            immunizationVaccinationProtocolComponent.seriesDoses = this.seriesDoses == null ? null : this.seriesDoses.copy();
            immunizationVaccinationProtocolComponent.doseTarget = this.doseTarget == null ? null : this.doseTarget.copy();
            immunizationVaccinationProtocolComponent.doseStatus = this.doseStatus == null ? null : this.doseStatus.copy();
            immunizationVaccinationProtocolComponent.doseStatusReason = this.doseStatusReason == null ? null : this.doseStatusReason.copy();
            return immunizationVaccinationProtocolComponent;
        }
    }

    public static class ImmunizationReactionComponent
    extends BackboneElement {
        protected DateTimeType date;
        protected ResourceReference detail;
        protected Resource detailTarget;
        protected BooleanType reported;
        private static final long serialVersionUID = -1842660322L;

        public DateTimeType getDate() {
            return this.date;
        }

        public ImmunizationReactionComponent setDate(DateTimeType dateTimeType) {
            this.date = dateTimeType;
            return this;
        }

        public DateAndTime getDateSimple() {
            return this.date == null ? null : this.date.getValue();
        }

        public ImmunizationReactionComponent setDateSimple(DateAndTime dateAndTime) {
            if (dateAndTime == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(dateAndTime);
            }
            return this;
        }

        public ResourceReference getDetail() {
            return this.detail;
        }

        public ImmunizationReactionComponent setDetail(ResourceReference resourceReference) {
            this.detail = resourceReference;
            return this;
        }

        public Resource getDetailTarget() {
            return this.detailTarget;
        }

        public ImmunizationReactionComponent setDetailTarget(Resource resource) {
            this.detailTarget = resource;
            return this;
        }

        public BooleanType getReported() {
            return this.reported;
        }

        public ImmunizationReactionComponent setReported(BooleanType booleanType) {
            this.reported = booleanType;
            return this;
        }

        public boolean getReportedSimple() {
            return this.reported == null ? false : this.reported.getValue();
        }

        public ImmunizationReactionComponent setReportedSimple(boolean bl) {
            if (!bl) {
                this.reported = null;
            } else {
                if (this.reported == null) {
                    this.reported = new BooleanType();
                }
                this.reported.setValue(bl);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("date", "dateTime", "Date of reaction to the immunization.", 0, Integer.MAX_VALUE, this.date));
            list.add(new Property("detail", "Resource(AdverseReaction|Observation)", "Details of the reaction.", 0, Integer.MAX_VALUE, this.detail));
            list.add(new Property("reported", "boolean", "Self-reported indicator.", 0, Integer.MAX_VALUE, this.reported));
        }

        public ImmunizationReactionComponent copy() {
            ImmunizationReactionComponent immunizationReactionComponent = new ImmunizationReactionComponent();
            immunizationReactionComponent.date = this.date == null ? null : this.date.copy();
            immunizationReactionComponent.detail = this.detail == null ? null : this.detail.copy();
            immunizationReactionComponent.reported = this.reported == null ? null : this.reported.copy();
            return immunizationReactionComponent;
        }
    }

    public static class ImmunizationExplanationComponent
    extends BackboneElement {
        protected List<CodeableConcept> reason = new ArrayList<CodeableConcept>();
        protected List<CodeableConcept> refusalReason = new ArrayList<CodeableConcept>();
        private static final long serialVersionUID = -945852082L;

        public List<CodeableConcept> getReason() {
            return this.reason;
        }

        public CodeableConcept addReason() {
            CodeableConcept codeableConcept = new CodeableConcept();
            this.reason.add(codeableConcept);
            return codeableConcept;
        }

        public List<CodeableConcept> getRefusalReason() {
            return this.refusalReason;
        }

        public CodeableConcept addRefusalReason() {
            CodeableConcept codeableConcept = new CodeableConcept();
            this.refusalReason.add(codeableConcept);
            return codeableConcept;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("reason", "CodeableConcept", "Reasons why a vaccine was administered.", 0, Integer.MAX_VALUE, this.reason));
            list.add(new Property("refusalReason", "CodeableConcept", "Refusal or exemption reasons.", 0, Integer.MAX_VALUE, this.refusalReason));
        }

        public ImmunizationExplanationComponent copy() {
            ImmunizationExplanationComponent immunizationExplanationComponent = new ImmunizationExplanationComponent();
            immunizationExplanationComponent.reason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reason) {
                immunizationExplanationComponent.reason.add(codeableConcept.copy());
            }
            immunizationExplanationComponent.refusalReason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.refusalReason) {
                immunizationExplanationComponent.refusalReason.add(codeableConcept.copy());
            }
            return immunizationExplanationComponent;
        }
    }
}

