/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Immunization;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;

public class ImmunizationRecommendation
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected ResourceReference subject;
    protected Patient subjectTarget;
    protected List<ImmunizationRecommendationRecommendationComponent> recommendation = new ArrayList<ImmunizationRecommendationRecommendationComponent>();
    private static final long serialVersionUID = -1986363579L;

    public ImmunizationRecommendation() {
    }

    public ImmunizationRecommendation(ResourceReference resourceReference) {
        this.subject = resourceReference;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public ImmunizationRecommendation setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Patient getSubjectTarget() {
        return this.subjectTarget;
    }

    public ImmunizationRecommendation setSubjectTarget(Patient patient) {
        this.subjectTarget = patient;
        return this;
    }

    public List<ImmunizationRecommendationRecommendationComponent> getRecommendation() {
        return this.recommendation;
    }

    public ImmunizationRecommendationRecommendationComponent addRecommendation() {
        ImmunizationRecommendationRecommendationComponent immunizationRecommendationRecommendationComponent = new ImmunizationRecommendationRecommendationComponent();
        this.recommendation.add(immunizationRecommendationRecommendationComponent);
        return immunizationRecommendationRecommendationComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "A unique identifier assigned to this particular recommendation record.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("subject", "Resource(Patient)", "The patient who is the subject of the profile.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("recommendation", "", "Vaccine administration recommendations.", 0, Integer.MAX_VALUE, this.recommendation));
    }

    public ImmunizationRecommendation copy() {
        ImmunizationRecommendation immunizationRecommendation = new ImmunizationRecommendation();
        immunizationRecommendation.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            immunizationRecommendation.identifier.add(element.copy());
        }
        immunizationRecommendation.subject = this.subject == null ? null : this.subject.copy();
        immunizationRecommendation.recommendation = new ArrayList<ImmunizationRecommendationRecommendationComponent>();
        for (ImmunizationRecommendationRecommendationComponent immunizationRecommendationRecommendationComponent : this.recommendation) {
            immunizationRecommendation.recommendation.add(immunizationRecommendationRecommendationComponent.copy());
        }
        return immunizationRecommendation;
    }

    protected ImmunizationRecommendation typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImmunizationRecommendation;
    }

    public static class ImmunizationRecommendationRecommendationProtocolComponent
    extends BackboneElement {
        protected IntegerType doseSequence;
        protected StringType description;
        protected ResourceReference authority;
        protected Organization authorityTarget;
        protected StringType series;
        private static final long serialVersionUID = -1894841004L;

        public IntegerType getDoseSequence() {
            return this.doseSequence;
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setDoseSequence(IntegerType integerType) {
            this.doseSequence = integerType;
            return this;
        }

        public int getDoseSequenceSimple() {
            return this.doseSequence == null ? null : Integer.valueOf(this.doseSequence.getValue());
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setDoseSequenceSimple(int n) {
            if (n == -1) {
                this.doseSequence = null;
            } else {
                if (this.doseSequence == null) {
                    this.doseSequence = new IntegerType();
                }
                this.doseSequence.setValue(n);
            }
            return this;
        }

        public StringType getDescription() {
            return this.description;
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setDescription(StringType stringType) {
            this.description = stringType;
            return this;
        }

        public String getDescriptionSimple() {
            return this.description == null ? null : this.description.getValue();
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setDescriptionSimple(String string) {
            if (string == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(string);
            }
            return this;
        }

        public ResourceReference getAuthority() {
            return this.authority;
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setAuthority(ResourceReference resourceReference) {
            this.authority = resourceReference;
            return this;
        }

        public Organization getAuthorityTarget() {
            return this.authorityTarget;
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setAuthorityTarget(Organization organization) {
            this.authorityTarget = organization;
            return this;
        }

        public StringType getSeries() {
            return this.series;
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setSeries(StringType stringType) {
            this.series = stringType;
            return this;
        }

        public String getSeriesSimple() {
            return this.series == null ? null : this.series.getValue();
        }

        public ImmunizationRecommendationRecommendationProtocolComponent setSeriesSimple(String string) {
            if (string == null) {
                this.series = null;
            } else {
                if (this.series == null) {
                    this.series = new StringType();
                }
                this.series.setValue(string);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("doseSequence", "integer", "Indicates the nominal position in a series of the next dose.  This is the recommended dose number as per a specified protocol.", 0, Integer.MAX_VALUE, this.doseSequence));
            list.add(new Property("description", "string", "Contains the description about the protocol under which the vaccine was administered.", 0, Integer.MAX_VALUE, this.description));
            list.add(new Property("authority", "Resource(Organization)", "Indicates the authority who published the protocol?  E.g. ACIP.", 0, Integer.MAX_VALUE, this.authority));
            list.add(new Property("series", "string", "One possible path to achieve presumed immunity against a disease - within the context of an authority.", 0, Integer.MAX_VALUE, this.series));
        }

        public ImmunizationRecommendationRecommendationProtocolComponent copy() {
            ImmunizationRecommendationRecommendationProtocolComponent immunizationRecommendationRecommendationProtocolComponent = new ImmunizationRecommendationRecommendationProtocolComponent();
            immunizationRecommendationRecommendationProtocolComponent.doseSequence = this.doseSequence == null ? null : this.doseSequence.copy();
            immunizationRecommendationRecommendationProtocolComponent.description = this.description == null ? null : this.description.copy();
            immunizationRecommendationRecommendationProtocolComponent.authority = this.authority == null ? null : this.authority.copy();
            immunizationRecommendationRecommendationProtocolComponent.series = this.series == null ? null : this.series.copy();
            return immunizationRecommendationRecommendationProtocolComponent;
        }
    }

    public static class ImmunizationRecommendationRecommendationDateCriterionComponent
    extends BackboneElement {
        protected CodeableConcept code;
        protected DateTimeType value;
        private static final long serialVersionUID = 1036994566L;

        public ImmunizationRecommendationRecommendationDateCriterionComponent() {
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent(CodeableConcept codeableConcept, DateTimeType dateTimeType) {
            this.code = codeableConcept;
            this.value = dateTimeType;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent setCode(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
            return this;
        }

        public DateTimeType getValue() {
            return this.value;
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent setValue(DateTimeType dateTimeType) {
            this.value = dateTimeType;
            return this;
        }

        public DateAndTime getValueSimple() {
            return this.value == null ? null : this.value.getValue();
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent setValueSimple(DateAndTime dateAndTime) {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            this.value.setValue(dateAndTime);
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "CodeableConcept", "Date classification of recommendation - e.g. earliest date to give, latest date to give, etc.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("value", "dateTime", "Date recommendation.", 0, Integer.MAX_VALUE, this.value));
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent copy() {
            ImmunizationRecommendationRecommendationDateCriterionComponent immunizationRecommendationRecommendationDateCriterionComponent = new ImmunizationRecommendationRecommendationDateCriterionComponent();
            immunizationRecommendationRecommendationDateCriterionComponent.code = this.code == null ? null : this.code.copy();
            immunizationRecommendationRecommendationDateCriterionComponent.value = this.value == null ? null : this.value.copy();
            return immunizationRecommendationRecommendationDateCriterionComponent;
        }
    }

    public static class ImmunizationRecommendationRecommendationComponent
    extends BackboneElement {
        protected DateTimeType date;
        protected CodeableConcept vaccineType;
        protected IntegerType doseNumber;
        protected CodeableConcept forecastStatus;
        protected List<ImmunizationRecommendationRecommendationDateCriterionComponent> dateCriterion = new ArrayList<ImmunizationRecommendationRecommendationDateCriterionComponent>();
        protected ImmunizationRecommendationRecommendationProtocolComponent protocol;
        protected List<ResourceReference> supportingImmunization = new ArrayList<ResourceReference>();
        protected List<Immunization> supportingImmunizationTarget = new ArrayList<Immunization>();
        protected List<ResourceReference> supportingPatientInformation = new ArrayList<ResourceReference>();
        protected List<Resource> supportingPatientInformationTarget = new ArrayList<Resource>();
        private static final long serialVersionUID = -1269839046L;

        public ImmunizationRecommendationRecommendationComponent() {
        }

        public ImmunizationRecommendationRecommendationComponent(DateTimeType dateTimeType, CodeableConcept codeableConcept, CodeableConcept codeableConcept2) {
            this.date = dateTimeType;
            this.vaccineType = codeableConcept;
            this.forecastStatus = codeableConcept2;
        }

        public DateTimeType getDate() {
            return this.date;
        }

        public ImmunizationRecommendationRecommendationComponent setDate(DateTimeType dateTimeType) {
            this.date = dateTimeType;
            return this;
        }

        public DateAndTime getDateSimple() {
            return this.date == null ? null : this.date.getValue();
        }

        public ImmunizationRecommendationRecommendationComponent setDateSimple(DateAndTime dateAndTime) {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(dateAndTime);
            return this;
        }

        public CodeableConcept getVaccineType() {
            return this.vaccineType;
        }

        public ImmunizationRecommendationRecommendationComponent setVaccineType(CodeableConcept codeableConcept) {
            this.vaccineType = codeableConcept;
            return this;
        }

        public IntegerType getDoseNumber() {
            return this.doseNumber;
        }

        public ImmunizationRecommendationRecommendationComponent setDoseNumber(IntegerType integerType) {
            this.doseNumber = integerType;
            return this;
        }

        public int getDoseNumberSimple() {
            return this.doseNumber == null ? null : Integer.valueOf(this.doseNumber.getValue());
        }

        public ImmunizationRecommendationRecommendationComponent setDoseNumberSimple(int n) {
            if (n == -1) {
                this.doseNumber = null;
            } else {
                if (this.doseNumber == null) {
                    this.doseNumber = new IntegerType();
                }
                this.doseNumber.setValue(n);
            }
            return this;
        }

        public CodeableConcept getForecastStatus() {
            return this.forecastStatus;
        }

        public ImmunizationRecommendationRecommendationComponent setForecastStatus(CodeableConcept codeableConcept) {
            this.forecastStatus = codeableConcept;
            return this;
        }

        public List<ImmunizationRecommendationRecommendationDateCriterionComponent> getDateCriterion() {
            return this.dateCriterion;
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent addDateCriterion() {
            ImmunizationRecommendationRecommendationDateCriterionComponent immunizationRecommendationRecommendationDateCriterionComponent = new ImmunizationRecommendationRecommendationDateCriterionComponent();
            this.dateCriterion.add(immunizationRecommendationRecommendationDateCriterionComponent);
            return immunizationRecommendationRecommendationDateCriterionComponent;
        }

        public ImmunizationRecommendationRecommendationProtocolComponent getProtocol() {
            return this.protocol;
        }

        public ImmunizationRecommendationRecommendationComponent setProtocol(ImmunizationRecommendationRecommendationProtocolComponent immunizationRecommendationRecommendationProtocolComponent) {
            this.protocol = immunizationRecommendationRecommendationProtocolComponent;
            return this;
        }

        public List<ResourceReference> getSupportingImmunization() {
            return this.supportingImmunization;
        }

        public ResourceReference addSupportingImmunization() {
            ResourceReference resourceReference = new ResourceReference();
            this.supportingImmunization.add(resourceReference);
            return resourceReference;
        }

        public List<Immunization> getSupportingImmunizationTarget() {
            return this.supportingImmunizationTarget;
        }

        public Immunization addSupportingImmunizationTarget() {
            Immunization immunization = new Immunization();
            this.supportingImmunizationTarget.add(immunization);
            return immunization;
        }

        public List<ResourceReference> getSupportingPatientInformation() {
            return this.supportingPatientInformation;
        }

        public ResourceReference addSupportingPatientInformation() {
            ResourceReference resourceReference = new ResourceReference();
            this.supportingPatientInformation.add(resourceReference);
            return resourceReference;
        }

        public List<Resource> getSupportingPatientInformationTarget() {
            return this.supportingPatientInformationTarget;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("date", "dateTime", "The date the immunization recommendation was created.", 0, Integer.MAX_VALUE, this.date));
            list.add(new Property("vaccineType", "CodeableConcept", "Vaccine that pertains to the recommendation.", 0, Integer.MAX_VALUE, this.vaccineType));
            list.add(new Property("doseNumber", "integer", "This indicates the next recommended dose number (e.g. dose 2 is the next recommended dose).", 0, Integer.MAX_VALUE, this.doseNumber));
            list.add(new Property("forecastStatus", "CodeableConcept", "Vaccine administration status.", 0, Integer.MAX_VALUE, this.forecastStatus));
            list.add(new Property("dateCriterion", "", "Vaccine date recommendations - e.g. earliest date to administer, latest date to administer, etc.", 0, Integer.MAX_VALUE, this.dateCriterion));
            list.add(new Property("protocol", "", "Contains information about the protocol under which the vaccine was administered.", 0, Integer.MAX_VALUE, this.protocol));
            list.add(new Property("supportingImmunization", "Resource(Immunization)", "Immunization event history that supports the status and recommendation.", 0, Integer.MAX_VALUE, this.supportingImmunization));
            list.add(new Property("supportingPatientInformation", "Resource(Observation|AdverseReaction|AllergyIntolerance)", "Patient Information that supports the status and recommendation.  This includes patient observations, adverse reactions and allergy/intolerance information.", 0, Integer.MAX_VALUE, this.supportingPatientInformation));
        }

        public ImmunizationRecommendationRecommendationComponent copy() {
            ImmunizationRecommendationRecommendationComponent immunizationRecommendationRecommendationComponent = new ImmunizationRecommendationRecommendationComponent();
            immunizationRecommendationRecommendationComponent.date = this.date == null ? null : this.date.copy();
            immunizationRecommendationRecommendationComponent.vaccineType = this.vaccineType == null ? null : this.vaccineType.copy();
            immunizationRecommendationRecommendationComponent.doseNumber = this.doseNumber == null ? null : this.doseNumber.copy();
            immunizationRecommendationRecommendationComponent.forecastStatus = this.forecastStatus == null ? null : this.forecastStatus.copy();
            immunizationRecommendationRecommendationComponent.dateCriterion = new ArrayList<ImmunizationRecommendationRecommendationDateCriterionComponent>();
            for (ImmunizationRecommendationRecommendationDateCriterionComponent element : this.dateCriterion) {
                immunizationRecommendationRecommendationComponent.dateCriterion.add(element.copy());
            }
            immunizationRecommendationRecommendationComponent.protocol = this.protocol == null ? null : this.protocol.copy();
            immunizationRecommendationRecommendationComponent.supportingImmunization = new ArrayList<ResourceReference>();
            for (ResourceReference resourceReference : this.supportingImmunization) {
                immunizationRecommendationRecommendationComponent.supportingImmunization.add(resourceReference.copy());
            }
            immunizationRecommendationRecommendationComponent.supportingPatientInformation = new ArrayList<ResourceReference>();
            for (ResourceReference resourceReference : this.supportingPatientInformation) {
                immunizationRecommendationRecommendationComponent.supportingPatientInformation.add(resourceReference.copy());
            }
            return immunizationRecommendationRecommendationComponent;
        }
    }
}

