/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;

public class List_
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected CodeableConcept code;
    protected ResourceReference subject;
    protected Resource subjectTarget;
    protected ResourceReference source;
    protected Resource sourceTarget;
    protected DateTimeType date;
    protected BooleanType ordered;
    protected Enumeration<ListMode> mode;
    protected List<ListEntryComponent> entry = new ArrayList<ListEntryComponent>();
    protected CodeableConcept emptyReason;
    private static final long serialVersionUID = -1401650190L;

    public List_() {
    }

    public List_(Enumeration<ListMode> enumeration) {
        this.mode = enumeration;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public List_ setCode(CodeableConcept codeableConcept) {
        this.code = codeableConcept;
        return this;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public List_ setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public List_ setSubjectTarget(Resource resource) {
        this.subjectTarget = resource;
        return this;
    }

    public ResourceReference getSource() {
        return this.source;
    }

    public List_ setSource(ResourceReference resourceReference) {
        this.source = resourceReference;
        return this;
    }

    public Resource getSourceTarget() {
        return this.sourceTarget;
    }

    public List_ setSourceTarget(Resource resource) {
        this.sourceTarget = resource;
        return this;
    }

    public DateTimeType getDate() {
        return this.date;
    }

    public List_ setDate(DateTimeType dateTimeType) {
        this.date = dateTimeType;
        return this;
    }

    public DateAndTime getDateSimple() {
        return this.date == null ? null : this.date.getValue();
    }

    public List_ setDateSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(dateAndTime);
        }
        return this;
    }

    public BooleanType getOrdered() {
        return this.ordered;
    }

    public List_ setOrdered(BooleanType booleanType) {
        this.ordered = booleanType;
        return this;
    }

    public boolean getOrderedSimple() {
        return this.ordered == null ? false : this.ordered.getValue();
    }

    public List_ setOrderedSimple(boolean bl) {
        if (!bl) {
            this.ordered = null;
        } else {
            if (this.ordered == null) {
                this.ordered = new BooleanType();
            }
            this.ordered.setValue(bl);
        }
        return this;
    }

    public Enumeration<ListMode> getMode() {
        return this.mode;
    }

    public List_ setMode(Enumeration<ListMode> enumeration) {
        this.mode = enumeration;
        return this;
    }

    public ListMode getModeSimple() {
        return this.mode == null ? null : this.mode.getValue();
    }

    public List_ setModeSimple(ListMode listMode) {
        if (this.mode == null) {
            this.mode = new Enumeration();
        }
        this.mode.setValue(listMode);
        return this;
    }

    public List<ListEntryComponent> getEntry() {
        return this.entry;
    }

    public ListEntryComponent addEntry() {
        ListEntryComponent listEntryComponent = new ListEntryComponent();
        this.entry.add(listEntryComponent);
        return listEntryComponent;
    }

    public CodeableConcept getEmptyReason() {
        return this.emptyReason;
    }

    public List_ setEmptyReason(CodeableConcept codeableConcept) {
        this.emptyReason = codeableConcept;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "Identifier for the List assigned for business purposes outside the context of FHIR.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("code", "CodeableConcept", "This code defines the purpose of the list - why it was created.", 0, Integer.MAX_VALUE, this.code));
        list.add(new Property("subject", "Resource(Patient|Group|Device|Location)", "The common subject (or patient) of the resources that are in the list, if there is one.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("source", "Resource(Practitioner|Patient|Device)", "The entity responsible for deciding what the contents of the list were.", 0, Integer.MAX_VALUE, this.source));
        list.add(new Property("date", "dateTime", "The date that the list was prepared.", 0, Integer.MAX_VALUE, this.date));
        list.add(new Property("ordered", "boolean", "Whether items in the list have a meaningful order.", 0, Integer.MAX_VALUE, this.ordered));
        list.add(new Property("mode", "code", "How this list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.", 0, Integer.MAX_VALUE, this.mode));
        list.add(new Property("entry", "", "Entries in this list.", 0, Integer.MAX_VALUE, this.entry));
        list.add(new Property("emptyReason", "CodeableConcept", "If the list is empty, why the list is empty.", 0, Integer.MAX_VALUE, this.emptyReason));
    }

    public List_ copy() {
        List_ list_ = new List_();
        list_.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            list_.identifier.add(element.copy());
        }
        list_.code = this.code == null ? null : this.code.copy();
        list_.subject = this.subject == null ? null : this.subject.copy();
        list_.source = this.source == null ? null : this.source.copy();
        list_.date = this.date == null ? null : this.date.copy();
        list_.ordered = this.ordered == null ? null : this.ordered.copy();
        list_.mode = this.mode == null ? null : this.mode.copy();
        list_.entry = new ArrayList<ListEntryComponent>();
        for (ListEntryComponent listEntryComponent : this.entry) {
            list_.entry.add(listEntryComponent.copy());
        }
        list_.emptyReason = this.emptyReason == null ? null : this.emptyReason.copy();
        return list_;
    }

    protected List_ typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.List;
    }

    public static class ListEntryComponent
    extends BackboneElement {
        protected List<CodeableConcept> flag = new ArrayList<CodeableConcept>();
        protected BooleanType deleted;
        protected DateTimeType date;
        protected ResourceReference item;
        protected Resource itemTarget;
        private static final long serialVersionUID = -1728647377L;

        public ListEntryComponent() {
        }

        public ListEntryComponent(ResourceReference resourceReference) {
            this.item = resourceReference;
        }

        public List<CodeableConcept> getFlag() {
            return this.flag;
        }

        public CodeableConcept addFlag() {
            CodeableConcept codeableConcept = new CodeableConcept();
            this.flag.add(codeableConcept);
            return codeableConcept;
        }

        public BooleanType getDeleted() {
            return this.deleted;
        }

        public ListEntryComponent setDeleted(BooleanType booleanType) {
            this.deleted = booleanType;
            return this;
        }

        public boolean getDeletedSimple() {
            return this.deleted == null ? false : this.deleted.getValue();
        }

        public ListEntryComponent setDeletedSimple(boolean bl) {
            if (!bl) {
                this.deleted = null;
            } else {
                if (this.deleted == null) {
                    this.deleted = new BooleanType();
                }
                this.deleted.setValue(bl);
            }
            return this;
        }

        public DateTimeType getDate() {
            return this.date;
        }

        public ListEntryComponent setDate(DateTimeType dateTimeType) {
            this.date = dateTimeType;
            return this;
        }

        public DateAndTime getDateSimple() {
            return this.date == null ? null : this.date.getValue();
        }

        public ListEntryComponent setDateSimple(DateAndTime dateAndTime) {
            if (dateAndTime == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(dateAndTime);
            }
            return this;
        }

        public ResourceReference getItem() {
            return this.item;
        }

        public ListEntryComponent setItem(ResourceReference resourceReference) {
            this.item = resourceReference;
            return this;
        }

        public Resource getItemTarget() {
            return this.itemTarget;
        }

        public ListEntryComponent setItemTarget(Resource resource) {
            this.itemTarget = resource;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("flag", "CodeableConcept", "The flag allows the system constructing the list to make one or more statements about the role and significance of the item in the list.", 0, Integer.MAX_VALUE, this.flag));
            list.add(new Property("deleted", "boolean", "True if this item is marked as deleted in the list.", 0, Integer.MAX_VALUE, this.deleted));
            list.add(new Property("date", "dateTime", "When this item was added to the list.", 0, Integer.MAX_VALUE, this.date));
            list.add(new Property("item", "Resource(Any)", "A reference to the actual resource from which data was derived.", 0, Integer.MAX_VALUE, this.item));
        }

        public ListEntryComponent copy() {
            ListEntryComponent listEntryComponent = new ListEntryComponent();
            listEntryComponent.flag = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.flag) {
                listEntryComponent.flag.add(codeableConcept.copy());
            }
            listEntryComponent.deleted = this.deleted == null ? null : this.deleted.copy();
            listEntryComponent.date = this.date == null ? null : this.date.copy();
            listEntryComponent.item = this.item == null ? null : this.item.copy();
            return listEntryComponent;
        }
    }

    public static class ListModeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("working".equals(string)) {
                return ListMode.working;
            }
            if ("snapshot".equals(string)) {
                return ListMode.snapshot;
            }
            if ("changes".equals(string)) {
                return ListMode.changes;
            }
            throw new Exception("Unknown ListMode code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ListMode.working) {
                return "working";
            }
            if (enum_ == ListMode.snapshot) {
                return "snapshot";
            }
            if (enum_ == ListMode.changes) {
                return "changes";
            }
            return "?";
        }
    }

    public static enum ListMode {
        working,
        snapshot,
        changes,
        Null;


        public static ListMode fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("working".equals(string)) {
                return working;
            }
            if ("snapshot".equals(string)) {
                return snapshot;
            }
            if ("changes".equals(string)) {
                return changes;
            }
            throw new Exception("Unknown ListMode code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case working: {
                    return "working";
                }
                case snapshot: {
                    return "snapshot";
                }
                case changes: {
                    return "changes";
                }
            }
            return "?";
        }
    }
}

