/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.DecimalType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;

public class Location
extends Resource {
    protected Identifier identifier;
    protected StringType name;
    protected StringType description;
    protected CodeableConcept type;
    protected List<Contact> telecom = new ArrayList<Contact>();
    protected Address address;
    protected CodeableConcept physicalType;
    protected LocationPositionComponent position;
    protected ResourceReference managingOrganization;
    protected Organization managingOrganizationTarget;
    protected Enumeration<LocationStatus> status;
    protected ResourceReference partOf;
    protected Location partOfTarget;
    protected Enumeration<LocationMode> mode;
    private static final long serialVersionUID = 784899904L;

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Location setIdentifier(Identifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public StringType getName() {
        return this.name;
    }

    public Location setName(StringType stringType) {
        this.name = stringType;
        return this;
    }

    public String getNameSimple() {
        return this.name == null ? null : this.name.getValue();
    }

    public Location setNameSimple(String string) {
        if (string == null) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(string);
        }
        return this;
    }

    public StringType getDescription() {
        return this.description;
    }

    public Location setDescription(StringType stringType) {
        this.description = stringType;
        return this;
    }

    public String getDescriptionSimple() {
        return this.description == null ? null : this.description.getValue();
    }

    public Location setDescriptionSimple(String string) {
        if (string == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(string);
        }
        return this;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Location setType(CodeableConcept codeableConcept) {
        this.type = codeableConcept;
        return this;
    }

    public List<Contact> getTelecom() {
        return this.telecom;
    }

    public Contact addTelecom() {
        Contact contact = new Contact();
        this.telecom.add(contact);
        return contact;
    }

    public Address getAddress() {
        return this.address;
    }

    public Location setAddress(Address address) {
        this.address = address;
        return this;
    }

    public CodeableConcept getPhysicalType() {
        return this.physicalType;
    }

    public Location setPhysicalType(CodeableConcept codeableConcept) {
        this.physicalType = codeableConcept;
        return this;
    }

    public LocationPositionComponent getPosition() {
        return this.position;
    }

    public Location setPosition(LocationPositionComponent locationPositionComponent) {
        this.position = locationPositionComponent;
        return this;
    }

    public ResourceReference getManagingOrganization() {
        return this.managingOrganization;
    }

    public Location setManagingOrganization(ResourceReference resourceReference) {
        this.managingOrganization = resourceReference;
        return this;
    }

    public Organization getManagingOrganizationTarget() {
        return this.managingOrganizationTarget;
    }

    public Location setManagingOrganizationTarget(Organization organization) {
        this.managingOrganizationTarget = organization;
        return this;
    }

    public Enumeration<LocationStatus> getStatus() {
        return this.status;
    }

    public Location setStatus(Enumeration<LocationStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public LocationStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public Location setStatusSimple(LocationStatus locationStatus) {
        if (locationStatus == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration();
            }
            this.status.setValue(locationStatus);
        }
        return this;
    }

    public ResourceReference getPartOf() {
        return this.partOf;
    }

    public Location setPartOf(ResourceReference resourceReference) {
        this.partOf = resourceReference;
        return this;
    }

    public Location getPartOfTarget() {
        return this.partOfTarget;
    }

    public Location setPartOfTarget(Location location) {
        this.partOfTarget = location;
        return this;
    }

    public Enumeration<LocationMode> getMode() {
        return this.mode;
    }

    public Location setMode(Enumeration<LocationMode> enumeration) {
        this.mode = enumeration;
        return this;
    }

    public LocationMode getModeSimple() {
        return this.mode == null ? null : this.mode.getValue();
    }

    public Location setModeSimple(LocationMode locationMode) {
        if (locationMode == null) {
            this.mode = null;
        } else {
            if (this.mode == null) {
                this.mode = new Enumeration();
            }
            this.mode.setValue(locationMode);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "Unique code or number identifying the location to its users.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("name", "string", "Name of the location as used by humans. Does not need to be unique.", 0, Integer.MAX_VALUE, this.name));
        list.add(new Property("description", "string", "Description of the Location, which helps in finding or referencing the place.", 0, Integer.MAX_VALUE, this.description));
        list.add(new Property("type", "CodeableConcept", "Indicates the type of function performed at the location.", 0, Integer.MAX_VALUE, this.type));
        list.add(new Property("telecom", "Contact", "The contact details of communication devices available at the location. This can include phone numbers, fax numbers, mobile numbers, email addresses and web sites.", 0, Integer.MAX_VALUE, this.telecom));
        list.add(new Property("address", "Address", "Physical location.", 0, Integer.MAX_VALUE, this.address));
        list.add(new Property("physicalType", "CodeableConcept", "Physical form of the location, e.g. building, room, vehicle, road.", 0, Integer.MAX_VALUE, this.physicalType));
        list.add(new Property("position", "", "The absolute geographic location of the Location, expressed in a KML compatible manner (see notes below for KML).", 0, Integer.MAX_VALUE, this.position));
        list.add(new Property("managingOrganization", "Resource(Organization)", "The organization that is responsible for the provisioning and upkeep of the location.", 0, Integer.MAX_VALUE, this.managingOrganization));
        list.add(new Property("status", "code", "active | suspended | inactive.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("partOf", "Resource(Location)", "Another Location which this Location is physically part of.", 0, Integer.MAX_VALUE, this.partOf));
        list.add(new Property("mode", "code", "Indicates whether a resource instance represents a specific location or a class of locations.", 0, Integer.MAX_VALUE, this.mode));
    }

    public Location copy() {
        Location location = new Location();
        location.identifier = this.identifier == null ? null : this.identifier.copy();
        location.name = this.name == null ? null : this.name.copy();
        location.description = this.description == null ? null : this.description.copy();
        location.type = this.type == null ? null : this.type.copy();
        location.telecom = new ArrayList<Contact>();
        for (Contact contact : this.telecom) {
            location.telecom.add(contact.copy());
        }
        location.address = this.address == null ? null : this.address.copy();
        location.physicalType = this.physicalType == null ? null : this.physicalType.copy();
        location.position = this.position == null ? null : this.position.copy();
        location.managingOrganization = this.managingOrganization == null ? null : this.managingOrganization.copy();
        location.status = this.status == null ? null : this.status.copy();
        location.partOf = this.partOf == null ? null : this.partOf.copy();
        location.mode = this.mode == null ? null : this.mode.copy();
        return location;
    }

    protected Location typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Location;
    }

    public static class LocationPositionComponent
    extends BackboneElement {
        protected DecimalType longitude;
        protected DecimalType latitude;
        protected DecimalType altitude;
        private static final long serialVersionUID = -74276134L;

        public LocationPositionComponent() {
        }

        public LocationPositionComponent(DecimalType decimalType, DecimalType decimalType2) {
            this.longitude = decimalType;
            this.latitude = decimalType2;
        }

        public DecimalType getLongitude() {
            return this.longitude;
        }

        public LocationPositionComponent setLongitude(DecimalType decimalType) {
            this.longitude = decimalType;
            return this;
        }

        public BigDecimal getLongitudeSimple() {
            return this.longitude == null ? null : this.longitude.getValue();
        }

        public LocationPositionComponent setLongitudeSimple(BigDecimal bigDecimal) {
            if (this.longitude == null) {
                this.longitude = new DecimalType();
            }
            this.longitude.setValue(bigDecimal);
            return this;
        }

        public DecimalType getLatitude() {
            return this.latitude;
        }

        public LocationPositionComponent setLatitude(DecimalType decimalType) {
            this.latitude = decimalType;
            return this;
        }

        public BigDecimal getLatitudeSimple() {
            return this.latitude == null ? null : this.latitude.getValue();
        }

        public LocationPositionComponent setLatitudeSimple(BigDecimal bigDecimal) {
            if (this.latitude == null) {
                this.latitude = new DecimalType();
            }
            this.latitude.setValue(bigDecimal);
            return this;
        }

        public DecimalType getAltitude() {
            return this.altitude;
        }

        public LocationPositionComponent setAltitude(DecimalType decimalType) {
            this.altitude = decimalType;
            return this;
        }

        public BigDecimal getAltitudeSimple() {
            return this.altitude == null ? null : this.altitude.getValue();
        }

        public LocationPositionComponent setAltitudeSimple(BigDecimal bigDecimal) {
            if (bigDecimal == null) {
                this.altitude = null;
            } else {
                if (this.altitude == null) {
                    this.altitude = new DecimalType();
                }
                this.altitude.setValue(bigDecimal);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("longitude", "decimal", "Longitude. The value domain and the interpretation are the same as for the text of the longitude element in KML (see notes below).", 0, Integer.MAX_VALUE, this.longitude));
            list.add(new Property("latitude", "decimal", "Latitude. The value domain and the interpretation are the same as for the text of the latitude element in KML (see notes below).", 0, Integer.MAX_VALUE, this.latitude));
            list.add(new Property("altitude", "decimal", "Altitude. The value domain and the interpretation are the same as for the text of the altitude element in KML (see notes below).", 0, Integer.MAX_VALUE, this.altitude));
        }

        public LocationPositionComponent copy() {
            LocationPositionComponent locationPositionComponent = new LocationPositionComponent();
            locationPositionComponent.longitude = this.longitude == null ? null : this.longitude.copy();
            locationPositionComponent.latitude = this.latitude == null ? null : this.latitude.copy();
            locationPositionComponent.altitude = this.altitude == null ? null : this.altitude.copy();
            return locationPositionComponent;
        }
    }

    public static class LocationModeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("instance".equals(string)) {
                return LocationMode.instance;
            }
            if ("kind".equals(string)) {
                return LocationMode.kind;
            }
            throw new Exception("Unknown LocationMode code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == LocationMode.instance) {
                return "instance";
            }
            if (enum_ == LocationMode.kind) {
                return "kind";
            }
            return "?";
        }
    }

    public static enum LocationMode {
        instance,
        kind,
        Null;


        public static LocationMode fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("instance".equals(string)) {
                return instance;
            }
            if ("kind".equals(string)) {
                return kind;
            }
            throw new Exception("Unknown LocationMode code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case instance: {
                    return "instance";
                }
                case kind: {
                    return "kind";
                }
            }
            return "?";
        }
    }

    public static class LocationStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("active".equals(string)) {
                return LocationStatus.active;
            }
            if ("suspended".equals(string)) {
                return LocationStatus.suspended;
            }
            if ("inactive".equals(string)) {
                return LocationStatus.inactive;
            }
            throw new Exception("Unknown LocationStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == LocationStatus.active) {
                return "active";
            }
            if (enum_ == LocationStatus.suspended) {
                return "suspended";
            }
            if (enum_ == LocationStatus.inactive) {
                return "inactive";
            }
            return "?";
        }
    }

    public static enum LocationStatus {
        active,
        suspended,
        inactive,
        Null;


        public static LocationStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("active".equals(string)) {
                return active;
            }
            if ("suspended".equals(string)) {
                return suspended;
            }
            if ("inactive".equals(string)) {
                return inactive;
            }
            throw new Exception("Unknown LocationStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case active: {
                    return "active";
                }
                case suspended: {
                    return "suspended";
                }
                case inactive: {
                    return "inactive";
                }
            }
            return "?";
        }
    }
}

