/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;

public class Media
extends Resource {
    protected Enumeration<MediaType> type;
    protected CodeableConcept subtype;
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected DateTimeType dateTime;
    protected ResourceReference subject;
    protected Resource subjectTarget;
    protected ResourceReference operator;
    protected Practitioner operatorTarget;
    protected CodeableConcept view;
    protected StringType deviceName;
    protected IntegerType height;
    protected IntegerType width;
    protected IntegerType frames;
    protected IntegerType length;
    protected Attachment content;
    private static final long serialVersionUID = 633107111L;

    public Media() {
    }

    public Media(Enumeration<MediaType> enumeration, Attachment attachment) {
        this.type = enumeration;
        this.content = attachment;
    }

    public Enumeration<MediaType> getType() {
        return this.type;
    }

    public Media setType(Enumeration<MediaType> enumeration) {
        this.type = enumeration;
        return this;
    }

    public MediaType getTypeSimple() {
        return this.type == null ? null : this.type.getValue();
    }

    public Media setTypeSimple(MediaType mediaType) {
        if (this.type == null) {
            this.type = new Enumeration();
        }
        this.type.setValue(mediaType);
        return this;
    }

    public CodeableConcept getSubtype() {
        return this.subtype;
    }

    public Media setSubtype(CodeableConcept codeableConcept) {
        this.subtype = codeableConcept;
        return this;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public DateTimeType getDateTime() {
        return this.dateTime;
    }

    public Media setDateTime(DateTimeType dateTimeType) {
        this.dateTime = dateTimeType;
        return this;
    }

    public DateAndTime getDateTimeSimple() {
        return this.dateTime == null ? null : this.dateTime.getValue();
    }

    public Media setDateTimeSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.dateTime = null;
        } else {
            if (this.dateTime == null) {
                this.dateTime = new DateTimeType();
            }
            this.dateTime.setValue(dateAndTime);
        }
        return this;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public Media setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Media setSubjectTarget(Resource resource) {
        this.subjectTarget = resource;
        return this;
    }

    public ResourceReference getOperator() {
        return this.operator;
    }

    public Media setOperator(ResourceReference resourceReference) {
        this.operator = resourceReference;
        return this;
    }

    public Practitioner getOperatorTarget() {
        return this.operatorTarget;
    }

    public Media setOperatorTarget(Practitioner practitioner) {
        this.operatorTarget = practitioner;
        return this;
    }

    public CodeableConcept getView() {
        return this.view;
    }

    public Media setView(CodeableConcept codeableConcept) {
        this.view = codeableConcept;
        return this;
    }

    public StringType getDeviceName() {
        return this.deviceName;
    }

    public Media setDeviceName(StringType stringType) {
        this.deviceName = stringType;
        return this;
    }

    public String getDeviceNameSimple() {
        return this.deviceName == null ? null : this.deviceName.getValue();
    }

    public Media setDeviceNameSimple(String string) {
        if (string == null) {
            this.deviceName = null;
        } else {
            if (this.deviceName == null) {
                this.deviceName = new StringType();
            }
            this.deviceName.setValue(string);
        }
        return this;
    }

    public IntegerType getHeight() {
        return this.height;
    }

    public Media setHeight(IntegerType integerType) {
        this.height = integerType;
        return this;
    }

    public int getHeightSimple() {
        return this.height == null ? null : Integer.valueOf(this.height.getValue());
    }

    public Media setHeightSimple(int n) {
        if (n == -1) {
            this.height = null;
        } else {
            if (this.height == null) {
                this.height = new IntegerType();
            }
            this.height.setValue(n);
        }
        return this;
    }

    public IntegerType getWidth() {
        return this.width;
    }

    public Media setWidth(IntegerType integerType) {
        this.width = integerType;
        return this;
    }

    public int getWidthSimple() {
        return this.width == null ? null : Integer.valueOf(this.width.getValue());
    }

    public Media setWidthSimple(int n) {
        if (n == -1) {
            this.width = null;
        } else {
            if (this.width == null) {
                this.width = new IntegerType();
            }
            this.width.setValue(n);
        }
        return this;
    }

    public IntegerType getFrames() {
        return this.frames;
    }

    public Media setFrames(IntegerType integerType) {
        this.frames = integerType;
        return this;
    }

    public int getFramesSimple() {
        return this.frames == null ? null : Integer.valueOf(this.frames.getValue());
    }

    public Media setFramesSimple(int n) {
        if (n == -1) {
            this.frames = null;
        } else {
            if (this.frames == null) {
                this.frames = new IntegerType();
            }
            this.frames.setValue(n);
        }
        return this;
    }

    public IntegerType getLength() {
        return this.length;
    }

    public Media setLength(IntegerType integerType) {
        this.length = integerType;
        return this;
    }

    public int getLengthSimple() {
        return this.length == null ? null : Integer.valueOf(this.length.getValue());
    }

    public Media setLengthSimple(int n) {
        if (n == -1) {
            this.length = null;
        } else {
            if (this.length == null) {
                this.length = new IntegerType();
            }
            this.length.setValue(n);
        }
        return this;
    }

    public Attachment getContent() {
        return this.content;
    }

    public Media setContent(Attachment attachment) {
        this.content = attachment;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("type", "code", "Whether the media is a photo (still image), an audio recording, or a video recording.", 0, Integer.MAX_VALUE, this.type));
        list.add(new Property("subtype", "CodeableConcept", "Details of the type of the media - usually, how it was acquired (what type of device). If images sourced from a DICOM system, are wrapped in a Media resource, then this is the modality.", 0, Integer.MAX_VALUE, this.subtype));
        list.add(new Property("identifier", "Identifier", "Identifiers associated with the image - these may include identifiers for the image itself, identifiers for the context of its collection (e.g. series ids) and context ids such as accession numbers or other workflow identifiers.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("dateTime", "dateTime", "When the media was originally recorded. For video and audio, if the length of the recording is not insignificant, this is the end of the recording.", 0, Integer.MAX_VALUE, this.dateTime));
        list.add(new Property("subject", "Resource(Patient|Practitioner|Group|Device|Specimen)", "Who/What this Media is a record of.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("operator", "Resource(Practitioner)", "The person who administered the collection of the image.", 0, Integer.MAX_VALUE, this.operator));
        list.add(new Property("view", "CodeableConcept", "The name of the imaging view e.g Lateral or Antero-posterior (AP).", 0, Integer.MAX_VALUE, this.view));
        list.add(new Property("deviceName", "string", "The name of the device / manufacturer of the device  that was used to make the recording.", 0, Integer.MAX_VALUE, this.deviceName));
        list.add(new Property("height", "integer", "Height of the image in pixels(photo/video).", 0, Integer.MAX_VALUE, this.height));
        list.add(new Property("width", "integer", "Width of the image in pixels (photo/video).", 0, Integer.MAX_VALUE, this.width));
        list.add(new Property("frames", "integer", "The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif. If there is more than one frame, this SHALL have a value in order to alert interface software that a multi-frame capable rendering widget is required.", 0, Integer.MAX_VALUE, this.frames));
        list.add(new Property("length", "integer", "The length of the recording in seconds - for audio and video.", 0, Integer.MAX_VALUE, this.length));
        list.add(new Property("content", "Attachment", "The actual content of the media - inline or by direct reference to the media source file.", 0, Integer.MAX_VALUE, this.content));
    }

    public Media copy() {
        Media media = new Media();
        media.type = this.type == null ? null : this.type.copy();
        media.subtype = this.subtype == null ? null : this.subtype.copy();
        media.identifier = new ArrayList<Identifier>();
        for (Identifier identifier : this.identifier) {
            media.identifier.add(identifier.copy());
        }
        media.dateTime = this.dateTime == null ? null : this.dateTime.copy();
        media.subject = this.subject == null ? null : this.subject.copy();
        media.operator = this.operator == null ? null : this.operator.copy();
        media.view = this.view == null ? null : this.view.copy();
        media.deviceName = this.deviceName == null ? null : this.deviceName.copy();
        media.height = this.height == null ? null : this.height.copy();
        media.width = this.width == null ? null : this.width.copy();
        media.frames = this.frames == null ? null : this.frames.copy();
        media.length = this.length == null ? null : this.length.copy();
        media.content = this.content == null ? null : this.content.copy();
        return media;
    }

    protected Media typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Media;
    }

    public static class MediaTypeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("photo".equals(string)) {
                return MediaType.photo;
            }
            if ("video".equals(string)) {
                return MediaType.video;
            }
            if ("audio".equals(string)) {
                return MediaType.audio;
            }
            throw new Exception("Unknown MediaType code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == MediaType.photo) {
                return "photo";
            }
            if (enum_ == MediaType.video) {
                return "video";
            }
            if (enum_ == MediaType.audio) {
                return "audio";
            }
            return "?";
        }
    }

    public static enum MediaType {
        photo,
        video,
        audio,
        Null;


        public static MediaType fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("photo".equals(string)) {
                return photo;
            }
            if ("video".equals(string)) {
                return video;
            }
            if ("audio".equals(string)) {
                return audio;
            }
            throw new Exception("Unknown MediaType code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case photo: {
                    return "photo";
                }
                case video: {
                    return "video";
                }
                case audio: {
                    return "audio";
                }
            }
            return "?";
        }
    }
}

