/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;

public class Medication
extends Resource {
    protected StringType name;
    protected CodeableConcept code;
    protected BooleanType isBrand;
    protected ResourceReference manufacturer;
    protected Organization manufacturerTarget;
    protected Enumeration<MedicationKind> kind;
    protected MedicationProductComponent product;
    protected MedicationPackageComponent package_;
    private static final long serialVersionUID = -1406021045L;

    public StringType getName() {
        return this.name;
    }

    public Medication setName(StringType stringType) {
        this.name = stringType;
        return this;
    }

    public String getNameSimple() {
        return this.name == null ? null : this.name.getValue();
    }

    public Medication setNameSimple(String string) {
        if (string == null) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(string);
        }
        return this;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public Medication setCode(CodeableConcept codeableConcept) {
        this.code = codeableConcept;
        return this;
    }

    public BooleanType getIsBrand() {
        return this.isBrand;
    }

    public Medication setIsBrand(BooleanType booleanType) {
        this.isBrand = booleanType;
        return this;
    }

    public boolean getIsBrandSimple() {
        return this.isBrand == null ? false : this.isBrand.getValue();
    }

    public Medication setIsBrandSimple(boolean bl) {
        if (!bl) {
            this.isBrand = null;
        } else {
            if (this.isBrand == null) {
                this.isBrand = new BooleanType();
            }
            this.isBrand.setValue(bl);
        }
        return this;
    }

    public ResourceReference getManufacturer() {
        return this.manufacturer;
    }

    public Medication setManufacturer(ResourceReference resourceReference) {
        this.manufacturer = resourceReference;
        return this;
    }

    public Organization getManufacturerTarget() {
        return this.manufacturerTarget;
    }

    public Medication setManufacturerTarget(Organization organization) {
        this.manufacturerTarget = organization;
        return this;
    }

    public Enumeration<MedicationKind> getKind() {
        return this.kind;
    }

    public Medication setKind(Enumeration<MedicationKind> enumeration) {
        this.kind = enumeration;
        return this;
    }

    public MedicationKind getKindSimple() {
        return this.kind == null ? null : this.kind.getValue();
    }

    public Medication setKindSimple(MedicationKind medicationKind) {
        if (medicationKind == null) {
            this.kind = null;
        } else {
            if (this.kind == null) {
                this.kind = new Enumeration();
            }
            this.kind.setValue(medicationKind);
        }
        return this;
    }

    public MedicationProductComponent getProduct() {
        return this.product;
    }

    public Medication setProduct(MedicationProductComponent medicationProductComponent) {
        this.product = medicationProductComponent;
        return this;
    }

    public MedicationPackageComponent getPackage() {
        return this.package_;
    }

    public Medication setPackage(MedicationPackageComponent medicationPackageComponent) {
        this.package_ = medicationPackageComponent;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("name", "string", "The common/commercial name of the medication absent information such as strength, form, etc.  E.g. Acetaminophen, Tylenol 3, etc.  The fully coordinated name is communicated as the display of Medication.code.", 0, Integer.MAX_VALUE, this.name));
        list.add(new Property("code", "CodeableConcept", "A code (or set of codes) that identify this medication.   Usage note: This could be a standard drug code such as a drug regulator code, RxNorm code, SNOMED CT code, etc. It could also be a local formulary code, optionally with translations to the standard drug codes.", 0, Integer.MAX_VALUE, this.code));
        list.add(new Property("isBrand", "boolean", "Set to true if the item is attributable to a specific manufacturer (even if we don't know who that is).", 0, Integer.MAX_VALUE, this.isBrand));
        list.add(new Property("manufacturer", "Resource(Organization)", "Describes the details of the manufacturer.", 0, Integer.MAX_VALUE, this.manufacturer));
        list.add(new Property("kind", "code", "Medications are either a single administrable product or a package that contains one or more products.", 0, Integer.MAX_VALUE, this.kind));
        list.add(new Property("product", "", "Information that only applies to products (not packages).", 0, Integer.MAX_VALUE, this.product));
        list.add(new Property("package", "", "Information that only applies to packages (not products).", 0, Integer.MAX_VALUE, this.package_));
    }

    public Medication copy() {
        Medication medication = new Medication();
        medication.name = this.name == null ? null : this.name.copy();
        medication.code = this.code == null ? null : this.code.copy();
        medication.isBrand = this.isBrand == null ? null : this.isBrand.copy();
        medication.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        medication.kind = this.kind == null ? null : this.kind.copy();
        medication.product = this.product == null ? null : this.product.copy();
        medication.package_ = this.package_ == null ? null : this.package_.copy();
        return medication;
    }

    protected Medication typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Medication;
    }

    public static class MedicationPackageContentComponent
    extends BackboneElement {
        protected ResourceReference item;
        protected Medication itemTarget;
        protected Quantity amount;
        private static final long serialVersionUID = 1971935074L;

        public MedicationPackageContentComponent() {
        }

        public MedicationPackageContentComponent(ResourceReference resourceReference) {
            this.item = resourceReference;
        }

        public ResourceReference getItem() {
            return this.item;
        }

        public MedicationPackageContentComponent setItem(ResourceReference resourceReference) {
            this.item = resourceReference;
            return this;
        }

        public Medication getItemTarget() {
            return this.itemTarget;
        }

        public MedicationPackageContentComponent setItemTarget(Medication medication) {
            this.itemTarget = medication;
            return this;
        }

        public Quantity getAmount() {
            return this.amount;
        }

        public MedicationPackageContentComponent setAmount(Quantity quantity) {
            this.amount = quantity;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("item", "Resource(Medication)", "Identifies one of the items in the package.", 0, Integer.MAX_VALUE, this.item));
            list.add(new Property("amount", "Quantity", "The amount of the product that is in the package.", 0, Integer.MAX_VALUE, this.amount));
        }

        public MedicationPackageContentComponent copy() {
            MedicationPackageContentComponent medicationPackageContentComponent = new MedicationPackageContentComponent();
            medicationPackageContentComponent.item = this.item == null ? null : this.item.copy();
            medicationPackageContentComponent.amount = this.amount == null ? null : this.amount.copy();
            return medicationPackageContentComponent;
        }
    }

    public static class MedicationPackageComponent
    extends BackboneElement {
        protected CodeableConcept container;
        protected List<MedicationPackageContentComponent> content = new ArrayList<MedicationPackageContentComponent>();
        private static final long serialVersionUID = -62466804L;

        public CodeableConcept getContainer() {
            return this.container;
        }

        public MedicationPackageComponent setContainer(CodeableConcept codeableConcept) {
            this.container = codeableConcept;
            return this;
        }

        public List<MedicationPackageContentComponent> getContent() {
            return this.content;
        }

        public MedicationPackageContentComponent addContent() {
            MedicationPackageContentComponent medicationPackageContentComponent = new MedicationPackageContentComponent();
            this.content.add(medicationPackageContentComponent);
            return medicationPackageContentComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("container", "CodeableConcept", "The kind of container that this package comes as.", 0, Integer.MAX_VALUE, this.container));
            list.add(new Property("content", "", "A set of components that go to make up the described item.", 0, Integer.MAX_VALUE, this.content));
        }

        public MedicationPackageComponent copy() {
            MedicationPackageComponent medicationPackageComponent = new MedicationPackageComponent();
            medicationPackageComponent.container = this.container == null ? null : this.container.copy();
            medicationPackageComponent.content = new ArrayList<MedicationPackageContentComponent>();
            for (MedicationPackageContentComponent medicationPackageContentComponent : this.content) {
                medicationPackageComponent.content.add(medicationPackageContentComponent.copy());
            }
            return medicationPackageComponent;
        }
    }

    public static class MedicationProductIngredientComponent
    extends BackboneElement {
        protected ResourceReference item;
        protected Resource itemTarget;
        protected Ratio amount;
        private static final long serialVersionUID = 928082101L;

        public MedicationProductIngredientComponent() {
        }

        public MedicationProductIngredientComponent(ResourceReference resourceReference) {
            this.item = resourceReference;
        }

        public ResourceReference getItem() {
            return this.item;
        }

        public MedicationProductIngredientComponent setItem(ResourceReference resourceReference) {
            this.item = resourceReference;
            return this;
        }

        public Resource getItemTarget() {
            return this.itemTarget;
        }

        public MedicationProductIngredientComponent setItemTarget(Resource resource) {
            this.itemTarget = resource;
            return this;
        }

        public Ratio getAmount() {
            return this.amount;
        }

        public MedicationProductIngredientComponent setAmount(Ratio ratio) {
            this.amount = ratio;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("item", "Resource(Substance|Medication)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, Integer.MAX_VALUE, this.item));
            list.add(new Property("amount", "Ratio", "Specifies how many (or how much) of the items there are in this Medication.  E.g. 250 mg per tablet.", 0, Integer.MAX_VALUE, this.amount));
        }

        public MedicationProductIngredientComponent copy() {
            MedicationProductIngredientComponent medicationProductIngredientComponent = new MedicationProductIngredientComponent();
            medicationProductIngredientComponent.item = this.item == null ? null : this.item.copy();
            medicationProductIngredientComponent.amount = this.amount == null ? null : this.amount.copy();
            return medicationProductIngredientComponent;
        }
    }

    public static class MedicationProductComponent
    extends BackboneElement {
        protected CodeableConcept form;
        protected List<MedicationProductIngredientComponent> ingredient = new ArrayList<MedicationProductIngredientComponent>();
        private static final long serialVersionUID = 698672741L;

        public CodeableConcept getForm() {
            return this.form;
        }

        public MedicationProductComponent setForm(CodeableConcept codeableConcept) {
            this.form = codeableConcept;
            return this;
        }

        public List<MedicationProductIngredientComponent> getIngredient() {
            return this.ingredient;
        }

        public MedicationProductIngredientComponent addIngredient() {
            MedicationProductIngredientComponent medicationProductIngredientComponent = new MedicationProductIngredientComponent();
            this.ingredient.add(medicationProductIngredientComponent);
            return medicationProductIngredientComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("form", "CodeableConcept", "Describes the form of the item.  Powder; tables; carton.", 0, Integer.MAX_VALUE, this.form));
            list.add(new Property("ingredient", "", "Identifies a particular constituent of interest in the product.", 0, Integer.MAX_VALUE, this.ingredient));
        }

        public MedicationProductComponent copy() {
            MedicationProductComponent medicationProductComponent = new MedicationProductComponent();
            medicationProductComponent.form = this.form == null ? null : this.form.copy();
            medicationProductComponent.ingredient = new ArrayList<MedicationProductIngredientComponent>();
            for (MedicationProductIngredientComponent medicationProductIngredientComponent : this.ingredient) {
                medicationProductComponent.ingredient.add(medicationProductIngredientComponent.copy());
            }
            return medicationProductComponent;
        }
    }

    public static class MedicationKindEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("product".equals(string)) {
                return MedicationKind.product;
            }
            if ("package".equals(string)) {
                return MedicationKind.package_;
            }
            throw new Exception("Unknown MedicationKind code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == MedicationKind.product) {
                return "product";
            }
            if (enum_ == MedicationKind.package_) {
                return "package";
            }
            return "?";
        }
    }

    public static enum MedicationKind {
        product,
        package_,
        Null;


        public static MedicationKind fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("product".equals(string)) {
                return product;
            }
            if ("package".equals(string)) {
                return package_;
            }
            throw new Exception("Unknown MedicationKind code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case product: {
                    return "product";
                }
                case package_: {
                    return "package";
                }
            }
            return "?";
        }
    }
}

