/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Device;
import org.hl7.fhir.instance.model.Encounter;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Medication;
import org.hl7.fhir.instance.model.MedicationPrescription;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.Type;

public class MedicationAdministration
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected Enumeration<MedicationAdminStatus> status;
    protected ResourceReference patient;
    protected Patient patientTarget;
    protected ResourceReference practitioner;
    protected Practitioner practitionerTarget;
    protected ResourceReference encounter;
    protected Encounter encounterTarget;
    protected ResourceReference prescription;
    protected MedicationPrescription prescriptionTarget;
    protected BooleanType wasNotGiven;
    protected List<CodeableConcept> reasonNotGiven = new ArrayList<CodeableConcept>();
    protected Period whenGiven;
    protected ResourceReference medication;
    protected Medication medicationTarget;
    protected List<ResourceReference> device = new ArrayList<ResourceReference>();
    protected List<Device> deviceTarget = new ArrayList<Device>();
    protected List<MedicationAdministrationDosageComponent> dosage = new ArrayList<MedicationAdministrationDosageComponent>();
    private static final long serialVersionUID = -1505926298L;

    public MedicationAdministration() {
    }

    public MedicationAdministration(Enumeration<MedicationAdminStatus> enumeration, ResourceReference resourceReference, ResourceReference resourceReference2, ResourceReference resourceReference3, Period period) {
        this.status = enumeration;
        this.patient = resourceReference;
        this.practitioner = resourceReference2;
        this.prescription = resourceReference3;
        this.whenGiven = period;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public Enumeration<MedicationAdminStatus> getStatus() {
        return this.status;
    }

    public MedicationAdministration setStatus(Enumeration<MedicationAdminStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public MedicationAdminStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public MedicationAdministration setStatusSimple(MedicationAdminStatus medicationAdminStatus) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(medicationAdminStatus);
        return this;
    }

    public ResourceReference getPatient() {
        return this.patient;
    }

    public MedicationAdministration setPatient(ResourceReference resourceReference) {
        this.patient = resourceReference;
        return this;
    }

    public Patient getPatientTarget() {
        return this.patientTarget;
    }

    public MedicationAdministration setPatientTarget(Patient patient) {
        this.patientTarget = patient;
        return this;
    }

    public ResourceReference getPractitioner() {
        return this.practitioner;
    }

    public MedicationAdministration setPractitioner(ResourceReference resourceReference) {
        this.practitioner = resourceReference;
        return this;
    }

    public Practitioner getPractitionerTarget() {
        return this.practitionerTarget;
    }

    public MedicationAdministration setPractitionerTarget(Practitioner practitioner) {
        this.practitionerTarget = practitioner;
        return this;
    }

    public ResourceReference getEncounter() {
        return this.encounter;
    }

    public MedicationAdministration setEncounter(ResourceReference resourceReference) {
        this.encounter = resourceReference;
        return this;
    }

    public Encounter getEncounterTarget() {
        return this.encounterTarget;
    }

    public MedicationAdministration setEncounterTarget(Encounter encounter) {
        this.encounterTarget = encounter;
        return this;
    }

    public ResourceReference getPrescription() {
        return this.prescription;
    }

    public MedicationAdministration setPrescription(ResourceReference resourceReference) {
        this.prescription = resourceReference;
        return this;
    }

    public MedicationPrescription getPrescriptionTarget() {
        return this.prescriptionTarget;
    }

    public MedicationAdministration setPrescriptionTarget(MedicationPrescription medicationPrescription) {
        this.prescriptionTarget = medicationPrescription;
        return this;
    }

    public BooleanType getWasNotGiven() {
        return this.wasNotGiven;
    }

    public MedicationAdministration setWasNotGiven(BooleanType booleanType) {
        this.wasNotGiven = booleanType;
        return this;
    }

    public boolean getWasNotGivenSimple() {
        return this.wasNotGiven == null ? false : this.wasNotGiven.getValue();
    }

    public MedicationAdministration setWasNotGivenSimple(boolean bl) {
        if (!bl) {
            this.wasNotGiven = null;
        } else {
            if (this.wasNotGiven == null) {
                this.wasNotGiven = new BooleanType();
            }
            this.wasNotGiven.setValue(bl);
        }
        return this;
    }

    public List<CodeableConcept> getReasonNotGiven() {
        return this.reasonNotGiven;
    }

    public CodeableConcept addReasonNotGiven() {
        CodeableConcept codeableConcept = new CodeableConcept();
        this.reasonNotGiven.add(codeableConcept);
        return codeableConcept;
    }

    public Period getWhenGiven() {
        return this.whenGiven;
    }

    public MedicationAdministration setWhenGiven(Period period) {
        this.whenGiven = period;
        return this;
    }

    public ResourceReference getMedication() {
        return this.medication;
    }

    public MedicationAdministration setMedication(ResourceReference resourceReference) {
        this.medication = resourceReference;
        return this;
    }

    public Medication getMedicationTarget() {
        return this.medicationTarget;
    }

    public MedicationAdministration setMedicationTarget(Medication medication) {
        this.medicationTarget = medication;
        return this;
    }

    public List<ResourceReference> getDevice() {
        return this.device;
    }

    public ResourceReference addDevice() {
        ResourceReference resourceReference = new ResourceReference();
        this.device.add(resourceReference);
        return resourceReference;
    }

    public List<Device> getDeviceTarget() {
        return this.deviceTarget;
    }

    public Device addDeviceTarget() {
        Device device = new Device();
        this.deviceTarget.add(device);
        return device;
    }

    public List<MedicationAdministrationDosageComponent> getDosage() {
        return this.dosage;
    }

    public MedicationAdministrationDosageComponent addDosage() {
        MedicationAdministrationDosageComponent medicationAdministrationDosageComponent = new MedicationAdministrationDosageComponent();
        this.dosage.add(medicationAdministrationDosageComponent);
        return medicationAdministrationDosageComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "External identifier - FHIR will generate its own internal IDs (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("status", "code", "Will generally be set to show that the administration has been completed.  For some long running administrations such as infusions it is possible for an administration to be started but not completed or it may be paused while some other process is under way.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("patient", "Resource(Patient)", "The person or animal to whom the medication was given.", 0, Integer.MAX_VALUE, this.patient));
        list.add(new Property("practitioner", "Resource(Practitioner)", "The individual who was responsible for giving the medication to the patient.", 0, Integer.MAX_VALUE, this.practitioner));
        list.add(new Property("encounter", "Resource(Encounter)", "The visit or admission the or other contact between patient and health care provider the medication administration was performed as part of.", 0, Integer.MAX_VALUE, this.encounter));
        list.add(new Property("prescription", "Resource(MedicationPrescription)", "The original request, instruction or authority to perform the administration.", 0, Integer.MAX_VALUE, this.prescription));
        list.add(new Property("wasNotGiven", "boolean", "Set this to true if the record is saying that the medication was NOT administered.", 0, Integer.MAX_VALUE, this.wasNotGiven));
        list.add(new Property("reasonNotGiven", "CodeableConcept", "A code indicating why the administration was not performed.", 0, Integer.MAX_VALUE, this.reasonNotGiven));
        list.add(new Property("whenGiven", "Period", "An interval of time during which the administration took place.  For many administrations, such as swallowing a tablet the lower and upper values of the interval will be the same.", 0, Integer.MAX_VALUE, this.whenGiven));
        list.add(new Property("medication", "Resource(Medication)", "Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, Integer.MAX_VALUE, this.medication));
        list.add(new Property("device", "Resource(Device)", "The device used in administering the medication to the patient.  E.g. a particular infusion pump.", 0, Integer.MAX_VALUE, this.device));
        list.add(new Property("dosage", "", "Provides details of how much of the medication was administered.", 0, Integer.MAX_VALUE, this.dosage));
    }

    public MedicationAdministration copy() {
        MedicationAdministration medicationAdministration = new MedicationAdministration();
        medicationAdministration.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            medicationAdministration.identifier.add(element.copy());
        }
        medicationAdministration.status = this.status == null ? null : this.status.copy();
        medicationAdministration.patient = this.patient == null ? null : this.patient.copy();
        medicationAdministration.practitioner = this.practitioner == null ? null : this.practitioner.copy();
        medicationAdministration.encounter = this.encounter == null ? null : this.encounter.copy();
        medicationAdministration.prescription = this.prescription == null ? null : this.prescription.copy();
        medicationAdministration.wasNotGiven = this.wasNotGiven == null ? null : this.wasNotGiven.copy();
        medicationAdministration.reasonNotGiven = new ArrayList<CodeableConcept>();
        for (CodeableConcept codeableConcept : this.reasonNotGiven) {
            medicationAdministration.reasonNotGiven.add(codeableConcept.copy());
        }
        medicationAdministration.whenGiven = this.whenGiven == null ? null : this.whenGiven.copy();
        medicationAdministration.medication = this.medication == null ? null : this.medication.copy();
        medicationAdministration.device = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.device) {
            medicationAdministration.device.add(resourceReference.copy());
        }
        medicationAdministration.dosage = new ArrayList<MedicationAdministrationDosageComponent>();
        for (MedicationAdministrationDosageComponent medicationAdministrationDosageComponent : this.dosage) {
            medicationAdministration.dosage.add(medicationAdministrationDosageComponent.copy());
        }
        return medicationAdministration;
    }

    protected MedicationAdministration typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationAdministration;
    }

    public static class MedicationAdministrationDosageComponent
    extends BackboneElement {
        protected Type timing;
        protected Type asNeeded;
        protected CodeableConcept site;
        protected CodeableConcept route;
        protected CodeableConcept method;
        protected Quantity quantity;
        protected Ratio rate;
        protected Ratio maxDosePerPeriod;
        private static final long serialVersionUID = 1667442570L;

        public Type getTiming() {
            return this.timing;
        }

        public MedicationAdministrationDosageComponent setTiming(Type type) {
            this.timing = type;
            return this;
        }

        public Type getAsNeeded() {
            return this.asNeeded;
        }

        public MedicationAdministrationDosageComponent setAsNeeded(Type type) {
            this.asNeeded = type;
            return this;
        }

        public CodeableConcept getSite() {
            return this.site;
        }

        public MedicationAdministrationDosageComponent setSite(CodeableConcept codeableConcept) {
            this.site = codeableConcept;
            return this;
        }

        public CodeableConcept getRoute() {
            return this.route;
        }

        public MedicationAdministrationDosageComponent setRoute(CodeableConcept codeableConcept) {
            this.route = codeableConcept;
            return this;
        }

        public CodeableConcept getMethod() {
            return this.method;
        }

        public MedicationAdministrationDosageComponent setMethod(CodeableConcept codeableConcept) {
            this.method = codeableConcept;
            return this;
        }

        public Quantity getQuantity() {
            return this.quantity;
        }

        public MedicationAdministrationDosageComponent setQuantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public Ratio getRate() {
            return this.rate;
        }

        public MedicationAdministrationDosageComponent setRate(Ratio ratio) {
            this.rate = ratio;
            return this;
        }

        public Ratio getMaxDosePerPeriod() {
            return this.maxDosePerPeriod;
        }

        public MedicationAdministrationDosageComponent setMaxDosePerPeriod(Ratio ratio) {
            this.maxDosePerPeriod = ratio;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("timing[x]", "dateTime|Period", "The timing schedule for giving the medication to the patient.  This may be a single time point (using dateTime) or it may be a start and end dateTime (Period).", 0, Integer.MAX_VALUE, this.timing));
            list.add(new Property("asNeeded[x]", "boolean|CodeableConcept", "If set to true or if specified as a CodeableConcept, indicates that the medication is only taken when needed within the specified schedule rather than at every scheduled dose.  If a CodeableConcept is present, it indicates the pre-condition for taking the Medication.", 0, Integer.MAX_VALUE, this.asNeeded));
            list.add(new Property("site", "CodeableConcept", "A coded specification of the anatomic site where the medication first entered the body.  E.g. 'left arm'.", 0, Integer.MAX_VALUE, this.site));
            list.add(new Property("route", "CodeableConcept", "A code specifying the route or physiological path of administration of a therapeutic agent into or onto the patient.   E.g. topical, intravenous, etc.", 0, Integer.MAX_VALUE, this.route));
            list.add(new Property("method", "CodeableConcept", "A coded value indicating the method by which the medication was introduced into or onto the body. Most commonly used for injections.  Examples:  Slow Push; Deep IV.\n\nTerminologies used often pre-coordinate this term with the route and or form of administration.", 0, Integer.MAX_VALUE, this.method));
            list.add(new Property("quantity", "Quantity", "The amount of the medication given at one administration event.   Use this value when the administration is essentially an instantaneous event such as a swallowing a tablet or giving an injection.", 0, Integer.MAX_VALUE, this.quantity));
            list.add(new Property("rate", "Ratio", "Identifies the speed with which the medication was introduced into the patient. Typically the rate for an infusion e.g. 200ml in 2 hours.  May also expressed as a rate per unit of time such as 100ml per hour - the duration is then not specified, or is specified in the quantity.", 0, Integer.MAX_VALUE, this.rate));
            list.add(new Property("maxDosePerPeriod", "Ratio", "The maximum total quantity of a therapeutic substance that was administered to the patient over the specified period of time. E.g. 1000mg in 24 hours.", 0, Integer.MAX_VALUE, this.maxDosePerPeriod));
        }

        public MedicationAdministrationDosageComponent copy() {
            MedicationAdministrationDosageComponent medicationAdministrationDosageComponent = new MedicationAdministrationDosageComponent();
            medicationAdministrationDosageComponent.timing = this.timing == null ? null : this.timing.copy();
            medicationAdministrationDosageComponent.asNeeded = this.asNeeded == null ? null : this.asNeeded.copy();
            medicationAdministrationDosageComponent.site = this.site == null ? null : this.site.copy();
            medicationAdministrationDosageComponent.route = this.route == null ? null : this.route.copy();
            medicationAdministrationDosageComponent.method = this.method == null ? null : this.method.copy();
            medicationAdministrationDosageComponent.quantity = this.quantity == null ? null : this.quantity.copy();
            medicationAdministrationDosageComponent.rate = this.rate == null ? null : this.rate.copy();
            medicationAdministrationDosageComponent.maxDosePerPeriod = this.maxDosePerPeriod == null ? null : this.maxDosePerPeriod.copy();
            return medicationAdministrationDosageComponent;
        }
    }

    public static class MedicationAdminStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("in progress".equals(string)) {
                return MedicationAdminStatus.inProgress;
            }
            if ("on hold".equals(string)) {
                return MedicationAdminStatus.onHold;
            }
            if ("completed".equals(string)) {
                return MedicationAdminStatus.completed;
            }
            if ("entered in error".equals(string)) {
                return MedicationAdminStatus.enteredInError;
            }
            if ("stopped".equals(string)) {
                return MedicationAdminStatus.stopped;
            }
            throw new Exception("Unknown MedicationAdminStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == MedicationAdminStatus.inProgress) {
                return "in progress";
            }
            if (enum_ == MedicationAdminStatus.onHold) {
                return "on hold";
            }
            if (enum_ == MedicationAdminStatus.completed) {
                return "completed";
            }
            if (enum_ == MedicationAdminStatus.enteredInError) {
                return "entered in error";
            }
            if (enum_ == MedicationAdminStatus.stopped) {
                return "stopped";
            }
            return "?";
        }
    }

    public static enum MedicationAdminStatus {
        inProgress,
        onHold,
        completed,
        enteredInError,
        stopped,
        Null;


        public static MedicationAdminStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("in progress".equals(string)) {
                return inProgress;
            }
            if ("on hold".equals(string)) {
                return onHold;
            }
            if ("completed".equals(string)) {
                return completed;
            }
            if ("entered in error".equals(string)) {
                return enteredInError;
            }
            if ("stopped".equals(string)) {
                return stopped;
            }
            throw new Exception("Unknown MedicationAdminStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case inProgress: {
                    return "in progress";
                }
                case onHold: {
                    return "on hold";
                }
                case completed: {
                    return "completed";
                }
                case enteredInError: {
                    return "entered in error";
                }
                case stopped: {
                    return "stopped";
                }
            }
            return "?";
        }
    }
}

