/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Location;
import org.hl7.fhir.instance.model.Medication;
import org.hl7.fhir.instance.model.MedicationPrescription;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.Type;

public class MedicationDispense
extends Resource {
    protected Identifier identifier;
    protected Enumeration<MedicationDispenseStatus> status;
    protected ResourceReference patient;
    protected Patient patientTarget;
    protected ResourceReference dispenser;
    protected Practitioner dispenserTarget;
    protected List<ResourceReference> authorizingPrescription = new ArrayList<ResourceReference>();
    protected List<MedicationPrescription> authorizingPrescriptionTarget = new ArrayList<MedicationPrescription>();
    protected List<MedicationDispenseDispenseComponent> dispense = new ArrayList<MedicationDispenseDispenseComponent>();
    protected MedicationDispenseSubstitutionComponent substitution;
    private static final long serialVersionUID = 1726669338L;

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public MedicationDispense setIdentifier(Identifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public Enumeration<MedicationDispenseStatus> getStatus() {
        return this.status;
    }

    public MedicationDispense setStatus(Enumeration<MedicationDispenseStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public MedicationDispenseStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public MedicationDispense setStatusSimple(MedicationDispenseStatus medicationDispenseStatus) {
        if (medicationDispenseStatus == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration();
            }
            this.status.setValue(medicationDispenseStatus);
        }
        return this;
    }

    public ResourceReference getPatient() {
        return this.patient;
    }

    public MedicationDispense setPatient(ResourceReference resourceReference) {
        this.patient = resourceReference;
        return this;
    }

    public Patient getPatientTarget() {
        return this.patientTarget;
    }

    public MedicationDispense setPatientTarget(Patient patient) {
        this.patientTarget = patient;
        return this;
    }

    public ResourceReference getDispenser() {
        return this.dispenser;
    }

    public MedicationDispense setDispenser(ResourceReference resourceReference) {
        this.dispenser = resourceReference;
        return this;
    }

    public Practitioner getDispenserTarget() {
        return this.dispenserTarget;
    }

    public MedicationDispense setDispenserTarget(Practitioner practitioner) {
        this.dispenserTarget = practitioner;
        return this;
    }

    public List<ResourceReference> getAuthorizingPrescription() {
        return this.authorizingPrescription;
    }

    public ResourceReference addAuthorizingPrescription() {
        ResourceReference resourceReference = new ResourceReference();
        this.authorizingPrescription.add(resourceReference);
        return resourceReference;
    }

    public List<MedicationPrescription> getAuthorizingPrescriptionTarget() {
        return this.authorizingPrescriptionTarget;
    }

    public MedicationPrescription addAuthorizingPrescriptionTarget() {
        MedicationPrescription medicationPrescription = new MedicationPrescription();
        this.authorizingPrescriptionTarget.add(medicationPrescription);
        return medicationPrescription;
    }

    public List<MedicationDispenseDispenseComponent> getDispense() {
        return this.dispense;
    }

    public MedicationDispenseDispenseComponent addDispense() {
        MedicationDispenseDispenseComponent medicationDispenseDispenseComponent = new MedicationDispenseDispenseComponent();
        this.dispense.add(medicationDispenseDispenseComponent);
        return medicationDispenseDispenseComponent;
    }

    public MedicationDispenseSubstitutionComponent getSubstitution() {
        return this.substitution;
    }

    public MedicationDispense setSubstitution(MedicationDispenseSubstitutionComponent medicationDispenseSubstitutionComponent) {
        this.substitution = medicationDispenseSubstitutionComponent;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "Identifier assigned by the dispensing facility - this is an identifier assigned outside FHIR.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("status", "code", "A code specifying the state of the set of dispense events.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("patient", "Resource(Patient)", "A link to a resource representing the person to whom the medication will be given.", 0, Integer.MAX_VALUE, this.patient));
        list.add(new Property("dispenser", "Resource(Practitioner)", "The individual responsible for dispensing the medication.", 0, Integer.MAX_VALUE, this.dispenser));
        list.add(new Property("authorizingPrescription", "Resource(MedicationPrescription)", "Indicates the medication order that is being dispensed against.", 0, Integer.MAX_VALUE, this.authorizingPrescription));
        list.add(new Property("dispense", "", "Indicates the details of the dispense event such as the days supply and quantity of medication dispensed.", 0, Integer.MAX_VALUE, this.dispense));
        list.add(new Property("substitution", "", "Indicates whether or not substitution was made as part of the dispense.  In some cases substitution will be expected but doesn't happen, in other cases substitution is not expected but does happen.  This block explains what substitition did or did not happen and why.", 0, Integer.MAX_VALUE, this.substitution));
    }

    public MedicationDispense copy() {
        MedicationDispense medicationDispense = new MedicationDispense();
        medicationDispense.identifier = this.identifier == null ? null : this.identifier.copy();
        medicationDispense.status = this.status == null ? null : this.status.copy();
        medicationDispense.patient = this.patient == null ? null : this.patient.copy();
        medicationDispense.dispenser = this.dispenser == null ? null : this.dispenser.copy();
        medicationDispense.authorizingPrescription = new ArrayList<ResourceReference>();
        for (ResourceReference element : this.authorizingPrescription) {
            medicationDispense.authorizingPrescription.add(element.copy());
        }
        medicationDispense.dispense = new ArrayList<MedicationDispenseDispenseComponent>();
        for (MedicationDispenseDispenseComponent medicationDispenseDispenseComponent : this.dispense) {
            medicationDispense.dispense.add(medicationDispenseDispenseComponent.copy());
        }
        medicationDispense.substitution = this.substitution == null ? null : this.substitution.copy();
        return medicationDispense;
    }

    protected MedicationDispense typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationDispense;
    }

    public static class MedicationDispenseSubstitutionComponent
    extends BackboneElement {
        protected CodeableConcept type;
        protected List<CodeableConcept> reason = new ArrayList<CodeableConcept>();
        protected List<ResourceReference> responsibleParty = new ArrayList<ResourceReference>();
        protected List<Practitioner> responsiblePartyTarget = new ArrayList<Practitioner>();
        private static final long serialVersionUID = -1275850915L;

        public MedicationDispenseSubstitutionComponent() {
        }

        public MedicationDispenseSubstitutionComponent(CodeableConcept codeableConcept) {
            this.type = codeableConcept;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public MedicationDispenseSubstitutionComponent setType(CodeableConcept codeableConcept) {
            this.type = codeableConcept;
            return this;
        }

        public List<CodeableConcept> getReason() {
            return this.reason;
        }

        public CodeableConcept addReason() {
            CodeableConcept codeableConcept = new CodeableConcept();
            this.reason.add(codeableConcept);
            return codeableConcept;
        }

        public List<ResourceReference> getResponsibleParty() {
            return this.responsibleParty;
        }

        public ResourceReference addResponsibleParty() {
            ResourceReference resourceReference = new ResourceReference();
            this.responsibleParty.add(resourceReference);
            return resourceReference;
        }

        public List<Practitioner> getResponsiblePartyTarget() {
            return this.responsiblePartyTarget;
        }

        public Practitioner addResponsiblePartyTarget() {
            Practitioner practitioner = new Practitioner();
            this.responsiblePartyTarget.add(practitioner);
            return practitioner;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("type", "CodeableConcept", "A code signifying whether a different drug was dispensed from what was prescribed.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("reason", "CodeableConcept", "Indicates the reason for the substitution of (or lack of substitution) from what was prescribed.", 0, Integer.MAX_VALUE, this.reason));
            list.add(new Property("responsibleParty", "Resource(Practitioner)", "The person or organization that has primary responsibility for the substitution.", 0, Integer.MAX_VALUE, this.responsibleParty));
        }

        public MedicationDispenseSubstitutionComponent copy() {
            MedicationDispenseSubstitutionComponent medicationDispenseSubstitutionComponent = new MedicationDispenseSubstitutionComponent();
            medicationDispenseSubstitutionComponent.type = this.type == null ? null : this.type.copy();
            medicationDispenseSubstitutionComponent.reason = new ArrayList<CodeableConcept>();
            for (CodeableConcept type : this.reason) {
                medicationDispenseSubstitutionComponent.reason.add(type.copy());
            }
            medicationDispenseSubstitutionComponent.responsibleParty = new ArrayList<ResourceReference>();
            for (ResourceReference resourceReference : this.responsibleParty) {
                medicationDispenseSubstitutionComponent.responsibleParty.add(resourceReference.copy());
            }
            return medicationDispenseSubstitutionComponent;
        }
    }

    public static class MedicationDispenseDispenseDosageComponent
    extends BackboneElement {
        protected CodeableConcept additionalInstructions;
        protected Type timing;
        protected Type asNeeded;
        protected CodeableConcept site;
        protected CodeableConcept route;
        protected CodeableConcept method;
        protected Quantity quantity;
        protected Ratio rate;
        protected Ratio maxDosePerPeriod;
        private static final long serialVersionUID = 498364389L;

        public CodeableConcept getAdditionalInstructions() {
            return this.additionalInstructions;
        }

        public MedicationDispenseDispenseDosageComponent setAdditionalInstructions(CodeableConcept codeableConcept) {
            this.additionalInstructions = codeableConcept;
            return this;
        }

        public Type getTiming() {
            return this.timing;
        }

        public MedicationDispenseDispenseDosageComponent setTiming(Type type) {
            this.timing = type;
            return this;
        }

        public Type getAsNeeded() {
            return this.asNeeded;
        }

        public MedicationDispenseDispenseDosageComponent setAsNeeded(Type type) {
            this.asNeeded = type;
            return this;
        }

        public CodeableConcept getSite() {
            return this.site;
        }

        public MedicationDispenseDispenseDosageComponent setSite(CodeableConcept codeableConcept) {
            this.site = codeableConcept;
            return this;
        }

        public CodeableConcept getRoute() {
            return this.route;
        }

        public MedicationDispenseDispenseDosageComponent setRoute(CodeableConcept codeableConcept) {
            this.route = codeableConcept;
            return this;
        }

        public CodeableConcept getMethod() {
            return this.method;
        }

        public MedicationDispenseDispenseDosageComponent setMethod(CodeableConcept codeableConcept) {
            this.method = codeableConcept;
            return this;
        }

        public Quantity getQuantity() {
            return this.quantity;
        }

        public MedicationDispenseDispenseDosageComponent setQuantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public Ratio getRate() {
            return this.rate;
        }

        public MedicationDispenseDispenseDosageComponent setRate(Ratio ratio) {
            this.rate = ratio;
            return this;
        }

        public Ratio getMaxDosePerPeriod() {
            return this.maxDosePerPeriod;
        }

        public MedicationDispenseDispenseDosageComponent setMaxDosePerPeriod(Ratio ratio) {
            this.maxDosePerPeriod = ratio;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("additionalInstructions", "CodeableConcept", "Additional instructions such as 'Swallow with plenty of water' which may or may not be coded.", 0, Integer.MAX_VALUE, this.additionalInstructions));
            list.add(new Property("timing[x]", "dateTime|Period|Schedule", "The timing schedule for giving the medication to the patient.  The Schedule data type allows many different expressions, for example.  'Every  8 hours'; 'Three times a day'; '1/2 an hour before breakfast for 10 days from 23-Dec 2011:';  '15 Oct 2013, 17 Oct 2013 and 1 Nov 2013'.", 0, Integer.MAX_VALUE, this.timing));
            list.add(new Property("asNeeded[x]", "boolean|CodeableConcept", "If set to true or if specified as a CodeableConcept, indicates that the medication is only taken when needed within the specified schedule rather than at every scheduled dose.  If a CodeableConcept is present, it indicates the pre-condition for taking the Medication.", 0, Integer.MAX_VALUE, this.asNeeded));
            list.add(new Property("site", "CodeableConcept", "A coded specification of the anatomic site where the medication first enters the body.", 0, Integer.MAX_VALUE, this.site));
            list.add(new Property("route", "CodeableConcept", "A code specifying the route or physiological path of administration of a therapeutic agent into or onto a subject.", 0, Integer.MAX_VALUE, this.route));
            list.add(new Property("method", "CodeableConcept", "A coded value indicating the method by which the medication is introduced into or onto the body. Most commonly used for injections.  Examples:  Slow Push; Deep IV.\n\nTerminologies used often pre-coordinate this term with the route and or form of administration.", 0, Integer.MAX_VALUE, this.method));
            list.add(new Property("quantity", "Quantity", "The amount of therapeutic or other substance given at one administration event.", 0, Integer.MAX_VALUE, this.quantity));
            list.add(new Property("rate", "Ratio", "Identifies the speed with which the substance is introduced into the subject. Typically the rate for an infusion. 200ml in 2 hours.", 0, Integer.MAX_VALUE, this.rate));
            list.add(new Property("maxDosePerPeriod", "Ratio", "The maximum total quantity of a therapeutic substance that may be administered to a subject over the period of time,  e.g. 1000mg in 24 hours.", 0, Integer.MAX_VALUE, this.maxDosePerPeriod));
        }

        public MedicationDispenseDispenseDosageComponent copy() {
            MedicationDispenseDispenseDosageComponent medicationDispenseDispenseDosageComponent = new MedicationDispenseDispenseDosageComponent();
            medicationDispenseDispenseDosageComponent.additionalInstructions = this.additionalInstructions == null ? null : this.additionalInstructions.copy();
            medicationDispenseDispenseDosageComponent.timing = this.timing == null ? null : this.timing.copy();
            medicationDispenseDispenseDosageComponent.asNeeded = this.asNeeded == null ? null : this.asNeeded.copy();
            medicationDispenseDispenseDosageComponent.site = this.site == null ? null : this.site.copy();
            medicationDispenseDispenseDosageComponent.route = this.route == null ? null : this.route.copy();
            medicationDispenseDispenseDosageComponent.method = this.method == null ? null : this.method.copy();
            medicationDispenseDispenseDosageComponent.quantity = this.quantity == null ? null : this.quantity.copy();
            medicationDispenseDispenseDosageComponent.rate = this.rate == null ? null : this.rate.copy();
            medicationDispenseDispenseDosageComponent.maxDosePerPeriod = this.maxDosePerPeriod == null ? null : this.maxDosePerPeriod.copy();
            return medicationDispenseDispenseDosageComponent;
        }
    }

    public static class MedicationDispenseDispenseComponent
    extends BackboneElement {
        protected Identifier identifier;
        protected Enumeration<MedicationDispenseStatus> status;
        protected CodeableConcept type;
        protected Quantity quantity;
        protected ResourceReference medication;
        protected Medication medicationTarget;
        protected DateTimeType whenPrepared;
        protected DateTimeType whenHandedOver;
        protected ResourceReference destination;
        protected Location destinationTarget;
        protected List<ResourceReference> receiver = new ArrayList<ResourceReference>();
        protected List<Resource> receiverTarget = new ArrayList<Resource>();
        protected List<MedicationDispenseDispenseDosageComponent> dosage = new ArrayList<MedicationDispenseDispenseDosageComponent>();
        private static final long serialVersionUID = -557541864L;

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public MedicationDispenseDispenseComponent setIdentifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Enumeration<MedicationDispenseStatus> getStatus() {
            return this.status;
        }

        public MedicationDispenseDispenseComponent setStatus(Enumeration<MedicationDispenseStatus> enumeration) {
            this.status = enumeration;
            return this;
        }

        public MedicationDispenseStatus getStatusSimple() {
            return this.status == null ? null : this.status.getValue();
        }

        public MedicationDispenseDispenseComponent setStatusSimple(MedicationDispenseStatus medicationDispenseStatus) {
            if (medicationDispenseStatus == null) {
                this.status = null;
            } else {
                if (this.status == null) {
                    this.status = new Enumeration();
                }
                this.status.setValue(medicationDispenseStatus);
            }
            return this;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public MedicationDispenseDispenseComponent setType(CodeableConcept codeableConcept) {
            this.type = codeableConcept;
            return this;
        }

        public Quantity getQuantity() {
            return this.quantity;
        }

        public MedicationDispenseDispenseComponent setQuantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public ResourceReference getMedication() {
            return this.medication;
        }

        public MedicationDispenseDispenseComponent setMedication(ResourceReference resourceReference) {
            this.medication = resourceReference;
            return this;
        }

        public Medication getMedicationTarget() {
            return this.medicationTarget;
        }

        public MedicationDispenseDispenseComponent setMedicationTarget(Medication medication) {
            this.medicationTarget = medication;
            return this;
        }

        public DateTimeType getWhenPrepared() {
            return this.whenPrepared;
        }

        public MedicationDispenseDispenseComponent setWhenPrepared(DateTimeType dateTimeType) {
            this.whenPrepared = dateTimeType;
            return this;
        }

        public DateAndTime getWhenPreparedSimple() {
            return this.whenPrepared == null ? null : this.whenPrepared.getValue();
        }

        public MedicationDispenseDispenseComponent setWhenPreparedSimple(DateAndTime dateAndTime) {
            if (dateAndTime == null) {
                this.whenPrepared = null;
            } else {
                if (this.whenPrepared == null) {
                    this.whenPrepared = new DateTimeType();
                }
                this.whenPrepared.setValue(dateAndTime);
            }
            return this;
        }

        public DateTimeType getWhenHandedOver() {
            return this.whenHandedOver;
        }

        public MedicationDispenseDispenseComponent setWhenHandedOver(DateTimeType dateTimeType) {
            this.whenHandedOver = dateTimeType;
            return this;
        }

        public DateAndTime getWhenHandedOverSimple() {
            return this.whenHandedOver == null ? null : this.whenHandedOver.getValue();
        }

        public MedicationDispenseDispenseComponent setWhenHandedOverSimple(DateAndTime dateAndTime) {
            if (dateAndTime == null) {
                this.whenHandedOver = null;
            } else {
                if (this.whenHandedOver == null) {
                    this.whenHandedOver = new DateTimeType();
                }
                this.whenHandedOver.setValue(dateAndTime);
            }
            return this;
        }

        public ResourceReference getDestination() {
            return this.destination;
        }

        public MedicationDispenseDispenseComponent setDestination(ResourceReference resourceReference) {
            this.destination = resourceReference;
            return this;
        }

        public Location getDestinationTarget() {
            return this.destinationTarget;
        }

        public MedicationDispenseDispenseComponent setDestinationTarget(Location location) {
            this.destinationTarget = location;
            return this;
        }

        public List<ResourceReference> getReceiver() {
            return this.receiver;
        }

        public ResourceReference addReceiver() {
            ResourceReference resourceReference = new ResourceReference();
            this.receiver.add(resourceReference);
            return resourceReference;
        }

        public List<Resource> getReceiverTarget() {
            return this.receiverTarget;
        }

        public List<MedicationDispenseDispenseDosageComponent> getDosage() {
            return this.dosage;
        }

        public MedicationDispenseDispenseDosageComponent addDosage() {
            MedicationDispenseDispenseDosageComponent medicationDispenseDispenseDosageComponent = new MedicationDispenseDispenseDosageComponent();
            this.dosage.add(medicationDispenseDispenseDosageComponent);
            return medicationDispenseDispenseDosageComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("identifier", "Identifier", "Identifier assigned by the dispensing facility.   This is an identifier assigned outside FHIR.", 0, Integer.MAX_VALUE, this.identifier));
            list.add(new Property("status", "code", "A code specifying the state of the dispense event.", 0, Integer.MAX_VALUE, this.status));
            list.add(new Property("type", "CodeableConcept", "Indicates the type of dispensing event that is performed. Examples include: Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("quantity", "Quantity", "The amount of medication that has been dispensed. Includes unit of measure.", 0, Integer.MAX_VALUE, this.quantity));
            list.add(new Property("medication", "Resource(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, Integer.MAX_VALUE, this.medication));
            list.add(new Property("whenPrepared", "dateTime", "The time when the dispensed product was packaged and reviewed.", 0, Integer.MAX_VALUE, this.whenPrepared));
            list.add(new Property("whenHandedOver", "dateTime", "The time the dispensed product was provided to the patient or their representative.", 0, Integer.MAX_VALUE, this.whenHandedOver));
            list.add(new Property("destination", "Resource(Location)", "Identification of the facility/location where the medication was shipped to, as part of the dispense event.", 0, Integer.MAX_VALUE, this.destination));
            list.add(new Property("receiver", "Resource(Patient|Practitioner)", "Identifies the person who picked up the medication.  This will usually be a patient or their carer, but some cases exist where it can be a healthcare professional.", 0, Integer.MAX_VALUE, this.receiver));
            list.add(new Property("dosage", "", "Indicates how the medication is to be used by the patient.", 0, Integer.MAX_VALUE, this.dosage));
        }

        public MedicationDispenseDispenseComponent copy() {
            MedicationDispenseDispenseComponent medicationDispenseDispenseComponent = new MedicationDispenseDispenseComponent();
            medicationDispenseDispenseComponent.identifier = this.identifier == null ? null : this.identifier.copy();
            medicationDispenseDispenseComponent.status = this.status == null ? null : this.status.copy();
            medicationDispenseDispenseComponent.type = this.type == null ? null : this.type.copy();
            medicationDispenseDispenseComponent.quantity = this.quantity == null ? null : this.quantity.copy();
            medicationDispenseDispenseComponent.medication = this.medication == null ? null : this.medication.copy();
            medicationDispenseDispenseComponent.whenPrepared = this.whenPrepared == null ? null : this.whenPrepared.copy();
            medicationDispenseDispenseComponent.whenHandedOver = this.whenHandedOver == null ? null : this.whenHandedOver.copy();
            medicationDispenseDispenseComponent.destination = this.destination == null ? null : this.destination.copy();
            medicationDispenseDispenseComponent.receiver = new ArrayList<ResourceReference>();
            for (ResourceReference element : this.receiver) {
                medicationDispenseDispenseComponent.receiver.add(element.copy());
            }
            medicationDispenseDispenseComponent.dosage = new ArrayList<MedicationDispenseDispenseDosageComponent>();
            for (MedicationDispenseDispenseDosageComponent medicationDispenseDispenseDosageComponent : this.dosage) {
                medicationDispenseDispenseComponent.dosage.add(medicationDispenseDispenseDosageComponent.copy());
            }
            return medicationDispenseDispenseComponent;
        }
    }

    public static class MedicationDispenseStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("in progress".equals(string)) {
                return MedicationDispenseStatus.inProgress;
            }
            if ("on hold".equals(string)) {
                return MedicationDispenseStatus.onHold;
            }
            if ("completed".equals(string)) {
                return MedicationDispenseStatus.completed;
            }
            if ("entered in error".equals(string)) {
                return MedicationDispenseStatus.enteredInError;
            }
            if ("stopped".equals(string)) {
                return MedicationDispenseStatus.stopped;
            }
            throw new Exception("Unknown MedicationDispenseStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == MedicationDispenseStatus.inProgress) {
                return "in progress";
            }
            if (enum_ == MedicationDispenseStatus.onHold) {
                return "on hold";
            }
            if (enum_ == MedicationDispenseStatus.completed) {
                return "completed";
            }
            if (enum_ == MedicationDispenseStatus.enteredInError) {
                return "entered in error";
            }
            if (enum_ == MedicationDispenseStatus.stopped) {
                return "stopped";
            }
            return "?";
        }
    }

    public static enum MedicationDispenseStatus {
        inProgress,
        onHold,
        completed,
        enteredInError,
        stopped,
        Null;


        public static MedicationDispenseStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("in progress".equals(string)) {
                return inProgress;
            }
            if ("on hold".equals(string)) {
                return onHold;
            }
            if ("completed".equals(string)) {
                return completed;
            }
            if ("entered in error".equals(string)) {
                return enteredInError;
            }
            if ("stopped".equals(string)) {
                return stopped;
            }
            throw new Exception("Unknown MedicationDispenseStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case inProgress: {
                    return "in progress";
                }
                case onHold: {
                    return "on hold";
                }
                case completed: {
                    return "completed";
                }
                case enteredInError: {
                    return "entered in error";
                }
                case stopped: {
                    return "stopped";
                }
            }
            return "?";
        }
    }
}

