/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.Duration;
import org.hl7.fhir.instance.model.Encounter;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.Medication;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;

public class MedicationPrescription
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected DateTimeType dateWritten;
    protected Enumeration<MedicationPrescriptionStatus> status;
    protected ResourceReference patient;
    protected Patient patientTarget;
    protected ResourceReference prescriber;
    protected Practitioner prescriberTarget;
    protected ResourceReference encounter;
    protected Encounter encounterTarget;
    protected Type reason;
    protected ResourceReference medication;
    protected Medication medicationTarget;
    protected List<MedicationPrescriptionDosageInstructionComponent> dosageInstruction = new ArrayList<MedicationPrescriptionDosageInstructionComponent>();
    protected MedicationPrescriptionDispenseComponent dispense;
    protected MedicationPrescriptionSubstitutionComponent substitution;
    private static final long serialVersionUID = 1303224135L;

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public DateTimeType getDateWritten() {
        return this.dateWritten;
    }

    public MedicationPrescription setDateWritten(DateTimeType dateTimeType) {
        this.dateWritten = dateTimeType;
        return this;
    }

    public DateAndTime getDateWrittenSimple() {
        return this.dateWritten == null ? null : this.dateWritten.getValue();
    }

    public MedicationPrescription setDateWrittenSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.dateWritten = null;
        } else {
            if (this.dateWritten == null) {
                this.dateWritten = new DateTimeType();
            }
            this.dateWritten.setValue(dateAndTime);
        }
        return this;
    }

    public Enumeration<MedicationPrescriptionStatus> getStatus() {
        return this.status;
    }

    public MedicationPrescription setStatus(Enumeration<MedicationPrescriptionStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public MedicationPrescriptionStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public MedicationPrescription setStatusSimple(MedicationPrescriptionStatus medicationPrescriptionStatus) {
        if (medicationPrescriptionStatus == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration();
            }
            this.status.setValue(medicationPrescriptionStatus);
        }
        return this;
    }

    public ResourceReference getPatient() {
        return this.patient;
    }

    public MedicationPrescription setPatient(ResourceReference resourceReference) {
        this.patient = resourceReference;
        return this;
    }

    public Patient getPatientTarget() {
        return this.patientTarget;
    }

    public MedicationPrescription setPatientTarget(Patient patient) {
        this.patientTarget = patient;
        return this;
    }

    public ResourceReference getPrescriber() {
        return this.prescriber;
    }

    public MedicationPrescription setPrescriber(ResourceReference resourceReference) {
        this.prescriber = resourceReference;
        return this;
    }

    public Practitioner getPrescriberTarget() {
        return this.prescriberTarget;
    }

    public MedicationPrescription setPrescriberTarget(Practitioner practitioner) {
        this.prescriberTarget = practitioner;
        return this;
    }

    public ResourceReference getEncounter() {
        return this.encounter;
    }

    public MedicationPrescription setEncounter(ResourceReference resourceReference) {
        this.encounter = resourceReference;
        return this;
    }

    public Encounter getEncounterTarget() {
        return this.encounterTarget;
    }

    public MedicationPrescription setEncounterTarget(Encounter encounter) {
        this.encounterTarget = encounter;
        return this;
    }

    public Type getReason() {
        return this.reason;
    }

    public MedicationPrescription setReason(Type type) {
        this.reason = type;
        return this;
    }

    public ResourceReference getMedication() {
        return this.medication;
    }

    public MedicationPrescription setMedication(ResourceReference resourceReference) {
        this.medication = resourceReference;
        return this;
    }

    public Medication getMedicationTarget() {
        return this.medicationTarget;
    }

    public MedicationPrescription setMedicationTarget(Medication medication) {
        this.medicationTarget = medication;
        return this;
    }

    public List<MedicationPrescriptionDosageInstructionComponent> getDosageInstruction() {
        return this.dosageInstruction;
    }

    public MedicationPrescriptionDosageInstructionComponent addDosageInstruction() {
        MedicationPrescriptionDosageInstructionComponent medicationPrescriptionDosageInstructionComponent = new MedicationPrescriptionDosageInstructionComponent();
        this.dosageInstruction.add(medicationPrescriptionDosageInstructionComponent);
        return medicationPrescriptionDosageInstructionComponent;
    }

    public MedicationPrescriptionDispenseComponent getDispense() {
        return this.dispense;
    }

    public MedicationPrescription setDispense(MedicationPrescriptionDispenseComponent medicationPrescriptionDispenseComponent) {
        this.dispense = medicationPrescriptionDispenseComponent;
        return this;
    }

    public MedicationPrescriptionSubstitutionComponent getSubstitution() {
        return this.substitution;
    }

    public MedicationPrescription setSubstitution(MedicationPrescriptionSubstitutionComponent medicationPrescriptionSubstitutionComponent) {
        this.substitution = medicationPrescriptionSubstitutionComponent;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "External identifier - one that would be used by another non-FHIR system - for example a re-imbursement system might issue its own id for each prescription that is created.  This is particularly important where FHIR only provides part of an erntire workflow process where records have to be tracked through an entire system.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("dateWritten", "dateTime", "The date (and perhaps time) when the prescription was written.", 0, Integer.MAX_VALUE, this.dateWritten));
        list.add(new Property("status", "code", "A code specifying the state of the order.  Generally this will be active or completed state.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("patient", "Resource(Patient)", "A link to a resource representing the person to whom the medication will be given.", 0, Integer.MAX_VALUE, this.patient));
        list.add(new Property("prescriber", "Resource(Practitioner)", "The healthcare professional responsible for authorizing the prescription.", 0, Integer.MAX_VALUE, this.prescriber));
        list.add(new Property("encounter", "Resource(Encounter)", "A link to a resource that identifies the particular occurrence of contact between patient and health care provider.", 0, Integer.MAX_VALUE, this.encounter));
        list.add(new Property("reason[x]", "CodeableConcept|Resource(Condition)", "Can be the reason or the indication for writing the prescription.", 0, Integer.MAX_VALUE, this.reason));
        list.add(new Property("medication", "Resource(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, Integer.MAX_VALUE, this.medication));
        list.add(new Property("dosageInstruction", "", "Indicates how the medication is to be used by the patient.", 0, Integer.MAX_VALUE, this.dosageInstruction));
        list.add(new Property("dispense", "", "Deals with details of the dispense part of the order.", 0, Integer.MAX_VALUE, this.dispense));
        list.add(new Property("substitution", "", "Indicates whether or not substitution can or should be part of the dispense. In some cases substitution must happen, in other cases substitution must not happen, and in others it does not matter. This block explains the prescriber's intent. If nothing is specified substitution may be done.", 0, Integer.MAX_VALUE, this.substitution));
    }

    public MedicationPrescription copy() {
        MedicationPrescription medicationPrescription = new MedicationPrescription();
        medicationPrescription.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            medicationPrescription.identifier.add(element.copy());
        }
        medicationPrescription.dateWritten = this.dateWritten == null ? null : this.dateWritten.copy();
        medicationPrescription.status = this.status == null ? null : this.status.copy();
        medicationPrescription.patient = this.patient == null ? null : this.patient.copy();
        medicationPrescription.prescriber = this.prescriber == null ? null : this.prescriber.copy();
        medicationPrescription.encounter = this.encounter == null ? null : this.encounter.copy();
        medicationPrescription.reason = this.reason == null ? null : this.reason.copy();
        medicationPrescription.medication = this.medication == null ? null : this.medication.copy();
        medicationPrescription.dosageInstruction = new ArrayList<MedicationPrescriptionDosageInstructionComponent>();
        for (MedicationPrescriptionDosageInstructionComponent medicationPrescriptionDosageInstructionComponent : this.dosageInstruction) {
            medicationPrescription.dosageInstruction.add(medicationPrescriptionDosageInstructionComponent.copy());
        }
        medicationPrescription.dispense = this.dispense == null ? null : this.dispense.copy();
        medicationPrescription.substitution = this.substitution == null ? null : this.substitution.copy();
        return medicationPrescription;
    }

    protected MedicationPrescription typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationPrescription;
    }

    public static class MedicationPrescriptionSubstitutionComponent
    extends BackboneElement {
        protected CodeableConcept type;
        protected CodeableConcept reason;
        private static final long serialVersionUID = 1693602518L;

        public MedicationPrescriptionSubstitutionComponent() {
        }

        public MedicationPrescriptionSubstitutionComponent(CodeableConcept codeableConcept) {
            this.type = codeableConcept;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public MedicationPrescriptionSubstitutionComponent setType(CodeableConcept codeableConcept) {
            this.type = codeableConcept;
            return this;
        }

        public CodeableConcept getReason() {
            return this.reason;
        }

        public MedicationPrescriptionSubstitutionComponent setReason(CodeableConcept codeableConcept) {
            this.reason = codeableConcept;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("type", "CodeableConcept", "A code signifying whether a different drug should be dispensed from what was prescribed.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("reason", "CodeableConcept", "Indicates the reason for the substitution, or why substitution must or must not be performed.", 0, Integer.MAX_VALUE, this.reason));
        }

        public MedicationPrescriptionSubstitutionComponent copy() {
            MedicationPrescriptionSubstitutionComponent medicationPrescriptionSubstitutionComponent = new MedicationPrescriptionSubstitutionComponent();
            medicationPrescriptionSubstitutionComponent.type = this.type == null ? null : this.type.copy();
            medicationPrescriptionSubstitutionComponent.reason = this.reason == null ? null : this.reason.copy();
            return medicationPrescriptionSubstitutionComponent;
        }
    }

    public static class MedicationPrescriptionDispenseComponent
    extends BackboneElement {
        protected ResourceReference medication;
        protected Medication medicationTarget;
        protected Period validityPeriod;
        protected IntegerType numberOfRepeatsAllowed;
        protected Quantity quantity;
        protected Duration expectedSupplyDuration;
        private static final long serialVersionUID = 1342523350L;

        public ResourceReference getMedication() {
            return this.medication;
        }

        public MedicationPrescriptionDispenseComponent setMedication(ResourceReference resourceReference) {
            this.medication = resourceReference;
            return this;
        }

        public Medication getMedicationTarget() {
            return this.medicationTarget;
        }

        public MedicationPrescriptionDispenseComponent setMedicationTarget(Medication medication) {
            this.medicationTarget = medication;
            return this;
        }

        public Period getValidityPeriod() {
            return this.validityPeriod;
        }

        public MedicationPrescriptionDispenseComponent setValidityPeriod(Period period) {
            this.validityPeriod = period;
            return this;
        }

        public IntegerType getNumberOfRepeatsAllowed() {
            return this.numberOfRepeatsAllowed;
        }

        public MedicationPrescriptionDispenseComponent setNumberOfRepeatsAllowed(IntegerType integerType) {
            this.numberOfRepeatsAllowed = integerType;
            return this;
        }

        public int getNumberOfRepeatsAllowedSimple() {
            return this.numberOfRepeatsAllowed == null ? null : Integer.valueOf(this.numberOfRepeatsAllowed.getValue());
        }

        public MedicationPrescriptionDispenseComponent setNumberOfRepeatsAllowedSimple(int n) {
            if (n == -1) {
                this.numberOfRepeatsAllowed = null;
            } else {
                if (this.numberOfRepeatsAllowed == null) {
                    this.numberOfRepeatsAllowed = new IntegerType();
                }
                this.numberOfRepeatsAllowed.setValue(n);
            }
            return this;
        }

        public Quantity getQuantity() {
            return this.quantity;
        }

        public MedicationPrescriptionDispenseComponent setQuantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public Duration getExpectedSupplyDuration() {
            return this.expectedSupplyDuration;
        }

        public MedicationPrescriptionDispenseComponent setExpectedSupplyDuration(Duration duration) {
            this.expectedSupplyDuration = duration;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("medication", "Resource(Medication)", "Identifies the medication that is to be dispensed.  This may be a more specifically defined than the medicationPrescription.medication . This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, Integer.MAX_VALUE, this.medication));
            list.add(new Property("validityPeriod", "Period", "Design Comments: This indicates the validity period of a prescription (stale dating the Prescription) \nIt reflects the prescriber perspective for the validity of the prescription. Dispenses must not be made against the prescription outside of this period. The lower-bound of the Dispensing Window signifies the earliest date that the prescription can be filled for the first time. If an upper-bound is not specified then the Prescription is open-ended or will default to a stale-date based on regulations. \nRationale: Indicates when the Prescription becomes valid, and when it ceases to be a dispensable Prescription.", 0, Integer.MAX_VALUE, this.validityPeriod));
            list.add(new Property("numberOfRepeatsAllowed", "integer", "An integer indicating the number of repeats of the Dispense. \nUsageNotes: For example, the number of times the prescribed quantity is to be supplied including the initial standard fill.", 0, Integer.MAX_VALUE, this.numberOfRepeatsAllowed));
            list.add(new Property("quantity", "Quantity", "The amount that is to be dispensed.", 0, Integer.MAX_VALUE, this.quantity));
            list.add(new Property("expectedSupplyDuration", "Duration", "Identifies the period time over which the supplied product is expected to be used, or the length of time the dispense is expected to last. \nIn some situations, this attribute may be used instead of quantity to identify the amount supplied by how long it is expected to last, rather than the physical quantity issued, e.g. 90 days supply of medication (based on an ordered dosage) When possible, it is always better to specify quantity, as this tends to be more precise. expectedSupplyDuration will always be an estimate that can be influenced by external factors.", 0, Integer.MAX_VALUE, this.expectedSupplyDuration));
        }

        public MedicationPrescriptionDispenseComponent copy() {
            MedicationPrescriptionDispenseComponent medicationPrescriptionDispenseComponent = new MedicationPrescriptionDispenseComponent();
            medicationPrescriptionDispenseComponent.medication = this.medication == null ? null : this.medication.copy();
            medicationPrescriptionDispenseComponent.validityPeriod = this.validityPeriod == null ? null : this.validityPeriod.copy();
            medicationPrescriptionDispenseComponent.numberOfRepeatsAllowed = this.numberOfRepeatsAllowed == null ? null : this.numberOfRepeatsAllowed.copy();
            medicationPrescriptionDispenseComponent.quantity = this.quantity == null ? null : this.quantity.copy();
            medicationPrescriptionDispenseComponent.expectedSupplyDuration = this.expectedSupplyDuration == null ? null : this.expectedSupplyDuration.copy();
            return medicationPrescriptionDispenseComponent;
        }
    }

    public static class MedicationPrescriptionDosageInstructionComponent
    extends BackboneElement {
        protected StringType text;
        protected CodeableConcept additionalInstructions;
        protected Type timing;
        protected Type asNeeded;
        protected CodeableConcept site;
        protected CodeableConcept route;
        protected CodeableConcept method;
        protected Quantity doseQuantity;
        protected Ratio rate;
        protected Ratio maxDosePerPeriod;
        private static final long serialVersionUID = 2050594784L;

        public StringType getText() {
            return this.text;
        }

        public MedicationPrescriptionDosageInstructionComponent setText(StringType stringType) {
            this.text = stringType;
            return this;
        }

        public String getTextSimple() {
            return this.text == null ? null : this.text.getValue();
        }

        public MedicationPrescriptionDosageInstructionComponent setTextSimple(String string) {
            if (string == null) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(string);
            }
            return this;
        }

        public CodeableConcept getAdditionalInstructions() {
            return this.additionalInstructions;
        }

        public MedicationPrescriptionDosageInstructionComponent setAdditionalInstructions(CodeableConcept codeableConcept) {
            this.additionalInstructions = codeableConcept;
            return this;
        }

        public Type getTiming() {
            return this.timing;
        }

        public MedicationPrescriptionDosageInstructionComponent setTiming(Type type) {
            this.timing = type;
            return this;
        }

        public Type getAsNeeded() {
            return this.asNeeded;
        }

        public MedicationPrescriptionDosageInstructionComponent setAsNeeded(Type type) {
            this.asNeeded = type;
            return this;
        }

        public CodeableConcept getSite() {
            return this.site;
        }

        public MedicationPrescriptionDosageInstructionComponent setSite(CodeableConcept codeableConcept) {
            this.site = codeableConcept;
            return this;
        }

        public CodeableConcept getRoute() {
            return this.route;
        }

        public MedicationPrescriptionDosageInstructionComponent setRoute(CodeableConcept codeableConcept) {
            this.route = codeableConcept;
            return this;
        }

        public CodeableConcept getMethod() {
            return this.method;
        }

        public MedicationPrescriptionDosageInstructionComponent setMethod(CodeableConcept codeableConcept) {
            this.method = codeableConcept;
            return this;
        }

        public Quantity getDoseQuantity() {
            return this.doseQuantity;
        }

        public MedicationPrescriptionDosageInstructionComponent setDoseQuantity(Quantity quantity) {
            this.doseQuantity = quantity;
            return this;
        }

        public Ratio getRate() {
            return this.rate;
        }

        public MedicationPrescriptionDosageInstructionComponent setRate(Ratio ratio) {
            this.rate = ratio;
            return this;
        }

        public Ratio getMaxDosePerPeriod() {
            return this.maxDosePerPeriod;
        }

        public MedicationPrescriptionDosageInstructionComponent setMaxDosePerPeriod(Ratio ratio) {
            this.maxDosePerPeriod = ratio;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("text", "string", "Free text dosage instructions for cases where the instructions are too complex to code.", 0, Integer.MAX_VALUE, this.text));
            list.add(new Property("additionalInstructions", "CodeableConcept", "Additional instructions such as 'Swallow with plenty of water' which may or may not be coded.", 0, Integer.MAX_VALUE, this.additionalInstructions));
            list.add(new Property("timing[x]", "dateTime|Period|Schedule", "The timing schedule for giving the medication to the patient.  The Schedule data type allows many different expressions, for example.  'Every  8 hours'; 'Three times a day'; '1/2 an hour before breakfast for 10 days from 23-Dec 2011:';  '15 Oct 2013, 17 Oct 2013 and 1 Nov 2013'.", 0, Integer.MAX_VALUE, this.timing));
            list.add(new Property("asNeeded[x]", "boolean|CodeableConcept", "If set to true or if specified as a CodeableConcept, indicates that the medication is only taken when needed within the specified schedule rather than at every scheduled dose.  If a CodeableConcept is present, it indicates the pre-condition for taking the Medication.", 0, Integer.MAX_VALUE, this.asNeeded));
            list.add(new Property("site", "CodeableConcept", "A coded specification of the anatomic site where the medication first enters the body.", 0, Integer.MAX_VALUE, this.site));
            list.add(new Property("route", "CodeableConcept", "A code specifying the route or physiological path of administration of a therapeutic agent into or onto a patient.", 0, Integer.MAX_VALUE, this.route));
            list.add(new Property("method", "CodeableConcept", "A coded value indicating the method by which the medication is introduced into or onto the body. Most commonly used for injections.  Examples:  Slow Push; Deep IV.\n\nTerminologies used often pre-coordinate this term with the route and or form of administration.", 0, Integer.MAX_VALUE, this.method));
            list.add(new Property("doseQuantity", "Quantity", "The amount of therapeutic or other substance given at one administration event.", 0, Integer.MAX_VALUE, this.doseQuantity));
            list.add(new Property("rate", "Ratio", "Identifies the speed with which the substance is introduced into the subject. Typically the rate for an infusion. 200ml in 2 hours.", 0, Integer.MAX_VALUE, this.rate));
            list.add(new Property("maxDosePerPeriod", "Ratio", "The maximum total quantity of a therapeutic substance that may be administered to a subject over the period of time. E.g. 1000mg in 24 hours.", 0, Integer.MAX_VALUE, this.maxDosePerPeriod));
        }

        public MedicationPrescriptionDosageInstructionComponent copy() {
            MedicationPrescriptionDosageInstructionComponent medicationPrescriptionDosageInstructionComponent = new MedicationPrescriptionDosageInstructionComponent();
            medicationPrescriptionDosageInstructionComponent.text = this.text == null ? null : this.text.copy();
            medicationPrescriptionDosageInstructionComponent.additionalInstructions = this.additionalInstructions == null ? null : this.additionalInstructions.copy();
            medicationPrescriptionDosageInstructionComponent.timing = this.timing == null ? null : this.timing.copy();
            medicationPrescriptionDosageInstructionComponent.asNeeded = this.asNeeded == null ? null : this.asNeeded.copy();
            medicationPrescriptionDosageInstructionComponent.site = this.site == null ? null : this.site.copy();
            medicationPrescriptionDosageInstructionComponent.route = this.route == null ? null : this.route.copy();
            medicationPrescriptionDosageInstructionComponent.method = this.method == null ? null : this.method.copy();
            medicationPrescriptionDosageInstructionComponent.doseQuantity = this.doseQuantity == null ? null : this.doseQuantity.copy();
            medicationPrescriptionDosageInstructionComponent.rate = this.rate == null ? null : this.rate.copy();
            medicationPrescriptionDosageInstructionComponent.maxDosePerPeriod = this.maxDosePerPeriod == null ? null : this.maxDosePerPeriod.copy();
            return medicationPrescriptionDosageInstructionComponent;
        }
    }

    public static class MedicationPrescriptionStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("active".equals(string)) {
                return MedicationPrescriptionStatus.active;
            }
            if ("on hold".equals(string)) {
                return MedicationPrescriptionStatus.onHold;
            }
            if ("completed".equals(string)) {
                return MedicationPrescriptionStatus.completed;
            }
            if ("entered in error".equals(string)) {
                return MedicationPrescriptionStatus.enteredInError;
            }
            if ("stopped".equals(string)) {
                return MedicationPrescriptionStatus.stopped;
            }
            if ("superceded".equals(string)) {
                return MedicationPrescriptionStatus.superceded;
            }
            throw new Exception("Unknown MedicationPrescriptionStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == MedicationPrescriptionStatus.active) {
                return "active";
            }
            if (enum_ == MedicationPrescriptionStatus.onHold) {
                return "on hold";
            }
            if (enum_ == MedicationPrescriptionStatus.completed) {
                return "completed";
            }
            if (enum_ == MedicationPrescriptionStatus.enteredInError) {
                return "entered in error";
            }
            if (enum_ == MedicationPrescriptionStatus.stopped) {
                return "stopped";
            }
            if (enum_ == MedicationPrescriptionStatus.superceded) {
                return "superceded";
            }
            return "?";
        }
    }

    public static enum MedicationPrescriptionStatus {
        active,
        onHold,
        completed,
        enteredInError,
        stopped,
        superceded,
        Null;


        public static MedicationPrescriptionStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("active".equals(string)) {
                return active;
            }
            if ("on hold".equals(string)) {
                return onHold;
            }
            if ("completed".equals(string)) {
                return completed;
            }
            if ("entered in error".equals(string)) {
                return enteredInError;
            }
            if ("stopped".equals(string)) {
                return stopped;
            }
            if ("superceded".equals(string)) {
                return superceded;
            }
            throw new Exception("Unknown MedicationPrescriptionStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case active: {
                    return "active";
                }
                case onHold: {
                    return "on hold";
                }
                case completed: {
                    return "completed";
                }
                case enteredInError: {
                    return "entered in error";
                }
                case stopped: {
                    return "stopped";
                }
                case superceded: {
                    return "superceded";
                }
            }
            return "?";
        }
    }
}

