/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Device;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Medication;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.Schedule;
import org.hl7.fhir.instance.model.Type;

public class MedicationStatement
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected ResourceReference patient;
    protected Patient patientTarget;
    protected BooleanType wasNotGiven;
    protected List<CodeableConcept> reasonNotGiven = new ArrayList<CodeableConcept>();
    protected Period whenGiven;
    protected ResourceReference medication;
    protected Medication medicationTarget;
    protected List<ResourceReference> device = new ArrayList<ResourceReference>();
    protected List<Device> deviceTarget = new ArrayList<Device>();
    protected List<MedicationStatementDosageComponent> dosage = new ArrayList<MedicationStatementDosageComponent>();
    private static final long serialVersionUID = 874621239L;

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public ResourceReference getPatient() {
        return this.patient;
    }

    public MedicationStatement setPatient(ResourceReference resourceReference) {
        this.patient = resourceReference;
        return this;
    }

    public Patient getPatientTarget() {
        return this.patientTarget;
    }

    public MedicationStatement setPatientTarget(Patient patient) {
        this.patientTarget = patient;
        return this;
    }

    public BooleanType getWasNotGiven() {
        return this.wasNotGiven;
    }

    public MedicationStatement setWasNotGiven(BooleanType booleanType) {
        this.wasNotGiven = booleanType;
        return this;
    }

    public boolean getWasNotGivenSimple() {
        return this.wasNotGiven == null ? false : this.wasNotGiven.getValue();
    }

    public MedicationStatement setWasNotGivenSimple(boolean bl) {
        if (!bl) {
            this.wasNotGiven = null;
        } else {
            if (this.wasNotGiven == null) {
                this.wasNotGiven = new BooleanType();
            }
            this.wasNotGiven.setValue(bl);
        }
        return this;
    }

    public List<CodeableConcept> getReasonNotGiven() {
        return this.reasonNotGiven;
    }

    public CodeableConcept addReasonNotGiven() {
        CodeableConcept codeableConcept = new CodeableConcept();
        this.reasonNotGiven.add(codeableConcept);
        return codeableConcept;
    }

    public Period getWhenGiven() {
        return this.whenGiven;
    }

    public MedicationStatement setWhenGiven(Period period) {
        this.whenGiven = period;
        return this;
    }

    public ResourceReference getMedication() {
        return this.medication;
    }

    public MedicationStatement setMedication(ResourceReference resourceReference) {
        this.medication = resourceReference;
        return this;
    }

    public Medication getMedicationTarget() {
        return this.medicationTarget;
    }

    public MedicationStatement setMedicationTarget(Medication medication) {
        this.medicationTarget = medication;
        return this;
    }

    public List<ResourceReference> getDevice() {
        return this.device;
    }

    public ResourceReference addDevice() {
        ResourceReference resourceReference = new ResourceReference();
        this.device.add(resourceReference);
        return resourceReference;
    }

    public List<Device> getDeviceTarget() {
        return this.deviceTarget;
    }

    public Device addDeviceTarget() {
        Device device = new Device();
        this.deviceTarget.add(device);
        return device;
    }

    public List<MedicationStatementDosageComponent> getDosage() {
        return this.dosage;
    }

    public MedicationStatementDosageComponent addDosage() {
        MedicationStatementDosageComponent medicationStatementDosageComponent = new MedicationStatementDosageComponent();
        this.dosage.add(medicationStatementDosageComponent);
        return medicationStatementDosageComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "External identifier - FHIR will generate its own internal IDs (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("patient", "Resource(Patient)", "The person or animal who is /was taking the medication.", 0, Integer.MAX_VALUE, this.patient));
        list.add(new Property("wasNotGiven", "boolean", "Set this to true if the record is saying that the medication was NOT taken.", 0, Integer.MAX_VALUE, this.wasNotGiven));
        list.add(new Property("reasonNotGiven", "CodeableConcept", "A code indicating why the medication was not taken.", 0, Integer.MAX_VALUE, this.reasonNotGiven));
        list.add(new Property("whenGiven", "Period", "The interval of time during which it is being asserted that the patient was taking the medication.", 0, Integer.MAX_VALUE, this.whenGiven));
        list.add(new Property("medication", "Resource(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, Integer.MAX_VALUE, this.medication));
        list.add(new Property("device", "Resource(Device)", "An identifier or a link to a resource that identifies a device used in administering the medication to the patient.", 0, Integer.MAX_VALUE, this.device));
        list.add(new Property("dosage", "", "Indicates how the medication is/was used by the patient.", 0, Integer.MAX_VALUE, this.dosage));
    }

    public MedicationStatement copy() {
        MedicationStatement medicationStatement = new MedicationStatement();
        medicationStatement.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            medicationStatement.identifier.add(element.copy());
        }
        medicationStatement.patient = this.patient == null ? null : this.patient.copy();
        medicationStatement.wasNotGiven = this.wasNotGiven == null ? null : this.wasNotGiven.copy();
        medicationStatement.reasonNotGiven = new ArrayList<CodeableConcept>();
        for (CodeableConcept codeableConcept : this.reasonNotGiven) {
            medicationStatement.reasonNotGiven.add(codeableConcept.copy());
        }
        medicationStatement.whenGiven = this.whenGiven == null ? null : this.whenGiven.copy();
        medicationStatement.medication = this.medication == null ? null : this.medication.copy();
        medicationStatement.device = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.device) {
            medicationStatement.device.add(resourceReference.copy());
        }
        medicationStatement.dosage = new ArrayList<MedicationStatementDosageComponent>();
        for (MedicationStatementDosageComponent medicationStatementDosageComponent : this.dosage) {
            medicationStatement.dosage.add(medicationStatementDosageComponent.copy());
        }
        return medicationStatement;
    }

    protected MedicationStatement typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationStatement;
    }

    public static class MedicationStatementDosageComponent
    extends BackboneElement {
        protected Schedule timing;
        protected Type asNeeded;
        protected CodeableConcept site;
        protected CodeableConcept route;
        protected CodeableConcept method;
        protected Quantity quantity;
        protected Ratio rate;
        protected Ratio maxDosePerPeriod;
        private static final long serialVersionUID = -2103892057L;

        public Schedule getTiming() {
            return this.timing;
        }

        public MedicationStatementDosageComponent setTiming(Schedule schedule) {
            this.timing = schedule;
            return this;
        }

        public Type getAsNeeded() {
            return this.asNeeded;
        }

        public MedicationStatementDosageComponent setAsNeeded(Type type) {
            this.asNeeded = type;
            return this;
        }

        public CodeableConcept getSite() {
            return this.site;
        }

        public MedicationStatementDosageComponent setSite(CodeableConcept codeableConcept) {
            this.site = codeableConcept;
            return this;
        }

        public CodeableConcept getRoute() {
            return this.route;
        }

        public MedicationStatementDosageComponent setRoute(CodeableConcept codeableConcept) {
            this.route = codeableConcept;
            return this;
        }

        public CodeableConcept getMethod() {
            return this.method;
        }

        public MedicationStatementDosageComponent setMethod(CodeableConcept codeableConcept) {
            this.method = codeableConcept;
            return this;
        }

        public Quantity getQuantity() {
            return this.quantity;
        }

        public MedicationStatementDosageComponent setQuantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public Ratio getRate() {
            return this.rate;
        }

        public MedicationStatementDosageComponent setRate(Ratio ratio) {
            this.rate = ratio;
            return this;
        }

        public Ratio getMaxDosePerPeriod() {
            return this.maxDosePerPeriod;
        }

        public MedicationStatementDosageComponent setMaxDosePerPeriod(Ratio ratio) {
            this.maxDosePerPeriod = ratio;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("timing", "Schedule", "The timing schedule for giving the medication to the patient.  The Schedule data type allows many different expressions, for example.  'Every  8 hours'; 'Three times a day'; '1/2 an hour before breakfast for 10 days from 23-Dec 2011:';  '15 Oct 2013, 17 Oct 2013 and 1 Nov 2013'.", 0, Integer.MAX_VALUE, this.timing));
            list.add(new Property("asNeeded[x]", "boolean|CodeableConcept", "If set to true or if specified as a CodeableConcept, indicates that the medication is only taken when needed within the specified schedule rather than at every scheduled dose.  If a CodeableConcept is present, it indicates the pre-condition for taking the Medication.", 0, Integer.MAX_VALUE, this.asNeeded));
            list.add(new Property("site", "CodeableConcept", "A coded specification of the anatomic site where the medication first enters the body.", 0, Integer.MAX_VALUE, this.site));
            list.add(new Property("route", "CodeableConcept", "A code specifying the route or physiological path of administration of a therapeutic agent into or onto a subject.", 0, Integer.MAX_VALUE, this.route));
            list.add(new Property("method", "CodeableConcept", "A coded value indicating the method by which the medication is introduced into or onto the body. Most commonly used for injections.  Examples:  Slow Push; Deep IV.\n\nTerminologies used often pre-coordinate this term with the route and or form of administration.", 0, Integer.MAX_VALUE, this.method));
            list.add(new Property("quantity", "Quantity", "The amount of therapeutic or other substance given at one administration event.", 0, Integer.MAX_VALUE, this.quantity));
            list.add(new Property("rate", "Ratio", "Identifies the speed with which the substance is introduced into the subject. Typically the rate for an infusion. 200ml in 2 hours.", 0, Integer.MAX_VALUE, this.rate));
            list.add(new Property("maxDosePerPeriod", "Ratio", "The maximum total quantity of a therapeutic substance that may be administered to a subject over the period of time. E.g. 1000mg in 24 hours.", 0, Integer.MAX_VALUE, this.maxDosePerPeriod));
        }

        public MedicationStatementDosageComponent copy() {
            MedicationStatementDosageComponent medicationStatementDosageComponent = new MedicationStatementDosageComponent();
            medicationStatementDosageComponent.timing = this.timing == null ? null : this.timing.copy();
            medicationStatementDosageComponent.asNeeded = this.asNeeded == null ? null : this.asNeeded.copy();
            medicationStatementDosageComponent.site = this.site == null ? null : this.site.copy();
            medicationStatementDosageComponent.route = this.route == null ? null : this.route.copy();
            medicationStatementDosageComponent.method = this.method == null ? null : this.method.copy();
            medicationStatementDosageComponent.quantity = this.quantity == null ? null : this.quantity.copy();
            medicationStatementDosageComponent.rate = this.rate == null ? null : this.rate.copy();
            medicationStatementDosageComponent.maxDosePerPeriod = this.maxDosePerPeriod == null ? null : this.maxDosePerPeriod.copy();
            return medicationStatementDosageComponent;
        }
    }
}

