/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.Device;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.UriType;

public class MessageHeader
extends Resource {
    protected IdType identifier;
    protected InstantType timestamp;
    protected Coding event;
    protected MessageHeaderResponseComponent response;
    protected MessageSourceComponent source;
    protected List<MessageDestinationComponent> destination = new ArrayList<MessageDestinationComponent>();
    protected ResourceReference enterer;
    protected Practitioner entererTarget;
    protected ResourceReference author;
    protected Practitioner authorTarget;
    protected ResourceReference receiver;
    protected Resource receiverTarget;
    protected ResourceReference responsible;
    protected Resource responsibleTarget;
    protected CodeableConcept reason;
    protected List<ResourceReference> data = new ArrayList<ResourceReference>();
    protected List<Resource> dataTarget = new ArrayList<Resource>();
    private static final long serialVersionUID = 75462059L;

    public MessageHeader() {
    }

    public MessageHeader(IdType idType, InstantType instantType, Coding coding, MessageSourceComponent messageSourceComponent) {
        this.identifier = idType;
        this.timestamp = instantType;
        this.event = coding;
        this.source = messageSourceComponent;
    }

    public IdType getIdentifier() {
        return this.identifier;
    }

    public MessageHeader setIdentifier(IdType idType) {
        this.identifier = idType;
        return this;
    }

    public String getIdentifierSimple() {
        return this.identifier == null ? null : this.identifier.getValue();
    }

    public MessageHeader setIdentifierSimple(String string) {
        if (this.identifier == null) {
            this.identifier = new IdType();
        }
        this.identifier.setValue(string);
        return this;
    }

    public InstantType getTimestamp() {
        return this.timestamp;
    }

    public MessageHeader setTimestamp(InstantType instantType) {
        this.timestamp = instantType;
        return this;
    }

    public DateAndTime getTimestampSimple() {
        return this.timestamp == null ? null : this.timestamp.getValue();
    }

    public MessageHeader setTimestampSimple(DateAndTime dateAndTime) {
        if (this.timestamp == null) {
            this.timestamp = new InstantType();
        }
        this.timestamp.setValue(dateAndTime);
        return this;
    }

    public Coding getEvent() {
        return this.event;
    }

    public MessageHeader setEvent(Coding coding) {
        this.event = coding;
        return this;
    }

    public MessageHeaderResponseComponent getResponse() {
        return this.response;
    }

    public MessageHeader setResponse(MessageHeaderResponseComponent messageHeaderResponseComponent) {
        this.response = messageHeaderResponseComponent;
        return this;
    }

    public MessageSourceComponent getSource() {
        return this.source;
    }

    public MessageHeader setSource(MessageSourceComponent messageSourceComponent) {
        this.source = messageSourceComponent;
        return this;
    }

    public List<MessageDestinationComponent> getDestination() {
        return this.destination;
    }

    public MessageDestinationComponent addDestination() {
        MessageDestinationComponent messageDestinationComponent = new MessageDestinationComponent();
        this.destination.add(messageDestinationComponent);
        return messageDestinationComponent;
    }

    public ResourceReference getEnterer() {
        return this.enterer;
    }

    public MessageHeader setEnterer(ResourceReference resourceReference) {
        this.enterer = resourceReference;
        return this;
    }

    public Practitioner getEntererTarget() {
        return this.entererTarget;
    }

    public MessageHeader setEntererTarget(Practitioner practitioner) {
        this.entererTarget = practitioner;
        return this;
    }

    public ResourceReference getAuthor() {
        return this.author;
    }

    public MessageHeader setAuthor(ResourceReference resourceReference) {
        this.author = resourceReference;
        return this;
    }

    public Practitioner getAuthorTarget() {
        return this.authorTarget;
    }

    public MessageHeader setAuthorTarget(Practitioner practitioner) {
        this.authorTarget = practitioner;
        return this;
    }

    public ResourceReference getReceiver() {
        return this.receiver;
    }

    public MessageHeader setReceiver(ResourceReference resourceReference) {
        this.receiver = resourceReference;
        return this;
    }

    public Resource getReceiverTarget() {
        return this.receiverTarget;
    }

    public MessageHeader setReceiverTarget(Resource resource) {
        this.receiverTarget = resource;
        return this;
    }

    public ResourceReference getResponsible() {
        return this.responsible;
    }

    public MessageHeader setResponsible(ResourceReference resourceReference) {
        this.responsible = resourceReference;
        return this;
    }

    public Resource getResponsibleTarget() {
        return this.responsibleTarget;
    }

    public MessageHeader setResponsibleTarget(Resource resource) {
        this.responsibleTarget = resource;
        return this;
    }

    public CodeableConcept getReason() {
        return this.reason;
    }

    public MessageHeader setReason(CodeableConcept codeableConcept) {
        this.reason = codeableConcept;
        return this;
    }

    public List<ResourceReference> getData() {
        return this.data;
    }

    public ResourceReference addData() {
        ResourceReference resourceReference = new ResourceReference();
        this.data.add(resourceReference);
        return resourceReference;
    }

    public List<Resource> getDataTarget() {
        return this.dataTarget;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "id", "The identifier of this message.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("timestamp", "instant", "The time that the message was sent.", 0, Integer.MAX_VALUE, this.timestamp));
        list.add(new Property("event", "Coding", "Code that identifies the event this message represents and connects it with it's definition. Events defined as part of the FHIR specification have the system value 'http://hl7.org/fhir/message-type'.", 0, Integer.MAX_VALUE, this.event));
        list.add(new Property("response", "", "Information about the message that this message is a response to.  Only present if this message is a response.", 0, Integer.MAX_VALUE, this.response));
        list.add(new Property("source", "", "The source application from which this message originated.", 0, Integer.MAX_VALUE, this.source));
        list.add(new Property("destination", "", "The destination application which the message is intended for.", 0, Integer.MAX_VALUE, this.destination));
        list.add(new Property("enterer", "Resource(Practitioner)", "The person or device that performed the data entry leading to this message. Where there is more than one candidate, pick the most proximal to the message. Can provide other enterers in extensions.", 0, Integer.MAX_VALUE, this.enterer));
        list.add(new Property("author", "Resource(Practitioner)", "The logical author of the message - the person or device that decided the described event should happen. Where there is more than one candidate, pick the most proximal to the MessageHeader. Can provide other authors in extensions.", 0, Integer.MAX_VALUE, this.author));
        list.add(new Property("receiver", "Resource(Practitioner|Organization)", "Allows data conveyed by a message to be addressed to a particular person or department when routing to a specific application isn't sufficient.", 0, Integer.MAX_VALUE, this.receiver));
        list.add(new Property("responsible", "Resource(Practitioner|Organization)", "The person or organization that accepts overall responsibility for the contents of the message. The implication is that the message event happened under the policies of the responsible party.", 0, Integer.MAX_VALUE, this.responsible));
        list.add(new Property("reason", "CodeableConcept", "Coded indication of the cause for the event - indicates  a reason for the occurance of the event that is a focus of this message.", 0, Integer.MAX_VALUE, this.reason));
        list.add(new Property("data", "Resource(Any)", "The actual data of the message - a reference to the root/focus class of the event.", 0, Integer.MAX_VALUE, this.data));
    }

    public MessageHeader copy() {
        MessageHeader messageHeader = new MessageHeader();
        messageHeader.identifier = this.identifier == null ? null : this.identifier.copy();
        messageHeader.timestamp = this.timestamp == null ? null : this.timestamp.copy();
        messageHeader.event = this.event == null ? null : this.event.copy();
        messageHeader.response = this.response == null ? null : this.response.copy();
        messageHeader.source = this.source == null ? null : this.source.copy();
        messageHeader.destination = new ArrayList<MessageDestinationComponent>();
        for (MessageDestinationComponent element : this.destination) {
            messageHeader.destination.add(element.copy());
        }
        messageHeader.enterer = this.enterer == null ? null : this.enterer.copy();
        messageHeader.author = this.author == null ? null : this.author.copy();
        messageHeader.receiver = this.receiver == null ? null : this.receiver.copy();
        messageHeader.responsible = this.responsible == null ? null : this.responsible.copy();
        messageHeader.reason = this.reason == null ? null : this.reason.copy();
        messageHeader.data = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.data) {
            messageHeader.data.add(resourceReference.copy());
        }
        return messageHeader;
    }

    protected MessageHeader typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MessageHeader;
    }

    public static class MessageDestinationComponent
    extends BackboneElement {
        protected StringType name;
        protected ResourceReference target;
        protected Device targetTarget;
        protected UriType endpoint;
        private static final long serialVersionUID = 1209429009L;

        public MessageDestinationComponent() {
        }

        public MessageDestinationComponent(UriType uriType) {
            this.endpoint = uriType;
        }

        public StringType getName() {
            return this.name;
        }

        public MessageDestinationComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public MessageDestinationComponent setNameSimple(String string) {
            if (string == null) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(string);
            }
            return this;
        }

        public ResourceReference getTarget() {
            return this.target;
        }

        public MessageDestinationComponent setTarget(ResourceReference resourceReference) {
            this.target = resourceReference;
            return this;
        }

        public Device getTargetTarget() {
            return this.targetTarget;
        }

        public MessageDestinationComponent setTargetTarget(Device device) {
            this.targetTarget = device;
            return this;
        }

        public UriType getEndpoint() {
            return this.endpoint;
        }

        public MessageDestinationComponent setEndpoint(UriType uriType) {
            this.endpoint = uriType;
            return this;
        }

        public String getEndpointSimple() {
            return this.endpoint == null ? null : this.endpoint.getValue();
        }

        public MessageDestinationComponent setEndpointSimple(String string) {
            if (this.endpoint == null) {
                this.endpoint = new UriType();
            }
            this.endpoint.setValue(string);
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("name", "string", "Human-readable name for the source system.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("target", "Resource(Device)", "Identifies the target end system in situations where the initial message transmission is to an intermediary system.", 0, Integer.MAX_VALUE, this.target));
            list.add(new Property("endpoint", "uri", "Indicates where the message should be routed to.", 0, Integer.MAX_VALUE, this.endpoint));
        }

        public MessageDestinationComponent copy() {
            MessageDestinationComponent messageDestinationComponent = new MessageDestinationComponent();
            messageDestinationComponent.name = this.name == null ? null : this.name.copy();
            messageDestinationComponent.target = this.target == null ? null : this.target.copy();
            messageDestinationComponent.endpoint = this.endpoint == null ? null : this.endpoint.copy();
            return messageDestinationComponent;
        }
    }

    public static class MessageSourceComponent
    extends BackboneElement {
        protected StringType name;
        protected StringType software;
        protected StringType version;
        protected Contact contact;
        protected UriType endpoint;
        private static final long serialVersionUID = 2095309634L;

        public MessageSourceComponent() {
        }

        public MessageSourceComponent(StringType stringType, UriType uriType) {
            this.software = stringType;
            this.endpoint = uriType;
        }

        public StringType getName() {
            return this.name;
        }

        public MessageSourceComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public MessageSourceComponent setNameSimple(String string) {
            if (string == null) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(string);
            }
            return this;
        }

        public StringType getSoftware() {
            return this.software;
        }

        public MessageSourceComponent setSoftware(StringType stringType) {
            this.software = stringType;
            return this;
        }

        public String getSoftwareSimple() {
            return this.software == null ? null : this.software.getValue();
        }

        public MessageSourceComponent setSoftwareSimple(String string) {
            if (this.software == null) {
                this.software = new StringType();
            }
            this.software.setValue(string);
            return this;
        }

        public StringType getVersion() {
            return this.version;
        }

        public MessageSourceComponent setVersion(StringType stringType) {
            this.version = stringType;
            return this;
        }

        public String getVersionSimple() {
            return this.version == null ? null : this.version.getValue();
        }

        public MessageSourceComponent setVersionSimple(String string) {
            if (string == null) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(string);
            }
            return this;
        }

        public Contact getContact() {
            return this.contact;
        }

        public MessageSourceComponent setContact(Contact contact) {
            this.contact = contact;
            return this;
        }

        public UriType getEndpoint() {
            return this.endpoint;
        }

        public MessageSourceComponent setEndpoint(UriType uriType) {
            this.endpoint = uriType;
            return this;
        }

        public String getEndpointSimple() {
            return this.endpoint == null ? null : this.endpoint.getValue();
        }

        public MessageSourceComponent setEndpointSimple(String string) {
            if (this.endpoint == null) {
                this.endpoint = new UriType();
            }
            this.endpoint.setValue(string);
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("name", "string", "Human-readable name for the target system.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("software", "string", "May include configuration or other information useful in debugging.", 0, Integer.MAX_VALUE, this.software));
            list.add(new Property("version", "string", "Can convey versions of multiple systems in situations where a message passes through multiple hands.", 0, Integer.MAX_VALUE, this.version));
            list.add(new Property("contact", "Contact", "An e-mail, phone, website or other contact point to use to resolve issues with message communications.", 0, Integer.MAX_VALUE, this.contact));
            list.add(new Property("endpoint", "uri", "Identifies the routing target to send acknowledgements to.", 0, Integer.MAX_VALUE, this.endpoint));
        }

        public MessageSourceComponent copy() {
            MessageSourceComponent messageSourceComponent = new MessageSourceComponent();
            messageSourceComponent.name = this.name == null ? null : this.name.copy();
            messageSourceComponent.software = this.software == null ? null : this.software.copy();
            messageSourceComponent.version = this.version == null ? null : this.version.copy();
            messageSourceComponent.contact = this.contact == null ? null : this.contact.copy();
            messageSourceComponent.endpoint = this.endpoint == null ? null : this.endpoint.copy();
            return messageSourceComponent;
        }
    }

    public static class MessageHeaderResponseComponent
    extends BackboneElement {
        protected IdType identifier;
        protected Enumeration<ResponseCode> code;
        protected ResourceReference details;
        protected OperationOutcome detailsTarget;
        private static final long serialVersionUID = -1631054369L;

        public MessageHeaderResponseComponent() {
        }

        public MessageHeaderResponseComponent(IdType idType, Enumeration<ResponseCode> enumeration) {
            this.identifier = idType;
            this.code = enumeration;
        }

        public IdType getIdentifier() {
            return this.identifier;
        }

        public MessageHeaderResponseComponent setIdentifier(IdType idType) {
            this.identifier = idType;
            return this;
        }

        public String getIdentifierSimple() {
            return this.identifier == null ? null : this.identifier.getValue();
        }

        public MessageHeaderResponseComponent setIdentifierSimple(String string) {
            if (this.identifier == null) {
                this.identifier = new IdType();
            }
            this.identifier.setValue(string);
            return this;
        }

        public Enumeration<ResponseCode> getCode() {
            return this.code;
        }

        public MessageHeaderResponseComponent setCode(Enumeration<ResponseCode> enumeration) {
            this.code = enumeration;
            return this;
        }

        public ResponseCode getCodeSimple() {
            return this.code == null ? null : this.code.getValue();
        }

        public MessageHeaderResponseComponent setCodeSimple(ResponseCode responseCode) {
            if (this.code == null) {
                this.code = new Enumeration();
            }
            this.code.setValue(responseCode);
            return this;
        }

        public ResourceReference getDetails() {
            return this.details;
        }

        public MessageHeaderResponseComponent setDetails(ResourceReference resourceReference) {
            this.details = resourceReference;
            return this;
        }

        public OperationOutcome getDetailsTarget() {
            return this.detailsTarget;
        }

        public MessageHeaderResponseComponent setDetailsTarget(OperationOutcome operationOutcome) {
            this.detailsTarget = operationOutcome;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("identifier", "id", "The id of the message that this message is a response to.", 0, Integer.MAX_VALUE, this.identifier));
            list.add(new Property("code", "code", "Code that identifies the type of response to the message - whether it was successful or not, and whether it should be resent or not.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("details", "Resource(OperationOutcome)", "Full details of any issues found in the message.", 0, Integer.MAX_VALUE, this.details));
        }

        public MessageHeaderResponseComponent copy() {
            MessageHeaderResponseComponent messageHeaderResponseComponent = new MessageHeaderResponseComponent();
            messageHeaderResponseComponent.identifier = this.identifier == null ? null : this.identifier.copy();
            messageHeaderResponseComponent.code = this.code == null ? null : this.code.copy();
            messageHeaderResponseComponent.details = this.details == null ? null : this.details.copy();
            return messageHeaderResponseComponent;
        }
    }

    public static class ResponseCodeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("ok".equals(string)) {
                return ResponseCode.ok;
            }
            if ("transient-error".equals(string)) {
                return ResponseCode.transienterror;
            }
            if ("fatal-error".equals(string)) {
                return ResponseCode.fatalerror;
            }
            throw new Exception("Unknown ResponseCode code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ResponseCode.ok) {
                return "ok";
            }
            if (enum_ == ResponseCode.transienterror) {
                return "transient-error";
            }
            if (enum_ == ResponseCode.fatalerror) {
                return "fatal-error";
            }
            return "?";
        }
    }

    public static enum ResponseCode {
        ok,
        transienterror,
        fatalerror,
        Null;


        public static ResponseCode fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("ok".equals(string)) {
                return ok;
            }
            if ("transient-error".equals(string)) {
                return transienterror;
            }
            if ("fatal-error".equals(string)) {
                return fatalerror;
            }
            throw new Exception("Unknown ResponseCode code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case ok: {
                    return "ok";
                }
                case transienterror: {
                    return "transient-error";
                }
                case fatalerror: {
                    return "fatal-error";
                }
            }
            return "?";
        }
    }
}

