/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.List;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class Narrative
extends Element {
    protected Enumeration<NarrativeStatus> status;
    protected XhtmlNode div;
    private static final long serialVersionUID = 1463852859L;

    public Narrative() {
    }

    public Narrative(Enumeration<NarrativeStatus> enumeration, XhtmlNode xhtmlNode) {
        this.status = enumeration;
        this.div = xhtmlNode;
    }

    public Enumeration<NarrativeStatus> getStatus() {
        return this.status;
    }

    public Narrative setStatus(Enumeration<NarrativeStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public NarrativeStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public Narrative setStatusSimple(NarrativeStatus narrativeStatus) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(narrativeStatus);
        return this;
    }

    public XhtmlNode getDiv() {
        return this.div;
    }

    public Narrative setDiv(XhtmlNode xhtmlNode) {
        this.div = xhtmlNode;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("status", "code", "The status of the narrative - whether it's entirely generated (from just the defined data or the extensions too), or whether a human authored it and it may contain additional data.", 0, Integer.MAX_VALUE, this.status));
    }

    public Narrative copy() {
        Narrative narrative = new Narrative();
        narrative.status = this.status == null ? null : this.status.copy();
        narrative.div = this.div == null ? null : this.div.copy();
        return narrative;
    }

    protected Narrative typedCopy() {
        return this.copy();
    }

    public static class NarrativeStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("generated".equals(string)) {
                return NarrativeStatus.generated;
            }
            if ("extensions".equals(string)) {
                return NarrativeStatus.extensions;
            }
            if ("additional".equals(string)) {
                return NarrativeStatus.additional;
            }
            if ("empty".equals(string)) {
                return NarrativeStatus.empty;
            }
            throw new Exception("Unknown NarrativeStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == NarrativeStatus.generated) {
                return "generated";
            }
            if (enum_ == NarrativeStatus.extensions) {
                return "extensions";
            }
            if (enum_ == NarrativeStatus.additional) {
                return "additional";
            }
            if (enum_ == NarrativeStatus.empty) {
                return "empty";
            }
            return "?";
        }
    }

    public static enum NarrativeStatus {
        generated,
        extensions,
        additional,
        empty,
        Null;


        public static NarrativeStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("generated".equals(string)) {
                return generated;
            }
            if ("extensions".equals(string)) {
                return extensions;
            }
            if ("additional".equals(string)) {
                return additional;
            }
            if ("empty".equals(string)) {
                return empty;
            }
            throw new Exception("Unknown NarrativeStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case generated: {
                    return "generated";
                }
                case extensions: {
                    return "extensions";
                }
                case additional: {
                    return "additional";
                }
                case empty: {
                    return "empty";
                }
            }
            return "?";
        }
    }
}

