/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Range;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.Specimen;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;

public class Observation
extends Resource {
    protected CodeableConcept name;
    protected Type value;
    protected CodeableConcept interpretation;
    protected StringType comments;
    protected Type applies;
    protected InstantType issued;
    protected Enumeration<ObservationStatus> status;
    protected Enumeration<ObservationReliability> reliability;
    protected CodeableConcept bodySite;
    protected CodeableConcept method;
    protected Identifier identifier;
    protected ResourceReference subject;
    protected Resource subjectTarget;
    protected ResourceReference specimen;
    protected Specimen specimenTarget;
    protected List<ResourceReference> performer = new ArrayList<ResourceReference>();
    protected List<Resource> performerTarget = new ArrayList<Resource>();
    protected List<ObservationReferenceRangeComponent> referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
    protected List<ObservationRelatedComponent> related = new ArrayList<ObservationRelatedComponent>();
    private static final long serialVersionUID = -1854863907L;

    public Observation() {
    }

    public Observation(CodeableConcept codeableConcept, Enumeration<ObservationStatus> enumeration, Enumeration<ObservationReliability> enumeration2) {
        this.name = codeableConcept;
        this.status = enumeration;
        this.reliability = enumeration2;
    }

    public CodeableConcept getName() {
        return this.name;
    }

    public Observation setName(CodeableConcept codeableConcept) {
        this.name = codeableConcept;
        return this;
    }

    public Type getValue() {
        return this.value;
    }

    public Observation setValue(Type type) {
        this.value = type;
        return this;
    }

    public CodeableConcept getInterpretation() {
        return this.interpretation;
    }

    public Observation setInterpretation(CodeableConcept codeableConcept) {
        this.interpretation = codeableConcept;
        return this;
    }

    public StringType getComments() {
        return this.comments;
    }

    public Observation setComments(StringType stringType) {
        this.comments = stringType;
        return this;
    }

    public String getCommentsSimple() {
        return this.comments == null ? null : this.comments.getValue();
    }

    public Observation setCommentsSimple(String string) {
        if (string == null) {
            this.comments = null;
        } else {
            if (this.comments == null) {
                this.comments = new StringType();
            }
            this.comments.setValue(string);
        }
        return this;
    }

    public Type getApplies() {
        return this.applies;
    }

    public Observation setApplies(Type type) {
        this.applies = type;
        return this;
    }

    public InstantType getIssued() {
        return this.issued;
    }

    public Observation setIssued(InstantType instantType) {
        this.issued = instantType;
        return this;
    }

    public DateAndTime getIssuedSimple() {
        return this.issued == null ? null : this.issued.getValue();
    }

    public Observation setIssuedSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.issued = null;
        } else {
            if (this.issued == null) {
                this.issued = new InstantType();
            }
            this.issued.setValue(dateAndTime);
        }
        return this;
    }

    public Enumeration<ObservationStatus> getStatus() {
        return this.status;
    }

    public Observation setStatus(Enumeration<ObservationStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public ObservationStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public Observation setStatusSimple(ObservationStatus observationStatus) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(observationStatus);
        return this;
    }

    public Enumeration<ObservationReliability> getReliability() {
        return this.reliability;
    }

    public Observation setReliability(Enumeration<ObservationReliability> enumeration) {
        this.reliability = enumeration;
        return this;
    }

    public ObservationReliability getReliabilitySimple() {
        return this.reliability == null ? null : this.reliability.getValue();
    }

    public Observation setReliabilitySimple(ObservationReliability observationReliability) {
        if (this.reliability == null) {
            this.reliability = new Enumeration();
        }
        this.reliability.setValue(observationReliability);
        return this;
    }

    public CodeableConcept getBodySite() {
        return this.bodySite;
    }

    public Observation setBodySite(CodeableConcept codeableConcept) {
        this.bodySite = codeableConcept;
        return this;
    }

    public CodeableConcept getMethod() {
        return this.method;
    }

    public Observation setMethod(CodeableConcept codeableConcept) {
        this.method = codeableConcept;
        return this;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Observation setIdentifier(Identifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public Observation setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Observation setSubjectTarget(Resource resource) {
        this.subjectTarget = resource;
        return this;
    }

    public ResourceReference getSpecimen() {
        return this.specimen;
    }

    public Observation setSpecimen(ResourceReference resourceReference) {
        this.specimen = resourceReference;
        return this;
    }

    public Specimen getSpecimenTarget() {
        return this.specimenTarget;
    }

    public Observation setSpecimenTarget(Specimen specimen) {
        this.specimenTarget = specimen;
        return this;
    }

    public List<ResourceReference> getPerformer() {
        return this.performer;
    }

    public ResourceReference addPerformer() {
        ResourceReference resourceReference = new ResourceReference();
        this.performer.add(resourceReference);
        return resourceReference;
    }

    public List<Resource> getPerformerTarget() {
        return this.performerTarget;
    }

    public List<ObservationReferenceRangeComponent> getReferenceRange() {
        return this.referenceRange;
    }

    public ObservationReferenceRangeComponent addReferenceRange() {
        ObservationReferenceRangeComponent observationReferenceRangeComponent = new ObservationReferenceRangeComponent();
        this.referenceRange.add(observationReferenceRangeComponent);
        return observationReferenceRangeComponent;
    }

    public List<ObservationRelatedComponent> getRelated() {
        return this.related;
    }

    public ObservationRelatedComponent addRelated() {
        ObservationRelatedComponent observationRelatedComponent = new ObservationRelatedComponent();
        this.related.add(observationRelatedComponent);
        return observationRelatedComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("name", "CodeableConcept", "Describes what was observed. Sometimes this is called the observation 'code'.", 0, Integer.MAX_VALUE, this.name));
        list.add(new Property("value[x]", "Quantity|CodeableConcept|Attachment|Ratio|Period|SampledData|string", "The information determined as a result of making the observation, if the information has a simple value.", 0, Integer.MAX_VALUE, this.value));
        list.add(new Property("interpretation", "CodeableConcept", "The assessment made based on the result of the observation.", 0, Integer.MAX_VALUE, this.interpretation));
        list.add(new Property("comments", "string", "May include statements about significant, unexpected or unreliable values, or information about the source of the value where this may be relevant to the interpretation of the result.", 0, Integer.MAX_VALUE, this.comments));
        list.add(new Property("applies[x]", "dateTime|Period", "The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the 'physiologically relevant time'. This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.", 0, Integer.MAX_VALUE, this.applies));
        list.add(new Property("issued", "instant", "Date/Time this was made available.", 0, Integer.MAX_VALUE, this.issued));
        list.add(new Property("status", "code", "The status of the result value.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("reliability", "code", "An estimate of the degree to which quality issues have impacted on the value reported.", 0, Integer.MAX_VALUE, this.reliability));
        list.add(new Property("bodySite", "CodeableConcept", "Indicates where on the subject's body the observation was made.", 0, Integer.MAX_VALUE, this.bodySite));
        list.add(new Property("method", "CodeableConcept", "Indicates the mechanism used to perform the observation.", 0, Integer.MAX_VALUE, this.method));
        list.add(new Property("identifier", "Identifier", "A unique identifier for the simple observation.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("subject", "Resource(Patient|Group|Device|Location)", "The thing the observation is being made about.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("specimen", "Resource(Specimen)", "The specimen that was used when this observation was made.", 0, Integer.MAX_VALUE, this.specimen));
        list.add(new Property("performer", "Resource(Practitioner|Device|Organization)", "Who was responsible for asserting the observed value as 'true'.", 0, Integer.MAX_VALUE, this.performer));
        list.add(new Property("referenceRange", "", "Guidance on how to interpret the value by comparison to a normal or recommended range.", 0, Integer.MAX_VALUE, this.referenceRange));
        list.add(new Property("related", "", "Related observations - either components, or previous observations, or statements of derivation.", 0, Integer.MAX_VALUE, this.related));
    }

    public Observation copy() {
        Observation observation = new Observation();
        observation.name = this.name == null ? null : this.name.copy();
        observation.value = this.value == null ? null : this.value.copy();
        observation.interpretation = this.interpretation == null ? null : this.interpretation.copy();
        observation.comments = this.comments == null ? null : this.comments.copy();
        observation.applies = this.applies == null ? null : this.applies.copy();
        observation.issued = this.issued == null ? null : this.issued.copy();
        observation.status = this.status == null ? null : this.status.copy();
        observation.reliability = this.reliability == null ? null : this.reliability.copy();
        observation.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        observation.method = this.method == null ? null : this.method.copy();
        observation.identifier = this.identifier == null ? null : this.identifier.copy();
        observation.subject = this.subject == null ? null : this.subject.copy();
        observation.specimen = this.specimen == null ? null : this.specimen.copy();
        observation.performer = new ArrayList<ResourceReference>();
        for (ResourceReference element : this.performer) {
            observation.performer.add(element.copy());
        }
        observation.referenceRange = new ArrayList<ObservationReferenceRangeComponent>();
        for (ObservationReferenceRangeComponent observationReferenceRangeComponent : this.referenceRange) {
            observation.referenceRange.add(observationReferenceRangeComponent.copy());
        }
        observation.related = new ArrayList<ObservationRelatedComponent>();
        for (ObservationRelatedComponent observationRelatedComponent : this.related) {
            observation.related.add(observationRelatedComponent.copy());
        }
        return observation;
    }

    protected Observation typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Observation;
    }

    public static class ObservationRelatedComponent
    extends BackboneElement {
        protected Enumeration<ObservationRelationshiptypes> type;
        protected ResourceReference target;
        protected Observation targetTarget;
        private static final long serialVersionUID = -984646850L;

        public ObservationRelatedComponent() {
        }

        public ObservationRelatedComponent(ResourceReference resourceReference) {
            this.target = resourceReference;
        }

        public Enumeration<ObservationRelationshiptypes> getType() {
            return this.type;
        }

        public ObservationRelatedComponent setType(Enumeration<ObservationRelationshiptypes> enumeration) {
            this.type = enumeration;
            return this;
        }

        public ObservationRelationshiptypes getTypeSimple() {
            return this.type == null ? null : this.type.getValue();
        }

        public ObservationRelatedComponent setTypeSimple(ObservationRelationshiptypes observationRelationshiptypes) {
            if (observationRelationshiptypes == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration();
                }
                this.type.setValue(observationRelationshiptypes);
            }
            return this;
        }

        public ResourceReference getTarget() {
            return this.target;
        }

        public ObservationRelatedComponent setTarget(ResourceReference resourceReference) {
            this.target = resourceReference;
            return this;
        }

        public Observation getTargetTarget() {
            return this.targetTarget;
        }

        public ObservationRelatedComponent setTargetTarget(Observation observation) {
            this.targetTarget = observation;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("type", "code", "A code specifying the kind of relationship that exists with the target observation.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("target", "Resource(Observation)", "A reference to the observation that is related to this observation.", 0, Integer.MAX_VALUE, this.target));
        }

        public ObservationRelatedComponent copy() {
            ObservationRelatedComponent observationRelatedComponent = new ObservationRelatedComponent();
            observationRelatedComponent.type = this.type == null ? null : this.type.copy();
            observationRelatedComponent.target = this.target == null ? null : this.target.copy();
            return observationRelatedComponent;
        }
    }

    public static class ObservationReferenceRangeComponent
    extends BackboneElement {
        protected Quantity low;
        protected Quantity high;
        protected CodeableConcept meaning;
        protected Range age;
        private static final long serialVersionUID = -1022858860L;

        public Quantity getLow() {
            return this.low;
        }

        public ObservationReferenceRangeComponent setLow(Quantity quantity) {
            this.low = quantity;
            return this;
        }

        public Quantity getHigh() {
            return this.high;
        }

        public ObservationReferenceRangeComponent setHigh(Quantity quantity) {
            this.high = quantity;
            return this;
        }

        public CodeableConcept getMeaning() {
            return this.meaning;
        }

        public ObservationReferenceRangeComponent setMeaning(CodeableConcept codeableConcept) {
            this.meaning = codeableConcept;
            return this;
        }

        public Range getAge() {
            return this.age;
        }

        public ObservationReferenceRangeComponent setAge(Range range) {
            this.age = range;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("low", "Quantity", "The value of the low bound of the reference range. If this is omitted, the low bound of the reference range is assumed to be meaningless. E.g. <2.3.", 0, Integer.MAX_VALUE, this.low));
            list.add(new Property("high", "Quantity", "The value of the high bound of the reference range. If this is omitted, the high bound of the reference range is assumed to be meaningless. E.g. >5.", 0, Integer.MAX_VALUE, this.high));
            list.add(new Property("meaning", "CodeableConcept", "Code for the meaning of the reference range.", 0, Integer.MAX_VALUE, this.meaning));
            list.add(new Property("age", "Range", "The age at which this reference range is applicable. This is a neonatal age (e.g. number of weeks at term) if the meaning says so.", 0, Integer.MAX_VALUE, this.age));
        }

        public ObservationReferenceRangeComponent copy() {
            ObservationReferenceRangeComponent observationReferenceRangeComponent = new ObservationReferenceRangeComponent();
            observationReferenceRangeComponent.low = this.low == null ? null : this.low.copy();
            observationReferenceRangeComponent.high = this.high == null ? null : this.high.copy();
            observationReferenceRangeComponent.meaning = this.meaning == null ? null : this.meaning.copy();
            observationReferenceRangeComponent.age = this.age == null ? null : this.age.copy();
            return observationReferenceRangeComponent;
        }
    }

    public static class ObservationRelationshiptypesEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("has-component".equals(string)) {
                return ObservationRelationshiptypes.hascomponent;
            }
            if ("has-member".equals(string)) {
                return ObservationRelationshiptypes.hasmember;
            }
            if ("derived-from".equals(string)) {
                return ObservationRelationshiptypes.derivedfrom;
            }
            if ("sequel-to".equals(string)) {
                return ObservationRelationshiptypes.sequelto;
            }
            if ("replaces".equals(string)) {
                return ObservationRelationshiptypes.replaces;
            }
            if ("qualified-by".equals(string)) {
                return ObservationRelationshiptypes.qualifiedby;
            }
            if ("interfered-by".equals(string)) {
                return ObservationRelationshiptypes.interferedby;
            }
            throw new Exception("Unknown ObservationRelationshiptypes code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ObservationRelationshiptypes.hascomponent) {
                return "has-component";
            }
            if (enum_ == ObservationRelationshiptypes.hasmember) {
                return "has-member";
            }
            if (enum_ == ObservationRelationshiptypes.derivedfrom) {
                return "derived-from";
            }
            if (enum_ == ObservationRelationshiptypes.sequelto) {
                return "sequel-to";
            }
            if (enum_ == ObservationRelationshiptypes.replaces) {
                return "replaces";
            }
            if (enum_ == ObservationRelationshiptypes.qualifiedby) {
                return "qualified-by";
            }
            if (enum_ == ObservationRelationshiptypes.interferedby) {
                return "interfered-by";
            }
            return "?";
        }
    }

    public static enum ObservationRelationshiptypes {
        hascomponent,
        hasmember,
        derivedfrom,
        sequelto,
        replaces,
        qualifiedby,
        interferedby,
        Null;


        public static ObservationRelationshiptypes fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("has-component".equals(string)) {
                return hascomponent;
            }
            if ("has-member".equals(string)) {
                return hasmember;
            }
            if ("derived-from".equals(string)) {
                return derivedfrom;
            }
            if ("sequel-to".equals(string)) {
                return sequelto;
            }
            if ("replaces".equals(string)) {
                return replaces;
            }
            if ("qualified-by".equals(string)) {
                return qualifiedby;
            }
            if ("interfered-by".equals(string)) {
                return interferedby;
            }
            throw new Exception("Unknown ObservationRelationshiptypes code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case hascomponent: {
                    return "has-component";
                }
                case hasmember: {
                    return "has-member";
                }
                case derivedfrom: {
                    return "derived-from";
                }
                case sequelto: {
                    return "sequel-to";
                }
                case replaces: {
                    return "replaces";
                }
                case qualifiedby: {
                    return "qualified-by";
                }
                case interferedby: {
                    return "interfered-by";
                }
            }
            return "?";
        }
    }

    public static class ObservationReliabilityEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("ok".equals(string)) {
                return ObservationReliability.ok;
            }
            if ("ongoing".equals(string)) {
                return ObservationReliability.ongoing;
            }
            if ("early".equals(string)) {
                return ObservationReliability.early;
            }
            if ("questionable".equals(string)) {
                return ObservationReliability.questionable;
            }
            if ("calibrating".equals(string)) {
                return ObservationReliability.calibrating;
            }
            if ("error".equals(string)) {
                return ObservationReliability.error;
            }
            if ("unknown".equals(string)) {
                return ObservationReliability.unknown;
            }
            throw new Exception("Unknown ObservationReliability code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ObservationReliability.ok) {
                return "ok";
            }
            if (enum_ == ObservationReliability.ongoing) {
                return "ongoing";
            }
            if (enum_ == ObservationReliability.early) {
                return "early";
            }
            if (enum_ == ObservationReliability.questionable) {
                return "questionable";
            }
            if (enum_ == ObservationReliability.calibrating) {
                return "calibrating";
            }
            if (enum_ == ObservationReliability.error) {
                return "error";
            }
            if (enum_ == ObservationReliability.unknown) {
                return "unknown";
            }
            return "?";
        }
    }

    public static enum ObservationReliability {
        ok,
        ongoing,
        early,
        questionable,
        calibrating,
        error,
        unknown,
        Null;


        public static ObservationReliability fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("ok".equals(string)) {
                return ok;
            }
            if ("ongoing".equals(string)) {
                return ongoing;
            }
            if ("early".equals(string)) {
                return early;
            }
            if ("questionable".equals(string)) {
                return questionable;
            }
            if ("calibrating".equals(string)) {
                return calibrating;
            }
            if ("error".equals(string)) {
                return error;
            }
            if ("unknown".equals(string)) {
                return unknown;
            }
            throw new Exception("Unknown ObservationReliability code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case ok: {
                    return "ok";
                }
                case ongoing: {
                    return "ongoing";
                }
                case early: {
                    return "early";
                }
                case questionable: {
                    return "questionable";
                }
                case calibrating: {
                    return "calibrating";
                }
                case error: {
                    return "error";
                }
                case unknown: {
                    return "unknown";
                }
            }
            return "?";
        }
    }

    public static class ObservationStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("registered".equals(string)) {
                return ObservationStatus.registered;
            }
            if ("preliminary".equals(string)) {
                return ObservationStatus.preliminary;
            }
            if ("final".equals(string)) {
                return ObservationStatus.final_;
            }
            if ("amended".equals(string)) {
                return ObservationStatus.amended;
            }
            if ("cancelled".equals(string)) {
                return ObservationStatus.cancelled;
            }
            if ("entered in error".equals(string)) {
                return ObservationStatus.enteredInError;
            }
            throw new Exception("Unknown ObservationStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ObservationStatus.registered) {
                return "registered";
            }
            if (enum_ == ObservationStatus.preliminary) {
                return "preliminary";
            }
            if (enum_ == ObservationStatus.final_) {
                return "final";
            }
            if (enum_ == ObservationStatus.amended) {
                return "amended";
            }
            if (enum_ == ObservationStatus.cancelled) {
                return "cancelled";
            }
            if (enum_ == ObservationStatus.enteredInError) {
                return "entered in error";
            }
            return "?";
        }
    }

    public static enum ObservationStatus {
        registered,
        preliminary,
        final_,
        amended,
        cancelled,
        enteredInError,
        Null;


        public static ObservationStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("registered".equals(string)) {
                return registered;
            }
            if ("preliminary".equals(string)) {
                return preliminary;
            }
            if ("final".equals(string)) {
                return final_;
            }
            if ("amended".equals(string)) {
                return amended;
            }
            if ("cancelled".equals(string)) {
                return cancelled;
            }
            if ("entered in error".equals(string)) {
                return enteredInError;
            }
            throw new Exception("Unknown ObservationStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case registered: {
                    return "registered";
                }
                case preliminary: {
                    return "preliminary";
                }
                case final_: {
                    return "final";
                }
                case amended: {
                    return "amended";
                }
                case cancelled: {
                    return "cancelled";
                }
                case enteredInError: {
                    return "entered in error";
                }
            }
            return "?";
        }
    }
}

